/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/hlm_ex/arbit.v#1 $
*/

APPS.MultiWindowApp Arbitrary_Slicer<NEdisplayMode="maximized",
                                     NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      demo_text = "This example shows the use of the Arbitrary_Slicer macro. This macro uses the low level module DVslice to allow the creation of an arbitrarily postioned slice plane. You can select the slice using <CTRL>LMB and then rotate it in the viewer.";
      helpfile = "examples/examples_help.htm";
   };

   GDM.Uviewer3D Uviewer3D {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.bounds.out_obj,<-.<-.<-.Arbitrary_Slicer.out_obj_slice};
            Xform {
               mat = {
                  0.328132,-0.0119674,0.0574246,0.,-0.00319031,0.322198,0.0853769,
0.,-0.0585716,-0.0845942,0.317056,0.,0.,0.,0.,1.
               };
               xlate = {-4.,-4.,-5.16667};
            };
         };
         View {
            View {
               trigger = 1;
            };
         };
      };
   };
   MODS.Read_Field Read_Field {
      read_field_ui {
         filename = "$XP_PATH<0>/data/field/wind.fld";
      };
   };
   MODS.bounds bounds {
      in_field => <-.Read_Field.field;
   };
   HLM.Arbitrary_Slicer Arbitrary_Slicer {
      in_field => <-.Read_Field.field;
      plane {
         xform {
            mat = {
               0.861718,0.,0.507388,0.,-0.326617,0.765259,0.554708,0.,-0.388283,
-0.643723,0.659437,0.,0.,0.,0.,1.
            };
         };
      };
      SliceUI {
         UIoptionBoxLabel {
            label_cmd {
               cmd[] = {
                  {
                     active=1
                  },
                  {
                     active=1
                  },
                  {
                     active=1
                  }};
            };
         };
         plane_xform {
            GDxform_editor {
               x_rot = 40.07;
               y_rot = -30.49;
               z_rot = -0.;
               abs_y_rot = -30.48999977;
               abs_z_rot = -0.5899999738;
               abs_x_rot = 40.06999969;
            };
            XformEditorUI {
               trans_shell {
                  x = 412;
                  y = 264;
                  ok = 1;
               };
            };
         };
      };
   };
};
