/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/hlm_ex/outputim.v#1 $
*/

APPS.MultiWindowApp OutputImage<NEdisplayMode="maximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      demo_text = "The OutputImage macro connects to a viewer and saves the contents of the viewer to an image file.  The OutputImage UI allows output of a variety of common image formats including avs .x, gif, jpg, pbm and tiff formats.  Use the Modules menu, above, to switch to the OutputImage UI panel";
      helpfile = "examples/examples_help.htm";
   };

   GDM.Uviewer3D Uviewer3D {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.bounds.out_obj,<-.<-.<-.Orthogonal_Slicer.boundary,
               <-.<-.<-.isoline.out_obj};
            Xform {
               mat = {
                  0.186921,-0.0222747,0.106747,0.,-0.00575791,0.209529,0.0538049,
0.,-0.108894,-0.0493149,0.18039,0.,0.,0.,0.,1.
               };
               xlate = {-4.,-4.,-5.16667};
            };
         };
         View {
            View {
               trigger = 1;
            };
            ViewUI {
               ViewPanel {
                  UI {
                     panel {
                        defaultX = 173;
                        defaultY = 330;
                     };
                  };
               };
            };
         };
      };
   };
   HLM.Orthogonal_Slicer Orthogonal_Slicer {
      Orthogonal_slicer_UI<instanced=0>;
      OrthoSliceParam {
         plane = 9;
      };
      in_field => <-.Read_Field.field;
   };
   MODS.Read_Field Read_Field {
      read_field_ui {
         file_browser {
            dirMaskCache = "$XP_PATH<0>/data/field/*.fld";
         };
         filename = "$XP_PATH<0>/data/field/wind.fld";
      };
      DVread_field {
         Mesh_Unif+Node_Data Output_Field;
      };
   };
   MODS.bounds bounds {
      in_field => <-.Read_Field.field;
   };
   MODS.isoline isoline {
      in_field => <-.Orthogonal_Slicer.out_fld;
   };
   HLM.OutputImage OutputImage {
      view_in => <-.Uviewer3D.Scene_Selector.curr_view;
   };
};
