/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/hlm_ex/particle.v#1 $
*/

APPS.MultiWindowApp Particle_Advector<NEdisplayMode="maximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=20.,NEy=20> {
      demo_text = "This example shows the use of the high level Particle_Advector macro. This uses the advector macro and includes its own subset of geometries for the probe points and glyphs.";
      helpfile = "examples/examples_help.htm";
   };

   GDM.Uviewer3D Uviewer3D {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.bounds.out_obj,
               <-.<-.<-.Particle_Advector.out_probe_obj,
               <-.<-.<-.Particle_Advector.out_stream_obj,
               <-.<-.<-.Particle_Advector.out_glyph_obj};
            Xform {
               mat = {
                  0.107904,-0.0750392,0.158177,0.,-0.041471,0.169563,0.108731,
0.,-0.170091,-0.0889462,0.073835,0.,0.,0.,0.,1.
               };
               xlate = {-4.,-4.,-5.13055};
            };
         };
         View {
            View {
               trigger = 1;
            };
            ViewUI {
               ViewPanel {
                  UI {
                     panel {
                        defaultX = 210;
                        defaultY = 347;
                     };
                  };
               };
            };
         };
      };
   };
   MODS.Read_Field Read_Field {
      read_field_ui {
         filename = "$XP_PATH<0>/data/field/wind.fld";
      };
      DVread_field {
         Mesh_Unif+Node_Data Output_Field;
      };
   };
   MODS.bounds bounds {
      in_field => <-.Read_Field.field;
   };
   HLM.Particle_Advector Particle_Advector {
      advector {
         AdvectParam {
            scale = 0.06;
         };
      };
      particle_probes {
         FPlane {
            plane {
               xform {
                  mat = {
                     0.438685,0.,0.898641,0.,0.,1.,0.,0.,-0.898641,0.,0.438685,
0.,0.,0.,0.,1.
                  };
               };
            };
         };
         probe_ui {
            probe_edit {
               GDxform_editor {
                  y_rot = -63.98;
                  abs_y_rot = -63.97999954;
                  abs_x_rot = -4.179999828;
               };
               XformEditorUI {
                  trans_shell {
                     x = 676;
                     y = 235;
                  };
               };
            };
         };
         dim1 = 10;
         dim2 = 10;
      };
      in_field => <-.combine_vect.out_fld;
   };
   MODS.combine_vect combine_vect {
      in_field => <-.Read_Field.field;
   };
};
