/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/hlm_ex/probe.v#1 $
*/

APPS.MultiWindowApp Probe<NEdisplayMode="maximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      demo_text = "Probe demonstrates the use of the high level Probe macro. Use the <CTRL>LMB combination to make a selection on the orthoslice in the viewer.";
      helpfile = "examples/examples_help.htm";
   };

   GDM.Uviewer3D Uviewer3D {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.bounds.out_obj,<-.<-.<-.Probe.out_obj,
               <-.<-.<-.Probe.out_title,<-.<-.<-.orthoslice.out_obj};
            Xform {
               mat = {
                  0.111694,0.0730391,-0.130075,0.,0.0340305,-0.170685,-0.0666207,
0.,-0.145246,0.0161764,-0.115637,0.,0.,0.,0.,1.
               };
               xlate = {-4.,-4.,-5.16667};
            };
         };
         Lights {
            Lights = {
               {
                  type="BiDirectional"
               },,,};
         };
         View {
            View {
               trigger = 1;
            };
            ViewUI {
               ViewPanel {
                  UI {
                     panel {
                        defaultX = 123;
                        defaultY = 417;
                     };
                  };
               };
            };
         };
      };
   };
   HLM.Probe Probe {
      in_field => <-.Read_Field.field;
      in_pick => <-.Uviewer3D.Scene_Editor.View_Editor.GDobj_sel.cur_obj;
      ProbeParam {
         scale = 1.84;
      };
      Probe_Type = 1;
   };
   MODS.Read_Field Read_Field {
      read_field_ui {
         file_browser {
            dirMaskCache = "$XP_PATH<0>/data/field/*.fld";
         };
         filename = "$XP_PATH<0>/data/field/wind.fld";
      };
      DVread_field {
         Mesh_Unif+Node_Data Output_Field;
      };
   };
   MODS.bounds bounds {
      in_field => <-.Read_Field.field;
   };
   MODS.orthoslice orthoslice {
      in_field => <-.Read_Field.field;
   };
};
