/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/hlm_ex/stream.v#1 $
*/

APPS.MultiWindowApp Streamline<NEdisplayMode="maximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel<NEx=20.,NEy=20> {
      demo_text = "This example shows how the Streamline macro can be used. This is just a higher level macro which encapsulates the streamlines macro. Note that you can select and move the sampling grid by using <CTRL>LMB to select it in the viewer and then rotating it.";
      helpfile = "examples/examples_help.htm";
   };

   GDM.Uviewer3D Uviewer3D {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.bounds.out_obj,<-.<-.<-.Streamline.out_stream_obj,
               <-.<-.<-.Streamline.out_probe_obj};
            Xform {
               mat = {
                  0.0935042,-0.0650254,0.137069,0.,-0.0359368,0.146936,0.0942212,
0.,-0.147393,-0.0770765,0.0639819,0.,0.,0.,0.,1.
               };
               xlate = {-4.14057,-4.17451,-5.12725};
            };
         };
         Lights {
            Lights = {
               {
                  type="BiDirectional"
               },,,};
         };
         View {
            View {
               trigger = 1;
            };
            ViewUI {
               ViewPanel {
                  UI {
                     panel {
                        defaultX = 274;
                        defaultY = 445;
                     };
                  };
               };
            };
         };
      };
   };
   MODS.Read_Field Read_Field {
      read_field_ui {
         filename = "$XP_PATH<0>/data/field/wind.fld";
      };
      DVread_field {
         Mesh_Unif+Node_Data Output_Field;
      };
   };
   MODS.bounds bounds {
      in_field => <-.Read_Field.field;
   };
   MODS.combine_vect combine_vect {
      in_field => <-.Read_Field.field;
   };
   HLM.Streamline Streamline {
      streamlines {
         StreamParam {
            ribbons = 1;
            rib_width = 1.17;
         };
      };
      streamlines_probes {
         probe_ui {
            probe_edit {
               GDxform_editor {
                  y_rot = -67.36;
                  abs_y_rot = -67.36000061;
               };
               XformEditorUI {
                  trans_shell {
                     x = 9;
                     y = 220;
                     width = 511;
                     height = 450;
                  };
               };
            };
         };
         start_point = 2;
         FPlane {
            plane {
               xform {
                  mat = {
                     0.38494,0.,0.922942,0.,0.,1.,0.,0.,-0.922942,0.,0.38494,
0.,0.,0.,0.,1.
                  };
               };
            };
         };
         dim1 = 10;
         dim2 = 10;
      };
      in_field => <-.combine_vect.out_fld;
   };
};
