/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/hlm_ex/vector.v#1 $
*/

APPS.MultiWindowApp Vector<NEdisplayMode="maximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      demo_text = "Vector shows how to integrate the Vector macro in a visualization. This is a useful macro for quickly creating vector representations. It is a wrapper on the glyph macro.";
      helpfile = "examples/examples_help.htm";
   };

   GDM.Uviewer3D Uviewer3D {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.bounds.out_obj,<-.<-.<-.Vector.out_obj};
            Xform {
               mat = {
                  0.111694,0.073039,-0.130075,0.,0.0340304,-0.170685,-0.0666206,
0.,-0.145246,0.0161764,-0.115637,0.,0.,0.,0.,1.
               };
               xlate = {0.502618,0.921015,4.15271};
            };
         };
         Lights {
            Lights = {
               {
                  type="BiDirectional"
               },,,};
         };
         View {
            View {
               trigger = 1;
            };
            ViewUI {
               ViewPanel {
                  UI {
                     panel {
                        defaultX = 300;
                        defaultY = 200;
                     };
                  };
               };
            };
         };
      };
   };
   MODS.Read_Field Read_Field {
      read_field_ui {
         filename = "$XP_PATH<0>/data/field/wind.fld";
      };
   };
   MODS.bounds bounds {
      in_field => <-.Read_Field.field;
   };
   MODS.combine_vect combine_vect {
      in_field => <-.Read_Field.field;
   };
   MODS.orthoslice orthoslice {
      in_field => <-.combine_vect.out_fld;
   };
   HLM.Vector Vector {
      in_field => <-.orthoslice.out_fld;
   };
};
