/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/ip_examp/extrema.v#1 $
*/

APPS.MultiWindowApp IPextrema<NEdisplayMode="maximized",NEhelpFile="examples/examples_help.htm"> {

UIsummaryPanel Summary_Panel {
   demo_text = "This example demonstrates the extrema module ascertaining the min and max data values in an image.\n\nHere you can manually alter the parameters via the threshold module and see the results in the extrema UI Panel.";
   helpfile = "examples/examples_help.htm";
};

MODS.Readers.Read_Image Read_Image<NEx=594.,NEy=22.> {
   read_image_ui {
      filename = "$XP_PATH<0>/data/image/mandrill.x";
   };
};
MODS.Filters.extract_scalar extract_scalar<NEx=594.,NEy=88.> {
   in_field => <-.Read_Image.field;
   ExtractScalarParam {
      component = 3;
   };
};
Interface.IPfldToImage IPfldToImage<NEx=561.,NEy=176.> {
   In => <-.extract_scalar.out_fld;
};
IP.Macros.IPthreshold IPthreshold<NEx=660.,NEy=264.> {
   in_image => <-.IPfldToImage.Image;
   LowUI {
      y = 84;
   };
   HighUI {
      y = 24;
   };
   InvUI {
      y = 0;
   };
};
Interface.IPfldToROI IPfldToROI<NEx=594.,NEy=330.> {
   In => IPthreshold.Cvt.TmpField;
};
IP.Macros.IPextrema IPextrema<NEx=550.,NEy=407.> {
   Min {
      FieldPanel {
         y = 70;
      };
   };
   Max {
      FieldPanel {
         y = 0;
      };
   };
   work_func {
      src => <-.<-.IPfldToImage.Image;
      roi => <-.<-.IPfldToROI.ROI.Roi;
   };
};
GDM.Uviewer2D Uviewer2D<NEx=671.,NEy=484.> {
   Scene {
      Top {
      child_objs => {
         IPthreshold.Cvt.dataObject.obj};
      };
   };
};

};
