/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/ip_examp/logic.v#1 $
*/

APPS.MultiWindowApp IPlogical<NEdisplayMode="maximized",NEhelpFile="examples/examples_help.htm"> {

UIsummaryPanel Summary_Panel {
   demo_text = "This example demonstrates how you can undertake logic operations on an image.";
   helpfile = "examples/examples_help.htm";
};

MODS.Readers.Read_Image Read_Image<NEx=517.,NEy=11.> {
   read_image_ui {
      filename = "$XP_PATH<0>/data/image/mandrill.x";
   };
};
MODS.Filters.extract_scalar extract_scalar<NEx=517.,NEy=55.> {
   in_field => <-.Read_Image.field;
   ExtractScalarParam {
      component = 3;
   };
};
Interface.IPfldToImage IPfldToImage<NEx=396.,NEy=110.> {
   In => <-.extract_scalar.out_fld;
};
IP.Macros.IPthreshold IPthreshold<NEx=594.,NEy=154.> {
   in_image => <-.IPfldToImage.Image;
   LowUI {
      y = 84;
      value = 116.73;
   };
   HighUI {
      y = 24;
   };
   InvUI {
      y = 0;
   };
};
Interface.IPfldToROI IPfldToROI<NEx=693.,NEy=209.> {
   In => <-.IPthreshold.Cvt.TmpField;
};
IP.Macros.IPand IPand<NEx=275.,NEy=253.> {
   in_image1 => <-.IPfldToImage.Image;
   in_image2 => <-.IPthreshold.work_func.dst;
};
IP.Macros.IPand_const IPand_const<NEx=308.,NEy=297.> {
   in_image => <-.IPand.work_func.dst;
   Const {
      Field {
	 value = 63.0;
      };
      FieldPanel {
         y = 0;
      };
   };
};
IP.Macros.IPnand IPnand<NEx=352.,NEy=352.> {
   in_image1 => <-.IPand_const.work_func.dst;
   in_image2 => <-.IPfldToImage.Image;
   in_roi => <-.IPfldToROI.ROI.Roi;
};
IP.Macros.IPnor IPnor<NEx=396.,NEy=396.> {
   in_image1 => <-.IPnand.work_func.dst;
   in_image2 => <-.IPfldToImage.Image;
};
IP.Macros.IPnot IPnot<NEx=440.,NEy=440.> {
   in_image => <-.IPnor.work_func.dst;
};
IP.Macros.IPor IPor<NEx=539.,NEy=253.> {
   in_image1 => <-.IPnot.work_func.dst;
   in_image2 => <-.IPfldToImage.Image;
};
IP.Macros.IPor_const IPor_const<NEx=561.,NEy=308.> {
   in_image => <-.IPor.work_func.dst;
   Const {
      Field {
	 value = 31.0;
      };
      FieldPanel {
         y = 0;
      };
   };
};
IP.Macros.IPshift IPshift<NEx=605.,NEy=352.> {
   in_image => <-.IPor_const.work_func.dst;
   Const {
      y = 0;
      value = 1;
   };
};
IP.Macros.IPxor IPxor<NEx=649.,NEy=396.> {
   in_image1 => <-.IPshift.work_func.dst;
   in_image2 => <-.IPfldToImage.Image;
};
IP.Macros.IPxor_const IPxor_const<NEx=682.,NEy=451.> {
   in_image => <-.IPxor.work_func.dst;
   Const {
      Field {
	 value = 66.0;
      };
      FieldPanel {
         y = 0;
      };
   };
   in_roi => <-.IPfldToROI.ROI.Roi;
};
GDM.Uviewer2D Uviewer2D<NEx=671.,NEy=484.> {
   Scene {
      Top {
         child_objs => {
            IPxor_const.Cvt.dataObject.obj};
      };
   };
};

};
