/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/ip_pkg.v#1 $
*/

flibrary+global IP_PKG <
   build_dir="ip_lib",
   build_cmd="$(MAKE)",
   hdr_code="int ip_Image_init (void);",
   init_code="   ip_Image_init();",
   disabled => Templates.CONFIG.ip_kit_disabled
> {

/*
 * Low level ip objects
 */
flibrary+global+buffered IPlib<
   build_dir="ip_lib",
   c_hdr_files= "ip.h ip/device.h inter/ip_inter.h",
   link_files="-lip",
   out_src_file="inter/ip_gen.c",
   out_hdr_file="inter/ip_gen.h">
{
    group ip_Typed_Image {
	int+write+req			&xsize;
	int+write+req			&ysize;
	int				nbands;
	int+read+req			&data_type;
	prim+nonotify			data<unmanaged=1>[xsize*ysize][1];
	prim+nres+nonotify		&data_ptr<cptr=1>[xsize*ysize][1]=>data;
	method_upd			Type_update = "ip_Typed_Image_Func";
    };

    ip_Typed_Image ip_Image<struct_name	   = "ip_Image_Struct",
			    struct_bitmask = "ip_Image_Bitmask",
			    NEnumColors=4, NEcolor0=0xffffff, NEcolor1=0xff0000,
			    NEcolor2=0xff0000, NEcolor3=0x00000000> {
	xsize+nowrite+read-write;
	ysize+nowrite+read-write;
	nbands+write+req = 1;
	cmethod+notify_val+notify_inst	Image_update<status=1> = "ip_Image_Func";
	cmethod+notify_del		Image_del    = "ip_Image_Del";
    };

    group ip_Roi<struct_name	= "ip_Roi",
		 struct_bitmask = "ip_Roi_Bitmask",
		 NEnumColors=2, NEcolor0=0xffffff, NEcolor1=0xff0000,
		 NEcolor2=0x00ff00, NEcolor3 = 0x00ff00> {
	int				type = 1;	/* must have one var */
    };

    group ip_Mtable<struct_name    = "ip_Mtable_Struct",
		    struct_bitmask = "ip_Mtable_Bitmask"> {
	string+Iparam			&FileName;
	cmethod+notify_val+notify_inst	Mtable_update<status=1> = "ip_Mtable_Update";
	cmethod+notify_del		Mtable_del    = "ip_Mtable_Del";
    };

    group ip_Sel<struct_name	= "ip_Sel_Struct",
		 struct_bitmask = "ip_Sel_Bitmask"> {
	string+Iparam			&FileName;
	cmethod+notify_val+notify_inst	Sel_update<status=1> = "ip_Sel_Update";
	cmethod+notify_del		Sel_del    = "ip_Sel_Del";
    };

    group ip_Kernel<struct_name	= "ip_Kernel_Struct",
		 struct_bitmask = "ip_Kernel_Bitmask"> {
	string+Iparam			&FileName;
	cmethod+notify_val+notify_inst	Kernel_update<status=1> = "ip_Kernel_Update";
	cmethod+notify_del		Kernel_del    = "ip_Kernel_Del";
    };

    group ip_Data_Names {
        int nnames;
        string names[nnames];
	string file;
        method+notify_inst		Data_create<status=1> = "ip_Data_Names";
    };
};

/*
 * Base IP types
 *	These are the package elements that should be instanced.
 */
flibrary+global+buffered IPbase {
    Mesh_Unif+Node_Data_Struct+Dim2+Space2+Scalar IPfld;

    group ip_Byte    <NEcolor3=0xff0000> { int+read+req data_type = 0; };
    group ip_Short   <NEcolor3=0xffff00> { int+read+req data_type = 1; };
    group ip_Int     <NEcolor3=0x00ff00> { int+read+req data_type = 2; };
    group ip_Float   <NEcolor3=0x00ffff> { int+read+req data_type = 3; };
    group ip_Double  <NEcolor3=0x0000ff> { int+read+req data_type = 4; };
    group ip_Complex <NEcolor3=0xff00ff> { int+read+req data_type = 5; };

    IPlib.ip_Image	    ip_Image;
    ip_Image+ip_Byte	    ip_ImageByte;
    ip_Image+ip_Short	    ip_ImageShort;
    ip_Image+ip_Int	    ip_ImageInt;
    ip_Image+ip_Float	    ip_ImageFloat;
    ip_Image+ip_Double	    ip_ImageDouble;
    ip_Image+ip_Complex	    ip_ImageComplex;

    IPlib.ip_Image+Iparam	    ip_Image_In {
	xsize+nowrite+read;
	ysize+nowrite+read;
	nbands+nowrite+read-write;
	data_ptr+read-nonotify+notify+req;
    };
    ip_Image_In+ip_Byte		    ip_Image_InByte;
    ip_Image_In+ip_Short	    ip_Image_InShort;
    ip_Image_In+ip_Int		    ip_Image_InInt;
    ip_Image_In+ip_Float	    ip_Image_InFloat;
    ip_Image_In+ip_Double	    ip_Image_InDouble;
    ip_Image_In+ip_Complex	    ip_Image_InComplex;

    IPlib.ip_Image+read+req+nonotify	ip_Image_Out<NEportLevels={2,0},
						     modified=1> {
	xsize+nowrite+read;
	ysize+nowrite+read;
	nbands+nowrite+read-write;
	data_ptr+write+nonotify-notify<modified=1>;
    };
    ip_Image_Out+ip_Byte	    ip_Image_OutByte;
    ip_Image_Out+ip_Short	    ip_Image_OutShort;
    ip_Image_Out+ip_Int		    ip_Image_OutInt;
    ip_Image_Out+ip_Float	    ip_Image_OutFloat;
    ip_Image_Out+ip_Double	    ip_Image_OutDouble;
    ip_Image_Out+ip_Complex	    ip_Image_OutComplex;

    IPlib.ip_Roi		    ip_Roi;
    IPlib.ip_Roi+IPort2+read	    ip_Roi_In;
    IPlib.ip_Roi+Oparam		    ip_Roi_Out;

    IPlib.ip_Mtable		    ip_Mtable;
    IPlib.ip_Sel		    ip_Sel;
    IPlib.ip_Kernel		    ip_Kernel;
};

/*
 * Converters objects for low-level ip objects
 */
IPlib {
    group ip_Roi_conv<struct_name	= "ip_Roi_conv_Struct",
		      struct_bitmask	= "ip_Roi_conv_Bitmask"> {
	ip_Image_InByte			&In<cptr=1>;
	ip_Roi_Out			Roi<cptr=1>;
	cmethod+notify_val+notify_inst	Roi_update<status=1> = "ip_Roi_conv_Func";
	cmethod+notify_del		Roi_del    = "ip_Roi_conv_Del";
    };
};

IPbase {
    IPlib.ip_Roi_conv		    ip_Roi_conv;

    group ip_1i {
	IPbase.ip_Image_In		&src<cptr=1>;
    };

    group ip_1i1o {
	IPbase.ip_Image_In		&src<cptr=1>;
	IPbase.ip_Image_Out		dst<cptr=1> {
	    xsize => <-.src.xsize;
	    ysize => <-.src.ysize;
	    data_type => <-.src.data_type;
	};
    };

    group ip_1i1ob {
	IPbase.ip_Image_In		&src<cptr=1>;
	IPbase.ip_Image_Out		dst<cptr=1> {
	    xsize => <-.src.xsize;
	    ysize => <-.src.ysize;
	    data_type = 0;
	};
    };

    group ip_f1i1o {
	IPbase.ip_Image_InFloat		&src<cptr=1>;
	IPbase.ip_Image_OutFloat	dst<cptr=1> {
	    xsize => <-.src.xsize;
	    ysize => <-.src.ysize;
	};
    };

    group ip_f1i2o {
	IPbase.ip_Image_InFloat		&src<cptr=1>;
	IPbase.ip_Image_OutFloat	dst1<cptr=1> {
	    xsize => <-.src.xsize;
	    ysize => <-.src.ysize;
	};
	IPbase.ip_Image_OutFloat	dst2<cptr=1> {
	    xsize => <-.src.xsize;
	    ysize => <-.src.ysize;
	};
    };

    group ip_2i {
	IPbase.ip_Image_In		&src1<cptr=1>;
	IPbase.ip_Image_In		&src2<cptr=1>;
    };

    group ip_2i1o {
	IPbase.ip_Image_In		&src1<cptr=1>;
	IPbase.ip_Image_In		&src2<cptr=1>;
	IPbase.ip_Image_Out		dst<cptr=1> {
	    xsize => <-.src1.xsize;
	    ysize => <-.src1.ysize;
	    data_type => <-.src1.data_type;
	};
    };

    group ip_3i1o {
	IPbase.ip_Image_In		&src1<cptr=1>;
	IPbase.ip_Image_In		&src2<cptr=1>;
	IPbase.ip_Image_In		&src3<cptr=1>;
	IPbase.ip_Image_Out		dst<cptr=1> {
	    xsize => <-.src1.xsize;
	    ysize => <-.src1.ysize;
	    data_type => <-.src1.data_type;
	};
    };

    group ip_1r {
	IPbase.ip_Roi_In	&roi<cptr=1>;
    };

    group ip_Slct {
	IPbase.ip_Sel+Iparam	&sel<cptr=1>;
    };

    group ip_Krnl {
	IPbase.ip_Kernel+Iparam	&kernel<cptr=1>;
    };

    ip_1i+ip_1r			ip_1i1r;
    ip_1i1o+ip_1r		ip_1i1o1r;
    ip_1i1ob+ip_1r		ip_1i1ob1r;
    ip_2i1o+ip_1r		ip_2i1o1r;

    ip_1i1o1r+ip_Slct		ip_1i1o1rSlct;
    ip_1i1o1r+ip_Krnl		ip_1i1o1rKrnl;
};

/*
 * Low level wrapper function library calls.
 */
IPlib {
    IPbase.ip_1i1ob1r ip_threshold <
	struct_name = "ip_threshold_Struct",
	cfunction   = "if (src == NULL || dst == NULL || ip_threshold(src->Image,dst->Image,lo,hi,inv,roi) != 0) return(0)"
    > {
	float+Iparam		&lo = 0;
	float+Iparam		&hi = 255;
	int+Iparam		&inv = 0;
	cmethod+notify_val	threshold_update<status=1> = "ip_threshold_Func";
    };

    IPbase.ip_1i1o1r ip_linremap <
	struct_name = "ip_linremap_Struct",
	cfunction   = "if (src == NULL || dst == NULL || ip_linremap(src->Image,dst->Image,con,mul,roi) != 0) return(0)"
    > {
	float+Iparam		&con = 0;
	float+Iparam		&mul = 1;
	cmethod+notify_val	linremap_update<status=1> = "ip_linremap_Func";
    };

    IPbase.ip_1i1o1r ip_edge <
	struct_name = "ip_edge_Struct",
	cfunction   = "if (src == NULL || dst == NULL || ip_edge(src->Image,dst->Image,alg,hwidth,vwidth,roi) != 0) return(0)"
    > {
	int+Iparam		&alg = 1;
	float+Iparam		&hwidth = 3;
	float+Iparam		&vwidth = 3;
	cmethod+notify_val	edge_update<status=1> = "ip_edge_Func";
    };

    IPbase.ip_1i1r ip_variance <
	struct_name = "ip_variance_Struct",
	cfunction   = "if (src == NULL || ip_variance(src->Image,&npix,&mean,&var,roi) != 0) return(0)"
    > {
	float+Oparam		npix<modified=1>;
	float+Oparam		mean<modified=1>;
	float+Oparam		var<modified=1>;
	cmethod+notify_val	variance_update<status=1> = "ip_variance_Func";
    };

    IPbase.ip_1i1r ip_extrema <
	struct_name = "ip_extrema_Struct",
	cfunction   = "if (src == NULL || (roi != NULL && roi->data == NULL) || ip_extrema(src->Image, &min, &max, roi) != 0) return(0)"
    > {
	float+Oparam		min<modified=1>;
	float+Oparam		max<modified=1>;
	cmethod+notify_val	extrema_update<status=1> = "ip_extrema_Func";
    };

    IPbase.ip_1i1r ip_histogram <
	struct_name = "ip_histogram_Struct",
	cfunction   = "if (src == NULL || bins == NULL || ip_histogram(src->Image, bins, nbins, low, high, roi) != 0) return(0)"
    > {
	int+Iparam		nbins = 256;
	int+Oparam		bins<cptr=1,modified=1>[nbins];
	float+Iparam		low = 0;
	float+Iparam		high = 255;
	cmethod+notify_val	histogram_update<status=1> = "ip_histogram_Func";
    };

    /* for ip_read_line make out buf datatype same as src input */
    group ip_rdlnc {
	int+read+req		x1;
	int+read+req		y1;
	int+read+req		x2;
	int+read+req		y2;
        int+read+req            data_type;
        prim+nonotify		buf_real<unmanaged=1>[abs(x2-x1)+abs(y2-y1)];
        int+nres+nonotify	&buf<cptr=1>[abs(x2-x1)+abs(y2-y1)] => buf_real;
        method_upd		update = "ip_Read_Line_Convert_Func";
    };

    IPbase.ip_1i+ip_rdlnc ip_read_line <
	struct_name = "ip_read_line_Struct",
	cfunction   = "if (src == NULL || (npixels=ip_read_line(src->Image, x1, y1, x2, y2, (caddr_t)buf)) == 0) return(0)"
    > {
	int+Oparam		npixels<modified=1>;
	buf+Oparam<modified=1>;
	data_type => src.data_type;
	cmethod+notify_val	read_line_update<status=1> = "ip_read_line_Func";
    };

#ifdef USING_CONTOURS
    IPbase.ip_1i1o ip_contour <
	struct_name = "ip_contour_Struct",
	cfunction   = "if (src == NULL || dst == NULL || ip_contour(src->Image, dst->Image, levels, nlevels) != 0) return(0)"
    > {
	int+Iparam		nlevels;
	float			levels<cptr=1>[nlevels];
	cmethod+notify_val	contour_update<status=1> = "ip_contour_Func";
    };
#endif

    IPbase.ip_1i1o1rSlct ip_erode <
	struct_name = "ip_erode_Struct",
	cfunction   = "if (src == NULL || dst == NULL || sel == NULL || ip_erode(src->Image, dst->Image, sel->Sel, roi) != 0) return(0)"
    > {
	ip_Data_Names;
	cmethod+notify_val	erode_update<status=1> = "ip_erode_Func";
    };

    IPbase.ip_1i1o1rSlct ip_dilate <
	struct_name = "ip_dilate_Struct",
	cfunction   = "if (src == NULL || dst == NULL || sel == NULL || ip_dilate(src->Image, dst->Image, sel->Sel, roi) != 0) return(0)"
    > {
	ip_Data_Names;
	cmethod+notify_val	dilate_update<status=1> = "ip_dilate_Func";
    };

    IPbase.ip_1i1o1rSlct ip_median <
	struct_name = "ip_median_Struct",
	cfunction   = "if (src == NULL || dst == NULL || sel == NULL || ip_median(src->Image, dst->Image, sel->Sel, roi) != 0) return(0)"
    > {
	ip_Data_Names;
	cmethod+notify_val	median_update<status=1> = "ip_median_Func";
    };

    IPbase.ip_1i1o1rKrnl ip_convolve <
	struct_name = "ip_convolve_Struct",
	cfunction   = "if (src == NULL || dst == NULL || kernel == NULL || ip_convolve(src->Image, dst->Image, kernel->Kernel, roi) != 0)  return(0)"
    > {
	ip_Data_Names;
	cmethod+notify_val	convolve_update<status=1> = "ip_convolve_Func";
    };

    IPbase.ip_2i ip_compare <
	struct_name = "ip_compare_Struct",
	cfunction   = "if (src1 == NULL || src2 == NULL || ip_compare_xp(src1->Image, src2->Image, &res, &diffs) != 0)  return(0)"
    > {
/*	string+Oparam		res<cptr=1,modified=1>[1];*/
	int+Oparam		res<modified=1>;
	int+Oparam		diffs<modified=1>;
	cmethod+notify_val	compare_update<status=1> = "ip_compare_Func";
    };

    IPbase.ip_1i1o1r ip_and_const <
	struct_name = "ip_and_const_Struct",
	cfunction   = "if (src == NULL || dst == NULL || ip_and_const(src->Image, dst->Image, Const, roi) != 0) return(0)"
    > {
	int+Iparam		Const = 0;
	cmethod+notify_val	and_const_update<status=1> = "ip_and_const_Func";
    };

    IPbase.ip_1i1o1r ip_or_const <
	struct_name = "ip_or_const_Struct",
	cfunction   = "if (src == NULL || dst == NULL || ip_or_const(src->Image, dst->Image, Const, roi) != 0) return(0)"
    > {
	int+Iparam		Const = 0;
	cmethod+notify_val	or_const_update<status=1> = "ip_or_const_Func";
    };

    IPbase.ip_1i1o1r ip_xor_const <
	struct_name = "ip_xor_const_Struct",
	cfunction   = "if (src == NULL || dst == NULL || ip_xor_const(src->Image, dst->Image, Const, roi) != 0) return(0)"
    > {
	int+Iparam		Const = 0;
	cmethod+notify_val	xor_const_update<status=1> = "ip_xor_const_Func";
    };

    IPbase.ip_1i1o1r ip_min_const <
	struct_name = "ip_min_const_Struct",
	cfunction   = "if (src == NULL || dst == NULL || ip_min_const(src->Image, dst->Image, Const, roi) != 0) return(0)"
    > {
	float+Iparam		Const = 0;
	cmethod+notify_val	min_const_update<status=1> = "ip_min_const_Func";
    };

    IPbase.ip_1i1o1r ip_max_const <
	struct_name = "ip_max_const_Struct",
	cfunction   = "if (src == NULL || dst == NULL || ip_max_const(src->Image, dst->Image, Const, roi) != 0) return(0)"
    > {
	float+Iparam		Const = 0;
	cmethod+notify_val	max_const_update<status=1> = "ip_max_const_Func";
    };

    IPbase.ip_1i1o1r ip_mul_const <
	struct_name = "ip_mul_const_Struct",
	cfunction   = "if (src == NULL || dst == NULL || ip_mul_const(src->Image, dst->Image, Const, roi) != 0) return(0)"
    > {
	float+Iparam		Const = 1;
	cmethod+notify_val	mul_const_update<status=1> = "ip_mul_const_Func";
    };

    IPbase.ip_1i1o1r ip_add_const <
	struct_name = "ip_add_const_Struct",
	cfunction   = "if (src == NULL || dst == NULL || ip_add_const(src->Image, dst->Image, Const, roi) != 0) return(0)"
    > {
	float+Iparam		Const = 0;
	cmethod+notify_val	add_const_update<status=1> = "ip_add_const_Func";
    };

    IPbase.ip_2i1o1r ip_add <
	struct_name = "ip_add_Struct",
	cfunction   = "if (src1 == NULL || src2 == NULL || dst == NULL || ip_add(src1->Image, src2->Image, dst->Image, roi) != 0) return(0)"
    > {
	cmethod+notify_val	add_update<status=1> = "ip_add_Func";
    };

    IPbase.ip_2i1o1r ip_subtract <
	struct_name = "ip_subtract_Struct",
	cfunction   = "if (src1 == NULL || src2 == NULL || dst == NULL || ip_subtract(src1->Image, src2->Image, dst->Image, roi) != 0) return(0)"
    > {
	cmethod+notify_val	subtract_update<status=1> = "ip_subtract_Func";
    };

    IPbase.ip_2i1o1r ip_multiply <
	struct_name = "ip_multiply_Struct",
	cfunction   = "if (src1 == NULL || src2 == NULL || dst == NULL || ip_multiply(src1->Image, src2->Image, dst->Image, roi) != 0) return(0)"
    > {
	cmethod+notify_val	multiply_update<status=1> = "ip_multiply_Func";
    };

    IPbase.ip_2i1o1r ip_divide <
	struct_name = "ip_divide_Struct",
	cfunction   = "if (src1 == NULL || src2 == NULL || dst == NULL || ip_divide(src1->Image, src2->Image, dst->Image, roi) != 0) return(0)"
    > {
	cmethod+notify_val	divide_update<status=1> = "ip_divide_Func";
    };

    IPbase.ip_2i1o1r ip_and <
	struct_name = "ip_and_Struct",
	cfunction   = "if (src1 == NULL || src2 == NULL || dst == NULL || ip_and(src1->Image, src2->Image, dst->Image, roi) != 0) return(0)"
    > {
	cmethod+notify_val	and_update<status=1> = "ip_and_Func";
    };

    IPbase.ip_2i1o1r ip_nand <
	struct_name = "ip_nand_Struct",
	cfunction   = "if (src1 == NULL || src2 == NULL || dst == NULL || ip_nand(src1->Image, src2->Image, dst->Image, roi) != 0) return(0)"
    > {
	cmethod+notify_val	nand_update<status=1> = "ip_nand_Func";
    };

    IPbase.ip_2i1o1r ip_nor <
	struct_name = "ip_nor_Struct",
	cfunction   = "if (src1 == NULL || src2 == NULL || dst == NULL || ip_nor(src1->Image, src2->Image, dst->Image, roi) != 0) return(0)"
    > {
	cmethod+notify_val	nor_update<status=1> = "ip_nor_Func";
    };

    IPbase.ip_1i1o1r ip_not <
	struct_name = "ip_not_Struct",
	cfunction   = "if (src == NULL || dst == NULL || ip_not(src->Image, dst->Image, roi) != 0) return(0)"
    > {
	cmethod+notify_val	not_update<status=1> = "ip_not_Func";
    };

    IPbase.ip_1i1o1r ip_abs <
	struct_name = "ip_abs_Struct",
	cfunction   = "if (src == NULL || dst == NULL || ip_abs(src->Image, dst->Image, roi) != 0)  return(0)"
    > {
	cmethod+notify_val	abs_update<status=1> = "ip_abs_Func";
    };

    IPbase.ip_2i1o1r ip_or <
	struct_name = "ip_or_Struct",
	cfunction   = "if (src1 == NULL || src2 == NULL || dst == NULL || ip_or(src1->Image, src2->Image, dst->Image, roi) != 0) return(0)"
    > {
	cmethod+notify_val	or_update<status=1> = "ip_or_Func";
    };

    IPbase.ip_2i1o1r ip_xor <
	struct_name = "ip_xor_Struct",
	cfunction   = "if (src1 == NULL || src2 == NULL || dst == NULL || ip_xor(src1->Image, src2->Image, dst->Image, roi) != 0) return(0)"
    > {
	cmethod+notify_val	xor_update<status=1> = "ip_xor_Func";
    };

    IPbase.ip_2i1o1r ip_min <
	struct_name = "ip_min_Struct",
	cfunction   = "if (src1 == NULL || src2 == NULL || dst == NULL || ip_min(src1->Image, src2->Image, dst->Image, roi) != 0) return(0)"
    > {
	cmethod+notify_val	min_update<status=1> = "ip_min_Func";
    };

    IPbase.ip_2i1o1r ip_max <
	struct_name = "ip_max_Struct",
	cfunction   = "if (src1 == NULL || src2 == NULL || dst == NULL || ip_max(src1->Image, src2->Image, dst->Image, roi) != 0) return(0)"
    > {
	cmethod+notify_val	max_update<status=1> = "ip_max_Func";
    };

    IPbase.ip_3i1o ip_blend <
	struct_name = "ip_blend_Struct",
	cfunction   = "if (src1 == NULL || src2 == NULL || dst == NULL || ip_blend(src1->Image, src2->Image, dst->Image, src3->Image) != 0) return(0)"
    > {
	cmethod+notify_val	blend_update<status=1> = "ip_blend_Func";
    };

    IPbase.ip_1i1o ip_reflect <
	struct_name = "ip_reflect_Struct",
	cfunction   = "if (src == NULL || dst == NULL || ip_reflect(src->Image, dst->Image, dir_code) != 0) return(0)"
    > {
	int+Iparam		&dir_code = 0;
	cmethod+notify_val	reflect_update<status=1> = "ip_reflect_Func";
    };

    IPbase.ip_1i1o ip_rotate <
	struct_name = "ip_rotate_Struct",
	cfunction   = "if (src == NULL || dst == NULL || ip_rotate(src->Image, dst->Image, angle, int_code) != 0) return(0)"
    > {
	double+Iparam		&angle = 0;
	int+Iparam		&int_code = 1;
	cmethod+notify_val	rotate_update<status=1> = "ip_rotate_Func";
    };

    IPbase.ip_1i1o1r ip_shift <
	struct_name = "ip_shift_Struct",
	cfunction   = "if (src == NULL || dst == NULL || ip_shift(src->Image, dst->Image, bits, roi) != 0) return(0)"
    > {
	int+Iparam		&bits = 0;
	cmethod+notify_val	shift_update<status=1> = "ip_shift_Func";
    };

    IPbase.ip_1i1o ip_zoom <
	struct_name = "ip_zoom_Struct",
	cfunction   = "if (src == NULL || dst == NULL || ip_zoom(src->Image, dst->Image, (float)x, (float)y, (float)ScaleX, (float)ScaleY, int_code) != 0) return(0)"
    > {
	double+Iparam		x = 0;
	double+Iparam		y = 0;
	double+Iparam		&ScaleX = 1.0;
	double+Iparam		&ScaleY = 1.0;
	int+Iparam		&int_code = 1;
	cmethod+notify_val	zoom_update<status=1> = "ip_zoom_Func";
    };

    IPbase.ip_1i1o1r ip_copy <
	struct_name = "ip_copy_Struct",
	cfunction   = "if (src == NULL || dst == NULL || ip_copy(src->Image, dst->Image, roi) != 0) return(0)"
    > {
	int+req			DstType;
	dst.data_type => <-.DstType;
	cmethod+notify_val	copy_update<status=1> = "ip_copy_Func";
    };

    IPbase.ip_f1i1o ip_fft <
	struct_name = "ip_fft_Struct",
	cfunction   = "if (src == NULL || dst == NULL || ip_fft(src->Image, dst->Image) != 0) return(0)"
    > {
	cmethod+notify_val	fft_update<status=1> = "ip_fft_Func";
    };

    IPbase.ip_f1i1o ip_ifft <
	struct_name = "ip_ifft_Struct",
	cfunction   = "if (src == NULL || dst == NULL || ip_ifft(src->Image, dst->Image) != 0) return(0)"
    > {
	cmethod+notify_val	ifft_update<status=1> = "ip_ifft_Func";
    };

    IPbase.ip_f1i2o ip_fft_display <
	struct_name = "ip_fft_display_Struct",
	cfunction   = "if (src == NULL || dst1 == NULL || dst2 == NULL || ip_fft_display(src->Image,dst1->Image,dst2->Image,log) != 0) return(0)"
    > {
	int+Iparam		log;
	cmethod+notify_val	fft_display_update<status=1> = "ip_fft_display_Func";
    };

    IPbase.ip_1i1o1r ip_flog <
	struct_name = "ip_flog_Struct",
	cfunction   = "if (src == NULL || dst == NULL || ip_flog(src->Image, dst->Image, roi) != 0) return(0)"
    > {
	cmethod+notify_val	flog_update<status=1> = "ip_flog_Func";
    };

    IPbase.ip_1i1o1r ip_flog10 <
	struct_name = "ip_flog10_Struct",
	cfunction   = "if (src == NULL || dst == NULL || ip_flog10(src->Image, dst->Image, roi) != 0) return(0)"
    > {
	cmethod+notify_val	flog10_update<status=1> = "ip_flog10_Func";
    };

    IPbase.ip_1i1o1r ip_fsqrt <
	struct_name = "ip_fsqrt_Struct",
	cfunction   = "if (src == NULL || dst == NULL || ip_fsqrt(src->Image, dst->Image, roi) != 0) return(0)"
    > {
	cmethod+notify_val	fsqrt_update<status=1> = "ip_fsqrt_Func";
    };

    IPbase.ip_1i1o1r ip_fexp <
	struct_name = "ip_fexp_Struct",
	cfunction   = "if (src == NULL || dst == NULL || ip_fexp(src->Image, dst->Image, roi) != 0) return(0)"
    > {
	cmethod+notify_val	fexp_update<status=1> = "ip_fexp_Func";
    };

    IPbase.ip_1i1o1r ip_frecip <
	struct_name = "ip_frecip_Struct",
	cfunction   = "if (src == NULL || dst == NULL || ip_frecip(src->Image, dst->Image, roi) != 0) return(0)"
    > {
	cmethod+notify_val	frecip_update<status=1> = "ip_frecip_Func";
    };

    IPbase.ip_1i1o1r ip_fcos <
	struct_name = "ip_fcos_Struct",
	cfunction   = "if (src == NULL || dst == NULL || ip_fcos(src->Image, dst->Image, roi) != 0) return(0)"
    > {
	cmethod+notify_val	fcos_update<status=1> = "ip_fcos_Func";
    };

    IPbase.ip_1i1o1r ip_fsin <
	struct_name = "ip_fsin_Struct",
	cfunction   = "if (src == NULL || dst == NULL || ip_fsin(src->Image, dst->Image, roi) != 0) return(0)"
    > {
	cmethod+notify_val	fsin_update<status=1> = "ip_fsin_Func";
    };

    IPbase.ip_1i1o1r ip_fatan <
	struct_name = "ip_fatan_Struct",
	cfunction   = "if (src == NULL || dst == NULL || ip_fatan(src->Image, dst->Image, roi) != 0) return(0)"
    > {
	cmethod+notify_val	fatan_update<status=1> = "ip_fatan_Func";
    };

};

/*
 * Base IP types
 *	These are the package elements that should be instanced.
 */
flibrary+global+sort+buffered IPfunc {
    IPlib.ip_threshold		ip_threshold;
    IPlib.ip_linremap		ip_linremap;
    IPlib.ip_edge		ip_edge;
    IPlib.ip_variance		ip_variance;
    IPlib.ip_extrema		ip_extrema;
    IPlib.ip_histogram		ip_histogram;
    IPlib.ip_read_line		ip_read_line;
#ifdef USING_CONTOURS
    IPlib.ip_contour		ip_contour;
#endif
    IPlib.ip_erode		ip_erode;
    IPlib.ip_dilate		ip_dilate;
    IPlib.ip_median		ip_median;
    IPlib.ip_convolve		ip_convolve;
    IPlib.ip_compare		ip_compare;
    IPlib.ip_and_const		ip_and_const;
    IPlib.ip_or_const		ip_or_const;
    IPlib.ip_xor_const		ip_xor_const;
    IPlib.ip_min_const		ip_min_const;
    IPlib.ip_max_const		ip_max_const;
    IPlib.ip_mul_const		ip_mul_const;
    IPlib.ip_add_const		ip_add_const;
    IPlib.ip_add		ip_add;
    IPlib.ip_subtract		ip_subtract;
    IPlib.ip_multiply		ip_multiply;
    IPlib.ip_divide		ip_divide;
    IPlib.ip_and		ip_and;
    IPlib.ip_nand		ip_nand;
    IPlib.ip_nor		ip_nor;
    IPlib.ip_not		ip_not;
    IPlib.ip_abs		ip_abs;
    IPlib.ip_or			ip_or;
    IPlib.ip_xor		ip_xor;
    IPlib.ip_min		ip_min;
    IPlib.ip_max		ip_max;
    IPlib.ip_blend		ip_blend;
    IPlib.ip_reflect		ip_reflect;
    IPlib.ip_rotate		ip_rotate;
    IPlib.ip_shift		ip_shift;
    IPlib.ip_zoom		ip_zoom;
    IPlib.ip_copy		ip_copy;
    IPlib.ip_fft		ip_fft;
    IPlib.ip_ifft		ip_ifft;
    IPlib.ip_fft_display	ip_fft_display;
    IPlib.ip_flog		ip_flog;
    IPlib.ip_flog10		ip_flog10;
    IPlib.ip_fsqrt		ip_fsqrt;
    IPlib.ip_fexp		ip_fexp;
    IPlib.ip_frecip		ip_frecip;
    IPlib.ip_fcos		ip_fcos;
    IPlib.ip_fsin		ip_fsin;
    IPlib.ip_fatan		ip_fatan;
};


};
