//                        Copyright (c) 1993 by
//                        Advanced Visual Systems Inc.
//                        All Rights Reserved
//
//        This software comprises unpublished confidential information of
//        Advanced Visual Systems Inc. and may not be used, copied or made
//        available to anyone, except in accordance with the license
//        under which it is furnished.
//
//        This file is under Perforce control
//        $Id: //depot/express/fcs70/v/lib_xp.v#1 $
//

$include ../include/$MACHINE/gd_ren.h
$include ../include/$MACHINE/config.h

library Libraries {

   // Simplified Start page oriented towards new users

   NElink Start <needs_use_lic="GD DV",NEgridWidth=160>
          => Templates.NELIBS.NE_START;

   // The Main page contains an assortment of links to libraries in
   // various kits.

   flibrary Main <needs_use_lic="GD DV"> {
      NElink Data_IO         <NEdisplayMode="open">
         => Templates.NELIBS.NE_DATA_IO;

      NElink Filters         <NEdisplayMode="open">
         => Templates.NELIBS.NE_FILTERS;

      NElink Mappers         <NEdisplayMode="open">
         => Templates.NELIBS.NE_MAPPERS;

      NElink Geometries      <NEdisplayMode="open">
         => Templates.NELIBS.NE_GEOMS;

      NElink Field_Mappers   <NEdisplayMode="open">
         => Templates.FLD_MAP;

      NElink Viewers         <NEdisplayMode="open">
         => Templates.NELIBS.NE_VIEWERS;
   };

   // The Accessories page is another assortment of links to libraries
   // in various kits.
   flibrary Accessories <needs_use_lic="GD DV"> {

      /* stuff from GD kit */
      flibrary Graphics <NEdisplayMode="open"> {
         NElink Interactivity => Templates.GDM.Interactivity;
         NElink Modules  => Templates.NELIBS.GD_Modules;
         NElink Editors  => Templates.GDM.UI_Editors;
         NElink Viewers  => Templates.VIEW.Viewers;

         flibrary+buffered ColorMap<user_library=0> {
            CMAP_EDTR.Macro.ColorMapEditor ColormapEditor;
            CMAP_EDTR.Modules.modHistogram histogram {
               data_component<NEportLevels={2,0}>;
            };
         };
      };

#ifdef AG_KIT
      NElink Graphs         <NEdisplayMode="open">
          => Templates.NELIBS.NE_GRAPHS_HLM;
#endif

      flibrary Image_Processing <NEdisplayMode="open"> {
         NElink Modules    = Templates.IP.Macros;
         flibrary+buffered Loop_Vol<user_library=0> {
            IPloopVol IPloopVol;
            IPloopVolRoi IPloopVolRoi;
            IPloopVolVolRoi IPloopVolVolRoi;
            IPaddVol IPaddVol;
            IPadd_constVol IPadd_constVol;
            IPconvolveVol IPconvolveVol;
            IPdivideVol IPdivideVol;
            IPmul_constVol IPmul_constVol;
            IPmultiplyVol IPmultiplyVol;
            IPsubVol IPsubVol;
            IPthresholdVol IPthresholdVol;
         };
         NElink Converters = Templates.IP.Interface;
      };

      NElink Utility_Modules    <NEdisplayMode="open">
         => Templates.NELIBS.NE_UTILITY;

      NElink Field_Schema     <NEdisplayMode="open">
         => Templates.NELIBS.NE_DV.Field_Schema;

      flibrary Array_of_Fields <NEdisplayMode="open"> {
         NElink Filters => Templates.MODS_ARR.Array_Filters;
         NElink Mappers => Templates.MODS_ARR.Array_Mappers;
         NElink Multi_Block => Templates.MODS_ARR.Multi_Block;
         NElink Fast_Filters => Templates.FAST_ARR.FA_Filters;
         NElink Fast_Mappers => Templates.FAST_ARR.FA_Mappers;
      };

   };  // Accessories

   // The "Standard Objects" page contains base types for building new
   // components.

   NElink Standard_Objects => Templates.STD;

   // The following pages correspond to various kits:

   NElink User_Interface => Templates.NELIBS.NE_UI;

   NElink Graphics_Display <needs_use_lic="GD"> => Templates.NELIBS.NE_GD;

#ifdef AG_KIT
   NElink Annotation_Graphing => Templates.NELIBS.NE_AG;
#endif

   NElink Visualization <needs_use_lic="DV"> => Templates.NELIBS.NE_DV;

   NElink Imaging => Templates.NELIBS.NE_IP;

   /* IAC: Added PST User Library */
#ifdef PST_KIT
   library PST<needs_use_lic="PST", NEdisplayMode="open"> {
#ifdef PST_DEV_AVAIL
      NElink Development<NEdisplayMode="open"> => Templates.PST_DEV;
#endif      
      NElink DataIO<NEdisplayMode="open"> => Templates.PST_USER.DataIO;
      NElink Filters<NEdisplayMode="open"> => Templates.PST_USER.Filters;
      NElink Mappers<NEdisplayMode="open"> => Templates.PST_USER.Mappers;
      NElink Misc<NEdisplayMode="open"> => Templates.PST_USER.Misc;
      NElink Applications<NEdisplayMode="open"> => Templates.PST.APPS;
   };
#endif
   
#ifdef INCLUDE_MicroAVS
   $include MicroAVS/xp.v
#endif

//#ifdef ACKIT
//   NElink AVS5_Modules => Templates.NELIBS.NE_AC;
//#endif

//#ifdef AC_KIT_V1
//   NElink AVS5_Mods_UNSUPPORTED => Templates.NELIBS.NE_AC;
//#endif

#ifdef DB_KIT
   NElink Database <needs_use_lic="DB"> => Templates.DB;
#endif

   // The Examples page contains demo applications.

   NElink Examples => Templates.EXAMPLES;

   // The "Library Workspaces" page contains a number of editable libraries
   // that objects can be dropped into.  It is editable itself, so that new
   // libraries can be dropped into it.

   flibrary Library_Workspaces <NEeditable=1> {

      NElink Express_Functions <NEeditable=1, NEdisplayMode="open"> =>
             Templates.WORKSPACE_XP;
      NElink User_Functions <NEeditable=1, NEdisplayMode="open">    =>
             Templates.USER;
      NElink Workspace_1 <NEeditable=1, NEdisplayMode="open">  =>
             Templates.WORKSPACE_1;
      NElink Workspace_2 <NEeditable=1, NEdisplayMode="open">  =>
             Templates.WORKSPACE_2;
      NElink Workspace_3 <NEeditable=1, NEdisplayMode="open">  =>
             Templates.WORKSPACE_3;
      NElink Workspace_4 <NEeditable=1, NEdisplayMode="open">  =>
             Templates.WORKSPACE_4;
   };

   // The Templates page is a link back to the "raw" Templates library.
   // It is editable, so that new libraries can be dropped into it.

   NElink Templates <NEeditable=1> => <-.Templates;
};

//---------------------------------------------------------------------//
//                           End of lib_xp.v                           //
//---------------------------------------------------------------------//
