/*
 		Copyright (c) 1992,1994 by
 		Advanced Visual Systems Inc.
 		All Rights Reserved

 This software comprises unpublished confidential information of Advanced
 Visual Systems Inc. and may not be used, copied or made available to
 anyone, except in accordance with the license under which it is furnished.

 This file is under Perforce control
 $Id: //depot/express/fcs70/v/modules.v#1 $
*/

flibrary MODS<needs_use_lic="GD",needs_edit_lic="DV",
	      compile_subs=0> {

$include ../include/avs/gd_def.h
$include ../include/$MACHINE/config.h

ModuleStack ModuleStack;

library+sort+buffered Readers {

#ifdef ACKIT
#define INCLUDE_READ_GEOM	1
#endif
#ifdef AC_KIT_V1
#define INCLUDE_READ_GEOM	1
#endif

#ifdef READ_URL
  W3C.Read_URL Read_URL;
  W3C.ReadWebField ReadWebField;
#ifdef INCLUDE_READ_GEOM
  W3C.ReadWebGeom ReadWebGeom;
#endif
#endif

#ifdef INCLUDE_READ_GEOM

macro Read_Geom<disabled=>Templates.CONFIG.ac_kit_disabled> {

    macro read_geom_ui {
	UImod_panel panel {
            title => name_of(<-.<-.<-,1);
	    message = "Select read geom control panel.";
	    parent<NEportLevels={4,0}>;
	};

	UIlabel Geometry_Filename {
	    parent => <-.panel;
	    y = 0;
	    width => 200;
	    alignment = 0;
	};
	UItext file_name {
	    parent => panel;
	    y => Geometry_Filename.y + Geometry_Filename.height + 5;
	    text => <-.filename;
	    width = 170;
            showLastPosition = 1;
	};
	UIbutton visible {
	    parent => panel;
	    x => file_name.x + file_name.width + 5;
	    y => file_name.y;
	    width = 75;
	    height => <-.file_name.height;
	    label = "Browse...";
	};
	UIfileSB file_browser {
	    GMOD.copy_on_change copy_on_change {
		trigger => <-.<-.visible.do;
		input => <-.<-.visible.do;
		output => <-.visible;
	    };
	    title = "Read GEOM Filename";
	    searchPattern = "$XP_PATH<0>/data/geom/*.geo";
	    filename => <-.filename;
	};

	string filename<export=3>;
    };

    ACread_geom ACread_geom {
        array_flag = 0;
	filename => read_geom_ui.filename;
    };

    DataObject DataObject {
	in => ACread_geom.out_field;
	Obj {
                name <NEportLevels={3,0}> => <-.<-.ACread_geom.name;
	};
    };

    olink field<export_all=2> => ACread_geom.out_field;
    olink geom =>  DataObject.obj;
};  // Read_Geom

macro Read_Geoms<disabled=>Templates.CONFIG.ac_kit_disabled> {

    macro read_geom_ui {
        UImod_panel panel {
            title => name_of(<-.<-.<-);
            message = "Select read geom control panel.";
            parent<NEportLevels={4,0}>;
        };
	UIlabel Geometry_Filename {
	    parent => <-.panel;
	    y = 0;
	    width => 200;
	    alignment = 0;
	};
	UItext file_name {
	    parent => panel;
	    y => Geometry_Filename.y + Geometry_Filename.height + 5;
	    text => <-.filename;
	    width = 170;
            showLastPosition = 1;
	};
	UIbutton visible {
	    parent => panel;
	    x => file_name.x + file_name.width + 5;
	    y => file_name.y;
	    width = 75;
	    height => <-.file_name.height;
	    label = "Browse...";
	};
        UIfileSB file_browser {
	    GMOD.copy_on_change copy_on_change {
		trigger => <-.<-.visible.do;
		input => <-.<-.visible.do;
		output => <-.visible;
	    };
            title = "Read GEOM Filename";
            searchPattern = "$XP_PATH<0>/data/geom/*.geo";
	    filename => <-.filename;
	};

	string filename<export=3>;
    };

    ACread_geom ACread_geom {
        array_flag = 1;
        filename => read_geom_ui.filename;
    };

    DataObjects DataObjects {
        in_fields => ACread_geom.out_fields;
        dos {
                Obj {
                        xform_mode = GD_XFORM_MODE_PARENT;
                        name => ( (<-.<-.<-.ACread_geom.name + ".obj") +
                                  index_of(<-.<-.dos) );
                };
        };
    };

    GroupObject GroupObject {
        child_objs => DataObjects.dos.obj;
        Top {
                name => <-.<-.ACread_geom.name + ".Top";
        };
    };

    olink field<export_all=2> => ACread_geom.out_fields;
    olink geom =>  GroupObject.obj;
}; // Read_Geoms

#endif /* INCLUDE_READ_GEOM */

macro Read_Volume {

    macro read_volume_ui {
	UImod_panel panel {
            title => name_of(<-.<-.<-);
	    message = "Select read volume control panel.";
	    parent<NEportLevels={4,0}>;
	};
	UIlabel Volume_Filename {
	    parent => <-.panel;
	    y = 0;
	    width => 200;
	    alignment = 0;
	};
	UItext file_name {
	    parent => panel;
	    y => Volume_Filename.y + Volume_Filename.height + 5;
	    text => <-.filename;
	    width = 170;
            showLastPosition = 1;
	};
	UIbutton visible {
	    parent => panel;
	    x => file_name.x + file_name.width + 5;
	    y => file_name.y;
	    width = 75;
	    height => <-.file_name.height;
	    label = "Browse...";
	};
	UIfileSB file_browser {
	    GMOD.copy_on_change copy_on_change {
		trigger => <-.<-.visible.do;
		input => <-.<-.visible.do;
		output => <-.visible;
	    };
	    title = "Read vol Filename";
	    searchPattern = "$XP_PATH<0>/data/volume/*.dat";
	    filename => <-.filename;
	};

	string filename<export=3>;
    };

    DVread_vol DVread_vol {
	filename => read_volume_ui.filename;
    };

    DataObject DataObject {
	in => DVread_vol.out;
	Obj {
		name => name_of(<-.<-.<-);
	};
    };
    olink field<export_all=2> => DVread_vol.out;
    olink geom => DataObject.obj;
}; // Read_Volume

macro Read_Image {

    macro read_image_ui {
	ilink in<export_all=2>;
	string info_string = "";

	UImod_panel panel {
            title => name_of(<-.<-.<-);
	    message = "Select read image control panel.";
	    parent<NEportLevels={4,0}>;
	};

	UIlabel Image_Filename {
	    parent => <-.panel;
	    y = 0;
	    width => 200;
	    alignment = 0;
	};
	UItext file_name {
	    parent => panel;
	    y => Image_Filename.y + Image_Filename.height + 5;
	    text => <-.filename;
	    width = 170;
            showLastPosition = 1;
	};
	UIbutton visible {
	    parent => panel;
	    x => file_name.x + file_name.width + 5;
	    y => file_name.y;
	    width = 75;
	    height => <-.file_name.height;
	    label = "Browse...";
	};

	UIfileSB file_browser {
	    GMOD.copy_on_change copy_on_change {
		trigger => <-.<-.visible.do;
		input => <-.<-.visible.do;
		output => <-.visible;
	    };
	    title = "Read IMAGE Filename";
	    searchPattern = "$XP_PATH<0>/data/image/*";
	};

	UItoggle flip_toggle {
	    parent => <-.panel;
	    label = "Flip Image";
	    y		=> <-.visible.y + <-.visible.height+8;
	    width	=> <-.panel.width;
	};

	UIframe format_frame {
	    parent => <-.panel;
	    visible => <-.panel.visible;
	    y => <-.flip_toggle.y + <-.flip_toggle.height + 4;
	    width => <-.panel.width;
	    height => <-.format_rb.y + <-.format_rb.height + 6;
	};
	UIlabel format_label {
	    parent => format_frame;
	    label = "File Format";
	    x = 4;
	    y = 0;
	    width => <-.panel.width;
	};
	UIoption format_from {
	    label = "(from file)";
	    message = "determine format from file";
	    active = 1;
	};
	UIoption format_avsx {
	    label = "AVS .x";
	    message = "AVS .x format";
	    active = 1;
	};
	UIoption format_bmp {
	    label = "BMP";
	    message = "Microsoft BMP format";
	    active = 1;
	};
	UIoption format_gif {
	    label = "GIF";
	    message = "Graphics Interchange Format";
	    active = 1;
	};
	UIoption format_jpeg {
	    label = "JPEG";
	    message = "JFIF: JPEG File Interchange Format";
	    active = 1;
	};
	UIoption format_pbm {
	    label = "PBM";
	    message = "Portable Bitmap Utilities";
	    active = 1;
	};
	UIoption format_sgi {
	    label = "SGI Image";
	    message = "SGI Image format";
	    active = 1;
	};
	UIoption format_sun {
	    label = "Sun Raster";
	    message = "Sun Rasterfile format";
	    active = 1;
	};
	UIoption format_tiff {
	    label = "TIFF";
	    message = "Tag Image File Format";
	    active = 1;
	};
	UIradioBox format_rb {
	    parent => format_frame;
	    cmdList => {format_from, format_avsx, format_bmp, format_gif, format_jpeg, format_pbm, format_sgi, format_sun, format_tiff};
	    visible => <-.panel.visible;
	    selectedItem = 0;
	    x = 4;
	    y => <-.format_label.y + <-.format_label.height + 4;
	    width => <-.panel.width;
	};

	UItext file_info {
	    parent => <-.panel;
            visible => <-.panel.visible;
            y => <-.format_frame.y + <-.format_frame.height + 4;
            width => <-.panel.width;
	    outputOnly = 1;
	    text<NEportLevels={0,3}> = <-.info_string;
	};

	olink filename<export=3> => file_browser.filename;
	olink flip<export=3>     => flip_toggle.set;
	olink format<export=3>   => format_rb.selectedItem;
	olink info<export=3>     => file_info.text;
    };
    DVread_image DVread_image {
	filename => read_image_ui.filename;
	flip =>  read_image_ui.flip;
	format =>  read_image_ui.format;
	info => read_image_ui.info;
	out {
	    xform.rspace = 2;
        };
    };

    DataObject DataObject {
	in => DVread_image.out;
	Obj {
		name => name_of(<-.<-.<-);
	};
    };

    olink field<export_all=2>=> DVread_image.out;
    olink image => DataObject.obj;
}; // Read_Image

macro Read_Img2Vol {

    DV_Param_read_img2vol Read_Img2VolParam {
        min_length = 0;
        format = 0;
        out_format = 5;
    };

    macro read_img2vol_ui {

        DV_Param_read_img2vol+IPort2 &param => <-.Read_Img2VolParam;

        string info_string = "";

        UImod_panel panel {
            title => name_of(<-.<-.<-);
            message = "Select read image2volume control panel.";
            parent<NEportLevels={4,0}>;
        };

        UIlabel FilenamePatternLabel {
            parent => panel;
            label = "Filename Pattern";
            alignment = "center";
            y = 0;
            width => parent.width;
        };
        UIlabel FilenameHeadLabel {
            parent => panel;
            label   = "Fname Head";
            message = "Filename Head";
            alignment = "left";
            y => <-.FilenamePatternLabel.y + <-.FilenamePatternLabel.height + 2;
            width => parent.width * (1./3.) - 3;
        };
        UItext FilenameHeadText {
            parent => panel;
            text => <-.param.filename_head;
            x => <-.FilenameHeadLabel.x + <-.FilenameHeadLabel.width + 3;
            y => <-.FilenameHeadLabel.y;
            width => parent.width * (2./3.);
        };
        UIlabel FilenameTailLabel {
            parent => panel;
            label   = "Fname Tail";
            message = "Filename Tail";
            alignment = "left";
            y => <-.FilenameHeadText.y + <-.FilenameHeadText.height + 5;
            width => parent.width * (1./3.) - 3;
        };
        UItext FilenameTailText {
            parent => panel;
            text => <-.param.filename_tail;
            x => <-.FilenameTailLabel.x + <-.FilenameTailLabel.width + 3;
            y => <-.FilenameTailLabel.y;
            width => parent.width * (2./3.);
        };
        UIlabel MinLengthLabel {
            parent => panel;
            label = "Minimum Index Length";
            alignment = 2;
            y => <-.FilenameTailText.y + <-.FilenameTailText.height + 5;
            width => parent.width * (2./3.) - 3;
        };
        UIfield MinLengthField {
            parent => panel;
            min = 0;
            mode = "integer";
            value => <-.param.min_length;
            x => <-.MinLengthLabel.x + <-.MinLengthLabel.width + 3;
            y => <-.MinLengthLabel.y;
            width => parent.width * (1./3.);
        };

        string+Port formatEg => "%0" + param.min_length + "d";

        string+Port filenameEg => param.filename_head + str_format(.formatEg, 1) + param.filename_tail;

        UIlabel FilenameEgLabel {
            parent => panel;
            label = "Filename Eg.";
            alignment = 2;
            y => <-.MinLengthField.y + <-.MinLengthField.height + 10;
            width => parent.width * (1./3.) - 3;
        };
        UItext FilenameEgText {
            parent => panel;
            text => <-.filenameEg;
            outputOnly = 1;
            x => <-.FilenameEgLabel.x + <-.FilenameEgLabel.width + 3;
            y => <-.FilenameEgLabel.y;
            width => parent.width * (2./3.);
        };

        UIlabel StartIndexLabel {
            parent => panel;
            label = "Starting Image Index";
            alignment = 2;
            y => <-.FilenameEgText.y + <-.FilenameEgText.height + 25;
            width => parent.width * (2./3.) - 3;
        };
        UIfield StartIndexField {
            parent => panel;
            min = 0;
            mode = "integer";
            value => <-.param.start;
            x => <-.StartIndexLabel.x + <-.StartIndexLabel.width + 3;
            y => <-.StartIndexLabel.y;
            width => parent.width * (1./3.);
        };

        UIlabel EndIndexLabel {
           parent => panel;
           label = "Ending Image Index";
           alignment = 2;
           y => <-.StartIndexField.y + <-.StartIndexField.height + 3;
           width => parent.width * (2./3.) - 3;
        };

        UIfield EndIndexField {
           parent => panel;
           min = 0;
           value => <-.param.end;
           mode = "integer";
           x => <-.EndIndexLabel.x + <-.EndIndexLabel.width + 3;
           y => <-.EndIndexLabel.y;
           width => parent.width * (1./3.);
        };

        UIframe format_frame {
           parent => <-.panel;
           visible => <-.panel.visible;
           y => <-.EndIndexField.y + <-.EndIndexField.height + 10;
           width => <-.panel.width;
           height => <-.format_rb.y + <-.format_rb.height + 6;
        };
        UIlabel format_label {
           parent => format_frame;
           label = "File Format";
           x = 4;
           y = 0;
           width => <-.panel.width;
        };
        UIoption format_from {
           label = "(from file)";
           message = "determine format from file";
           active = 1;
        };
        UIoption format_avsx {
           label = "AVS .x";
           message = "AVS .x format";
           active = 1;
        };
        UIoption format_bmp {
           label = "BMP";
           message = "Microsoft BMP format";
           active = 1;
        };
        UIoption format_gif {
           label = "GIF";
           message = "Graphics Interchange Format";
           active = 1;
        };
        UIoption format_jpeg {
           label = "JPEG";
           message = "JFIF: JPEG File Interchange Format";
           active = 1;
        };
        UIoption format_pbm {
           label = "PBM";
           message = "Portable Bitmap Utilities";
           active = 1;
        };
        UIoption format_sgi {
           label = "SGI Image";
           message = "SGI Image format";
           active = 1;
        };
        UIoption format_sun {
           label = "Sun Raster";
           message = "Sun Rasterfile format";
           active = 1;
        };
        UIoption format_tiff {
           label = "TIFF";
           message = "Tag Image File Format";
           active = 1;
        };
        UIradioBox format_rb {
           parent => format_frame;
           cmdList => {format_from, format_avsx, format_bmp, format_gif, format_jpeg, format_pbm, format_sgi, format_sun, format_tiff};
           visible => <-.panel.visible;
           selectedItem => <-.param.format;
           x = 4;
           y => <-.format_label.y + <-.format_label.height + 4;
           width => <-.panel.width;
        };


        UIframe out_format_frame {
            parent => <-.panel;
            visible => <-.panel.visible;
            y => <-.format_frame.y + <-.format_frame.height + 10;
            width => <-.panel.width;
            height => <-.out_format_rb.y + <-.out_format_rb.height + 6;
        };
        UIlabel out_format_label {
            parent => out_format_frame;
            label = "Output Format";
            x = 4;
            y = 0;
            width => <-.panel.width;
        };
        UIoption out_format_argb {
            label = "ARGB Data";
            message = "Output 4-byte ARGB vector.";
            active = 1;
        };
        UIoption out_format_alpha {
            label = "Alpha Data";
            message = "Output alpha channel byte data.";
            active = 1;
        };
        UIoption out_format_red {
            label = "Red Data";
            message = "Output red channel byte data.";
            active = 1;
        };
        UIoption out_format_green {
            label = "Green Data";
            message = "Output green channel byte data.";
            active = 1;
        };
        UIoption out_format_blue {
            label = "Blue Data";
            message = "Output blue channel byte data.";
           active = 1;
        };
        UIoption out_format_lumi {
           label = "Luminance Data (float)";
           message = "Output luminance float data.";
           active = 1;
        };
        UIoption out_format_lumi_byte {
           label = "Luminance Data (byte)";
           message = "Output luminance byte data.";
           active = 1;
        };
        UIradioBox out_format_rb {
           parent => out_format_frame;
           cmdList => {out_format_argb, out_format_alpha, out_format_red, out_format_green, out_format_blue, out_format_lumi, out_format_lumi_byte};
           visible => <-.panel.visible;
           selectedItem => <-.param.out_format;
           x = 4;
           y => <-.out_format_label.y + <-.out_format_label.height + 4;
           width => <-.panel.width;
        };

        UItext file_info {
           parent => <-.panel;
           visible => <-.panel.visible;
           y => <-.out_format_frame.y + <-.out_format_frame.height + 10;
           width => <-.panel.width;
           outputOnly = 1;
           text => <-.info_string;
        };

    }; // read_img2vol_ui

    string+Port filename => Read_Img2VolParam.filename_head + "%0" + Read_Img2VolParam.min_length + "d" + Read_Img2VolParam.filename_tail;

    DVread_img2vol DVread_img2vol {
      	filename   => <-.filename;
        format     => <-.Read_Img2VolParam.format;
        start      => <-.Read_Img2VolParam.start;
        end        => <-.Read_Img2VolParam.end;
        out_format => <-.Read_Img2VolParam.out_format;
    };

    DataObject DataObject {
        in => <-.DVread_img2vol.out;
        Obj.name => name_of(<-.<-.<-);
    };

    olink out_fld => .DVread_img2vol.out;
    olink out_obj => .DataObject.obj;
    olink info    => .DVread_img2vol.info;
}; // Read_Img2Vol

macro Read_Field {

#ifdef OLD_FIELD_READER

    macro read_field_ui {
	UImod_panel panel {
	    title => name_of(<-.<-.<-,1);
	    message = "Select read field control panel.";
	    parent<NEportLevels={4,0}>;
	};

	UItoggle portable_toggle {
	    parent => <-.panel;
	    label  =  "Portable (XDR)";
	    set    =  1;
	    y      =  0;
	    width  => <-.panel.width;
	    set => <-.portable;
	};

	UItoggle swap_toggle {
	    int vis_arr[2] => {(<-.portable_toggle.set)^1, 1};
	    parent => <-.panel;
	    label  =  "Swap Bytes";
	    set    =  0;
	    y      =>  <-.portable_toggle.height+<-.portable_toggle.y+4;
	    width  => <-.panel.width;
	    visible => min_array(vis_arr);
	    set => <-.swap;
	};

	UItoggle flip_toggle {
	    parent => <-.panel;
	    label  =  "Flip Image";
	    y      => <-.swap_toggle.height+<-.swap_toggle.y+4;
	    width  => <-.panel.width;
	    set => <-.flip;
	};
	UIlabel Field_Filename {
	    parent => <-.panel;
	    y      => flip_toggle.height + flip_toggle.y + 10;
	    width => 200;
	    alignment = 0;
	};
	UItext file_name {
	    parent => panel;
	    y => Field_Filename.y + Field_Filename.height + 5;
	    text => <-.filename;
	    width = 170;
	    showLastPosition = 1;
	};
	UIbutton visible {
	    parent => panel;
	    x => file_name.x + file_name.width + 5;
	    y => file_name.y;
	    width = 75;
	    height => <-.file_name.height;
	    label = "Browse...";
	};

	UIfileSB file_browser {
	    GMOD.copy_on_change copy_on_change {
               trigger => <-.<-.visible.do;
               input => <-.<-.visible.do;
               output => <-.visible;
	    };
	    title = "Read AVS Field Filename";
	    searchPattern = "$XP_PATH<0>/data/field/*.fld";
	    filename => <-.filename;
	};

	string filename<export=3>;
	int portable<export=3>=1;
	int swap<export=3>=0;
	int flip<export=3>=0;
    };
    DVread_field DVread_field {
	filename => read_field_ui.filename;
	portable => read_field_ui.portable;
	swap => read_field_ui.swap;
	flip =>  read_field_ui.flip;
    };

    DataObjectNoTexture DataObject {
	in => DVread_field.out;
	Obj {
		name => name_of(<-.<-.<-);
	};
    };
    olink field<export_all=2> => DVread_field.out;
    olink out_obj => DataObject.obj;

#else	// new multi-timestep reader from KGT

    macro read_field_ui {
	group &param<NEportLevels={2,0}> => <-.Read_Field_Param;

	UImod_panel panel {
	    title => name_of(<-.<-.<-,1);
	    message = "Select read field control panel.";
	    parent<NEportLevels={4,0}>;
	};

	UItoggle portable_toggle {
	    parent => <-.panel;
	    label  =  "Portable (XDR)";
	    set    =  1;
	    y      =  0;
	    width  => <-.panel.width;
	    set => <-.portable;
	};
	UItoggle swap_toggle {
	    int vis_arr[2] => {(<-.portable_toggle.set)^1, 1};
	    parent => <-.panel;
	    label  =  "Swap Bytes";
	    set    =  0;
	    y      =>  <-.portable_toggle.height+<-.portable_toggle.y+4;
	    width  => <-.panel.width;
	    visible => min_array(vis_arr);
	    set => <-.swap;
	};
	UItoggle flip_toggle {
	    parent => <-.panel;
	    label  =  "Flip Image";
	    y      => <-.swap_toggle.height+<-.swap_toggle.y+4;
	    width  => <-.panel.width;
	    set => <-.flip;
	};
	UIlabel Field_Filename {
	    parent => <-.panel;
	    y      => <-.flip_toggle.height+<-.flip_toggle.y+4;
	    width  => 200;
	    alignment = 0;
	};
	UItext file_name {
	    parent => panel;
	    y => Field_Filename.y + Field_Filename.height + 5;
	    text => <-.filename;
	    width = 170;
	    showLastPosition = 1;
	};
	UIbutton visible {
	    parent => panel;
	    x => file_name.x + file_name.width + 5;
	    y => file_name.y;
	    width = 75;
	    height => <-.file_name.height;
	    label = "Browse...";
	};

	UIfileSB file_browser {
	    GMOD.copy_on_change copy_on_change {
               trigger => <-.<-.visible.do;
               input => <-.<-.visible.do;
               output => <-.visible;
	    };
	    title = "Read AVS Field Filename";
	    searchPattern = "$XP_PATH<0>/data/field/*.fld";
	    filename => <-.filename;
	};

	string filename<export=3>;
	int portable<export=3>=1;
	int swap<export=3>=0;
	int flip<export=3>=0;

      UItoggle store_all_steps {
        parent => <-.panel;
        label  =  "Store All Steps";
        visible => (param.total_steps > 1);
        y => ((<-.file_name.y + <-.file_name.height) + 15);
        width  => <-.panel.width;
        set => <-.param.store_all_steps;
      };

      UIlabel total_step_label {
        parent => <-.panel;
        label => "Total Steps";
        y      => store_all_steps.height + store_all_steps.y + 10;
        visible => (param.total_steps > 1);
        width = 120;
        height => UIdata.UIfonts[0].lineHeight + 8;
        alignment = 1;
      };
      UIlabel current_step_label {
        parent => <-.panel;
        label => "Current Step";
        visible => (param.total_steps > 1);
        y => ((<-.total_step_label.y + <-.total_step_label.height) + 4);
        width = 120;
        height => UIdata.UIfonts[0].lineHeight + 8;
        alignment = 1;
      };
      UIfield total_step_field {
        parent => <-.panel;
        x => (<-.total_step_label.x + <-.total_step_label.width);
        y => <-.total_step_label.y;
        width = 60;
        height => <-.total_step_label.height;
        value => <-.param.total_steps;
        visible => (param.total_steps > 1);
        decimalPoints = 0;
        outputOnly = 1;
      };
      UIfield current_step_field {
        parent => <-.panel;
        x => (<-.current_step_label.x + <-.current_step_label.width);
        y => <-.current_step_label.y;
        width = 60;
        height => <-.current_step_label.height;
        value => <-.param.current_step;
        visible => (param.total_steps > 1);
        decimalPoints = 0;
        updateMode = 1;
      };
      UIbutton forward {
        parent => <-.panel;
        height = 30;
        y => ((<-.current_step_field.y + <-.current_step_field.height) + 5);
        width = 192;
        label => "Step Forward";
        visible => (param.total_steps > 1);
        do => <-.param.step_forward;
      };
      UIbutton backward {
        parent => <-.panel;
        height = 30;
        y => ((<-.forward.y + <-.forward.height) + 5);
        width = 192;
        label => "Step Backward";
        visible => (param.total_steps > 1);
        do => <-.param.step_backward;
      };
      UItoggle one_time {
        parent => <-.panel;
        y => ((<-.backward.y + <-.backward.height) + 5);
        width = 192;
        label => "One-time";
        visible => (param.total_steps > 1);
        set => <-.param.one_time;
#ifdef MSDOS
         GMOD.parse_v parse_v {
           v_commands = "do = 1;";
           trigger =>active;
           active =><-.set;
           on_inst = 0;
           relative =><-;
         };
#endif
      };
      GMOD.copy_on_change one_change_cont {
        trigger => <-.one_time.do;
        input = 0;
        output => <-.continuous.set;
        on_inst = 0;
      };
      GMOD.copy_on_change one_change_bounce {
        trigger => <-.one_time.do;
        input = 0;
        output => <-.bounce.set;
        on_inst = 0;
      };
      UItoggle continuous {
        parent => <-.panel;
        y => ((<-.one_time.y + <-.one_time.height) + 5);
        width = 192;
        label => "Continuous";
        visible => (param.total_steps > 1);
        set => <-.param.continuous;
#ifdef MSDOS
         GMOD.parse_v parse_v {
           v_commands = "do = 1;";
           trigger =>active;
           active =><-.set;
           on_inst = 0;
           relative =><-;
         };
#endif
      };
      GMOD.copy_on_change cont_change_one {
        trigger => <-.continuous.do;
        input = 0;
        output => <-.one_time.set;
        on_inst = 0;
      };
      GMOD.copy_on_change cont_change_bounce {
        trigger => <-.continuous.do;
        input = 0;
        output => <-.bounce.set;
        on_inst = 0;
      };
      UItoggle bounce {
        parent => <-.panel;
        y => ((<-.continuous.y + <-.continuous.height) + 5);
        width = 192;
        label => "Bounce";
        visible => (param.total_steps > 1);
        set => <-.param.bounce;
#ifdef MSDOS
         GMOD.parse_v parse_v {
           v_commands = "do = 1;";
           trigger =>active;
           active =><-.set;
           on_inst = 0;
           relative =><-;
         };
#endif
      };
      GMOD.copy_on_change bounce_change_one {
        trigger => <-.bounce.do;
        input = 0;
        output => <-.one_time.set;
        on_inst = 0;
      };
      GMOD.copy_on_change bounce_change_cont {
        trigger => <-.bounce.do;
        input = 0;
        output => <-.continuous.set;
        on_inst = 0;
      };
    };

    GMOD.loop loop {
      run => <-.do_loop.set_run.output;
      start_val = 1;
      end_val => <-.Read_Field_Param.total_steps;
      incr = 1;
      count => <-.Read_Field_Param.current_step;
    };

    GMOD.copy_on_change one_set_cycle {
      trigger => <-.read_field_ui.one_time.do;
      input = 0;
      output => <-.loop.cycle;
      on_inst = 0;
    };
    GMOD.copy_on_change cont_set_cycle {
      trigger => <-.read_field_ui.continuous.do;
      input = 1;
      output => <-.loop.cycle;
      on_inst = 0;
    };
    GMOD.copy_on_change bounce_set_cycle {
      trigger => <-.read_field_ui.bounce.do;
      input = 2;
      output => <-.loop.cycle;
      on_inst = 0;
    };

    macro do_loop {
      int+IPort2 one => <-.Read_Field_Param.one_time;
      int+IPort2 cont => <-.Read_Field_Param.continuous;
      int+IPort2 bounce => <-.Read_Field_Param.bounce;
      int+IPort2 total => <-.Read_Field_Param.total_steps;
      int+OPort do => ((one || cont || bounce) && (total > 1));
      GMOD.copy_on_change set_run {
        trigger => <-.do;
        input => <-.do;
        on_inst = 0;
        output<NEportLevels={0,3}>;
      };
    };

    GMOD.copy_on_change one_time_end {
      trigger => <-.loop.done;
      input = 0;
      output => <-.Read_Field_Param.one_time;
      on_inst = 0;
    };

    group Read_Field_Param <NEportLevels={0,1}> {
        int store_all_steps<export=3> = 0;
        int total_steps<export=3> = 0;
        int current_step<export=3> = 0;
        int step_forward<export=3>;
        int step_backward<export=3>;
        int one_time<export=3>;
        int continuous<export=3>;
        int bounce<export=3>;
    };

    macro TextTitle {
      Xform text {
        xform<NEportLevels={0,2}>;
        int align_horiz = 1;
        int align_vert;
        int drop_shadow;
        int background;
        int bounds;
        int underline;
        int lead_line;
        int radial;
        int do_offset;
        float offset;
        int xform_mode;
        string str<NEportLevels={3,0},export=4> => <-.<-.DVread_field.time_string;
        int nspace = 3;
        float position<export=4>[nspace] = {0.,0.7,0.99};
        int stroke = 0;
        group StrokeTextAttribs {
          int font_type;
          int style;
          int plane;
          int orient;
          int path;
          int space_mode;
          float spacing;
          float angle;
          float height;
          float expansion;
          float width;
        };
        float+write min_vec[nspace];
        float+write max_vec[nspace];
      };

      DefaultObject DefaultObject<NEportLevels={1,2}> {
        input => <-.text;
        xform => <-.text.xform;
        props => <-.DefaultProps;
        xform_mode = "Locked";
        name => name_of(<-.<-);
        pick_info => <-.DefaultPickInfo;
      };
      DefaultProps DefaultProps {
        font<NEportLevels={2,0},export=4> => "-adobe-times-bold-r-*-*-40-*-*-*-*-*-*-*";
        inherit = 0;
      };
      GDpick_info DefaultPickInfo;
    };

    DVread_field DVread_field {
	filename          => read_field_ui.filename;
	portable          => read_field_ui.portable;
	swap              => read_field_ui.swap;
	flip              => read_field_ui.flip;
	store_all         => Read_Field_Param.store_all_steps;
	store_all_visible => read_field_ui.store_all_steps.visible;
	nsteps            => Read_Field_Param.total_steps;
	stepno            => Read_Field_Param.current_step;
	forward           => Read_Field_Param.step_forward;
	backward          => Read_Field_Param.step_backward;
    };

    DataObjectNoTexture DataObject {
	in => DVread_field.out;
	Obj {
		name => name_of(<-.<-.<-);
	};
    };
    olink field<export_all=2> => DVread_field.out;
    olink time_field<export_all=2> => DVread_field.out_all;
    olink out_obj => DataObject.obj;
    olink title_obj => .TextTitle.DefaultObject;

#endif
};  // Read_Field

macro Read_Triangle {

    macro read_tri_ui {
        string filename<export=3>;

        UImod_panel panel {
            title => name_of(<-.<-.<-);
            message = "Select Read Triangle control panel.";
            parent<NEportLevels={4,0}>;
        };
        UIlabel Tri_Filename {
            parent => <-.panel;
            y = 0;
            width => 200;
            alignment = 0;
            label => "Filename (RAW/STL/SLP/TIN)";
        };
        UItext file_name {
            parent => panel;
            y => <-.Tri_Filename.y + <-.Tri_Filename.height + 5;
            text => <-.filename;
            width = 170;
            height = 32;
            showLastPosition = 1;
        };
        UIbutton visible {
            parent => <-.panel;
            x => <-.file_name.x + <-.file_name.width + 5;
            y => <-.file_name.y;
            width = 75;
            height => <-.file_name.height;
            label = "Browse...";
        };
        UIfileSB file_browser {
            GMOD.copy_on_change copy_on_change {
                trigger => <-.<-.visible.do;
                input   => <-.<-.visible.do;
                output  => <-.visible;
            };
            title = "Read Triangle Filename (RAW/STL/SLP/TIN)";
            searchPattern = "$XP_PATH<0>/data/*.*";
            filename => <-.filename;
        };
    };

    DVread_triangle DVread_triangle {
        filename => <-.read_tri_ui.filename;
    };

    DataObjectNoTexture DataObject {
	in => <-.DVread_triangle.outFld;
	Obj {
            name => name_of(<-.<-.<-);
	};
    };

    olink field<export_all=2> => DVread_triangle.outFld;
    olink out_obj => DataObject.obj;
}; // Read_Triangle

macro Read_Polygon {

    macro read_poly_ui {
        string filename<export=3>;

        UImod_panel panel {
            title => name_of(<-.<-.<-);
            message = "Select Read Polygon control panel.";
            parent<NEportLevels={4,0}>;
        };
        UIlabel Poly_Filename {
            parent => <-.panel;
            y = 0;
            width => 200;
            alignment = 0;
            label => "Filename (OBJ/PLY/VTK)";
        };
        UItext file_name {
            parent => panel;
            y => <-.Poly_Filename.y + <-.Poly_Filename.height + 5;
            text => <-.filename;
            width = 170;
            height = 32;
            showLastPosition = 1;
        };
        UIbutton visible {
            parent => <-.panel;
            x => <-.file_name.x + <-.file_name.width + 5;
            y => <-.file_name.y;
            width = 75;
            height => <-.file_name.height;
            label = "Browse...";
        };
        UIfileSB file_browser {
            GMOD.copy_on_change copy_on_change {
                trigger => <-.<-.visible.do;
                input   => <-.<-.visible.do;
                output  => <-.visible;
            };
            title = "Read Polygon Filename (OBJ/PLY/VTK)";
            searchPattern = "$XP_PATH<0>/data/*.*";
            filename => <-.filename;
        };
    };

    DVread_polygon DVread_polygon {
        filename => <-.read_poly_ui.filename;
    };

    DataObjectNoTexture DataObject {
	in => <-.DVread_polygon.outFld;
	Obj {
            name => name_of(<-.<-.<-);
	};
    };

    olink field<export_all=2> => DVread_polygon.outFld;
    olink out_obj => DataObject.obj;
}; // Read_Polygon

macro Read_DXF {

    macro read_dxf_ui {
        string filename<export=3>;

        UImod_panel panel {
            title => name_of(<-.<-.<-);
            message = "Select Read DXF control panel.";
            parent<NEportLevels={4,0}>;
        };
        UIlabel DXF_Filename {
            parent => <-.panel;
            y = 0;
            width => 200;
            alignment = 0;
            label => "Filename";
        };
        UItext file_name {
            parent => panel;
            y => <-.DXF_Filename.y + <-.DXF_Filename.height + 5;
            text => <-.filename;
            width = 170;
            height = 32;
            showLastPosition = 1;
        };
        UIbutton visible {
            parent => <-.panel;
            x => <-.file_name.x + <-.file_name.width + 5;
            y => <-.file_name.y;
            width = 75;
            height => <-.file_name.height;
            label = "Browse...";
        };
        UIfileSB file_browser {
            GMOD.copy_on_change copy_on_change {
                trigger => <-.<-.visible.do;
                input   => <-.<-.visible.do;
                output  => <-.visible;
            };
            title = "Read DXF Filename";
            searchPattern = "$XP_PATH<0>/data/*.dxf";
            filename => <-.filename;
        };
    };

    DVread_dxf DVread_dxf {
        filename => <-.read_dxf_ui.filename;
    };

    DataObjectNoTexture DataObject {
	in => <-.DVread_dxf.outFld;
	Obj {
            name => name_of(<-.<-.<-);
	};
    };

    olink field<export_all=2> => DVread_dxf.outFld;
    olink out_obj => DataObject.obj;
}; // Read_DXF

macro Print_Field {
    ilink in_field<export_all=1>;
        DVprint_params DVprint_params<NEportLevels={0,1},export=1> {
	    gridout=1;
	    cellout=1;
	    xformout=1;
	    nodesout=1;
            htmlout=1;
            trigger=1;
            allout=0;
	    nvals=1000;
	    start_index=-1;
	};

    macro print_field_ui {
	ilink in => in_field;
	DVprint_params &prtparams => <-.DVprint_params;

	UImod_panel panel {
	    title => name_of(<-.<-.<-,1);
	    message = "Print Field panel.";
	    parent<NEportLevels={4,0}>;
	};

	UIframe data_frame {
	    parent => panel;
	      y = 0;
	    width => <-.panel.clientWidth;
	    height => <-.alltoggle.y + <-.alltoggle.height + 6;
	};
	UIlabel PrtfldWin {
	    parent => data_frame;
	    y = 0;
	    width => parent.clientWidth;
	    alignment = 0;
            label = "Data Selection:";
	};
        UItoggle gridtoggle {
            parent => data_frame;
            label => "Grid";
            y => PrtfldWin.y + PrtfldWin.height;
            width => parent.clientWidth;
            set<NEportLevels={2,0},export=2> => <-.prtparams.gridout;
        };
        UItoggle celltoggle {
            parent => data_frame;
            label => "Cell";
            y => gridtoggle.y + gridtoggle.height;
            width => parent.clientWidth;
            set<NEportLevels={2,0}> => <-.prtparams.cellout;
        };
        UItoggle nodestoggle {
            parent => data_frame;
            label => "Node";
            y => celltoggle.y + celltoggle.height;
            width => parent.clientWidth;
            set<NEportLevels={2,0}> => <-.prtparams.nodesout;
        };
        UItoggle xformtoggle {
            parent => data_frame;
            label => "Xform";
            y => nodestoggle.y + nodestoggle.height;
            width => parent.clientWidth;
            set<NEportLevels={2,0}> => <-.prtparams.xformout;
        };
        UItoggle alltoggle {
            parent => data_frame;
            label => "Points";
            y => xformtoggle.y + xformtoggle.height;
            width => parent.clientWidth;
            set<NEportLevels={2,0},export=2> => <-.prtparams.allout;
        };

	UIframe values_frame {
	    parent => panel;
	    y => data_frame.y + data_frame.height + 6;
	    width => <-.panel.clientWidth;
	    height => <-.vali_field.y + <-.vali_field.height + 6;
	};
	UIlabel values_label {
	    parent => values_frame;
	    y = 0;
	    width => parent.clientWidth;
	    alignment = 0;
	    label = "Values Selection:";
	};
	UIlabel nvals_label {
	    parent => values_frame;
	    y => values_label.y + values_label.height;
	    width => panel.clientWidth*2/3;
	    alignment = 0;
	    label = "Maximum Number";
	};
        UIfield nvals_field {
            parent => values_frame;
            x => nvals_label.x + nvals_label.width;
            y => nvals_label.y;
            width => panel.clientWidth/4;
            value<NEportLevels={2,0},export=2> => <-.prtparams.nvals;
            updateMode = 1;
            mode = 1;
        };
	UIlabel vali_label {
	    parent => values_frame;
	    y => nvals_field.y + nvals_field.height;
	    width => panel.clientWidth*2/3;
	    alignment = 0;
	    label = "Start Index (< 0 for range)";
	};
        UIfield vali_field {
            parent => values_frame;
            x => vali_label.x + vali_label.width;
            y => vali_label.y;
            width => panel.clientWidth/4;
            value<NEportLevels={2,0},export=2> => <-.prtparams.start_index;
            updateMode = 1;
            mode = 1;
        };

	UIframe output_frame {
	    parent => panel;
	    y => values_frame.y + values_frame.height + 6;
	    width => <-.panel.clientWidth;
	    height => <-.htmltoggle.y + <-.htmltoggle.height + 6;
	};
	UIlabel output_label {
	    parent => output_frame;
	    y = 0;
	    width => parent.clientWidth;
	    alignment = 0;
	    label = "Output:";
	};
	UIlabel UCD_Filename {
	    parent => output_frame;
	    y => output_label.y + output_label.height;
	    width => parent.clientWidth;
	    alignment = 0;
	    label = "Filename";
	};
	UItext file_name {
	    parent => output_frame;
	    y => UCD_Filename.y + UCD_Filename.height;
	    width = 170;
            text<NEportLevels={2,0},export=2> => <-.prtparams.filename;
            showLastPosition = 1;
	};
        UIbutton visible {
	    parent => output_frame;
	    x => file_name.x + file_name.width + 5;
	    y => file_name.y;
	    width = 75;
	    height => <-.file_name.height;
	    label = "Browse...";
	};
        UItoggle htmltoggle {
            parent => output_frame;
            label => "Print HTML file";
            y => file_name.y + file_name.height + 4;
            width => parent.clientWidth;
            set<NEportLevels={2,0}> => <-.prtparams.htmlout;
        };
	UIfileSB file_browser {
	    GMOD.copy_on_change copy_on_change {
               trigger => <-.<-.visible.do;
               input => <-.<-.visible.do;
               output => <-.visible;
	    };
	    title = "Output Filename";
	    searchPattern = "";
	    filename<NEportLevels={2,0},export=2> => <-.prtparams.filename;
	};

        UIbutton trigger {
            parent => panel;
            label => "Click to Start Printing";
            y => output_frame.y + output_frame.height + 10;
            width => parent.clientWidth;
            do<NEportLevels={2,0}> => <-.prtparams.trigger;
        };

        UIlabel UIPrtData {
	    parent => <-.panel;
	    y => trigger.y + trigger.height + 6;
	    width => parent.clientWidth;
	    alignment = 0;
            label = "Node/Cell Data Attributes";
	};

        UItext UIgridtxt {
            parent => <-.panel;
            text<NEportLevels={2,2}> => <-.prtparams.notes;
            y => UIPrtData.y + UIPrtData.height;
            width => parent.clientWidth;
            height = 160;
            multiLine = 1;
            outputOnly = 1;
        };

	UIlabel UIPrtStatus {
	    parent => <-.panel;
	    y => UIgridtxt.y + UIgridtxt.height + 10;
	    width => parent.clientWidth;
	    alignment = 0;
            label = "Printing Status";
	};

        UItext UItext {
            parent => <-.panel;
            text<NEportLevels={2,2}> => <-.prtparams.message;
            y => UIPrtStatus.y + UIPrtStatus.height;
            width => parent.clientWidth;
            outputOnly = 1;
        };
    };

    DVprint_field DVprint_field {
	DVprint_params => <-.DVprint_params;
	field_to_print => <-.in_field;
    };
}; // Print_Field

macro Read_UCD {

#ifdef OLD_UCD_READER
    macro read_ucd_ui {
	UImod_panel panel {
            title => name_of(<-.<-.<-,1);
	    message = "Select read ucd control panel.";
	    parent<NEportLevels={4,0}>;
	};
	UIlabel UCD_Filename {
	    parent => <-.panel;
	    y = 0;
	    width => 200;
	    alignment = 0;
	};
	UItext file_name {
	    parent => panel;
	    y => UCD_Filename.y + UCD_Filename.height + 5;
	    text => <-.filename;
	    width = 170;
            showLastPosition = 1;
	};
	UIbutton visible {
	    parent => panel;
	    x => file_name.x + file_name.width + 5;
	    y => file_name.y;
	    width = 75;
	    height => <-.file_name.height;
	    label = "Browse...";
	};

	UIfileSB file_browser {
	    GMOD.copy_on_change copy_on_change {
               trigger => <-.<-.visible.do;
               input => <-.<-.visible.do;
               output => <-.visible;
	    };
	    title = "Read UCD Filename";
	    searchPattern = "$XP_PATH<0>/data/ucd/*.inp";
	    filename => <-.filename;
	};

	string filename<export=3>;
    };
    DVread_ucd DVread_ucd {
	filename => read_ucd_ui.filename;
    };

    DataObjectNoTexture DataObject {
	in => DVread_ucd.out;
	Obj {
		name => name_of(<-.<-.<-);
	};
    };
    olink field<export_all=2> => DVread_ucd.out;
    olink out_obj => DataObject.obj;

#else	// new multi-timestep reader from KGT

    macro read_ucd_ui {
      group &param<NEportLevels={2,0}> => <-.Read_UCD_Param;
      UImod_panel panel {
        title => name_of(<-.<-.<-);
        message = "Select Read UCD control panel.";
        parent<NEportLevels={4,0}>;
      };
      UIlabel UCD_Filename {
        parent => <-.panel;
        y = 0;
        width => 200;
        alignment = 0;
      };
      UItext file_name {
        parent => panel;
        y => <-.UCD_Filename.y + <-.UCD_Filename.height + 5;
        text => <-.filename;
        width = 170;
        height = 32;
        showLastPosition = 1;
      };
      UIbutton visible {
        parent => <-.panel;
        x => <-.file_name.x + <-.file_name.width + 5;
        y => <-.file_name.y;
        width = 75;
        height => <-.file_name.height;
        label = "Browse...";
      };

      UIfileSB file_browser {
        GMOD.copy_on_change copy_on_change {
          trigger => <-.<-.visible.do;
          input => <-.<-.visible.do;
          output => <-.visible;
        };
        title = "Read UCD Filename";
        searchPattern = "$XP_PATH<0>/data/ucd/*.inp";
        filename => <-.filename;
      };
      string filename<export=3>;

      UItoggle store_all_steps {
        parent => <-.panel;
        label => "Store All Steps";
        visible => (param.total_steps > 1);
        y => ((<-.file_name.y + <-.file_name.height) + 10);
        width = 192;
        set => <-.param.store_all_steps;
      };

      UIlabel total_step_label {
        parent => <-.panel;
        label => "Total Steps";
        visible => (param.total_steps > 1);
        y => ((<-.store_all_steps.y + <-.store_all_steps.height) + 15);
        height => UIdata.UIfonts[0].lineHeight + 8;
        width = 120;
        alignment = 1;
      };
      UIlabel current_step_label {
        parent => <-.panel;
        label => "Current Step";
        visible => (param.total_steps > 1);
        y => ((<-.total_step_label.y + <-.total_step_label.height) + 10);
        width = 120;
        height => UIdata.UIfonts[0].lineHeight + 8;
        alignment = 1;
      };
      UIfield total_step_field {
        parent => <-.panel;
        x => (<-.total_step_label.x + <-.total_step_label.width);
        y => <-.total_step_label.y;
        width = 60;
        height => <-.total_step_label.height;
        value => <-.param.total_steps;
        visible => (param.total_steps > 1);
        decimalPoints = 0;
        outputOnly = 1;
      };
      UIfield current_step_field {
        parent => <-.panel;
        x => (<-.current_step_label.x + <-.current_step_label.width);
        y => <-.current_step_label.y;
        width = 60;
        height => <-.current_step_label.height;
        value => <-.param.current_step;
        visible => (param.total_steps > 1);
        decimalPoints = 0;
        updateMode = 1;
      };
      UIbutton forward {
        parent => <-.panel;
        height = 30;
        y => ((<-.current_step_field.y + <-.current_step_field.height) + 5);
        width = 192;
        label => "Step Forward";
        visible => (param.total_steps > 1);
        do => <-.param.step_forward;
      };
      UIbutton backward {
        parent => <-.panel;
        height = 30;
        y => ((<-.forward.y + <-.forward.height) + 5);
        width = 192;
        label => "Step Backward";
        visible => (param.total_steps > 1);
        do => <-.param.step_backward;
      };
      UItoggle one_time {
        parent => <-.panel;
        y => ((<-.backward.y + <-.backward.height) + 5);
        width = 192;
        label => "One-time";
        visible => (param.total_steps > 1);
        set => <-.param.one_time;
#ifdef MSDOS
         GMOD.parse_v parse_v {
           v_commands = "do = 1;";
           trigger =>active;
           active =><-.set;
           on_inst = 0;
           relative =><-;
         };
#endif
      };
      GMOD.copy_on_change one_change_cont {
        trigger => <-.one_time.do;
        input = 0;
        output => <-.continuous.set;
        on_inst = 0;
      };
      GMOD.copy_on_change one_change_bounce {
        trigger => <-.one_time.do;
        input = 0;
        output => <-.bounce.set;
        on_inst = 0;
      };
      UItoggle continuous {
        parent => <-.panel;
        y => ((<-.one_time.y + <-.one_time.height) + 5);
        width = 192;
        label => "Continuous";
        visible => (param.total_steps > 1);
        set => <-.param.continuous;
#ifdef MSDOS
         GMOD.parse_v parse_v {
           v_commands = "do = 1;";
           trigger =>active;
           active =><-.set;
           on_inst = 0;
           relative =><-;
         };
#endif
      };
      GMOD.copy_on_change cont_change_one {
        trigger => <-.continuous.do;
        input = 0;
        output => <-.one_time.set;
        on_inst = 0;
      };
      GMOD.copy_on_change cont_change_bounce {
        trigger => <-.continuous.do;
        input = 0;
        output => <-.bounce.set;
        on_inst = 0;
      };
      UItoggle bounce {
        parent => <-.panel;
        y => ((<-.continuous.y + <-.continuous.height) + 5);
        width = 192;
        label => "Bounce";
        visible => (param.total_steps > 1);
        set => <-.param.bounce;
#ifdef MSDOS
         GMOD.parse_v parse_v {
           v_commands = "do = 1;";
           trigger =>active;
           active =><-.set;
           on_inst = 0;
           relative =><-;
         };
#endif
      };
      GMOD.copy_on_change bounce_change_one {
        trigger => <-.bounce.do;
        input = 0;
        output => <-.one_time.set;
        on_inst = 0;
      };
      GMOD.copy_on_change bounce_change_cont {
        trigger => <-.bounce.do;
        input = 0;
        output => <-.continuous.set;
        on_inst = 0;
      };
    };

    GMOD.loop loop{
      run => <-.do_loop.set_run.output;
      start_val = 1;
      end_val => <-.Read_UCD_Param.total_steps;
      incr = 1;
      count => <-.Read_UCD_Param.current_step;
    };

    GMOD.copy_on_change one_set_cycle {
      trigger => <-.read_ucd_ui.one_time.do;
      input = 0;
      output => <-.loop.cycle;
      on_inst = 0;
    };
    GMOD.copy_on_change cont_set_cycle {
      trigger => <-.read_ucd_ui.continuous.do;
      input = 1;
      output => <-.loop.cycle;
      on_inst = 0;
    };
    GMOD.copy_on_change bounce_set_cycle {
      trigger => <-.read_ucd_ui.bounce.do;
      input = 2;
      output => <-.loop.cycle;
      on_inst = 0;
    };

    macro do_loop {
      int+IPort2 one => <-.Read_UCD_Param.one_time;
      int+IPort2 cont => <-.Read_UCD_Param.continuous;
      int+IPort2 bounce => <-.Read_UCD_Param.bounce;
      int+IPort2 total => <-.Read_UCD_Param.total_steps;
      int+OPort do => ((one || cont || bounce) && (total > 1));
      GMOD.copy_on_change set_run {
        trigger => <-.do;
        input => <-.do;
        on_inst = 0;
        output<NEportLevels={0,3}>;
      };
    };

    GMOD.copy_on_change one_time_end {
      trigger => <-.loop.done;
      input = 0;
      output => <-.Read_UCD_Param.one_time;
      on_inst = 0;
    };

    group Read_UCD_Param <NEportLevels={0,1}> {
        int store_all_steps<export=3> = 0;
        int total_steps<export=3> = 0;
        int current_step<export=3> = 0;
        int step_forward<export=3>;
        int step_backward<export=3>;
        int one_time<export=3>;
        int continuous<export=3>;
        int bounce<export=3>;
    };

    macro TextTitle {
      Xform text {
        xform<NEportLevels={0,2}>;
        int align_horiz = 1;
        int align_vert;
        int drop_shadow;
        int background;
        int bounds;
        int underline;
        int lead_line;
        int radial;
        int do_offset;
        float offset;
        int xform_mode;
        string str<NEportLevels={3,0},export=4> => <-.<-.DVread_ucd.step_title;
        int nspace = 3;
        float position<export=4>[nspace] = {0.,0.7,0.99};
        int stroke = 0;
        group StrokeTextAttribs {
          int font_type;
          int style;
          int plane;
          int orient;
          int path;
          int space_mode;
          float spacing;
          float angle;
          float height;
          float expansion;
          float width;
        };
        float+write min_vec[nspace];
        float+write max_vec[nspace];
      };
      DefaultObject DefaultObject<NEportLevels={1,2}> {
        input => <-.text;
        xform => <-.text.xform;
        props => <-.DefaultProps;
        xform_mode = "Locked";
        name => name_of(<-.<-);
        pick_info => <-.DefaultPickInfo;
      };
      DefaultProps DefaultProps {
        font<NEportLevels={2,0},export=4> => "-adobe-times-bold-r-*-*-40-*-*-*-*-*-*-*";
        inherit = 0;
      };
      GDpick_info DefaultPickInfo;
    };

    DVread_ucd DVread_ucd {
	filename          => read_ucd_ui.filename;
	total		  => Read_UCD_Param.total_steps;
	store_all         => Read_UCD_Param.store_all_steps;
	store_all_visible => read_ucd_ui.store_all_steps.visible;
	current_step      => Read_UCD_Param.current_step;
	forward           => Read_UCD_Param.step_forward;
	backward          => Read_UCD_Param.step_backward;
    };

    DataObjectNoTexture DataObject {
	in => DVread_ucd.out;
	Obj {
		name => name_of(<-.<-.<-);
	};
    };
    olink field<export_all=2> => DVread_ucd.out;
    olink time_field<export_all=2> => DVread_ucd.out_all;
    olink out_obj => DataObject.obj;
    olink title_obj => .TextTitle.DefaultObject;

#endif
}; // Read_UCD

// Reads spreadsheet-type text tables, allowing the user
// to control what happens to each column.
//
// Formerly Read_Column_File
macro Read_Text_Columns {
    group DVtable_read_param {	// its really just a template
	string+IPort2+OPort2 	filename;
	int+IPort2+OPort2	init_file;
	string			user_delim;
	string			delimiters[];
	int+IPort2+OPort2	delim_ind;
	int+IPort2+OPort2	header;
	int+IPort2+OPort2	skip_lines;
	int+IPort2+OPort2	index_column;
	DVtable_column+IPort2+OPort2	columns[ncol];
	int+IPort2+OPort2	ncol;
	int+IPort2+OPort2	tbl_nrow;
	int+IPort2+OPort2	tbl_ncol;
	string+IPort2+OPort2 	col_names[ncol]=>columns.name;
    };

    DVtable_read_param param<export_all=2> {
	header = 0;
	skip_lines = 0;
	user_delim = " ";
	delimiters[] => {" ","\t", ",", ";", ":", user_delim};
	delim_ind = 0;
	init_file = 1;
	ncol = 0;
	index_column = 0;
    };

    DVtable_read_init  DVtable_read_init {
	DVtable_read_param &param=> <-.param;
	init_file =>param.init_file;
	filename => param.filename;
	delimiter => param.delimiters[param.delim_ind];
	header => param.header;
	skip_lines => param.skip_lines;
	&ncol => param.ncol;
	&out => param.columns;
    };
    DVtable_read DVtable_read {
	DVtable_read_param &param=> <-.param;
	columns => param.columns;
	tbl_nrow => param.tbl_nrow;
	tbl_ncol => param.tbl_ncol;
	filename => param.filename;
	delimiter => param.delimiters[param.delim_ind];
	header => param.header;
	skip_lines => param.skip_lines;
	index_column => param.index_column;
    };

    GMOD.instancer instancer {
	Value => UIpanel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => read_table_ui;
    };
    UImod_panel UIpanel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-,1);
	message = "Select read text columns control panel.";
    };

    macro read_table_ui<instanced=0> {
	DVtable_read_param &param=> <-.param;

	ilink UIpanel  => <-.UIpanel;
	UIlabel Filename {
	    parent => <-.UIpanel;
	    y = 0;
	    width => 200;
	    alignment = 0;
	};
	UItext file_name {
	    parent => UIpanel;
	    y => Filename.y + Filename.height + 5;
	    text => <-.param.filename;
	    width = 170;
            showLastPosition = 1;
	};
	UIbutton visible {
	    parent => UIpanel;
	    x => file_name.x + file_name.width + 5;
	    y => file_name.y;
	    width = 75;
	    height => <-.file_name.height;
	    label = "Browse...";
	};
	UIfileSB file_browser {
	    GMOD.copy_on_change copy_on_change {
               trigger => <-.<-.visible.do;
               input => <-.<-.visible.do;
               output => <-.visible;
	    };
	    title = "Filename";
	    searchPattern = "$XP_PATH<0>/data/*.*";
	    filename => <-.param.filename;
	};
	UIfieldTypein skip_typein {
	    UIparent => <-.UIpanel;
	    flabel = "skip lines";
	    fval => <-.param.skip_lines;
	    field.mode = 1;
	    label.alignment = 0;
	    y		=> visible.y + visible.height+10;
	};
	UItoggle header_toggle {
	    parent => <-.UIpanel;
	    label  =  "has header line";
	    set    => param.header;
	    y	   =>  <-.skip_typein.y + <-.skip_typein.height+4;
	    width  => <-.UIpanel.width;
	    // color.backgroundColor = "red";
	};
	UIoptionMenuLabel   radio_box_delim {
	    parent => <-.UIpanel;
	    labels => {"space","tab", ",", ";", ":", "user"};
	    &selectedItem => <-.param.delim_ind;
	    visible => <-.UIpanel.visible;
	    title = "column separator";
	    y		=> <-.header_toggle.y + <-.header_toggle.height + 6;
	    width	=> <-.UIpanel.width;
	};
	UItextTypein user_delim {
	    UIparent => <-.UIpanel;
	    stext => <-.param.user_delim;
	    slabel => "user separator";
	    text_label.width = 90;
	    text_label.alignment = 0;
	    text_label.active=>(<-.<-.param.delim_ind==5);
	    text.active=>(<-.<-.param.delim_ind==5);
	    text.x = 106;
	    text.width = 60;
	    panel.y => <-.<-.radio_box_delim.y + <-.<-.radio_box_delim.height + 4;
	};
	UItoggle init_toggle {
	    parent => <-.UIpanel;
	    label  =  "columns setup from file";
	    set    => param.init_file;
	    y	   =>  <-.user_delim.panel.y + <-.user_delim.panel.height+12;
	    width  => <-.UIpanel.width;
	    // color.backgroundColor = "red";
	};
	UItoggle index_toggle {
	    parent => <-.UIpanel;
	    label  =  "generate index column";
	    set    => param.index_column;
	    y	   => <-.init_toggle.y +<-.init_toggle.height+10;
	    width  => <-.UIpanel.width;
	    // color.backgroundColor = "red";
	};
	UIfieldTypein ncol_typein {
	    UIparent => <-.UIpanel;
	    flabel = "# columns in file";
	    fval => <-.param.ncol;
	    field.mode = 1;
	    label.alignment = 0;
	    label.width => (<-.panel.width) * 0.5;
	    field.x => label.width + 1;
	    y		=> <-.index_toggle.y +<-.index_toggle.height+14;
	};

	UIoptionMenuLabel   option_menu_column {
		parent => <-.UIpanel;
		labels => <-.param.col_names;
		selectedItem = 0;
		visible => <-.UIpanel.visible;
		title = "Columns Setup";
		width	=> <-.UIpanel.width;
		x = 0;
		y => <-.ncol_typein.y + <-.ncol_typein.height+4;
		UIoptionMenu.active => (<-.<-.param.ncol > 0);
	};
	group  column_set {
		UIframe UIframe_column {
        	  	parent => <-.<-.UIpanel;
			x = 0;
	          	y => <-.<-.option_menu_column.y + <-.<-.option_menu_column.height+16;
        	  	width	=> <-.<-.UIpanel.width;
          		height = 195;
       		};
		UIpanel UIpanel_column {
			parent => <-.UIframe_column;
			x = 0;
			y = 0;
			width	=> <-.UIframe_column.width;
			height  => <-.UIframe_column.height-5;
			active => (<-.<-.param.ncol > 0);
		};

		UItoggle read_toggle {
    			parent => <-.UIpanel_column;
			visible => <-.UIpanel_column.visible;
	    		label = "read column";
    			&set+nres => <-.<-.param.columns[<-.<-.option_menu_column.selectedItem].use;
    			x	= 0;
	    		y	= 0;
    			width	=> <-.UIpanel_column.width;
		};
	   	UItextTypein column_name {
	    		UIparent => <-.UIpanel_column;
			stext => <-.<-.param.columns[<-.<-.option_menu_column.selectedItem].name;
	    		slabel => "column name";
	    		text_label.width = 90;
	    		text_label.alignment = 0;
	    		text.x = 100;
	    		text.width = 130;
	    		panel.y => <-.<-.read_toggle.y + <-.<-.read_toggle.height + 4;
		};
		UIoptionMenuLabel  radio_box_type {
	        	parent => <-.UIpanel_column;
			labels => {"byte","short","int","float","double", "string", "long"};
			selectedItem => <-.<-.param.columns[<-.<-.option_menu_column.selectedItem].type;
			visible => <-.UIpanel_column.visible;
			title = "data type";
			width	=> <-.UIpanel_column.width;
			x = 0;
			y => <-.column_name.panel.y + <-.column_name.panel.height+6;
		};
		UIfieldTypein null_typein {
	    		UIparent => <-.UIpanel_column;
	    		flabel = "null value";
	    		fval => <-.<-.param.columns[<-.<-.option_menu_column.selectedItem].null_value;
			y => <-.radio_box_type.y + <-.radio_box_type.height+10;
		};

	  };
	  UIbutton read_button {
            parent => <-.UIpanel;
            label => "Read File";
	    y => <-.option_menu_column.y + <-.option_menu_column.height+230;
            do => <-.<-.DVtable_read.do;
	    // color.backgroundColor = "red";
         };
    };
    olink table<export_all=2> => DVtable_read.out;
    Mesh_Unif+Dim2+Space2+Node_Data+Scalar+OPort2 field<export_all=2> {
	dims=> {param.tbl_nrow, param.tbl_ncol};
	points => {{0,0},{dims[0]-1,dims[1]-1}};
	nnode_data = 1;
	node_data {
		values+nres=> concat_array(DVtable_read.out.values);
	};
    };
    DataObject DataObject {
	in => <-.field;
	Obj {
		name => name_of(<-.<-.<-);
	};
    };
    olink out_obj => DataObject.obj;
}; // Read_Text_Columns

// Reads spreadsheet-type text tables, treating the table as a
// 2D grid in which all the columns are handled in the same manner.
// Other than than column headers and row headers, the data should
// all numerical.
macro Read_Text_Grid {
    group DVgrid_read_param {	// its really just a template
	string+IPort2+OPort2 	filename;
	string			user_delim;
	int+IPort2+OPort2	delim_ind;
	int+IPort2+OPort2	skip_lines;
	int+IPort2+OPort2	col_header;
	int+IPort2+OPort2	row_header;
	int+IPort2+OPort2	type;
    };

    DVgrid_read_param param<export_all=2> {
	user_delim = " ";
	delim_ind = 1;	// tab
	skip_lines = 0;
	col_header = 0;
	row_header = 0;
	type = 5;	// from file
    };

    DVgrid_read DVgrid_read {
        // New parameter
	int+read+notify+req	do;

	DVgrid_read_param &param => <-.param;

	// translate from the menu choices to a DTYPE
	// Read_Column_file does this in C code.
	int map_to_dtype[] => { 1, 2, 3, 4, 5, 13, 6};

	// translate from the menu choices to the real character
	string delimiters[] => {" ", "\t", ",", ";", ":", .param.user_delim};

	filename   => .param.filename;
	delimiter  => .delimiters[.param.delim_ind];
	skip_lines => .param.skip_lines;
	col_header => .param.col_header;
	row_header => .param.row_header;
	data_type  => .map_to_dtype[.param.type];

	// Need to repeat this definition to insure that the +req
	// on "do" is respected.
	omethod+notify_inst+notify_val upd_func<status=1> = "DVgrid_read_update";
    };

    GMOD.instancer instancer {
	Value => UIpanel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => read_grid_ui;
    };
    UImod_panel UIpanel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-,1);
	message = "Select read text grid control panel.";
    };

    macro read_grid_ui<instanced=0> {
	DVgrid_read_param &param=> <-.param;

	ilink UIpanel  => <-.UIpanel;
	UIlabel Filename {
	    parent => <-.UIpanel;
	    y = 0;
	    width => 200;
	    alignment = 0;
	};
	UItext file_name {
	    parent => UIpanel;
	    y => Filename.y + Filename.height + 5;
	    text => <-.param.filename;
	    width = 170;
            showLastPosition = 1;
	};
	UIbutton browse {
	    parent => UIpanel;
	    x => file_name.x + file_name.width + 5;
	    y => file_name.y;
	    width = 75;
	    height => <-.file_name.height;
	    label = "Browse...";
	};
	UIfileSB file_browser {
	    GMOD.copy_on_change copy_on_change {
               trigger => <-.<-.browse.do;
               input => <-.<-.browse.do;
               output => <-.visible;
	    };
	    title = "Filename";
	    searchPattern = "$XP_PATH<0>/data/*.*";
	    filename => <-.param.filename;
	};
	UIfieldTypein skip_typein {
	    UIparent => <-.UIpanel;
	    flabel  = "skip initial lines";
	    fval    => <-.param.skip_lines;
	    field.mode = 1;
	    label.alignment = 0;
	    y	    => browse.y + browse.height+10;
	};
	UItoggle col_header_toggle {
	    parent  => <-.UIpanel;
	    label   =  "has column header line on top";
	    set     => param.col_header;
	    y	    =>  <-.skip_typein.y + <-.skip_typein.height+4;
	    width   => <-.UIpanel.width;
	};
	UItoggle row_header_toggle {
	    parent  => <-.UIpanel;
	    label   =  "has row headers on left";
	    set     => param.row_header;
	    y	    =>  <-.col_header_toggle.y + <-.col_header_toggle.height+4;
	    width   => <-.UIpanel.width;
	};
	UIoptionMenuLabel   menu_delim {
	    parent => <-.UIpanel;
	    labels => {"space","tab", ",", ";", ":", "user"};
	    &selectedItem => <-.param.delim_ind;
	    visible => <-.UIpanel.visible;
	    title = "column separator";
	    y		=> <-.row_header_toggle.y + <-.row_header_toggle.height + 10;
	    width	=> <-.UIpanel.width;
	};
	UItextTypein user_delim {
	    UIparent => <-.UIpanel;
	    stext => <-.param.user_delim;
	    slabel => "user separator";
	    text_label.width = 90;
	    text_label.alignment = 0;
	    text_label.active=>(<-.<-.param.delim_ind==5);
	    text.active=>(<-.<-.param.delim_ind==5);
	    text.x = 106;
	    text.width = 60;
	    panel.y => <-.<-.menu_delim.y + <-.<-.menu_delim.height + 4;
	};
	UIoptionMenuLabel  menu_type {
	    parent => <-.UIpanel;
	    labels => {"byte", "short", "int", "float", "double", "from file", "long"};
	    selectedItem => <-.<-.param.type;
	    //visible => <-.UIpanel.visible;
	    title = "data type";
	    width	=> <-.UIpanel.width;
	    x = 0;
	    y => <-.user_delim.panel.y + <-.user_delim.panel.height+6;
	};
	UIbutton read_button {
            parent => <-.UIpanel;
            label => "Read File";
	    y => <-.menu_type.y + <-.menu_type.height+30;
            do => <-.<-.DVgrid_read.do;
        };
    };

    olink field => DVgrid_read.out;
    DataObject DataObject {
	in => <-.field;
	Obj {
		name => name_of(<-.<-.<-);
	};
    };
    olink out_obj => DataObject.obj;
}; // Read_Text_Grid


// You have a array/grid type dataset that has been written
// out to a file as a continuous sequence of ascii values,
// with little or no formatting information.  User must use the
// UI to specify things like dimensions and data type.
macro Read_Text_Sequence {
    group DVread_seq_param {	// its really just a template
	string+IPort2+OPort2 	filename;
	int+IPort2+OPort2	skip_lines;
	int+IPort2+OPort2	ndim;
	long+IPort2+OPort2	dims[ndim];
	int+IPort2+OPort2	delim_ind;
	int+IPort2+OPort2	ncomp;
	DVread_seq_var+IPort2+OPort2	comps[ncomp];
    };

    DVread_seq_param param<export_all=2> {
        skip_lines = 0;
        ndim = 3;
	delim_ind = 0;	// space (index into menu choices)
        ncomp = 1;
	comps {
	    veclen = 1;
	    data_type = 5;	// from file (index into menu choices)
	};
    };

    DVread_seq_ascii DVread_seq_ascii {
        // New parameter
	int+read+notify+req	do;

	DVread_seq_param &param => <-.param;

	// translate from the menu choices to a DTYPE
	int map_to_dtype[] => { 1, 2, 3, 4, 5, 13, 6};

	// translate from the menu choices to the real character
	string delimiters[] =>{" ","\t", ",", ";", ":"};

	filename   => .param.filename;
	skip_lines => .param.skip_lines;
	ndim       => .param.ndim;
	&dims      => .param.dims;
	delimiter  => .delimiters[.param.delim_ind];
	ncomp      => .param.ncomp;
	//comps      => .param.comps;
	comps[.param.ncomp] {
            // Eeeek! A lot of mess to do the type mapping trick ...
	    int my_index => index_of(comps);
	    veclen => <-.param.comps[my_index].veclen;
	    data_type => <-.map_to_dtype[<-.param.comps[my_index].data_type];
	    label => <-.param.comps[my_index].label;
	    units => <-.param.comps[my_index].units;
	};

	// Need to repeat this definition to insure that the +req
	// on "do" is respected.
	omethod+notify_inst+notify_val read_update<status=1> =
		"DVread_seq_ascii_update";
    };

    GMOD.instancer instancer {
	Value => UIpanel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => read_seq_ui;
    };
    UImod_panel UIpanel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-,1);
	message = "Select read text sequence control panel.";
    };

    macro read_seq_ui<instanced=0> {
	DVread_seq_param &param=> <-.param;
	ilink UIpanel  => <-.UIpanel;
#ifdef MSDOS
        int+nres field_height => UIdata.UIfonts[0].lineHeight+4;
#else
	// This is the default setting for UIfield, and unfortunately
	// it looks terrible if you try a smaller setting than this
        // with common default fonts for X11.
        int field_height = 30;
#endif
	UIlabel Filename {
	    parent => <-.UIpanel;
	    y = 0;
	    width => 200;
	    alignment = 0;
	};
	UItext file_name {
	    parent => UIpanel;
	    y => Filename.y + Filename.height + 4;
	    text => <-.param.filename;
	    width = 170;
            showLastPosition = 1;
	};
	UIbutton browse {
	    parent => UIpanel;
	    x => file_name.x + file_name.width + 5;
	    y => file_name.y;
	    width = 75;
	    height => <-.file_name.height;
	    label = "Browse...";
	};
	UIfileSB file_browser {
	    GMOD.copy_on_change copy_on_change {
               trigger => <-.<-.browse.do;
               input => <-.<-.browse.do;
               output => <-.visible;
	    };
	    title = "Filename";
	    searchPattern = "$XP_PATH<0>/data/*.*";
	    filename => <-.param.filename;
	};
	UIfieldTypein skip_typein {
	    UIparent => <-.UIpanel;
	    flabel  = "skip initial lines";
	    fval    => <-.param.skip_lines;
	    y       => browse.y + browse.height+4;
	    height      => field.height+4;	// default is 40
	    label.width => <-.panel.width * .7;
	    label.alignment = "left";
	    field.x     => <-.label.x + <-.label.width;
	    field.width => <-.panel.width - .x;
	    field.height => field_height;
	    field.mode  = "integer";
	};
	UIfieldTypein ndim_typein {
	    UIparent => <-.UIpanel;
#ifdef MSDOS
	    flabel  = "number of dimensions";
#else
	    flabel  = "number of dims";
#endif
	    fval    => <-.param.ndim;
	    fmin    = 1;
	    fmax    = 4;
	    y       => skip_typein.y + skip_typein.height;
	    height  => field.height+4;
	    label.width => <-.panel.width * .7;
	    label.alignment = "left";
	    field.x     => <-.label.x + <-.label.width;
	    field.width => <-.panel.width - .x;
	    field.height => <-.<-.field_height;
	    field.mode  = "integer";
	    field.nullString = "";
	};
	UIfieldTypein dim1_typein {
	    UIparent => <-.UIpanel;
	    flabel  = "dimension 1";
	    fval    => <-.param.dims[0];
	    y       => ndim_typein.y + ndim_typein.height;
	    height  => field.height+4;
	    label.alignment = "left";
	    label.active => is_valid(<-.<-.param.ndim);
	    label.width => <-.panel.width * .7;
	    field.x     => <-.label.x + <-.label.width;
	    field.width => <-.panel.width - .x;
	    field.height => <-.<-.field_height;
	    field.mode  = "integer";
	    field.active => <-.label.active;
	    field.nullString = "";
	};
	UIfieldTypein dim2_typein {
	    UIparent => <-.UIpanel;
	    flabel  = "dimension 2";
	    fval+nres => <-.param.dims[1];
	    y       => <-.dim1_typein.y + <-.dim1_typein.height;
	    height  => field.height+4;
	    label.alignment = "left";
	    label.active => is_valid(<-.<-.param.ndim) && (<-.<-.param.ndim > 1);
	    label.width => <-.panel.width * .7;
	    field.x     => <-.label.x + <-.label.width;
	    field.width => <-.panel.width - .x;
	    field.mode  = "integer";
	    field.active => <-.label.active;
	    field.nullString = "";
	    field.height => <-.<-.field_height;
	};
	UIfieldTypein dim3_typein {
	    UIparent => <-.UIpanel;
	    flabel  = "dimension 3";
	    fval+nres => <-.param.dims[2];
	    y       => dim2_typein.y + dim2_typein.height;
	    height  => field.height+4;
	    label.alignment = "left";
	    label.active => is_valid(<-.<-.param.ndim) && (<-.<-.param.ndim > 2);
	    label.width => <-.panel.width * .7;
	    field.x     => <-.label.x + <-.label.width;
	    field.width => <-.panel.width - .x;
	    field.height => <-.<-.field_height;
	    field.mode  = "integer";
	    field.active => <-.label.active;
	    field.nullString = "";
	};

	UIoptionMenuLabel delim_menu {
	    parent => <-.UIpanel;
	    labels => {"space", "tab", ", (comma)", "; (semi-colon)", ": (colon)"};
	    selectedItem => <-.param.delim_ind;
	    title = "separator  ";
	    y       => dim3_typein.y + dim3_typein.height;
	    width => .parent.clientWidth - 8;
	};

	UIfieldTypein ncomp_typein {
	    UIparent => <-.UIpanel;
#ifdef MSDOS
	    flabel  = "number of variables";
#else
	    flabel  = "number of vars";
#endif
	    fval    => <-.param.ncomp;
	    fmin    = 1;
	    //height  = 34;
	    height  => field.height+4;
	    y       => delim_menu.y + delim_menu.height+2;
	    label.width => <-.panel.width * .7;
	    label.alignment = "left";
	    field.x     => <-.label.x + <-.label.width;
	    field.width => <-.panel.width - .x;
	    field.height => <-.<-.field_height;
	    field.mode = "integer";
	};

        UIscrolledWindow varScroll {
	    parent => <-.UIpanel;
            x = 0;
            y => (<-.ncomp_typein.y + <-.ncomp_typein.height) + 3;
            width => parent.clientWidth;
            //virtualWidth => .clientWidth;
            virtualWidth => .width;
            virtualHeight+nres => 10 +
                                  <-.variable_ui[0].frame.height + 
                                  max_array(<-.variable_ui.frame.y );
#ifdef MSDOS
            height => switch((.virtualHeight < 300)+1, 301, .virtualHeight+1);
#else
            height = 400;
#endif
        };

	group variable_ui[param.ncomp] {

	    int my_index => index_of(variable_ui);
	    DVread_seq_var &var => <-.<-.param.comps[index_of(variable_ui)];

            UIframe frame {
		parent => <-.<-.varScroll;
		x = 0;
		y => 1+height*<-.my_index;
	        width => parent.clientWidth;
		height+nres => <-.units_text.y + 40;
            };
	    UIlabel variable_label {
		parent => <-.frame;
		label => "===  Variable: " + <-.my_index + "  ===";
		x = 0;
		y = 4;
		width => parent.clientWidth;
	    };
	    UIfieldTypein veclen_typein {
		UIparent => <-.frame;
		flabel = "vector length";
		fval   => <-.var.veclen;
		fmin   = 1;
		x = 4;
		y => <-.variable_label.y + <-.variable_label.height+4;
		//height = 34;
		height => field.height+4;
		label.width => <-.panel.width * .7;
		label.alignment = "left";
		field.x	    => <-.label.x + <-.label.width;
		field.width => <-.panel.width - .x;
		field.height => <-.<-.<-.field_height;
		field.mode  = "integer";
	    };
	    UIoptionMenuLabel data_type_menu {
		parent => <-.frame;
		labels => {"byte", "short", "int", "float", "double",
				"from file", "long"};
		selectedItem => <-.var.data_type;
		string selectedLabel => .labels[.selectedItem];
		title = "data type  ";
		x = 4;
		y => <-.veclen_typein.y + <-.veclen_typein.height+4;
		width => <-.frame.clientWidth - 8;
	    };
	    UIlabeledText label_text {
		parent => <-.frame;
		label  = "label (opt)";
		label_width => parent.clientWidth * 0.33;
		text => <-.var.label;
		x = 4;
		y => <-.data_type_menu.y + <-.data_type_menu.height+6;
		width => parent.clientWidth - 8;
		UIlabel.alignment = "left";
		UItext.height => <-.<-.<-.field_height;
	    };
	    UIlabeledText units_text {
		parent => <-.frame;
		label  = "units (opt)";
		label_width => parent.clientWidth * 0.33;
		text => <-.var.units;
		x = 4;
		y => <-.label_text.y + <-.label_text.height+2;
		width => parent.clientWidth - 8;
		UIlabel.alignment = "left";
		UItext.height => <-.<-.<-.field_height;
	    };
	};

	UIbutton read_button {
            parent => <-.UIpanel;
            label => "Read File";
	    y  => <-.varScroll.y + <-.varScroll.height+10;
            do => <-.<-.DVread_seq_ascii.do;
        };
    };

    olink field => DVread_seq_ascii.out;
    DataObject DataObject {
	in => <-.field;
	Obj {
		name => name_of(<-.<-.<-);
	};
    };
    olink out_obj => DataObject.obj;
}; // Read_Text_Sequence


// You have a array/grid type dataset that has been written
// out to a file as a continuous sequence of binary values,
// with little or no formatting information.  User must use the
// UI to specify things like dimensions and data type
macro Read_Binary_Sequence {
    group DVread_seq_param {	// its really just a template
	string+IPort2+OPort2 	filename;
	int+IPort2+OPort2	skip_bytes;
	int+IPort2+OPort2	ndim;
	long+IPort2+OPort2	dims[ndim];
	int+IPort2+OPort2	endian;
	int+IPort2+OPort2	ncomp;
	DVread_seq_var+IPort2+OPort2	comps[ncomp];
    };

    DVread_seq_param param<export_all=2> {
        skip_bytes = 0;
        ndim = 3;
	endian = 0;
        ncomp = 1;
	comps {
	    veclen = 1;
	    data_type = 3;	// float (index into menu choices)
	};
    };

    DVread_seq_binary DVread_seq_binary {
        // New parameter
	int+read+notify+req	do;

	DVread_seq_param &param => <-.param;

	// translate from the menu choices to a DTYPE
	int map_to_dtype[] => { 1, 2, 3, 4, 5, 6};

	filename   => .param.filename;
	skip_bytes => .param.skip_bytes;
	ndim       => .param.ndim;
	&dims      => .param.dims;
	endian     => .param.endian;
	ncomp      => .param.ncomp;
	//comps      => .param.comps;
	comps[.param.ncomp] {
            // Eeeek! A lot of mess to do the type mapping trick ...
	    int my_index => index_of(comps);
	    veclen => <-.param.comps[my_index].veclen;
	    data_type => <-.map_to_dtype[<-.param.comps[my_index].data_type];
	    label => <-.param.comps[my_index].label;
	    units => <-.param.comps[my_index].units;
	};

	// Need to repeat this definition to insure that the +req
	// on "do" is respected.
	omethod+notify_inst+notify_val read_update<status=1> =
		"DVread_seq_binary_update";
    };

    GMOD.instancer instancer {
	Value => UIpanel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => read_seq_ui;
    };
    UImod_panel UIpanel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-,1);
	message = "Select read binary sequence control panel.";
    };

    macro read_seq_ui<instanced=0> {
	DVread_seq_param &param=> <-.param;
	ilink UIpanel  => <-.UIpanel;
#ifdef MSDOS
        int+nres field_height => UIdata.UIfonts[0].lineHeight+4;
#else
	// This is the default setting for UIfield, and unfortunately
	// it looks terrible if you try a smaller setting than this
        // with common default fonts for X11.
        int field_height = 30;
#endif
	UIlabel Filename {
	    parent => <-.UIpanel;
	    y = 0;
	    width => 200;
	    alignment = 0;
	};
	UItext file_name {
	    parent => UIpanel;
	    y => Filename.y + Filename.height + 4;
	    text => <-.param.filename;
	    width = 170;
            showLastPosition = 1;
	};
	UIbutton browse {
	    parent => UIpanel;
	    x => file_name.x + file_name.width + 5;
	    y => file_name.y;
	    width = 75;
	    height => <-.file_name.height;
	    label = "Browse...";
	};
	UIfileSB file_browser {
	    GMOD.copy_on_change copy_on_change {
               trigger => <-.<-.browse.do;
               input => <-.<-.browse.do;
               output => <-.visible;
	    };
	    title = "Filename";
	    searchPattern = "$XP_PATH<0>/data/*.*";
	    filename => <-.param.filename;
	};
	UIfieldTypein skip_typein {
	    UIparent => <-.UIpanel;
	    flabel  = "skip initial bytes";
	    fval    => <-.param.skip_bytes;
	    y       => browse.y + browse.height+4;
	    height      => field.height+4;	// default is 40
	    label.width => <-.panel.width * .7;
	    label.alignment = "left";
	    field.x     => <-.label.x + <-.label.width;
	    field.width => <-.panel.width - .x;
	    field.height => field_height;
	    field.mode  = "integer";
	};
	UIfieldTypein ndim_typein {
	    UIparent => <-.UIpanel;
#ifdef MSDOS
	    flabel  = "number of dimensions";
#else
	    flabel  = "number of dims";
#endif
	    fval    => <-.param.ndim;
	    fmin    = 1;
	    fmax    = 4;
	    y       => skip_typein.y + skip_typein.height;
	    height  => field.height+4;
	    label.width => <-.panel.width * .7;
	    label.alignment = "left";
	    field.x     => <-.label.x + <-.label.width;
	    field.width => <-.panel.width - .x;
	    field.height => <-.<-.field_height;
	    field.mode  = "integer";
	    field.nullString = "";
	};
	UIfieldTypein dim1_typein {
	    UIparent => <-.UIpanel;
	    flabel  = "dimension 1";
	    fval    => <-.param.dims[0];
	    y       => ndim_typein.y + ndim_typein.height;
	    height  => field.height+4;
	    label.alignment = "left";
	    label.active => is_valid(<-.<-.param.ndim);
	    label.width => <-.panel.width * .7;
	    field.x     => <-.label.x + <-.label.width;
	    field.width => <-.panel.width - .x;
	    field.height => <-.<-.field_height;
	    field.mode  = "integer";
	    field.active => <-.label.active;
	    field.nullString = "";
	};
	UIfieldTypein dim2_typein {
	    UIparent => <-.UIpanel;
	    flabel  = "dimension 2";
	    fval+nres => <-.param.dims[1];
	    y       => <-.dim1_typein.y + <-.dim1_typein.height;
	    height  => field.height+4;
	    label.alignment = "left";
	    label.active => is_valid(<-.<-.param.ndim) && (<-.<-.param.ndim > 1);
	    label.width => <-.panel.width * .7;
	    field.x     => <-.label.x + <-.label.width;
	    field.width => <-.panel.width - .x;
	    field.mode  = "integer";
	    field.active => <-.label.active;
	    field.nullString = "";
	    field.height => <-.<-.field_height;
	};
	UIfieldTypein dim3_typein {
	    UIparent => <-.UIpanel;
	    flabel  = "dimension 3";
	    fval+nres => <-.param.dims[2];
	    y       => dim2_typein.y + dim2_typein.height;
	    height  => field.height+4;
	    label.alignment = "left";
	    label.active => is_valid(<-.<-.param.ndim) && (<-.<-.param.ndim > 2);
	    label.width => <-.panel.width * .7;
	    field.x     => <-.label.x + <-.label.width;
	    field.width => <-.panel.width - .x;
	    field.height => <-.<-.field_height;
	    field.mode  = "integer";
	    field.active => <-.label.active;
	    field.nullString = "";
	};

	UIoptionMenuLabel endian_menu {
	    parent => <-.UIpanel;
	    labels => {"same as machine", "little endian", "big endian"};
	    selectedItem => <-.param.endian;
	    title = "byte order  ";
	    y       => dim3_typein.y + dim3_typein.height;
	    width => .parent.clientWidth - 8;
	};

	UIfieldTypein ncomp_typein {
	    UIparent => <-.UIpanel;
#ifdef MSDOS
	    flabel  = "number of variables";
#else
	    flabel  = "number of vars";
#endif
	    fval    => <-.param.ncomp;
	    fmin    = 1;
	    //height  = 34;
	    height  => field.height+4;
	    y       => endian_menu.y + endian_menu.height+2;
	    label.width => <-.panel.width * .7;
	    label.alignment = "left";
	    field.x     => <-.label.x + <-.label.width;
	    field.width => <-.panel.width - .x;
	    field.height => <-.<-.field_height;
	    field.mode = "integer";
	};

        UIscrolledWindow varScroll {
	    parent => <-.UIpanel;
            x = 0;
            y => (<-.ncomp_typein.y + <-.ncomp_typein.height) + 3;
            width => parent.clientWidth;
            //virtualWidth => .clientWidth;
            virtualWidth => .width;
            virtualHeight+nres => 10 +
                                  <-.variable_ui[0].frame.height + 
                                  max_array(<-.variable_ui.frame.y );
#ifdef MSDOS
            height => switch((.virtualHeight < 300)+1, 301, .virtualHeight+1);
#else
            height = 400;
#endif
        };

	group variable_ui[param.ncomp] {

	    int my_index => index_of(variable_ui);
	    DVread_seq_var &var => <-.<-.param.comps[index_of(variable_ui)];

            UIframe frame {
		parent => <-.<-.varScroll;
		x = 0;
		y => 1+height*<-.my_index;
	        width => parent.clientWidth;
		height+nres => <-.units_text.y + 40;
            };
	    UIlabel variable_label {
		parent => <-.frame;
		label => "===  Variable: " + <-.my_index + "  ===";
		x = 0;
		y = 4;
		width => parent.clientWidth;
	    };
	    UIfieldTypein veclen_typein {
		UIparent => <-.frame;
		flabel = "vector length";
		fval   => <-.var.veclen;
		fmin   = 1;
		x = 4;
		y => <-.variable_label.y + <-.variable_label.height+4;
		//height = 34;
		height => field.height+4;
		label.width => <-.panel.width * .7;
		label.alignment = "left";
		field.x	    => <-.label.x + <-.label.width;
		field.width => <-.panel.width - .x;
		field.height => <-.<-.<-.field_height;
		field.mode  = "integer";
	    };
	    UIoptionMenuLabel data_type_menu {
		parent => <-.frame;
		labels => {"byte", "short", "int", "float", "double", "long"};
		selectedItem => <-.var.data_type;
		string selectedLabel => .labels[.selectedItem];
		title = "data type  ";
		x = 4;
		y => <-.veclen_typein.y + <-.veclen_typein.height+4;
		width => <-.frame.clientWidth - 8;
	    };
	    UIlabeledText label_text {
		parent => <-.frame;
		label  = "label (opt)";
		label_width => parent.clientWidth * 0.33;
		text => <-.var.label;
		x = 4;
		y => <-.data_type_menu.y + <-.data_type_menu.height+6;
		width => parent.clientWidth - 8;
		UIlabel.alignment = "left";
		UItext.height => <-.<-.<-.field_height;
	    };
	    UIlabeledText units_text {
		parent => <-.frame;
		label  = "units (opt)";
		label_width => parent.clientWidth * 0.33;
		text => <-.var.units;
		x = 4;
		y => <-.label_text.y + <-.label_text.height+2;
		width => parent.clientWidth - 8;
		UIlabel.alignment = "left";
		UItext.height => <-.<-.<-.field_height;
	    };
	};

	UIbutton read_button {
            parent => <-.UIpanel;
            label => "Read File";
	    y  => <-.varScroll.y + <-.varScroll.height+10;
            do => <-.<-.DVread_seq_binary.do;
        };
    };

    olink field => DVread_seq_binary.out;
    DataObject DataObject {
	in => <-.field;
	Obj {
		name => name_of(<-.<-.<-);
	};
    };
    olink out_obj => DataObject.obj;
}; // Read_Binary_Sequence


macro Loop {
    int+IPort2 reset<export=2>=0;
    int+IPort2 reset_back<export=2>=0;
    int+IPort2 run<export=2>=0;
    int+IPort2 run_back<export=2>=0;
    int+IPort2 step<export=2>=0;
    int+IPort2 step_back<export=2>=0;
    int+IPort2 cycle<export=2>=0;
    float+IPort2 start<export=2>=0;
    float+IPort2 end<export=2>=0;
    float+IPort2 incr<export=2>=0;
    float+OPort2 count<export=2>=0;
    int+OPort2 done<export=2>=0;

    GMOD.loop loop {
	&reset => <-.reset;
	&reset_back => <-.reset_back;
	&run => <-.run;
	&run_back => <-.run_back;
	&step => <-.step;
	&step_back => <-.step_back;
	&cycle => <-.cycle;
	&start_val => <-.start;
	&end_val => <-.end;
	&incr => <-.incr;
	&count => <-.count;
	&done => <-.done;
    };
    GMOD.instancer instancer {
	Value => UIpanel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => LoopUI;
    };
    UImod_panel UIpanel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-);
	message = "Select loop control panel.";
    };

    macro LoopUI<instanced=0> {
	ilink UIpanel  => <-.UIpanel;

	UItoggle run_toggle {
	    parent => <-.UIpanel;
	    label = "Run";
	    &set+IPort2 => <-.<-.run;
	    x		=  0;
	    y		=  0;
	    width	= 125;
	};
	UItoggle run_back_toggle {
	    parent => <-.UIpanel;
	    label = "Run Backwards";
	    &set+IPort2 => <-.<-.run_back;
	    x 		= 125;
	    y		=  0;
	    width	= 125;
	};
	UItoggle step_toggle {
	    parent => <-.UIpanel;
	    label = "Step";
	    &set+IPort2 => <-.<-.step;
	    y		=> <-.run_toggle.y + <-.run_toggle.height + 4;
	    width	= 125;
	};
	UItoggle step_back_toggle {
	    parent => <-.UIpanel;
	    label = "Step Backwards";
	    &set+IPort2 => <-.<-.step_back;
	    x		= 125;
	    y		=> <-.run_toggle.y + <-.run_toggle.height + 4;
	    width	= 125;
	};
	UItoggle reset_toggle {
	    parent => <-.UIpanel;
	    label = "Reset";
	    &set+IPort2 => <-.<-.reset;
	    y		=> <-.step_toggle.y + <-.step_toggle.height + 4;
	    width	= 125;
	};
	UItoggle reset_back_toggle {
	    parent => <-.UIpanel;
	    label = "Reset Back";
	    &set+IPort2 => <-.<-.reset_back;
	    x		= 125;
	    y		=> <-.step_toggle.y + <-.step_toggle.height + 4;
	    width	= 125;
	};
	UIoption Once {
        set = 1;
	};
	UIoption Cycle;
	UIoption Bounce;
        UIoptionMenu cycle_toggle {
	    parent => <-.UIpanel;
	    cmdList => {<-.Once,<-.Cycle,<-.Bounce};
	    label = "Cycle Options";
   	    selectedItem => <-.<-.cycle;
   	    y = 0;
	    y		=> <-.reset_toggle.y + <-.reset_toggle.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIfieldTypein start_typein {
	    UIparent => <-.UIpanel;
	    flabel = "Start Value";
	    fval+IPort2 => <-.<-.start;
	    y		=> <-.cycle_toggle.y + <-.cycle_toggle.height + 4;
	    panel.width	=> <-.<-.UIpanel.width;
	};
	UIfieldTypein end_typein {
	    UIparent => <-.UIpanel;
	    flabel = "End Value";
	    fval+IPort2 => <-.<-.end;
	    y		=> <-.start_typein.y + <-.start_typein.height + 4;
	    panel.width	=> <-.<-.UIpanel.width;
	};
	UIfieldTypein incr_typein {
	    UIparent => <-.UIpanel;
	    flabel = "Increment";
	    fval+IPort2 => <-.<-.incr;
	    y		=> <-.end_typein.y + <-.end_typein.height + 4;
	    panel.width	=> <-.<-.UIpanel.width;
	};
	UIfieldTypein count_typein {
	    UIparent => <-.UIpanel;
	    flabel = "Loop count";
	    fval+IPort2 => <-.<-.count;
	    y		=> <-.incr_typein.y + <-.incr_typein.height + 4;
	    panel.width	=> <-.<-.UIpanel.width;
	};
    };
}; // Loop

// Just to get more of the examples working under VIZ
// Don't add it to the readers in the main page.
macro Read_USCounties {
   GD.Read_USCounties rd_counties;
   DataObject obj {
      in => <-.rd_counties.out_mesh;
      Modes {
         mode = {0,2,1,0,0};
      };
   };
   olink out_mesh<export_all=2> => .rd_counties.out_mesh;
   olink out_obj => obj.obj;
};

}; // Readers

///////////////////////////////////////////////////////////////////////////////

library+sort+buffered Writers {

macro Write_Image {
     ilink in<export_all=2>;
     macro write_image_ui {
	UImod_panel panel {
            title => name_of(<-.<-.<-,1);
	    message = "Select write image control panel.";
	    parent<NEportLevels={4,0}>;
	};

	UIlabel Image_Filename {
	    parent => <-.panel;
	    y = 0;
	    width => 200;
	    alignment = 0;
	};
	UItext file_name {
	    parent => panel;
	    y => Image_Filename.y + Image_Filename.height + 5;
	    text => <-.filename;
	    width = 170;
            showLastPosition = 1;
	};
	UIbutton visible {
	    parent => panel;
	    x => file_name.x + file_name.width + 5;
	    y => file_name.y;
	    width = 75;
	    height => <-.file_name.height;
	    label = "Browse...";
	};

	UIbutton write_oneshot {
	    parent => <-.panel;
	    label = "Write File";
	    y	=> <-.visible.y + <-.visible.height+8;
	    width => <-.panel.width;
	};

	UItoggle overwrite_toggle {
	    parent => <-.panel;
	    label = "Overwrite";
	    set+IPort2 = 0;
	    y	=> <-.write_oneshot.y + <-.write_oneshot.height+4;
	    width => <-.panel.width;
	};

	UItoggle flip_toggle {
	    parent => <-.panel;
	    label = "flip";
	    set+IPort2 = 1;
	    y	=> <-.overwrite_toggle.y + <-.overwrite_toggle.height+4;
	    width => <-.panel.width;
	};

	UIfileSB file_browser {
	    GMOD.copy_on_change copy_on_change {
               trigger => <-.<-.visible.do;
               input => <-.<-.visible.do;
               output => <-.visible;
	    };
	    title = "Write IMAGE Filename";
	    searchPattern = "";
	};

	UIframe format_frame {
	    parent => <-.panel;
	    visible => <-.panel.visible;
	    y => <-.flip_toggle.y + <-.flip_toggle.height + 4;
	    width => <-.panel.width;
	    height => <-.format_rb.y + <-.format_rb.height + 6;
	};
	UIlabel format_label {
	    parent => format_frame;
	    label = "File Format";
	    x = 4;
	    y = 0;
	    width => <-.panel.width;
	};
	UIoption format_avsx {
	    label = "AVS .x";
	    message = "AVS .x format";
	    active = 1;
	};
	UIoption format_bmp {
	    label = "BMP";
	    message = "Microsoft BMP format";
	    active = 1;
	};
	UIoption format_gif {
	    label = "GIF";
	    message = "Graphics Interchange Format";
	    active = 1;
	};
	UIoption format_jpeg {
	    label = "JPEG";
	    message = "JFIF: JPEG File Interchange Format";
	    active = 1;
	};
	UIoption format_pbm {
	    label = "PBM";
	    message = "Portable Bitmap Utilities";
	    active = 1;
	};
	UIoption format_sgi {
	    label = "SGI Image";
	    message = "SGI Image format";
	    active = 1;
	};
	UIoption format_sun {
	    label = "Sun Raster";
	    message = "Sun Rasterfile format";
	    active = 0;
	};
	UIoption format_tiff {
	    label = "TIFF";
	    message = "Tag Image File Format";
	    active = 1;
	};
	UIradioBox format_rb {
	    parent => format_frame;
	    cmdList => {format_avsx, format_bmp, format_gif, format_jpeg, format_pbm, format_sgi, format_sun, format_tiff};
	    visible => <-.panel.visible;
	    selectedItem = 0;
	    x = 4;
	    y => <-.format_label.y + <-.format_label.height + 4;
	    width => <-.panel.width;
	};

	UIframe bpp_frame {
	    parent => <-.panel;
	    visible => <-.panel.visible;
	    y => <-.format_frame.y + <-.format_frame.height + 4;
	    width => <-.panel.width;
	    height => <-.bpp_rb.y + <-.bpp_rb.height + 6;
	};
	UIlabel bpp_label {
	    parent => bpp_frame;
	    label = "Bits Per Pixel";
	    x = 4;
	    y = 0;
	    width => <-.panel.width;
	};
	UIoption bpp_0 {
	    label = "Not Applicable";
	    message = "Not applicable";
	    active => switch(<-.format_rb.selectedItem + 1, 0,0,0,1,1,1,0,1);
	};
	UIoption bpp_1 {
	    label = "1";
	    message = "1 bit per pixel";
	    active => switch(<-.format_rb.selectedItem + 1, 0,0,0,0,0,0,0,0);
	};
	UIoption bpp_4 {
	    label = "4";
	    message = "4 bits per pixel";
	    active => switch(<-.format_rb.selectedItem + 1, 0,0,0,0,0,0,0,0);
	};
	UIoption bpp_8 {
	    label = "8";
	    message = "8 bits per pixel";
	    active => switch(<-.format_rb.selectedItem + 1, 0,0,1,0,0,0,0,0);
	};
	UIoption bpp_16 {
	    label = "16";
	    message = "16 bits per pixel";
	    active => switch(<-.format_rb.selectedItem + 1, 0,0,0,0,0,0,0,0);
	};
	UIoption bpp_24 {
	    label = "24";
	    message = "24 bits per pixel";
	    active => switch(<-.format_rb.selectedItem + 1, 0,1,0,0,0,0,0,0);
	};
	UIoption bpp_32 {
	    label = "32";
	    message = "32 bits per pixel";
	    active => switch(<-.format_rb.selectedItem + 1, 1,0,0,0,0,0,0,0);
	};
	UIradioBox bpp_rb {
	    parent => bpp_frame;
	    cmdList => {bpp_0, bpp_1, bpp_4, bpp_8, bpp_16, bpp_24, bpp_32};
	    visible => <-.panel.visible;
	    selectedItem => switch(<-.format_rb.selectedItem + 1, 6,5,3,0,0,0,0,0);
	    x = 4;
	    y => <-.bpp_label.y + <-.bpp_label.height + 4;
	    width => <-.panel.width;
	};

	UIframe color_frame {
	    parent => <-.panel;
	    visible => <-.panel.visible;
	    y => <-.bpp_frame.y + <-.bpp_frame.height + 4;
	    width => <-.panel.width;
	    height => <-.color_rb.y + <-.color_rb.height + 6;
	};
	UIlabel color_label {
	    parent => color_frame;
	    label = "Color Type";
	    x = 4;
	    y = 0;
	    width => <-.panel.width;
	};
	UIoption color_rgb {
	    label = "RGB";
	    message = "Red, Green, Blue";
	    active => switch(<-.format_rb.selectedItem + 1, 1,1,1,1,1,1,0,1);
	};
	UIoption color_grey {
	    label = "Greyscale";
	    message = "Grey levels";
	    active => switch(<-.format_rb.selectedItem + 1, 1,0,1,1,1,1,0,1);
	};
	UIoption color_bw {
	    label = "BW";
	    message = "Black, White";
	    active => switch(<-.format_rb.selectedItem + 1, 0,0,0,0,1,0,0,0);
	};
	UIradioBox color_rb {
	    parent => color_frame;
	    cmdList => {color_rgb, color_grey, color_bw};
	    visible => <-.panel.visible;
	    selectedItem => switch(<-.format_rb.selectedItem + 1, 0,0,0,0,0,0,0,0);
	    x = 4;
	    y => <-.color_label.y + <-.color_label.height + 4;
	    width => <-.panel.width;
	};

	UIframe compression_frame {
	    parent => <-.panel;
	    visible => <-.panel.visible;
	    y => <-.color_frame.y + <-.color_frame.height + 4;
	    width => <-.panel.width;
	    height => <-.quality.y + <-.quality.height + 6;
	};
	UIlabel compression_label {
	    parent => compression_frame;
	    label = "Compression Type";
	    x = 4;
	    y = 0;
	    width => <-.panel.width;
	};
	UIoption compression_none {
	    label = "none";
	    message = "no compression";
	    active => switch(<-.format_rb.selectedItem + 1, 1,1,0,0,1,1,0,1);
	};
	UIoption compression_rle {
	    label = "RLE";
	    message = "Run Length Encoded";
	    active => switch(<-.format_rb.selectedItem + 1, 0,0,0,0,0,1,0,1);
	};
	UIoption compression_lzw {
	    label = "LZW";
	    message = "LZW Compression";
	    active => switch(<-.format_rb.selectedItem + 1, 0,0,1,0,0,0,0,1);
	};
	UIoption compression_jpeg {
	    label = "JPEG";
	    message = "JPEG Compression";
	    active => switch(<-.format_rb.selectedItem + 1, 0,0,0,1,0,0,0,0);
	};
	UIoption compression_ccitt3 {
	    label = "CCITT Group 3";
	    message = "CCITT T.4 Compression";
	    active => switch(<-.format_rb.selectedItem + 1, 0,0,0,0,0,0,0,1);
	};
	UIoption compression_ccitt4 {
	    label = "CCITT Group 4";
	    message = "CCITT T.6 Compression";
	    active => switch(<-.format_rb.selectedItem + 1, 0,0,0,0,0,0,0,1);
	};
	UIradioBox compression_rb {
	    parent => compression_frame;
	    cmdList => {compression_none, compression_rle, compression_lzw, compression_jpeg, compression_ccitt3, compression_ccitt4};
	    visible => <-.panel.visible;
	    selectedItem => switch(<-.format_rb.selectedItem + 1, 0,0,2,3,0,0,0,1);
	    x = 4;
	    y => <-.compression_label.y + <-.compression_label.height + 4;
	    width => <-.panel.width;
	};
	UIslider quality {
	    parent => compression_frame;
	    title = "Quality";
	    min = 0.0;
	    max = 100.0;
	    value = 75.0;
    	    active => switch(<-.format_rb.selectedItem + 1, 0,0,0,1,0,0,0,0);
	    visible => <-.panel.visible;
	    x = 4;
	    y => <-.compression_rb.y + <-.compression_rb.height + 4;
	    width => <-.panel.width;
	};

	UIframe reduction_frame {
	    parent => <-.panel;
	    visible => <-.panel.visible;
	    y => <-.compression_frame.y + <-.compression_frame.height + 4;
	    width => <-.panel.width;
	    height => <-.reduction_rb.y + <-.reduction_rb.height + 6;
	};
	UIlabel reduction_label {
	    parent => reduction_frame;
	    label = "Reduction Type";
	    x = 4;
	    y = 0;
	    width => <-.panel.width;
	};
	UIoption reduction_na {
	    label = "Not Applicable";
	    message = "Not applicable";
	    active => switch(<-.format_rb.selectedItem + 1, 1,0,0,1,1,0,0,1);
	};
	UIoption reduction_ex {
	    label = "Exhaustive";
	    message = "Exhaustive Reduction";
	    active => switch(<-.format_rb.selectedItem + 1, 0,0,0,0,0,0,0,0);
	};
	UIoption reduction_mc {
	    label = "Median Cut";
	    message = "Median Cut Reduction";
	    active => switch(<-.format_rb.selectedItem + 1, 0,0,0,0,0,0,0,0);
	};
	UIoption reduction_pop {
	    label = "Popularity";
	    message = "Popularity Reduction";
	    active => switch(<-.format_rb.selectedItem + 1, 0,0,0,0,0,0,0,0);
	};
	UIoption reduction_fs {
	    label = "Floyd Steinberg";
	    message = "Floyd Steinberg Dithering";
	    active => switch(<-.format_rb.selectedItem + 1, 0,0,1,0,0,0,0,0);
	};
	UIradioBox reduction_rb {
	    parent => reduction_frame;
	    cmdList => {reduction_na, reduction_ex, reduction_mc, reduction_pop, reduction_fs};
	    visible => <-.panel.visible;
	    selectedItem => switch(<-.format_rb.selectedItem + 1, 0,0,4,0,0,0,0,0);
	    x = 4;
	    y => <-.reduction_label.y + <-.reduction_label.height + 4;
	    width => <-.panel.width;
	};

	UIframe filetype_frame {
	    parent => <-.panel;
	    visible => <-.panel.visible;
	    y => <-.reduction_frame.y + <-.reduction_frame.height + 4;
	    width => <-.panel.width;
	    height => <-.filetype_rb.y + <-.filetype_rb.height + 6;
	};
	UIlabel filetype_label {
	    parent => filetype_frame;
	    label = "File Type";
	    x = 4;
	    y = 0;
	    width => <-.panel.width;
	};
	UIoption filetype_binary {
	    label = "binary";
	    message = "binary type";
	    active => switch(<-.format_rb.selectedItem + 1, 1,1,1,1,1,0,0,1);
	};
	UIoption filetype_ascii {
	    label = "ASCII";
	    message = "ASCII type";
	    active => switch(<-.format_rb.selectedItem + 1, 0,0,0,0,1,0,0,0);
	};
	UIradioBox filetype_rb {
	    parent => filetype_frame;
	    cmdList => {filetype_binary, filetype_ascii};
	    visible => <-.panel.visible;
	    selectedItem => switch(<-.format_rb.selectedItem + 1, 0,0,0,0,0,0,0,0);
	    x = 4;
	    y => <-.filetype_label.y + <-.filetype_label.height + 4;
	    width => <-.panel.width;
	};

	olink filename<export=3>     => file_browser.filename;
	olink output<export=3>       => write_oneshot.do;
	olink overwrite<export=3>    => overwrite_toggle.set;
	olink flip<export=3>         => flip_toggle.set;
	olink format<export=3>       => format_rb.selectedItem;
	olink filetype <export=3>    => filetype_rb.selectedItem;
	olink depth<export=3>        => bpp_rb.selectedItem;
	olink colortype<export=3>    => color_rb.selectedItem;
	olink compresstype<export=3> => compression_rb.selectedItem;
	olink compressqual<export=3> => quality.value;
	olink reducetype<export=3>   => reduction_rb.selectedItem;
    };
    DVwrite_image DVwrite_image {
	in => <-.in;
	filename => write_image_ui.filename;
	output => write_image_ui.output;
	flip => write_image_ui.flip;
	format => write_image_ui.format;
	filetype => write_image_ui.filetype;
	depth => write_image_ui.depth;
	colortype => write_image_ui.colortype;
	compresstype => write_image_ui.compresstype;
	compressqual => write_image_ui.compressqual;
	reducetype => write_image_ui.reducetype;
	overwrite => write_image_ui.overwrite;
    };
}; // Write_Image

}; // Writers

library+sort+buffered Filters {

macro combine_rgb {
    ilink in_field1<export_all=1>;
    ilink in_field2<export_all=1>;
    ilink in_field3<export_all=1>;

    DVcombine_rgb DVcombine_rgb {
	in1 => in_field1;
	in2 => in_field2;
	in3 => in_field3;
    };

    DataObjectNoTexture obj {
	in => DVcombine_rgb.out;
	Obj {
	    name => name_of(<-.<-.<-,1);
	};
    };

    olink out_fld<export_all=2> => DVcombine_rgb.out;
    olink out_obj => obj.obj;
}; // combine_rgb

macro coordinate_math {
    Mesh+IPort2 &in_field1<export_all=1>;
    Mesh+IPort2 &in_field2<export_all=1>;
    Mesh+IPort2 &in_field3<export_all=1>;
    Mesh+IPort2 &in_field4<export_all=1>;

    string+Port operation_x<export=2> = "#1x";
    string+Port operation_y<export=2> = "#1y";
    string+Port operation_z<export=2> = "#1z";
    int+Port nspace<export=2> => in_field1.nspace+0;

    DVcoord_math DVcoord_math {
	&operation_x => <-.operation_x;
	&operation_y => <-.operation_y;
	&operation_z => <-.operation_z;
	&nspace => <-.nspace;
	in1 => in_field1;
	in2 => in_field2;
	in3 => in_field3;
	in4 => in_field4;
    };
    UImod_panel UIpanel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-);
	message = "Select coordinate math control panel.";
    };
    GMOD.instancer instancer {
	Value => UIpanel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => CoordMathUI;
    };
    macro CoordMathUI<instanced=0> {
	ilink UIpanel  => <-.UIpanel;

	UIslider nspace_slider {
	    parent => <-.UIpanel;
	    title = "output nspace";
	    min = 1;
	    max = 3;
	    mode = 1;
	    value+IPort2 => <-.<-.nspace;
	    y		= 0;
	    width	=> <-.UIpanel.width;
	};
	UIlabeledText Operation_x {
	    parent=> <-.UIpanel;
	    label = "X";
	    &text+IPort2 => <-.<-.operation_x;
	    x = 0;
	    y		=> <-.nspace_slider.y + <-.nspace_slider.height + 4;
	    width	=> <-.UIpanel.width;
	    label_width = 10;
	    active => (<-.<-.nspace>0);
	};
	UIlabeledText Operation_y {
	    parent=> <-.UIpanel;
	    label = "Y";
	    &text+IPort2 => <-.<-.operation_y;
	    x = 0;
	    y		=> <-.Operation_x.y + <-.Operation_x.height + 4;
	    width	=> <-.UIpanel.width;
	    label_width = 10;
	    active => (<-.<-.nspace>1);
	};
	UIlabeledText Operation_z {
	    parent=> <-.UIpanel;
	    label = "Z";
	    &text+IPort2 => <-.<-.operation_z;
	    x = 0;
	    y		=> <-.Operation_y.y + <-.Operation_y.height + 4;
	    width	=> <-.UIpanel.width;
	    label_width = 10;
	    active => (<-.<-.nspace>2);
	};
/***
	UItext Operation_x {
	    parent => <-.UIpanel;
	    &text+IPort2 => <-.<-.operation_x;
	    y		=> <-.nspace_slider.y + <-.nspace_slider.height + 4;
	    width	=> <-.UIpanel.width;
	    active => (<-.<-.nspace>0);
	};
	UItext Operation_y {
	    parent => <-.UIpanel;
	    &text+IPort2 => <-.<-.operation_y;
	    y		=> <-.Operation_x.y + <-.Operation_x.height + 4;
	    width	=> <-.UIpanel.width;
	    active => (<-.<-.nspace>1);
	};
	UItext Operation_z {
	    parent => <-.UIpanel;
	    &text+IPort2 => <-.<-.operation_z;
	    y		=> <-.Operation_y.y + <-.Operation_y.height + 4;
	    width	=> <-.UIpanel.width;
	    active => (<-.<-.nspace>2);
	};
***/
    };
    DataObjectNoTexture obj {
	in => DVcoord_math.out;
	Obj {
	    name => name_of(<-.<-.<-);
	};
    };

    olink out_fld<export_all=2> => DVcoord_math.out;
    olink out_obj => obj.obj;
}; // coordinate_math

macro data_math {
    ilink in_field1<export_all=1>;
    ilink in_field2<export_all=1>;
    ilink in_field3<export_all=1>;
    ilink in_field4<export_all=1>;

    string+Port expres<export=2> = "#1";
    int+Port value_type<export=2> = 4;

    DVdata_math DVdata_math {
	&operation => expres;
	&data_type => value_type;
	in1 => in_field1;
	in2 => in_field2;
	in3 => in_field3;
	in4 => in_field4;
    };
    UImod_panel UIpanel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-);
	message = "Select cell data math control panel.";
    };
    GMOD.instancer instancer {
	Value => UIpanel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => DataMathUI;
    };
    macro DataMathUI<instanced=0> {
	ilink oper=>expres;

	ilink UIpanel  => <-.UIpanel;

	UItext Operation {
	    parent => <-.UIpanel;
	    &text+IPort2 => oper;
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
	string labels[7] = {"char", "byte", "short", "int", "float", "double", "long"};

	UIradioBoxLabel   UIradioBoxLabel {
	    parent => <-.UIpanel;
	    labels => <-.labels;
	    &selectedItem => value_type;
	    visible => <-.UIpanel.visible;
	    title = "data type";
	    y		=> <-.Operation.y + <-.Operation.height + 4;
	    width	=> <-.UIpanel.width;
	};
    };
    DataObjectNoTexture obj {
	in => DVdata_math.out;
	Obj {
	    name => name_of(<-.<-.<-);
	};
    };

    olink out_fld<export_all=2> => DVdata_math.out;
    olink out_obj => obj.obj;
}; // data_math

macro cell_data_math {
    ilink in_field1<export_all=1>;
    ilink in_field2<export_all=1>;
    ilink in_field3<export_all=1>;
    ilink in_field4<export_all=1>;

    string+Port expres<export=2> = "#1";
    int+Port value_type<export=2> = 4;

    DVcell_data_math DVcell_data_math {
	&operation => expres;
	&data_type => value_type;
	in1 => in_field1;
	in2 => in_field2;
	in3 => in_field3;
	in4 => in_field4;
    };
    UImod_panel UIpanel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-);
	message = "Select data math control panel.";
    };
    GMOD.instancer instancer {
	Value => UIpanel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => DataMathUI;
    };
    macro DataMathUI<instanced=0> {
	ilink oper=>expres;
	ilink UIpanel  => <-.UIpanel;

	UItext Operation {
	    parent => <-.UIpanel;
	    &text+IPort2 => oper;
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
	string labels[7] = {"char", "byte", "short", "int", "float", "double", "long"};

	UIradioBoxLabel   UIradioBoxLabel {
	    parent => <-.UIpanel;
	    labels => <-.labels;
	    &selectedItem => value_type;
	    visible => <-.UIpanel.visible;
	    title = "data type";
	    y		=> <-.Operation.y + <-.Operation.height + 4;
	    width	=> <-.UIpanel.width;
	};
    };
    DataObjectNoTexture obj {
	in => DVcell_data_math.out;
	Obj {
	    name => name_of(<-.<-.<-);
	};
    };

    olink out_fld<export_all=2> => DVcell_data_math.out;
    olink out_obj => obj.obj;
}; // cell_data_math

macro downsize {
    ilink in_field<export_all=1>;

    DV_Param_downsize  DownsizeParam<export_all=2> {
	factor0 = 8;
	factor1 = 8;
	factor2 = 8;
    };
    DVdownsize  DVdownsize {
	DV_Param_downsize+IPort2 &param => DownsizeParam;
	in => in_field;
	factor => param.factor[0:in.ndim-1];
    };
    GMOD.instancer instancer {
	Value => panel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => DownsizeUI;
    };
    UImod_panel panel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-);
	message = "Select downsize control panel.";
    };

    macro DownsizeUI<instanced=0> {
	ilink in_fld => in_field;
	DV_Param_downsize+IPort2 &param =>DownsizeParam;

	ilink panel  => <-.panel;

	UItoggle int_toggle {
	    parent => <-.panel;
	    label = "Integer Sliders";
	    set+IPort2 = 1;
	    y		=  0;
	    width	=> <-.panel.width;
	};

	UIslider factor0_slider {
	    parent => <-.panel;
	    title = "I downsize factor";
	    min => <-.int_toggle.set;
	    max = 12.0;
	    value+IPort2 => param.factor0;
	    mode => <-.int_toggle.set;
	    y		=> <-.int_toggle.y + <-.int_toggle.height + 4;
	    width	=> <-.panel.width;
	};
	factor0_slider factor1_slider {
	    title = "J downsize factor";
	    value+IPort2 => param.factor1;
	    y		=> <-.factor0_slider.y + <-.factor0_slider.height + 4;
	    visible+nres => panel.visible & (in_fld.ndim > 1);
	};
	factor0_slider factor2_slider {
	    title = "K downsize factor";
	    value+IPort2 => param.factor2;
	    y		=> <-.factor1_slider.y + <-.factor1_slider.height + 4;
	    visible+nres => panel.visible & (in_fld.ndim > 2);
	};
    };

    DataObjectNoTexture obj {
	in => DVdownsize.out;
	Obj {
	    name => name_of(<-.<-.<-);
	};
    };

    olink out_fld<export_all=2> => DVdownsize.out;
    olink out_obj => obj.obj;
}; // downsize

macro crop {
    ilink in_field<export_all=1>;

    DV_Param_crop CropParam<export_all=2> {
	min+nres => init_array(in_field.ndim,0,0);
	max+nres => in_field.dims-1;
    };

    DVcrop DVcrop {
	DV_Param_crop+IPort2 &param => CropParam;
	in => in_field;
	min => param.min;
	max => param.max;
    };

    GMOD.instancer instancer {
	Value => panel.visible;
	active = 2; // don't de-instance when visible = 0
	Group =>CropUI ;
    };
    UImod_panel panel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-);
	message = "Select crop control panel.";
    };

    macro CropUI<instanced=0> {
	ilink in_fld => in_field;
	DV_Param_crop+IPort2 &param => CropParam;

	ilink panel  => <-.panel;

	UIslider min0_slider {
	    parent => <-.panel;
	    title = "I min";
	    max+nres => in_fld.dims[0]-1;
	    value+nres+IPort2 => param.min[0];
	    mode = 1;
	    y		=  0;
	    width	=> <-.panel.width;
	};
	min0_slider max0_slider {
	    title = "I max";
	    max+nres => in_fld.dims[0]-1;
	    value+nres+IPort2 => param.max[0];
	    y		=> <-.min0_slider.y + <-.min0_slider.height + 4;
	};

	min0_slider min1_slider {
	    title = "J min";
	    max+nres => in_fld.dims[1]-1;
	    value+nres+IPort2 => param.min[1];
	    y		=> <-.max0_slider.y + <-.max0_slider.height + 4;
	    visible+nres => panel.visible & (in_fld.ndim > 1);
	};
	min0_slider max1_slider {
	    title = "J max";
	    max+nres => in_fld.dims[1]-1;
	    value+nres+IPort2 => param.max[1];
	    y		=> <-.min1_slider.y + <-.min1_slider.height + 4;
	    visible+nres => panel.visible & (in_fld.ndim > 1);
	};

	min0_slider min2_slider {
	    title = "K min";
	    max+nres => in_fld.dims[2]-1;
	    value+nres+IPort2 => param.min[2];
	    y		=> <-.max1_slider.y + <-.max1_slider.height + 4;
	    visible+nres => panel.visible & (in_fld.ndim > 2);
	};
	min0_slider max2_slider {
	    title = "K max";
	    max+nres => in_fld.dims[2]-1;
	    value+nres+IPort2 => param.max[2];
	    y		=> <-.min2_slider.y + <-.min2_slider.height + 4;
	    visible+nres => panel.visible & (in_fld.ndim > 2);
	};
    };

    DataObjectNoTexture obj {
	in => DVcrop.out;
	Obj {
	    name => name_of(<-.<-.<-);
	};
    };

    olink out_fld<export_all=2> => DVcrop.out;
    olink out_obj => obj.obj;
}; // crop

macro extract_component {
    ilink in_field<export_all=1>;

    DV_Param_extr_comp ExtrCompParam<export_all=2>{
	component = 0;
    };

    DVextract_comp DVextract_comp {
	DV_Param_extr_comp+IPort2 &param => ExtrCompParam;
	in => in_field;
	&component => param.component;
    };

    macro ExtrCompUI {
	ilink in_fld => in_field;
	DV_Param_extr_comp+IPort2 &param => ExtrCompParam;

	UImod_panel panel {
	    parent<NEportLevels={4,0}>;
	    title => name_of(<-.<-.<-,1);
	    message = "Select extract component control panel.";
	};

	DVnode_data_labels DVnode_data_labels {
	    in => in_fld;
	    int+nres  ncomp => in.nnode_data;
	};
	UIradioBoxLabel  UIradioBoxLabel {
	    parent => <-.panel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    &selectedItem+IPort2 => param.component;
	    visible => <-.panel.visible;
	    title = "data component";
	    y		=  0;
	    width	=> <-.panel.width;
	};
    };

    DataObjectNoTexture obj {
	in => DVextract_comp.out;
	Obj {
	    name => name_of(<-.<-.<-);
	};
    };

    olink out_fld<export_all=2> => DVextract_comp.out;
    olink out_obj => obj.obj;
}; // extract_component

macro extract_mesh {
    ilink in_field<export_all=1>;

    DVextract_mesh DVextract_mesh {
	in => in_field;
    };

    DataObjectNoTexture obj {
	in => DVextract_mesh.out;
	Obj {
	    name => name_of(<-.<-.<-,1);
	};
    };

    olink out_fld<export_all=2> => DVextract_mesh.out;
    olink out_obj => obj.obj;
};

macro extract_cell_component {
    ilink in_field<export_all=1>;

    DV_Param_extr_comp ExtrCompParam<export_all=2> {
	component = 0;
    };

    DVextr_cell_comp DVextr_cell_comp {
	DV_Param_extr_comp+IPort2 &param => ExtrCompParam;
	in => in_field;
	&comp => param.component;
    };

    macro ExtrCompUI {
	ilink in_fld => in_field;
	DV_Param_extr_comp+IPort2 &param => ExtrCompParam;

	UImod_panel panel {
	    parent<NEportLevels={4,0}>;
	    title => name_of(<-.<-.<-,1);
	    message = "Select extract cell component control panel.";
	};
	DVcell_data_labels DVcell_data_labels {
	    in => in_fld;
	};
	UIradioBoxLabel  UIradioBoxLabel {
	    parent => <-.panel;
	    labels+IPort2 => DVcell_data_labels.labels;
	    &selectedItem+IPort2 => param.component;
	    visible => <-.panel.visible;
	    title = "cell data";
	    y		=  0;
	    width	=> <-.panel.width;
	};
    };

    DataObjectNoTexture obj {
	in => DVextr_cell_comp.out;
	Obj {
	    name => name_of(<-.<-.<-);
	};
    };

    olink out_fld<export_all=2> => DVextr_cell_comp.out;
    olink out_obj => obj.obj;
}; // extract_cell_component

macro extract_scalar {
    ilink in_field<export_all=1>;

    DV_Param_extract_scalar+Port ExtractScalarParam<export_all=2> {
	vector = 0;
	component = 0;
    };

    ExtractScalar ExtractScalar {
	in_fld => in_field;
	param => ExtractScalarParam;
    };

    macro  ExtractScalarUI {
	ilink in_fld => in_field;
	DV_Param_extract_scalar+IPort2 &param => ExtractScalarParam;

	DVnode_data_labels DVnode_data_labels {
	    in => in_fld;
	    int+nres  ncomp => in.nnode_data;
	};
	UImod_panel UIpanel {
	    parent<NEportLevels={4,0}>;
	    title => name_of(<-.<-.<-,1);
	    message = "Select extract scalar control panel.";
	};

	UIradioBoxLabel  UIradioBoxLabel {
	    parent => <-.UIpanel;
	    labels => DVnode_data_labels.labels;
	    &selectedItem => param.vector;
	    visible => <-.UIpanel.visible;
	    title = "data component";
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};

        UIslider ComponentSlider {
            int+nres val_array[2] => {1, in_fld.node_data[param.vector].veclen-1};
            parent => <-.UIpanel;
            title = "vector component";
            max+nres => max_array(val_array);
            value+IPort2 => param.component;
            mode = 1;
            y           => <-.UIradioBoxLabel.y + <-.UIradioBoxLabel.height + 4;
            width       => <-.UIpanel.width;
            visible+nres => min_array(val_array);
        };

    };

    DataObjectNoTexture obj {
	in => ExtractScalar.out_fld;
	Obj {
	    name => name_of(<-.<-.<-);
	};
    };

    olink out_fld<export_all=2> => ExtractScalar.out_fld;
    olink out_obj => obj.obj;
}; // extract_scalar

macro combine_vect {
    ilink in_field<export_all=1>;

    DV_Param_combine_vect+Port CombineVectParam<export_all=2> {
	veclen = 3;
	components[] = {0,1,2};
	sub_components[4] => {0,0,0,0};
    };
    GMOD.parse_v  parse_v{
      on_inst = 0;
      trigger => <-.CombineVectParam.veclen;
      relative => <-.CombineVectParam;
      v_commands = "components = init_array(veclen,0,veclen-1);";
      parse_v_relative<weight=0>;
    };
    CombineVect CombineVect {
	in_fld => in_field;
	param => CombineVectParam;
    };

    macro CombVectUI {
	ilink in_fld => in_field;
	DV_Param_combine_vect+IPort2 &param => CombineVectParam;

	DVnode_data_labels DVnode_data_labels {
	    in => in_fld;
	    int+nres  ncomp => in.nnode_data;
	};

	UImod_panel UIpanel {
	    parent<NEportLevels={4,0}>;
	    title => name_of(<-.<-.<-);
	    message = "Select combine vector control panel.";
	};

	UIslider ComponentSlider {
	    parent => <-.UIpanel;
	    title = "veclen";
	    max+nres = 4;
	    value+IPort2 => param.veclen;
	    mode = 1;
		min  = 1.0;
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};

	UIoptionBoxLabel UIoptionBoxLabel {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    max => param.veclen;
	    &selectedItems+IPort2 => param.components;
	    title = "vector components";
	    visible => <-.UIpanel.visible;
	    y		=> <-.ComponentSlider.y + <-.ComponentSlider.height + 4;
	    width	=> <-.UIpanel.width;
	};
    };

    DataObjectNoTexture obj {
	in => CombineVect.out_fld;
	Obj {
	    name => name_of(<-.<-.<-);
	};
    };

    olink out_fld<export_all=2>  => CombineVect.out_fld;
    olink out_obj => obj.obj;
}; // combine_vect

macro threshold {
    ilink in_field<export_all=1>;

    DV_Param_thresh+Port ThreshParam<export_all=2> {
	check_vector = 0;
	check_comp = 0;
	thresh_vector = 0;
	below = 1;
	above = 0;
	min_value+nres => cache(in_field.node_data[check_vector].min_vec[check_comp]);
	max_value+nres => cache(in_field.node_data[check_vector].max_vec[check_comp]);
	null_value = 0;
    };

    Threshold Threshold {
	in_fld => in_field;
	param => ThreshParam;
    };
    GMOD.instancer instancer {
	Value => UIpanel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => ThresholdUI;
    };
    UImod_panel UIpanel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-);
	message = "Select threshold control panel.";
    };

    macro ThresholdUI<instanced=0> {
	ilink in_fld => in_field;
	DV_Param_thresh+IPort2 &param => ThreshParam;

	DVnode_data_labels DVnode_data_labels {
	    in => in_fld;
	    int+nres  ncomp => in.nnode_data;
	};
	ilink UIpanel  => <-.UIpanel;

	UIradioBoxLabel UIradioBoxLabel_check {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    &selectedItem+IPort2 => param.check_vector;
	    visible => <-.UIpanel.visible;
	    title = "check component";
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};

	UIradioBoxLabel UIradioBoxLabel_thresh {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    &selectedItem+IPort2 => param.thresh_vector;
	    visible => <-.UIpanel.visible;
	    title = "threshold component";
	    y		=> <-.UIradioBoxLabel_check.y + <-.UIradioBoxLabel_check.height + 4;
	    width	=> <-.UIpanel.width;
	};

	UItoggle below_toggle {
	    parent => <-.UIpanel;
	    label = "Below min value";
	    set+IPort2 => param.below;
	    y		=> <-.UIradioBoxLabel_thresh.y + <-.UIradioBoxLabel_thresh.height + 4;
	    width	=> <-.UIpanel.width;
	};

	UIslider min_slider {
	    parent => <-.UIpanel;
	    title = "min value";
	    min+nres => cache(in_fld.node_data[param.check_vector].min_vec[param.check_comp]-0.1);
	    max+nres => cache(in_fld.node_data[param.check_vector].max_vec[param.check_comp]+0.1);
	    value+IPort2 => param.min_value;
	    y		=> <-.below_toggle.y + <-.below_toggle.height + 4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein min_slider_typein {
	    slider	=> min_slider;
        };
	UItoggle above_toggle {
	    parent => <-.UIpanel;
	    label = "Above max value";
	    set+IPort2 => param.above;
	    y		=> <-.min_slider.y + <-.min_slider.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIslider max_slider {
	    parent => <-.UIpanel;
	    title = "max value";
	    min+nres => cache(in_fld.node_data[param.check_vector].min_vec[param.check_comp]-0.1);
	    max+nres => cache(in_fld.node_data[param.check_vector].max_vec[param.check_comp]+0.1);
	    value+IPort2 => param.max_value;
	    y		=> <-.above_toggle.y + <-.above_toggle.height + 4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein max_slider_typein {
	    slider	=> max_slider;
        };
	UIslider null_slider {
	    parent => <-.UIpanel;
	    title = "null thresh value";
	    min+nres => cache(in_fld.node_data[param.thresh_vector].min-10);
	    max+nres => cache(in_fld.node_data[param.thresh_vector].max+10);
	    value+IPort2 => param.null_value;
	    y		=> <-.max_slider.y + <-.max_slider.height + 4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein null_slider_typein {
	    slider	=> null_slider;
        };
    };

    DataObjectNoTexture obj {
	in => Threshold.out_fld;
	Obj {
	    name => name_of(<-.<-.<-);
	};
    };

    olink out_fld<export_all=2> => Threshold.out_fld;
    olink out_obj => obj.obj;
}; // threshold

macro threshold_cell {
    ilink in_field<export_all=1>;

    DV_Param_thresh+Port ThreshParam<export_all=2> {
	check_vector = 0;
	check_comp = 0;
	thresh_vector = 0;
	below = 1;
	above = 0;
	min_value+nres => cache(in_field.cell_set[0].cell_data[check_vector].min);
	max_value+nres => cache(in_field.cell_set[0].cell_data[check_vector].max);
	null_value = 0;
    };

    DVthreshold_cell DVthreshold_cell {
	DV_Param_thresh+IPort2 &param => ThreshParam;
	in => in_field;
	check_vector => param.check_vector;
	check_comp => param.check_comp;
	thresh_vector => param.thresh_vector;
	below => param.below;
	above => param.above;
	min_value => param.min_value;
	max_value => param.max_value;
	null_value => param.null_value;
    };
    GMOD.instancer instancer {
	Value => UIpanel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => ThresholdUI;
    };
    UImod_panel UIpanel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-,1);
	message = "Select threshold cells control panel.";
    };

    macro ThresholdUI<instanced=0> {
	ilink in_fld => in_field;
	DV_Param_thresh+IPort2 &param => ThreshParam;

	DVcell_data_labels DVcell_data_labels {
	    in => in_fld;
	};
	ilink UIpanel  => <-.UIpanel;

	UIradioBoxLabel UIradioBoxLabel_check {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVcell_data_labels.labels;
	    &selectedItem+IPort2 => param.check_vector;
	    visible => <-.UIpanel.visible;
	    title = "check component";
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};

	UIradioBoxLabel UIradioBoxLabel_thresh {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVcell_data_labels.labels;
	    &selectedItem+IPort2 => param.thresh_vector;
	    visible => <-.UIpanel.visible;
	    title = "threshold component";
	    y		=> <-.UIradioBoxLabel_check.y + <-.UIradioBoxLabel_check.height + 4;
	    width	=> <-.UIpanel.width;
	};

	UItoggle below_toggle {
	    parent => <-.UIpanel;
	    label = "Below min value";
	    set+IPort2 => param.below;
	    y		=> <-.UIradioBoxLabel_thresh.y + <-.UIradioBoxLabel_thresh.height + 4;
	    width	=> <-.UIpanel.width;
	};

	UIslider min_slider {
	    parent => <-.UIpanel;
	    title = "min value";
	    min+nres => DVcell_data_labels.min_data[param.check_vector]-0.1;
	    max+nres => DVcell_data_labels.max_data[param.check_vector]+0.1;
	    value+IPort2 => param.min_value;
	    y		=> <-.below_toggle.y + <-.below_toggle.height + 4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein min_slider_typein {
	    slider	=> min_slider;
        };
	UItoggle above_toggle {
	    parent => <-.UIpanel;
	    label = "Above max value";
	    set+IPort2 => param.above;
	    y		=> <-.min_slider.y + <-.min_slider.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIslider max_slider {
	    parent => <-.UIpanel;
	    title = "max value";
	    min+nres => DVcell_data_labels.min_data[param.check_vector]-0.1;
	    max+nres => DVcell_data_labels.max_data[param.check_vector]+0.1;
	    value+IPort2 => param.max_value;
	    y		=> <-.above_toggle.y + <-.above_toggle.height + 4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein max_slider_typein {
	    slider	=> max_slider;
        };
	UIslider null_slider {
	    parent => <-.UIpanel;
	    title = "null thresh value";
	    min+nres => DVcell_data_labels.min_data[param.thresh_vector]-10;
	    max+nres => DVcell_data_labels.max_data[param.thresh_vector]+10;
	    value+IPort2 => param.null_value;
	    y		=> <-.max_slider.y + <-.max_slider.height + 4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein null_slider_typein {
	    slider	=> null_slider;
        };
    };

    DataObjectNoTexture obj {
	in => DVthreshold_cell.out;
	Obj {
	    name => name_of(<-.<-.<-,1);
	};
    };

    olink out_fld<export_all=2> => DVthreshold_cell.out;
    olink out_obj => obj.obj;
}; // threshold_cell

macro clamp {
    ilink in_field<export_all=1>;

    DV_Param_clamp+Port ClampParam<export_all=2> {
	vector = 0;	/* Note reversal of usual terminology */
	component = 0;	/* Note reversal of usual terminology */
	below = 1;
	above = 0;
	reset_minmax = 0;
	min_value+nres => cache(in_field.node_data[vector].min_vec[component]);
	max_value+nres => cache(in_field.node_data[vector].max_vec[component]);
    };

    Clamp Clamp {
	in_fld => in_field;
	param => ClampParam;
    };

    GMOD.instancer instancer {
	Value => UIpanel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => ClampUI;
    };
    UImod_panel UIpanel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-);
	message = "Select clamp control panel.";
    };

    macro ClampUI<instanced=0> {
	ilink in_fld => in_field;
	DV_Param_clamp+IPort2 &param => ClampParam;

	DVnode_data_labels DVnode_data_labels {
	    in => in_fld;
	    int+nres  ncomp => in.nnode_data;
	};

	ilink UIpanel  => <-.UIpanel;

	UIradioBoxLabel   UIradioBoxLabel {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    &selectedItem+IPort2 => param.vector;
	    visible => <-.UIpanel.visible;
	    title = "data component";
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
	UIslider vec_comp {
	    int+nres val_array[2] => {1, in_fld.node_data[param.vector].veclen-1};
	    parent => <-.UIpanel;
	    title = "vector sub-component";
	    max+nres => max_array(val_array);
	    value+IPort2 => param.component;
	    mode = 1;
	    y		=> <-.UIradioBoxLabel.y + <-.UIradioBoxLabel.height + 4;
	    width	=> <-.UIpanel.width;
	    visible+nres => min_array(val_array);
	};
	UItoggle below_toggle {
	    parent => <-.UIpanel;
	    label = "Clamp below min value";
	    set+IPort2  => param.below;
	    y		=> <-.vec_comp.y + <-.vec_comp.height + 6;
	    width	=> <-.UIpanel.width;
	};
	UIslider min_slider {
	    parent => <-.UIpanel;
	    title = "min value";
	    min+nres => cache(in_fld.node_data[param.vector].min_vec[param.component]);
	    max+nres => cache(in_fld.node_data[param.vector].max_vec[param.component]);
	    value+IPort2 => param.min_value;
	    y		=> <-.below_toggle.y + <-.below_toggle.height + 4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein min_slider_typein {
	    slider	=> min_slider;
        };
	UItoggle above_toggle {
	    parent => <-.UIpanel;
	    label = "Clamp above max value";
	    set+IPort2  => param.above;
	    y		=> <-.min_slider.y + <-.min_slider.height + 6;
	    width	=> <-.UIpanel.width;
	};
	UIslider max_slider {
	    parent => <-.UIpanel;
	    title = "max value";
	    min+nres => cache(in_fld.node_data[param.vector].min_vec[param.component]);
	    max+nres => cache(in_fld.node_data[param.vector].max_vec[param.component]);
	    value+IPort2 => param.max_value;
	    y		=> <-.above_toggle.y + <-.above_toggle.height + 4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein max_slider_typein {
	    slider	=> max_slider;
        };
	UItoggle reset_toggle {
	    parent => <-.UIpanel;
	    label = "Reset min-max";
	    set+IPort2  => param.reset_minmax;
	    y		=> <-.max_slider.y + <-.max_slider.height + 6;
	    width	=> <-.UIpanel.width;
	};
    };

    DataObjectNoTexture obj {
	in => Clamp.out_fld;
	Obj {
	    name => name_of(<-.<-.<-);
	};
    };

    olink out_fld<export_all=2> => Clamp.out_fld;
    olink out_obj => obj.obj;
}; // clamp

macro clamp_cell {
    ilink in_field<export_all=1>;

    DV_Param_clamp+Port ClampParam<export_all=2> {
	vector = 0;	/* Note reversal of usual terminology */
	component = 0;	/* Note reversal of usual terminology */
	below = 1;
	above = 0;
	reset_minmax = 0;
	min_value+nres => cache(in_field.cell_set[0].cell_data[vector].min_vec[component]);
	max_value+nres => cache(in_field.cell_set[0].cell_data[vector].max_vec[component]);
    };

    DVextr_cell_comp DVextr_cell_comp {
        in   => <-.in_field;
        comp => <-.ClampParam.vector;
    };
    DVclamp_cell DVclamp_cell {
        in => <-.DVextr_cell_comp.out;
        &component => <-.ClampParam.component;
        &below     => <-.ClampParam.below;
        &above     => <-.ClampParam.above;
        &reset_minmax => <-.ClampParam.reset_minmax;
        &min_value => <-.ClampParam.min_value;
        &max_value => <-.ClampParam.max_value;
    };

    GMOD.instancer instancer {
        Value => UIpanel.visible;
        active = 2; // don't de-instance when visible = 0
        Group => ClampUI;
    };
    UImod_panel UIpanel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-);
	message = "Select clamp control panel.";
    };

    macro ClampUI<instanced=0> {
	ilink in_fld => in_field;
	DV_Param_clamp+IPort2 &param => ClampParam;

	DVcell_data_labels DVcell_data_labels {
	    in => in_fld;
	};

	ilink UIpanel  => <-.UIpanel;

	UIradioBoxLabel   UIradioBoxLabel{
	    parent => <-.UIpanel;
	    labels+IPort2 => DVcell_data_labels.labels;
	    &selectedItem+IPort2 => param.vector;
	    visible => <-.UIpanel.visible;
	    title = "data component";
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
	UIslider vec_comp {
	    int+nres val_array[2] => {1, in_fld.cell_set[0].cell_data[param.vector].veclen-1};
	    parent => <-.UIpanel;
	    title = "vector sub-component";
	    max+nres => max_array(val_array);
	    value+IPort2 => param.component;
	    mode = 1;
	    y		=> <-.UIradioBoxLabel.y + <-.UIradioBoxLabel.height + 4;
	    width	=> <-.UIpanel.width;
	    visible+nres => min_array(val_array);
	};
	UItoggle below_toggle {
	    parent => <-.UIpanel;
	    label = "Clamp below min value";
	    set+IPort2  => param.below;
	    y		=> <-.vec_comp.y + <-.vec_comp.height + 6;
	    width	=> <-.UIpanel.width;
	};
	UIslider min_slider {
	    parent => <-.UIpanel;
	    title = "min value";
	    min+nres => cache(in_fld.cell_set[0].cell_data[param.vector].min_vec[param.component]);
	    max+nres => cache(in_fld.cell_set[0].cell_data[param.vector].max_vec[param.component]);
	    value+IPort2 => param.min_value;
	    y		=> <-.below_toggle.y + <-.below_toggle.height + 4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein min_slider_typein {
	    slider	=> min_slider;
        };
	UItoggle above_toggle {
	    parent => <-.UIpanel;
	    label = "Clamp above max value";
	    set+IPort2  => param.above;
	    y		=> <-.min_slider.y + <-.min_slider.height + 6;
	    width	=> <-.UIpanel.width;
	};
	UIslider max_slider {
	    parent => <-.UIpanel;
	    title = "max value";
	    min+nres => cache(in_fld.cell_set[0].cell_data[param.vector].min_vec[param.component]);
	    max+nres => cache(in_fld.cell_set[0].cell_data[param.vector].max_vec[param.component]);
	    value+IPort2 => param.max_value;
	    y		=> <-.above_toggle.y + <-.above_toggle.height + 4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein max_slider_typein {
	    slider	=> max_slider;
        };
	UItoggle reset_toggle {
	    parent => <-.UIpanel;
	    label = "Reset min-max";
	    set+IPort2  => param.reset_minmax;
	    y		=> <-.max_slider.y + <-.max_slider.height + 6;
	    width	=> <-.UIpanel.width;
	};
    };

    DataObjectNoTexture obj {
	in => DVclamp_cell.out;
	Obj {
	    name => name_of(<-.<-.<-);
	};
    };

    olink out_fld<export_all=2> => DVclamp_cell.out;
    olink out_obj => obj.obj;
}; // clamp_cell

macro least_squares {
    ilink in_field<export_all=1>;

    DV_Param_least_sq+IPort LeastParam<export_all=2> {
	component = 0;
	order = 3;
    };

    Least_Squares Least_Squares {
	in_fld => in_field;
	param => LeastParam;
    };

    macro LeastUI {
	ilink in_fld => in_field;
	DV_Param_extr_comp+IPort2 &param => LeastParam;

	DVnode_data_labels DVnode_data_labels {
	    in => in_fld;
	    int+nres  ncomp => in.nnode_data;
	};
	UImod_panel UIpanel {
	    parent<NEportLevels={4,0}>;
	    title => name_of(<-.<-.<-);
	    message = "Select least squares control panel.";
	};
	UIradioBoxLabel UIradioBoxLabel {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    &selectedItem+IPort2 => param.component;
	    visible => <-.UIpanel.visible;
	    title = "data component";
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
	UIslider order_slider {
	    parent => <-.UIpanel;
	    title = "polynom order";
	    mode = 1;
	    min = 1;
	    value+IPort2 => param.order;
	    y		=> <-.UIradioBoxLabel.y + <-.UIradioBoxLabel.height + 4;
	    width	=> <-.UIpanel.width;
	};
    };

    DataObjectNoTexture obj {
	in => Least_Squares.out_fld;
	Obj {
	    name => name_of(<-.<-.<-);
	};
    };

    olink out_coeff => Least_Squares.out_coeff;
    olink out_fld<export_all=2>=> Least_Squares.out_fld;
    olink out_obj => obj.obj;
}; // least_squares


macro filter_1d {
    ilink in_field<export_all=1>;
    ilink kernels<export_all=1>;

    DV_Param_extr_comp+Port FilterParam<export_all=2> {
	component = 0;
    };

    Filter_1d Filter_1d {
	in_fld => in_field;
	kernels => <-.kernels;
	param => FilterParam;
    };

    macro FilterUI {
	ilink in_fld => in_field;
	DV_Param_extr_comp+IPort2 &param => FilterParam;

	DVnode_data_labels DVnode_data_labels {
	    in => in_fld;
	    int+nres  ncomp => in.nnode_data;
	};
	UImod_panel UIpanel {
	    parent<NEportLevels={4,0}>;
	    title => name_of(<-.<-.<-);
	    message = "Select filter control panel.";
	};
	UIradioBoxLabel UIradioBoxLabel {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    &selectedItem+IPort2 => param.component;
	    visible => <-.UIpanel.visible;
	    title = "data component";
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
    };

    DataObjectNoTexture obj {
	in => Filter_1d.out_fld;
	Obj {
	    name => name_of(<-.<-.<-);
	};
    };

    olink out_fld<export_all=2> => Filter_1d.out_fld;
    olink out_obj => obj.obj;
}; // filter_1d

macro set_xform {
    ilink in_field1<export_all=1>;
    ilink in_field2<export_all=1>;

    DVset_xform DVset_xform {
	in => in_field1;
	in_xfm => in_field2;
    };

    DataObjectNoTexture obj {
	in => DVset_xform.out;
	Obj {
	    name => name_of(<-.<-.<-);
	};
    };

    olink out_fld<export_all=2> => DVset_xform.out;
    olink out_obj => obj.obj;
};

macro reset_xform {
    ilink in_field<export_all=1>;

    group xfm {
	DefaultXform  xform;
    };

    DVset_xform DVset_xform {
	in => in_field;
	in_xfm => xfm;
    };
    DataObjectNoTexture obj {
	in => DVset_xform.out;
	Obj {
	    name => name_of(<-.<-.<-);
	};
    };

    olink out_fld<export_all=2> => DVset_xform.out;
    olink out_obj => obj.obj;
};

macro set_null {
    ilink in_field<export_all=1>;

    DV_Param_set_null SetNullParam <export_all=2>{
	component = 0;
	unset = 0;
	null_value = 0;
    };

    DVset_null DVset_null {
	DV_Param_set_null+IPort2 &param => SetNullParam;
	in => in_field;
	&component => param.component;
	&unset => param.unset;
	&null_value => param.null_value;
    };

    DVcomb_mesh_and_data DVcomb_mesh_and_data {
	in_mesh => in_field;
	in_nd =>  DVset_null.out;
    };
    GMOD.instancer instancer {
	Value => UIpanel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => SetNullUI;
    };
    UImod_panel UIpanel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-);
	message = "Select set_null panel.";
    };

    macro SetNullUI<instanced=0> {
	ilink in_fld => in_field;
	DV_Param_set_null+IPort2 &param => SetNullParam;

	DVnode_data_labels DVnode_data_labels {
	    in => in_fld;
	    int+nres  ncomp => in.nnode_data;
	};

	ilink UIpanel  => <-.UIpanel;

	UIradioBoxLabel comp_radioBoxLabel {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    &selectedItem+IPort2 => param.component;
	    visible => <-.UIpanel.visible;
	    title = "data component";
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
	UIradioBoxLabel set_radioBoxLabel {
	    parent => <-.UIpanel;
	    labels+IPort2 = {"set Null Value", "unset Null Value"};
	    &selectedItem+IPort2 => param.unset;
	    visible => <-.UIpanel.visible;
	    title = "Set Null";
	    y     => <-.comp_radioBoxLabel.y + <-.comp_radioBoxLabel.height + 8;
	    width => <-.UIpanel.width;
	};
	UIfieldTypein null_typein {
	    UIparent => <-.UIpanel;
	    flabel = "Null Value";
	    fval+IPort2 => param.null_value;
	    y     => <-.set_radioBoxLabel.y + <-.set_radioBoxLabel.height + 16;
	    width => <-.UIpanel.width;
            int+nres active => (<-.param.unset == 0);
            label {
                active => <-.active;
                alignment = "left";
                x      = 0;
                width  => <-.panel.width * 0.4;
            };
            field {
                active => <-.active;
                x      => <-.label.width;
                width  => <-.panel.width * 0.4;
            };
	};
    };

    DataObjectNoTexture obj {
	in => DVcomb_mesh_and_data.out;
	Obj {
	    name => name_of(<-.<-.<-);
	};
    };

    olink out_fld<export_all=2> => DVcomb_mesh_and_data.out;
    olink out_obj => obj.obj;
}; // set_null

macro cell_to_node {
    ilink in_field<export_all=1>;

    DV_Param_cell_to_node CellToNodeParam<export_all=2> {
	comps[] = {0};
	order = 0;
    };

    DVcell_to_node DVcell_to_node {
	DV_Param_cell_to_node+IPort2 &param => CellToNodeParam;
	in => in_field;
	&comps => param.comps;
	&order => param.order;
    };

    macro CellToNodeUI {
	ilink in_fld => in_field;
	DV_Param_cell_to_node+IPort2 &param => CellToNodeParam;

	DVcell_data_labels DVcell_data_labels {
	    in => in_fld;
	};
	UImod_panel UIpanel {
	    parent<NEportLevels={4,0}>;
	    title => name_of(<-.<-.<-);
	    message = "Select cell_to_node control panel.";
	};
	UIoptionBoxLabel UIoptionBoxLabel {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVcell_data_labels.labels;
	    max => DVcell_data_labels.ncomp;
	    &selectedItems+IPort2 => param.comps;
	    title = "cell data components";
	    visible => <-.UIpanel.visible;
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
	UIslider order_slider {
	    parent => <-.UIpanel;
	    title = "Interpolation Order";
	    max = 32;
	    value+IPort2 => param.order;
	    mode = 1;
	    y		=> <-.UIoptionBoxLabel.y + <-.UIoptionBoxLabel.height+4;
	    width	=> <-.UIpanel.width;
	};
    };

    DataObjectNoTexture obj {
	in => DVcell_to_node.out;
	Obj {
	    name => name_of(<-.<-.<-);
	};
    };

    olink out_fld<export_all=2> => DVcell_to_node.out;
    olink out_obj => obj.obj;
}; // cell_to_node

macro select_cells {
    ilink in_field<export_all=1>;

    int+Port sets<export=2>[] = {0};

    DVselect_cells DVselect_cells {
	in => in_field;
	sets => <-.sets;
    };

    macro SelectCellsUI {
	ilink in_fld => in_field;
	int+IPort2 &sets[] => <-.sets;

	DVcell_labels DVcell_labels {
	    in => in_fld;
	    int+nres  ncomp => in.nnode_data;
	};
	UImod_panel UIpanel {
	    parent<NEportLevels={4,0}>;
	    title => name_of(<-.<-.<-);
	    message = "Select select_cells control panel.";
	};
	UIoptionBoxLabel UIoptionBoxLabel {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVcell_labels.labels;
	    max => DVcell_labels.nsets;
	    &selectedItems+IPort2 => sets;
	    title = "cell sets";
	    visible => <-.UIpanel.visible;
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
    };

    DataObjectNoTexture obj {
	in => DVselect_cells.out;
	Obj {
	    name => name_of(<-.<-.<-);
	};
    };

    olink out_fld<export_all=2> => DVselect_cells.out;
    olink out_obj => obj.obj;
}; // select_cells

macro gradient {
    ilink in_field<export_all=1>;

    int+Port component<export=2>  = 0;

    DVgrad DVgrad {
	in => in_field;
	int+Iparam comp => <-.component;
    };

    macro GradUI {
	ilink in_fld => in_field;
	int+IPort2 &param => component;

	DVnode_data_labels DVnode_data_labels {
	    in => in_fld;
	    int+nres  ncomp => in.nnode_data;
	};
	UImod_panel UIpanel {
	    parent<NEportLevels={4,0}>;
	    title => name_of(<-.<-.<-);
	    message = "Select gradient control panel.";
	};
	UIradioBoxLabel UIradioBoxLabel {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    &selectedItem+IPort2 => param;
	    visible => <-.UIpanel.visible;
	    title = "data component";
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
    };

    DataObjectNoTexture obj {
	in => DVgrad.out;
	Obj {
	    name => name_of(<-.<-.<-);
	};
    };

    olink out_fld<export_all=2> => DVgrad.out;
    olink out_obj => obj.obj;
}; // gradient

macro curl {
    ilink in_field<export_all=1>;

    int+Port component<export=2> = 0;

    DVcurl  DVcurl {
	in => in_field;
	int+Iparam comp => <-.component;
    };

    macro  CurlUI {
	ilink in_fld => in_field;
	int+IPort2 &param => component;

	DVnode_data_labels DVnode_data_labels {
	    in => in_fld;
	    int+nres  ncomp => in.nnode_data;
	};
	UImod_panel UIpanel {
	    parent<NEportLevels={4,0}>;
	    title => name_of(<-.<-.<-);
	    message = "Select  curlcontrol panel.";
	};
	UIradioBoxLabel UIradioBoxLabel {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    &selectedItem+IPort2 => param;
	    visible => <-.UIpanel.visible;
	    title = "data component";
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
    };

    DataObjectNoTexture obj {
	in => DVcurl.out;
	Obj {
	    name => name_of(<-.<-.<-);
	};
    };

    olink out_fld<export_all=2> => DVcurl.out;
    olink out_obj => obj.obj;
}; // curl

macro divergence {
    ilink in_field<export_all=1>;

    int+Port component<export=2> = 0;

    DVdivrg  DVdivrg {
	in => in_field;
	int+Iparam comp => <-.component;
    };

    macro  DivUI {
	ilink in_fld => in_field;
	int+IPort2 &param => component;

	UImod_panel UIpanel {
	    parent<NEportLevels={4,0}>;
	    title => name_of(<-.<-.<-);
	    message = "Select divergence control panel.";
	};

	DVnode_data_labels DVnode_data_labels {
	    in => in_fld;
	    int+nres  ncomp => in.nnode_data;
	};
	UIradioBoxLabel UIradioBoxLabel {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    &selectedItem+IPort2 => param;
	    visible => <-.UIpanel.visible;
	    title = "data component";
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
    };

    DataObjectNoTexture obj {
	in => DVdivrg.out;
	Obj {
	    name => name_of(<-.<-.<-);
	};
    };

    olink out_fld<export_all=2> => DVdivrg.out;
    olink out_obj => obj.obj;
}; // divergence

macro xform_to_plane {
    ilink in_field<export_all=1>;
    ilink in_plane<export_all=1>;

    DVxform_to_plane DVxform_to_plane {
	in => in_field;
	plane => in_plane;
    };
    DataObjectNoTexture obj {
	in => DVxform_to_plane.out;
	Obj {
	    name => name_of(<-.<-.<-);
	    xform_mode = GD_XFORM_MODE_ALT;
	    alt_xform+nres => <-.<-.DVxform_to_plane.user_xform;
	};
    };

    olink out_fld<export_all=2> => DVxform_to_plane.out;
    olink out_obj => obj.obj;
};

macro mirror {
    ilink in_field<export_all=1>;

    DV_Param_mirror MirrorParam<export_all=2> {
	x_axis = 0;
	y_axis = 0;
	z_axis = 0;
    };

    DVmirror DVmirror {
	DV_Param_mirror &param => MirrorParam;
	in => in_field;
	float mirr_coef[2] = {1.0, -1.0};
	mir_x => mirr_coef[param.x_axis];
	mir_y => mirr_coef[param.y_axis];
	mir_z => mirr_coef[param.z_axis];
    };

    macro  MirrorUI {
	ilink in_fld => in_field;
	DV_Param_mirror &param => MirrorParam;

	UImod_panel UIpanel {
	    parent<NEportLevels={4,0}>;
	    title => name_of(<-.<-.<-);
	    message = "Select mirror control panel.";
	};

	UItoggle mirror_x_toggle {
	    parent => <-.UIpanel;
	    label = "mirror X axis";
	    &set+IPort2 => param.x_axis;
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
	UItoggle mirror_y_toggle {
	    parent => <-.UIpanel;
	    label = "mirror Y axis";
	    &set+IPort2 => param.y_axis;
	    y		=> <-.mirror_x_toggle.y + <-.mirror_x_toggle.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UItoggle mirror_z_toggle {
	    parent => <-.UIpanel;
	    label = "mirror Z axis";
	    &set+IPort2 => param.z_axis;
	    y		=> <-.mirror_y_toggle.y + <-.mirror_y_toggle.height + 4;
	    width	=> <-.UIpanel.width;
	};
    };

    DataObjectNoTexture obj {
	in => DVmirror.out;
	Obj {
	    name => name_of(<-.<-.<-);
	    xform_mode = GD_XFORM_MODE_ALT;
	    alt_xform+nres => <-.<-.DVmirror.user_xform;
	};
    };

    olink out_fld<export_all=2> => DVmirror.out;
    olink out_obj => obj.obj;
}; // mirror

macro scale {
    ilink in_field<export_all=1>;

    DV_Param_scale ScaleParam<export_all=2> {
	scale_x = 1;
	scale_y = 1;
	scale_z = 1;
    };

    DVscale DVscale {
	DV_Param_scale+IPort2 &param => ScaleParam;
	in => in_field;
	&scale_x => param.scale_x;
	&scale_y => param.scale_y;
	&scale_z => param.scale_z;
    };

    macro ScaleUI {
	ilink in_fld => in_field;
	DV_Param_scale+IPort2 &param => ScaleParam;

	UImod_panel UIpanel {
	    parent<NEportLevels={4,0}>;
	    title => name_of(<-.<-.<-);
	    message = "Select scale control panel.";
	};

	UIslider scale_x_slider {
	    parent => <-.UIpanel;
	    title = "X-scale";
	    min = -10.0;
	    max = 10.0;
	    value+IPort2 => param.scale_x;
	    y		=  0;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein scale_x_slider_typein {
	    slider	=> scale_x_slider;
        };

	UIslider scale_y_slider {
	    parent => <-.UIpanel;
	    title = "Y-scale";
	    min = -10.0;
	    max = 10.0;
	    value+IPort2 => param.scale_y;
	    y		=> <-.scale_x_slider.y + <-.scale_x_slider.height + 4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein scale_y_slider_typein {
	    slider	=> scale_y_slider;
        };

	UIslider scale_z_slider {
	    parent => <-.UIpanel;
	    title = "Z-scale";
	    min = -10.0;
	    max = 10.0;
	    value+IPort2 => param.scale_z;
	    y		=> <-.scale_y_slider.y + <-.scale_y_slider.height + 4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein scale_z_slider_typein {
	    slider	=> scale_z_slider;
        };
    };
    DataObjectNoTexture obj {
	in => DVscale.out;
	Obj {
	    name => name_of(<-.<-.<-);
	    xform_mode = GD_XFORM_MODE_ALT;
	    alt_xform+nres => <-.<-.DVscale.user_xform;
	};
    };
    olink out_fld<export_all=2> => DVscale.out;
    olink out_obj => obj.obj;
}; // scale

macro magnitude {
    ilink in_field<export_all=1>;

    DV_Param_extr_comp MagParam<export_all=2> {
	component = 0;
    };

    DVmagnitude DVmagnitude {
	MagParam+IPort2 &param => MagParam;
	in => in_field;
	&component => param.component;
    };

    macro  MagUI {
	ilink in_fld => in_field;
	DV_Param_extr_comp+IPort2 &param => MagParam;

	DVnode_data_labels DVnode_data_labels {
	    in => in_fld;
	    int+nres  ncomp => in.nnode_data;
	};
	UImod_panel UIpanel {
	    parent<NEportLevels={4,0}>;
	    title => name_of(<-.<-.<-);
	    message = "Select magnitude control panel.";
	};
	UIradioBoxLabel UIradioBoxLabel {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    &selectedItem+IPort2 => param.component;
	    visible => <-.UIpanel.visible;
	    title = "data component";
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
    };

    DataObjectNoTexture obj {
	in => DVmagnitude.out;
	Obj {
	    name => name_of(<-.<-.<-);
	};
    };

    olink out_fld<export_all=2> => DVmagnitude.out;
    olink out_obj => obj.obj;
}; // magnitude

macro combine_comp {
    ilink in_field1<export_all=1>;
    ilink in_field2<export_all=1>;

    DV_Param_comb_comp CombCompParam<export_all=2> {
	comp1[] = {0};
	comp2[] = {0};
    };
    DVcomb_comp DVcomb_comp {
	DV_Param_comb_comp+IPort2 &param => CombCompParam;
	nd1 => in_field1;
	nd2 => in_field2;
	comp1 => param.comp1;
	comp2 => param.comp2;
    };
    DVcomb_mesh_and_data DVcomb_mesh_and_data {
	in_mesh => in_field1;
	in_nd => DVcomb_comp.out;
    };
    macro  CombCompUI {
	ilink in_fld1 => in_field1;
	ilink in_fld2 => in_field2;
	DV_Param_comb_comp+IPort2 &param => CombCompParam;

	UImod_panel UIpanel {
	    parent<NEportLevels={4,0}>;
	    title => name_of(<-.<-.<-);
	    message = "Select combine components control panel.";
	};

	DVnode_data_labels DVnode_data_labels1 {
	    in => in_fld1;
	    int+nres  ncomp => in_fld1.nnode_data;
	};
	DVnode_data_labels DVnode_data_labels2 {
	    in => in_fld2;
	    int+nres  ncomp => in_fld2.nnode_data;
	};

	UIoptionBoxLabel UIoptionBoxLabel1 {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels1.labels;
	    max => DVnode_data_labels1.ncomp;
	    &selectedItems+IPort2 => param.comp1;
	    title = "data components 1";
	    visible => <-.UIpanel.visible;
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
	UIoptionBoxLabel UIoptionBoxLabel2 {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels2.labels;
	    max => DVnode_data_labels2.ncomp;
	    &selectedItems+IPort2 => param.comp2;
	    title = "data components 2";
	    visible => <-.UIpanel.visible;
	    y		=> <-.UIoptionBoxLabel1.y + <-.UIoptionBoxLabel1.height + 4;
	    width	=> <-.UIpanel.width;
	};
    };

    DataObjectNoTexture obj {
	in => DVcomb_mesh_and_data.out;
	Obj {
	    name => name_of(<-.<-.<-);
	};
    };

    olink out_fld<export_all=2> => DVcomb_mesh_and_data.out;
    olink out_obj => obj.obj;
}; // combine_comp

macro explode_materials {
    ilink in_field<export_all=1>;

    int+Port material_index<export=2> = 0;

    macro ExplMatUI {
	ilink  mat_index => <-.material_index;

	UImod_panel UIpanel {
	    parent<NEportLevels={4,0}>;
	    title => name_of(<-.<-.<-);
	    message = "Select explode_materials control panel.";
	};
	UIslider mat_slider {
	    parent => <-.UIpanel;
	    title = "material index";
	    mode = 1;
	    max = 10;
	    value+IPort2 => mat_index;
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
    };
    DVexplode_materials DVexplode_materials {
	in => <-.in_field;
	property => <-.material_index;
    };
    DataObjects objs {
	in_fields => DVexplode_materials.out;
    };
    GroupObject obj {
	child_objs => objs.dos.obj;
    };

    mlink+OPort2 out_fld => DVexplode_materials.out;
    olink out_obj => obj;
}; // explode_materials

macro explode_fields {
    imlink in_fields<export_all=1>;

    DV_Param_scale explode_param<export_all=2> {
	scale_x = 0.5;
	scale_y = 0.5;
	scale_z = 0.5;
    };

    macro ExplFldUI {
	DV_Param_scale+IPort2 &param => <-.explode_param;

	UImod_panel UIpanel {
	    parent<NEportLevels={4,0}>;
	    title => name_of(<-.<-.<-);
	    message = "Select explode_fields control panel.";
	};
	UIslider x_slider {
	    parent => <-.UIpanel;
	    title = "x-scale";
	    value+IPort2 => param.scale_x;
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
	UIslider y_slider {
	    parent => <-.UIpanel;
	    title = "y-scale";
	    value+IPort2 => param.scale_y;
	    y		=> <-.x_slider.y + <-.x_slider.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIslider z_slider {
	    parent => <-.UIpanel;
	    title = "z-scale";
	    value+IPort2 => param.scale_z;
	    y		=> <-.y_slider.y + <-.y_slider.height + 4;
	    width	=> <-.UIpanel.width;
	};
    };
    Explode_Fields Explode_Fields {
	in_fields => <-.in_fields;
	param => <-.explode_param;
    };

    DataObjects objs {
	in_fields => Explode_Fields.out_fld;
    };
    GroupObject obj {
	child_objs => objs.dos.obj;
    };

    mlink+OPort2 out_fld => Explode_Fields.out_fld;
    olink  out_obj => obj.obj;
}; // explode_fields

macro mblock_to_fields {
    Multi_Block+IPort2 &multi_block<export_all=1>;
    olink fields<export_all=2> => multi_block.fields;
};

macro fields_to_mblock {
    imlink fields<export_all=1>;
    Multi_Block+OPort2 multi_block<export_all=2> {
	&fields => <-.fields;
	nblocks => array_size(<-.fields);
    };
};

macro rotate {
    ilink in_field<export_all=1>;

    DV_Param_rotate Param<export_all=2> {
	nmeshes = 1;
	axis = 2;
	center_x = 0.0;
	center_y = 0.0;
	center_z = 0.0;
	center => {center_x, center_y, center_z};
	start_angle = 180.0;
	end_angle = 0.0;
    };

    DVrotate_mesh DVrotate_mesh {
	in => <-.in_field;
	axis => <-.Param.axis;
	center => <-.Param.center;
	angle => <-.Param.start_angle*acos(-1.0)/180;
    };
    GMOD.instancer instancer {
	Value => UIpanel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => RotateUI;
    };
    UImod_panel UIpanel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-);
	message = "Select rotat control panel.";
    };

    macro RotateUI<instanced=0> {
	ilink in_fld => in_field;
	DV_Param_rotate+IPort2 &param => <-.Param;

	ilink UIpanel  => <-.UIpanel;

	UIradioBoxLabel UIradioBoxLabel {
	    parent => <-.UIpanel;
	    labels+IPort2 = {"X", "Y", "Z"};
	    &selectedItem+IPort2 => param.axis;
	    visible => <-.UIpanel.visible;
	    title = "rotation axis";
	    y		= 0;
	    width	=> <-.UIpanel.width;
	};
	UIfieldTypein start_typein {
	    UIparent => <-.UIpanel;
	    flabel = "Angle";
	    fval => param.start_angle;
	    y => <-.UIradioBoxLabel.y + <-.UIradioBoxLabel.height+4;
	};
	UIfieldTypein x_typein {
	    UIparent => <-.UIpanel;
	    flabel = "X center";
	    fval => param.center_x;
	    y => <-.start_typein.y + <-.start_typein.height+14;
	};
	UIfieldTypein y_typein {
	    UIparent => <-.UIpanel;
	    flabel = "Y center";
	    fval => param.center_y;
	    y => <-.x_typein.y + <-.x_typein.height+4;
	};
	UIfieldTypein z_typein {
	    UIparent => <-.UIpanel;
	    flabel = "Z center";
	    fval => param.center_z;
	    y => <-.y_typein.y + <-.y_typein.height+4;
	};
    };
    DataObjectNoTexture obj {
	in => DVrotate_mesh.out;
	Obj {
	    name => name_of(<-.<-.<-);
	    xform_mode = GD_XFORM_MODE_ALT;
	    alt_xform+nres => <-.<-.DVrotate_mesh.user_xform;
	};
    };

    olink out_fld<export_all=2> => DVrotate_mesh.out;
    olink out_obj => obj.obj;
}; // rotate

macro replicate_field {
    ilink in_field<export_all=1>;

    DV_Param_rotate Param<export_all=2> {
	nmeshes = 2;
	axis = 2;
	center_x = 0.0;
	center_y = 0.0;
	center_z = 0.0;
	center => {center_x, center_y, center_z};
	start_angle = 0.0;
	end_angle = 180.0;
    };

    Replicate_Field Replicate_Field {
	DV_Param_rotate+IPort2 &param => <-.Param;
	in_fld => in_field;
    };

    GMOD.instancer instancer {
	Value => UIpanel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => ReplFieldUI;
    };
    UImod_panel UIpanel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-);
	message = "Select replicate field control panel.";
    };

    macro ReplFieldUI<instanced=0> {
	ilink in_fld => in_field;
	DV_Param_rotate+IPort2 &param => <-.Param;

	ilink UIpanel  => <-.UIpanel;

	UIslider nmeshes_slider {
	    parent => <-.UIpanel;
	    title = "# of fields";
	    mode = 1;
	    value+IPort2 => param.nmeshes;
	    y		= 0;
	    width	=> <-.UIpanel.width;
	};

	UIradioBoxLabel UIradioBoxLabel {
	    parent => <-.UIpanel;
	    labels+IPort2 = {"X", "Y", "Z"};
	    &selectedItem+IPort2 => param.axis;
	    visible => <-.UIpanel.visible;
	    title = "rotation axis";
	    y		=> <-.nmeshes_slider.y + <-.nmeshes_slider.height+4;
	    width	=> <-.UIpanel.width;
	};
	UIfieldTypein start_typein {
	    UIparent => <-.UIpanel;
	    flabel = "Start angle";
	    fval => param.start_angle;
	    y => <-.UIradioBoxLabel.y + <-.UIradioBoxLabel.height+4;
	};
	UIfieldTypein end_typein {
	    UIparent => <-.UIpanel;
	    flabel = "End angle";
	    fval => param.end_angle;
	    y => <-.start_typein.y + <-.start_typein.height+4;
	};
	UIfieldTypein x_typein {
	    UIparent => <-.UIpanel;
	    flabel = "X center";
	    fval => param.center_x;
	    y => <-.end_typein.y + <-.end_typein.height+14;
	};
	UIfieldTypein y_typein {
	    UIparent => <-.UIpanel;
	    flabel = "Y center";
	    fval => param.center_y;
	    y => <-.x_typein.y + <-.x_typein.height+4;
	};
	UIfieldTypein z_typein {
	    UIparent => <-.UIpanel;
	    flabel = "Z center";
	    fval => param.center_z;
	    y => <-.y_typein.y + <-.y_typein.height+4;
	};
    };
    DataObjectNoTexture in_obj {
	in => <-.in_field;
	Obj {
	    name => name_of(<-.<-.<-);
	    xform_mode = GD_XFORM_MODE_PARENT;
	};
    };
    GroupObject group_obj[Param.nmeshes] {
	Top.name => name_of(<-.<-.<-)+index_of(group_obj);
	Top.xform_mode = GD_XFORM_MODE_PARENT;
 	child_objs => <-.in_obj.obj;
	&Xform => <-.Replicate_Field.DVrotate_mesh[index_of(group_obj)].rotate_xform.xform;
    };
    GroupObject obj {
	Top.name => name_of(<-.<-.<-);
 	child_objs => group_obj.obj;
    };
    mlink+OPort2 out_fld => Replicate_Field.out;
    olink out_obj => obj.obj;
}; // replicate_field

macro project_axis {
    ilink in_field<export_all=1>;

    int+Port plane = 0;

    DVproject DVproject {
	in => in_field;
	plane => <-.plane;
    };
    DVextract_mesh DVextract_mesh {
	in => <-.DVproject.out;
    };

    macro  ProjectUI {
	UImod_panel UIpanel {
	    parent<NEportLevels={4,0}>;
	    title => name_of(<-.<-.<-);
	    message = "Select project control panel.";
	};
	UIradioBoxLabel UIradioBoxLabel {
	    parent => <-.UIpanel;
	    labels+IPort2 = {"XY", "YZ", "ZX"};
	    &selectedItem+IPort2 => <-.<-.plane;
	    visible => <-.UIpanel.visible;
	    title = "projection plane";
	    y		= 0;
	    width	=> <-.UIpanel.width;
	};
    };

    DataObjectNoTexture obj {
	in => DVextract_mesh.out;
	Modes {
	    mode = {0,0,GD_SURF_NOLIGHT,0,0};	/* set lines, gouraud mode */
	};
	Obj {
	    name => name_of(<-.<-.<-);
	    xform_mode = GD_XFORM_MODE_ALT;
	    alt_xform+nres => <-.<-.DVproject.user_xform;
	};
    };

    olink out_fld<export_all=2> => DVextract_mesh.out;
    olink out_obj => obj.obj;
}; // project_axis

macro project_plane {
    ilink in_field<export_all=1>;
    ilink in_plane<export_all=1>;

    DVproject_to_plane DVproject_to_plane {
	in => <-.in_field;
	plane => <-.in_plane;
    };

    DVextract_mesh DVextract_mesh {
	in => <-.DVproject_to_plane.out;
    };

    DataObjectNoTexture obj {
	in => DVextract_mesh.out;
	Modes {
	    mode = {0,0,GD_SURF_NOLIGHT,0,0};	/* set lines, gouraud mode */
	};
	Obj {
	    name => name_of(<-.<-.<-);
	    xform_mode = GD_XFORM_MODE_ALT;
	    alt_xform+nres => <-.<-.DVproject_to_plane.user_xform;
	};
    };

    olink out_fld<export_all=2> => DVextract_mesh.out;
    olink out_obj => obj.obj;
}; // project_plane

//////////////////////////////
//// set-reset minmax modules
/////////////////////////////

macro reset_extent {
    ilink in_field<export_all=1>;

    DVreset_extent DVreset_extent {
	in => <-.in_field;
    };

    DataObject obj {
	in => DVreset_extent.out;
	Obj {
	    name => name_of(<-.<-.<-);
	};
    };

    olink out_fld<export_all=2> => DVreset_extent.out;
    olink out_obj => obj.obj;
};

macro reset_minmax {
    ilink in_field<export_all=1>;

    int+IPort+OPort comp[] = {0};

    DVreset_minmax DVreset_minmax {
	in => in_field;
	&comp => <-.comp;
    };
    DVcomb_mesh_and_data DVcomb_mesh_and_data {
	in_mesh => in_field;
	in_nd =>  DVreset_minmax.out;
    };
    macro  ResetMinmaxUI {
	ilink in_fld => in_field;

	UImod_panel UIpanel {
	    parent<NEportLevels={4,0}>;
	    title => name_of(<-.<-.<-,1);
	    message = "Select reset minmax control panel.";
	};

	DVnode_data_labels DVnode_data_labels {
	    in => in_fld;
	    int+nres  ncomp => in.nnode_data;
	};
	UIoptionBoxLabel  UIoptionBoxLabel{
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    max => DVnode_data_labels.ncomp;
	    &selectedItems+IPort2 => <-.<-.comp;
	    title = "node data components";
	    visible => <-.UIpanel.visible;
	    y		= 0;
	    width	=> <-.UIpanel.width;
	};
    };

    DataObjectNoTexture obj {
	in => DVcomb_mesh_and_data.out;
	Obj {
	    name => name_of(<-.<-.<-);
	};
    };

    olink out_fld<export_all=2> => DVcomb_mesh_and_data.out;
    olink out_obj => obj.obj;
}; // reset_minmax

macro reset_minmax_cell {
    ilink in_field<export_all=1>;

    int+IPort+OPort comp[] = {0};

    DVreset_minmax_cell DVreset_minmax_cell {
	in => in_field;
	&comp => <-.comp;
    };

    macro  ResetMinmaxUI {
	ilink in_fld => in_field;

	UImod_panel UIpanel {
	    parent<NEportLevels={4,0}>;
	    title => name_of(<-.<-.<-,1);
	    message = "Select reset minmax_cell control panel.";
	};

	DVcell_data_labels DVcell_data_labels {
	    in => in_fld;
	};
	UIoptionBoxLabel  UIoptionBoxLabel {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVcell_data_labels.labels;
	    max => DVcell_data_labels.ncomp;
	    &selectedItems+IPort2 => <-.<-.comp;
	    title = "cell data components";
	    visible => <-.UIpanel.visible;
	    y		= 0;
	    width	=> <-.UIpanel.width;
	};
    };

    DataObjectNoTexture obj {
	in => DVreset_minmax_cell.out;
	Obj {
	    name => name_of(<-.<-.<-);
	};
    };

    olink out_fld<export_all=2> => DVreset_minmax_cell.out;
    olink out_obj => obj.obj;
}; // reset_minmax_cell

macro set_minmax {
    ilink in_field<export_all=1>;

    DV_Param_minmax SetMinmaxParam<export_all=2> {
	comp = 0;
	min+nres => cache(in_field.node_data[comp].min);
	max+nres => cache(in_field.node_data[comp].max);
    };

    DVset_minmax DVset_minmax {
	DV_Param_minmax+IPort2 &param => SetMinmaxParam;
	in => in_field;
	comp => param.comp;
	min => param.min;
	max => param.max;
    };
    DVcomb_mesh_and_data DVcomb_mesh_and_data {
	in_mesh => in_field;
	in_nd =>  DVset_minmax.out;
    };
    GMOD.instancer instancer {
	Value => UIpanel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => SetMinMaxUI;
    };
    UImod_panel UIpanel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-);
	message = "Select set minmax control panel.";
    };

    macro SetMinMaxUI<instanced=0> {
	ilink in_fld => in_field;
	DV_Param_minmax+IPort2 &param => SetMinmaxParam;

	DVnode_data_labels DVnode_data_labels {
	    in => in_fld;
	    int+nres  ncomp => in.nnode_data;
	};

	ilink UIpanel  => <-.UIpanel;
	UIradioBoxLabel  UIradioBoxLabel {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    &selectedItem+IPort2 => param.comp;
	    visible => <-.UIpanel.visible;
	    title = "data component";
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
	UIfieldTypein min_typein {
	    UIparent => <-.UIpanel;
	    flabel = "min value";
	    fval => <-.param.min;
	    y		=> <-.UIradioBoxLabel.y + <-.UIradioBoxLabel.height+4;
	    field.decimalPoints = 6;
	};
	UIfieldTypein max_typein {
	    UIparent => <-.UIpanel;
	    flabel = "max value";
	    fval => <-.param.max;
	    y		=> <-.min_typein.y + <-.min_typein.height+4;
	    field.decimalPoints = 6;
	};

	GMOD.parse_v reset_minmax {
            trigger => reset.do;
            v_commands =
                "param.min => cache(in_field.node_data[comp].min);
                 param.max => cache(in_field.node_data[comp].max);
                ";
            on_inst = 0;
            relative => <-;
	};
        UIbutton reset {
            parent => <-.UIpanel;
            y => max_typein.y + max_typein.height+4;
            label = "Reset";
        };
    };

    DataObjectNoTexture obj {
	in => DVcomb_mesh_and_data.out;
	Obj {
	    name => name_of(<-.<-.<-);
	};
    };

    olink out_fld<export_all=2> => DVcomb_mesh_and_data.out;
    olink out_obj => obj.obj;
}; // set_minmax

macro set_minmax_cell {
    ilink in_field<export_all=1>;

    DV_Param_minmax SetMinmaxParam<export_all=2> {
	comp = 0;
	min+nres => cache(in_field.cell_set[0].cell_data[comp].min);
	max+nres => cache(in_field.cell_set[0].cell_data[comp].max);
    };

    DVset_minmax_cell DVset_minmax_cell {
	DV_Param_minmax+IPort2 &param => SetMinmaxParam;
	in => in_field;
	comp => param.comp;
	min => param.min;
	max => param.max;
    };

    GMOD.instancer instancer {
	Value => UIpanel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => SetMinMaxUI;
    };
    UImod_panel UIpanel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-);
	message = "Select set minmax control panel.";
    };

    macro SetMinMaxUI<instanced=0> {
	ilink in_fld => in_field;
	DV_Param_minmax+IPort2 &param => SetMinmaxParam;
	DVcell_data_labels DVcell_data_labels {
	    in => in_fld;
	};
	ilink UIpanel  => <-.UIpanel;

	UIradioBoxLabel  UIradioBoxLabel {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVcell_data_labels.labels;
	    &selectedItem+IPort2 => param.comp;
	    visible => <-.UIpanel.visible;
	    title = "cell data component";
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
	UIfieldTypein min_typein {
	    UIparent => <-.UIpanel;
	    flabel = "min value";
	    fval => <-.param.min;
	    y		=> <-.UIradioBoxLabel.y + <-.UIradioBoxLabel.height+4;
	};
	UIfieldTypein max_typein {
	    UIparent => <-.UIpanel;
	    flabel = "max value";
	    fval => <-.param.max;
	    y		=> <-.min_typein.y + <-.min_typein.height+4;
	};

	GMOD.parse_v reset_minmax {
            trigger => reset.do;
            v_commands =
                "param.min => cache(in_field.cell_set[0].cell_data[comp].min);
                 param.max => cache(in_field.cell_set[0].cell_data[comp].max);
                ";
            on_inst = 0;
            relative => <-;
	};
        UIbutton reset {
            parent => <-.UIpanel;
            y => max_typein.y + max_typein.height+4;
            label = "Reset";
        };
    };

    DataObjectNoTexture obj {
	in => DVset_minmax_cell.out;
	Obj {
	    name => name_of(<-.<-.<-);
	};
    };

    olink out_fld<export_all=2> => DVset_minmax_cell.out;
    olink out_obj => obj.obj;
}; // set_minmax_cell

//////////////////////////
///// time series modules
//////////////////////////

macro set_global_extent {
    ilink in_field<export_all=1>;

     DVset_global_extent DVset_global_extent {
	in => <-.in_field;
    };

    olink out_fld<export_all=2> => DVset_global_extent.out;
};

macro set_global_minmax {
    ilink in_field<export_all=1>;

     DVset_global_minmax DVset_global_minmax {
	in => <-.in_field;
    };

    olink out_fld<export_all=2> => DVset_global_minmax.out;
};

macro set_global_minmax_cell {
    ilink in_field<export_all=1>;

     DVset_global_minmax_cell DVset_global_minmax_cell {
	in => <-.in_field;
    };

    olink out_fld<export_all=2> => DVset_global_minmax_cell.out;
};

macro extract_time_step {
    ilink in_field<export_all=1>;

    int+IPort2 step = 0;

    DVextract_time_step DVextract_time_step {
	in => in_field;
	&step => <-.step;
    };

    macro  ExtractStepUI {
	ilink in_fld => in_field;
	UImod_panel UIpanel {
	    parent<NEportLevels={4,0}>;
	    title => name_of(<-.<-.<-,1);
	    message = "Select extract time step control panel.";
	};
	UIfieldTypein step_typein {
	    UIparent => <-.UIpanel;
	    flabel = "time step index";
	    fval => <-.<-.step;
	    field.mode = 1;
	    y		= 0;
	};

    };
    DataObjectNoTexture obj {
	in => DVextract_time_step.out;
	Obj {
	    name => name_of(<-.<-.<-);
	};
    };

    olink out_fld<export_all=2> => DVextract_time_step.out;
    olink out_obj => obj.obj;
}; // extract_time_step

macro interp_time_step {
    ilink in_field<export_all=1>;

    double+IPort2 time = 0;

    DVinterp_time_step DVinterp_time_step {
	in => in_field;
	&time => <-.time;
    };

    macro  InterpStepUI {
	ilink in_fld => in_field;
	UImod_panel UIpanel {
	    parent<NEportLevels={4,0}>;
	    title => name_of(<-.<-.<-,1);
	    message = "Select interp time step control panel.";
	};
	UIfieldTypein time_typein {
	    UIparent => <-.UIpanel;
	    flabel = "time value";
	    fval => <-.<-.time;
	    field.mode = 2;
	    y		= 0;
	};

    };
    DataObjectNoTexture obj {
	in => DVinterp_time_step.out;
	Obj {
	    name => name_of(<-.<-.<-);
	};
    };

    olink out_fld<export_all=2> => DVinterp_time_step.out;
    olink out_obj => obj.obj;
}; // interp_time_step

#ifdef GIS_KIT
    GIS_UI.GISMapTransform GISMapTransform;
#endif

}; // Filters

library+sort+buffered Mappers {

macro surf_plot {
    ilink in_field<export_all=1>;

    DV_Param_surf_plot SurfPlotParam<export_all=2> {
	component = 0;
	scale = 1.0;
	offset = 0.0;
	nspace+nres => cache(min_array({<-.in_field.nspace, 
			3-(<-.in_field.node_data[component].veclen)}, 0, 0));
    };

    DVsurf_plot  DVsurf_plot {
	DV_Param_surf_plot+IPort2 &param => SurfPlotParam;
	in => in_field;
	&component => param.component;
	&scale => param.scale;
	&offset => param.offset;
	&nspace => param.nspace;
    };

    GMOD.instancer instancer {
	Value => UIpanel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => SurfPlotUI;
    };
    UImod_panel UIpanel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-);
	message = "Select surf_plot control panel.";
    };

    macro SurfPlotUI<instanced=0> {
	ilink in_fld => in_field;
	DV_Param_surf_plot+IPort2 &param => SurfPlotParam;

	DVnode_data_labels DVnode_data_labels {
	    in => in_fld;
	    int+nres  ncomp => in.nnode_data;
	};
	DVmesh_extent DVmesh_extent {
	    in => in_fld;
	};
	ilink UIpanel  => <-.UIpanel;

	float+nres max_val => in_fld.node_data[param.component].max;
	float+nres min_val => in_fld.node_data[param.component].min;
	float+nres min_max_val => max_array({abs(max_val),abs(min_val)});
	float+nres m_val => abs(max_val-min_val);


	UIradioBoxLabel   UIradioBoxLabel {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    &selectedItem+IPort2 => param.component;
	    visible => <-.UIpanel.visible;
	    title = "data component";
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};

	UIslider nspace_slider {
	    parent => <-.UIpanel;
	    title = "input nspace";
	    mode = 1;
	    max = 3.0;
	    value+IPort2 => param.nspace;
	    y		=> <-.UIradioBoxLabel.y + <-.UIradioBoxLabel.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIslider scale_slider {
	    parent => <-.UIpanel;
	    title = "scale";
	    min+nres => cache((-5)*(<-.DVmesh_extent.extent/<-.m_val));
	    max+nres => cache(( 5)*(<-.DVmesh_extent.extent/<-.m_val));
	    value+IPort2 => param.scale;
	    y		=> <-.nspace_slider.y + <-.nspace_slider.height + 4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein scale_slider_typein {
	    slider	=> scale_slider;
        };
	UIslider offset_slider {
	    parent => <-.UIpanel;
	    title = "offset";
	    value+IPort2 => param.offset;
	    min+nres => (-2)*(<-.DVmesh_extent.extent+<-.min_max_val);
	    max+nres => ( 2)*(<-.DVmesh_extent.extent+<-.min_max_val);
	    y		=> <-.scale_slider.y + <-.scale_slider.height + 4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein offset_slider_typein {
	    slider	=> offset_slider;
        };
    };

    DataObjectNoTexture obj {
	in => DVsurf_plot.out;
	Obj {
	    name => name_of(<-.<-.<-);
	    xform_mode = GD_XFORM_MODE_PARENT;
	};
    };

    olink out_fld<export_all=2> => DVsurf_plot.out;
    olink out_obj => obj.obj;
}; // surf_plot

macro surf_optimize {
    ilink in_field<export_all=1>;

   float+nres tolerance<export=2> => 0.1 * (in_field.node_data[0].max - in_field.node_data[0].min);

    DVsurf_optimize DVsurf_optimize {
	in => in_field;
	tolerance => <-.tolerance;
    };

    macro SurfOptimizeUI {
	ilink in_fld => in_field;

	UImod_panel UIpanel {
	    parent<NEportLevels={4,0}>;
	    title => name_of(<-.<-.<-);
	    message = "Select surf_optimize control panel.";
	};

	UIslider scale_slider {
	    parent => <-.UIpanel;
	    title = "tolerance";

	    min = 0.0;
	    max+nres => abs(in_fld.node_data[0].max - in_fld.node_data[0].min);
	    value+IPort3 => <-.<-.tolerance;
	    y		= 0;
	    width	=> <-.UIpanel.width;
	};
    };

    DataObjectNoTexture obj {
	in => DVsurf_optimize.out;
	Obj {
	    name => name_of(<-.<-.<-);
	    xform_mode = GD_XFORM_MODE_PARENT;
	};
    };

    olink out_fld<export_all=2> => DVsurf_optimize.out;
    olink out_obj => obj.obj;
}; // surf_optimize

macro ribbons_plot {
    ilink in_field<export_all=1>;

    DV_Param_surf_ribbons SurfRibParam<export_all=2> {
	ribbon_dir = 0;
	height_comp = 0;
	map_comp = 0;
	scale = 1.0;
	offset = 0.0;
    };

    DVsurf_ribbons  DVsurf_ribbons {
	DV_Param_surf_ribbons+IPort2 &param => SurfRibParam;
	in => in_field;
	&ribbon_dir => param.ribbon_dir;
	&height_comp => param.height_comp;
	&map_comp => param.map_comp;
	&scale => param.scale;
	&offset => param.offset;
    };

    GMOD.instancer instancer {
	Value => UIpanel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => SurfRibUI;
    };
    UImod_panel UIpanel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-);
	message = "Select surf_ribbons control panel.";
    };

    macro SurfRibUI<instanced=0> {
	ilink in_fld => in_field;
	DV_Param_surf_ribbons+IPort2 &param => SurfRibParam;

	DVnode_data_labels DVnode_data_labels {
	    in => in_fld;
	    int+nres  ncomp => in.nnode_data;
	};
	DVmesh_extent DVmesh_extent {
	    in => in_fld;
	};
	ilink UIpanel  => <-.UIpanel;

	UIradioBoxLabel UIradioBoxLabel_dir {
	    parent => <-.UIpanel;
	    labels => {"X", "Y"};
	    &selectedItem+IPort2 => param.ribbon_dir;
	    visible => <-.UIpanel.visible;
	    title = "ribbon direction";
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};

	UIradioBoxLabel UIradioBoxLabel_height {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    &selectedItem+IPort2 => param.height_comp;
	    visible => <-.UIpanel.visible;
	    title = "height data";
	    y		=> <-.UIradioBoxLabel_dir.y + <-.UIradioBoxLabel_dir.height + 4;
	    width	=> <-.UIpanel.width;
	};

	UIradioBoxLabel UIradioBoxLabel_map {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    &selectedItem+IPort2 => param.map_comp;
	    visible => <-.UIpanel.visible;
	    title = "map data";
	    y		=> <-.UIradioBoxLabel_height.y + <-.UIradioBoxLabel_height.height + 4;
	    width	=> <-.UIpanel.width;
	};

	UIslider scale_slider {
	    parent => <-.UIpanel;
	    title = "scale";

	    float+nres max_val => in_fld.node_data[param.height_comp].max;
	    float+nres min_val => in_fld.node_data[param.height_comp].min;
	    float+nres min_max_val => max_array({abs(max_val),abs(min_val)});
	    min+nres => cache((-10)*(<-.DVmesh_extent.extent/min_max_val));
            max+nres => cache(( 10)*(<-.DVmesh_extent.extent/min_max_val));
	    value+IPort2 => param.scale;
	    y		=> <-.UIradioBoxLabel_map.y + <-.UIradioBoxLabel_map.height + 4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein scale_slider_typein {
	    slider	=> scale_slider;
        };

	UIslider offset_slider {
	    parent => <-.UIpanel;
	    title = "offset";
	    value+IPort2 => param.offset;
	    y		=> <-.scale_slider.y + <-.scale_slider.height + 4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein offset_slider_typein {
	    slider	=> offset_slider;
        };
    };

    DataObjectNoTexture obj {
	in => DVsurf_ribbons.out;
	Obj {
	    xform_mode = GD_XFORM_MODE_PARENT;
	};
    };

    olink out_fld<export_all=2> => DVsurf_ribbons.out;
    olink out_obj => obj.obj;
}; // ribbons_plot

macro table_to_uniform_field {
     imlink  columns<export_all=1>;

     DVtable_xyz_create  xyz_create {
	reset = 1;
	columns+req => 	<-.columns;
	&xyz_select => <-.xyz_select;
	&field_xyz[] => <-.xyz;
     };
     DVtable_data_create  data_create {
	reset = 1;
	count_records = 1;
	ncol => <-.xyz_create.ncol;
	columns+req =>	 <-.columns;
	&data_select =>	 <-.data_select;
	&field_data[] => <-.data;
     };

     DVtable_xyz_select 	xyz_select;
     DVtable_data_select	data_select;

     int  ncol=> xyz_create.ncol;

     DVtable_xyz 		xyz[ncol];
     DVtable_data 		data[ncol+1];

     string 	&xyz_names[] =>   xyz_create.xyz_names;
     string 	&data_names[] =>  data_create.data_names;

     DVtable_to_unif field_create {
	xyz_select => <-.xyz_select;
	field_xyz  => <-.xyz;
	data_select=> <-.data_select;
	field_data => <-.data;
     };
     macro Uniform_Field_UI {

	UImod_panel UIpanel {
		parent<NEportLevels={4,0}>;
		title => name_of(<-.<-.<-);
		UIshell.title => name_of(<-.<-.<-.<-);
		height => <-.DATApanel.y+<-.DATApanel.height+10;
	    	message = "Select Uniform_Field control panel";
#ifndef MSDOS
		width = 280;
#endif
	};

	UIframe XYZpanel {
       	  	parent => <-.UIpanel;
		visible => <-.UIpanel.visible;
		x = 0;
          	y = 4;
       	  	width	=> <-.UIpanel.width;
		height = 510;
	};
	UIframe DATApanel {
       	  	parent => <-.UIpanel;
		visible => <-.UIpanel.visible;
		x = 0;
          	y => <-.XYZpanel.y + <-.XYZpanel.height+12;
       	  	width	=> <-.UIpanel.width;
       		height = 360;
	};
	UIlabel XYZlabel {
		parent => <-.XYZpanel;
		visible => <-.XYZpanel.visible;
		label = "Field Coordinates";
		width	=> <-.XYZpanel.width/2;
		x = 0;
		y = 0;
       	  	width	=> <-.UIpanel.width;
		alignment = 0;
	};

	UIoptionMenuLabel UIoptionMenuLabel_X {
	        parent => <-.XYZpanel;
		labels+nres => xyz_names;
		selectedItem => <-.<-.xyz_select.xyz_axis[0];
		visible => <-.XYZpanel.visible;
		title = "X Axis";
		width	=> <-.x_toggle.x - 5 - .x;
		x = 0;
		y => <-.XYZlabel.y + <-.XYZlabel.height+6;
	};
	UItoggle x_toggle {
	    	parent => <-.XYZpanel;
	    	label = "ON";
		visible => <-.XYZpanel.visible;
	    	&set+IPort2 => <-.<-.xyz_select.xyz_set[0];
	    	x	=> <-.XYZpanel.width - .width;
	    	y	=> <-.UIoptionMenuLabel_X.y+2;
	    	width	=  50;
	};
	UIoptionMenuLabel UIoptionMenuLabel_Y {
	        parent => <-.XYZpanel;
		labels+nres => xyz_names;
		selectedItem => <-.<-.xyz_select.xyz_axis[1];
		visible => <-.XYZpanel.visible;
		title = "Y Axis";
		width	=> <-.y_toggle.x - 5 - .x;
		x = 0;
		y => UIoptionMenuLabel_X.y+UIoptionMenuLabel_X.height+4;
	};
	UItoggle y_toggle {
	    	parent => <-.XYZpanel;
	    	label = "ON";
		visible => <-.XYZpanel.visible;
	    	&set+IPort2 => <-.<-.xyz_select.xyz_set[1];
	    	x	=> <-.XYZpanel.width - .width;
	    	y	=> <-.UIoptionMenuLabel_Y.y+2;
	    	width	=  50;
	};
	UIoptionMenuLabel UIoptionMenuLabel_Z {
	        parent => <-.XYZpanel;
		labels+nres => xyz_names;
		selectedItem => <-.<-.xyz_select.xyz_axis[2];
		visible => <-.XYZpanel.visible;
		title = "Z Axis";
		width	=> <-.z_toggle.x - 5 - .x;
		x = 0;
		y => UIoptionMenuLabel_Y.y+UIoptionMenuLabel_Y.height+4;
	};
	UItoggle z_toggle {
	    	parent => <-.XYZpanel;
	    	label = "ON";
		visible => <-.XYZpanel.visible;
	    	&set+IPort2 => <-.<-.xyz_select.xyz_set[2];
	    	x	=> <-.XYZpanel.width - .width;
	    	y	=> <-.UIoptionMenuLabel_Z.y+2;
	    	width	=  50;
	};
	UIoptionMenuLabel UIoptionMenuLabel_XYZ {
	        parent => <-.XYZpanel;
		labels+nres => <-.<-.xyz.name;
		selectedItem = 0;
		visible => <-.XYZpanel.visible;
		title = "Axis Setup";
		width	=> <-.XYZpanel.width - 10;
		x = 0;
		y => <-.z_toggle.y+<-.z_toggle.height+30;
	};
	group  XYZ_set {
		UI.UIframe UIframe_XYZ {
        	  	parent => <-.<-.XYZpanel;
			visible => <-.<-.XYZpanel.visible;
			x = 0;
	          	y => <-.<-.UIoptionMenuLabel_XYZ.y + <-.<-.UIoptionMenuLabel_XYZ.height+10;
        	  	width	=> <-.<-.XYZpanel.width - 6;
          		height = 310;
       		};

		UIlabel UIlabel {
			parent => <-.UIframe_XYZ;
			visible => <-.UIframe_XYZ.visible;
			label => "Axis Setup Parameters";
			y = 0;
			width = 150;
		};

		UItoggle discrete_toggle {
    			parent => <-.UIframe_XYZ;
			visible => <-.UIframe_XYZ.visible;
	    		label = "Discrete";
    			&set => <-.<-.<-.xyz[<-.<-.UIoptionMenuLabel_XYZ.selectedItem].discrete;
    			x	= 0;
	    		y	= 30;
    			width	=> <-.UIframe_XYZ.width;
		};
		UIfieldTypein min_typein {
	    		UIparent => <-.UIframe_XYZ;
	    		flabel = "Min value";
	    		fval => <-.<-.<-.xyz[<-.<-.UIoptionMenuLabel_XYZ.selectedItem].min;
	    		y		=> <-.discrete_toggle.y + <-.discrete_toggle.height+4;
	    		panel.width	=> <-.<-.UIframe_XYZ.width;
			label.width	=> <-.panel.width / 4;
			field.x		=> <-.panel.width / 3;
			field.active	=> <-.<-.<-.<-.xyz[<-.<-.<-.UIoptionMenuLabel_XYZ.selectedItem].discrete^1;
		};
		UIfieldTypein max_typein {
	    		UIparent => <-.UIframe_XYZ;
	    		flabel = "Max value";
	    		fval => <-.<-.<-.xyz[<-.<-.UIoptionMenuLabel_XYZ.selectedItem].max;
	    		y		=> <-.min_typein.y + <-.min_typein.height+4;
	    		panel.width	=> <-.<-.UIframe_XYZ.width;
			label.width	=> <-.panel.width / 4;
			field.x		=> <-.panel.width / 3;
			field.active	=> <-.<-.<-.<-.xyz[<-.<-.<-.UIoptionMenuLabel_XYZ.selectedItem].discrete^1;
		};
		UIfieldTypein bin_typein {
	    		UIparent => <-.UIframe_XYZ;
	    		flabel = "Bin size";
	    		fval => <-.<-.<-.xyz[<-.<-.UIoptionMenuLabel_XYZ.selectedItem].bin_size;
	    		y		=> <-.max_typein.y + <-.max_typein.height+4;
	    		panel.width	=> <-.<-.UIframe_XYZ.width;
			label.width	=> <-.panel.width / 4;
			field.x		=> <-.panel.width / 3;
			field.active	=> <-.<-.<-.<-.xyz[<-.<-.<-.UIoptionMenuLabel_XYZ.selectedItem].discrete^1;
		};
		UItoggle normalize_toggle {
    			parent => <-.UIframe_XYZ;
			visible => <-.UIframe_XYZ.visible;
	    		label = "normalize axis";
    			&set => <-.<-.<-.xyz[<-.<-.UIoptionMenuLabel_XYZ.selectedItem].normalize;
    			x	= 0;
	    		y	=> <-.bin_typein.y + <-.bin_typein.height+4;
    			width	=> <-.UIframe_XYZ.width;
		};
		UItoggle label_set_toggle {
    			parent => <-.UIframe_XYZ;
			visible => <-.UIframe_XYZ.visible;
	    		label = "set labels";
    			&set => <-.<-.<-.xyz[<-.<-.UIoptionMenuLabel_XYZ.selectedItem].set_labels;
    			x	= 0;
	    		y	=> <-.normalize_toggle.y + <-.normalize_toggle.height+4;
    			width	=> <-.UIframe_XYZ.width;
		};
		UItoggle label_toggle {
    			parent => <-.UIframe_XYZ;
			visible => <-.UIframe_XYZ.visible;
	    		label = "index labels";
    			&set => <-.<-.<-.xyz[<-.<-.UIoptionMenuLabel_XYZ.selectedItem].index_labels;
    			x	= 0;
	    		y	=> <-.label_set_toggle.y + <-.label_set_toggle.height+4;
    			width	=> <-.UIframe_XYZ.width;
			active	=> <-.<-.<-.xyz[<-.<-.UIoptionMenuLabel_XYZ.selectedItem].set_labels+0;
		};
		UIslider step_slider {
	    		parent => <-.UIframe_XYZ;
	    		title = "label step";
	    		min = 1;
	    		max = 12;
	    		value+IPort2 => <-.<-.<-.xyz[<-.<-.UIoptionMenuLabel_XYZ.selectedItem].label_step;
	    		mode = 1;
	    		y	=> <-.label_toggle.y + <-.label_toggle.height + 4;
    			width	=> <-.UIframe_XYZ.width-10;
			active	=> <-.<-.<-.xyz[<-.<-.UIoptionMenuLabel_XYZ.selectedItem].set_labels+0;
		};
	};
	UIlabel DATAlabel {
		parent => <-.DATApanel;
		visible => <-.DATApanel.visible;
		label = "Field Data";
		width	=> <-.DATApanel.width/2;
		x = 0;
		y = 0;
		alignment = 0;

	};
	UIscrolledWindow UIscrolledWindow {
		resizeMode = 1;
                scrollBars = 1;
	    	parent => <-.DATApanel;
		x = 0;
	    	y => <-.DATAlabel.y + <-.DATAlabel.height+4;
	    	width	=> <-.DATApanel.width-10;
		height  => <-.DATApanel.height-130;
	    	visible => <-.DATApanel.visible;
		virtualHeight => <-.UIoptionBoxLabel_Data.height;
	};
	UIoptionBoxLabel UIoptionBoxLabel_Data {
		UIlabel.visible = 0;
		UIlabel.height = 0;
	    	parent => <-.UIscrolledWindow;
	    	labels+IPort2 => data_names;
	    	max => ncol+1;
	    	&selectedItems+IPort2 => <-.<-.data_select.data;
	    	title = "";
	    	visible => <-.UIscrolledWindow.visible;
		x = 0;
	    	y = 0;
	    	width	=> <-.UIscrolledWindow.width;
		UIlabel.width => <-.<-.UIscrolledWindow.width/2;
	};
	UIoptionMenuLabel UIoptionMenuLabel_Data {
	        parent => <-.DATApanel;
		labels+nres => <-.<-.data.name;
		selectedItem = 1;
		visible => <-.DATApanel.visible;
		title = "Data Setup";
		width	=> <-.DATApanel.width - 10;
		x = 0;
		y => <-.UIscrolledWindow.y + <-.UIscrolledWindow.height + 10;
	};
	group  Data_set {
		UI.UIpanel UIframe_Data {
        	  	parent => <-.<-.DATApanel;
			visible => <-.<-.DATApanel.visible;
			x = 0;
	          	y => <-.<-.UIoptionMenuLabel_Data.y + <-.<-.UIoptionMenuLabel_Data.height+6;
        	  	width	=> <-.<-.DATApanel.width;
          		height = 120;
       		};

		UIradioBoxLabel UIradioBoxLabel {
			UIlabel.height = 0;
		    	parent => <-.UIframe_Data;
		    	labels => {"sum", "average"};
		    	&selectedItem+IPort2 => <-.<-.<-.data[<-.<-.UIoptionMenuLabel_Data.selectedItem].operation;
		    	visible => <-.UIframe_Data.visible;
		    	title = "";
		    	y		=  0;
		    	width	=> <-.UIframe_Data.width;
			UIradioBox.active	=> <-.<-.<-.<-.data[<-.<-.<-.UIoptionMenuLabel_Data.selectedItem].count_records^1;
		};
	};
     };
     DataObjectNoTexture obj {
	in => field_create.out;
	Obj {
	    name => name_of(<-.<-.<-);
	};
     };

     olink out_fld<export_all=2> => field_create.out;
     olink out_obj => obj.obj;
     group+OPort2 axis_labels<export_all=2> {
     	string x_labels[] => <-.field_create.x_labels;
     	string y_labels[] => <-.field_create.y_labels;
     	string z_labels[] => <-.field_create.z_labels;
     };
     olink  x_name<export_all=2> => field_create.x_name;
     olink  y_name<export_all=2> => field_create.y_name;
     olink  z_name<export_all=2> => field_create.z_name;

}; // table_to_uniform_field

macro table_to_scatter_field {
     imlink  columns<export_all=1>;

     DVtable_xyz_create  xyz_create {
	reset = 1;
	columns+req => 	<-.columns;
	&xyz_select => <-.xyz_select;
	&field_xyz[] => <-.xyz;
     };
     DVtable_data_create  data_create {
	reset = 1;
	count_records = 0;
	ncol => <-.xyz_create.ncol;
	columns+req =>	 <-.columns;
	&data_select =>	 <-.data_select;
	&field_data[] => <-.data;
     };

     DVtable_xyz_select 	xyz_select;
     DVtable_data_select 	data_select;

     int  ncol => xyz_create.ncol;

     DVtable_xyz		xyz[ncol];
     DVtable_data		data[ncol];

     int cell_type = 0;

     string 	&xyz_names[] =>  xyz_create.xyz_names;
     string 	&data_names[] =>  data_create.data_names;

     DVtable_to_scat field_create {
	xyz_select => <-.xyz_select;
	field_xyz  => <-.xyz;
	data_select=> <-.data_select;
	field_data => <-.data;
	cell_type  => <-.cell_type;
     };

     macro Scatter_Field_UI {

	UImod_panel UIpanel {
		parent<NEportLevels={4,0}>;
		title => name_of(<-.<-.<-);
		UIshell.title => name_of(<-.<-.<-.<-);
	    	message = "Select Scatter_Field control panel.";
		height => <-.DATApanel.y+<-.DATApanel.height+10;
#ifndef MSDOS
		width = 280;
#endif
	};

	UIframe XYZpanel {
       	  	parent => <-.UIpanel;
		visible => <-.UIpanel.visible;
		x = 0;
          	y = 4;
       	  	width	=> <-.UIpanel.width;
		//height = 300;
		height+nres => <-.UIoptionMenuLabel_CellSet.y + <-.UIoptionMenuLabel_CellSet.height + 10;
	};
	UIframe DATApanel {
       	  	parent => <-.UIpanel;
		visible => <-.UIpanel.visible;
		x = 0;
          	y => <-.XYZpanel.y + <-.XYZpanel.height+12;
       	  	width	=> <-.UIpanel.width;
       		//height = 360;
		height+nres => <-.Data_set.UIframe_Data.height + <-.Data_set.UIframe_Data.y;
	};
	UIlabel XYZlabel {
		parent => <-.XYZpanel;
		visible => <-.XYZpanel.visible;
		label = "Field Coordinates";
		width	=> <-.XYZpanel.width/2;
		x = 0;
		y = 0;
       	  	width	=> <-.UIpanel.width;
		alignment = 0;
	};

	UIoptionMenuLabel UIoptionMenuLabel_X {
	        parent => <-.XYZpanel;
		labels+nres => xyz_names;
		selectedItem => <-.<-.xyz_select.xyz_axis[0];
		visible => <-.XYZpanel.visible;
		title = "X axis";
		width	=> <-.x_toggle.x - 5 - .x;
		x = 0;
		y => <-.XYZlabel.y + <-.XYZlabel.height+6;
	};
	UItoggle x_toggle {
	    	parent => <-.XYZpanel;
	    	label = "ON";
		visible => <-.XYZpanel.visible;
	    	&set+IPort2 => <-.<-.xyz_select.xyz_set[0];
	    	x	=> <-.XYZpanel.width - .width;
	    	y	=> <-.UIoptionMenuLabel_X.y+2;
	    	width	=  50;
	};
	UIoptionMenuLabel UIoptionMenuLabel_Y {
	        parent => <-.XYZpanel;
		labels+nres => xyz_names;
		selectedItem => <-.<-.xyz_select.xyz_axis[1];
		visible => <-.XYZpanel.visible;
		title = "Y axis";
		width	=> <-.y_toggle.x - 5 - .x;
		x = 0;
		y => UIoptionMenuLabel_X.y+UIoptionMenuLabel_X.height+4;
	};
	UItoggle y_toggle {
	    	parent => <-.XYZpanel;
	    	label = "ON";
		visible => <-.XYZpanel.visible;
	    	&set+IPort2 => <-.<-.xyz_select.xyz_set[1];
	    	x	=> <-.XYZpanel.width - .width;
	    	y	=> <-.UIoptionMenuLabel_Y.y+2;
	    	width	=  50;
	};
	UIoptionMenuLabel UIoptionMenuLabel_Z {
	        parent => <-.XYZpanel;
		labels+nres => xyz_names;
		selectedItem => <-.<-.xyz_select.xyz_axis[2];
		visible => <-.XYZpanel.visible;
		title = "Z axis";
		width	=> <-.z_toggle.x - 5 - .x;
		x = 0;
		y => UIoptionMenuLabel_Y.y+UIoptionMenuLabel_Y.height+4;
	};
	UItoggle z_toggle {
	    	parent => <-.XYZpanel;
	    	label = "ON";
		visible => <-.XYZpanel.visible;
	    	&set+IPort2 => <-.<-.xyz_select.xyz_set[2];
	    	x	=> <-.XYZpanel.width - .width;
	    	y	=> <-.UIoptionMenuLabel_Z.y+2;
	    	width	=  50;
	};
	UIoptionMenuLabel UIoptionMenuLabel_XYZ {
	        parent => <-.XYZpanel;
		labels+nres => <-.<-.xyz.name;
		selectedItem = 0;
		visible => <-.XYZpanel.visible;
		title = "Axis Setup";
		width	=> <-.XYZpanel.width - 10;
		x = 0;
		y => <-.z_toggle.y+<-.z_toggle.height+30;
	};
	group  XYZ_set {
		UI.UIpanel UIframe_XYZ {
        	  	parent => <-.<-.XYZpanel;
			visible => <-.<-.XYZpanel.visible;
			x = 0;
	          	y => <-.<-.UIoptionMenuLabel_XYZ.y + <-.<-.UIoptionMenuLabel_XYZ.height+10;
        	  	width	=> <-.<-.XYZpanel.width;
          		height = 40;
       		};
		int which_axis      => <-.UIoptionMenuLabel_XYZ.selectedItem;
		UItoggle discrete_toggle {
    			parent => <-.UIframe_XYZ;
			visible => <-.UIframe_XYZ.visible;
	    		label => "discrete";  /* + xyz_names[which_axis] */
    			&set => <-.<-.<-.xyz[which_axis].discrete;
    			x	= 0;
	    		y	= 0;
    			//width	=> <-.UIframe_XYZ.width;
		};
	};
	UIoptionMenuLabel UIoptionMenuLabel_CellSet {
		parent => <-.XYZpanel;
		labels => { "Points", "Lines" };
		selectedItem => <-.<-.cell_type;
		visible => <-.XYZpanel.visible;
		title = "Field Type";
		width	=> <-.XYZpanel.width - 10;
		x = 0;
		y => <-.XYZ_set.UIframe_XYZ.y + <-.XYZ_set.UIframe_XYZ.height+10;
	};

	UIlabel DATAlabel {
		parent => <-.DATApanel;
		visible => <-.DATApanel.visible;
		label = "Field Data";
		width	=> <-.DATApanel.width/2;
		x = 0;
		y = 0;
		alignment = 0;
	};
	UIscrolledWindow UIscrolledWindow {
		resizeMode = 1;
                scrollBars = 1;
	    	parent => <-.DATApanel;
		x = 0;
	    	y => <-.DATAlabel.y + <-.DATAlabel.height+4;
	    	width	=> <-.DATApanel.width-10;
		// height  => <-.DATApanel.height*0.5;
		height  = 180;
	    	visible => <-.DATApanel.visible;
		virtualHeight => <-.UIoptionBoxLabel_Data.height;
	};
	UIoptionBoxLabel UIoptionBoxLabel_Data {
		UIlabel.visible = 0;
		UIlabel.height = 0;
	    	parent => <-.UIscrolledWindow;
	    	labels+IPort2 => data_names;
	    	max => ncol+1;
	    	&selectedItems+IPort2 => <-.<-.data_select.data;
	    	title = "";
	    	visible => <-.UIscrolledWindow.visible;
		x = 0;
	    	y = 0;
	    	width	=> <-.UIscrolledWindow.width;
		UIlabel.width => <-.<-.UIscrolledWindow.width/2;
	};
	UIoptionMenuLabel UIoptionMenuLabel_Data {
	        parent => <-.DATApanel;
		labels+nres => <-.<-.data.name;
		selectedItem = 0;
		visible => <-.DATApanel.visible;
		title = "Data Setup";
		width	=> <-.DATApanel.width - 10;
		x = 0;
		y => <-.UIscrolledWindow.y + <-.UIscrolledWindow.height + 10;
	};
	group  Data_set {
		UI.UIpanel UIframe_Data {
        	  	parent => <-.<-.DATApanel;
			visible => <-.<-.DATApanel.visible;
			x = 0;
	          	y => <-.<-.UIoptionMenuLabel_Data.y + <-.<-.UIoptionMenuLabel_Data.height+6;
        	  	width	=> <-.<-.DATApanel.width;
          		height = 40;
       		};

		UItoggle radius_toggle {
		    	parent => <-.UIframe_Data;
			visible => <-.UIframe_Data.visible;
	    		label = "sphere radius";
    			&set => <-.<-.<-.data[<-.<-.UIoptionMenuLabel_Data.selectedItem].operation;
    			x	= 0;
	    		y	=> 0;
    			//width	=> <-.UIframe_Data.width;
		};
	};
     };
     DataObjectNoTexture obj {
	in => field_create.out;
	Obj {
	    name => name_of(<-.<-.<-);
	};
     };

     olink out_fld<export_all=2> => field_create.out;
     olink out_obj => obj.obj;
     olink  x_name<export_all=2> => field_create.x_name;
     olink  y_name<export_all=2> => field_create.y_name;
     olink  z_name<export_all=2> => field_create.z_name;

}; // table_to_scatter_field


macro texture_mesh {
    ilink in_field<export_all=1>;
    ilink texture<export_all=1>;

    DV_Param_texture_mesh TextureMeshParam<export_all=2> {
	uv_switch = 0;
	u_flip = 0;
	v_flip = 0;
	u_scale = 1.0;
	v_scale = 1.0;
	u_shift = 0.0;
	v_shift = 0.0;
    };

    DVmesh_uv DVmesh_uv {
	DV_Param_texture_mesh+IPort2 &param => TextureMeshParam;
	in => in_field;
	&uv_switch => param.uv_switch;
	&u_flip => param.u_flip;
	&v_flip => param.v_flip;
	&u_scale => param.u_scale;
	&v_scale => param.v_scale;
	&u_shift => param.u_shift;
	&v_shift => param.v_shift;
    };
    GMOD.instancer instancer {
	Value => UIpanel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => TextureMeshUI;
    };
    UImod_panel UIpanel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-);
	message = "Select texture_mesh control panel.";
    };

    macro TextureMeshUI <instanced=0> {
	ilink in_fld => in_field;
	DV_Param_texture_mesh+IPort2 &param => TextureMeshParam;

	ilink UIpanel  => <-.UIpanel;

	UItoggle uv_toggle {
	    parent => <-.UIpanel;
	    label = "switch uv";
	    &set+IPort2 => param.uv_switch;
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
	UItoggle u_toggle {
	    parent => <-.UIpanel;
	    label = "flip u";
	    &set+IPort2 => param.u_flip;
	    y		=> <-.uv_toggle.y + <-.uv_toggle.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UItoggle v_toggle {
	    parent => <-.UIpanel;
	    label = "flip v";
	    &set+IPort2 => param.v_flip;
	    y		=> <-.u_toggle.y + <-.u_toggle.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIslider u_scale_slider {
	    parent => <-.UIpanel;
	    title = "u scale";
	    min = 0.0;
	    max = 10.0;
	    value+IPort2 => param.u_scale;
	    y		=> <-.v_toggle.y + <-.v_toggle.height + 4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein u_scale_slider_typein {
	    slider	=> u_scale_slider;
        };
	UIslider v_scale_slider {
	    parent => <-.UIpanel;
	    title = "v scale";
	    min = 0.0;
	    max = 10;
	    value+IPort2 => param.v_scale;
	    y		=> <-.u_scale_slider.y + <-.u_scale_slider.height + 4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein v_scale_slider_typein {
	    slider	=> v_scale_slider;
        };
	UIslider u_shift_slider {
	    parent => <-.UIpanel;
	    title = "u shift";
	    min = -10.0;
	    max = 10.0;
	    value+IPort2 => param.u_shift;
	    y		=> <-.v_scale_slider.y + <-.v_scale_slider.height + 4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein u_shift_slider_typein {
	    slider	=> u_shift_slider;
        };
	UIslider v_shift_slider {
	    parent => <-.UIpanel;
	    title = "v shift";
	    min = -10.0;
	    max = 10.0;
	    value+IPort2 => param.v_shift;
	    y		=> <-.u_shift_slider.y + <-.u_shift_slider.height + 4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein v_shift_slider_typein {
	    slider	=> v_shift_slider;
        };
    };

    DataObject obj {
	in => DVmesh_uv.out;
	texture_in => <-.texture;
	Obj {
	    name => name_of(<-.<-.<-);
/* The following setting removed per CFS 20791
	    xform_mode = GD_XFORM_MODE_PARENT;
*/
	};
    };

    olink out_fld<export_all=2> => DVmesh_uv.out;
    olink out_obj => obj.obj;
}; // texture_mesh

#ifdef GIS_KIT
macro texture_sphere {
    ilink texture<export_all=1>;

    DV_Param_texture_sphere TextureSphereParam<export_all=2> {
	sphere_dims={24,24};
	longitude = {0.,360.};
	latitude = {-90.,90.};
	radius = 6378000.;
    };

    Texture_Sphere Texture_Sphere {
	DV_Param_texture_sphere+IPort2 &param => TextureSphereParam;
    };
    GMOD.instancer instancer {
	Value => UIpanel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => TextureSphereUI;
    };
    UImod_panel UIpanel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-);
	message = "Select texture_sphere control panel.";
    };

    macro TextureSphereUI <instanced=0> {
	DV_Param_texture_sphere+IPort2 &param => TextureSphereParam;

	ilink UIpanel  => <-.UIpanel;

	UIslider lon_dim_slider {
	    parent => <-.UIpanel;
	    title = "longitude dimension";
	    min = 0;
	    max = 100;
	    mode = 1;
	    value+IPort2 => param.sphere_dims[0];
	    y		= 0;
	    width	=> <-.UIpanel.width;
	};
	UIslider lat_dim_slider {
	    parent => <-.UIpanel;
	    title = "latitude dimension";
	    min = 0;
	    max = 100;
	    mode = 1;
	    value+IPort2 => param.sphere_dims[1];
	    y		=> <-.lon_dim_slider.y + <-.lon_dim_slider.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIfieldTypein radius_typein {
	    UIparent => <-.UIpanel;
	    flabel = "Radius";
	    fval => <-.param.radius;
	    y		=> <-.lat_dim_slider.y +<-.lat_dim_slider.height+8;
	};
      VUIDial west_longitude {
            parent => <-.UIpanel;
            height = 150;
            value => param.longitude[0];
            title = "Western Long";
            y =>  <-.radius_typein.y + <-.radius_typein.height+8;
            width = 100;
            float min = -180.;
            float max = 360.;
            decimalPoints = 2;
            Dial {
             height = 120;
           };
      };
      VUIDial east_longitude {
            parent => <-.UIpanel;
            height = 150;
            value => param.longitude[1];
            title = "Eastern Long";
            y =>  <-.radius_typein.y + <-.radius_typein.height+8;
            x = 110;
            width = 100;
            float min = -180.;
            float max = 360.;
            decimalPoints = 2;
            Dial {
             height = 120;
           };
      };

      VUIDial south_latitude {
           parent => <-.UIpanel;
           height = 150;
           value => param.latitude[0];
           title = "Southern Lat";
           y => <-.east_longitude.y +  <-.east_longitude.height+8;
           width = 100;
           min = -90;
           max = 90;
           decimalPoints = 2;
           Dial {
             height = 120;
           };
      };

      VUIDial north_latitude {
           parent => <-.UIpanel;
           height = 150;
           value => param.latitude[1];
           title = "Northern Lat";
           x = 110;
           y => <-.east_longitude.y +  <-.east_longitude.height+8;
           width = 100;
           min = -90;
           max = 90;
           decimalPoints = 2;
           Dial {
             height = 120;
           };
       };
    };

    DataObject obj {
	in => Texture_Sphere.out_fld;
	texture_in => <-.texture;
	Modes {
         normals = 1;
        };
	Obj {
	    name => name_of(<-.<-.<-);
	    xform_mode = GD_XFORM_MODE_PARENT;
	};
    };

    olink out_fld<export_all=2> => Texture_Sphere.out_fld;
    olink out_obj => obj.obj;
}; // texture_sphere
#endif /* GIS_KIT */


macro offset {
    ilink in_field<export_all=1>;

    DV_Param_offset OffsetParam<export_all=2> {
	component = 0;
	scale = 1.0;
    };

    DVoffset  DVoffset{
	DV_Param_offset+IPort2 &param => OffsetParam;
	in => in_field;
	&component => param.component;
	&scale => param.scale;
    };

    macro OffsetUI {
	ilink in_fld => in_field;
	DV_Param_offset+IPort2 &param => OffsetParam;

	DVnode_data_labels DVnode_data_labels {
	    in => in_fld;
	    int+nres  ncomp => in.nnode_data;
	};
	UImod_panel UIpanel {
	    parent<NEportLevels={4,0}>;
	    title => name_of(<-.<-.<-);
	    message = "Select offset control panel.";
	};

	UIradioBoxLabel UIradioBoxLabel {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    &selectedItem+IPort2 => param.component;
	    visible => <-.UIpanel.visible;
	    title = "data component";
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
	UIslider scale_slider {
	    parent => <-.UIpanel;
	    title = "scale";
	    min = -10.0;
	    max = 10.0;
	    value+IPort2 => param.scale;
	    y		=> <-.UIradioBoxLabel.y + <-.UIradioBoxLabel.height + 4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein scale_slider_typein {
	    slider	=> scale_slider;
        };
    };

    DataObjectNoTexture obj {
	in => DVoffset.out;
	Obj {
	    name => name_of(<-.<-.<-);
	    xform_mode = GD_XFORM_MODE_PARENT;
	};
    };

    olink out_fld<export_all=2> => DVoffset.out;
    olink out_obj => obj.obj;
}; // offset

macro orthoslice {
    ilink in_field<export_all=1>;

    DV_Param_ortho_slice OrthoSliceParam<export_all=2> {
	axis = 0;
	plane+nres => in_field.dims[axis]/2;
    };

    DVorthoslice DVorthoslice {
	DV_Param_ortho_slice+IPort2 &param => OrthoSliceParam;
	in => in_field;
	&axis => param.axis;
	&plane => param.plane;
    };

    macro OrthoSliceUI {
	ilink in_fld => in_field;
	DV_Param_ortho_slice+IPort2 &param => OrthoSliceParam;

	UImod_panel UIpanel {
	    parent<NEportLevels={4,0}>;
	    title => name_of(<-.<-.<-);
	    message = "Select  orthoslice control panel.";
	};

	UIslider axis_slider {
	    parent => <-.UIpanel;
	    title = "axis";
	    max+nres+IPort2 => in_fld.ndim-1;
	    value+IPort2 => param.axis;
	    mode = 1;
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
	UIslider plane_slider {
	    parent => <-.UIpanel;
	    title = "plane";
	    max+nres+IPort2 => in_fld.dims[param.axis]-1;
	    value+IPort2 => param.plane;
	    mode = 1;
	    y		=> <-.axis_slider.y + <-.axis_slider.height + 4;
	    width	=> <-.UIpanel.width;
	};
    };

    DataObjectNoTexture obj {
	in => DVorthoslice.out;
	Obj {
	    name => name_of(<-.<-.<-);
	    xform_mode = GD_XFORM_MODE_PARENT;
	};
    };

    olink out_fld<export_all=2> => DVorthoslice.out;
    olink out_obj => obj.obj;
}; // orthoslice

macro scat_to_unif {
    ilink in_field<export_all=1>;

    DV_Param_scat_2_unif+Port Scat2UnifParam<export_all=2> {
	component = 0;
	rndim = 3;
	dim1 = 10;
	dim2 = 10;
	dim3 = 10;
	interp_order = 2;
	min_xyz => in_field.coordinates.min_vec[0:rndim-1];
	max_xyz => in_field.coordinates.max_vec[0:rndim-1];
	search_dist1 => dim1/5;
	search_dist2 => dim2/5;
	search_dist3 => dim3/5;
	null_value=>in_field.node_data[component].max+1;
    };

    Scat2Unif Scat2Unif {
	in_fld => in_field;
	param => Scat2UnifParam;
    };
    GMOD.instancer instancer {
	Value => UIpanel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => Scat2UnifUI;
    };
    UImod_panel UIpanel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-);
	message = "Select Scat_to_Unif control panel.";
    };

    macro Scat2UnifUI<instanced=0> {
	ilink in_fld => in_field;
	DV_Param_scat_2_unif+IPort2 &param => Scat2UnifParam;

	DVnode_data_labels DVnode_data_labels {
	    in => in_fld;
	    int+nres  ncomp => in.nnode_data;
	};
	ilink UIpanel  => <-.UIpanel;

	UIradioBoxLabel   UIradioBoxLabel{
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    &selectedItem+IPort2 => param.component;
	    visible => <-.UIpanel.visible;
	    title = "data component";
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
	UIslider ndim_slider {
	    parent => <-.UIpanel;
	    title = "ndim";
	    max = 3;
	    value+IPort2 => param.rndim;
	    mode = 1;
	    y		=> <-.UIradioBoxLabel.y + <-.UIradioBoxLabel.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIslider dim1_slider {
	    parent => <-.UIpanel;
	    title = "I-dimension";
	    max = 1000;
	    value+IPort2 => param.dim1;
	    mode = 1;
	    y		=> <-.ndim_slider.y + <-.ndim_slider.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIslider dim2_slider {
	    parent => <-.UIpanel;
	    title = "J-dimension";
	    max = 1000;
	    value+IPort2 => param.dim2;
	    mode = 1;
	    y		=> <-.dim1_slider.y + <-.dim1_slider.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIslider dim3_slider {
	    parent => <-.UIpanel;
	    title = "K-dimension";
	    max = 1000;
	    value+IPort2 => param.dim3;
	    mode = 1;
	    y		=> <-.dim2_slider.y + <-.dim2_slider.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIslider search_dist_x {
	    parent => <-.UIpanel;
	    title = "interpolate range I";
	    mode = 1;
	    max+nres+IPort2 => param.dim1/2+1;
	    value+IPort2 => param.search_dist1;
	    y		=> <-.dim3_slider.y + <-.dim3_slider.height + 4;
	    width	=> <-.UIpanel.width;
	};

	UIslider search_dist_y {
	    parent => <-.UIpanel;
	    title = "interpolate range J";
	    mode = 1;
	    max+nres+IPort2 => param.dim2/2+1;
	    value+IPort2 => param.search_dist2;
	    y		=> <-.search_dist_x.y + <-.search_dist_x.height + 4;
	    width	=> <-.UIpanel.width;
	};

	UIslider search_dist_z {
	    parent => <-.UIpanel;
	    title = "interpolate range K";
	    mode = 1;
	    max+nres+IPort2 => param.dim3/2+1;
	    value+IPort2 => param.search_dist3;
	    y		=> <-.search_dist_y.y + <-.search_dist_y.height + 4;
	    width	=> <-.UIpanel.width;
	};

	UIslider order_slider {
	    parent => <-.UIpanel;
	    title = "order";
	    max = 10;
	    value+IPort2 => param.interp_order;
	    mode = 1;
	    y		=> <-.search_dist_z.y + <-.search_dist_z.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIfieldTypein null_typein {
	    UIparent => <-.UIpanel;
	    flabel = "Null Value";
	    fval+IPort2 => param.null_value;
	    panel.y	=> <-.<-.order_slider.y + <-.<-.order_slider.height + 4;
	    panel.width	=> <-.<-.UIpanel.width;
	};

    };
    DataObjectNoTexture obj {
	in => Scat2Unif.out_fld;
	Obj {
	    name => name_of(<-.<-.<-);
	    xform_mode = GD_XFORM_MODE_PARENT;
	};
    };

    olink out_fld<export_all=2> => Scat2Unif.out_fld;
    olink out_obj => obj.obj;
}; // scat_to_unif

macro scat_bin {
    ilink in_field<export_all=1>;

    DV_Param_scat_2_unif+Port Scat2UnifParam<export_all=2> {
	component = 0;
	rndim+nres => in_field.nspace+0;
	dim1 = 10;
	dim2 = 10;
	dim3 = 10;
	min_xyz => in_field.coordinates.min_vec[0:rndim-1];
	max_xyz => in_field.coordinates.max_vec[0:rndim-1];
	null_value=>in_field.node_data[component].max+1;
    };
    DVscat_bin  DVscat_bin {
	DV_Param_scat_2_unif+IPort2 &param=> <-.Scat2UnifParam;
	in => <-.in_field;
	&rndim => param.rndim;
	rdims+nres => param.rdims;
	min_xyz+nres => param.min_xyz;
	max_xyz+nres => param.max_xyz;
	null_value => param.null_value;
    };
    GMOD.instancer instancer {
	Value => UIpanel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => ScatBinUI;
    };
    UImod_panel UIpanel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-);
	message = "Select Scat_Bin control panel.";
    };

    macro ScatBinUI<instanced=0> {
	ilink in_fld => in_field;
	DV_Param_scat_2_unif+IPort2 &param => Scat2UnifParam;
	ilink UIpanel  => <-.UIpanel;

	UIslider ndim_slider {
	    parent => <-.UIpanel;
	    title = "ndim";
	    max = 3;
	    value+IPort2 => param.rndim;
	    mode = 1;
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
	UIslider dim1_slider {
	    parent => <-.UIpanel;
	    title = "I-dimension";
	    max = 1000;
	    value+IPort2 => param.dim1;
	    mode = 1;
	    y		=> <-.ndim_slider.y + <-.ndim_slider.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIslider dim2_slider {
	    parent => <-.UIpanel;
	    title = "J-dimension";
	    max = 1000;
	    value+IPort2 => param.dim2;
	    mode = 1;
	    y		=> <-.dim1_slider.y + <-.dim1_slider.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIslider dim3_slider {
	    parent => <-.UIpanel;
	    title = "K-dimension";
	    max = 1000;
	    value+IPort2 => param.dim3;
	    mode = 1;
	    y		=> <-.dim2_slider.y + <-.dim2_slider.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIfieldTypein null_typein {
	    UIparent => <-.UIpanel;
	    flabel = "Null Value";
	    fval+IPort2 => param.null_value;
	    panel.y	=> <-.<-.dim3_slider.y + <-.<-.dim3_slider.height + 4;
	    panel.width	=> <-.<-.UIpanel.width;
	};

    };
    DataObjectNoTexture obj {
	in => DVscat_bin.out;
	Obj {
	    xform_mode = GD_XFORM_MODE_PARENT;
	    name => name_of(<-.<-.<-);
	};
    };

    olink out_fld<export_all=2> => DVscat_bin.out;
    olink out_obj => obj.obj;
}; // scat_bin

macro bounds {
    ilink in_field<export_all=1>;

    DV_Param_bounds BoundsParam<export_all=2> {
	 hull=1;
	 edges=0;
	 faces=0;
	 imin=0;
	 imax=0;
	 jmin=0;
	 jmax=0;
	 kmin=0;
	 kmax=0;
	 data=0;
	 component=0;
    };

    DVbounds  DVbounds {
	DV_Param_bounds+IPort2 &param => BoundsParam;
	in => in_field;
	hull => param.hull;
	edges => param.edges;
	faces => param.faces;
	imin => param.imin;
	imax => param.imax;
	jmin => param.jmin;
	jmax => param.jmax;
	kmin => param.kmin;
	kmax => param.kmax;
	data => param.data;
	component => param.component;
    };
    GMOD.instancer instancer {
	Value => UIpanel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => BoundsUI;
    };
    UImod_panel UIpanel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-);
	message = "Select Bounds control panel.";
    };

    macro BoundsUI<instanced=0> {
	ilink in_fld => in_field;
	DV_Param_bounds+IPort2 &param => BoundsParam;

	DVnode_data_labels DVnode_data_labels {
	    in => in_fld;
	    int+nres  ncomp => in.nnode_data;
	};
	ilink UIpanel  => <-.UIpanel;

	UIradioBoxLabel UIradioBoxLabel {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    &selectedItem+IPort2 => param.component;
	    visible => <-.UIpanel.visible;
	    title = "data component";
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
	UItoggle hull_toggle {
	    parent => <-.UIpanel;
	    label = "Hull";
	    &set+IPort2 => param.hull;
	    y		=> <-.UIradioBoxLabel.y + <-.UIradioBoxLabel.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UItoggle edges_toggle {
	    parent => <-.UIpanel;
	    label = "Edges";
	    &set+IPort2 => param.edges;
	    y		=> <-.hull_toggle.y + <-.hull_toggle.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UItoggle faces_toggle {
	    parent => <-.UIpanel;
	    label = "Faces";
	    &set+IPort2 => param.faces;
	    y		=> <-.edges_toggle.y + <-.edges_toggle.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UItoggle imin_toggle {
	    parent => <-.UIpanel;
	    label = "Imin";
	    &set+IPort2 => param.imin;
	    y		=> <-.faces_toggle.y + <-.faces_toggle.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UItoggle imax_toggle {
	    parent => <-.UIpanel;
	    label = "Imax";
	    &set+IPort2 => param.imax;
	    y		=> <-.imin_toggle.y + <-.imin_toggle.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UItoggle jmin_toggle {
	    parent => <-.UIpanel;
	    label = "Jmin";
	    &set+IPort2 => param.jmin;
	    y		=> <-.imax_toggle.y + <-.imax_toggle.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UItoggle jmax_toggle {
	    parent => <-.UIpanel;
	    label = "Jmax";
	    &set+IPort2 => param.jmax;
	    y		=> <-.jmin_toggle.y + <-.jmin_toggle.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UItoggle kmin_toggle {
	    parent => <-.UIpanel;
	    label = "Kmin";
	    &set+IPort2 => param.kmin;
	    y		=> <-.jmax_toggle.y + <-.jmax_toggle.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UItoggle kmax_toggle {
	    parent => <-.UIpanel;
	    label = "Kmax";
	    &set+IPort2 => param.kmax;
	    y		=> <-.kmin_toggle.y + <-.kmin_toggle.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UItoggle data_toggle {
	    parent => <-.UIpanel;
	    label = "Data";
	    &set+IPort2 => param.data;
	    y		=> <-.kmax_toggle.y + <-.kmax_toggle.height + 4;
	    width	=> <-.UIpanel.width;
	};
    };

    DataObjectNoTexture obj {
	in => DVbounds.out;
	Modes {
	    mode = {0,GD_LINES,GD_SURF_GOURAUD,0,0};	/* set lines, gouraud mode */
	};
	Obj {
	    name => name_of(<-.<-.<-);
	    xform_mode = GD_XFORM_MODE_PARENT;
	};
    };

    olink out_fld<export_all=2> => DVbounds.out;
    olink out_obj => obj.obj;
}; // bounds


macro scat_to_tri {
    ilink in_field<export_all=1>;

    int+Port triangles<export=2> = 0;

    DVscat_to_tet DVscat_to_tet {
	triangle => <-.triangles;
	in => in_field;
    };
    macro Scat2TriUI {
	UImod_panel UIpanel {
	    parent<NEportLevels={4,0}>;
	    title => name_of(<-.<-.<-);
	    message = "Select Scatter to field control panel.";
	};
	UItoggle Dim2_toggle {
	    parent => <-.UIpanel;
	    label = "2D(triangles)";
	    &set+IPort2 => <-.<-.triangles;
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
    };

    DataObjectNoTexture obj {
	in => DVscat_to_tet.out;
	Obj {
	    name => name_of(<-.<-.<-);
	};
    };

    olink out_fld<export_all=2> => DVscat_to_tet.out;
    olink out_obj => obj.obj;
}; // scat_to_tri

macro edges {
    ilink in_field<export_all=1>;

    DVedges DVedges {
	in => <-.in_field;
    };

    DataObjectNoTexture obj {
	in => DVedges.out;
	Obj {
	    name => name_of(<-.<-.<-);
	    xform_mode = GD_XFORM_MODE_PARENT;
	};
    };
    olink out_fld<export_all=2> => DVedges.out;
    olink out_obj => obj.obj;
}; // edges

macro external_faces {
    ilink in_field<export_all=1>;

    External_Faces External_Faces {
	in_field => <-.in_field;
    };

    DataObjectNoTexture obj {
	in => External_Faces.out_fld;
	Obj {
	    name => name_of(<-.<-.<-);
	    xform_mode = GD_XFORM_MODE_PARENT;
	    Modes.normals = 1;
	};
    };
    olink out_fld<export_all=2> => External_Faces.out_fld;
    olink out_obj => obj.obj;
}; // external_faces

macro external_edges {
    ilink in_field<export_all=1>;

    float+Port edge_angle<export=2> = 5.0;

    macro ExtEdgeUI {
	ilink  angle => <-.edge_angle;

	UImod_panel UIpanel {
	    parent<NEportLevels={4,0}>;
	    title => name_of(<-.<-.<-);
	    message = "Select  ext_edge control panel.";
	};
	UIslider ang_slider {
	    parent => <-.UIpanel;
	    title = "max edge angle";
	    max = 180.0;
	    value+IPort2 => angle;
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
    };

    External_Edges External_Edges {
	in_field => <-.in_field;
	edge_angle => <-.edge_angle;
    };

    DataObjectNoTexture obj {
	in => External_Edges.out_fld;
	Obj {
	    name => name_of(<-.<-.<-);
	    xform_mode = GD_XFORM_MODE_PARENT;
	};
        Props {
            jitter = 1;
            inherit = 0;
        };
    };

    olink out_fld<export_all=2> => External_Edges.out_fld;
    olink out_obj => obj.obj;
}; // external_edges

macro volume_integr {
    ilink in_field<export_all=1>;

    DV_Param_integr IntegrParam<export_all=2> {
	component = 0;
	dim = 3;
    };
    DVintegr_vol DVintegr_vol {
	DV_Param_integr+IPort2 &param => IntegrParam;
	in => in_field;
	component => param.component;
	dim => param.dim;
    };

    macro IntegrUI {
	ilink in_fld => in_field;
	DV_Param_integr+IPort2 &param => IntegrParam;

	UImod_panel UIpanel {
	    parent<NEportLevels={4,0}>;
	    title => name_of(<-.<-.<-);
	    message = "Select Volume Integral control panel.";
	};

	DVnode_data_labels DVnode_data_labels {
	    in => in_fld;
	    int+nres  ncomp => in.nnode_data;
	};
	UIradioBoxLabel UIradioBoxLabel {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    &selectedItem+IPort2 => param.component;
	    visible => <-.UIpanel.visible;
	    title = "data component";
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
	UIslider dim_slider {
	    parent => <-.UIpanel;
	    title = "cells dimensionality";
	    min = 1;
	    max = 3;
	    value+IPort2 => param.dim;
	    mode = 1;
	    y		=> <-.UIradioBoxLabel.y + <-.UIradioBoxLabel.height + 4;
	    width	=> <-.UIpanel.width;
	};

	UIfieldTypein vol_field {
	    UIparent => <-.UIpanel;
	    flabel = "volume";
	    fval+IPort2 => DVintegr_vol.volume;
	    panel.y	=> <-.<-.dim_slider.y + <-.<-.dim_slider.height + 4;
	    panel.width	=> <-.<-.UIpanel.width;
	};

	UIfieldTypein mas_field {
	    UIparent => <-.UIpanel;
	    flabel = "volume integral";
	    fval+IPort2 => DVintegr_vol.mass;
	    panel.y	=> <-.<-.vol_field.panel.y + <-.<-.vol_field.panel.height + 4;
	    panel.width	=> <-.<-.UIpanel.width;
	};
    };
}; // volume_integr

macro cut {
    ilink in_field<export_all=1>;
    ilink in_plane<export_all=1>;

    DV_Param_cut+Port CutParam<export_all=2> {
	component = {0};
	dist = 0.0;
	above = 1;
	cell_data = {0};
    };

    int has_cell_data => (DVcell_data_labels.ncomp > 0);
    Cut Cut {
	param => CutParam;
	in_fld => in_field;
	in_pln => in_plane;
	DVcut {
		cell_data => switch(has_cell_data, param.cell_data);
	};
    };
    DVnode_data_labels DVnode_data_labels {
	    in => in_field;
	    int+nres  ncomp => in.nnode_data;
    };
    DVcell_data_labels DVcell_data_labels {
	    in => in_field;
    };
    UImod_panel UIpanel {
	    parent<NEportLevels={3,0}>;
	    title => name_of(<-.<-);
	    message = "Select Cut control panel.";
    };
    GMOD.instancer instancer {
	Value => UIpanel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => <-.CutUI;
    };
    macro CutUI<instanced=0> {
	ilink in_fld => in_field;
	DV_Param_cut+IPort2 &param => CutParam;
	ilink DVnode_data_labels => <-.DVnode_data_labels;
	ilink DVcell_data_labels => <-.DVcell_data_labels;
	ilink UIpanel  => <-.UIpanel;

	UItoggle above_toggle {
	    parent => <-.UIpanel;
	    label = "Above";
	    &set+IPort2 => param.above;
	    y		= 0;
	    width	=> <-.UIpanel.width;
	};

	UIslider plane_dist {
	    parent => <-.UIpanel;
	    title = "plane distance";
	    min+nres+IPort2 => cache(-0.5*(magnitude(in_fld.coordinates.max_vec-
					      in_fld.coordinates.min_vec)));
	    max+nres+IPort2 => cache( 0.5*(magnitude(in_fld.coordinates.max_vec-
					      in_fld.coordinates.min_vec)));
	    value+IPort2 => param.dist;
	    y		=> <-.above_toggle.y + <-.above_toggle.height + 4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein plane_dist_typein {
	    slider	=> plane_dist;
        };

	UIoptionBoxLabel  UIoptionBoxLabel {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    max => DVnode_data_labels.ncomp;
	    &selectedItems+IPort2 => param.component;
	    title = "map components";
	    visible => <-.UIpanel.visible;
	    y		=> <-.plane_dist.y + <-.plane_dist.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIoptionBoxLabel  UIoptionBoxLabel_cell {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVcell_data_labels.labels;
	    max => DVcell_data_labels.ncomp;
	    &selectedItems+IPort2 => param.cell_data;
	    title = "map cell components";
	    visible => <-.UIpanel.visible & (DVcell_data_labels.ncomp > 0);
	    y		=> <-.UIoptionBoxLabel.y + <-.UIoptionBoxLabel.height + 4;
	    width	=> <-.UIpanel.width;
	};
    };

    DataObjectNoTexture obj {
	in => Cut.out_fld;
	Obj {
	    name => name_of(<-.<-.<-);
	    xform_mode = GD_XFORM_MODE_ALT;
	    alt_xform+nres => <-.<-.in_plane.xform;
	    Modes.normals = 1;
	};
    };

    olink out_fld<export_all=2> => Cut.out_fld;
    olink out_obj => obj.obj;
}; // cut

macro cut_plane {
    ilink in_field<export_all=1>;

    DV_Param_cut+Port CutParam<export_all=2> {
	component = {0};
	dist = 0.0;
	above = 1;
	cell_data = {0};
    };

    int has_cell_data => (DVcell_data_labels.ncomp > 0);

    float+nres xlate[3]=>{0.0, 0.0,
		    (in_field.coordinates.min_vec[2]+in_field.coordinates.max_vec[2])/2};
    Plane_Mesh   plane {
	xform {
	    xlate+nres=>cache(<-.<-.xlate);
	};
	dims => {2, 2};
	points+nres => {in_field.coordinates.min_vec[0], in_field.coordinates.min_vec[1], 
		  in_field.coordinates.max_vec[0], in_field.coordinates.max_vec[1]};
    };

    Cut Cut {
	param => CutParam;
	in_fld => in_field;
	in_pln => <-.plane;
	DVcut {
		cell_data => switch(has_cell_data, param.cell_data);
	};
    };
    DVnode_data_labels DVnode_data_labels {
	    in => in_field;
	    int+nres  ncomp => in.nnode_data;
    };
    DVcell_data_labels DVcell_data_labels {
	    in => in_field;
    };

    GMOD.instancer instancer {
	Value => UIpanel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => <-.CutUI;
    };
    UImod_panel UIpanel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-);
	message = "Select Cut control panel.";
    };

    macro CutUI<instanced=0> {
	ilink in_fld => in_field;
	DV_Param_cut+IPort2 &param => CutParam;

	ilink UIpanel  => <-.UIpanel;
	ilink DVnode_data_labels => <-.DVnode_data_labels;
	ilink DVcell_data_labels => <-.DVcell_data_labels;

	UItoggle above_toggle {
	    parent => <-.UIpanel;
	    label = "Above";
	    &set+IPort2 => param.above;
	    y		= 0;
	    width	=> <-.UIpanel.width;
	};

	UIslider plane_dist {
	    parent => <-.UIpanel;
	    title = "plane distance";
	    min+nres+IPort2 => cache(-0.5*(magnitude(in_fld.coordinates.max_vec-
					      in_fld.coordinates.min_vec)));
	    max+nres+IPort2 => cache( 0.5*(magnitude(in_fld.coordinates.max_vec-
					      in_fld.coordinates.min_vec)));
	    value+IPort2 => param.dist;
	    y		=> <-.above_toggle.y + <-.above_toggle.height + 4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein plane_dist_typein {
	    slider	=> plane_dist;
        };

	UItoggle xform_toggle {
	    parent => <-.UIpanel;
	    label = "Plane Transform Editor";
	    y		=> <-.plane_dist.y + <-.plane_dist.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIoptionBoxLabel  UIoptionBoxLabel {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    max => DVnode_data_labels.ncomp;
	    &selectedItems+IPort2 => param.component;
	    title = "map components";
	    visible => <-.UIpanel.visible;
	    y		=> <-.xform_toggle.y + <-.xform_toggle.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIoptionBoxLabel  UIoptionBoxLabel_cell {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVcell_data_labels.labels;
	    max => DVcell_data_labels.ncomp;
	    &selectedItems+IPort2 => param.cell_data;
	    title = "map cell components";
	    visible => <-.UIpanel.visible & (DVcell_data_labels.ncomp > 0);
	    y		=> <-.UIoptionBoxLabel.y + <-.UIoptionBoxLabel.height + 4;
	    width	=> <-.UIpanel.width;
	};
	XformEditor plane_xform {
	    obj_in => <-.<-.plane;
	    vis => xform_toggle.set;
	};
    };

    DataObject cut_obj {
	in => Cut.out_fld;
	Obj {
	    name => name_of(<-.<-.<-);
	    Modes.normals = 1;
	};
    };
    DataObject plane_obj {
	in => <-.plane;
	Obj {
	    xform_mode = GD_XFORM_MODE_ALT;
	    alt_xform+nres => <-.<-.plane.xform;
	};
    };

    olink out_fld<export_all=2> => Cut.out_fld;
    olink out_plane<export_all=2> => plane;
    olink out_obj_cut => cut_obj.obj;
    olink out_obj_plane => plane_obj.obj;
}; // cut_plane


macro glyph {
    ilink in_field<export_all=1>;
    ilink in_glyph<export_all=1>;

    DV_Param_glyph GlyphParam<export_all=2> {
	glyph_comp = 0;
	map_comp = 0;
	scale_comp = 0;
	vector = 1;
	scale = 1.0;
	scale_x = 1;
	scale_y = 1;
	scale_z = 1;
	normalize = 0;
    };

    DVglyph DVglyph {
	DV_Param_glyph+IPort2 &param => GlyphParam;
	in => in_field;
	glyph => in_glyph;
	glyph_comp => param.glyph_comp;
	map_comp => param.map_comp;
	scale_comp => param.scale_comp;
	vector => param.vector;
	scale => param.scale;
	scale_x => param.scale_x;
	scale_y => param.scale_y;
	scale_z => param.scale_z;
	normalize => param.normalize;
    };
    GMOD.instancer instancer {
	Value => UIpanel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => GlyphUI;
    };
    UImod_panel UIpanel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-);
	message = "Select Glyph control panel.";
    };

    macro GlyphUI<instanced=0> {
	ilink in_fld => in_field;
	DV_Param_glyph+IPort2 &param => GlyphParam;

	DVnode_data_labels DVnode_data_labels {
	    in => in_fld;
	    int+nres  ncomp => in.nnode_data;
	};
	ilink UIpanel  => <-.UIpanel;

	UIradioBoxLabel   UIradioBoxLabel_glyph {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    &selectedItem+IPort2 => param.glyph_comp;
	    visible => <-.UIpanel.visible;
	    title = "Glyph Component";
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
	UIradioBoxLabel   UIradioBoxLabel_map {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    &selectedItem+IPort2 => param.map_comp;
	    visible => <-.UIpanel.visible;
	    title = "Color Component";
	    y		=> <-.UIradioBoxLabel_glyph.y + <-.UIradioBoxLabel_glyph.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIradioBoxLabel   UIradioBoxLabel_scale {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    &selectedItem+IPort2 => param.scale_comp;
	    visible => <-.UIpanel.visible;
	    title = "Scale Component";
	    y		=> <-.UIradioBoxLabel_map.y + <-.UIradioBoxLabel_map.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIradioBoxLabel   UIradioBoxLabel_mode {
	    parent => <-.UIpanel;
	    labels+IPort2 => {"scalar", "vector", "components"};
	    &selectedItem+IPort2 => param.vector;
	    visible => <-.UIpanel.visible;
	    title = "Mode";
	    y		=> <-.UIradioBoxLabel_scale.y + <-.UIradioBoxLabel_scale.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UItoggle norm_toggle {
	    parent => <-.UIpanel;
	    label = "Normalize";
	    &set+IPort2 => param.normalize;
	    y		=> <-.UIradioBoxLabel_mode.y + <-.UIradioBoxLabel_mode.height + 4;
	    width	=> <-.UIpanel.width;
	};

	UIslider scale_slider {
	    parent => <-.UIpanel;
	    title = "scale";
	    value+IPort2 => param.scale;
	    min = -10;
	    max = 10;
	    y		=> <-.norm_toggle.y + <-.norm_toggle.height + 4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein scale_slider_typein {
	    slider	=> scale_slider;
        };

	UItoggle scale_x_toggle {
	    parent => <-.UIpanel;
	    label = "Scale X";
	    &set+IPort2 => param.scale_x;
	    y		=> <-.scale_slider.y + <-.scale_slider.height + 4;
	    width	=> <-.UIpanel.width;
	};

	UItoggle scale_y_toggle {
	    parent => <-.UIpanel;
	    label = "Scale Y";
	    &set+IPort2 => param.scale_y;
	    y		=> <-.scale_x_toggle.y + <-.scale_x_toggle.height + 4;
	    width	=> <-.UIpanel.width;
	};

	UItoggle scale_z_toggle {
	    parent => <-.UIpanel;
	    label = "Scale Z";
	    &set+IPort2 => param.scale_z;
	    y		=> <-.scale_y_toggle.y + <-.scale_y_toggle.height + 4;
	    width	=> <-.UIpanel.width;
	};

    };

    DataObjectNoTexture obj {
	in => DVglyph.out;
	Modes {
	    mode = {0,GD_LINES,GD_SURF_GOURAUD,0,0};	/* set lines, gouraud mode */
	};
	Obj {
	    name => name_of(<-.<-.<-);
	    xform_mode = GD_XFORM_MODE_PARENT;
	};
    };

    olink out_fld<export_all=2> => DVglyph.out;
    olink out_obj => obj.obj;
}; // glyph

macro geo_glyph {
    ilink in_field<export_all=1>;
    imlink in_glyph<export_all=1>;

    DV_Param_geo_glyph GlyphParam<export_all=2> {
	scale = 1.0;
	color_r= 10;
	color_g= 1.0;
	color_b= 1.0;
	normalize = 0;
    };

    DVgeo_glyph DVglyph {
	DV_Param_geo_glyph+IPort2 &param => GlyphParam;
	in => in_field;
	glyph => in_glyph;
	scale => param.scale;
	color => {param.color_r,param.color_g,param.color_b};
	normalize => param.normalize;
    };

    GMOD.instancer instancer {
	Value => UIpanel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => GlyphUI;
    };
    UImod_panel UIpanel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-);
	message = "Select geo_glyph control panel.";
    };

    macro GlyphUI<instanced=0> {
	ilink in_fld => in_field;
	DV_Param_geo_glyph+IPort2 &param => GlyphParam;
	ilink UIpanel  => <-.UIpanel;

	UIslider scale_slider {
	    parent => <-.UIpanel;
	    title = "scale";
	    value+IPort2 => param.scale;
	    min = -10;
	    max = 10;
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
	UIslider color_r_slider {
	    parent => <-.UIpanel;
	    title = "red";
	    value+IPort2 => param.color_r;
	    min = 0;
	    max = 1;
	    y		=> <-.scale_slider.y + <-.scale_slider.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIslider color_g_slider {
	    parent => <-.UIpanel;
	    title = "green";
	    value+IPort2 => param.color_g;
	    min = 0;
	    max = 1;
	    y		=> <-.color_r_slider.y + <-.color_r_slider.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIslider color_b_slider {
	    parent => <-.UIpanel;
	    title = "blue";
	    value+IPort2 => param.color_b;
	    min = 0;
	    max = 1;
	    y		=> <-.color_g_slider.y + <-.color_g_slider.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UItoggle norm_toggle {
	    parent => <-.UIpanel;
	    label = "normalize glyph index";
	    &set+IPort2 => param.normalize;
	    y		=> <-.color_b_slider.y + <-.color_b_slider.height + 4;
	    width	=> <-.UIpanel.width;
	};
    };

    DataObjectNoTexture obj {
	in => DVglyph.out;
	Modes {
	    mode = {0,GD_LINES,GD_SURF_GOURAUD,0,0};	/* set lines, gouraud mode */
	};
	Obj {
	    name => name_of(<-.<-.<-);
	    xform_mode = GD_XFORM_MODE_PARENT;
	};
    };

    olink out_fld<export_all=2> => DVglyph.out;
    olink out_obj => obj.obj;
}; // geo_glyph

macro text_glyph {
    Mesh+IPort2 &in_mesh<export_all=1>;
    string+IPort2 in_text<export_all=1>[];

    GMOD.instancer instancer {
	Value => UImod_panel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => TextUI;
    };
    UImod_panel UImod_panel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-);
	message = "Select control panel.";
    };

    macro TextUI<instanced=0> {
       int active_array[2] = {1,0};
       ilink UImod_panel  => <-.UImod_panel;

       Controls.UIlabel UIlabel {
          y = 0;
          width = 45;
          parent => <-.UImod_panel;
          label = "Font";
          alignment = 0;
       };
       UItext Font {
          x = <-.UIlabel.width;
          y = 0;
          width = 200;
          parent => <-.UImod_panel;
          text<NEportLevels={0,3}> = "-adobe-times-bold-r-*-*-20-*-*-*-*-*-*-*";
          active    => <-.active_array[<-.StrokeText.set];
       };
       Panels.UIframe UIframe {
          y => <-.Font.y + <-.Font.height + 4;
          width => <-.UImod_panel.width;
          height => <-.OffsetZValue.y + <-.OffsetZValue.height + 2;
          parent => <-.UImod_panel;
       };
       Commands.UIoption UIoption {
          label = "Left";
          set = 1;
       };
       Commands.UIoption UIoption#1 {
          label = "Center";
       };
       Commands.UIoption UIoption#2 {
          label = "Right";
       };
       UIoptionMenu AlignHorizMenu {
          parent => <-.UIframe;
          cmdList => {<-.UIoption,<-.UIoption#1,<-.UIoption#2};
          x = 2;
          y = 2;
          label = "Align Horizontal";
          alignment = 0;
          selectedItem<NEportLevels={0,3}> = 0;
       };
       Commands.UIoption UIoption#3 {
          label = "Base";
          set = 1;
       };
       Commands.UIoption UIoption#4 {
          label = "Bottom";
       };
       Commands.UIoption UIoption#5 {
          label = "Center";
       };
       Commands.UIoption UIoption#6 {
          label = "Top";
       };
       UIoptionMenu AlignVertMenu {
          parent => <-.UIframe;
          cmdList => {<-.UIoption#3,<-.UIoption#4,<-.UIoption#5,<-.UIoption#6};
          x = 2;
          y = 30;
          label = "Align Vertical";
          alignment = 0;
          selectedItem<NEportLevels={0,3}> = 0;
       };
       UItoggle DropShadow {
          parent => <-.UIframe;
          label = "Drop Shadow";
          x = 2;
          y = 60;
          width = 150;
          alignment = 0;
          set<NEportLevels={0,3}>;
          active    => <-.active_array[<-.StrokeText.set];
       };
       UItoggle Bounds {
          parent => <-.UIframe;
          label = "Bounds";
          x = 2;
          y = 90;
          set<NEportLevels={0,3}>;
          active    => <-.active_array[<-.StrokeText.set];
       };
       UItoggle Underline {
          parent => <-.UIframe;
          label = "Underline";
          x = 2;
          y = 120;
          set<NEportLevels={0,3}>;
          active    => <-.active_array[<-.StrokeText.set];
       };
       UItoggle Background {
          parent => <-.UIframe;
          label = "Background";
          x = 2;
          y = 150;
          set<NEportLevels={0,3}>;
          active    => <-.active_array[<-.StrokeText.set];
       };
       UItoggle Leadline {
          parent => <-.UIframe;
          label = "Leadline";
          x = 2;
          y = 180;
          set<NEportLevels={0,3}>;
          active    => <-.active_array[<-.StrokeText.set];
       };
       UItoggle Radial {
          parent => <-.UIframe;
          label = "Radial";
          set<NEportLevels={0,3}>;
          x = 2;
          y         => <-.Leadline.y + <-.Leadline.height + 5;
          width     => <-.UIframe.clientWidth - 8;
          active    => <-.active_array[<-.StrokeText.set];
       };
       UItoggle Offset {
          parent => <-.UIframe;
          label = "Offset";
          set<NEportLevels={0,3}>;
          x = 2;
          y         => <-.Radial.y + <-.Radial.height + 5;
          width     => <-.UIframe.clientWidth - 8;
          active    => <-.active_array[<-.StrokeText.set];
       };
       UIfieldTypein OffsetXValue {
          UIparent => <-.UIframe;
          flabel = "X Offset";
          x         =  4;
          y         => <-.Offset.y + <-.Offset.height + 5;
          width     => <-.UIframe.clientWidth - 8;
          height    => field.height + 6;
	  label.alignment = 1;
	  field.active => <-.<-.active_array[<-.<-.StrokeText.set];
	  field.value = ;
	  field.value = 0.05;
       };
       UIfieldTypein OffsetYValue {
          UIparent => <-.UIframe;
          flabel = "Y Offset";
          x         =  4;
          y         => <-.OffsetXValue.y + <-.OffsetXValue.height + 5;
          width     => <-.UIframe.clientWidth - 8;
          height    => field.height + 6;
	  label.alignment = 1;
	  field.active => <-.<-.active_array[<-.<-.StrokeText.set];
	  field.value = ;
	  field.value = 0.05;
       };
       UIfieldTypein OffsetZValue {
          UIparent => <-.UIframe;
          flabel = "Z Offset";
          x         =  4;
          y         => <-.OffsetYValue.y + <-.OffsetYValue.height + 5;
          width     => <-.UIframe.clientWidth - 8;
          height    => field.height + 6;
	  label.alignment = 1;
	  field.active => <-.<-.active_array[<-.<-.StrokeText.set];
	  field.value = ;
          field.value = 0.0;
       };

       /* UI widgets associated with the stroke text attributes. */
       UItoggle StrokeText {
          parent => <-.UImod_panel;
          label = "StrokeText";
          y         => <-.UIframe.y + <-.UIframe.height + 5;
          width     => <-.UImod_panel.clientWidth - 50;
          set       => <-.<-.TextValues.stroke;
       };
       Panels.UIframe StrokeFrame {
          parent => <-.UImod_panel;
          y         => <-.StrokeText.y + <-.StrokeText.height + 10;
          width     => <-.UImod_panel.clientWidth;
          height    => <-.StrokeExpansion.y + <-.StrokeExpansion.height + 6;
          visible   => <-.StrokeText.set;
       };
       UIoptionMenu StrokeFontType {
          parent => <-.StrokeFrame;
          cmdList => {<-.Font1, <-.Font2, <-.Font3, <-.Font4,
            <-.Font5, <-.Font6, <-.Font7, <-.Font8, <-.Font9, <-.Font10};
          label = "Font Type";
          alignment = 0;
          selectedItem<NEportLevels={0,3}> = 0;
          x =  4;
          y =  0;
          width => <-.StrokeFrame.clientWidth - 8;
       };
       Commands.UIoption Font1 {
          label = "Roman Simplex";
          set = 1;
       };
       Commands.UIoption Font2 {
          label = "Roman Duplex";
       };
       Commands.UIoption Font3 {
          label = "Roman Triplex";
       };
       Commands.UIoption Font4 {
          label = "Roman Complex";
       };
       Commands.UIoption Font5 {
          label = "Script Simplex";
       };
       Commands.UIoption Font6 {
          label = "Script Complex";
       };
       Commands.UIoption Font7 {
          label = "Italics Triplex";
       };
       Commands.UIoption Font8 {
          label = "Italics Duplex";
       };
       Commands.UIoption Font9 {
          label = "Greek Simplex";
       };
       Commands.UIoption Font10 {
          label = "Greek Complex";
       };
       UIoptionMenu StrokePlane {
          parent => <-.StrokeFrame;
          cmdList => {<-.XYplane, <-.XZplane, <-.YZplane};
          label = "Plane";
          alignment = 0;
          selectedItem<NEportLevels={0,3}> = 0;
          x =  4;
          y => <-.StrokeFontType.y + <-.StrokeFontType.height + 5;
          width => <-.StrokeFrame.clientWidth - 8;
       };
       Commands.UIoption XYplane {
          label = "XY";
          set = 1;
       };
       Commands.UIoption XZplane {
          label = "XZ";
       };
       Commands.UIoption YZplane {
          label = "YZ";
       };
       UIoptionMenu StrokeOrient {
          parent => <-.StrokeFrame;
          cmdList => {<-.LRorient, <-.UPorient, <-.RLorient, <-.DOWNorient, <-.ARBorient};
          label = "Orientation";
          alignment = 0;
          selectedItem<NEportLevels={0,3}> = 0;
          x =  4;
          y => <-.StrokePlane.y + <-.StrokePlane.height + 5;
          width => <-.StrokeFrame.clientWidth - 8;
       };
       Commands.UIoption LRorient {
          label = "Left-to-Right";
          set = 1;
       };
       Commands.UIoption UPorient {
          label = "Up";
       };
       Commands.UIoption RLorient {
          label = "Right-to-Left";
       };
       Commands.UIoption DOWNorient {
          label = "Down";
       };
       Commands.UIoption ARBorient {
          label = "Arbitrary";
       };
       UIslider StrokeAngle {
          parent => <-.StrokeFrame;
          title = "Angle";
          x = 4;
          y => <-.StrokeOrient.y + <-.StrokeOrient.height + 5;
          width => <-.UImod_panel.clientWidth - 50;
          min = -180.0;
          max = 180.0;
          value = 0.0;
          active => switch((StrokeOrient.selectedItem == 4) + 1, 0, 1);
       };
       UIoptionMenu StrokePath {
          parent => <-.StrokeFrame;
          cmdList => {<-.LRpath, <-.UPpath, <-.RLpath, <-.DOWNpath};
          label = "Path";
          alignment = 0;
          selectedItem<NEportLevels={0,3}> = 0;
          x =  4;
          y => <-.StrokeAngle.y + <-.StrokeAngle.height + 5;
          width => <-.StrokeFrame.clientWidth - 8;
       };
       Commands.UIoption LRpath {
          label = "Left-to-Right";
          set = 1;
       };
       Commands.UIoption UPpath {
          label = "Up";
       };
       Commands.UIoption RLpath {
          label = "Right-to-Left";
       };
       Commands.UIoption DOWNpath {
          label = "Down";
       };
       UIoptionMenu StrokeSpaceMode {
          parent => <-.StrokeFrame;
          cmdList => {<-.FixedSpace, <-.PropSpace};
          label = "Spacing Mode";
          alignment = 0;
          selectedItem<NEportLevels={0,3}> = 1;
          x =  4;
          y => <-.StrokePath.y + <-.StrokePath.height + 5;
          width => <-.StrokeFrame.clientWidth - 8;
       };
       Commands.UIoption FixedSpace {
          label = "Fixed";
       };
       Commands.UIoption PropSpace {
          label = "Proportional";
          set = 1;
       };
       UIslider StrokeSpacing {
          parent => <-.StrokeFrame;
          title = "Spacing";
          x = 4;
          y => <-.StrokeSpaceMode.y + <-.StrokeSpaceMode.height + 5;
          width => <-.UImod_panel.clientWidth - 50;
          min = 0.0;
          max = 3.0;
          value = 0.0;
       };
       UIslider StrokeHeight {
          parent => <-.StrokeFrame;
          title = "Height";
          x = 4;
          y => <-.StrokeSpacing.y + <-.StrokeSpacing.height + 5;
          width => <-.UImod_panel.clientWidth - 50;
          min = 0.01;
          max = 10.0;
          value = 1.0;
       };
       UIslider StrokeExpansion {
          parent => <-.StrokeFrame;
          title = "Expansion";
          x = 4;
          y => <-.StrokeHeight.y + <-.StrokeHeight.height + 5;
          width => <-.UImod_panel.clientWidth - 50;
          min = 0.25;
          max = 3.0;
          value = 1.0;
       };
    };

    TextValues TextValues<export_all=2> {
        text_values => in_text;
        align_horiz<NEportLevels={2,0}> => <-.TextUI.AlignHorizMenu.selectedItem;
        align_vert<NEportLevels={2,0}> => <-.TextUI.AlignVertMenu.selectedItem;
        drop_shadow<NEportLevels={2,0}> => <-.TextUI.DropShadow.set;
        bounds<NEportLevels={2,0}> => <-.TextUI.Bounds.set;
        underline<NEportLevels={2,0}> => <-.TextUI.Underline.set;
        background<NEportLevels={2,0}> => <-.TextUI.Background.set;
        lead_line<NEportLevels={2,0}> => <-.TextUI.Leadline.set;
        radial<NEportLevels={2,0}> => <-.TextUI.Radial.set;
        do_offset<NEportLevels={2,0}> => <-.TextUI.Offset.set;
        offset<NEportLevels={2,0}> => {<-.TextUI.OffsetXValue.field.value,
                                       <-.TextUI.OffsetYValue.field.value,
                                       <-.TextUI.OffsetZValue.field.value};
        StrokeTextAttribs {
           font_type => <-.<-.TextUI.StrokeFontType.selectedItem;
           plane => <-.<-.TextUI.StrokePlane.selectedItem;
           orient => <-.<-.TextUI.StrokeOrient.selectedItem;
           angle => <-.<-.TextUI.StrokeAngle.value;
           path => <-.<-.TextUI.StrokePath.selectedItem;
           space_mode => <-.<-.TextUI.StrokeSpaceMode.selectedItem;
           spacing => <-.<-.TextUI.StrokeSpacing.value;
           height => <-.<-.TextUI.StrokeHeight.value;
           expansion => <-.<-.TextUI.StrokeExpansion.value;
        };
    };
    TextField &TextField => merge(TextValues, in_mesh);

    DataObjectNoTexture obj {
	in => TextField;
	Obj {
	    name => name_of(<-.<-.<-);
	};
	Props {
	   font => <-.<-.TextUI.Font.text;
	   inherit = 0;
	};
    };

    olink out_obj => obj.obj;
}; // text_glyph

macro city_plot {
    Mesh_Unif+Node_Data+IPort2 &in_field<export_all=1>;

    DV_Param_city CityParam<export_all=2> {
	glyph_comp = 0;
	map_comp = 0;
	scale_comp = 0;
	vector = 0;
	scale = 1.0;
	scale_x = 0;
	scale_y =>2-in_field.ndim;
	scale_z = 1;
	normalize = 0;
	x_scale = 1.0;
	y_scale = 1.0;
    };

    GEOMS.Block block {
	probe_ui<instanced=0>;
	DV_Param_city+IPort2 &param => CityParam;
	scale_x => param.x_scale;
	scale_y => param.y_scale;
	in => in_field;
    };

    DVglyph DVglyph {
	DV_Param_city+IPort2 &param => CityParam;
	in => in_field;
	glyph => block.out_fld;
	glyph_comp => param.glyph_comp;
	map_comp => param.map_comp;
	scale_comp => param.glyph_comp;
	vector => param.vector;
	scale => param.scale;
	scale_x => param.scale_x;
	scale_y => param.scale_y;
	scale_z => param.scale_z;
	normalize => param.normalize;
    };
    GMOD.instancer instancer {
	Value => UIpanel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => CityUI;
    };
    UImod_panel UIpanel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-);
	message = "Select City Plot control panel.";
    };

    macro CityUI<instanced=0> {
	ilink in_fld => in_field;
	DV_Param_city+IPort2 &param => CityParam;

	DVnode_data_labels DVnode_data_labels {
	    in => in_fld;
	    int+nres  ncomp => in.nnode_data;
	};
	DVmesh_extent DVmesh_extent {
	    in => in_fld;
	};
	ilink UIpanel  => <-.UIpanel;

	UIradioBoxLabel UIradioBoxLabel_glyph {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    &selectedItem+IPort2 => param.glyph_comp;
	    visible => <-.UIpanel.visible;
	    title = "Height Component";
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
	UIradioBoxLabel UIradioBoxLabel_map {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    &selectedItem+IPort2 => param.map_comp;
	    visible => <-.UIpanel.visible;
	    title = "Color Component";
	    y		=> <-.UIradioBoxLabel_glyph.y + <-.UIradioBoxLabel_glyph.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UItoggle norm_toggle {
	    parent => <-.UIpanel;
	    label = "Normalize";
	    &set+IPort2 => param.normalize;
	    y		=> <-.UIradioBoxLabel_map.y + <-.UIradioBoxLabel_map.height + 4;
	    width	=> <-.UIpanel.width;
	};

	UIslider scale_slider {
	    parent => <-.UIpanel;
	    title = "height scale";
	    value+IPort2 => param.scale;

	    float+nres max_val => in_fld.node_data[param.scale_comp].max;
	    float+nres min_val => in_fld.node_data[param.scale_comp].min;
	    float+nres min_max_val => max_array({abs(max_val),abs(min_val)});

	    min+nres => cache((-10)*(<-.DVmesh_extent.extent/min_max_val));
            max+nres => cache(( 10)*(<-.DVmesh_extent.extent/min_max_val));
	    y		=> <-.norm_toggle.y + <-.norm_toggle.height + 4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein scale_slider_typein {
	    slider	=> scale_slider;
        };

	UIslider scale_x_slider {
	    parent => <-.UIpanel;
	    title = "x-scale";
	    value+IPort2 => param.x_scale;
	    max = 2;
	    y		=> <-.scale_slider.y + <-.scale_slider.height + 4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein scale_x_slider_typein {
	    slider	=> scale_x_slider;
        };

	UIslider scale_y_slider {
	    parent => <-.UIpanel;
	    title = "y-scale";
	    value+IPort2 => param.y_scale;
	    max = 2;
	    y		=> <-.scale_x_slider.y + <-.scale_x_slider.height + 4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein scale_y_slider_typein {
	    slider	=> scale_y_slider;
        };
    };

    DataObjectNoTexture obj {
	in => DVglyph.out;
	Obj {
	    name => name_of(<-.<-.<-);
	    xform_mode = GD_XFORM_MODE_PARENT;
	    Modes.normals = 1;
	};
    };
    olink out_fld<export_all=2> => DVglyph.out;
    olink out_obj => obj.obj;
}; // city_plot

macro cylinder_plot_unif {
    Mesh_Unif+Dim2+Node_Data+IPort2 &in_field<export_all=1>;
    ilink in_locations<export_all=1>;

    DV_Param_cyl_plot CylParam<export_all=2> {
	component = 0;
	scale_height = 1;
	scale_radius = 0;
	color_sides = 1;
	radius => 0.3*(<-.in_field.coordinates.max_vec[0]-
		   <-.in_field.coordinates.min_vec[0])/(<-.in_field.dims[0]-0.99);
	scale => 0.6*(<-.in_field.coordinates.max_vec[0]-
		   <-.in_field.coordinates.min_vec[0])/(<-.in_field.dims[0]-0.99)/
		   <-.in_field.node_data[component].max;
	angle = 0;
	nseg = 36;
	default_rgb = {1.0,1.0,1.0};
	vertical = 0;
    };

     DVcyl_plot DVcyl_plot {
	DV_Param_cyl_plot+IPort2 &param => CylParam;
	in => <-.in_field;
	in_locations => <-.in_locations;
	component => param.component;
	vertical => param.vertical;
	scale_height => param.scale_height;
	scale_radius => param.scale_radius;
	color_sides => param.color_sides;
	nseg => param.nseg;
	radius => param.radius;
	scale => param.scale;
	angle => param.angle;
	default_rgb => param.default_rgb;
    };
    GMOD.instancer instancer {
	Value => UIpanel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => CylUI;
    };
    UImod_panel UIpanel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-);
	message = "Select Cylinder Plot control panel.";
    };

    macro CylUI<instanced=0> {
	ilink in_fld => in_field;
	DV_Param_cyl_plot+IPort2 &param => CylParam;

	DVnode_data_labels DVnode_data_labels {
	    in => in_fld;
	    int+nres  ncomp => in.nnode_data;
	};
	ilink UIpanel  => <-.UIpanel;

	UIradioBoxLabel UIradioBoxLabel {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    &selectedItem+IPort2 => param.component;
	    visible => <-.UIpanel.visible;
	    title = "Data Component";
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
	UItoggle vert_toggle {
	    parent => <-.UIpanel;
	    label = "vertical segmentation";
	    &set+IPort2 => param.vertical;
	    y		=> <-.UIradioBoxLabel.y + <-.UIradioBoxLabel.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UItoggle height_toggle {
	    parent => <-.UIpanel;
	    label = "scale height by total";
	    &set+IPort2 => param.scale_height;
	    y		=> <-.vert_toggle.y + <-.vert_toggle.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UItoggle radius_toggle {
	    parent => <-.UIpanel;
	    label = "scale radius by total";
	    &set+IPort2 => param.scale_radius;
	    y		=> <-.height_toggle.y + <-.height_toggle.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UItoggle color_toggle {
	    parent => <-.UIpanel;
	    label = "color sides by total";
	    &set+IPort2 => param.color_sides;
	    y		=> <-.radius_toggle.y + <-.radius_toggle.height + 4;
	    width	=> <-.UIpanel.width;
	};

	UIfieldTypein radius_value {
	    UIparent => <-.UIpanel;
	    flabel = "radius";
	    fmin+nres+IPort2 =>  0.0;
	    fval+IPort2 => param.radius;
	    field.decimalPoints = 6;
	    panel.y	=> <-.<-.color_toggle.y + <-.<-.color_toggle.height + 4;
	    panel.width	=> <-.<-.UIpanel.width;
	};
	UIfieldTypein scale_value {
	    UIparent => <-.UIpanel;
	    flabel = "height scale";
	    field.decimalPoints = 6;
	    fval+IPort2 => param.scale;
	    panel.y	=> <-.<-.radius_value.panel.y + <-.<-.radius_value.panel.height + 4;
	    panel.width	=> <-.<-.UIpanel.width;
	};
	UIslider nseg_slider {
	    parent => <-.UIpanel;
	    title = "nsegments";
	    value+IPort2 => param.nseg;
	    mode = 1;
	    min = 1;
	    max = 100;
	    y		=> <-.scale_value.panel.y + <-.scale_value.panel.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIslider angle_slider {
	    parent => <-.UIpanel;
	    title = "start angle";
	    value+IPort2 => param.angle;
	    mode = 1;
	    min = 0;
	    max = 360;
	    y		=> <-.nseg_slider.y + <-.nseg_slider.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIlabel color_label {
		parent => <-.UIpanel;
		label = "Default side color";
		width	=> <-.UIpanel.width/2;
		x = 0;
		y => <-.angle_slider.y + <-.angle_slider.height+16;
		alignment = 0;
	};
	UIframe UIframe_color {
     	  	parent => <-.UIpanel;
		x = 0;
          	y => <-.color_label.y + <-.color_label.height+10;
       	  	width	=> <-.UIpanel.clientWidth;
       		height = 200;
	};

	UIslider color_r_slider {
	    parent => <-.UIframe_color;
	    title = "red";
	    value+IPort2 => param.default_rgb[0];
	    min = 0;
	    max = 1;
	    y		= 0;
	    width	=> <-.UIframe_color.clientWidth;
	};
	UIslider color_g_slider {
	    parent => <-.UIframe_color;
	    title = "green";
	    value+IPort2 => param.default_rgb[1];
	    min = 0;
	    max = 1;
	    y		=> <-.color_r_slider.y + <-.color_r_slider.height + 4;
	    width	=> <-.UIframe_color.clientWidth;
	};
	UIslider color_b_slider {
	    parent => <-.UIframe_color;
	    title = "blue";
	    value+IPort2 => param.default_rgb[2];
	    min = 0;
	    max = 1;
	    y		=> <-.color_g_slider.y + <-.color_g_slider.height + 4;
	    width	=> <-.UIframe_color.clientWidth;
	};
    };

    DataObjectNoTexture obj {
	in => DVcyl_plot.out;
	Obj {
	    name => name_of(<-.<-.<-);
	    xform_mode = GD_XFORM_MODE_PARENT;
	    Modes.normals = 1;
	};
    };
    olink out_fld<export_all=2> => DVcyl_plot.out;
    olink out_obj => obj.obj;
}; // cylinder_plot_unif


macro shrink_cells {
    Mesh+IPort2 &in_field<export_all=1>;

    DV_Param_separate_cells ShrinkParam<export_all=2> {
	shrink=1;
	scale = 0.7;
    };

    DVseparate_cells DVseparate_cells {
	DV_Param_separate_cells+IPort2 &param => ShrinkParam;
	in => <-.in_field;
	shrink => param.shrink;
	scale => param.scale;
    };

    macro ShrinkUI {
	ilink in_fld => in_field;
	DV_Param_separate_cells+IPort2 &param => ShrinkParam;

	UImod_panel UIpanel {
	    parent<NEportLevels={4,0}>;
	    title => name_of(<-.<-.<-);
	    message = "Select Shrink control panel.";
	};
	UItoggle shrink_toggle {
	    parent => <-.UIpanel;
	    label = "shrink cells";
	    &set+IPort2 => param.shrink;
	    y		=0;
	    width	=> <-.UIpanel.width;
	};
	UIslider shrink_slider {
	    parent => <-.UIpanel;
	    title = "scale factor";
	    value+IPort2 => param.scale;
	    min = 0.0;
	    max = 1.0;
	    y		=> <-.shrink_toggle.y + <-.shrink_toggle.height + 4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein shrink_slider_typein {
	    slider	=> shrink_slider;
        };
    };

    DataObjectNoTexture obj {
	in => DVseparate_cells.out;
	Obj {
	    name => name_of(<-.<-.<-);
	    xform_mode = GD_XFORM_MODE_PARENT;
	};
    };
    olink out_fld<export_all=2> => DVseparate_cells.out;
    olink out_obj => obj.obj;
}; // shrink_cells


macro cell_centers {
    Mesh+IPort2 &in_field<export_all=1>;

	DVcell_centres DVcell_centres {
		in => <-.in_field;
	};
	DataObjectNoTexture obj {
		in => DVcell_centres.out;
		Obj {
	    		name => name_of(<-.<-.<-);
	    		xform_mode = GD_XFORM_MODE_PARENT;
		};
    	};
    	olink out_fld<export_all=2> => DVcell_centres.out;
    	olink out_obj => obj.obj;
}; // cell_centers

macro extrude_cells {
    Mesh+Cell_Data+IPort2 &in_field<export_all=1>;

    DV_Param_extrude_cells ExtrudeParam<export_all=2> {
	height_comp = 0;
	scale = 1;
	shrink=0;
	scale_factor = 0.8;
	draw_sides = 1;
	color_sides = 0;
	flip_sides_normals = 0;
    };

    DVseparate_cells DVseparate_cells {
	DV_Param_extrude_cells+IPort2 &param => ExtrudeParam;
	in => <-.in_field;
	shrink => param.shrink;
	scale => param.scale_factor;
    };
    DVextrude_cells DVextrude_cells {
	DV_Param_extrude_cells+IPort2 &param => ExtrudeParam;
	in => <-.DVseparate_cells.out;
	height_comp => param.height_comp;
	scale => param.scale;
	draw_sides => param.draw_sides;
	color_sides => param.color_sides;
	flip_sides_normals => param.flip_sides_normals;
    };
    GMOD.instancer instancer {
	Value => UIpanel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => ExtrudeUI;
    };
    UImod_panel UIpanel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-);
	message = "Select extrude control panel.";
    };

    macro ExtrudeUI<instanced=0> {
	ilink in_fld => in_field;
	DV_Param_extrude_cells+IPort2 &param => ExtrudeParam;

	DVcell_data_labels DVcell_data_labels {
	    in => in_fld;
	};
	DVmesh_extent DVmesh_extent {
	    in => in_fld;
	};
	ilink UIpanel  => <-.UIpanel;

	UIradioBoxLabel UIradioBoxLabel {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVcell_data_labels.labels;
	    &selectedItem+IPort2 => param.height_comp;
	    visible => <-.UIpanel.visible;
	    title = "height data";
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};

	UIslider height_slider {
	    parent => <-.UIpanel;
	    title = "height scale";
	    value+IPort2 => param.scale;

	    float+nres min_val => DVcell_data_labels.min_data[param.height_comp];
	    float+nres max_val => DVcell_data_labels.max_data[param.height_comp];
	    float+nres min_max_val => max_array({abs(max_val),abs(min_val)});

	    min+nres => cache((-10)*(<-.DVmesh_extent.extent/min_max_val));
            max+nres => cache(( 10)*(<-.DVmesh_extent.extent/min_max_val));

	    y		=> <-.UIradioBoxLabel.y + <-.UIradioBoxLabel.height + 4;
	    width	=> <-.UIpanel.width;
	};

	UItoggle shrink_toggle {
	    parent => <-.UIpanel;
	    label = "shrink cells";
	    &set+IPort2 => param.shrink;
	    y		=> <-.height_slider.y + <-.height_slider.height + 4;
	    width	=> <-.UIpanel.width;
	};

	UIslider shrink_slider {
	    parent => <-.UIpanel;
	    title = "shrink factor";
	    value+IPort2 => param.scale_factor;
	    min = 0.0;
	    max = 1.0;
	    y		=> <-.shrink_toggle.y + <-.shrink_toggle.height + 4;
	    width	=> <-.UIpanel.width;
	};

	UItoggle draw_sides_toggle {
	    parent => <-.UIpanel;
	    label = "draw skirts";
	    &set+IPort2 => param.draw_sides;
	    y		=> <-.shrink_slider.y + <-.shrink_slider.height + 4;
	    width	=> <-.UIpanel.width;
	};

	UItoggle color_sides_toggle {
	    parent => <-.UIpanel;
	    label = "color skirts";
	    &set+IPort2 => param.color_sides;
	    y		=> <-.draw_sides_toggle.y + <-.draw_sides_toggle.height + 4;
	    width	=> <-.UIpanel.width;
	};

    };

    DataObjectNoTexture obj {
	in => DVextrude_cells.out;
	Obj {
	    name => name_of(<-.<-.<-);
	    xform_mode = GD_XFORM_MODE_PARENT;
	    Modes.normals = 1;
	};
    };
    olink out_fld<export_all=2> => DVextrude_cells.out;
    olink out_obj => obj.obj;
}; // extrude_cells


macro interp_data {
    ilink in_field<export_all=1>;
    ilink in_probe<export_all=1>;
    DV_Param_interp InterpParam<export_all=2> {
        components[] = {0};
    };

    DVinterp_data  DVinterpolate_data {
	DV_Param_interp+IPort2 &param => InterpParam;
	in => in_field;
	probe => in_probe;
	&comps => param.components;
    };
    macro InterpUI {
	ilink in_fld => in_field;
	DV_Param_interp+IPort2 &param => InterpParam;

	DVnode_data_labels DVnode_data_labels {
	    in => in_fld;
	    int+nres  ncomp => in.nnode_data;
	};

	UImod_panel UIpanel {
	    parent<NEportLevels={4,0}>;
	    title => name_of(<-.<-.<-);
	    message = "Select Interpolate_Data control panel.";
	};

	UIoptionBoxLabel UIoptionBoxLabel {
	    parent => <-.UIpanel;
	    labels => DVnode_data_labels.labels;
	    max => DVnode_data_labels.ncomp;
	    &selectedItems => param.components;
	    title = "interpolate components";
	    visible => <-.UIpanel.visible;
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
    };
    DataObjectNoTexture obj {
	in => DVinterpolate_data.out;
	Obj {
	    name => name_of(<-.<-.<-);
	    xform_mode = GD_XFORM_MODE_ALT;
	    alt_xform+nres => <-.<-.in_probe.xform;
	};
    };

    olink out_fld<export_all=2> => DVinterpolate_data.out;
    olink out_obj => obj.obj;
}; // interp_data


// probe field is assumed to be uniform
macro interp_data_to_unif {
    ilink in_field<export_all=1>;
    ilink in_probe<export_all=1>;
    DV_Param_interp InterpParam<export_all=2> {
        components[] = {0};
        int algorithm = 1;
    };

    DVinterp_data_to_unif DVinterp_data_unif {
	DV_Param_interp+IPort2 &param {
            int algorithm;
        }      => <-.InterpParam;
	in     => <-.in_field;
	probe  => <-.in_probe;
	&comps => param.components;
        &algorithm => param.algorithm;
    };
    macro InterpUI {
	ilink in_fld => in_field;
	DV_Param_interp+IPort2 &param {
            int algorithm;
        } => <-.InterpParam;

	DVnode_data_labels DVnode_data_labels {
	    in => in_fld;
	    int+nres  ncomp => in.nnode_data;
	};

	UImod_panel UIpanel {
	    parent<NEportLevels={4,0}>;
	    title => name_of(<-.<-.<-);
	    message = "Select Interpolate_Data control panel.";
	};

	UIoptionBoxLabel comp_optionBoxLabel {
	    parent => <-.UIpanel;
	    labels => DVnode_data_labels.labels;
	    max => DVnode_data_labels.ncomp;
	    &selectedItems => param.components;
	    title = "interpolate components";
	    visible => <-.UIpanel.visible;
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};

	UIradioBoxLabel algo_radioBoxLabel {
	    parent => <-.UIpanel;
	    labels => { "faster", "better quality" };
	    &selectedItem => param.algorithm;
	    title = "algorithm";
	    visible => <-.UIpanel.visible;
	    y		=> <-.comp_optionBoxLabel.y + 
                           <-.comp_optionBoxLabel.height + 12;
	    width	=> <-.UIpanel.width;
	};
    };
    DataObjectNoTexture obj {
	in => DVinterp_data_unif.out;
	Obj {
	    name => name_of(<-.<-.<-);
	    xform_mode = GD_XFORM_MODE_ALT;
	    alt_xform+nres => <-.<-.in_probe.xform;
	};
    };

    olink out_fld<export_all=2> => DVinterp_data_unif.out;
    olink out_obj => obj.obj;
}; // interp_data_unif


macro interp_cell_data {
    ilink in_field<export_all=1>;
    ilink in_probe<export_all=1>;

    DV_Param_extr_comp ExtrCompParam<export_all=2> {
	component = 0;
    };

    DVinterp_cell_data DVinterpolate_cell_data {
	DV_Param_extr_comp+IPort2 &param => ExtrCompParam;
	in => in_field;
	probe => in_probe;
	&component => param.component;
    };

    macro InterpUI {
	ilink in_fld => in_field;
	DV_Param_extr_comp+IPort2 &param => ExtrCompParam;

	UImod_panel UIpanel {
	    parent<NEportLevels={4,0}>;
	    title => name_of(<-.<-.<-);
	    message = "Select interpolate cell data control panel.";
	};
	DVcell_data_labels DVcell_data_labels {
	    in => in_fld;
	};
	UIradioBoxLabel UIradioBoxLabel {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVcell_data_labels.labels;
	    &selectedItem+IPort2 => param.component;
	    visible => <-.UIpanel.visible;
	    title = "cell data";
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
    };
    DataObjectNoTexture obj {
	in => DVinterpolate_cell_data.out;
	Obj {
	    name => name_of(<-.<-.<-);
	    xform_mode = GD_XFORM_MODE_ALT;
	    alt_xform+nres => <-.<-.in_probe.xform;
	};
    };

    olink out_fld<export_all=2> => DVinterpolate_cell_data.out;
    olink out_obj => obj.obj;
}; // interp_cell_data

macro probe {
    ilink in_field<export_all=1>;
    ilink in_glyph<export_all=1>;
    GDobject_templ+IPort2 &in_pick<export_all=1>;

    DV_Param_probe+Port ProbeParam<export_all=2> {
	component = 0;
	scale = 1.0;
	normalize = 0;
    };

    Probe Probe {
	in_fld => in_field;
	pick => in_pick;
	in_probe => in_glyph;
	DV_Param_probe+IPort2 &param => ProbeParam;
    };

    DV_Param_probe_o+Port &ProbeOParam<export_all=2> => Probe.oparam;

    TextField probe_anno {
		nspace=3;
		nnodes =1;
		text_values => " ("+<-.Probe.out_probe.coordinates.values[0]+
			       ", "+<-.Probe.out_probe.coordinates.values[1]+
			       ", "+<-.Probe.out_probe.coordinates.values[2]+
			       ")";
		coordinates {
			&values+nres => <-.<-.Probe.out_probe.coordinates.values;
		};
		&xform => <-.Probe.out_probe.xform;
    };

    GMOD.instancer instancer {
	Value => UIpanel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => ProbeUI;
    };
    UImod_panel UIpanel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-);
	message = "Select Probe control panel.";
    };

    macro ProbeUI<instanced=0> {
	ilink in_fld => in_field;
	DV_Param_probe+IPort2 &param => ProbeParam;
	DV_Param_probe_o+IPort2 &oparam => ProbeOParam;

	DVnode_data_labels DVnode_data_labels {
	    in => in_fld;
	    int+nres  ncomp => in.nnode_data;
	};
	ilink UIpanel  => <-.UIpanel;

	UIradioBoxLabel UIradioBoxLabel {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    &selectedItem+IPort2 => param.component;
	    visible => <-.UIpanel.visible;
	    title = "data component";
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};

	UItoggle norm_toggle {
	    parent => <-.UIpanel;
	    label = "Probe Normalize";
	    &set+IPort2 => param.normalize;
	    y		=> <-.UIradioBoxLabel.y + <-.UIradioBoxLabel.height + 4;
	    width	=> <-.UIpanel.width;
	};

	UIslider scale_slider {
	    parent => <-.UIpanel;
	    title = "probe scale";
	    min = -10;
	    max = 10;
	    value+IPort2 => param.scale;
	    y		=> <-.norm_toggle.y + <-.norm_toggle.height + 4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein scale_slider_typein {
	    slider	=> scale_slider;
        };

	UIfieldTypein probe_value {
	    UIparent => <-.UIpanel;
	    flabel = "value";
	    fmin+nres+IPort2 =>  cache(in_fld.node_data[param.component].min_vec[0]-10000);
	    fmax+nres+IPort2 =>  cache(in_fld.node_data[param.component].max_vec[0]+10000);
	    fval+IPort2 => oparam.value[0];
	    panel.y	=> <-.<-.scale_slider.y + <-.<-.scale_slider.height + 4;
	    panel.width	=> <-.<-.UIpanel.width;
	};
	UItoggle xform_toggle {
	    parent => <-.UIpanel;
	    label = "Probe Transform Editor";
	    y		=> <-.probe_value.panel.y + <-.probe_value.panel.height + 4;
	    width	=> <-.UIpanel.width;
	};
	XformEditor probe_edit {
	    obj_in => Probe.fprobe;
	    vis => xform_toggle.set;
	};
    };

    DataObjectNoTexture obj {
	in => Probe.out_fld;
	Obj {
	    name => name_of(<-.<-.<-);
	    type = 1;
	};
    };
    DataObjectNoTexture obj_anno {
        	in => <-.probe_anno;
		Obj {
			xform_mode = GD_XFORM_MODE_PARENT;
			name = "probe anno";
		};
    };
    olink out_fld<export_all=2> => Probe.out_probe;
    olink out_obj => obj.obj;
    olink out_anno => obj_anno.obj;
}; // probe

macro probe_cell {
    ilink in_field<export_all=1>;
    ilink in_glyph<export_all=1>;
    GDobject_templ+IPort2 &in_pick<export_all=1>;

    DV_Param_probe+Port ProbeParam<export_all=2> {
	component = 0;
	scale = 1.0;
	normalize = 0;
    };

    ProbeCell ProbeCell {
	in_fld => in_field;
	pick => in_pick;
	in_probe => in_glyph;
	DV_Param_probe+IPort2 &param => ProbeParam;
    };

    DV_Param_probe_o+Port &ProbeOParam<export_all=2> => ProbeCell.oparam;
    GMOD.instancer instancer {
	Value => UIpanel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => ProbeUI;
    };
    UImod_panel UIpanel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-);
	message = "Select probe control panel.";
    };

    macro ProbeUI <instanced=0> {
	ilink in_fld => in_field;
	DV_Param_probe+IPort2 &param => ProbeParam;
	DV_Param_probe_o+IPort2 &oparam => ProbeOParam;

	DVcell_data_labels DVcell_data_labels {
	    in => in_fld;
	};
	ilink UIpanel  => <-.UIpanel;

	UIradioBoxLabel UIradioBoxLabel {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVcell_data_labels.labels;
	    &selectedItem+IPort2 => param.component;
	    visible => <-.UIpanel.visible;
	    title = "cell data";
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};

	UItoggle norm_toggle {
	    parent => <-.UIpanel;
	    label = "Probe Normalize";
	    &set+IPort2 => param.normalize;
	    y		=> <-.UIradioBoxLabel.y + <-.UIradioBoxLabel.height + 4;
	    width	=> <-.UIpanel.width;
	};

	UIslider scale_slider {
	    parent => <-.UIpanel;
	    title = "probe scale";
	    min = -10;
	    max = 10;
	    value+IPort2 => param.scale;
	    y		=> <-.norm_toggle.y + <-.norm_toggle.height + 4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein scale_slider_typein {
	    slider	=> scale_slider;
        };

	UIfieldTypein probe_value {
	    UIparent => <-.UIpanel;
	    flabel = "value";
	    fmin+nres+IPort2 =>  cache(in_fld.node_data[param.component].min_vec[0]);
	    fmax+nres+IPort2 =>  cache(in_fld.node_data[param.component].max_vec[0]);
	    fval+IPort2 => oparam.value[0];
	    panel.y	=> <-.<-.scale_slider.y + <-.<-.scale_slider.height + 4;
	    panel.width	=> <-.<-.UIpanel.width;
	};
	UItoggle xform_toggle {
	    parent => <-.UIpanel;
	    label = "Probe Transform Editor";
	    y		=> <-.probe_value.panel.y + <-.probe_value.panel.height + 4;
	    width	=> <-.UIpanel.width;
	};
	XformEditor probe_edit {
	    obj_in => ProbeCell.fprobe;
	    vis => xform_toggle.set;
	};
    };

    DataObjectNoTexture obj {
	in => ProbeCell.out_fld;
	Obj {
	    type = 1;
	    name => name_of(<-.<-.<-);
	};
    };

    olink out_fld<export_all=2> => ProbeCell.out_probe;
    olink out_obj => obj.obj;
}; // probe_cell

macro iso_probe {
    ilink in_field<export_all=1>;
    ilink in_glyph<export_all=1>;
    GDobject_templ+IPort2 &in_pick<export_all=1>;

    DV_Param_iso_probe+Port IsoProbeParam<export_all=2> {
	iso_component = 0;
	map_component = 0;
	scale = 1.0;
	normalize = 0;
    };

    IsoProbe IsoProbe {
	in_fld => in_field;
	pick => in_pick;
	in_probe => in_glyph;
	param => IsoProbeParam;
    };

    DV_Param_probe_o+Port &ProbeOParam<export_all=2> => IsoProbe.oparam;
    GMOD.instancer instancer {
	Value => UIpanel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => IsoProbeUI;
    };
    UImod_panel UIpanel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-);
	message = "Select IsoProbe control panel.";
    };

    macro IsoProbeUI<instanced=0> {
	ilink in_fld => in_field;
	DV_Param_iso_probe+IPort2 &param => IsoProbeParam;
	DV_Param_probe_o+IPort2 &oparam => ProbeOParam;

	DVnode_data_labels DVnode_data_labels {
	    in => in_fld;
	    int+nres  ncomp => in_fld.nnode_data;
	};
	ilink UIpanel  => <-.UIpanel;

	UIradioBoxLabel UIradioBoxLabel_iso {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    &selectedItem+IPort2 => param.iso_component;
	    visible => <-.UIpanel.visible;
	    title = "iso component";
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
	UIradioBoxLabel UIradioBoxLabel_map {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    &selectedItem+IPort2 => param.map_component;
	    visible => <-.UIpanel.visible;
	    title = "map component";
	    y		=> <-.UIradioBoxLabel_iso.y + <-.UIradioBoxLabel_iso.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UItoggle norm_toggle {
	    parent => <-.UIpanel;
	    label = "Probe Normalize";
	    &set+IPort2 => param.normalize;
	    y		=> <-.UIradioBoxLabel_map.y + <-.UIradioBoxLabel_map.height + 4;
	    width	=> <-.UIpanel.width;
	};

	UIslider scale_slider {
	    parent => <-.UIpanel;
	    title = "probe scale";
	    min = -10;
	    max = 10;
	    value+IPort2 => param.scale;
	    y		=> <-.norm_toggle.y + <-.norm_toggle.height + 4;
	    width	=> <-.UIpanel.width;
	};

	UIfieldTypein probe_value {
	    UIparent => <-.UIpanel;
	    flabel = "value";
	    fmin+nres+IPort2 =>  cache(in_fld.node_data[param.component].min_vec[0]);
	    fmax+nres+IPort2 =>  cache(in_fld.node_data[param.component].max_vec[0]);
	    fval+IPort2 => oparam.value[0];
	    panel.y	=> <-.<-.scale_slider.y + <-.<-.scale_slider.height + 4;
	    panel.width	=> <-.<-.UIpanel.width;
	};
	UItoggle xform_toggle {
	    parent => <-.UIpanel;
	    label = "Plane Transform Editor";
	    y		=> <-.probe_value.panel.y + <-.probe_value.panel.height + 4;
	    width	=> <-.UIpanel.width;
	};
	XformEditor probe_edit {
	    obj_in => IsoProbe.fprobe;
	    vis => xform_toggle.set;
	};
    };

    olink out_fld<export_all=2> => IsoProbe.out_fld;
    olink out_fld1<export_all=2> => IsoProbe.out_fld1;

    DataObjectNoTexture obj {
	in => IsoProbe.out_fld;
	Obj {
	    name => name_of(<-.<-.<-);
	    xform_mode = GD_XFORM_MODE_PARENT;
	};
    };
    olink out_obj => obj.obj;

    DataObjectNoTexture obj1 {
	in => IsoProbe.out_fld1;
	Obj.type = 1;
    };

    olink out_obj1 => obj1.obj;
};  // iso_probe

macro draw_line {
    GDobject_templ+IPort2 &in_pick<export_all=1>;

    DVcreate_line DVcreate_line {
	picked_xyz => in_pick.pick_info.pick_data[0].point;
	picked_xform => in_pick.xform;
    };
    macro CreateLineUI {
	UImod_panel UIpanel {
	    parent<NEportLevels={4,0}>;
	    title => name_of(<-.<-.<-);
	    message = "Select Draw Line control panel.";
	};
	UItoggle pick_toggle {
	    parent => <-.UIpanel;
	    label = "Pick Point";
	    &set => DVcreate_line.pick;
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
	UItoggle new_toggle {
	    parent => <-.UIpanel;
	    label = "New Line";
	    &set => DVcreate_line.new;
	    y		=> <-.pick_toggle.y + <-.pick_toggle.height + 4;
	    width	=> <-.UIpanel.width;
	};
    };
    DataObjectNoTexture obj {
	in => DVcreate_line.out;
	Obj {
	    type = 1;
	    name => name_of(<-.<-.<-);
	};
    };

    olink out_fld<export_all=2> => DVcreate_line.out;
    olink out_obj => obj.obj;
}; // draw_line

macro isosurface {
    ilink in_field<export_all=1>;

    /*
     * Export the param block up two levels
     */
    DV_Param_iso+Port IsoParam<export_all=2> {
	iso_component = 0;
	iso_level =>  cache((in_field.node_data[iso_component].min + 
		     in_field.node_data[iso_component].max) / 2);
	map_component = {0};
	cell_data = {0};
    };
    int has_cell_data => (DVcell_data_labels.ncomp > 0);
    Iso Iso {
	in_fld => in_field;
	param => IsoParam;
	DViso {
		cell_data => switch(has_cell_data, param.cell_data);
	};
    };
    DVnode_data_labels DVnode_data_labels {
	    in => in_field;
	    int+nres  ncomp => in_fld.nnode_data;
    };
    DVcell_data_labels DVcell_data_labels {
	    in => in_field;
    };
    UImod_panel UIpanel {
	    parent<NEportLevels={3,0}>;
	    title => name_of(<-.<-);
	    message = "Select isosurface control panel.";
    };
    GMOD.instancer instancer {
	Value => UIpanel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => IsoUI;
    };

    macro IsoUI<instanced=0> {
	ilink in_fld => in_field;
	DV_Param_iso+IPort2 &param => IsoParam;

	ilink DVnode_data_labels => <-.DVnode_data_labels;
	ilink DVcell_data_labels => <-.DVcell_data_labels;
	ilink UIpanel => <-.UIpanel;

	UIradioBoxLabel UIradioBoxLabel {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    &selectedItem+IPort2 => param.iso_component;
	    visible => <-.UIpanel.visible;
	    title = "iso component";
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
	UIslider UIiso_level {
	    parent => <-.UIpanel;
	    title = "iso level";
	    min+nres =>  cache(in_fld.node_data[param.iso_component].min);
	    max+nres =>  cache(in_fld.node_data[param.iso_component].max);
	    value+IPort2 => param.iso_level;
	    y		=> <-.UIradioBoxLabel.y + <-.UIradioBoxLabel.height+4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein UIiso_level_typein {
	    slider	=> UIiso_level;
        };
	UIoptionBoxLabel UIoptionBoxLabel {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    max => DVnode_data_labels.ncomp;
	    &selectedItems+IPort2 => param.map_component;
	    title = "map components";
	    visible => <-.UIpanel.visible;
	    y		=> <-.UIiso_level.y + <-.UIiso_level.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIoptionBoxLabel UIoptionBoxLabel_cell {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVcell_data_labels.labels;
	    max => DVcell_data_labels.ncomp;
	    &selectedItems+IPort2 => param.cell_data;
	    title = "map cell components";
	    visible => <-.UIpanel.visible & (DVcell_data_labels.ncomp > 0);
	    y		=> <-.UIoptionBoxLabel.y + <-.UIoptionBoxLabel.height + 4;
	    width	=> <-.UIpanel.width;
	};
    };

    DataObjectNoTexture obj {
	in => Iso.out_fld;
	Obj {
	    name => name_of(<-.<-.<-);
	    xform_mode = GD_XFORM_MODE_PARENT;
	};
    };

    olink out_fld<export_all=2> => Iso.out_fld;
    olink out_obj => obj.obj;
}; // isosurface


macro isosurface_nest {
    Mesh+Node_Data &in_field<NEportLevels={2,1}>;

    DV_Param_isonest isonest_params {
        min+nres =>  cache( 0.7*<-.in_field.node_data[num_component].min +
                            0.3*<-.in_field.node_data[num_component].max );
        max+nres =>  cache( 0.1*<-.in_field.node_data[num_component].min +
                            0.9*<-.in_field.node_data[num_component].max );

        int num_levels = 3;
        int num_component = 0;
        float transparency = 0.5;
        int   trans_ramp = 1;
        float ramp_delta = 0.3;
    };

    // Functional macro.  Although this would seem to be a good
    // candidate for inclusion into the DV_MACROS library, I didn't
    // want to introduce GD dependencies into that library.
    macro IsonestFunc {
        ilink fld_in => in_field;
        DV_Param_isonest+IPort2 &params => <-.isonest_params;

        float values<NEportLevels={1,1}>[params.num_levels] =>
            init_array ( params.num_levels, params.min, params.max );

        float trans_vals<NEportLevels={1,1}>[params.num_levels] =>
            init_array ( params.num_levels, 
                         (params.transparency -
                           ( params.ramp_delta*0.5 ) * params.trans_ramp),
                         (params.transparency +
                           ( params.ramp_delta*0.5 ) * params.trans_ramp) );

        macro fld2dmap {
            DefaultMinMax MinMax {
                input => <-.<-.fld_in;
            };
            DefaultLinear Datamap<NEportLevels={0,2}> {
                dataMin => <-.MinMax.min_value;
                dataMax => <-.MinMax.max_value;
            };
        };
        DMAP.Dmap2Colors Dmap2Colors {
            values => <-.values;
            dmap => <-.fld2dmap.Datamap;
        };
        float color_values<NEportLevels={1,1}>[] => Dmap2Colors.colors;

        DViso DViso[params.num_levels] {
            int index => index_of(DViso);
            in => <-.fld_in;
            level => <-.values[index];
            cell_data => ;
            component => <-.params.num_component;

            DataObjectLite dataObj {
                in => <-.out;
                Props.trans => <-.<-.<-.trans_vals[<-.<-.index];
                obj<NEportLevels={0,3}>;
                Obj.xform_mode = "Parent";
                Obj.name => "shell "+ <-.<-.index;
                Props.inherit = 0;
                Props.col => { <-.<-.<-.color_values[<-.<-.index*3],
                               <-.<-.<-.color_values[<-.<-.index*3+1],
                               <-.<-.<-.color_values[<-.<-.index*3+2] };
            };
        };
        GMOD.group_reverse group_reverse {
            in_groups => <-.DViso.dataObj.obj;
        };
        GDM.GroupObject GroupObjFront {
            child_objs+nres => <-.DViso.dataObj.obj;
            Props.cull = "Front";
            Top.xform_mode = "Parent";
        };
        GDM.GroupObject GroupObjBack {
            child_objs+nres => <-.group_reverse.out_groups;
            Props.cull = "Back";
            Top.xform_mode = "Parent";
        };
        GDM.GroupObject GroupObjectOut {
            child_objs+nres => { GroupObjBack.obj, GroupObjFront.obj };
            Top.xform_mode = "Parent";
            Top.dmap<NEportLevels={3,0}> => <-.<-.fld2dmap.Datamap;
        };
        olink obj => GroupObjectOut.obj;
    };

    // User Interface
    macro IsonestUI {
        ilink in_fld => in_field;

        DV_Param_isonest+IPort2 &params => isonest_params;

        DVnode_data_labels DVnode_data_labels {
            in => <-.in_fld;
            int+nres ncomp => in.nnode_data;
        };
        UImod_panel UIpanel {
            title => name_of(<-.<-.<-,1);
            message = "Select isosurface_nest control panel.";
            parent<NEportLevels={4,0}>;
        };
        UIradioBoxLabel UIradioBoxLabel {
            parent => <-.UIpanel;
            labels+IPort2 => DVnode_data_labels.labels;
            &selectedItem+IPort2 => params.num_component;
            visible+nres => <-.UIpanel.visible;
            title = "isosurface data component";
            y        =  0;
            width    => <-.UIpanel.clientWidth;
        };
        UIslider nlevels {
            parent => <-.UIpanel;
            title = "number of isosurface shells";
            min = 1;
            max = 8;
            mode = 1;
            value+IPort2 => params.num_levels;
            y => <-.UIradioBoxLabel.y + <-.UIradioBoxLabel.height + 4;
            width    => <-.UIpanel.clientWidth * 11 / 12;
        };
        VUIslider_typein nlevels_typein {
            slider    => nlevels;
        };
        UIslider iso_level_min {
            parent => <-.UIpanel;
            title = "min level";
            min+nres =>  cache(in_fld.node_data[params.num_component].min);
            max+nres =>  cache(in_fld.node_data[params.num_component].max);
            value+IPort2 => params.min;
            y        => <-.nlevels.y + <-.nlevels.height + 4;
            width    => <-.UIpanel.clientWidth * 11 / 12;
        };
        VUIslider_typein iso_level_min_typein {
            slider    => iso_level_min;
        };
        UIslider iso_level_max {
            parent => <-.UIpanel;
            title = "max level";
            min+nres =>  cache(in_fld.node_data[params.num_component].min);
            max+nres =>  cache(in_fld.node_data[params.num_component].max);
            value+IPort2 => params.max;
            y        => <-.iso_level_min.y + <-.iso_level_min.height + 4;
            width    => <-.UIpanel.clientWidth * 11 / 12;
        };
        VUIslider_typein iso_level_max_typein {
            slider    => iso_level_max;
        };
        UIslider trans_level {
            parent => <-.UIpanel;
            title = "transparency level";
            min = 0.0;
            max = 1.0;
            value+IPort2 => params.transparency;
            y        => <-.iso_level_max.y + <-.iso_level_max.height + 4;
            width    => <-.UIpanel.clientWidth * 11 / 12;
        };
        VUIslider_typein trans_level_typein {
            slider    => trans_level;
        };
        UItoggle trans_ramp_toggle {
            parent => <-.UIpanel;
            label = "Transparency Progressive Ramp";
            &set+IPort2 => params.trans_ramp;
            y      => <-.trans_level.y + <-.trans_level.height + 8;
            width  => <-.UIpanel.clientWidth;
        };
        UIslider trans_range {
            parent => <-.UIpanel;
            title = "transparency range delta";
            min = 0.0;
            max = 1.0;
            value+IPort2 => params.ramp_delta;
            y      => <-.trans_ramp_toggle.y + <-.trans_ramp_toggle.height + 4;
            width  => <-.UIpanel.clientWidth * 11 / 12;
            active => <-.trans_ramp_toggle.set;
        };
        VUIslider_typein trans_range_typein {
            slider    => trans_range;
        };
    }; // end of user interface

    olink obj => IsonestFunc.obj;

    // No field output.  IsonestFunc.DViso.out will provide
    // an array of meshes, but there is no node data.

}; // isosurface_nest

macro isosurface_trace {
    ilink in_field<export_all=1>;
    ilink probe<export_all=1>;

    DV_Param_iso+Port IsoParam<export_all=2> {
	iso_component = 0;
	map_component = {0};
    };

    IsoSurfTrace IsoSurfTrace {
	in_fld => in_field;
	in_probe => probe;
	param => IsoParam;
    };

    macro IsoTraceUI {
	ilink in_fld => in_field;
	DV_Param_iso+IPort2 &param => IsoParam;

	DVnode_data_labels DVnode_data_labels {
	    in => in_fld;
	    int+nres  ncomp => in_fld.nnode_data;
	};
	UImod_panel UIpanel {
	    parent<NEportLevels={4,0}>;
	    title => name_of(<-.<-.<-);
	    message = "Select Isosurface Trace control panel.";
	};

	UIradioBoxLabel UIradioBoxLabel {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    &selectedItem+IPort2 => param.iso_component;
	    visible => <-.UIpanel.visible;
	    title = "iso component";
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
	UIoptionBoxLabel UIoptionBoxLabel {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    max => DVnode_data_labels.ncomp;
	    &selectedItems+IPort2 => param.map_component;
	    title = "map components";
	    visible => <-.UIpanel.visible;
	    y		=> <-.UIradioBoxLabel.y + <-.UIradioBoxLabel.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIslider UIiso_level {
	    parent => <-.UIpanel;
	    title = "iso level";
	    min+nres =>  cache(in_fld.node_data[param.iso_component].min);
	    max+nres =>  cache(in_fld.node_data[param.iso_component].max);
	    value+IPort2 => param.iso_level;
	    y		=> <-.UIoptionBoxLabel.y + <-.UIoptionBoxLabel.height + 4;
	    width	=> <-.UIpanel.width;
	};
    };

    DataObjectNoTexture obj {
	in =>IsoSurfTrace.out_fld;
	Obj {
	    name => name_of(<-.<-.<-);
	    xform_mode = GD_XFORM_MODE_PARENT;
	};
    };

    olink out_fld<export_all=2> => IsoSurfTrace.out_fld;
    olink out_obj => obj.obj;
}; // isosurface_trace

macro isoline {
    ilink in_field<export_all=1>;

    DV_Param_contour+Port IsoParam<export_all=2> {
	contour_comp = 0;
	ncontours = 10;
	level_min+nres =>  cache(0.7*in_field.node_data[contour_comp].min+
		    0.3*in_field.node_data[contour_comp].max);
	level_max+nres =>  cache(0.3*in_field.node_data[contour_comp].min+
		    0.7*in_field.node_data[contour_comp].max);
	color = 1;
    };

    DVisoline DVisoline {
	DV_Param_contour+IPort2 &param => IsoParam;
	in => in_field;
	&component => param.contour_comp;
	&level => init_array(param.ncontours, param.level_min,param.level_max);
	&color => param.color;
    };
    GMOD.instancer instancer {
	Value => UIpanel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => IsoLineUI;
    };
    UImod_panel UIpanel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-);
	message = "Select Isoline control panel.";
    };

    macro IsoLineUI<instanced=0> {
	ilink in_fld => in_field;
	DV_Param_contour+IPort2 &param => IsoParam;

	DVnode_data_labels DVnode_data_labels {
	    in => in_fld;
	    int+nres  ncomp => in.nnode_data;
	};
	ilink UIpanel  => <-.UIpanel;

	UIradioBoxLabel UIradioBoxLabel {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    &selectedItem+IPort2 => param.contour_comp;
	    visible => <-.UIpanel.visible;
	    title = "iso component";
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
	UIslider nleveles {
	    parent => <-.UIpanel;
	    title = "number of contours";
	    min = 1;
	    mode = 1;
	    value+IPort2 => param.ncontours;
	    y		=> <-.UIradioBoxLabel.y + <-.UIradioBoxLabel.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIslider iso_level_min {
	    parent => <-.UIpanel;
	    title = "min level";
	    min+nres =>  cache(in_fld.node_data[param.contour_comp].min);
	    max+nres =>  cache(in_fld.node_data[param.contour_comp].max);
	    value+IPort2 => param.level_min;
	    y		=> <-.nleveles.y + <-.nleveles.height + 4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein iso_level_min_typein {
	    slider	=> iso_level_min;
        };
	UIslider iso_level_max {
	    parent => <-.UIpanel;
	    title = "max level";
	    min+nres =>  cache(in_fld.node_data[param.contour_comp].min);
	    max+nres =>  cache(in_fld.node_data[param.contour_comp].max);
	    value+IPort2 => param.level_max;
	    y		=> <-.iso_level_min.y + <-.iso_level_min.height + 4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein iso_level_max_typein {
	    slider	=> iso_level_max;
        };
	UItoggle color_toggle {
	    parent => <-.UIpanel;
	    label = "Color";
	    &set+IPort2 => param.color;
	    y		=> <-.iso_level_max.y + <-.iso_level_max.height + 4;
	    width	=> <-.UIpanel.width;
	};

    };

    DataObjectNoTexture obj {
	in => DVisoline.out;
	Modes {
	    mode = {0,GD_LINES,0,0,0};	/* set lines mode on */
	};
	Obj {
	    name => name_of(<-.<-.<-);
	    xform_mode = GD_XFORM_MODE_PARENT;
	};
    };

    olink out_fld<export_all=2> => DVisoline.out;
    olink out_obj => obj.obj;
}; // isoline

macro isoline_trace {
    ilink in_field<export_all=1>;
    ilink in_probe<export_all=1>;

    DV_Param_iso+Port IsoParam<export_all=2> {
	iso_component = 0;
    };

    DVisoline_trace DVisoline_trace {
	DV_Param_iso+IPort2 &param => IsoParam;
	in => in_field;
	probe => in_probe;
	&component => param.iso_component;
	&level => param.iso_level;
	color = 1;
    };

    macro IsoLineUI {
	ilink in_fld => in_field;
	DV_Param_iso+IPort2 &param => IsoParam;

	DVnode_data_labels DVnode_data_labels {
	    in => in_fld;
	    int+nres  ncomp => in.nnode_data;
	};
	UImod_panel UIpanel {
	    parent<NEportLevels={4,0}>;
	    title => name_of(<-.<-.<-);
	    message = "Select Isoline Trace control panel.";
	};
	UIradioBoxLabel UIradioBoxLabel {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    &selectedItem+IPort2 => param.iso_component;
	    visible => <-.UIpanel.visible;
	    title = "iso component";
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
	UIslider iso_level {
	    parent => <-.UIpanel;
	    title = "iso level";
	    min+nres =>  cache(in_fld.node_data[param.iso_component].min);
	    max+nres =>  cache(in_fld.node_data[param.iso_component].max);
	    value+IPort2 => param.iso_level;
	    y		=> <-.UIradioBoxLabel.y + <-.UIradioBoxLabel.height + 4;
	    width	=> <-.UIpanel.width;
	};
    };

    DataObjectNoTexture obj {
	in => DVisoline_trace.out;
	Modes {
	    mode = {0,GD_LINES,0,0,0};	/* set lines mode on */
	};
	Obj {
	    name => name_of(<-.<-.<-);
	    xform_mode = GD_XFORM_MODE_PARENT;
	};
    };

    olink out_fld<export_all=2> => DVisoline_trace.out;
    olink out_obj => obj.obj;
}; // isoline_trace

macro solid_contour {
    ilink in_field<export_all=1>;

    DV_Param_contour ContourParam<export_all=2> {
	contour_comp = 0;
	ncontours = 4;
	level_min+nres =>  cache(0.8*in_field.node_data[contour_comp].min+
		    0.2*in_field.node_data[contour_comp].max);
	level_max+nres =>  cache(0.2*in_field.node_data[contour_comp].min+
		    0.8*in_field.node_data[contour_comp].max);
	contour_lines = 0;
	color = 0;
    };
    DVsolid_contour DVsolid_contour {
	DV_Param_contour+IPort2 &param => ContourParam;
	in => in_field;
	&contour_comp => param.contour_comp;
	&level => init_array(param.ncontours+1,param.level_min,param.level_max);
	&contour_lines => param.contour_lines;
	&color_lines => param.color;
    };
    GMOD.instancer instancer {
	Value => UIpanel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => SolidContourdUI;
    };
    UImod_panel UIpanel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-);
	message = "Select solid contour control panel.";
    };

    macro SolidContourdUI<instanced=0> {
	ilink in_fld => in_field;
	DV_Param_contour+IPort2 &param => ContourParam;

	DVnode_data_labels DVnode_data_labels {
	    in => in_fld;
	    int+nres  ncomp => in.nnode_data;
	};
	ilink UIpanel  => <-.UIpanel;

	UIradioBoxLabel UIradioBoxLabel {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    &selectedItem+IPort2 => param.contour_comp;
	    visible => <-.UIpanel.visible;
	    title = "contour component";
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
	UIslider nleveles {
	    parent => <-.UIpanel;
	    title = "number of contours";
	    min = 1;
	    mode = 1;
	    value+IPort2 => param.ncontours;
	    y		=> <-.UIradioBoxLabel.y + <-.UIradioBoxLabel.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIslider iso_level_min {
	    parent => <-.UIpanel;
	    title = "min level";
	    min+nres =>  cache(in_fld.node_data[param.contour_comp].min);
	    max+nres =>  cache(in_fld.node_data[param.contour_comp].max);
	    value+IPort2 => param.level_min;
	    y		=> <-.nleveles.y + <-.nleveles.height + 4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein iso_level_min_typein {
	    slider	=> iso_level_min;
        };

	UIslider iso_level_max {
	    parent => <-.UIpanel;
	    title = "max level";
	    min+nres =>  cache(in_fld.node_data[param.contour_comp].min);
	    max+nres =>  cache(in_fld.node_data[param.contour_comp].max);
	    value+IPort2 => param.level_max;
	    y		=> <-.iso_level_min.y + <-.iso_level_min.height + 4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein iso_level_max_typein {
	    slider	=> iso_level_max;
        };
	UItoggle line_toggle {
	    parent => <-.UIpanel;
	    label = "Contour Lines";
	    &set+IPort2 => param.contour_lines;
	    y		=> <-.iso_level_max.y + <-.iso_level_max.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UItoggle line_color_toggle {
	    parent => <-.UIpanel;
	    label = "Color Lines";
	    &set+IPort2 => param.color;
	    y		=> <-.line_toggle.y + <-.line_toggle.height + 4;
	    active 	=> param.contour_lines;
	    width	=> <-.UIpanel.width;
	};
    };
    DataObjectNoTexture obj {
	in => DVsolid_contour.out;
	Obj {
	    name => name_of(<-.<-.<-);
	    xform_mode = GD_XFORM_MODE_PARENT;
	    Modes.normals = 1;
	};
    };
    DataObjectNoTexture obj_line {
	in => DVsolid_contour.out_line;
	Modes {
	    mode = {0,GD_LINES,0,0,0};	/* set lines mode on */
	};
	Props {
	    jitter = 1;
	    inherit = 0;
	};
	Obj {
	    name => name_of(<-.<-.<-)+"lines";
	    xform_mode = GD_XFORM_MODE_PARENT;
	};
    };

    olink out_fld<export_all=2> => DVsolid_contour.out;
    olink out_fld_line<export_all=2> => DVsolid_contour.out_line;
    olink out_obj => obj.obj;
    olink out_obj_line => obj_line.obj;
}; // solid_contour

macro contour_texture {
    ilink in_field<export_all=1>;
    imlink in_imgs;

    DV_Param_contour ContourParam<export_all=2> {
	contour_comp = 0;
	ncontours => array_size(in_imgs)+0;
	level_min+nres =>  cache(0.8*in_field.node_data[contour_comp].min+
		    0.2*in_field.node_data[contour_comp].max);
	level_max+nres =>  cache(0.2*in_field.node_data[contour_comp].min+
		    0.8*in_field.node_data[contour_comp].max);
	contour_lines = 0;
	color = 0;
        map_comp[] =;
    };

    ContourTexture ContourTexture {
	in_fld => <-.in_field;
	param => <-.ContourParam;
    };

    GMOD.instancer instancer {
	Value => UIpanel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => ContourdUI;
    };
    UImod_panel UIpanel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-);
	message = "Select contour_texture control panel.";
    };

    macro ContourdUI<instanced=0> {
	ilink in_fld => in_field;
	DV_Param_contour+IPort2 &param => ContourParam;

	DVnode_data_labels DVnode_data_labels {
	    in => in_fld;
	    int+nres  ncomp => in.nnode_data;
	};
	ilink UIpanel  => <-.UIpanel;

	UIradioBoxLabel UIradioBoxLabel {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    &selectedItem+IPort2 => param.contour_comp;
	    visible => <-.UIpanel.visible;
	    title = "contour component";
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
	UIslider nleveles {
	    parent => <-.UIpanel;
	    title = "number of contours";
	    min = 0;
	    mode = 1;
	    value+IPort2 => param.ncontours;
	    y		=> <-.UIradioBoxLabel.y + <-.UIradioBoxLabel.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIslider iso_level_min {
	    parent => <-.UIpanel;
	    title = "min level";
	    min+nres =>  cache(in_fld.node_data[param.contour_comp].min);
	    max+nres =>  cache(in_fld.node_data[param.contour_comp].max);
	    value+IPort2 => param.level_min;
	    y		=> <-.nleveles.y + <-.nleveles.height + 4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein iso_level_min_typein {
	    slider	=> iso_level_min;
        };
	UIslider iso_level_max {
	    parent => <-.UIpanel;
	    title = "max level";
	    min+nres =>  cache(in_fld.node_data[param.contour_comp].min);
	    max+nres =>  cache(in_fld.node_data[param.contour_comp].max);
	    value+IPort2 => param.level_max;
	    y		=> <-.iso_level_min.y + <-.iso_level_min.height + 4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein iso_level_max_typein {
	    slider	=> iso_level_max;
        };
    };

    DataObjects objs {
         in_fields => ContourTexture.out_flds;
	 dos.Obj.xform_mode = 1;
	 dos {
		Obj {
		 	xform_mode = GD_XFORM_MODE_PARENT;
			name+nres => name_of(<-.<-.<-.<-)+index_of(dos);
			texture_in => switch(index_of(dos)<array_size(in_imgs),in_imgs[index_of(dos)]);
		};
	 };
    };
    GroupObject obj {
		Top.name => name_of(<-.<-.<-);
		child_objs => objs.dos.obj;
    };

    omlink out_flds<export_all=2> => ContourTexture.out_flds;
    olink out_obj => obj.obj;
}; // contour_texture


macro contour {
    ilink in_field<export_all=1>;

    DV_Param_contour ContourParam<export_all=2> {
	contour_comp = 0;
	level_min+nres =>  cache(0.6*in_field.node_data[contour_comp].min+
	        0.4*in_field.node_data[contour_comp].max);
	level_max+nres =>  cache(0.4*in_field.node_data[contour_comp].min+
	        0.6*in_field.node_data[contour_comp].max);
	map_comp[] = {0};
    };
    DVcontour DVcontour {
	DV_Param_contour+IPort2 &param => ContourParam;
	in => in_field;
	&contour_comp => param.contour_comp;
	map_comp => param.map_comp;
	&level_min => param.level_min;
	&level_max => param.level_max;
    };

    GMOD.instancer instancer {
	Value => UIpanel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => ContourUI;
    };
    UImod_panel UIpanel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-);
	message = "Select contour control panel.";
    };

    macro ContourUI<instanced=0> {
	ilink in_fld => in_field;
	DV_Param_contour+IPort2 &param => ContourParam;

	DVnode_data_labels DVnode_data_labels {
	    in => in_fld;
	    int+nres  ncomp => in.nnode_data;
	};
	ilink UIpanel  => <-.UIpanel;

	UIradioBoxLabel UIradioBoxLabel {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    &selectedItem+IPort2 => param.contour_comp;
	    visible => <-.UIpanel.visible;
	    title = "contour component";
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
	UIoptionBoxLabel UIoptionBoxLabel {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    max => DVnode_data_labels.ncomp;
	    &selectedItems+IPort2 => param.map_comp;
	    title = "map components";
	    visible => <-.UIpanel.visible;
	    y		=> <-.UIradioBoxLabel.y + <-.UIradioBoxLabel.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIslider min_level {
	    parent => <-.UIpanel;
	    title = "min level";
	    min+nres =>  cache(in_fld.node_data[param.contour_comp].min);
	    max+nres =>  cache(in_fld.node_data[param.contour_comp].max);
	    value+IPort2 => param.level_min;
	    y		=> <-.UIoptionBoxLabel.y + <-.UIoptionBoxLabel.height+4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein min_level_typein {
	    slider	=> min_level;
        };
	UIslider max_level {
	    parent => <-.UIpanel;
	    title = "max level";
	    min+nres =>  cache(in_fld.node_data[param.contour_comp].min);
	    max+nres =>  cache(in_fld.node_data[param.contour_comp].max);
	    value+IPort2 => param.level_max;
	    y		=> <-.min_level.y + <-.min_level.height + 4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein max_level_typein {
	    slider	=> max_level;
        };
    };

    DataObjectNoTexture obj {
	in => DVcontour.out;
	Obj {
	    name => name_of(<-.<-.<-);
	    xform_mode = GD_XFORM_MODE_PARENT;
	    Modes.normals = 1;
	};
    };

    olink out_fld<export_all=2> => DVcontour.out;
    olink out_obj => obj.obj;
}; // contour


macro isovolume {
    ilink in_field<export_all=1>;

    DV_Param_iso_vol IsoVolParam<export_all=2> {
	iso_component = 0;
	iso_level+nres => cache((in_field.node_data[iso_component].min + 
	             in_field.node_data[iso_component].max) / 2);
	map_component[] = {0};
	above = 1;
	cell_data = {0};
    };

    int has_cell_data => (DVcell_data_labels.ncomp > 0);

    DVcut DVcut {
	DV_Param_iso_vol+IPort2 &param => IsoVolParam;
	in => in_field;
	&cut_comp => param.iso_component;
	map_comp => param.map_component;
	&level => param.iso_level;
	above => param.above;
	cell_data => switch(<-.has_cell_data, param.cell_data);
    };
    GMOD.instancer instancer {
	Value => UIpanel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => IsoVolUI;
    };
    UImod_panel UIpanel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-);
	message = "Select Iso-Volume control panel.";
    };
    DVnode_data_labels DVnode_data_labels {
	    in => in_field;
	    int+nres  ncomp => in.nnode_data;
    };
    DVcell_data_labels DVcell_data_labels {
	    in => in_field;
    };

    macro IsoVolUI<instanced=0> {
	ilink in_fld => in_field;
	DV_Param_iso_vol+IPort2 &param => IsoVolParam;

	ilink UIpanel  => <-.UIpanel;
	ilink DVnode_data_labels => <-.DVnode_data_labels;
	ilink DVcell_data_labels => <-.DVcell_data_labels;
	UItoggle above_toggle {
	    parent => <-.UIpanel;
	    label = "Above";
	    &set+IPort2 => param.above;
	    y		= 0;
	    width	=> <-.UIpanel.width;
	};

	UIradioBoxLabel UIradioBoxLabel {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    &selectedItem+IPort2 => param.iso_component;
	    visible => <-.UIpanel.visible;
	    title = "iso component";
	    y		=> <-.above_toggle.y + <-.above_toggle.height + 4;
	    width	=> <-.UIpanel.width;
	};

	UIslider cut_level {
	    parent => <-.UIpanel;
	    title = "iso level";
	    min+nres => cache(in_fld.node_data[param.iso_component].min);
	    max+nres => cache(in_fld.node_data[param.iso_component].max);
	    value+IPort2 => param.iso_level;
	    y		=> <-.UIradioBoxLabel.y + <-.UIradioBoxLabel.height + 4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein cut_level_typein {
	    slider	=> cut_level;
        };
	UIoptionBoxLabel UIoptionBoxLabel {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    max => DVnode_data_labels.ncomp;
	    &selectedItems+IPort2 => param.map_component;
	    title = "map components";
	    visible => <-.UIpanel.visible;
	    y		=> <-.cut_level.y + <-.cut_level.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIoptionBoxLabel UIoptionBoxLabel_cell {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVcell_data_labels.labels;
	    max => DVcell_data_labels.ncomp;
	    &selectedItems+IPort2 => param.cell_data;
	    title = "map cell components";
	    visible => <-.UIpanel.visible & (DVcell_data_labels.ncomp > 0);
	    y		=> <-.UIoptionBoxLabel.y + <-.UIoptionBoxLabel.height + 4;
	    width	=> <-.UIpanel.width;
	};
    };

    DataObjectNoTexture obj {
	in => DVcut.out;
	Obj {
	    name => name_of(<-.<-.<-);
	    xform_mode = GD_XFORM_MODE_PARENT;
	    Modes.normals = 1;
	};
    };

    olink out_fld<export_all=2> => DVcut.out;
    olink out_obj => obj.obj;
}; // isovolume

macro plane_crop {
    ilink in_field<export_all=1>;
    imlink in_plane<export_all=1>;

    DV_Param_plane_crop PlaneCropParam<export_all=2> {
	in_out = 1;
	and_or = 0;
    };

    DVplane_crop DVplane_crop {
	in => in_field;
	plane => in_plane;
	DV_Param_plane_crop+IPort2 &param => PlaneCropParam;
	&in_out => param.in_out;
	&and_or => param.and_or;
    };
    macro PlaneCropUI {
	ilink in_fld => in_field;
	DV_Param_plane_crop+IPort2 &param => PlaneCropParam;

	UImod_panel UIpanel {
	    parent<NEportLevels={4,0}>;
	    title => name_of(<-.<-.<-);
	    message = "Select Plane Crop control panel.";
	};
	UItoggle in_out_toggle {
	    parent => <-.UIpanel;
	    label = "Crop Inside planes";
	    &set+IPort2 => param.in_out;
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
	UIradioBoxLabel UIradioBoxLabel {
	    parent => <-.UIpanel;
	    labels+IPort2 => {"and","or"};
	    &selectedItem+IPort2 => param.and_or;
	    visible => <-.UIpanel.visible;
	    title = "crop region for multiple planes";
	    y		=> <-.in_out_toggle.y + <-.in_out_toggle.height + 4;
	    width	=> <-.UIpanel.width;
	};

    };
    DataObjectNoTexture obj {
	in => DVplane_crop.out;
	Obj {
	    name => name_of(<-.<-.<-);
	    xform_mode = GD_XFORM_MODE_PARENT;
	};
    };

    olink out_fld<export_all=2> => DVplane_crop.out;
    olink out_obj => obj.obj;
}; // plane_crop

macro crop_box {
    ilink in_field<export_all=1>;

    DV_Param_crop_box CropParam<export_all=2> {
	inside = 1;
	xform_together = 1;
    };

    GEOMS.FBox_Planes FBox_Planes {
	in => <-.in_field;
	DV_Param_crop_box &param => <-.CropParam;
	box_ui<instanced=0>;
	xform_together => param.xform_together;
    };

    DVplane_crop DVplane_crop {
	in => <-.in_field;
	plane => <-.FBox_Planes.out_fld;
	DV_Param_crop_box+IPort2 &param => <-.CropParam;
	&in_out => param.inside^1;
	&and_or => param.inside;
    };
    macro CropUI {
	ilink in_fld => in_field;
	DV_Param_crop_box+IPort2 &param => <-.CropParam;

	UImod_panel UIpanel {
	    parent<NEportLevels={4,0}>;
	    title => name_of(<-.<-.<-);
	    message = "Select Crop Box control panel.";
	};
	UItoggle inside_toggle {
	    parent => <-.UIpanel;
	    label = "Crop outside box";
	    &set+IPort2 => param.inside;
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
	UItoggle together_toggle {
    		parent => <-.UIpanel;
    		label = "Transform planes together";
    		y	=>  <-.inside_toggle.y + <-.inside_toggle.height+8;
    		width	=> <-.UIpanel.width;
		set => <-.param.xform_together;
	};
	UItoggle xform_toggle {
    		parent => <-.UIpanel;
    		label = "Box Transformation Editor";
    		y	=>  <-.together_toggle.y + <-.together_toggle.height+8;
    		width	=> <-.UIpanel.width;
	};
	XformEditor probe_edit {
		obj_in => <-.<-.FBox_Planes.group_xform;
		vis => xform_toggle.set;
	};
    };
    DataObjectNoTexture obj {
	in => DVplane_crop.out;
	Obj {
	    name => name_of(<-.<-.<-);
	    xform_mode = GD_XFORM_MODE_PARENT;
	    Modes.normals = 1;
	};
    };

    olink out_fld<export_all=2> => DVplane_crop.out;
    mlink out_box<NEportLevels={1,2}> => FBox_Planes.out_fld;
    olink out_obj_crop => obj.obj;
    olink out_obj_box => FBox_Planes.out_obj;
}; // crop_box


//
// A crop for 3D fields (including unstructured) thats easier to use
// than crop_box.  The UI is more like the UI of standard crop which
// only works on structured fields.  You lose the ability to control
// the Xform of each of the six cropping planes, but most of the time
// that level of control is overkill and leads to usability problems.
//
// Currently does not handle 2D fields.
//
macro crop_orthobox {
    ilink in_field<export_all=1>;

    DV_Param_crop_box CropParam<export_all=2> {

        int+Port2+nres nspace => <-.in_field.nspace;

        float+Port2+nres min[3] => <-.in_field.coordinates.min_vec * 1.01;
        float+Port2+nres max[3] => <-.in_field.coordinates.max_vec * 1.01;

        float+Port2+nres min[.nspace] => <-.in_field.coordinates.min_vec * 1.01;
        float+Port2+nres max[.nspace] => <-.in_field.coordinates.max_vec * 1.01;

        inside = 1;
    };

    //
    // (Re)Initialize the min/max parameters whenever the in_field changes.
    //
    GMOD.copy_on_change coc_min {
        float+nres &input[]  => <-.in_field.coordinates.min_vec * 1.01;
        &output[] => <-.CropParam.min;
        // Don't override the values saved in V files.  The default
        // conns for min/max should be OK for when the macro is instanced.
        on_inst = 0;
    };
    GMOD.copy_on_change coc_max {
        float+nres &input[]  => <-.in_field.coordinates.max_vec * 1.01;
        &output[] => <-.CropParam.max;
        // Don't override the values saved in V files.
        on_inst = 0;
    };

    // Not really necessary, but this is nicer than wrestling with
    // the six different planes and six different DataObjects.
    Box_Mesh+OPort box {
        dims = { 2, 2, 2 };
        ilink param => <-.CropParam;
        points => {
            param.min[0], param.min[1], param.min[2],
            param.max[0], param.max[1], param.max[2] };
        &xform+nres => <-.in_field.xform;
    };

    DataObjectLite boxObj {
        in => <-.box;
        Obj.name = "crop_box";
        Modes {
            // Render the box as a wireframe
            mode = {0, GD_LINES, GD_NO_SURF, 0, 0};
        };
    };

    // Use a lighter version without a UI.
    GEOMS.FBox_Planes_Lite FBox_Planes<NEvisible=1> {

        DV_Param_crop_box &param => <-.CropParam;

        // This is all that FBox_Planes needs.
        group fake_field {
            group coordinates {
                float min_vec[] => param.min;
                float max_vec[] => param.max;
            };
        };

        in => .fake_field;
    };

    //
    // Long term plan is to make a DVbox_crop that crops using
    // a 3D box field.  Its inefficient to have to construct up
    // six different plane fields.
    //
    DVplane_crop DVplane_crop {
        in => <-.in_field;
        // This is an *array* of 6 2D planes, not a 3D box field
        plane =>  <-.FBox_Planes.out_fld;
        DV_Param_crop_box+IPort2 &param => <-.CropParam;
        &in_out => param.inside^1;
        &and_or => param.inside;
    };

    GMOD.instancer instancer {
        Value => panel.visible;
        active = 2; // don't de-instance when visible = 0
        Group => CropUI ;
    };
    UImod_panel panel {
        parent<NEportLevels={3,0}>;
        title => name_of(<-.<-);
        message = "Select crop unstruct control panel.";
    };

    macro CropUI<instanced=0> {
        ilink in_fld => in_field;
        DV_Param_crop+IPort2 &param => CropParam;

        ilink panel  => <-.panel;

        // X sliders
        UIslider min0_slider {
            parent => <-.panel;
            title = "X min";
            min+nres => in_fld.coordinates.min_vec[0] * 1.01;
            max+nres => in_fld.coordinates.max_vec[0];
            value+nres+IPort2 => param.min[0];
            y = 0;
            width => <-.panel.width * 11 / 12;
            visible+nres => panel.visible & (in_fld.nspace > 0);
        };
        //
        // Its really a waste to have SIX of these suckers when
        // you'll never need to be using more than one at a time.
        //
        // However, for this type of application its important that
        // the user be able to edit the decimal places setting.
        //
        VUIslider_typein min0_slider_typein {
            slider => min0_slider;
            visible+nres => .slider.visible;
        };
        min0_slider max0_slider {
            title = "X max";
            min+nres => in_fld.coordinates.min_vec[0];
            max+nres => in_fld.coordinates.max_vec[0] * 1.01;
            value+nres+IPort2 => param.max[0];
            y => <-.min0_slider.y + <-.min0_slider.height + 4;
        };
        VUIslider_typein max0_slider_typein {
            slider => max0_slider;
            visible+nres => .slider.visible;
        };

        // Y sliders
        min0_slider min1_slider {
            title = "Y min";
            min+nres => in_fld.coordinates.min_vec[1] * 1.01;
            max+nres => in_fld.coordinates.max_vec[1];
            value+nres+IPort2 => param.min[1];
            y => <-.max0_slider.y + <-.max0_slider.height + 4;
            visible+nres => panel.visible & (in_fld.nspace > 1);
        };
        VUIslider_typein min1_slider_typein {
            slider => min1_slider;
            visible+nres => .slider.visible;
        };
        min1_slider max1_slider {
            title = "Y max";
            min+nres => in_fld.coordinates.min_vec[1];
            max+nres => in_fld.coordinates.max_vec[1] * 1.01;
            value+nres+IPort2 => param.max[1];
            y => <-.min1_slider.y + <-.min1_slider.height + 4;
        };
        VUIslider_typein max1_slider_typein {
            slider => max1_slider;
            visible+nres => .slider.visible;
        };

        // Z sliders
        min0_slider min2_slider {
            title = "Z min";
            min+nres => in_fld.coordinates.min_vec[2] * 1.01;
            max+nres => in_fld.coordinates.max_vec[2];
            value+nres+IPort2 => param.min[2];
            y => <-.max1_slider.y + <-.max1_slider.height + 4;
            visible+nres => panel.visible & (in_fld.nspace > 2);
        };
        VUIslider_typein min2_slider_typein {
            slider => min2_slider;
            visible+nres => .slider.visible;
        };
        min2_slider max2_slider {
            title = "Z max";
            min+nres => in_fld.coordinates.min_vec[2];
            max+nres => in_fld.coordinates.max_vec[2] * 1.01;
            value+nres+IPort2 => param.max[2];
            y => <-.min2_slider.y + <-.min2_slider.height + 4;
        };
        VUIslider_typein max2_slider_typein {
            slider => max2_slider;
            visible+nres => .slider.visible;
        };
    };

    DataObjectNoTexture obj {
        in => DVplane_crop.out;
        Obj {
            name => name_of(<-.<-.<-);
        };
    };

    olink out_fld<export_all=2> => DVplane_crop.out;
    olink out_obj => obj.obj;
    olink box_obj => .boxObj.obj;
}; // crop_orthobox

//
// slice uses an external slicing plane. 
// slice_plane, below, has an integrated slicing place.
//
macro slice {
    ilink in_field<export_all=1>;
    ilink in_plane<export_all=1>;

    DV_Param_slice+Port SliceParam<export_all=2> {
	component = {0};
	dist = 0.0;
	cell_data = {0};
    };

    int has_cell_data => (DVcell_data_labels.ncomp > 0);

    DVslice  DVslice {
	DV_Param_slice+IPort2 &param => SliceParam;
	in => in_field;
	plane => in_plane;
	dist => param.dist;
	map_comp => param.component;
	cell_data => switch(<-.has_cell_data, param.cell_data);
    };
    DVnode_data_labels DVnode_data_labels {
	    in => in_field;
	    int+nres  ncomp => in.nnode_data;
    };
    DVcell_data_labels DVcell_data_labels {
	    in => in_field;
    };

    UImod_panel UIpanel {
	    parent<NEportLevels={3,0}>;
	    title => name_of(<-.<-);
	    message = "Select Slice control panel.";
    };
    GMOD.instancer instancer {
	Value => UIpanel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => SliceUI;
    };

    macro SliceUI<instanced=0> {
	ilink in_fld => in_field;
	DV_Param_slice+IPort2 &param => SliceParam;

	ilink DVnode_data_labels => <-.DVnode_data_labels;
	ilink DVcell_data_labels => <-.DVcell_data_labels;
	ilink UIpanel => <-.UIpanel;

	UIslider plane_dist {
	    parent => <-.UIpanel;
	    title = "plane distance";
	    min+nres+IPort2 => cache(-0.5*(magnitude(in_fld.coordinates.max_vec-
	                      in_fld.coordinates.min_vec)));
	    max+nres+IPort2 => cache( 0.5*(magnitude(in_fld.coordinates.max_vec-
	                      in_fld.coordinates.min_vec)));
	    value+IPort2 => param.dist;
	    y		= 0;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein plane_dist_typein {
	    slider	=> plane_dist;
        };
	UIoptionBoxLabel  UIoptionBoxLabel {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    max => DVnode_data_labels.ncomp;
	    &selectedItems+IPort2 => param.component;
	    title = "map components";
	    visible => <-.UIpanel.visible;
	    y		=> <-.plane_dist.y + <-.plane_dist.height+4;
	    width	=> <-.UIpanel.width;
	};
	UIoptionBoxLabel  UIoptionBoxLabel_cell {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVcell_data_labels.labels;
	    max => DVcell_data_labels.ncomp;
	    &selectedItems+IPort2 => param.cell_data;
	    title = "map cell components";
	    visible => <-.UIpanel.visible & (DVcell_data_labels.ncomp > 0);
	    y		=> <-.UIoptionBoxLabel.y + <-.UIoptionBoxLabel.height + 4;
	    width	=> <-.UIpanel.width;
	};
    };

    DataObjectNoTexture obj {
	in => DVslice.out;
	Obj {
	    name => name_of(<-.<-.<-);
	    xform_mode = GD_XFORM_MODE_ALT;
	    alt_xform+nres => <-.<-.in_plane.xform;
	};
    };

    olink out_fld<export_all=2> => DVslice.out;
    olink out_obj => obj.obj;
}; // slice

macro slice_plane {
    ilink in_field<export_all=1>;

    DV_Param_slice+Port SliceParam<export_all=2> {
	component = {0};
	dist = 0.0;
	cell_data = {0};
    };

    int has_cell_data => (DVcell_data_labels.ncomp > 0);

    float+nres xlate[3]=>{0.0, 0.0,
	    (in_field.coordinates.min_vec[2]+in_field.coordinates.max_vec[2])/2};
    Plane_Mesh   plane {
	xform {
	    xlate+nres=>cache(<-.<-.xlate);
	};
	dims => {2, 2};
	points+nres => {in_field.coordinates.min_vec[0], in_field.coordinates.min_vec[1], 
	      in_field.coordinates.max_vec[0], in_field.coordinates.max_vec[1]};
    };

    DVslice  DVslice {
	DV_Param_slice+IPort2 &param => SliceParam;
	in => in_field;
	plane => <-.plane;
	dist => param.dist;
	map_comp => param.component;
	cell_data => switch(<-.has_cell_data, param.cell_data);
    };
    DVnode_data_labels DVnode_data_labels {
	    in => in_field;
	    int+nres  ncomp => in.nnode_data;
    };
    DVcell_data_labels DVcell_data_labels {
	    in => in_field;
    };

    GMOD.instancer instancer {
	Value => UIpanel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => SliceUI;
    };
    UImod_panel UIpanel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-);
	message = "Select slice plane control panel.";
    };

    macro SliceUI<instanced=0> {
	ilink in_fld => in_field;
	DV_Param_slice+IPort2 &param => SliceParam;

	ilink DVnode_data_labels => <-.DVnode_data_labels;
	ilink DVcell_data_labels => <-.DVcell_data_labels;
	ilink UIpanel  => <-.UIpanel;

	UItoggle xform_toggle {
	    parent => <-.UIpanel;
	    label = "Plane Transform Editor";
	    y		= 0;
	    width	=> <-.UIpanel.width;
	};
	UIslider plane_dist {
	    parent => <-.UIpanel;
	    title = "plane distance";
	    min+nres+IPort2 => cache(-0.5*(magnitude(in_fld.coordinates.max_vec-
	                      in_fld.coordinates.min_vec)));
	    max+nres+IPort2 => cache( 0.5*(magnitude(in_fld.coordinates.max_vec-
	                      in_fld.coordinates.min_vec)));
	    value+IPort2 => param.dist;
	    y		=> <-.xform_toggle.y + <-.xform_toggle.height+4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein plane_dist_typein {
	    slider	=> plane_dist;
        };
	UIoptionBoxLabel UIoptionBoxLabel {
	        parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    max => DVnode_data_labels.ncomp;
	    &selectedItems+IPort2 => param.component;
	    title = "map components";
	    visible => <-.UIpanel.visible;
	    y		=> <-.plane_dist.y + <-.plane_dist.height+4;
	    width	=> <-.UIpanel.width;
	};
	UIoptionBoxLabel UIoptionBoxLabel_cell {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVcell_data_labels.labels;
	    max => DVcell_data_labels.ncomp;
	    &selectedItems+IPort2 => param.cell_data;
	    title = "map cell components";
	    visible => <-.UIpanel.visible & (DVcell_data_labels.ncomp > 0);
	    y		=> <-.UIoptionBoxLabel.y + <-.UIoptionBoxLabel.height + 4;
	    width	=> <-.UIpanel.width;
	};
	XformEditor plane_xform {
	    obj_in => <-.<-.plane;
	    vis => xform_toggle.set;
	};
    };

    DataObject slice_obj {
	in => DVslice.out;
	Obj {
	    name => name_of(<-.<-.<-);
	    xform_mode = GD_XFORM_MODE_ALT;
	    alt_xform+nres => <-.<-.plane.xform;
	};
    };

    DataObject plane_obj {
	in => <-.plane;
    };

    olink out_fld<export_all=2> => DVslice.out;
    olink out_plane<export_all=2> => plane;
    olink out_obj_slice => slice_obj.obj;
    olink out_obj_plane => plane_obj.obj;
}; // slice_plane

//
// Like slice_plane, but with a simpler interface that is
// more like orthoslice.  Another way to look at it is that
// it is like orthoslice that works on any 3D field (orthoslice
// is structured only) and is driven by the coordinates,
// instead of dimensions and axes.
//
macro slice_orthoplane {
    ilink in_field<export_all=1>;

    int dim1<export=2> = 2;
    int dim2<export=2> = 2;
    int dim3<export=2> = 2;

    DV_Param_slice_ortho SliceParam<export_all=2> {
        // Orthoslice parameters
        axis = 0;
        plane+nres => (in_field.coordinates.min_vec[axis] + 
                       in_field.coordinates.max_vec[axis]) / 2.0;
        // Slice parameters
        component = { 0 };
        cell_data = { 0 };
    };

    int has_cell_data => (DVcell_data_labels.ncomp > 0);

    Plane_Mesh plane_xy {
        xform {
            xlate+nres => cache({0.0, 0.0, SliceParam.plane});
        };
        dims => {dim1, dim2};
        points+nres => {in_field.coordinates.min_vec[0],
                        in_field.coordinates.min_vec[1], 
                        in_field.coordinates.max_vec[0],
                        in_field.coordinates.max_vec[1]};
    };
    Plane_Mesh plane_yz {
        xform {
            mat = {{0,0,1,0},
                   {0,1,0,0},
                   {-1,0,0,0},
                   {0,0,0,1}};
            xlate+nres => cache({SliceParam.plane, 0.0, 0.0});
        };
        dims => {dim3, dim2};
        points+nres => {in_field.coordinates.min_vec[2],
                        in_field.coordinates.min_vec[1], 
                        in_field.coordinates.max_vec[2],
                        in_field.coordinates.max_vec[1]};
    };
    Plane_Mesh plane_xz {
        xform {
            mat = {{1,0,0,0},
                   {0,0,1,0},
                   {0,-1,0,0},
                   {0,0,0,1}};
            xlate+nres => cache({0.0, SliceParam.plane, 0.0});
        };
        dims => {dim1, dim3};
        points+nres => {in_field.coordinates.min_vec[0],
                        in_field.coordinates.min_vec[2], 
                        in_field.coordinates.max_vec[0],
                        in_field.coordinates.max_vec[2]};
    };

    Plane_Mesh planes[] => { plane_yz, plane_xz, plane_xy };
    Plane_Mesh &plane => planes[SliceParam.axis];

    DVslice DVslice {
        DV_Param_slice_ortho+IPort2 &param => SliceParam;
        in => in_field;
        plane => <-.plane;
        dist = 0;
        map_comp => param.component;
        cell_data => switch(<-.has_cell_data, param.cell_data);
    };
    DVnode_data_labels DVnode_data_labels {
        in => in_field;
        int+nres  ncomp => in.nnode_data;
    };
    DVcell_data_labels DVcell_data_labels {
        in => in_field;
    };

    macro SliceUI {
        ilink in_fld => in_field;
        DV_Param_slice_ortho+IPort2 &param => SliceParam;

        UImod_panel UIpanel {
            parent<NEportLevels={4,0}>;
            title => name_of(<-.<-.<-);
            message = "Select slice control panel.";
        };

        UIslider axis_slider {
            parent => <-.UIpanel;
            title = "axis";
            max+nres+IPort2 => in_fld.nspace-1;
            value+IPort2 => param.axis;
            mode = "integer";
            y		=  0;
            width	=> <-.UIpanel.width;
        };
        UIslider plane_slider {
            parent => <-.UIpanel;
            title = "plane";
            min+nres+IPort2 => in_fld.coordinates.min_vec[param.axis];
            max+nres+IPort2 => in_fld.coordinates.max_vec[param.axis];
            value+IPort2 => param.plane;
            mode = "real";
            y        	=> <-.axis_slider.y + <-.axis_slider.height + 4;
            width        => <-.UIpanel.width;
        };

        // Simplify and do all data components by default ?

        UIoptionBoxLabel  UIoptionBoxLabel {
            parent => <-.UIpanel;
            labels+IPort2 => DVnode_data_labels.labels;
            max => DVnode_data_labels.ncomp;
            &selectedItems+IPort2 => param.component;
            title = "map components";
            visible => <-.UIpanel.visible;
            y		=> <-.plane_slider.y + <-.plane_slider.height+4;
            width	=> <-.UIpanel.width;
        };
        UIoptionBoxLabel  UIoptionBoxLabel_cell {
            parent => <-.UIpanel;
            labels+IPort2 => DVcell_data_labels.labels;
            max => DVcell_data_labels.ncomp;
            &selectedItems+IPort2 => param.cell_data;
            title = "map cell components";
            visible => <-.UIpanel.visible & (DVcell_data_labels.ncomp > 0);
            y		=> <-.UIoptionBoxLabel.y + <-.UIoptionBoxLabel.height + 4;
            width	=> <-.UIpanel.width;
        };

    };

    DataObjectNoTexture obj {
        in => DVslice.out;
        Obj {
            name => name_of(<-.<-.<-);
            xform_mode = GD_XFORM_MODE_PARENT;
        };
    };

    olink out_fld<export_all=2> => DVslice.out;
    olink out_obj => obj.obj;

}; // slice_orthoplane

macro adjust_slice_spacing {
    Mesh_Unif+Node_Data &in_fld<NEportLevels={2,1}>;
    float &slice_position<NEportLevels={2,1}>[];

    int+IPort spacing_axis = 2;

    DVadjust_slice_spacing adjust_slice_spacing {
        in => <-.in_fld;
        spacing_axis => <-.spacing_axis;
        slice_position => <-.slice_position;
    };

    DataObjectNoTexture obj {
        in => adjust_slice_spacing.out;
	Obj {
	    name => name_of(<-.<-.<-);
	};
    };

    Mesh+Node_Data+OPort2 &out_fld => merge(adjust_slice_spacing.out, in_fld);
    olink out_obj                  => obj.obj;
}; // adjust_slice_spacing


macro streamlines {
    ilink in_field<export_all=1>;
    ilink in_probe<export_all=1>;

    DV_Param_stream StreamParam<export_all=2> {
	component = 0;
	order = 2;
	forw_back = 1;
	nseg = 2;
	max_seg = 256;
	min_vel = 0.00001;
	ribbons = 0;
	rib_width = 1;
	rib_angle = 0;
	color = 1;
    };

    DVstream DVstream {
	DV_Param_stream+IPort2 &param => StreamParam;
	in => in_field;
	probe => in_probe;
	&stream_comp => param.component;
	&order => param.order;
	&forw_back => param.forw_back;
	&nseg => param.nseg;
	&max_seg => param.max_seg;
	&min_vel => param.min_vel;
	&ribbons => param.ribbons;
	&rib_width => param.rib_width;
	&rib_angle => param.rib_angle;
    };
    DVmagnitude DVmagnitude {
	in => DVstream.out;
	component = 0;
    };
    GMOD.instancer instancer {
	Value => UIpanel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => StreamUI;
    };
    UImod_panel UIpanel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-);
	message = "Select streamline control panel.";
    };

    macro StreamUI<instanced=0> {
	ilink in_fld => in_field;
	DV_Param_stream+IPort2 &param => StreamParam;

	DVnode_data_labels DVnode_data_labels {
	    in => in_fld;
	    int+nres  ncomp => in.nnode_data;
	};
	ilink UIpanel  => <-.UIpanel;

	UIradioBoxLabel UIradioBoxLabel {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    &selectedItem+IPort2 => param.component;
	    visible => <-.UIpanel.visible;
	    title = "velocity vector";
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
	UIradioBoxLabel UIradioBoxLabel_dir {
	    parent => <-.UIpanel;
	    labels+IPort2 => {"backward","forward"};
	    &selectedItem+IPort2 => param.forw_back;
	    visible => <-.UIpanel.visible;
	    title = "Direction";
	    y		=> <-.UIradioBoxLabel.y + <-.UIradioBoxLabel.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIslider nseg_slider {
	    parent => <-.UIpanel;
	    title = "nsegments";
	    max = 16;
	    value+IPort2 => param.nseg;
	    mode = 1;
	    y		=> <-.UIradioBoxLabel_dir.y + <-.UIradioBoxLabel_dir.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIslider max_seg_slider {
	    parent => <-.UIpanel;
	    title = "max segments";
	    min = 1;
	    max = 10000;
	    value+IPort2 => param.max_seg;
	    mode = 1;
	    y		=> <-.nseg_slider.y + <-.nseg_slider.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIslider order_slider {
	    parent => <-.UIpanel;
	    title = "order";
	    min = 1;
	    max = 4;
	    value+IPort2 => param.order;
	    mode = 1;
	    y		=> <-.max_seg_slider.y + <-.max_seg_slider.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIslider vel_slider {
	    parent => <-.UIpanel;
	    title = "min_velocity";
	    value+IPort2 => param.min_vel;
	    y		=> <-.order_slider.y + <-.order_slider.height + 4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein vel_slider_typein {
	    slider	=> vel_slider;
        };
	UItoggle color_toggle {
	    parent => <-.UIpanel;
	    label = "Color";
	    &set+IPort2 => param.color;
	    y		=> <-.vel_slider.y + <-.vel_slider.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UItoggle ribbon_toggle {
	    parent => <-.UIpanel;
	    label = "Ribbons";
	    &set+IPort2 => param.ribbons;
	    y		=> <-.color_toggle.y + <-.color_toggle.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIslider ribbon_width_slider {
	    parent => <-.UIpanel;
	    title = "ribbon width";
	    value+IPort2 => param.rib_width;
	    y		=> <-.ribbon_toggle.y + <-.ribbon_toggle.height + 4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein ribbon_width_slider_typein {
	    slider	=> ribbon_width_slider;
        };
	UIslider ribbon_angle_slider {
	    parent => <-.UIpanel;
	    title = "ribbon angle";
	    min = 0.0;
	    max = 360.0;
	    value+IPort2 => param.rib_angle;
	    y		=> <-.ribbon_width_slider.y + <-.ribbon_width_slider.height + 4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein ribbon_angle_slider_typein {
	    slider	=> ribbon_angle_slider;
        };
    };
    DVswitch DVswitch {
	in => {DVstream.out,  DVmagnitude.out};
	index => StreamParam.color;
    };


    DataObjectNoTexture obj {
	in => DVswitch.out;
	Obj {
	    name => name_of(<-.<-.<-);
	    xform_mode = GD_XFORM_MODE_ALT;
	    alt_xform+nres => <-.<-.in_probe.xform;
	};
    };

    olink out_fld<export_all=2> => DVswitch.out;
    olink out_obj => obj.obj;
}; // streamlines

macro stream_multi_block {
    ilink in_field<export_all=1>;
    ilink in_probe<export_all=1>;

    DV_Param_stream StreamParam<export_all=2> {
	component = 0;
	order = 2;
	forw_back = 1;
	nseg = 2;
	max_seg = 256;
	min_vel = 0.00001;
	ribbons = 0;
	rib_width = 1;
	rib_angle = 0;
	color = 1;
    };

    DVstream_multi_block DVstream {
	DV_Param_stream+IPort2 &param => StreamParam;
	in => in_field;
	probe => in_probe;
	&stream_comp => param.component;
	&order => param.order;
	&forw_back => param.forw_back;
	&nseg => param.nseg;
	&max_seg => param.max_seg;
	&min_vel => param.min_vel;
	&ribbons => param.ribbons;
	&rib_width => param.rib_width;
	&rib_angle => param.rib_angle;
    };
    DVmagnitude DVmagnitude {
	in => DVstream.out;
	component = 0;
    };
    GMOD.instancer instancer {
	Value => UIpanel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => StreamUI;
    };
    UImod_panel UIpanel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-);
	message = "Select Streamlines multiblock control panel.";
    };

    macro StreamUI<instanced=0> {
	ilink in_fld => in_field;
	DV_Param_stream+IPort2 &param => StreamParam;

	DVnode_data_labels DVnode_data_labels {
	    in => in_fld;
	    int+nres  ncomp => in.nnode_data;
	};
	ilink UIpanel  => <-.UIpanel;

	UIradioBoxLabel UIradioBoxLabel {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    &selectedItem+IPort2 => param.component;
	    visible => <-.UIpanel.visible;
	    title = "velocity vector";
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
	UIradioBoxLabel UIradioBoxLabel_dir {
	    parent => <-.UIpanel;
	    labels+IPort2 => {"backward","forward"};
	    &selectedItem+IPort2 => param.forw_back;
	    visible => <-.UIpanel.visible;
	    title = "Direction";
	    y		=> <-.UIradioBoxLabel.y + <-.UIradioBoxLabel.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIslider nseg_slider {
	    parent => <-.UIpanel;
	    title = "nsegments";
	    max = 16;
	    value+IPort2 => param.nseg;
	    mode = 1;
	    y		=> <-.UIradioBoxLabel_dir.y + <-.UIradioBoxLabel_dir.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIslider max_seg_slider {
	    parent => <-.UIpanel;
	    title = "max segments";
	    min = 1;
	    max = 10000;
	    value+IPort2 => param.max_seg;
	    mode = 1;
	    y		=> <-.nseg_slider.y + <-.nseg_slider.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIslider order_slider {
	    parent => <-.UIpanel;
	    title = "order";
	    min = 1;
	    max = 4;
	    value+IPort2 => param.order;
	    mode = 1;
	    y		=> <-.max_seg_slider.y + <-.max_seg_slider.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIslider vel_slider {
	    parent => <-.UIpanel;
	    title = "min_velocity";
	    value+IPort2 => param.min_vel;
	    y		=> <-.order_slider.y + <-.order_slider.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UItoggle color_toggle {
	    parent => <-.UIpanel;
	    label = "Color";
	    &set+IPort2 => param.color;
	    y		=> <-.vel_slider.y + <-.vel_slider.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UItoggle ribbon_toggle {
	    parent => <-.UIpanel;
	    label = "Ribbons";
	    &set+IPort2 => param.ribbons;
	    y		=> <-.color_toggle.y + <-.color_toggle.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIslider ribbon_width_slider {
	    parent => <-.UIpanel;
	    title = "ribbon width";
	    value+IPort2 => param.rib_width;
	    y		=> <-.ribbon_toggle.y + <-.ribbon_toggle.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIslider ribbon_angle_slider {
	    parent => <-.UIpanel;
	    title = "ribbon angle";
	    min = 0.0;
	    max = 360.0;
	    value+IPort2 => param.rib_angle;
	    y		=> <-.ribbon_width_slider.y + <-.ribbon_width_slider.height + 4;
	    width	=> <-.UIpanel.width;
	};
    };
    DVswitch DVswitch {
	in => {DVstream.out,  DVmagnitude.out};
	index => StreamParam.color;
    };


    DataObjectNoTexture obj {
	in => DVswitch.out;
	Obj {
	    xform_mode = GD_XFORM_MODE_ALT;
	    alt_xform+nres => <-.<-.in_probe.xform;
	};
    };

    olink out_fld<export_all=2> => DVswitch.out;
    olink out_obj => obj.obj;
}; // stream_multi_block

macro advector {
    ilink in_field<export_all=1>;
    ilink in_probe<export_all=1>;
    ilink in_glyph<export_all=1>;

    DV_Param_advect+Port  AdvectParam<export_all=2> {
	 component = 0;
	 order = 2;
	 forw_back = 1;
	 nseg = 2;
	 max_seg = 256;
	 min_vel = 0.00001;
	 run = 0;
	 reset = 0;
	 cycle = 0;
	 start = 0.0;
	 end = 1.0;
	 incr = 0.2;
	 vector = 1;
	 scale = 1.0;
	 normalize = 0;
	 release_interval = 0.0;
    };

    Advect Advect {
	in_fld => in_field;
	in_prb => in_probe;
	in_glp => in_glyph;
	param => AdvectParam;
    };
    GMOD.instancer instancer {
	Value => UIpanel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => AdvectUI;
    };
    UImod_panel UIpanel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-);
	message = "Select advector control panel.";
    };

    macro AdvectUI<instanced=0> {
	ilink in_fld => in_field;
	DV_Param_advect+IPort2 &param => AdvectParam;
	ilink UIpanel  => <-.UIpanel;

	UIslider nseg_slider {
	    parent => <-.UIpanel;
	    title = "N-segments";
	    max = 16;
	    value+IPort2 => param.nseg;
	    mode = 1;
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
	UIslider max_seg_slider {
	    parent => <-.UIpanel;
	    title = "Max Segments";
	    min = 1;
	    max = 10000;
	    value+IPort2 => param.max_seg;
	    mode = 1;
	    y		=> <-.nseg_slider.y + <-.nseg_slider.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIslider order_slider {
	    parent => <-.UIpanel;
	    title = "Order";
	    min = 1;
	    max = 4;
	    value+IPort2 => param.order;
	    mode = 1;
	    y		=> <-.max_seg_slider.y + <-.max_seg_slider.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIslider vel_slider {
	    parent => <-.UIpanel;
	    title = "Min Velocity";
	    value+IPort2 => param.min_vel;
	    y		=> <-.order_slider.y + <-.order_slider.height + 4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein vel_slider_typein {
	    slider	=> vel_slider;
        };
	UIradioBoxLabel UIradioBoxLabel_dir {
	    parent => <-.UIpanel;
	    labels+IPort2 => {"backward","forward"};
	    &selectedItem+IPort2 => param.forw_back;
	    visible => <-.UIpanel.visible;
	    title = "Direction";
	    y		=> <-.vel_slider.y + <-.vel_slider.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIradioBoxLabel UIradioBoxLabel_mode {
	    parent => <-.UIpanel;
	    labels+IPort2 => {"scalar", "vector", "components"};
	    &selectedItem+IPort2 => param.vector;
	    visible => <-.UIpanel.visible;
	    title = "Mode";
	    y		=> <-.UIradioBoxLabel_dir.y + <-.UIradioBoxLabel_dir.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UItoggle norm_toggle {
	    parent => <-.UIpanel;
	    label = "Glyph Normalize";
	    &set+IPort2 => param.normalize;
	    y		=> <-.UIradioBoxLabel_mode.y + <-.UIradioBoxLabel_mode.height + 4;
	    width	=> <-.UIpanel.width;
	};

	UIslider scale_slider {
	    parent => <-.UIpanel;
	    title = "Glyph Scale";
	    value+IPort2 => param.scale;
	    min = -10;
	    max = 10;
	    y		=> <-.norm_toggle.y + <-.norm_toggle.height + 4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein scale_slider_typein {
	    slider	=> scale_slider;
        };
	UIslider start_slider {
	    parent => <-.UIpanel;
	    title = "Start Time";
	    value+IPort2 => param.start;
	    y		=> <-.scale_slider.y + <-.scale_slider.height + 4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein start_slider_typein {
	    slider	=> start_slider;
        };
	UIslider end_slider {
	    parent => <-.UIpanel;
	    title = "End Time";
	    value+IPort2 => param.end;
	    y		=> <-.start_slider.y + <-.start_slider.height + 4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein end_slider_typein {
	    slider	=> end_slider;
        };
	UIslider incr_slider {
	    parent => <-.UIpanel;
	    title = "Step";
	    max = 10;
	    value+IPort2 => param.incr;
	    y		=> <-.end_slider.y + <-.end_slider.height + 4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein incr_slider_typein {
	    slider	=> incr_slider;
        };
	UIslider release_slider {
	    parent => <-.UIpanel;
	    title = "Release Interval";
	    max = 10;
	    value+IPort2 => param.release_interval;
	    y		=> <-.incr_slider.y + <-.incr_slider.height + 4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein release_slider_typein {
	    slider	=> release_slider;
        };
	UIfieldTypein time_typein {
	    UIparent => <-.UIpanel;
	    flabel = "Time";
	    fval+IPort2 => param.count;
	    panel.y	=> <-.<-.release_slider.y + <-.<-.release_slider.height + 4;
	    panel.width	=> <-.<-.UIpanel.width;
	};
	UItoggle run_toggle {
	    parent => <-.UIpanel;
	    label = "Run";
	    &set+IPort2 => param.run;
	    y		=> <-.time_typein.panel.y + <-.time_typein.panel.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UItoggle reset_toggle {
	    parent => <-.UIpanel;
	    label = "Reset Time";
	    &set+IPort2 => param.reset;
	    y		=> <-.run_toggle.y + <-.run_toggle.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UItoggle cycle_toggle {
	    parent => <-.UIpanel;
	    label = "Cycle";
	    &set+IPort2 => param.cycle;
	    y		=> <-.reset_toggle.y + <-.reset_toggle.height + 4;
	    width	=> <-.UIpanel.width;
	};

    };

    DataObjectNoTexture obj {
	in => Advect.out_fld;
	Obj {
	    type = 1;
	    name => name_of(<-.<-.<-);
	    xform_mode = GD_XFORM_MODE_ALT;
	    alt_xform+nres => <-.<-.plane.xform;
	};
    };
    DataObjectNoTexture obj1 {
	in => Advect.out_fld1;
	Obj {
	    xform_mode = GD_XFORM_MODE_ALT;
	    alt_xform+nres => <-.<-.in_probe.xform;
	};
    };

    olink out_fld<export_all=2> => Advect.out_fld;
    olink out_fld1<export_all=2> => Advect.out_fld1;
    olink out_obj => obj.obj;
    olink out_obj1 => obj1.obj;
}; // advector

macro advect_multi_block {
    ilink in_field<export_all=1>;
    ilink in_probe<export_all=1>;
    ilink in_glyph<export_all=1>;

    DV_Param_advect+Port  AdvectParam<export_all=2> {
	 component = 0;
	 order = 2;
	 forw_back = 1;
	 nseg = 2;
	 max_seg = 256;
	 min_vel = 0.00001;
	 run = 0;
	 reset = 0;
	 cycle = 0;
	 start = 0.0;
	 end = 1.0;
	 incr = 0.2;
	 vector = 1;
	 scale = 1.0;
	 normalize = 0;
    };

    AdvectMultiBlock Advect {
	in_fld => in_field;
	in_prb => in_probe;
	in_glp => in_glyph;
	param => AdvectParam;
    };
    GMOD.instancer instancer {
	Value => UIpanel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => AdvectUI;
    };
    UImod_panel UIpanel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-);
	message = "Select advector multiblock control panel.";
    };

    macro AdvectUI<instanced=0> {
	ilink in_fld => in_field;
	DV_Param_advect+IPort2 &param => AdvectParam;
	ilink UIpanel  => <-.UIpanel;

	UIslider nseg_slider {
	    parent => <-.UIpanel;
	    title = "N-segments";
	    max = 16;
	    value+IPort2 => param.nseg;
	    mode = 1;
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
	UIslider max_seg_slider {
	    parent => <-.UIpanel;
	    title = "Max Segments";
	    min = 1;
	    max = 10000;
	    value+IPort2 => param.max_seg;
	    mode = 1;
	    y		=> <-.nseg_slider.y + <-.nseg_slider.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIslider order_slider {
	    parent => <-.UIpanel;
	    title = "Order";
	    min = 1;
	    max = 4;
	    value+IPort2 => param.order;
	    mode = 1;
	    y		=> <-.max_seg_slider.y + <-.max_seg_slider.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIslider vel_slider {
	    parent => <-.UIpanel;
	    title = "Min Velocity";
	    value+IPort2 => param.min_vel;
	    y		=> <-.order_slider.y + <-.order_slider.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIradioBoxLabel UIradioBoxLabel_dir {
	    parent => <-.UIpanel;
	    labels+IPort2 => {"backward","forward"};
	    &selectedItem+IPort2 => param.forw_back;
	    visible => <-.UIpanel.visible;
	    title = "Direction";
	    y		=> <-.vel_slider.y + <-.vel_slider.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIradioBoxLabel UIradioBoxLabel_mode {
	    parent => <-.UIpanel;
	    labels+IPort2 => {"scalar", "vector", "components"};
	    &selectedItem+IPort2 => param.vector;
	    visible => <-.UIpanel.visible;
	    title = "Mode";
	    y		=> <-.UIradioBoxLabel_dir.y + <-.UIradioBoxLabel_dir.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UItoggle norm_toggle {
	    parent => <-.UIpanel;
	    label = "Glyph Normalize";
	    &set+IPort2 => param.normalize;
	    y		=> <-.UIradioBoxLabel_mode.y + <-.UIradioBoxLabel_mode.height + 4;
	    width	=> <-.UIpanel.width;
	};

	UIslider scale_slider {
	    parent => <-.UIpanel;
	    title = "Glyph Scale";
	    value+IPort2 => param.scale;
	    min = -10;
	    max = 10;
	    y		=> <-.norm_toggle.y + <-.norm_toggle.height + 4;
	    width	=> <-.UIpanel.width;
	};

	UIslider start_slider {
	    parent => <-.UIpanel;
	    title = "Start Time";
	    value+IPort2 => param.start;
	    y		=> <-.scale_slider.y + <-.scale_slider.height + 4;
	    width	=> <-.UIpanel.width;
	};

	UIslider end_slider {
	    parent => <-.UIpanel;
	    title = "End Time";
	    value+IPort2 => param.end;
	    y		=> <-.start_slider.y + <-.start_slider.height + 4;
	    width	=> <-.UIpanel.width;
	};

	UIslider incr_slider {
	    parent => <-.UIpanel;
	    title = "Step";
	    max = 10;
	    value+IPort2 => param.incr;
	    y		=> <-.end_slider.y + <-.end_slider.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIslider release_slider {
	    parent => <-.UIpanel;
	    title = "Release Interval";
	    max = 10;
	    value+IPort2 => param.release_interval;
	    y		=> <-.incr_slider.y + <-.incr_slider.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIfieldTypein time_typein {
	    UIparent => <-.UIpanel;
	    flabel = "Time";
	    fval+IPort2 => param.count;
	    panel.y	=> <-.<-.release_slider.y + <-.<-.release_slider.height + 4;
	    panel.width	=> <-.<-.UIpanel.width;
	};
	UItoggle run_toggle {
	    parent => <-.UIpanel;
	    label = "Run";
	    &set+IPort2 => param.run;
	    y		=> <-.time_typein.panel.y + <-.time_typein.panel.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UItoggle reset_toggle {
	    parent => <-.UIpanel;
	    label = "Reset Time";
	    &set+IPort2 => param.reset;
	    y		=> <-.run_toggle.y + <-.run_toggle.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UItoggle cycle_toggle {
	    parent => <-.UIpanel;
	    label = "Cycle";
	    &set+IPort2 => param.cycle;
	    y		=> <-.reset_toggle.y + <-.reset_toggle.height + 4;
	    width	=> <-.UIpanel.width;
	};

    };

    DataObjectNoTexture obj {
	in => Advect.out_fld;
	Obj {
	    name => name_of(<-.<-.<-);
	    xform_mode = GD_XFORM_MODE_ALT;
	    alt_xform+nres => <-.<-.in_probe.xform;
	};
	Obj.type = 1;
    };
    DataObjectNoTexture obj1 {
	in => Advect.out_fld1;
	Obj {
	    xform_mode = GD_XFORM_MODE_ALT;
	    alt_xform+nres => <-.<-.in_probe.xform;
	};
    };

    olink out_fld<export_all=2> => Advect.out_fld;
    olink out_fld1<export_all=2> => Advect.out_fld1;
    olink out_obj => obj.obj;
    olink out_obj1 => obj1.obj;
}; // advect_multi_block

macro thresh_null {
    ilink in_field<export_all=1>;

    int+Port component<export=2> = 0;

    DVthresh_null  DVthresh_null {
	in => in_field;
	thresh_component => component;
    };

    macro ThreshNullUI {
	link in_fld => in_field;
	ilink thresh_comp => component;

	DVnode_data_labels DVnode_data_labels {
	    in => in_fld;
	    int+nres  ncomp => in.nnode_data;
	};
	UImod_panel UIpanel {
	    parent<NEportLevels={4,0}>;
	    title => name_of(<-.<-.<-);
	    message = "Select Thresh Null control panel.";
	};
	UIradioBoxLabel UIradioBoxLabel {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    &selectedItem+IPort2 => thresh_comp;
	    visible => <-.UIpanel.visible;
	    title = "thresh data";
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
    };

    DataObjectNoTexture obj {
	in => DVthresh_null.out;
	Obj {
	    name => name_of(<-.<-.<-);
	};
    };

    olink out_fld<export_all=2> => DVthresh_null.out;
    olink out_obj => obj.obj;
}; // thresh_null

macro thresh_null_cells {
    ilink in_field<export_all=1>;

    int+Port component<export=2> = 0;

    DVthresh_null_cells  DVthresh_null_cells {
	in => in_field;
	thresh_component => component;
    };

    macro ThreshNullUI {
	link in_fld => in_field;
	ilink thresh_comp => component;

	DVcell_data_labels DVcell_data_labels {
	    in => in_fld;
	};
	UImod_panel UIpanel {
	    parent<NEportLevels={4,0}>;
	    title => name_of(<-.<-.<-);
	    message = "Select Thresh Null Cells control panel.";
	};
	UIradioBoxLabel UIradioBoxLabel {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVcell_data_labels.labels;
	    &selectedItem+IPort2 => thresh_comp;
	    visible => <-.UIpanel.visible;
	    title = "thresh data";
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
    };

    DataObjectNoTexture obj {
	in => DVthresh_null_cells.out;
	Obj {
	    name => name_of(<-.<-.<-);
	};
    };

    olink out_fld<export_all=2> => DVthresh_null_cells.out;
    olink out_obj => obj.obj;
}; // thresh_null_cells

macro excavate_brick3D {
    ilink in_field<export_all=1>;
    ilink texture_map<export_all=1>;

    DV_Param_exc_brick ExcBrickParam<export_all=2> {
	x+nres => (in_field.dims[0]-1)/2;
	y+nres => (in_field.dims[1]-1)/2;
	z+nres => (in_field.dims[2]-1)/2;
	flip_x = 0;
	flip_y = 0;
	flip_z = 0;
	draw_sides = 0;
    };

    DVexcavate_brick3d DVexcavate_brick3d {
	in => in_field;
	DV_Param_exc_brick+IPort2 &param => ExcBrickParam;
	&x => param.x;
	&y => param.y;
	&z => param.z;
	&flip_x => param.flip_x;
	&flip_y => param.flip_y;
	&flip_z => param.flip_z;
	&draw_sides => param.draw_sides;
    };
    GMOD.instancer instancer {
	Value => UIpanel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => ExcBrickUI;
    };
    UImod_panel UIpanel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-);
	message = "Select Excavate Brick 3D control panel.";
    };

    macro ExcBrickUI<instanced=0> {
	ilink in_fld => in_field;
	DV_Param_exc_brick+IPort2 &param => ExcBrickParam;
	ilink UIpanel  => <-.UIpanel;

	UIslider x_slider {
	    parent => <-.UIpanel;
	    title = "X";
	    &max+nres+IPort2 => in_fld.dims[0]-1;
	    value+IPort2 => param.x;
	    mode = 1;
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
	UIslider y_slider {
	    parent => <-.UIpanel;
	    title = "Y";
	    &max+nres+IPort2 => in_fld.dims[1]-1;
	    value+IPort2 => param.y;
	    mode = 1;
	    y		=> <-.x_slider.y + <-.x_slider.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UIslider z_slider {
	    parent => <-.UIpanel;
	    title = "Z";
	    &max+nres+IPort2 => in_fld.dims[2]-1;
	    value+IPort2 => param.z;
	    mode = 1;
	    y		=> <-.y_slider.y + <-.y_slider.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UItoggle flip_x_toggle {
	    parent => <-.UIpanel;
	    label = "Flip X";
	    &set+IPort2 => param.flip_x;
	    y		=> <-.z_slider.y + <-.z_slider.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UItoggle flip_y_toggle {
	    parent => <-.UIpanel;
	    label = "Flip Y";
	    &set+IPort2 => param.flip_y;
	    y		=> <-.flip_x_toggle.y + <-.flip_x_toggle.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UItoggle flip_z_toggle {
	    parent => <-.UIpanel;
	    label = "Flip Z";
	    &set+IPort2 => param.flip_z;
	    y		=> <-.flip_y_toggle.y + <-.flip_y_toggle.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UItoggle draw_sides_toggle {
	    parent => <-.UIpanel;
	    label = "Draw Sides";
	    &set+IPort2 => param.draw_sides;
	    y		=> <-.flip_z_toggle.y + <-.flip_z_toggle.height + 4;
	    width	=> <-.UIpanel.width;
	};
    };
    DataObject obj {
	in => DVexcavate_brick3d.out;
	texture_in => in_field;
	texture_col_in => texture_map;
	Obj {
	    name => name_of(<-.<-.<-);
	    xform_mode = GD_XFORM_MODE_PARENT;
	    Modes.normals = 1;
	};
    };

    olink out_fld<export_all=2> => DVexcavate_brick3d.out;
    olink out_obj => obj.obj;
}; // excavate_brick3D

macro cut_texture3D {
    ilink in_field<export_all=1>;
    ilink in_plane<export_all=1>;
    ilink texture_map<export_all=1>;

    DV_Param_cut+IPort CutParam<export_all=2> {
	component = {0};
	dist = 0;
	above = 0;
    };
    CutTxt3D CutTxt3D {
	in_fld0 => in_field;
	in_pln0 => in_plane;
	param0 => CutParam;
    };

    macro CutUI {
	ilink in_fld => in_field;
	DV_Param_cut+IPort2 &param => CutParam;

	DVnode_data_labels DVnode_data_labels {
	    in => in_fld;
	    int+nres  ncomp => in.nnode_data;
	};
	UImod_panel UIpanel {
	    parent<NEportLevels={4,0}>;
	    title => name_of(<-.<-.<-);
	    message = "Select Cut Texture 3D control panel.";
	};
	UIoptionBoxLabel UIoptionBoxLabel {
	    parent => <-.UIpanel;
	    labels+IPort2 => DVnode_data_labels.labels;
	    max => DVnode_data_labels.ncomp;
	    &selectedItems+IPort2 => param.component;
	    title = "map components";
	    visible => <-.UIpanel.visible;
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
	UItoggle above_toggle {
	    parent => <-.UIpanel;
	    label = "Above";
	    &set+IPort2 => param.above;
	    y		=> <-.UIoptionBoxLabel.y + <-.UIoptionBoxLabel.height + 4;
	    width	=> <-.UIpanel.width;
	};

	UIslider plane_dist {
	    parent => <-.UIpanel;
	    title = "plane distance";
	    min+nres+IPort2 => cache(-0.5*(magnitude(in_fld.coordinates.max_vec-
	                      in_fld.coordinates.min_vec)));
	    max+nres+IPort2 => cache( 0.5*(magnitude(in_fld.coordinates.max_vec-
	                      in_fld.coordinates.min_vec)));
	    value+IPort2 => param.dist;
	    y		=> <-.above_toggle.y + <-.above_toggle.height + 4;
	    width	=> <-.UIpanel.width * 11 / 12;
	};
	VUIslider_typein plane_dist_typein {
	    slider	=> plane_dist;
        };
    };

    DataObject obj {
	in => CutTxt3D.out_fld;
	texture_in => in_field;
	texture_col_in => texture_map;
	Obj {
	    name => name_of(<-.<-.<-);
	    xform_mode = GD_XFORM_MODE_ALT;
	    alt_xform+nres => <-.<-.in_plane.xform;
	};
    };

    olink out_fld<export_all=2> => CutTxt3D.out_fld;
    olink out_obj => obj.obj;
}; // cut_texture3D

macro slice_texture3D {
    ilink in_field<export_all=1>;
    ilink in_plane<export_all=1>;
    ilink texture_map<export_all=1>;

    SliceTxt3D SliceTxt3D {
	in_fld0 => in_field;
	in_pln0 => in_plane;
    };

    DataObject obj {
	in => SliceTxt3D.out_fld;
	texture_in => in_field;
	texture_col_in => texture_map;
	Obj {
	    name => name_of(<-.<-.<-);
	    xform_mode = GD_XFORM_MODE_ALT;
	    alt_xform+nres => <-.<-.in_plane.xform;
	};
    };

    olink out_fld<export_all=2> => SliceTxt3D.out_fld;
    olink out_obj => obj.obj;
}; // slice_texture3D

macro slice_texture2D {
    ilink in_field<export_all=1>;
    ilink in_plane<export_all=1>;
    ilink texture_map<export_all=1>;

    SliceTxt2D SliceTxt2D {
	in_fld => in_field;
	in_pln => in_plane;
    };

    DataObject obj {
	in => SliceTxt2D.out_fld;
	texture_in => SliceTxt2D.out_fld1;
	texture_col_in => texture_map;
	Obj {
	    name => name_of(<-.<-.<-);
	    xform_mode = GD_XFORM_MODE_ALT;
	    alt_xform+nres => <-.<-.in_plane.xform;
	};
    };

    olink out_fld<export_all=2> => SliceTxt2D.out_fld;
    olink out_obj => obj.obj;
}; // slice_texture2D

macro interp_texture3D {
    ilink in_field<export_all=1>;
    ilink in_probe<export_all=1>;
    ilink texture_map<export_all=1>;

    InterpTxt3D InterpTxt3D {
	in_fld => in_field;
	in_prb => in_probe;
    };

    DataObject obj {
	in => InterpTxt3D.out_fld;
	texture_in => in_field;
	texture_col_in => texture_map;
	Obj {
	    name => name_of(<-.<-.<-);
	    xform_mode = GD_XFORM_MODE_ALT;
	    alt_xform+nres => <-.<-.in_probe.xform;
	};
    };

    olink out_fld<export_all=2> => InterpTxt3D.out_fld;
    olink out_obj => obj.obj;
}; // interp_texture3D

macro roi_to_surface {
    Mesh_Array+IPort2 &rois;
    DV_Param_roi_to_surf param {
	roi_orient = 0;
	start_angle = 0;
	flip_normals = 0;
	cap_surface = 0;
    };
    Roi_to_surf Roi_to_surf {
	param => <-.param;
	mesh_array => <-.rois;
    };
    GMOD.instancer instancer {
	Value => UIpanel.visible;
	active = 2; // don't de-instance when visible = 0
	Group => roiUI;
    };
    UImod_panel UIpanel {
	parent<NEportLevels={3,0}>;
	title => name_of(<-.<-);
	message = "Select roi_to_surf control panel.";
    };

    macro roiUI<instanced=0> {
	DV_Param_roi_to_surf+IPort2 &param => <-.param;

	ilink UIpanel  => <-.UIpanel;

	UIradioBoxLabel UIradioBox_orient {
	    parent => <-.UIpanel;
	    labels = {"Z axis","Y axis","X axis"};
	    &selectedItem+IPort2 => param.roi_orient;
	    visible => <-.UIpanel.visible;
	    title = "roi oriented perpendicular to axis";
	    y		=  0;
	    width	=> <-.UIpanel.width;
	};
	UIradioBoxLabel UIradioBox_angle {
	    parent => <-.UIpanel;
	    labels = {"12 o'clock","3 o'clock","6 o'clock", "9 o'clock"};
	    &selectedItem+IPort2 => param.start_angle;
	    visible => <-.UIpanel.visible;
	    title = "start surface at";
	    y		=> <-.UIradioBox_orient.y + <-.UIradioBox_orient.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UItoggle UItoggle_flip {
	    parent => <-.UIpanel;
	    label = "flip surface normals";
	    set =>  param.flip_normals;
	    y		=><-.UIradioBox_angle.y + <-.UIradioBox_angle.height + 4;
	    width	=> <-.UIpanel.width;
	};
	UItoggle UItoggle_cap {
	    parent => <-.UIpanel;
	    label = "create cap surface";
	    set =>  param.cap_surface;
	    y		=><-.UItoggle_flip.y + <-.UItoggle_flip.height + 4;
	    width	=> <-.UIpanel.width;
	};
    };

    DataObjectNoTexture obj {
	in => Roi_to_surf.out_fld;
	Obj {
	    name => name_of(<-.<-.<-);
	    xform_mode = GD_XFORM_MODE_PARENT;
	};
    };

    olink out_fld<export_all=2> => Roi_to_surf.out_fld;
    olink out_obj => obj.obj;
}; // roi_to_surface


macro copy_ROI {
   Mesh_Unif+Node_Data+Dim3 &FieldIn<NEportLevels={2,1}>;
   Mesh &MeshIn<NEportLevels={2,1}>;
   float xsize => (FieldIn.coordinates.max_vec[0] - FieldIn.coordinates.min_vec[0]) *
   MeshOut.width + (2 * MeshOut.border_width * MeshOut.width);
   float ysize => (FieldIn.coordinates.max_vec[1] - FieldIn.coordinates.min_vec[1]) *
   MeshOut.height + (2 * MeshOut.border_width * MeshOut.height);
   float size_arr[2] => {xsize, ysize};
   float scale => (10 / max_array(.size_arr));
   float tmp1 => -5 * xsize / max_array(size_arr);
   float tmp2 => -5 * ysize / max_array(size_arr);
   float xxlate[2] => {tmp1,-5};
   float yxlate[2] => {tmp2,-5};
   FLD.Mesh_Array Mesh_Array;
   Mesh_Array+write+nonotify MeshOut {
      nmesh+nres => <-.FieldIn.dims[2];
      start = 0;
      width = 1;
      height = 1;
      orientation = 1;
      mode = 0;
      border_width = 0;
      MeshArr<NEportLevels={0,0}>;
      MeshIn<NEportLevels={2,0}> => <-.FieldIn;
      xform {
         mat+nres => {
            <-.<-.scale,0,0,0,
            0,<-.<-.scale,0,0,
            0,0,<-.<-.scale,0,
            0,0,0,1
         };
         xlate => {<-.<-.xxlate[<-.mode],<-.<-.yxlate[<-.mode],0};
      };
   };
   DV.DVswitch DVswitch {
      in => {<-.Mesh_Array, <-.MeshOut};
      index => <-.loop.done;
      out<NEportLevels={1,3}>;
   };
   GMOD.loop loop {
      start_val => <-.UIfieldTypein.field.value;
      end_val => <-.UIfieldTypein#1.field.value;
      incr = 1;
      run => <-.UItoggle.set;
      done = 1;
   };
   DV.DVcopy_cells DVcopy_cells {
      inMesh => <-.MeshIn;
      &outMesh => MeshOut.MeshArr[<-.loop.count];
      trigger => <-.loop.count;
   };
   UI.UImod_panel UImod_panel {
      title = "copy ROI";
      message = "Select copy ROI control panel.";
      height = 250;
   };
   int start_val = 0;
   UIfieldTypein UIfieldTypein {
      UIparent => <-.UImod_panel;
      flabel = "Start";
      fmax => <-.FieldIn.dims[2];
      fval => start_val;
      y = 0;
      label.alignment = 0;
      field.mode = 1;
      field.value = 0;
   };
   int end_val = 1;
   UIfieldTypein UIfieldTypein#1 {
      UIparent => <-.UImod_panel;
      flabel = "Stop";
      fmax => <-.FieldIn.dims[2];
      fval => end_val;
      y => <-.UIfieldTypein.y + <-.UIfieldTypein.height + 4;
      label.alignment = 0;
      field.mode = 1;
   };
   Controls.UItoggle UItoggle {
      parent => <-.UImod_panel;
      label = "Run";
      y	=> <-.UIfieldTypein#1.y + <-.UIfieldTypein#1.height + 4;
      width => <-.UImod_panel.width;
   };
}; // copy_ROI

macro display_vol_ROI {
   Mesh_Unif+Node_Data+Dim3 &FieldIn<NEportLevels={2,1}>;
   Mesh_Array &MeshIn<NEportLevels={2,1}>;
   int slice<NEportLevels={1,1}> => .UIslider.value;
   DV.DVorthoslice_unif DVorthoslice_unif {
      in => <-.FieldIn;
      axis = 2;
      plane => slice;
   };
   Mesh &MeshROI<NEportLevels={0,1}> => MeshIn.MeshArr[slice];
   GD.DataObject slice_obj {
      in => <-.DVset_xform.out;
   };
   GD.DataObject roi_obj {
      in => <-.MeshROI;
   };
   GD.GroupObject GroupObject {
      child_objs => {<-.slice_obj.obj, <-.roi_obj.obj};
      obj<NEportLevels={1,3}> {
         name => name_of(<-.<-.<-);
      };
   };
   DV.DVset_xform DVset_xform {
      in => <-.DVorthoslice_unif.out;
      in_xfm => <-.MeshROI;
   };
   UI.UImod_panel UImod_panel {
      title = "display vol ROI";
      message = "Select display vol ROI control panel.";
   };
   Controls.UIslider UIslider {
      parent => <-.UImod_panel;
      title = "slice";
      mode = 1;
      max => (<-.FieldIn.dims[2] - 1);
      value = 0;
      y		=  0;
      width	=> <-.UImod_panel.width;
   };
}; // display_vol_ROI

macro vect2rast_vol {
   Mesh_Unif+Node_Data+Dim3 &FieldIn<NEportLevels={2,1}>;
   Mesh_Array &MeshIn<NEportLevels={2,1}>;
   Mesh_Unif+Node_Data FieldOut<NEportLevels={0,1}> {
      nnodes => prod(.dims);
      dims+nres => {FieldIn.dims[0],
         FieldIn.dims[1],FieldIn.dims[2]};
      ndim+nres => FieldIn.ndim;
      nspace = 3;
      points => {
         0,0,0,(FieldIn.dims[0] - 1),(FieldIn.dims[1] - 1),
         (FieldIn.dims[2] - 1)
      };
   };
   GMOD.loop loop {
      start_val = 0;
      end_val => (FieldIn.dims[2] - 1);
      incr = 1;
      count = 63;
      done = 1;
      run => <-.UItoggle#1.set;
   };
   DV.DVset_slice_data DVset_slice_data {
      inField<NEportLevels={2,2}> => <-.FieldOut;
      slice => <-.loop.count;
      sliceField => <-.GDvector2raster.output;
   };
   Mesh &MeshROI<NEportLevels={0,1}> => MeshIn.MeshArr[loop.count];
   DV.DVswitch DVswitch {
      in => {<-.FieldIn, <-.DVset_slice_data.inField};
      index => <-.loop.done;
      out<NEportLevels={1,3}>;
   };
   GD.DefaultObject DefaultObject {
      input => <-.FieldIn;
   };
   Interactivity.GDvector2raster GDvector2raster {
      input => <-.MeshROI;
      obj_in => <-.DefaultObject;
      inside<NEportLevels={0,0}> => <-.UItoggle.set;
      name<NEportLevels={0,0}> => <-.UItext.text;
   };
   UI.UImod_panel UImod_panel {
      title = "vect2rast vol";
      message = "Select vector2raster volume control panel.";
   };
   Controls.UItoggle UItoggle {
      parent => <-.UImod_panel;
      label = "Inside";
      set = 1;
      y		=  0;
      width	=> <-.UImod_panel.width;
   };
   Controls.UIlabel UIlabel {
      parent => <-.UImod_panel;
      label = "Name";
      y		=> <-.UItoggle.y + <-.UItoggle.height;
      width	=> <-.UImod_panel.width / 2;
      height	=> <-.UItext.height;
      alignment = 0;
   };
   Controls.UItext UItext {
      parent => <-.UImod_panel;
      text<NEportLevels={0,2}>;
      x		=> <-.UImod_panel.width / 2;
      y		=> <-.UItoggle.y + <-.UItoggle.height;
      width	=> <-.UImod_panel.width / 2;
   };
   Controls.UItoggle UItoggle#1 {
      parent => <-.UImod_panel;
      label = "Run";
      set = 0;
      y		=> <-.UIlabel.y + <-.UIlabel.height + 4;
      width	=> <-.UImod_panel.width;
   };
}; // vect2rast_vol

macro tile_ROIs {
   FLD.Mesh_Array &Mesh_Array<NEportLevels={2,1}>;
   UI.UImod_panel UImod_panel {
      title = "Tile ROIs";
      message = "Select tile ROIs control panel";
   };
   Controls.UIslider UIslider {
      parent => <-.UImod_panel;
      title = "Start";
      mode = 1;
      max => (<-.Mesh_Array.nmesh - 1);
      value => <-.Mesh_Array.start;
      y		=  0;
      width	=> <-.UImod_panel.width;
   };
   Controls.UIslider UIslider#1 {
      parent => <-.UImod_panel;
      title = "Width";
      mode = 1;
      min = 1;
      max => (<-.Mesh_Array.nmesh - 1);
      value => <-.Mesh_Array.width;
      y		=> <-.UIslider.y + <-.UIslider.height + 4;
      width	=> <-.UImod_panel.width;
   };
   Controls.UIslider UIslider#2 {
      parent => <-.UImod_panel;
      title = "Height";
      mode = 1;
      min = 1;
      max => (<-.Mesh_Array.nmesh - 1);
      value => <-.Mesh_Array.height;
      y		=> <-.UIslider#1.y + <-.UIslider#1.height + 4;
      width	=> <-.UImod_panel.width;
   };
   Controls.UIslider UIslider#3 {
      parent => <-.UImod_panel;
      title = "Border Width";
      mode = 1;
      min = 0;
      max = 100;
      value => <-.Mesh_Array.border_width;
      y		=> <-.UIslider#2.y + <-.UIslider#2.height +4;
      width	=> <-.UImod_panel.width;
   };
   Panels.UIframe UIframe {
      parent => <-.UImod_panel;
      y		=> <-.UIslider#3.y + <-.UIslider#3.height + 4;
      width	=> <-.UImod_panel.width;
      height	=> <-.UIradioBox.y + <-.UIradioBox.height + 6;
   };
   Controls.UIlabel UIlabel {
      parent => <-.UIframe;
      label = "Orientation";
      y		=  0;
      width	=> <-.UIframe.clientWidth;
   };
   Commands.UIoption UIoption {
      label = "Column/Bottom";
   };
   Commands.UIoption UIoption#1 {
      label = "Row/Bottom";
   };
   Commands.UIoption UIoption#2 {
      label = "Column/Top";
   };
   Commands.UIoption UIoption#3 {
      label = "Row/Top";
   };
   Controls.UIradioBox UIradioBox {
      parent => <-.UIframe;
      cmdList => {<-.UIoption,<-.UIoption#1,<-.UIoption#2,<-.UIoption#3};
      selectedItem => <-.Mesh_Array.orientation;
      y		=> <-.UIlabel.y + <-.UIlabel.height + 4;
      width	=> <-.UIframe.clientWidth;
   };
   Panels.UIframe UIframe#1 {
      parent => <-.UImod_panel;
      y		=> <-.UIframe.y + <-.UIframe.height + 4;
      width	=> <-.UImod_panel.width;
      height	=> <-.UIradioBox#1.y + <-.UIradioBox#1.height + 6;
   };
   Controls.UIlabel UIlabel#1 {
      parent => <-.UIframe#1;
      label = "Transform Mode";
      y		=  0;
      width	=> <-.UIframe#1.clientWidth;
   };
   Commands.UIoption UIoption#4 {
      label = "Single Image";
   };
   Commands.UIoption UIoption#5 {
      label = "Within Tile";
   };
   Controls.UIradioBox UIradioBox#1 {
      parent => <-.UIframe#1;
      cmdList => {<-.UIoption#4,<-.UIoption#5};
      selectedItem = 0;
      y		=> <-.UIlabel#1.y + <-.UIlabel#1.height + 4;
      width	=> <-.UIframe#1.clientWidth;
   };
   Controls.UItoggle UItoggle {
      parent => <-.UImod_panel;
      label = "Container Mode";
      set => <-.Mesh_Array.mode;
      y         => <-.UIframe#1.y + <-.UIframe#1.height + 4;
      width     => <-.UImod_panel.width;
   };
   GD.DataObject DataObject {
      in => <-.Mesh_Array;
      int xform_mode_arr[2] = {0,2};
      obj<NEportLevels={1,3}> {
         name => name_of(<-.<-.<-);
         xform_mode => <-.xform_mode_arr[<-.<-.UIradioBox#1.selectedItem];
         alt_xform+IPort3 => <-.<-.Mesh_Array.tile_xform;
      };
   };
}; // tile_ROIs

macro tile_volume {
   Mesh_Unif+Node_Data+Dim3+Space3 &FieldIn<NEportLevels={2,1}>;
   UI.UImod_panel UImod_panel {
      title = "Tile Volume";
      message = "Select tile volume control panel";
   };
   Controls.UIslider UIslider {
      parent => <-.UImod_panel;
      title = "Start";
      mode = 1;
      max => (<-.FieldIn.dims[2] - 1);
      value => <-.Tiled_Volume.start;
      y		=  0;
      width	=> <-.UImod_panel.width;
   };
   Controls.UIslider UIslider#1 {
      parent => <-.UImod_panel;
      title = "Width";
      mode = 1;
      min = 1;
      max => (<-.FieldIn.dims[2] - 1);
      value => <-.Tiled_Volume.width;
      y		=> <-.UIslider.y + <-.UIslider.height +4;
      width	=> <-.UImod_panel.width;
   };
   Controls.UIslider UIslider#2 {
      parent => <-.UImod_panel;
      title = "Height";
      mode = 1;
      min = 1;
      max => (<-.FieldIn.dims[2] - 1);
      value => <-.Tiled_Volume.height;
      y		=> <-.UIslider#1.y + <-.UIslider#1.height +4;
      width	=> <-.UImod_panel.width;
   };
   Controls.UIslider UIslider#3 {
      parent => <-.UImod_panel;
      title = "Border Width";
      mode = 1;
      min = 0;
      max = 100;
      value => <-.Tiled_Volume.border_width;
      y		=> <-.UIslider#2.y + <-.UIslider#2.height +4;
      width	=> <-.UImod_panel.width;
   };
   Panels.UIframe UIframe {
      parent => <-.UImod_panel;
      y		=> <-.UIslider#3.y + <-.UIslider#3.height +4;
      width	=> <-.UImod_panel.width;
      height	=> <-.UIradioBox.y + <-.UIradioBox.height + 6;
   };
   Controls.UIlabel UIlabel {
      parent => <-.UIframe;
      label = "Orientation";
      y		=  0;
      width	=> <-.UIframe.clientWidth;
   };
   Commands.UIoption UIoption {
      label = "Column/Bottom";
   };
   Commands.UIoption UIoption#1 {
      label = "Row/Bottom";
   };
   Commands.UIoption UIoption#2 {
      label = "Column/Top";
   };
   Commands.UIoption UIoption#3 {
      label = "Row/Top";
   };
   Controls.UIradioBox UIradioBox {
      parent => <-.UIframe;
      cmdList => {<-.UIoption,<-.UIoption#1,<-.UIoption#2,<-.UIoption#3};
      selectedItem => <-.Tiled_Volume.orientation;
      y		=> <-.UIlabel.y + <-.UIlabel.height + 4;
      width	=> <-.UIframe.clientWidth;
   };
   Panels.UIframe UIframe#1 {
      parent => <-.UImod_panel;
      y		=> <-.UIframe.y + <-.UIframe.height + 4;
      width	=> <-.UImod_panel.width;
      height	=> <-.UIradioBox#1.y + <-.UIradioBox#1.height + 6;
   };
   Controls.UIlabel UIlabel#1 {
      parent => <-.UIframe#1;
      label = "Transform Mode";
      y		=  0;
      width	=> <-.UIframe#1.clientWidth;
   };
   Commands.UIoption UIoption#4 {
      label = "Single Image";
   };
   Commands.UIoption UIoption#5 {
      label = "Within Tile";
   };
   Controls.UIradioBox UIradioBox#1 {
      parent => <-.UIframe#1;
      cmdList => {<-.UIoption#4,<-.UIoption#5};
      selectedItem = 0;
      y		=> <-.UIlabel#1.y + <-.UIlabel#1.height + 4;
      width	=> <-.UIframe#1.clientWidth;
   };
   Controls.UItoggle UItoggle {
      parent => <-.UImod_panel;
      label = "Container Mode";
      set => <-.Tiled_Volume.mode;
      y		=> <-.UIframe#1.y + <-.UIframe#1.height + 4;
      width	=> <-.UImod_panel.width;
   };
   float xsize => (FieldIn.coordinates.max_vec[0] - FieldIn.coordinates.min_vec[0]) *
   Tiled_Volume.width + (2 * Tiled_Volume.border_width * Tiled_Volume.width);
   float ysize => (FieldIn.coordinates.max_vec[1] - FieldIn.coordinates.min_vec[1]) *
   Tiled_Volume.height + (2 * Tiled_Volume.border_width * Tiled_Volume.height);
   float size_arr[2] => {xsize, ysize};
   float scale => (10 / max_array(.size_arr));
   float tmp1 => -5 * xsize / max_array(size_arr);
   float tmp2 => -5 * ysize / max_array(size_arr);
   float xxlate[2] => {tmp1,-5};
   float yxlate[2] => {tmp2,-5};
   FLD.Tiled_Volume Tiled_Volume {
      VolIn<NEportLevels={2,0}> => FieldIn;
      start = 0;
      width = 1;
      height = 1;
      orientation = 1;
      mode = 0;
      border_width = 0;
      xform {
         mat+nres => {
            <-.<-.scale,0,0,0,
            0,<-.<-.scale,0,0,
            0,0,<-.<-.scale,0,
            0,0,0,1
         };
         xlate => { <-.<-.xxlate[<-.mode], <-.<-.yxlate[<-.mode], 0 };
      };
      tile_xform+OPort2;
   };
   GD.DataObject DataObject {
      in => <-.Tiled_Volume;
      MinMax {
         input => in.VolIn;
      };
      int xform_mode_arr[2] = {0,2};
      obj<NEportLevels={1,3}> {
         name => name_of(<-.<-.<-);
         xform_mode => <-.xform_mode_arr[<-.<-.UIradioBox#1.selectedItem];
         alt_xform+IPort3 => <-.<-.Tiled_Volume.tile_xform;
      };
   };
}; // tile_volume

macro tile_volume_ROIs {
   Mesh_Unif+Node_Data+Dim3+Space3 &FieldIn<NEportLevels={2,1}>;
   FLD.Mesh_Array &Mesh_Array<NEportLevels={2,1}>;
   UI.UImod_panel UImod_panel {
      title = "Tile Volume ROIs";
      message = "Select tile volume ROIs control panel.";
   };
   Controls.UIslider UIslider {
      parent => <-.UImod_panel;
      title = "Start";
      mode = 1;
      max => (<-.FieldIn.dims[2] - 1);
      value => <-.Mesh_Array.start;
      y		=  0;
      width	=> <-.UImod_panel.width;
   };
   Controls.UIslider UIslider#1 {
      parent => <-.UImod_panel;
      title = "Width";
      mode = 1;
      min = 1;
      max => (<-.FieldIn.dims[2] - 1);
      value => <-.Mesh_Array.width;
      y		=> <-.UIslider.y + <-.UIslider.height + 4;
      width	=> <-.UImod_panel.width;
   };
   Controls.UIslider UIslider#2 {
      parent => <-.UImod_panel;
      title = "Height";
      x = 0;
      y = 130;
      mode = 1;
      min = 1;
      max => (<-.FieldIn.dims[2] - 1);
      value => <-.Mesh_Array.height;
      y		=> <-.UIslider#1.y + <-.UIslider#1.height + 4;
      width	=> <-.UImod_panel.width;
   };
   Controls.UIslider UIslider#3 {
      parent => <-.UImod_panel;
      title = "Border Width";
      mode = 1;
      min = 0;
      max = 100;
      value => <-.Mesh_Array.border_width;
      y		=> <-.UIslider#2.y + <-.UIslider#2.height +4;
      width	=> <-.UImod_panel.width;
   };
   Panels.UIframe UIframe {
      parent => <-.UImod_panel;
      y		=> <-.UIslider#3.y + <-.UIslider#3.height + 4;
      width	=> <-.UImod_panel.width;
      height	=> <-.UIradioBox.y + <-.UIradioBox.height + 6;
   };
   Controls.UIlabel UIlabel {
      parent => <-.UIframe;
      label = "Orientation";
      y		=  0;
      width	=> <-.UIframe.clientWidth;
   };
   Commands.UIoption UIoption {
      label = "Column/Bottom";
   };
   Commands.UIoption UIoption#1 {
      label = "Row/Bottom";
   };
   Commands.UIoption UIoption#2 {
      label = "Column/Top";
   };
   Commands.UIoption UIoption#3 {
      label = "Row/Top";
   };
   Controls.UIradioBox UIradioBox {
      parent => <-.UIframe;
      cmdList => {<-.UIoption,<-.UIoption#1,<-.UIoption#2,<-.UIoption#3};
      selectedItem => <-.Mesh_Array.orientation;
      y		=> <-.UIlabel.y + <-.UIlabel.height + 4;
      width	=> <-.UIframe.clientWidth;
   };
   Panels.UIframe UIframe#1 {
      parent => <-.UImod_panel;
      y		=> <-.UIframe.y + <-.UIframe.height + 4;
      width	=> <-.UImod_panel.width;
      height	=> <-.UIradioBox#1.y + <-.UIradioBox#1.height + 6;
   };
   Controls.UIlabel UIlabel#1 {
      parent => <-.UIframe#1;
      label = "Transform Mode";
      y		=  0;
      width	=> <-.UIframe#1.clientWidth;
   };
   Commands.UIoption UIoption#4 {
      label = "Single Image";
   };
   Commands.UIoption UIoption#5 {
      label = "Within Tile";
   };
   Controls.UIradioBox UIradioBox#1 {
      parent => <-.UIframe#1;
      cmdList => {<-.UIoption#4,<-.UIoption#5};
      selectedItem = 0;
      y		=> <-.UIlabel#1.y + <-.UIlabel#1.height + 4;
      width	=> <-.UIframe#1.clientWidth;
   };
   Controls.UItoggle UItoggle {
      parent => <-.UImod_panel;
      label = "Container Mode";
      set => <-.Mesh_Array.mode;
      y         => <-.UIframe#1.y + <-.UIframe#1.height + 4;
      width     => <-.UImod_panel.width;
   };

   float xsize => (FieldIn.coordinates.max_vec[0] - FieldIn.coordinates.min_vec[0]) *
   Tiled_Volume.width + (2 * Tiled_Volume.border_width * Tiled_Volume.width);
   float ysize => (FieldIn.coordinates.max_vec[1] - FieldIn.coordinates.min_vec[1]) *
   Tiled_Volume.height + (2 * Tiled_Volume.border_width * Tiled_Volume.height);
   float size_arr[2] => {xsize, ysize};
   float scale => (10 / max_array(.size_arr));
   float tmp1 => -5 * xsize / max_array(size_arr);
   float tmp2 => -5 * ysize / max_array(size_arr);
   float xxlate[2] => {tmp1,-5};
   float yxlate[2] => {tmp2,-5};
   FLD.Tiled_Volume Tiled_Volume {
      VolIn<NEportLevels={2,0}> => FieldIn;
      start => <-.Mesh_Array.start;
      width => <-.Mesh_Array.width;
      height => <-.Mesh_Array.height;
      orientation => <-.Mesh_Array.orientation;
      mode => <-.Mesh_Array.mode;
      border_width => <-.Mesh_Array.border_width;
      xform {
         mat+nres => {
            <-.<-.scale,0,0,0,
            0,<-.<-.scale,0,0,
            0,0,<-.<-.scale,0,
            0,0,0,1
         };
         xlate => { <-.<-.xxlate[<-.mode], <-.<-.yxlate[<-.mode], 0 };
      };
      &tile_xform => <-.Mesh_Array.tile_xform;
   };

   GD.DataObject DataObject {
      in => <-.Mesh_Array;
      obj {
         name = "roi_obj";
         xform_mode = GD_XFORM_MODE_PARENT;
      };
   };
   GD.DataObject DataObject#1 {
      in => <-.Tiled_Volume;
      MinMax {
         input => in.VolIn;
      };
      obj {
         name = "image_obj";
         xform_mode = GD_XFORM_MODE_PARENT;
      };
   };
   GD.GroupObject GroupObject {
      child_objs => {<-.DataObject#1.obj,<-.DataObject.obj};
      int xform_mode_arr[2] = {0,2};
      obj<NEportLevels={1,3}> {
         name => name_of(<-.<-.<-);
         xform_mode => <-.xform_mode_arr[<-.<-.UIradioBox#1.selectedItem];
         alt_xform+IPort3 => <-.<-.Mesh_Array.tile_xform;
      };
   };
}; // tile_volume_ROIs

macro volume_render {
   // Should be Byte or Short
   Mesh_Unif+Dim3+Space3+Node_Data+Scalar &in_mesh<NEportLevels={2,1}>;
   macro DataObject {
      group &in<NEportLevels={2,1},NEnumColors=4,NEcolor0=255> {
         GDxform_templ &xform;
         method render;
      } => <-.in_mesh;
      imlink child_objs;
      DefaultProps Props;
      DefaultModes Modes<NEportLevels={0,2}> {
         mode = {0,0,0,3,0};
      };
      VolRenderMinMax MinMax {
         input => in;
         /* default values for 8-bit rendering */
         min_value = 0.0;
         max_value = 255.0;
      };
      DATAMAPS.VolumeRender VolRenderDatamap<NEportLevels={0,2}> {
         dataMin => <-.MinMax.min_value;
         dataMax => <-.MinMax.max_value;
         int rangesMin     => .min_array[index];
         int rangePosition => .mid_array[index];
         int rangesMax     => .max_array[index];

         // Use user defined range 
         // UIMinValue/UIMaxValue instead of DataMinValue/DataMaxValue
         !DataRange[0] { selectValues = 1; };
         !DataRange[1] { selectValues = 1; };

         // Ratio based on user defined range
         ratio => ((DataRange[0].UIMaxValue - DataRange[0].UIMinValue) / 
                   (DataRange[1].UIMaxValue - DataRange[0].UIMinValue));

      };
      DefaultPickInfo PickInfo;
      AltObject AltObject {
         alt_in => in;
      };
      DefaultObject Obj<NEportLevels={0,1}> {
         dmap => VolRenderDatamap;
         xform => in.xform;
         props => Props;
         modes => Modes;
         objects => child_objs;
         use_altobj = 1;
         altobj => AltObject.obj;
         pick_info => PickInfo;
         name => name_of(<-.<-.<-);
         input => <-.in;
      };
   };
   Editors.GDmodes_edit GDmodes_edit {
      shell_vis = 1;
      modes => DataObject.Modes;
      points = 0;
      lines = 0;
      bounds = 0;
   };
   Editors.GDprops_edit GDprops_edit {
      shell_vis = 1;
      props => DataObject.Props;
   };

   int curRange = 0;
   int curCP = 0;
   DMAP.DataRangeTempl &curRangePtr => DataObject.VolRenderDatamap.ranges[curRange];
   DMAP.DatamapValue &curCPptr => DataObject.VolRenderDatamap.ranges[curRange].controlPoints[curCP];
   DMAP.DatamapValue &nextCPptr => DataObject.VolRenderDatamap.ranges[curRange].controlPoints[curCP+1];

   UI.UImod_panel UImod_panel {
      title => name_of(<-.<-);
   };

   macro modes_ui {

   UIframe modes_frame {
      parent<NEportLevels={3,0}> => <-.<-.UImod_panel;
      y = 0;
      width => <-.<-.UImod_panel.clientWidth;
      height => vol_rb.y + vol_rb.height + 4;
   };

   UIlabel modes_label {
      parent => modes_frame;
      x = 4;
      y = 0;
      width => modes_frame.clientWidth - 8;
      label = "Modes";
      alignment = 1;
   };
   Commands.UIoption inherit {
      label = "Inherit";
   };
   Commands.UIoption none {
      label = "None";
   };
   Commands.UIoption no_light {
      label = "No Lighting";
   };
   Commands.UIoption flat {
      label = "Flat Shading";
   };
   Commands.UIoption gouraud {
      label = "Gouraud Shading";
   };
   UI.Controls.UIoptionMenu surf_rb {
      parent => modes_frame;
      y => modes_label.y + modes_label.height + 4;
      label = "Surface";
      alignment = 0;
      cmdList => {inherit,none,no_light,flat,gouraud};
      selectedItem => GDmodes_edit.surf;
   };
   Commands.UIoption vol_inherit {
      label = "Inherit";
   };
   Commands.UIoption vol_none {
      label = "None";
   };
   Commands.UIoption btf {
      label = "BTF texture";
   };
   Commands.UIoption ray_tracer {
      label = "Ray tracer";
   };
   UI.Controls.UIoptionMenu vol_rb {
      parent => modes_frame;
      y => surf_rb.y + surf_rb.height + 4;
      label = "Volume";
      alignment = 0;
      cmdList => {vol_inherit,vol_none,btf,ray_tracer};
      selectedItem => GDmodes_edit.volume;
   };
   }; // modes_ui

   macro props_ui {

   UIframe props_frame {
      parent<NEportLevels={3,0}> => UImod_panel;
      y => modes_ui.modes_frame.y + modes_ui.modes_frame.height + 4;
      width => UImod_panel.clientWidth;
      height => sfp_emit.y + sfp_emit.height + 8;
   };

   UIlabel props_label {
      parent => props_frame;
      x = 4;
      y = 0;
      width => props_frame.clientWidth - 8;
      label = "Properties";
      alignment = 1;
   };
   Commands.UIoption interp_pt {
      label = "Point";
   };
   Commands.UIoption interp_tri {
      label = "Trilinear";
   };
   UI.Controls.UIoptionMenu interp_rb {
      parent => props_frame;
      y => props_label.y + props_label.height + 4;
      label = "Interpolation";
      alignment = 0;
      cmdList => {interp_pt,interp_tri};
      selectedItem => GDprops_edit.voxel_interp;
      active => switch(((GDprops_edit.ray_algo == 0) + 1), 0, 1);
   };

   Commands.UIoption ray_direct {
      label = "Direct Composite";
   };
   Commands.UIoption ray_ave {
      label = "Average Value";
   };
   Commands.UIoption ray_max {
      label = "Maximum Value";
   };
   Commands.UIoption ray_dist {
      label = "Distance to Max";
   };
   Commands.UIoption ray_sfp {
      label = "SFP";
   };
   UI.Controls.UIoptionMenu ray_rb {
      parent => props_frame;
      y => interp_rb.y + interp_rb.height + 4;
      label = "Ray Algorithm";
      alignment = 0;
      cmdList => {ray_direct,ray_ave,ray_max,ray_dist,ray_sfp};
      selectedItem => GDprops_edit.ray_algo;
   };
   Commands.UIoption dist_glob {
      label = "Global";
   };
   Commands.UIoption dist_view {
      label = "View";
   };
   Commands.UIoption dist_ray {
      label = "Ray";
   };
   UI.Controls.UIoptionMenu dist_rb {
      parent => props_frame;
      y => ray_rb.y + ray_rb.height + 4;
      label = "Distance Normalize";
      alignment = 0;
      cmdList => {dist_glob,dist_view,dist_ray};
      selectedItem => GDprops_edit.ray_norm;
      active => switch(((GDprops_edit.ray_algo == 3) + 1), 0, 1);
   };
   Controls.UItoggle fat_ray {
      parent => props_frame;
      label = "Fat Ray";
      y => dist_rb.y + dist_rb.height + 4;
      set => GDprops_edit.fat_ray;
   };
   Controls.UIslider sfp_absorb {
      parent => props_frame;
      title = "SFP Absorption";
      y => fat_ray.y + fat_ray.height + 4;
      min = 0;
      max = 1;
      value => GDprops_edit.sfp_absorb;
      active => switch(((GDprops_edit.ray_algo == 4) + 1), 0, 1);
   };
   Controls.UIslider sfp_emit {
      parent => props_frame;
      title = "SFP Emission";
      y => sfp_absorb.y + sfp_absorb.height + 4;
      min = 0;
      max = 1;
      value => GDprops_edit.sfp_emit;
      active => switch(((GDprops_edit.ray_algo == 4) + 1), 0, 1);
   };
   }; // props_ui

   macro datamap_ui {

   ilink VolRenderDatamap => <-.DataObject.VolRenderDatamap;

   UIframe datamap_frame {
      parent<NEportLevels={3,0}> => <-.<-.UImod_panel;
      y => props_ui.props_frame.y + props_ui.props_frame.height + 4;
      width => UImod_panel.clientWidth;
      height => <-.max_slider.y + <-.max_slider.height + 8;
   };

   UIlabel datamap_label {
      parent => <-.datamap_frame;
      x = 4;
      y = 0;
      width => datamap_frame.clientWidth - 8;
      label = "Datamap";
      alignment = 1;
   };

   macro Dmap2ImageLegend {

   int+OPort x = 4;
   int+OPort y => datamap_label.y + datamap_label.height + 4;
   int+OPort width  => <-.datamap_frame.clientWidth - 8;
   int+OPort height = 30;

   DMAP.Dmap2Image Dmap2Image {
      dmap<NEportLevels={3,0}> => VolRenderDatamap;
      width  => <-.width;
      height => <-.height;
      Mode = 1;
   };

   GDM.DataObjectLite Dmap2ImageDataObject {
      in => <-.Dmap2Image.out;
      // Surface rendering = "No Lighting"
      Modes.mode => {0,0,2,0,0};
      // Ambient Lighting, Diffuse, Specular, Gloss
      Props.material = {0.9, 0., 0., 0.};
   };

   GDM.Mscene2D Scene {
      Top {
          child_objs => {<-.<-.Dmap2ImageDataObject.obj};
          Top.pickable = 0;
      };
      Camera {
         Camera.norm_scale = 1.0;
      };
      View {
         View {
            aspect = "Biggest";
            UIrenderView render_view {
               // portLevel overkill ? :-) 
               x<NEportLevels={5,0}>      => <-.<-.<-.<-.x;
               y<NEportLevels={5,0}>      => <-.<-.<-.<-.y;
               width<NEportLevels={5,0}>  => <-.<-.<-.<-.width;
               height<NEportLevels={5,0}> => <-.<-.<-.<-.height;
               parent<NEportLevels={6,0}> => <-.<-.<-.<-.<-.datamap_frame;
            };
            handle => .render_view.handle;
         };
      };
   };
   }; // Dmap2ImageLegend 


   UIslider datamap_min_slider {
      parent => <-.datamap_frame;
      x = 0;
      y => <-.Dmap2ImageLegend.y + <-.Dmap2ImageLegend.height + 8;
      width => .parent.clientWidth - 2;
      value => VolRenderDatamap.rangesMin;
      // Min posible value of datatype depends on 8 bit vs. 12 bit vs. 16 bit.
      min =>   VolRenderDatamap.dataMin;
      // Use actual data min to ensure all data values can be mapped.
      max => <-.<-.in_mesh.node_data[0].min;
      active => (.min < .max);
      mode = "integer";
      title = "Datamap Minimum";
      message = "Minimum of entire Datamap";
   };
   UIslider datamap_max_slider {
      parent => <-.datamap_frame;
      x = 0;
      y => <-.datamap_min_slider.y + <-.datamap_min_slider.height + 4;
      width => parent.clientWidth  - 2;
      value => VolRenderDatamap.rangesMax;
      // Use actual data max to ensure all data values can be mapped.
      min => <-.<-.in_mesh.node_data[0].max;
      // Max posible value of datatype depends on 8 bit vs. 12 bit vs. 16 bit.
      max => VolRenderDatamap.dataMax;
      active => (.min < .max);
      mode = "integer";
      title = "Datamap Maximum";
      message = "Maximum of entire Datamap";
   };
   UIslider pos_slider {
      parent => <-.datamap_frame;
      title = "Range Control Point";
      y => <-.datamap_max_slider.y + <-.datamap_max_slider.height + 4;
      width => parent.width - <-.pos_slider_field.width;
      visible => (VolRenderDatamap.numRanges > 1);
      min => <-.datamap_min_slider.value;
      max => <-.datamap_max_slider.value;
      value => VolRenderDatamap.ranges[0].UIMaxValue;
      // The underlying data is always integer (byte or short),
      // but we want to be able to pick a point between two values.
      // For example, 127.5
      decimalPoints = 1;
      message = "Dividing point between the lower and upper ranges";
   };
   UIfield pos_slider_field {
      parent => <-.datamap_frame;
      x      => <-.pos_slider.x + pos_slider.width;
      y      => <-.pos_slider.y + (<-.pos_slider.height - .height) / 2;
      width  = 50;
#ifdef MSDOS
      height => max_array({20, <-.pos_slider.height/2});
#else
      height => max_array({24, <-.pos_slider.height/2});
#endif
      visible => <-.pos_slider.visible;
      min    => <-.pos_slider.min;
      max    => <-.pos_slider.max;
      value  => <-.pos_slider.value;
      decimalPoints = 1;
   };

   Controls.UIslider range_slider {
      parent => <-.datamap_frame;
      title = "Current Range";
      y => pos_slider.y + pos_slider.height + 8;
      active => (VolRenderDatamap.numRanges > 1);
      min = 0;
      max => switch( (VolRenderDatamap.numRanges < 1)+1,
                     (VolRenderDatamap.numRanges - 1), 0);
      value => <-.<-.curRange;
      mode = 1;
      message = "0 = lower range, 1 = upper range";
   };
   Commands.UIoption alpha_linear {
      label = "Linear";
   };
   // This used to be "Constant", but that was misleading,
   // because it really means use (inter-range) step interpolation.
   Commands.UIoption alpha_step {
      label = "Step";
   };
   UI.Controls.UIoptionMenu alpha_rb {
      parent => <-.datamap_frame;
      //label = "Alpha inter-Range Interpolation";
      label = "Alpha Range Model";
      cmdList => {alpha_linear, alpha_step};
      y => range_slider.y + range_slider.height + 4;
      alignment = 0;
      selectedItem => <-.<-.curRangePtr.selectAlphaRange;
   };
   Controls.UIslider min_slider {
      parent => <-.datamap_frame;
      title = "Minimum Alpha";
      message = "Minimum Alpha for current range";
      y => alpha_rb.y + alpha_rb.height + 4;
      min = 0;
      max = 1;
      value => <-.<-.curCPptr.v1;
   };
   Controls.UIslider max_slider {
      parent => <-.datamap_frame;
      title = "Maximum Alpha";
      message = "Maximum Alpha for current range";
      y => min_slider.y + min_slider.height + 4;
      min = 0;
      max = 1;
      value => <-.<-.nextCPptr.v1;
   };

   }; // datamap_ui

   UItoggle alt_object {
      parent => <-.UImod_panel;
      x = 0;
      y => <-.datamap_ui.datamap_frame.y + <-.datamap_ui.datamap_frame.height + 6;
      width => parent.clientWidth;
      set => <-.DataObject.Obj.use_altobj;
      label = "Alternate Object";
   };

    olink out_obj => .DataObject.Obj;

}; // volume_render

}; // Mappers


library+buffered MODS_BackwardCompatibility
                 <compile_subs=0, NEvisible=0, user_library=0> {

Read_Text_Columns Read_Column_File;

#ifdef NETCDF_KIT
NETCDF.Read_Object Read_netCDF;
NETCDF.Write_Object Write_netCDF;
#endif

CFD.Read_PLOT3D Plot3d_Multi_Block;

CMAP_EDTR.Modules.modHistogram histogram {
    data_component<NEportLevels={2,0}>;
};

}; // BackwardCompatibility

};
