//
//                      Copyright (c) 1994 by
//                      Advanced Visual Systems Inc.
//                      All Rights Reserved
//
//      This software comprises unpublished confidential information of
//      Advanced Visual Systems Inc. and may not be used, copied or made
//      available to anyone, except in accordance with the license
//      under which it is furnished.
//
//      This file is under Perforce control
//      $Id: //depot/express/fcs70/v/ne.v#1 $
//
// Objects used by the Network Editor.
//
//---------------------------------------------------------------------//

flibrary+global NE <
   build_dir     = "ne",
   build_cmd     = "$(MAKE)",
   cxx_hdr_files = "avs/ne.h",
   dictionary    = "ne.dct",
   hdr_code      = "void NEinit (int *argc, char **argv);",
   init_code     = "   NEinit(argc, argv);",
   libdeps       = "UI PAL",
   link_files    = "-lne $(WINLIBS) -lcxxut",
   need_objs     = "NEpreferences",
   NEvisible     = 0,
   out_hdr_file  = "ne_omx.hxx",
   out_src_file  = "ne_omx.cxx"
> {

//---------------------------------------------------------------------//
//                            Basic types                              //
//---------------------------------------------------------------------//

// This module contains data needed by the NE object popup menu.

module NEobjPopupData <use_src_file=0> {

    //--------------- Inputs (assigned by NE event handler):

    // Pointer to internal NEobj_disp data structure.

    ptr  objDispPtr;

    // Pixel coordinates at which to display the popup menu, relative
    // to the object window origin.

    int  x, y;

    // Flags indicating if the mouse pointer is over a port, if it is
    // an input port, and the index of the port (-1 for the object's
    // own port; 0 and up for subports).

    int  portHit;
    int  inputPort;
    int  portIndex;

    // Trigger indicating that the attached popup menu should be displayed.

    int  visible;

    //--------------- Outputs:

    // Flags indicating attributes of the object.  These can be used to
    // control the visibility of popup menu items.

    int  closable      = 0;
    int  openable      = 0;
    int  canShowParams = 0;
    int  reducable     = 0;
    int  maximizable   = 0;
    int  renamable     = 0;
    int  propsEditable = 0;
    int  finderValid   = 0;
    int  canAddIport   = 0;
    int  canAddOport   = 0;
    int  canExportPort = 0;
    int  canRemovePort = 0;
    int  deletable     = 0;

    // Method for handling changes to the objDispPtr subobject.

    cxxmethod+req  updateObjDisp (objDispPtr+read+notify+req);
};

//---------------------------------------------------------------------//

// This object contains data needed by the various NE UI objects.

group NEdataObj {

    //--------------- Inputs:

    // The UIwindow in which to display the main body of the network editor.

    UIwindow+req &parent {
        canHaveChildren = 1;
    };

    // The instance method adds a notify to the "window" subobject of the
    // parent's "handle" subobject.  But (on the NT version) the notify is
    // never called unless the handle is a reference to the actual handle.
    // (NOTE: This should be investigated and fixed).

    UIwinHandle  &handle => parent.handle;

    // The "externParent" object can be used for creating the network editor
    // as a child of a Widget (Unix) or HWND (Windows).  On Unix, the
    // Widget must be realized before the NEdataObj is created.  If both
    // externParent and parent are set, externParent is used.

#ifdef MSDOS
    int          externParent;
#else
    ptr          externParent;
#endif

    // The network editor can display up to two group objects.  If only one
    // object is to be displayed, it should be referenced by displayedObj.
    // If two objects are to be displayed, the "application" methods such
    // as NEload_app will operate on the object referenced by appObj.

    group *displayedObj;
    group *appObj;

    // Height of the upper object pane (if two objects are displayed).

    float        paneHeight;

    // A list of application templates.  These can be used in a
    // "New Application" pulldown menu.

    group        *appList;

    // inObjectEditor should be set to 1 when creating an NEdataObj inside
    // an Object Editor dialog.  In the object editor, the editedObj is
    // highlighted.

    int    inObjectEditor;
    group  *editedObj;

    //--------------- Triggers:

    // Trigger for displaying the object editor.
    // NB:  There is a LOT of work to be done here

    int  displayObjectEditor = 0;

    //--------------- Outputs:

    // Pointer to NEshell_info data structure.

    ptr          shellInfo;

    // Version/copyright string.

    string       versionString;

    // String containing current status information.

    string       statusString;

    // Info/error dialog box message and visibility flag.

    string       dialogString;
    int          dialogVisible;

    // State objects which can be used to control the graying of menu items.

    int          deletable       = 0;
    int          loadable        = 0;
    int          anySelection    = 0;
    int          singleSelection = 0;
    int          renamable       = 0;
    int          propsEditable   = 0;
    int          bufferOK        = 0;
    int          bufferNonempty  = 0;
    int          duplicatable    = 0;
    int          finderOK        = 0;
    int          sourceEditable  = 0;
    int	         reloadable      = 0;
    int	         appExists       = 0;

    // The current project directory and editability state.

    string       projectDir;
    int	         projectEditable = 0;
    int	         projectSavedCompileable = 0;

    // The path-names of the list of currently selected NE objects
    string	 curObjList[];

#ifdef ACKIT
    // This is a list of pathnames that are significant to AVS
    AC_UTIL.Utilities.paths AVSpaths;
#endif // ACKIT

    // Instance and delete methods for this object.
    int dummy;

    omethod+notify_inst+notify+read inst<status=0,interruptable=0>
			(appObj, displayedObj, handle.window)
			= "NEdata_obj_inst";
    // Method to be called when resize change events occur
    // call after inst method with weight property
    omethod+notify+read update_window<status=0,weight=2>(handle.event) = 
			"NEwin_handle_resize";
    omethod updateEditedObj<weight=3>(editedObj+notify+read) =
                        "NEupdate_edited_obj";
    omethod+notify_deinst delete<status=0,interruptable=0>(dummy) =
			"NEdata_obj_delete";
};

//---------------------------------------------------------------------//

// This object contains a list of UIcmds that correspond to the subobjects
// of a given parent object.  This can be used in a "New Application"
// pulldown menu.

group NEsubobjCmdList {
    group                *parent;
    int                  numSubs;
    UIcmd                subCmds[numSubs];
    string               messageFormat;
    group                *selectedObj;
    omethod+notify_inst  init<status=0,interruptable=0> = 
			"NEsubobj_cmd_list_init";
    omethod+notify_val   update<status=0,interruptable=0> =
			"NEsubobj_cmd_list_update";
};

//---------------------------------------------------------------------//

// This object contains subobjects that control the UI builder.

group NEuiBuilderObj {

    UIlayoutEditState layout {
        saveCurrentShellValues = 1;
    };
};

//---------------------------------------------------------------------//

// Modules used by the object editor.  (Actually, these should probably be
// defined in a separate V file).

flibrary OE {
   module edit_control {
      string+read+notify current_obj;
      int+read+notify edit_current;
      string+read+write+notify disp_obj_path;
      string+read+write+notify edit_obj_path;
      group+write *edit_obj_out<edit_ref=1>;
      group+write *disp_obj_out<edit_ref=1>;
      int+read disable_current_obj;
      int+read+notify closed;
      omethod+notify_inst control_update<status=0> = "OEedit_control_update";
   };
   module edit_general {
      group+notify+read *edit_obj;
      group+notify+read *disp_obj;

      string+notify+read+write name, dims, conn, value;
      boolean+notify+read+write array;
      int+notify+read+write ref_mode;
      int+notify+read+write base_type;
      int+notify+read+write export, input_port, output_port;

      int+write array_active;
      int+write ref_mode_active;
      int+write base_type_active;
      int+write conn_active;
      int+write value_active;

      int+read+notify copy_to, merge_to;

      omethod+notify_inst update<status=0> = "OEedit_general_update";
   };
   module edit_parameter {
      group+notify+read *edit_obj;
      group+notify+read *disp_obj;
      boolean+write panel_active;

      string+write method_list[];

      int+notify+read+write method;
      boolean+notify+read+write read_state, write_state, notify_state, 
				req_state;

      boolean+write atts_active;
      boolean+write mult_meths;

      omethod+notify_inst update<status=0> = "OEedit_parameter_update";
   };
   module edit_method {
      group+notify+read *edit_obj;
      int+write panel_active;

      string+notify+read+write name;

      boolean+notify+read+write notify_inst_state, notify_deinst_state;
      boolean+notify+read+write req_state;

      boolean+notify+read+write specific_params;

      int+notify+read+write weight;

      string+notify+read+write meth_value;

      boolean+notify+read+write interruptable, status;

      boolean+notify+read+write no_meth_ctx;

      int+write method_type;

      int valid => (method_type == 1 || is_valid(meth_value));

      omethod+notify_inst update<status=0> = "OEedit_method_update";
   };
   module edit_library {
      group+notify+read *edit_obj;
      int+write panel_active;

      boolean+notify+read+write global_state, sort_state;

      omethod+notify_inst update = "OEedit_library_update";
   };
   module edit_module {
      group+notify+read *edit_obj;
      int+write panel_active;

      string+notify+read+write name;

      omethod+notify_inst update = "OEedit_module_update";
   };

   module add_object {
      // Two ways to set the parent either by a path name or a link to an
      // object
      string+read parent_path;
      link+read parent_obj;
      int+read+req mode;// 0 = new base type, 1 = derived copy, 
			// 2 = distinct copy, 3 = edit existing
      string+read base_type_name;
      string+read new_name;
      string+read copy_path;
      int+read special;

      string+write new_path;
      int+write error;
      int+write done;
      int+read+notify+req do;
      omethod+req update = "OEadd_object";
   };

   module destroy_object {
      link+read destroy_obj;
      int+read+notify+req do;
      omethod+req update = "OEdestroy_object";
   };

   module prop_group {
      // Two ways to set the parent either by a path name or a link to an
      // object
      string+read+notify edit_path;
      int+write prop_group;
      omethod update<status=0> = "OEprop_group_update";
   };
   module edit_file_variable {
	group+notify+read *edit_obj;
	boolean+notify+read    trigger;
	boolean+notify+read+write cache;
	string+notify+read+write file_name;
	string+notify+read+write offset;
	int+notify+read+write type;
	int+notify+read+write ncolumns;
	int+notify+read+write columns[ncolumns];
	boolean+read+write is_array;
	boolean+read+write connect;
	int+notify+read+write ascii_binary;
	int+notify+read+write stride;
	string+write  variables[];
	boolean+write panel_active;
	omethod+notify_inst update<val_state=2> = "OEedit_file_variable_update";
   };
   module edit_file_offset {
	group+notify+read *edit_obj;
	boolean+notify+read+write cache;
	string+notify+read+write file_name;
	string+notify+read+write offset;
	string+notify+read+write operand;
	int+notify+read+write operation;
	boolean+write connect;
	string+write  variables[];
	boolean+write panel_active;
	omethod+notify_inst update<val_state=2> = "OEedit_file_offset_update";
   };

   module edit_mesh {
	group+notify+read *edit_obj;
	int+notify+read+write mesh_type;
	string+notify+read+write nspace;
	string+notify+read+write nnodes;
	string+notify+read+write ndim;
	string+notify+read+write dims;
	string+notify+read+write points;
	string+notify+read+write coordinates;
	int+notify+read+write add_node_data;
	int+notify+read+write add_cell_data;

	boolean+notify+read add_ports;

	boolean+notify+write ndim_active;
	boolean+notify+write nnodes_active;
	boolean+notify+write dims_active;
	boolean+notify+write points_active;
	boolean+notify+write coordinates_active;
	boolean+notify+write add_node_data_active;
	boolean+notify+write add_cell_data_active;
	boolean+write panel_active;
	omethod+notify_inst update<val_state=2> = "OEedit_mesh_update";
   };

   module edit_cell_set {
	group+notify+read *edit_obj;

	int+notify+read mesh_type;
	int+notify+read+write ncell_sets;
	int+notify+read+write cell_set;
	int+notify+read+write cell_type;

	int+notify+read+write is_cell_set;

	string+notify+read+write name;

	int+notify+read+write poly_flag;
	string+notify+read+write ncells;
	string+notify+read+write connect_list;

	string+notify+read+write poly_nnodes;
	string+notify+read+write concave_flag;

	boolean+notify+read add_ports;

	boolean+notify+write ncell_sets_active;
	boolean+notify+write cell_set_active;
	boolean+notify+write cell_type_active;
	boolean+notify+write name_active;
	boolean+notify+write ncells_active;
	boolean+notify+write connect_list_active;
	boolean+notify+write poly_nnodes_active;
	boolean+notify+write concave_flag_active;

	boolean+write panel_active;

	omethod+notify_inst update<val_state=2> = "OEedit_cell_set_update";
    };

    module edit_node_data {
	group+notify+read *edit_obj;

	int+notify+read mesh_type;

	int+notify+read+write nnode_data;
	int+notify+read+write node_data;
	int+notify+read+write veclen;
	int+notify+read+write data_type;
	int+notify+read+write data_id;
	string+notify+read+write labels;
	string+notify+read+write values;

	boolean+notify+read add_ports;

	boolean+notify+write node_data_active;

	boolean+write panel_active;

	omethod+notify_inst update<val_state=2> = "OEedit_node_data_update";
   };

    module edit_cell_data {
	group+notify+read *edit_obj;

	int+notify+read mesh_type;

	int+notify+read+write set_template;
	int+notify+read+write ncell_data;
	int+notify+read+write cell_data;
	int+notify+read+write veclen;
	int+notify+read+write data_type;
	int+notify+read+write data_id;
	string+notify+read+write labels;
	string+notify+read+write values;

	boolean+notify+read add_ports;

	boolean+notify+write cell_data_active;

	boolean+write panel_active;

	omethod+notify_inst update<val_state=2> = "OEedit_cell_data_update";
   };

   module add_file_variable {
      group+notify+read *edit_obj;
      boolean+notify+read add_variable;
      boolean+notify+read add_offset;

      string+write   new_obj_path;
      int+write variable_created;
      int+write offset_created;
      int+write panel_active;

      omethod+notify_inst update<val_state=2> = "OEadd_file_variable_update";
   };

   module add_file_module {
      string+read+req parent_path;
      string+read name;
      boolean+read add_browser;
      string+read default_dir;
      string+read default_suffix;

      string+read file_string = "FILE.file FILE;";
      string+read ui_string => 
"macro UI {
	UImod_panel UImod_panel {
	    title => name_of(<-.<-.<-);
	    parent<NEportLevels={3,0}>;
	};
	UIlabel Filename {
	    parent => <-.UImod_panel;
	    y = 0;
	    width => 200;
	    alignment = 0;
	};
	UItext file_name {
	    parent => <-.UImod_panel;
	    y => Filename.y + Filename.height + 5;
	    text => <-.<-.FILE.name;
	    width = 170;
            showLastPosition = 1;
	};
	UIbutton browse_button {
	    parent => <-.UImod_panel;
	    x => file_name.x + file_name.width + 5;
	    y => file_name.y;
	    width = 75;
	    height => <-.file_name.height;
	    label = \"Browse...\";
	};
	UIfileSB file_browser {
	    GMOD.copy_on_change copy_on_change {
		trigger => <-.<-.browse_button.do;
		input => <-.<-.browse_button.do;
		output => <-.visible;
	    };
	    title = \"Filename\";
	    filename => <-.<-.FILE.name;
	    searchPattern = \"" + default_dir + "/*." + default_suffix + "\";"+
	"};
};";
      string+write new_obj_path;
      int+write error;
      int+read+notify+req do;
      int+write done;

      omethod+req update<val_state=2> = "OEadd_file_module_update";
   };

   module check_module_parent {
      string+read parent_path;
      int+read active;
      int+notify+read trigger;
      int+write invalid_parent_error;
      int+write inactive_error;
      int+write done;
      omethod+req update = "OEcheck_module_parent_update";
   };

   module edit_source <
      cxx_members = <"
         OMobj_id  ref_obj;
	 void update_property();
	 void update_build_path();
      ">,
      use_src_file = 0
   >
   {

      // Inputs:

      group   *edit_obj;
      int     process;
      string  source_file;
      int     edit_file;
      int     compile_process;
      string  property_name;

      // Outputs:

      int     num_processes => array_size(process_names);
      string  process_names[];
      int     panel_active;
      int     edit_src_active;
      string  project_dir;
      string  build_path;

      // Inputs/Outputs
      string  property_value;

      // Methods:

      cxxmethod+notify_inst set_object(edit_obj+notify+read,
                                       process_names+write,
                                       process+write,
                                       source_file+write,
				       panel_active+write,
				       edit_src_active+write,
				       build_dir+write,
				       property_value+write);
      cxxmethod  set_process(process+notify+read);
      cxxmethod  set_source_file(source_file+notify+read);
      cxxmethod  set_edit_file(edit_file+notify+read);
      cxxmethod  set_compile_process(compile_process+notify+read);
      cxxmethod  set_property(property_name+read+notify,
			      property_value+read+notify+write);
      cxxmethod  set_project_dir(project_dir+notify+read);
   };

   group op_state {
      string  enter_commands;
      string  exit_commands;
      string  cancel_commands;
      string  close_commands;
   };

   module op_control <
      cxx_members = <"
         int   running;
         int   state;
         void  process_transition(const char *transition, int state);
      ">,
      use_src_file = 0
   >
   {
      // Inputs:

      group     *relative;           // Object to which commands are relative
      op_state  module_state;        // Commands for the module itself
      int       num_states;
      op_state  states[num_states];  // Commands for each state
      int       disabled = 0;        // Prevents triggers from firing

      int       begin, back, next, cancel, close;  // State transition triggers

      // Outputs:

      int  first_state = 0;  // Indicates current state is first one
      int  last_state = 0;   // Indicates current state is last one
      int  done = 0;         // Indicates last state was exited via "next".

      // Methods:

      cxxmethod+notify_inst inst;

      cxxmethod  set_begin  <weight=2> (begin+notify+read);
      cxxmethod  set_back   <weight=2> (back+notify+read);
      cxxmethod  set_next   <weight=2> (next+notify+read);
      cxxmethod  set_cancel <weight=2> (cancel+notify+read);
      cxxmethod  set_close  <weight=2> (close+notify+read);
   };
}; // flibrary OE

//---------------------------------------------------------------------//

module NEapp_select {
   int+read viewer_type;
   int+read app_type;
   int+read wiz_di = 0;
   int+read wiz_dv = 0;
   int+read+notify ok;
   int+write load_app;
   int+read save_default;
   int+read+nres screenwidth;
   int+read+nres screenheight;
   group+read *to_destroy;
   cxxmethod update<val_state=2> = <"
      if (app_type == 5) {
	 load_app = 1;
      }
      else {
	 OMobj_id app_id, view_id;
	 static const char *app_paths[] = 
	    {"APPS.SingleWindowApp", "APPS.MultiWindowApp",
	     "APPS.DefaultApplication", "APPS.ModuleStack", "APPS.ScratchPad"};
	 static const char *view_paths[] = 
	    {"GDM.Uviewer3D", "GDM.Uviewer2D", "GDM.Uviewer"};
	 static const char *wiz_paths[] = 
	    {"WIZARD.data_import_wizard", "WIZARD.data_visualization_wizard"};

	 if (app_type < 5) {
	    app_id=OMcreate_obj_from_path(app_paths[app_type],NULL,OMinst_obj);
	    if (!OMis_null_obj(app_id) && viewer_type < 3 && app_type < 2) {

	       OMobj_id width_id, height_id;
	       int sw, sh;

	       view_id = OMcreate_obj_from_path(view_paths[viewer_type],NULL,
					     app_id);

	       width_id = screenwidth.obj_val();
	       if (OMget_int_val(width_id, &sw) != 1)
		 sw = 300;
	       else
		 sw = (sw * 2) / 3 - 250;

	       height_id = screenheight.obj_val();
	       if (OMget_int_val(height_id, &sh) != 1)
		 sh = 200;
	       else
		 sh = (sh * 5) / 6 - 400;

	       OMset_obj_iprop(view_id, NE_name_NEx, sw);
	       OMset_obj_iprop(view_id, NE_name_NEy, sh);
	    }
	    OMset_obj_sprop(app_id, NE_name_NEdisplayMode, "maximized");
	 }
	 else app_id = OMnull_obj;

	 if (app_type < 4 && !OMis_null_obj(app_id)) {
             if( wiz_di ) {
                 OMcreate_obj_from_path(wiz_paths[0], NULL, app_id);
             }
             if( wiz_dv ) {
                 OMcreate_obj_from_path(wiz_paths[1], NULL, app_id);
             }
         }

	 /* Write out this application as inst.v in the local project */
	 if (save_default) {
	    FILE *fp;
	    char buf1[AVS_PATH_MAX], buf2[AVS_PATH_MAX];
	    char *file;

	    if (OMis_defined("VIZ_EXPRESS"))
	       file = FILEconcat_dir_and_file(OMget_path_index(OM_VPATH,0,buf1),
					"vxp_inst.v",buf2);
	    else
	       file = FILEconcat_dir_and_file(OMget_path_index(OM_VPATH,0,buf1),
					"inst.v",buf2);

	    if (OMcheck_gen_hdr(file) == 0) {
	       ERRverror("NEapp_select",ERR_ORIG,
	 "Unable to set default application. file %s is in the way",file);
	       return(1);
	    }

	    /*
	     * Create an empty file for the "None" case 
	     */
	    if (OMis_null_obj(app_id)) {
	       fp = FILEfopen(file,"w");
	       OMwrite_gen_hdr(fp,"/*","*/");
	       fclose(fp);
	    }
	    else {
	       OMwrite_obj(app_id,file,OM_WRITE_GEN_HDR);
	    }
	 }
      }

      // probably should be a separate module?
      OMobj_id destroy_id;
      destroy_id = to_destroy.obj_val();
      if (!OMis_null_obj(destroy_id))
         OMuser_destroy_obj(destroy_id);

      return(1);
   ">;
};

//---------------------------------------------------------------------//

// Trigger objects used by NE menu items and dialog buttons.

library TriggerFuncs<compile_subs=0> {

group NEgroupPtrTriggerFunc {
    group  *trigger;
    omethod+notify_val  func<status=0,interruptable=0> = "OMomethod_notset";
};

group NEintTriggerFunc {
    int  trigger;
    omethod+notify_val  func<status=0,interruptable=0> = "OMomethod_notset";
};

group NEstringTriggerFunc {
    string  trigger;
    omethod+notify_val  func<status=0,interruptable=0> = "OMomethod_notset";
};

}; // flibrary TriggerFuncs

//---------------------------------------------------------------------//

// An object that allows installation of the NE hourglass cursor.

group NEhourglass {

    NEdataObj &dataObj;
    int       install;

    NEintTriggerFunc triggerFunc {
        trigger => install;
        func = "NEhourglass_install";
    };
};

//---------------------------------------------------------------------//

// Definition of dialog box for setting the initial application.

// We want the shell to be high enough to allow all of its children to be
// visible.  For now, we have to add a margin on the PC to account for the
// shell title bar.

#ifdef MSDOS
#define EXTRA_SHELL_HEIGHT 50
#else
#define EXTRA_SHELL_HEIGHT 0
#endif

// Correction for button area in UItemplateDialog:

#ifdef MSDOS
#define TEMPLATE_BUTTONS_HEIGHT 20
#else
#define TEMPLATE_BUTTONS_HEIGHT 50
#endif

macro NEappSelectDialog {

    NEdataObj &dataObj;

    // TEMPORARY HACK: Force this to connect to the NE dataObj...
    dataObj+nres => NetworkEditor.dataObj;

    // The initial dialog shell width is fixed, and the height is large
    // enough to accommodate all of its children.

    UItemplateDialog shell {
#ifndef MSDOS // Work around bug in dialog placement
        parent => dataObj.parent;
#endif
        width = 450;
        height => <-.panel.y + <-.panel.height +
                  EXTRA_SHELL_HEIGHT + TEMPLATE_BUTTONS_HEIGHT;
        title = "NE_SHELL_TITLE";
        visible = 1;
        okButton = 1;
        cancelButton = 0;
    };

    UIpanel panel {
        parent => <-.shell;
        x = 0;
        y = 0;
        width => <-.shell.clientWidth;
        height => switch(<-.defaultMessage.visible + 1,
                         <-.saveDefault.y + <-.saveDefault.height,
                         <-.defaultMessage.y + <-.defaultMessage.height);
    };

    UIlabel title {
        label = "NE_INIT_TITLE";
        parent => <-.panel;
        x = 0;
        y = 5;
        width => <-.panel.clientWidth - x;
        alignment = 1;
    };

    // This frame's height is determined by the height of its
    // UIradioBox child.

    UIframe appFrame {
        parent => <-.panel;
        x => 5;
        y => <-.title.y + <-.title.height + 5;
        width => (<-.panel.clientWidth - 15) / 2;
        height => <-.appBox.y + <-.appBox.height + (2 * shadowThickness);
        shadowType = "shadow_etched_in";
        shadowThickness = 3;
    };

#ifdef RADIO_BOX_LABEL_FIXED

    UIradioBoxLabel appBox {
        parent => <-.appFrame;
        x = 0;
        y = 0;
        width => <-.appFrame.clientWidth - 3;
        title = "NE_INIT_APPBOX_TITLE";
        labels = { "NE_INIT_SINGLE_DV",
                   "NE_INIT_MULTI_DV",
                   "NE_INIT_APP",
                   "NE_INIT_MODSTACK",
                   "NE_INIT_SCRATCHPAD",
                   "NE_INIT_LOAD_APP",
                   "NE_INIT_NONE"};
	selectedItem => switch(Templates.CONFIG.viz_express + 1, 0, 1);
    };

#else

    UIlabel appLabel {
        label = "NE_INIT_APPBOX_TITLE";
        parent => <-.appFrame;
        x = 0;
        y = 5;
        width => <-.appFrame.clientWidth;
        alignment = 1;
    };

    UIradioBox appBox {
        parent => <-.appFrame;
        x = 0;
        y => <-.appLabel.y + <-.appLabel.height + 5;
        width => <-.appFrame.clientWidth - 3;
        cmdList => { <-.singleAppOption,
                     <-.multiAppOption,
                     <-.applicationAppOption,
                     <-.moduleStackAppOption,
                     <-.scratchPadAppOption,
                     <-.loadAppOption,
                     <-.noneAppOption };
	selectedItem => switch(Templates.CONFIG.viz_express + 1, 0, 1);
    };

    UIoption singleAppOption {
        label = "NE_INIT_SINGLE_DV";
    };

    UIoption multiAppOption {
        label = "NE_INIT_MULTI_DV";
    };

    UIoption applicationAppOption {
        label = "NE_INIT_APP";
    };

    UIoption moduleStackAppOption {
        label = "NE_INIT_MODSTACK";
    };

    UIoption scratchPadAppOption {
        label = "NE_INIT_SCRATCHPAD";
    };

    UIoption loadAppOption {
        label = "NE_INIT_LOAD_APP";
    };

    UIoption noneAppOption {
        label = "NE_INIT_NONE";
    };

#endif

    // This frame's height is determined by the height of its
    // UIradioBox child.

    UIframe viewerFrame {
        parent => <-.panel;
        x => <-.appFrame.x + <-.appFrame.width + 5;
        y => <-.appFrame.y;
        width => <-.appFrame.width;
        height => <-.appFrame.height;
        shadowType = "shadow_etched_in";
        shadowThickness = 3;
    };

#ifdef RADIO_BOX_LABEL_FIXED

    UIradioBoxLabel viewerBox {
        parent => <-.viewerFrame;
        x = 0;
        y = 0;
        width => <-.viewerFrame.clientWidth - 3;
        title = "NE_INIT_VIEWBOX_TITLE";
        labels = { "NE_INIT_3D",
                   "NE_INIT_2D",
                   "NE_INIT_3D_2D",
                   "NE_INIT_NONE" };
        active => (<-.appBox.selectedItem <= 1);
	selectedItem => switch(Templates.CONFIG.viz_express + 1, 0, 2);
    };

#else

    UIlabel viewerLabel {
        label = "NE_INIT_VIEWBOX_TITLE";
        parent => <-.viewerFrame;
        x = 0;
        y = 5;
        width => <-.viewerFrame.clientWidth;
        alignment = 1;
        active => (<-.appBox.selectedItem <= 1);
    };

    UIradioBox viewerBox {
        active => <-.viewerLabel.active;
        parent => <-.viewerFrame;
        x = 0;
        y => <-.viewerLabel.y + <-.viewerLabel.height + 5;
        width => <-.viewerFrame.clientWidth - 3;
        cmdList => { <-.threeDViewerOption,
                     <-.twoDViewerOption,
                     <-.threeDAndTwoDViewerOption,
                     <-.noViewerOption };
	selectedItem => switch(Templates.CONFIG.viz_express + 1, 0, 2);
    };

    UIoption threeDViewerOption {
        label = "NE_INIT_3D";
        active => <-.viewerLabel.active;
    };

    UIoption twoDViewerOption {
        label = "NE_INIT_2D";
        active => <-.viewerLabel.active;
    };

    UIoption threeDAndTwoDViewerOption {
        label = "NE_INIT_3D_2D";
        active => <-.viewerLabel.active;
    };

    UIoption noViewerOption {
        label = "NE_INIT_NONE";
        active => <-.viewerLabel.active;
    };

#endif

    UIframe wizardFrame {
        parent => <-.panel;
        x => appFrame.x;
        y => appFrame.y + appFrame.height + 5;
        width => panel.clientWidth - (2 * x);
        height => <-.wizDV.y + <-.wizDV.height + 6;
        shadowType = "shadow_etched_in";
        shadowThickness = 3;
    };
    UItoggle wizDI {
        x = 5;
        y = 5;
        width => .parent.clientWidth;
        parent => <-.wizardFrame;
        label = "NE_INIT_DI_WIZ";
        active => (<-.appBox.selectedItem < 4);
    };
    UItoggle wizDV {
        x = 5;
        y => <-.wizDI.y + <-.wizDI.height;
        width => .parent.clientWidth;
        parent => <-.wizardFrame;
        label = "NE_INIT_DV_WIZ";
        active => (<-.appBox.selectedItem < 4);
    };

   UItoggle saveDefault {
      parent => <-.panel;
      active => dataObj.projectEditable && appBox.selectedItem != 5;
      x = 10;
      //y => appFrame.y + appFrame.height + 5;
      y => wizardFrame.y + wizardFrame.height + 7;
      width => panel.clientWidth - (2 * x);
      label = "NE_INIT_DEF_APP";
   };
   UIlabel defaultMessage {
      parent => <-.panel;
      visible => !dataObj.projectEditable;
      x = 5;
      y => saveDefault.y + saveDefault.height;
      width => panel.clientWidth - (2 * x);
      label = "NE_INIT_USE_SAVE";
      alignment = 0;
   };

   // This object installs the hourglass cursor when the OK button is pressed.
   // NOTE: We have to increase the priority of this object's method to prevent
   // the object from being destroyed by the NEapp_select object before it
   // is run.

   NEhourglass hourglass {
      dataObj => <-.dataObj;
      install => shell.ok;
      triggerFunc.func <weight=0>;
   };

   NEapp_select app_select {
      viewer_type => viewerBox.selectedItem;
      app_type => appBox.selectedItem;
      wiz_di   => wizDI.set;
      wiz_dv   => wizDV.set;
      ok => shell.ok;
      save_default => saveDefault.set;
      // 
      // Just connect this up to the load app item in the ne
      //
      load_app+nres => NetworkEditor.fileMenu.loadAppItem.cmd.do;
      to_destroy => <-.<-;
      screenwidth => UIdata.UIdisplays[0].width;
      screenheight => UIdata.UIdisplays[0].height;
   };
   // 
   // Just want them to know that we are running first
   //
   GMOD.parse_v LowerWindow {
      on_inst = 0;
      trigger => shell.ok;
      parse_v_relative<weight=0>;
      relative => <-;
      v_commands = "shell.visible = 0;";
   };
};

//---------------------------------------------------------------------//

// Version of app select dialog that appears when "New Application"
// is selected.

NEappSelectDialog NEnewAppDialog {

    shell {
        title = "NE_INIT_NEW_APP";
        visible = 0;
        cancelButton = 1;
    };

    title.label = "NE_INIT_CHOOSE_APP";

#ifdef RADIO_BOX_LABEL_FIXED

    appBox.labels = { "NE_INIT_SINGLE_DV",
                      "NE_INIT_MULTI_DV",
                      "NE_INIT_APP",
                      "NE_INIT_MODSTACK",
                      "NE_INIT_SCRATCHPAD" };

#else

    appBox.cmdList => { <-.singleAppOption,
                        <-.multiAppOption,
                        <-.applicationAppOption,
                        <-.moduleStackAppOption,
                        <-.scratchPadAppOption };

#endif

    app_select.to_destroy =>;
};

//---------------------------------------------------------------------//

module NEsave_proj_subset <use_src_file=0> {
   string path_name;
   int do_it;
   int save_app = 0;	/* Save current application instead of current objs */
   int inst_on_restore = 1; /* OM_PROJECT_TEMPLS_ONLY */
   int save_ne =0; /* include the network editor with the V code */
   int build_v_into_exec = 0;  /* OM_PROJECT_APP_FILE */
   int compile_project = 1; /* Build the project */
#ifdef MSDOS
   int include_ole = 0; /* Build the project into an ocx */
   int compile_project_as_ocx = 0; /* Build the project into an ocx */
#endif
   int compile_project_as_plugin = 0; /* Build as netscape plugin */
   int compile_plugin = 0; /* Compile the netscape plugin */
   int generate_source = 1; /* Generate the source */
   string status = ""; /* set to indicate the current status */
   int done; /* set only when we've really done the deed... */
   cxxmethod+req update(do_it+notify+req,path_name+nonotify,status+write,
			done+write);
};

//---------------------------------------------------------------------//

// Definition of dialog box for saving a compiled project.

macro NEsubsetDialog {

   // Include an object that performs the dialog's actions.

   NEsave_proj_subset saveObj;

   // The initial dialog shell width is fixed, and the height is large
   // enough to accommodate all of its children.  The children will be
   // laid out vertically, and their widths will be tied to the width
   // of the shell.

   UIshell shell {
      width = 400;
      height => <-.buttonPanel.panel.y + <-.buttonPanel.panel.height + 10 +
                EXTRA_SHELL_HEIGHT;
      title = "NE_CMPPROJ_TITLE";
      showStatusBar = 0;
   };

   macro dirPanel {

      UIpanel panel {
         parent<NEportLevels={3,0}> => <-.<-.shell;
         x = 10;
         y = 10;
         width => <-.<-.shell.clientWidth - 20;
         height => <-.dirText.y + <-.dirText.height;
      };

      UIlabel dirLabel {
         parent => <-.panel;
         x = 0;
         y = 0;
         width => <-.panel.width;
         height = 15;
         alignment = 0;
         label = "NE_CMPPROJ_DIRNAME";
      };

      UItext dirText {
         parent => <-.panel;
         x = 0;
         y => <-.dirLabel.y + <-.dirLabel.height + 10;
         width => <-.dirButton.x - 10;
         height = 35;
         updateMode = 2;
         text => saveObj.path_name;
      };

      UIbutton dirButton {
         parent => <-.panel;
         x => <-.panel.width - 80;
         y => <-.dirText.y;
         width = 80;
         height => <-.dirText.height;
         label = "NE_CMPPROJ_BROWSE";
         do => <-.dirDialog.visible;
      };

      UIfileDialog dirDialog {
         parent => <-.panel;
         title = "NE_CMPPROJ_TITLE";
         filename => saveObj.path_name;
         typeMask = "directory";
      };
   };

   macro radioFrame {

      // This frame's height is determined by the height of its
      // UIradioBox child.

      UIframe frame {
         parent<NEportLevels={3,0}> => <-.<-.shell;
         x = 10;
         y => <-.<-.dirPanel.panel.y + <-.<-.dirPanel.panel.height + 10;
         width => <-.<-.shell.clientWidth - 20;
         height => <-.radioBox.height + (2 * shadowThickness);
         shadowType = 2;
         shadowThickness = 3;
      };

      UIradioBox radioBox {
         parent => <-.frame;
         cmdList => {<-.saveObjsOption,
            <-.saveAppOption};
         x = 0;
         y = 0;
         width => <-.frame.clientWidth;
         selectedItem => saveObj.save_app;
      };

      UIoption saveObjsOption {
         label = "NE_CMPPROJ_SELECTED";
      };

      UIoption saveAppOption {
         label = "NE_CMPPROJ_CURR_APP";
      };
   };

   macro optionFrame {

      // This frame's height is determined by the height of its
      // UIoptionBox child.

      UIframe frame {
         parent<NEportLevels={3,0}> => <-.<-.shell;
         x = 10;
         y => <-.<-.radioFrame.frame.y + <-.<-.radioFrame.frame.height + 10;
         width => <-.<-.shell.clientWidth - 20;
         height => <-.optionBox.height + (2 * shadowThickness);
         shadowType = 2;
         shadowThickness = 3;
      };

      UIoptionBox optionBox {
         parent => <-.frame;
         cmdList => switch(is_valid(getenv("XP_PLUGIN_GEN")) + 1,
                           {<-.instObjsOption,
                            <-.saveNEOption,
                            <-.buildVOption,
                            <-.compProjOption,
#ifdef MSDOS
	                    //<-.includeOLEOption,
                            //<-.compProjOCXOption,
#endif
                            <-.genSourceOption},
                           {<-.instObjsOption,
                            <-.saveNEOption,
                            <-.buildVOption,
                            <-.compProjOption,
#ifdef MSDOS
	                    //<-.includeOLEOption,
                            //<-.compProjOCXOption,
#endif
                            <-.compProjAsPluginOption,
                            <-.genSourceOption});
         x = 0;
         y = 0;
         width => <-.frame.clientWidth;
      };

      UIoption instObjsOption {
         label = "NE_CMPPROJ_INST_AUTO";
         set => saveObj.inst_on_restore;
      };

      UIoption saveNEOption {
         label = "NE_CMPPROJ_INCLUDE_NE";
         set => saveObj.save_ne;
      };

      UIoption buildVOption {
         label = "NE_CMPPROJ_BUILD_V";
         set => saveObj.build_v_into_exec;
      };

      UIoption compProjOption {
         label = "NE_CMPPROJ_COMPILE";
         set => saveObj.compile_project;
      };

#ifdef MSDOS
      UIoption includeOLEOption {
         label = "NE_CMPPROJ_INCLUDE_OLE";
         set => saveObj.include_ole;
      };

      UIoption compProjOCXOption {
         label = "NE_CMPPROJ_COMPILE_AS_OCX";
         set => saveObj.compile_project_as_ocx;
      };
#endif

      UIoption compProjAsPluginOption {
         label = "NE_CMPPROJ_COMPILE_AS_NNPLUGIN";
         set => saveObj.compile_project_as_plugin;
      };

      UIoption compPluginOption {
         label = "NE_CMPPROJ_COMPILE_NNPLUGIN";
         set => saveObj.compile_plugin;
      };

      UIoption genSourceOption {
         label = "NE_CMPPROJ_GEN_SOURCE";
         set => saveObj.generate_source;
      };
   };

   macro buttonPanel {

      UIpanel panel {
         parent<NEportLevels={3,0}> => <-.<-.shell;
         x = 10;
         y => <-.<-.optionFrame.frame.y + <-.<-.optionFrame.frame.height + 10;
         width => <-.<-.shell.clientWidth - 20;
         height => <-.statusLabel.y + <-.statusLabel.height;
      };

      UIbutton okButton {
         parent => <-.panel;
         x = 73;
         y = 0;
         width = 80;
         height = 30;
         label = "NE_OK";
         do => saveObj.do_it;
      };

      UIbutton cancelButton {
         parent => <-.panel;
         x = 227;
         y = 0;
         width = 80;
         height = 30;
         label = "NE_CANCEL";
         do => makeInvis.trigger;
      };

      UIlabel statusLabel {
         parent => <-.panel;
         x = 0;
         y => <-.okButton.y + <-.okButton.height + 5;
         width => <-.panel.width;
         height = 15;
         alignment = 0;
         label => saveObj.status;
      };
   };

   GMOD.copy_on_change makeInvis {
      trigger => saveObj.done;
      input = 0;
      output => shell.visible;
      on_inst = 0;
   };
};

//---------------------------------------------------------------------//

// Definition of dialog box for setting the project configuration.

macro NEprojConfigDialog {

    NEdataObj &dataObj;

    // Trigger for initializing the dialog.

    int init;

    // The initial dialog shell width is fixed, and the height is large
    // enough to accommodate all of its children.  The children will be
    // laid out vertically, and their widths will be tied to the width
    // of the shell.

    UItemplateDialog shell {
#ifndef MSDOS // Work around bug in dialog placement
        parent => dataObj.parent;
#endif
        width = 240;
        height => <-.panel.y + <-.panel.height +
                  EXTRA_SHELL_HEIGHT + TEMPLATE_BUTTONS_HEIGHT;
        title = "NE_CONF_TITLE";
        okButton = 1;
        cancelButton = 1;
    };

    UIpanel panel {
        parent => <-.shell;
        x = 0;
        y = 0;
        width => <-.shell.clientWidth;
        height => <-.kitFrame.y + <-.kitFrame.height + 5;
    };

    UIlabel kitLabel {
        label = "NE_CONF_KITS";
        parent => <-.panel;
        x = 5;
        y = 5;
        width => <-.panel.clientWidth - x;
        alignment = 0;
    };

    // This frame's height is determined by the height of its
    // lowest child.

    UIframe kitFrame {
        parent => <-.panel;
        x => <-.kitLabel.x;
        y => <-.kitLabel.y + <-.kitLabel.height + 5;
        width => <-.panel.clientWidth - (2 * x);
        height => <-.pstKitToggle.y + <-.pstKitToggle.height +
                  (2 * shadowThickness);
	height = 470; // inc for PST
        shadowType = 2;
        shadowThickness = 3;
    };

    UItoggle agKitToggle {
        label = "NE_CONF_AG";
#ifdef AG_KIT
        active = 1;
#else
        active = 0;
#endif
        parent => <-.kitFrame;
        x = 0;
        y = 0;
        width => <-.kitFrame.clientWidth;
    };

    UItoggle prtRendererToggle {
        label = "NE_CONF_PRT";
#ifdef PRT_RENDERER
        active = 1;
#else
        active = 0;
#endif
        parent => <-.kitFrame;
        x = 0;
        y => <-.agKitToggle.y + <-.agKitToggle.height;
        width => <-.kitFrame.clientWidth;
    };

    UItoggle vrmlRendererToggle {
        label = "NE_CONF_VRML";
#ifdef VRML_RENDERER
        active = 1;
#else
        active = 0;
#endif
        parent => <-.kitFrame;
        x = 0;
        y => <-.prtRendererToggle.y + <-.prtRendererToggle.height;
        width => <-.kitFrame.clientWidth;
    };

    UItoggle vpsRendererToggle {
        label = "NE_CONF_VPS";
#ifdef VPS_RENDERER
        active = 1;
#else
        active = 0;
#endif
        parent => <-.kitFrame;
        x = 0;
        y => <-.vrmlRendererToggle.y + <-.vrmlRendererToggle.height;
        width => <-.kitFrame.clientWidth;
    };

    UItoggle glRendererToggle {
        label = "NE_CONF_OGL";
#ifdef OGL_RENDERER
        active = 1;
#else
        active = 0;
#endif
        parent => <-.kitFrame;
        x = 0;
        y => <-.vpsRendererToggle.y + <-.vpsRendererToggle.height;
        width => <-.kitFrame.clientWidth;
    };

    UItoggle xglRendererToggle { // Now obsolete
        label = "NE_CONF_XGL";
        active = 0;
        visible = 0;
        //parent => <-.kitFrame;
        x = 0;
        y = 0;
        width => <-.kitFrame.clientWidth;
    };

    UItoggle pexRendererToggle { // Now obsolete
        label = "NE_CONF_PEX";
        active = 0;
        visible = 0;
        //parent => <-.kitFrame;
        x = 0;
        y = 0;
        width => <-.kitFrame.clientWidth;
    };

    UItoggle xilRendererToggle {
        label = "NE_CONF_XIL";
#ifdef XIL_RENDERER
        active = 1;
#else
        active = 0;
#endif
        parent => <-.kitFrame;
        x = 0;
        y => <-.glRendererToggle.y + <-.glRendererToggle.height;
        width => <-.kitFrame.clientWidth;
    };

    UItoggle animKitToggle {
        label = "NE_CONF_ANIM";
#ifdef ANIM_KIT
        active = 1;
#else
        active = 0;
#endif
        parent => <-.kitFrame;
        x = 0;
        y => <-.xilRendererToggle.y + <-.xilRendererToggle.height;
        width => <-.kitFrame.clientWidth;
    };

    UItoggle reductKitToggle {
        label = "Reduction Kit";
#ifdef REDUCT_KIT
        active = 1;
#else
        active = 0;
#endif
        parent => <-.kitFrame;
        x = 0;
        y => <-.animKitToggle.y + <-.animKitToggle.height;
        width => <-.kitFrame.clientWidth;
    };

    UItoggle netcdfKitToggle {
        label = "netCDF Kit";
#ifdef NETCDF_KIT
        active = 1;
#else
        active = 0;
#endif
        parent => <-.kitFrame;
        x = 0;
        y => <-.reductKitToggle.y + <-.reductKitToggle.height;
        width => <-.kitFrame.clientWidth;
    };

    UItoggle hdf5KitToggle {
        label = "HDF5 Kit";
#ifdef HDF5_KIT
        active = 1;
#else
        active = 0;
#endif
        parent => <-.kitFrame;
        x = 0;
        y => <-.netcdfKitToggle.y + <-.netcdfKitToggle.height;
        width => <-.kitFrame.clientWidth;
    };

    UItoggle ipKitToggle {
        label = "Image Processing Kit";
        active = 1;
        parent => <-.kitFrame;
        x = 0;
        y => <-.hdf5KitToggle.y + <-.hdf5KitToggle.height;
        width => <-.kitFrame.clientWidth;
    };

    UItoggle acKitToggle {
        label = "NE_CONF_AVS5";
#ifdef ACKIT
        active = 1;
#else
#ifdef AC_KIT_V1
        active = 1;
#else
        active = 0;
#endif
#endif
        parent => <-.kitFrame;
        x = 0;
        y => <-.ipKitToggle.y + <-.ipKitToggle.height;
        width => <-.kitFrame.clientWidth;
    };

    UItoggle cfdKitToggle {
        label = "CFD Kit";
        active = 1;
        parent => <-.kitFrame;
        x = 0;
        y => <-.acKitToggle.y + <-.acKitToggle.height;
        width => <-.kitFrame.clientWidth;
    };

    UItoggle gisKitToggle {
        label = "NE_CONF_GIS";
#ifdef GIS_KIT
        active = 1;
#else
        active = 0;
#endif
        parent => <-.kitFrame;
        x = 0;
        y => <-.cfdKitToggle.y + <-.cfdKitToggle.height;
        width => <-.kitFrame.clientWidth;
    };

    UItoggle w3cKitToggle {
        label = "NE_CONF_W3C";
#ifdef READ_URL
        active = 1;
#else
        active = 0;
#endif
        parent => <-.kitFrame;
        x = 0;
        y => <-.gisKitToggle.y + <-.gisKitToggle.height;
        width => <-.kitFrame.clientWidth;
    };

    UItoggle dbKitToggle {
        label = "NE_CONF_DB";
        active => Templates.UI_GLOBAL.DBoptions.DBKit;
        parent => <-.kitFrame;
        x = 0;
        y => <-.w3cKitToggle.y + <-.w3cKitToggle.height;
        width => <-.kitFrame.clientWidth;
    };

    UItoggle oracleToggle {
        label = "NE_CONF_ORACLE";
        active => (Templates.UI_GLOBAL.DBoptions.oracleKit &&
                   dbKitToggle.set && dbKitToggle.active);
        parent => <-.kitFrame;
        x = 0;
        y => <-.dbKitToggle.y + <-.dbKitToggle.height;
        width => <-.kitFrame.clientWidth;
    };

    UItoggle mavsKitToggle {
        label = "NE_CONF_MICROAVS";
#ifdef MAVS_KIT
        active = 1;
#else
        active = 0;
#endif
	visible => Templates.CONFIG.microavs_included;
        parent => <-.kitFrame;
        x = 0;
        y => <-.oracleToggle.y + <-.oracleToggle.height;
        width => <-.kitFrame.clientWidth;
    };

    UItoggle pstKitToggle {
        label = "NE_CONF_PST";
#ifdef PST_KIT
        active = 1;
#else
        active = 0;
#endif
        parent => <-.kitFrame;
        x = 0;
        y => <-.mavsKitToggle.y + <-.mavsKitToggle.height;
        width => <-.kitFrame.clientWidth;
    };
    UIinfoDialog configDoneDialog {
        title = "NE_CONF_TITLE";
        message = "NE_CONF_DONE_MSG";
        parent => dataObj.parent;
        cancelButton = 0;
        visible = 0;
    };

    // V commands to initialize and display the dialog.
    GMOD.parse_v configInit {
        trigger => init;
        relative => <-;
        on_inst = 0;
        v_commands =
            "agKitToggle.set = " +
            "agKitToggle.active && !Templates.CONFIG.ag_kit_disabled;" +
            "prtRendererToggle.set = " +
            "prtRendererToggle.active && !Templates.CONFIG.gd_prt_disabled;" +
            "vrmlRendererToggle.set = " +
            "vrmlRendererToggle.active && !Templates.CONFIG.gd_vrml_disabled;" +
            "vpsRendererToggle.set = " +
            "vpsRendererToggle.active && !Templates.CONFIG.gd_vps_disabled;" +
            "glRendererToggle.set = " +
            "glRendererToggle.active && !Templates.CONFIG.gd_gl_disabled;" +
            "xglRendererToggle.set = " +
            "xglRendererToggle.active && !Templates.CONFIG.gd_xgl_disabled;" +
            "pexRendererToggle.set = " +
            "pexRendererToggle.active && !Templates.CONFIG.gd_pex_disabled;" +
            "xilRendererToggle.set = " +
            "xilRendererToggle.active && !Templates.CONFIG.gd_xil_disabled;" +
            "animKitToggle.set = " +
            "animKitToggle.active && !Templates.CONFIG.anim_kit_disabled;" +
            "reductKitToggle.set = " +
            "reductKitToggle.active && !Templates.CONFIG.reduct_kit_disabled;" +
            "netcdfKitToggle.set = " +
            "netcdfKitToggle.active && !Templates.CONFIG.netcdf_kit_disabled;" +
            "hdf5KitToggle.set = " +
            "hdf5KitToggle.active && !Templates.CONFIG.hdf5_kit_disabled;" +
            "acKitToggle.set = " +
            "acKitToggle.active && !Templates.CONFIG.ac_kit_disabled;" +
            "ipKitToggle.set = " +
            "ipKitToggle.active && !Templates.CONFIG.ip_kit_disabled;" +
            "mavsKitToggle.set = " +
            "mavsKitToggle.active && !Templates.CONFIG.mavs_kit_disabled;" +
            "cfdKitToggle.set = " +
            "cfdKitToggle.active && !Templates.CONFIG.cfd_kit_disabled;" +
            "gisKitToggle.set = " +
            "gisKitToggle.active && !Templates.CONFIG.gis_disabled;" +
            "w3cKitToggle.set = " +
            "w3cKitToggle.active && !Templates.CONFIG.w3c_disabled;" +
            "dbKitToggle.set = " +
            "dbKitToggle.active && !Templates.CONFIG.db_kit_disabled;" +
            "oracleToggle.set = " +
            "oracleToggle.active && !Templates.CONFIG.db_oracle_disabled;" +
            "pstKitToggle.set = " +
            "pstKitToggle.active && !Templates.CONFIG.pst_kit_disabled;" +
            "shell.visible = 1;";
    };

    // V commands to be executed when the dialog's OK button is pressed.
    GMOD.parse_v configOK {
        trigger => shell.ok;
        relative => <-;
        on_inst = 0;
        v_commands =>
            "configDoneDialog.visible               = 1;" +
            "Templates.CONFIG.ag_kit_disabled       = " + !agKitToggle.set +
            ";Templates.CONFIG.gd_prt_disabled      = " + !prtRendererToggle.set +
            ";Templates.CONFIG.gd_vrml_disabled     = " + !vrmlRendererToggle.set +
            ";Templates.CONFIG.gd_vps_disabled      = " + !vpsRendererToggle.set +
            ";Templates.CONFIG.gd_gl_disabled       = " + !glRendererToggle.set +
            ";Templates.CONFIG.gd_xgl_disabled      = " + !xglRendererToggle.set +
            ";Templates.CONFIG.gd_pex_disabled      = " + !pexRendererToggle.set +
            ";Templates.CONFIG.gd_xil_disabled      = " + !xilRendererToggle.set +
            ";Templates.CONFIG.anim_kit_disabled    = " + !animKitToggle.set +
            ";Templates.CONFIG.reduct_kit_disabled  = " + !reductKitToggle.set +
            ";Templates.CONFIG.netcdf_kit_disabled  = " + !netcdfKitToggle.set +
            ";Templates.CONFIG.ac_kit_disabled      = " + !acKitToggle.set +
            ";Templates.CONFIG.ip_kit_disabled      = " + !ipKitToggle.set +
            ";Templates.CONFIG.mavs_kit_disabled    = " + !mavsKitToggle.set +
            ";Templates.CONFIG.cfd_kit_disabled     = " + !cfdKitToggle.set +
            ";Templates.CONFIG.gis_disabled         = " + !gisKitToggle.set +
            ";Templates.CONFIG.w3c_disabled         = " + !w3cKitToggle.set +
            ";Templates.CONFIG.db_kit_disabled      = " + !dbKitToggle.set +
            ";Templates.CONFIG.db_oracle_disabled   = " + !oracleToggle.set +
            ";Templates.CONFIG.pst_kit_disabled     = " + !pstKitToggle.set + ";";
	// don't want to run when v_commands changes
        parse_v_relative(trigger);
    };
};

//---------------------------------------------------------------------//

// Definition of a dialog box for displaying messages for the NE.

UImessageBox NEmessageDialog {
    NEdataObj    &dataObj;
    parent       => dataObj.parent;
    title        =  "NE_MESSAGE_DIALOG_TITLE";
    cancelButton =  0;
    message      => dataObj.dialogString;
    visible      => dataObj.dialogVisible;
};

//---------------------------------------------------------------------//
//                        Individual menu items                        //
//---------------------------------------------------------------------//

group NEmenuItem {
    NEdataObj  &dataObj;
    UIcmd      cmd {
	update<status=0>; // disables verbose messages
    };
};

group NEcascadingMenuItem {
    NEdataObj  &dataObj;
    UIcmdList  cmdList;
};

group NEmenuToggle {
    NEdataObj  &dataObj;
    UIoption   option {
      update<status=0>;
    };
};

//---------------------------------------------------------------------//
//  Items normally located in the "File" menu:
//---------------------------------------------------------------------//

NEcascadingMenuItem NEnewAppItem_V2 {   //--- New Application ---//

    NEsubobjCmdList appCmdList {
        parent+nres   => dataObj.appList;
        messageFormat =  "NE_MENU_FILE_NEW_MSG_V2";
    };

    cmdList.label   =  "NE_MENU_FILE_NEW_V2";
    cmdList.cmdList => appCmdList.subCmds;

    NEgroupPtrTriggerFunc triggerFunc {
        trigger => appCmdList.selectedObj;
        func = "NEnew_application";
    };
};

NEmenuItem NEnewAppItem {   //--- New Application ---//

    cmd.label   =  "NE_MENU_FILE_NEW";
    cmd.message =  "NE_MENU_FILE_NEW_MSG";

    GMOD.instancer NEinstNewAppDialog {
	Value => cmd.do;
	Group => dialog;
	active = 2;
    };

    NEnewAppDialog dialog<instanced=0> {
        shell.visible => cmd.do;
    };
};

//---------------------------------------------------------------------//

//---------------------------------------------------------------------//

NEmenuItem NEloadAppItem {   //--- Load Application ---//

    cmd.label   = "NE_MENU_FILE_LOAD";
    cmd.message = "NE_MENU_FILE_LOAD_MSG";

    UIfileDialog dialog {
        parent        => dataObj.parent;
        title         =  "NE_MENU_FILE_LOAD_TITLE";
        searchPattern =  "*.v";
        autoUnmanage  =  1;
        visible       => cmd.do;
        isModal       =  1;
	update<status=0>;
    };

    NEstringTriggerFunc triggerFunc {
        trigger => dialog.filename;
        func = "NEload_application";
    };
};

//---------------------------------------------------------------------//

NEmenuItem NEsaveAppItem {   //--- Save Application ---//

    cmd.label   =  "NE_MENU_FILE_SAVE";
    cmd.message =  "NE_MENU_FILE_SAVE_MSG";
    cmd.active  => dataObj.appExists;

    UIfileDialog dialog {
        parent           => dataObj.parent;
        title            =  "NE_MENU_FILE_SAVE_TITLE";
        searchPattern    =  "*.v";
        autoUnmanage     =  1;
        confirmFileWrite =  1;
        visible          => cmd.do;
        isModal          =  1;
	update<status=0>;
    };

    NEstringTriggerFunc triggerFunc {
        trigger => dialog.filename;
        func = "NEsave_application";
    };
};

//---------------------------------------------------------------------//

NEmenuItem NEdeleteAppItem {   //--- Delete Application ---//

    cmd.label   =  "NE_MENU_FILE_DELETE";
    cmd.message =  "NE_MENU_FILE_DELETE_MSG";
    cmd.active  => dataObj.appExists;

    NEintTriggerFunc triggerFunc {
        trigger => cmd.do;
        func = "NEdelete_application";
    };
};

//---------------------------------------------------------------------//

NEmenuItem NEexitItem {   //--- Exit ---//

    cmd.label   = "NE_MENU_FILE_EXIT";
    cmd.message = "NE_MENU_FILE_EXIT_MSG";

    UIquestionDialog dialog {
        parent   => dataObj.parent;
        title    =  "NE_MENU_FILE_EXIT_TITLE";
        message  =  "NE_MENU_FILE_EXIT_PROMPT";
        visible  => cmd.do;
        isModal  =  1;
	update<status=0>;
    };

    NEintTriggerFunc triggerFunc {
        trigger => dialog.ok;
        func = "NEexit";
    };
};

//---------------------------------------------------------------------//
//  Items normally located in the "Edit" menu:
//---------------------------------------------------------------------//

NEmenuItem NEcutItem {   //--- Cut ---//

    cmd.label   =  "NE_MENU_EDIT_CUT";
    cmd.message =  "NE_MENU_EDIT_CUT_MSG";
    cmd.active  => dataObj.deletable & dataObj.bufferOK;

    NEintTriggerFunc triggerFunc {
        trigger => cmd.do;
        func = "NEcut_to_paste_buffer";
    };
};

//---------------------------------------------------------------------//

NEmenuItem NEcopyItem {   //--- Copy ---//

    cmd.label   =  "NE_MENU_EDIT_COPY";
    cmd.message =  "NE_MENU_EDIT_COPY_MSG";
    cmd.active  => dataObj.anySelection & dataObj.bufferOK;

    NEintTriggerFunc triggerFunc {
        trigger => cmd.do;
        func = "NEcopy_to_paste_buffer";
    };
};

//---------------------------------------------------------------------//

NEmenuItem NEpasteItem {   //--- Paste ---//

    cmd.label   =  "NE_MENU_EDIT_PASTE";
    cmd.message =  "NE_MENU_EDIT_PASTE_MSG";
    cmd.active  => dataObj.loadable & dataObj.bufferOK &
                   dataObj.bufferNonempty;

    NEintTriggerFunc triggerFunc {
        trigger => cmd.do;
        func = "NEpaste_buffer";
    };
};

//---------------------------------------------------------------------//

NEmenuItem NEduplicateItem {   //--- Duplicate ---//

    cmd.label   =  "NE_MENU_EDIT_DUPLICATE";
    cmd.message =  "NE_MENU_EDIT_DUPLICATE_MSG";
    cmd.active  => dataObj.duplicatable;

    NEintTriggerFunc triggerFunc {
        trigger => cmd.do;
        func = "NEduplicate_selected";
    };
};

//---------------------------------------------------------------------//

NEmenuItem NEdeleteItem {   //--- Delete ---//

    cmd.label   =  "NE_MENU_EDIT_DELETE";
    cmd.message =  "NE_MENU_EDIT_DELETE_MSG";
    cmd.active  => dataObj.deletable;

    NEintTriggerFunc triggerFunc {
        trigger => cmd.do;
        func = "NEdelete_selected";
    };
};

//---------------------------------------------------------------------//
//  Items normally located in the "Object" menu:
//---------------------------------------------------------------------//

NEmenuItem NErenameItem {   //--- Rename ---//

    cmd.label   =  "NE_MENU_OBJECT_RENAME";
    cmd.message =  "NE_MENU_OBJECT_RENAME_MSG";
    cmd.active  => dataObj.renamable;

    NEintTriggerFunc triggerFunc {
        trigger => cmd.do;
        func = "NErename_selected_obj";
    };
};

//---------------------------------------------------------------------//

NEmenuItem NEfindInAllItem {   //--- Find in All Libraries ---//

    cmd.label   =  "NE_MENU_OBJECT_FIND_ALL";
    cmd.message =  "NE_MENU_OBJECT_FIND_ALL_MSG";

    NEintTriggerFunc triggerFunc {
        trigger => cmd.do;
        func = "NEfind_in_libraries_obj";
    };
};

//---------------------------------------------------------------------//

NEmenuItem NEfindInSelectedItem {   //--- Find in Selected Library ---//

    cmd.label   =  "NE_MENU_OBJECT_FIND_SELECTED";
    cmd.message =  "NE_MENU_OBJECT_FIND_SELECTED_MSG";
    cmd.active  => dataObj.finderOK;

    NEintTriggerFunc triggerFunc {
        trigger => cmd.do;
        func = "NEfind_in_selected_obj";
    };
};

//---------------------------------------------------------------------//

#ifdef MSDOS

NEmenuItem NEbrowserItem {   //--- Browser ---//

    cmd.label   =  "NE_MENU_OBJECT_BROWSE";
    cmd.message =  "NE_MENU_OBJECT_BROWSE_MSG";

    NEintTriggerFunc triggerFunc {
        trigger => cmd.do;
        func = "NEdisplay_browser";
    };
};

#endif // MSDOS

//---------------------------------------------------------------------//

NEmenuItem NEpropertiesItem {   //--- Properties ---//

    cmd.label   =  "NE_MENU_OBJECT_PROPERTIES";
    cmd.message =  "NE_MENU_OBJECT_PROPERTIES_MSG";
    cmd.active  => dataObj.singleSelection;

    NEintTriggerFunc triggerFunc {
        trigger => cmd.do;
        func = "NEedit_selected_obj_props";
    };
};

//---------------------------------------------------------------------//

NEmenuItem NEobjectEditorItem {   //--- Object Editor ---//

    cmd.label   =  "NE_MENU_OBJECT_EDITOR";
    cmd.message =  "NE_MENU_OBJECT_EDITOR_MSG";
    cmd.active  => dataObj.propsEditable;

    GMOD.copy_on_change onActivate {
        trigger => cmd.do;
	on_inst = 0;
        input   = 1;
        output  => dataObj.displayObjectEditor;
    };
};

//---------------------------------------------------------------------//

NEmenuItem NEaddModuleItem {   //--- Add module ---//

    cmd.label   = "NE_MENU_OBJECT_ADD_MODULE";
    cmd.message = "NE_MENU_OBJECT_ADD_MODULE_MSG";
};

//---------------------------------------------------------------------//

NEmenuItem NEimportFileItem {   //--- Add File Import Module ---//

    cmd.label   = "NE_MENU_OBJECT_ADD_FILE_MOD";
    cmd.message = "NE_MENU_OBJECT_ADD_FILE_MOD_MSG";
};

//---------------------------------------------------------------------//

NEmenuItem NEloadObjsItem {   //--- Load Objects ---//

    cmd.label   =  "NE_MENU_OBJECT_LOAD";
    cmd.message =  "NE_MENU_OBJECT_LOAD_MSG";
    cmd.active  => dataObj.loadable;

    UIfileDialog dialog {
        parent        => dataObj.parent;
        title         =  "NE_MENU_OBJECT_LOAD_TITLE";
        searchPattern =  "*.v";
        autoUnmanage  =  1;
        visible       => cmd.do;
        isModal       =  1;
	update<status=0>;
    };

    NEstringTriggerFunc triggerFunc {
        trigger => dialog.filename;
        func = "NEload_objs";
    };
};

//---------------------------------------------------------------------//

NEmenuItem NEsaveObjsItem {   //--- Save Objects ---//

    cmd.label   =  "NE_MENU_OBJECT_SAVE";
    cmd.message =  "NE_MENU_OBJECT_SAVE_MSG";
    cmd.active  => dataObj.anySelection;

    UIfileDialog dialog {
        parent           => dataObj.parent;
        title            =  "NE_MENU_OBJECT_SAVE_TITLE";
        searchPattern    =  "*.v";
        autoUnmanage     =  1;
        confirmFileWrite =  1;
        visible          => cmd.do;
        isModal          =  1;
	update<status=0>;
    };

    NEstringTriggerFunc triggerFunc {
        trigger => dialog.filename;
        func = "NEsave_objs";
    };
};

//---------------------------------------------------------------------//
//  Items normally located in the "Project" menu:
//---------------------------------------------------------------------//

NEmenuItem NEeditSourceItem {   //--- Edit Source ---//

    cmd.label   =  "NE_MENU_PROJECT_EDIT";
    cmd.message =  "NE_MENU_PROJECT_EDIT_MSG";
    cmd.active  => dataObj.anySelection & dataObj.sourceEditable &
                   dataObj.projectEditable;

    NEintTriggerFunc triggerFunc {
        trigger => cmd.do;
        func = "NEedit_source";
    };
};

//---------------------------------------------------------------------//

NEmenuItem NEcompileItem {   //--- Compile ---//

    cmd.label   =  "NE_MENU_PROJECT_COMPILE";
    cmd.message => "NE_MENU_PROJECT_COMPILE_MSG" + " " + dataObj.projectDir;
    cmd.active  => dataObj.anySelection & dataObj.projectEditable;

    NEintTriggerFunc triggerFunc {
        trigger => cmd.do;
        func = "NEcompile_selected_objs";
    };
};

//---------------------------------------------------------------------//

NEmenuItem NEreloadLibItem {   //--- Reload Library ---//

    cmd.label   =  "NE_MENU_PROJECT_RELOAD";
    cmd.message =  "NE_MENU_PROJECT_RELOAD_MSG";
    cmd.active  => dataObj.reloadable;

    NEintTriggerFunc triggerFunc {
        trigger => cmd.do;
        func = "NEreload_lib";
    };
};

//---------------------------------------------------------------------//

NEmenuItem NEprojConfigItem {   //--- Configure ---//

    cmd.label   =  "NE_MENU_PROJECT_CONF";
    cmd.message =  "NE_MENU_PROJECT_CONF_MSG";

    NEprojConfigDialog dialog {
        dataObj => <-.dataObj;
    };

    GMOD.parse_v popupDialog {
        trigger => cmd.do;
        relative => <-;
        on_inst = 0;
        v_commands = "dialog.init = 1;";
    };
};

//---------------------------------------------------------------------//

NEmenuItem NEsaveProjectItem {   //--- Save ---//

    cmd.label   =  "NE_MENU_PROJECT_SAVE";
    cmd.message => "NE_MENU_PROJECT_SAVE_MSG" + " " + dataObj.projectDir;
    cmd.active  => dataObj.projectEditable;

    NEintTriggerFunc triggerFunc {
        trigger => cmd.do;
        func = "NEsave_project";
    };
};

//---------------------------------------------------------------------//

NEmenuItem NEsaveProjectAsItem {   //--- Save As ---//

    cmd.label   =  "NE_MENU_PROJECT_SAVE_AS";
    cmd.message =  "NE_MENU_PROJECT_SAVE_AS_MSG";

    UIfileDialog dialog {
        parent       => dataObj.parent;
        title        =  "NE_MENU_PROJECT_SAVE_TITLE";
        autoUnmanage =  1;
        visible      => cmd.do;
        isModal      =  1;
        typeMask = "directory";
	update<status=0>;
    };

    NEstringTriggerFunc triggerFunc {
        trigger => dialog.filename;
        func = "NEsave_project_as";
    };
};

//---------------------------------------------------------------------//

NEmenuItem NEsaveSubsetItem {   //--- Save Compiled Project ---//

    cmd.label   =  "NE_MENU_PROJECT_SAVE_COMPILED";
    cmd.message =  "NE_MENU_PROJECT_SAVE_COMPILED_MSG";
    cmd.active  => dataObj.projectSavedCompileable;

    GMOD.instancer NEinstanceDialog {
	Value => cmd.do;
	Group => dialog;
	active = 2;
    };

    NEsubsetDialog dialog<instanced=0> {
        shell.visible => cmd.do;
    };
};

//---------------------------------------------------------------------//
//  Items normally located in the "Journal" menu:
//---------------------------------------------------------------------//

NEmenuItem NEjournalMenuItem {
    GMOD.journal  &journalObj;
};

//---------------------------------------------------------------------//

NEjournalMenuItem NEplaybackItem {   //--- Playback ---//

    cmd.label   =  "NE_MENU_JOURNAL_PLAY";
    cmd.message => "NE_MENU_JOURNAL_PLAY_MSG";
    cmd.active  => journalObj.record ^ 1;

    UIfileDialog dialog {
        parent        => dataObj.parent;
        title         =  "NE_MENU_JOURNAL_PLAY_TITLE";
        searchPattern =  "*.v";
        autoUnmanage  =  1;
        visible       => cmd.do;
        isModal       =  1;

        // The following connections allow the journal object to
        // be triggered by the dialog.

        ok            => journalObj.playback;
        filename      => journalObj.playback_filename;
	update<status=0>;
    };
};

//---------------------------------------------------------------------//

NEjournalMenuItem NErecordItem {   //--- Record ---//

    cmd.label   =  "NE_MENU_JOURNAL_RECORD";
    cmd.message => "NE_MENU_JOURNAL_RECORD_MSG";
    cmd.active  => journalObj.record ^ 1;

    UIfileDialog dialog {
        parent           => dataObj.parent;
        title            =  "NE_MENU_JOURNAL_RECORD_TITLE";
        searchPattern    =  "*.v";
        autoUnmanage     =  1;
        confirmFileWrite =  1;
        visible          => cmd.do;
        isModal          =  1;

        // The following connections allow the journal object to
        // be triggered by the dialog.

        ok               => journalObj.start_recording;
        filename         => journalObj.record_filename;
	update<status=0>;
    };
};

//---------------------------------------------------------------------//

NEjournalMenuItem NEstopItem {   //--- Stop ---//

    cmd.label   =  "NE_MENU_JOURNAL_STOP";
    cmd.message => "NE_MENU_JOURNAL_STOP_MSG";
    cmd.active  => journalObj.record;

    // The following connection allows the journal object to
    // be triggered by the menu item.

    cmd.do      => journalObj.stop;
};

//---------------------------------------------------------------------//
//  Items normally located in the "UI Builder" menu:
//---------------------------------------------------------------------//

NEmenuItem NEuiBuilderMenuItem {
    NEuiBuilderObj  &builderObj;
};

NEmenuToggle NEuiBuilderMenuToggle {
    NEuiBuilderObj  &builderObj;
};

//---------------------------------------------------------------------//

NEuiBuilderMenuToggle NElayoutEditorItem {   //--- Layout Editor ---//

    option.label   =  "NE_MENU_UI_LAYOUT";
    option.message => "NE_MENU_UI_LAYOUT_MSG";
    option.set     => builderObj.layout.isActive;
};

//---------------------------------------------------------------------//

NEuiBuilderMenuToggle NEsnapToGridItem {   //--- Snap To Grid ---//

    option.label   =  "NE_MENU_UI_GRID";
    option.message => "NE_MENU_UI_GRID_MSG";
    option.set     => builderObj.layout.snapToGrid;
};

//---------------------------------------------------------------------//

NEuiBuilderMenuItem NEgroupItem {   //--- Group ---//

    cmd.label   =  "NE_MENU_UI_GROUP";
    cmd.message => "NE_MENU_UI_GROUP_MSG";
    cmd.do      => builderObj.layout.group;
};

//---------------------------------------------------------------------//

NEuiBuilderMenuItem NEungroupItem {   //--- Ungroup ---//

    cmd.label   =  "NE_MENU_UI_UNGROUP";
    cmd.message => "NE_MENU_UI_UNGROUP_MSG";
    cmd.do      => builderObj.layout.ungroup;
};

//---------------------------------------------------------------------//
//  Items normally located in the "Options" menu:
//---------------------------------------------------------------------//

NEmenuToggle NEflashingItem {   //--- Module Flashing ---//

    option.label   = "NE_MENU_OPTIONS_FLASH";
    option.set     = 1;
    option.message = "NE_MENU_OPTIONS_FLASH_MSG";

    group triggerFunc {
        int trigger => option.set;
        omethod+notify_inst+notify_val func<status=0,interruptable=0> = "NEupdate_flashing";
    };
};

//---------------------------------------------------------------------//

NEmenuToggle NEverboseItem {   //--- Verbose Functions ---//

    option.label   = "NE_MENU_OPTIONS_VERBOSE_FUNC";
    option.set     = ; // Explicitly unset to allow command line override.
    option.message = "NE_MENU_OPTIONS_VERBOSE_FUNC_MSG";

    group triggerFunc {
        int trigger => option.set;
        omethod+notify_inst+notify_val func<status=0,interruptable=0> ="NEupdate_verbose_funcs";
    };
};

//---------------------------------------------------------------------//

NEmenuToggle NEsaveUIParams {   //--- Save UI Parameters ---//

    option.label   = "NE_MENU_OPTIONS_SAVE_UI_PARAMS";
    option.set     = 1;
    option.message = "NE_MENU_OPTIONS_SAVE_UI_PARAMS_MSG";

    group triggerFunc {
        int trigger => option.set;
        omethod+notify_inst+notify_val func<status=0,interruptable=0> ="NEupdate_save_ui_params";
    };
};

#ifdef ACKIT
//---------------------------------------------------------------------//
//  Items normally located in the "AVS" menu:
//---------------------------------------------------------------------//

NEmenuItem NEreadNetItem {   //--- Read AVS5 Network ---//

    cmd.label   = "NE_MENU_AVS_NET";
    cmd.message = "NE_MENU_AVS_NET_MSG";

    UIfileDialog dialog {
        parent        => dataObj.parent;
        title         =  "NE_MENU_AVS_NET_TITLE";
        searchPattern =>  dataObj.AVSpaths.NetworkDirectory + "/*.net";
        autoUnmanage  =  1;
        visible       => cmd.do;
        isModal       =  1;
	update<status=0>;
    };

    AC_UTIL.MenuItems.read_avs5_net read_avs5_net {
        filename => dialog.filename;
    };
};

//---------------------------------------------------------------------//

NEmenuItem NErunScriptItem {   //--- Run AVS5 Script ---//

    cmd.label   = "NE_MENU_AVS_RUN";
    cmd.message = "NE_MENU_AVS_RUN_MSG";

    UIfileDialog dialog {
        parent        => dataObj.parent;
        title         =  "NE_MENU_AVS_RUN_TITLE";
        searchPattern =>  dataObj.AVSpaths.NetworkDirectory + "/*.scr";
        autoUnmanage  =  1;
        visible       => cmd.do;
        isModal       =  1;
	update<status=0>;
    };

    AC_UTIL.MenuItems.read_avs5_script read_avs5_script {
        filename => dialog.filename;
    };
};

//---------------------------------------------------------------------//

NEmenuItem NEreadModLibItem {   //--- Read Module Library ---//

    cmd.label   = "NE_MENU_AVS_RD_MOD_LIB";
    cmd.message = "NE_MENU_AVS_RD_MOD_LIB_MSG";

    UIfileDialog dialog {
        parent        => dataObj.parent;
        title         =  "NE_MENU_AVS_RD_MOD_LIB_TITLE";
        searchPattern =>  dataObj.AVSpaths.LibPath + "/*";
        autoUnmanage  =  1;
        visible       => cmd.do;
        isModal       =  1;
	update<status=0>;
    };

    AC_UTIL.MenuItems.read_mod_lib read_mod_lib {
        filename => dialog.filename;
    };
};

//---------------------------------------------------------------------//

NEmenuItem NEreadModItem {   //--- Read AVS Module ---//

    cmd.label   = "NE_MENU_AVS_RD_MOD";
    cmd.message = "NE_MENU_AVS_RD_MOD_MSG";

    UIfileDialog dialog {
        parent        => dataObj.parent;
        title         =  "NE_MENU_AVS_RD_MOD_TITLE";
        searchPattern =>  dataObj.AVSpaths.LibPath + "/*";
        autoUnmanage  =  1;
        visible       => cmd.do;
        isModal       =  1;
	update<status=0>;
    };

    AC_UTIL.MenuItems.read_module read_module {
        filename => dialog.filename;
    };
};

//---------------------------------------------------------------------//

NEmenuItem NEreadRModItem {   //--- Read AVS Remote Module ---//

    cmd.label   = "NE_MENU_AVS_RD_RMOD";
    cmd.message = "NE_MENU_AVS_RD_RMOD_MSG";

    UIpromptDialog host {
       visible => cmd.do;
       applyButton = 0;
       prompt = "NE_MENU_AVS_RD_RMOD_HOST_MSG";
       title = "NE_MENU_AVS_RD_RMOD_HOST_TITLE";
    };
    UIfileDialog file {
        parent        => dataObj.parent;
        title         =  "NE_MENU_AVS_RD_RMOD_TITLE";
        searchPattern =>  dataObj.AVSpaths.LibPath + "/*";
        autoUnmanage  =  1;
        visible       => host.ok;
        isModal       =  1;
    };
    AC_UTIL.MenuItems.read_remote_module read_remote_module {
        filename => file.filename;
        hostname => host.text;
    };
};

#endif // ACKIT

//---------------------------------------------------------------------//
//  Items normally located in the "Help" menu:
//---------------------------------------------------------------------//

NEmenuItem NEhelpContentsItem {   //--- Contents ---//

    cmd.label   =  "NE_MENU_HELP_CONTENTS";
    cmd.message =  "NE_MENU_HELP_CONTENTS_MSG";

    NEintTriggerFunc triggerFunc {
        trigger => cmd.do;
        func = "NEhelp_contents";
    };
};

//---------------------------------------------------------------------//

NEmenuItem NEhelpOnObjectItem {   //--- On Selected Object ---//

    cmd.label   =  "NE_MENU_HELP_SELECTED";
    cmd.message =  "NE_MENU_HELP_SELECTED_MSG";
    cmd.active  => dataObj.singleSelection;
    //cmd.active  = 0;

    NEintTriggerFunc triggerFunc {
        trigger => cmd.do;
        func = "NEhelp_on_object";
    };
};

//---------------------------------------------------------------------//

// No longer used in XP 6.0
NEmenuItem NEhelpOnHelpItem {   //--- On Help ---//

    cmd.label   =  "NE_MENU_HELP_USE";
    cmd.message =  "NE_MENU_HELP_USE_MSG";
    cmd.active = 0;

    NEintTriggerFunc triggerFunc {
        trigger => cmd.do;
        func = "NEhelp_on_help";
    };
};

//---------------------------------------------------------------------//

NEmenuItem NEhelpAboutItem {   //--- About ---//

    cmd.label   =  "NE_MENU_HELP_ABOUT";
    cmd.message =  "NE_MENU_HELP_ABOUT_MSG";

    UIinfoDialog dialog {
        parent       => dataObj.parent;
        title        =  "NE_MENU_HELP_ABOUT_TITLE";
        cancelButton = 0;
        message      => dataObj.versionString;
        visible      => cmd.do;
	update<status=0>;
    };
};

//---------------------------------------------------------------------//
//                  Default versions of pulldown menus                 //
//---------------------------------------------------------------------//

group NEpulldownMenu {
    NEdataObj  &dataObj;
    UIcmdList  pulldown;
};

//---------------------------------------------------------------------//

NEpulldownMenu NEfileMenu {   //--- File ---//

    NEnewAppItem     newAppItem    { dataObj => <-.dataObj; };
    NEloadAppItem    loadAppItem   { dataObj => <-.dataObj; };
    NEsaveAppItem    saveAppItem   { dataObj => <-.dataObj; };
    NEdeleteAppItem  deleteAppItem { dataObj => <-.dataObj; };
    UImenuSeparator  sep1;
    NEexitItem       exitItem      { dataObj => <-.dataObj; };

    pulldown.label   =  "NE_MENU_FILE";
    pulldown.cmdList => { newAppItem.cmd,
                          loadAppItem.cmd,
                          saveAppItem.cmd,
                          deleteAppItem.cmd,
                          sep1,
                          exitItem.cmd };
};

//---------------------------------------------------------------------//

NEpulldownMenu NEeditMenu {   //--- Edit ---//

    NEcutItem        cutItem       { dataObj => <-.dataObj; };
    NEcopyItem       copyItem      { dataObj => <-.dataObj; };
    NEpasteItem      pasteItem     { dataObj => <-.dataObj; };
    NEduplicateItem  duplicateItem { dataObj => <-.dataObj; };
    UImenuSeparator  sep1;
    UImenuSeparator  sep2;
    NEdeleteItem     deleteItem    { dataObj => <-.dataObj; };

    pulldown.label   =  "NE_MENU_EDIT";
    pulldown.cmdList => { cutItem.cmd,
                          copyItem.cmd,
                          pasteItem.cmd,
                          duplicateItem.cmd,
                          sep1,
                          sep2,
                          deleteItem.cmd };
};

//---------------------------------------------------------------------//

NEpulldownMenu NEobjectMenu {   //--- Object ---//

    NErenameItem          renameItem          { dataObj => <-.dataObj; };
    NEfindInAllItem       findInAllItem       { dataObj => <-.dataObj; };
    NEfindInSelectedItem  findInSelectedItem  { dataObj => <-.dataObj; };
#ifdef MSDOS
    NEbrowserItem         browserItem         { dataObj => <-.dataObj; };
#endif
    NEpropertiesItem      propertiesItem      { dataObj => <-.dataObj; };
    NEobjectEditorItem    objectEditorItem    { dataObj => <-.dataObj; };
    NEaddModuleItem       addModuleItem       { dataObj => <-.dataObj; };
    NEimportFileItem      importFileItem      { dataObj => <-.dataObj; };
    NEloadObjsItem        loadObjsItem        { dataObj => <-.dataObj; };
    NEsaveObjsItem        saveObjsItem        { dataObj => <-.dataObj; };

    pulldown.label   =  "NE_MENU_OBJECT";
    pulldown.cmdList => { renameItem.cmd,
                          findInAllItem.cmd,
                          findInSelectedItem.cmd,
#ifdef MSDOS
                          browserItem.cmd,
#endif
                          propertiesItem.cmd,
			  objectEditorItem.cmd,
			  addModuleItem.cmd,
			  importFileItem.cmd,
                          loadObjsItem.cmd,
                          saveObjsItem.cmd };
};

//---------------------------------------------------------------------//

NEpulldownMenu NEprojectMenu {   //--- Project ---//

    NEeditSourceItem     editSourceItem    { dataObj => <-.dataObj; };
    NEcompileItem        compileItem       { dataObj => <-.dataObj; };
    NEreloadLibItem      reloadLibItem     { dataObj => <-.dataObj; };
    NEprojConfigItem     projConfigItem    { dataObj => <-.dataObj; };
    NEsaveProjectItem    saveProjectItem   { dataObj => <-.dataObj; };
    NEsaveProjectAsItem  saveProjectAsItem { dataObj => <-.dataObj; };
    NEsaveSubsetItem     saveSubsetItem    { dataObj => <-.dataObj; };

    pulldown.label   =  "NE_MENU_PROJECT";
    pulldown.cmdList => { editSourceItem.cmd,
                          compileItem.cmd,
                          reloadLibItem.cmd,
                          projConfigItem.cmd,
                          saveProjectItem.cmd,
                          saveProjectAsItem.cmd,
                          saveSubsetItem.cmd };
};

//---------------------------------------------------------------------//

NEpulldownMenu NEjournalPulldownMenu {
    GMOD.journal  &journalObj;
};

NEjournalPulldownMenu NEjournalMenu {   //--- Journal ---//

    NEplaybackItem   playbackItem { dataObj => <-.dataObj;
                                    journalObj => <-.journalObj; };
    UImenuSeparator  sep1;
    NErecordItem     recordItem   { dataObj => <-.dataObj;
                                    journalObj => <-.journalObj; };
    NEstopItem       stopItem     { dataObj => <-.dataObj;
                                    journalObj => <-.journalObj; };

    pulldown.label   =  "NE_MENU_JOURNAL";
    pulldown.cmdList => { playbackItem.cmd,
                          sep1,
                          recordItem.cmd,
                          stopItem.cmd };
};

//---------------------------------------------------------------------//

NEpulldownMenu NEuiBuilderPulldownMenu {
    NEuiBuilderObj  &builderObj;
};

NEuiBuilderPulldownMenu NEuiBuilderMenu {   //--- UI Builder ---//

    NElayoutEditorItem  layoutEditorItem  { dataObj => <-.dataObj;
                                            builderObj => <-.builderObj; };
    NEsnapToGridItem    snapToGridItem    { dataObj => <-.dataObj;
                                            builderObj => <-.builderObj; };
    UImenuSeparator     sep1;
    NEgroupItem         groupItem         { dataObj => <-.dataObj;
                                            builderObj => <-.builderObj; };
    NEungroupItem       ungroupItem       { dataObj => <-.dataObj;
                                            builderObj => <-.builderObj; };

    pulldown.label   =  "NE_MENU_UI";
    pulldown.cmdList => { layoutEditorItem.option,
                          snapToGridItem.option,
                          sep1,
                          groupItem.cmd,
                          ungroupItem.cmd };
};

//---------------------------------------------------------------------//

NEpulldownMenu NEoptionsMenu {   //--- Options ---//

    NEflashingItem  flashingItem { dataObj => <-.dataObj; };
    NEverboseItem   verboseItem  { dataObj => <-.dataObj; };
    NEsaveUIParams  saveUIItem   { dataObj => <-.dataObj; };
    UIoption        Auto_Arrange {
        label = "NE_MENU_OPTIONS_ARRANGE";
        message = "NE_MENU_OPTIONS_ARRANGE_MSG";
	set => Templates.NE_PREFERENCES.NEpreferences.auto_arrange;
    };
    UIoption        Show_Application_UI {
        label = "NE_MENU_OPTIONS_SHOW_UI";
        message = "NE_MENU_OPTIONS_SHOW_UI_MSG";
	set => Templates.CONFIG.au_show_ui;
    };

    pulldown.label   =  "NE_MENU_OPTIONS";
    pulldown.cmdList => { flashingItem.option,
                          verboseItem.option, saveUIItem.option,
			  Auto_Arrange, Show_Application_UI};
};

//---------------------------------------------------------------------//

#ifdef ACKIT
NEpulldownMenu NEavsMenu {   //--- AVS ---//

    NEreadNetItem    readNetItem   { dataObj => <-.dataObj; };
    NErunScriptItem  runScriptItem { dataObj => <-.dataObj; };
    UImenuSeparator  sep1;
    NEreadModLibItem readModLibItem {dataObj => <-.dataObj;};
    NEreadModItem    readModItem    {dataObj => <-.dataObj;};
    NEreadRModItem   readRModItem   {dataObj => <-.dataObj;};

    pulldown.label   =  "NE_MENU_AVS";
    pulldown.cmdList => { readNetItem.cmd,
                          runScriptItem.cmd,
                          sep1,
			  readModLibItem.cmd,
			  readModItem.cmd,
			  readRModItem.cmd };
};
#endif // ACKIT

//---------------------------------------------------------------------//

NEpulldownMenu NEhelpMenu {   //--- Help ---//

    NEhelpContentsItem  helpContentsItem { dataObj => <-.dataObj; };
    NEhelpOnObjectItem  helpOnObjectItem { dataObj => <-.dataObj; };
    UImenuSeparator     sep1;
    NEhelpAboutItem     helpAboutItem { dataObj => <-.dataObj; };

    pulldown.label     =  "NE_MENU_HELP";
    pulldown.isHelpCmd =  1;
    pulldown.cmdList   => { helpContentsItem.cmd,
                            helpOnObjectItem.cmd,
                            sep1,
                            helpAboutItem.cmd };
};

//---------------------------------------------------------------------//
//                         Popup menu items                            //
//---------------------------------------------------------------------//

module NEpopupMenuItem <
    cxx_abstract = 1,
    cxx_members  = <"
        virtual int   processInput(int active_id);
        virtual void  addToShell(WTpopup_menu menu);
        virtual int   matchId(int active_id);
        NEobj_disp    *getObjDisp();
    ">,
    export_cxx   = 1
>
{
    NEobjPopupData  &popupData;
    NEdataObj       &dataObj <export_cxx=0>;
    int+opt         visible = 1;
    int+opt         active = 1;
};

//---------------------------------------------------------------------//

NEpopupMenuItem NEpopupMenuShell <
    cxx_members  = <"
        virtual void  addToShell(WTpopup_menu menu);
    ">,
    use_src_file = 0
>
{
    NEpopupMenuItem  &items[];
    cxxmethod        updateVisibility(visible+read+notify);
};

//---------------------------------------------------------------------//

NEpopupMenuItem NEpopupMenuSeparator <
    cxx_members  = <"
        virtual void  addToShell(WTpopup_menu menu);
    ">
>;

//---------------------------------------------------------------------//

NEpopupMenuItem NEpopupMenuLabel <
    cxx_members  = <"
        virtual void  addToShell(WTpopup_menu menu);
        virtual int   matchId(int active_id);
    ">
>
{
    int     id;
    string  label;
};

//---------------------------------------------------------------------//

NEpopupMenuLabel NEpopupMenuButton <
    cxx_members  = <"
        virtual int   processInput(int active_id);
        virtual void  addToShell(WTpopup_menu menu);
    ">
>
{
    int  activated;
};

//---------------------------------------------------------------------//
// ID numbers for popup menu items
//---------------------------------------------------------------------//

#define NE_POPUP_CLOSE_ID         0
#define NE_POPUP_REDUCE_ID        1
#define NE_POPUP_OPEN_ID          2
#define NE_POPUP_MAXIMIZE_ID      3
#define NE_POPUP_INFO_ID          4
#define NE_POPUP_HELP_ID          5
#define NE_POPUP_RENAME_ID        6
#define NE_POPUP_PROPERTIES_ID    7
#define NE_POPUP_FIND_ID          8
#define NE_POPUP_ADD_IPORT_ID     9
#define NE_POPUP_ADD_OPORT_ID    10
#define NE_POPUP_REMOVE_PORT_ID  11
#define NE_POPUP_EXPORT_PORT_ID  12
#define NE_POPUP_DELETE_ID       13
#define NE_POPUP_SHOW_PARAMS_ID  14
#define NE_POPUP_OBJ_EDITOR_ID   15

//---------------------------------------------------------------------//
//  Items normally located in the object popup menu:
//---------------------------------------------------------------------//

NEpopupMenuButton NEpopupCloseItem <use_src_file=0> {

    id         = NE_POPUP_CLOSE_ID;
    label      = "NE_POPUP_CLOSE";
    visible    => popupData.closable;
    cxxmethod  activate(activated+read+notify);
};

NEpopupMenuButton NEpopupReduceItem <use_src_file=0> {

    id         = NE_POPUP_REDUCE_ID;
    label      = "NE_POPUP_REDUCE";
    visible    => popupData.reducable;
    cxxmethod  activate(activated+read+notify);
};

NEpopupMenuButton NEpopupOpenItem <use_src_file=0> {

    id         = NE_POPUP_OPEN_ID;
    label      = "NE_POPUP_OPEN";
    visible    => popupData.openable;
    cxxmethod  activate(activated+read+notify);
};

NEpopupMenuButton NEpopupShowParamsItem <use_src_file=0> {

    id         = NE_POPUP_SHOW_PARAMS_ID;
    label      = "NE_POPUP_SHOW_PARAMS";
    visible    => popupData.canShowParams;
    cxxmethod  activate(activated+read+notify);
};

NEpopupMenuButton NEpopupMaximizeItem <use_src_file=0> {

    id         = NE_POPUP_MAXIMIZE_ID;
    label      = "NE_POPUP_MAXIMIZE";
    visible    => popupData.maximizable;
    cxxmethod  activate(activated+read+notify);
};

NEpopupMenuSeparator NEpopupModeItemsSeparator {
    visible => popupData.closable | popupData.openable |
               popupData.canShowParams |
               popupData.reducable | popupData.maximizable;
};

NEpopupMenuButton NEpopupInfoItem <use_src_file=0> {

    id         = NE_POPUP_INFO_ID;
    label      = "NE_POPUP_INFO";
    cxxmethod  activate(activated+read+notify);
};

NEpopupMenuButton NEpopupHelpItem <use_src_file=0> {

    id         = NE_POPUP_HELP_ID;
    label      = "NE_POPUP_HELP";
    //active     = 0;
    cxxmethod  activate(activated+read+notify);
};

NEpopupMenuButton NEpopupRenameItem <use_src_file=0> {

    id         = NE_POPUP_RENAME_ID;
    label      = "NE_POPUP_RENAME";
    visible    => popupData.renamable;
    cxxmethod  activate(activated+read+notify);
};

NEpopupMenuButton NEpopupObjEditorItem <use_src_file=0> {

    id         = NE_POPUP_OBJ_EDITOR_ID;
    label      = "NE_POPUP_OBJ_EDITOR";
    visible    => popupData.propsEditable;
    GMOD.copy_on_change onActivate<export_cxx=0> {
        trigger => <-.activated;
	on_inst = 0;
        input   = 1;
        output  => <-.dataObj.displayObjectEditor;
    };
};

NEpopupMenuButton NEpopupPropertiesItem <use_src_file=0> {

    id         = NE_POPUP_PROPERTIES_ID;
    label      = "NE_POPUP_PROPERTIES";
    cxxmethod  activate(activated+read+notify);
};

NEpopupMenuButton NEpopupFindItem <use_src_file=0> {

    id         = NE_POPUP_FIND_ID;
    label      = "NE_POPUP_FIND";
    visible    => popupData.finderValid;
    cxxmethod  activate(activated+read+notify);
};

NEpopupMenuButton NEpopupAddIportItem <use_src_file=0> {

    id         = NE_POPUP_ADD_IPORT_ID;
    label      = "NE_POPUP_ADD_IPORT";
    visible    => popupData.canAddIport;
    cxxmethod  activate(activated+read+notify);
};

NEpopupMenuButton NEpopupAddOportItem <use_src_file=0> {

    id         = NE_POPUP_ADD_OPORT_ID;
    label      = "NE_POPUP_ADD_OPORT";
    visible    => popupData.canAddOport;
    cxxmethod  activate(activated+read+notify);
};

NEpopupMenuButton NEpopupExportPortItem <use_src_file=0> {

    id         = NE_POPUP_EXPORT_PORT_ID;
    label      = "NE_POPUP_EXPORT_PORT";
    visible    => popupData.canExportPort;
    cxxmethod  activate(activated+read+notify);
};

NEpopupMenuButton NEpopupRemovePortItem <use_src_file=0> {

    id         = NE_POPUP_REMOVE_PORT_ID;
    label      = "NE_POPUP_REMOVE_PORT";
    visible    => popupData.canRemovePort;
    cxxmethod  activate(activated+read+notify);
};

NEpopupMenuSeparator NEpopupPortItemsSeparator {
    visible => popupData.canAddIport | popupData.canAddOport |
               popupData.canExportPort | popupData.canRemovePort;
};

NEpopupMenuButton NEpopupDeleteItem <use_src_file=0> {

    id         = NE_POPUP_DELETE_ID;
    label      = "NE_POPUP_DELETE";
    active     => popupData.deletable;
    cxxmethod  activate(activated+read+notify);
};

//---------------------------------------------------------------------//

// Default popup menu for NE objects.

module NEdefaultObjPopupMenu <compile_subs=0> {

    NEobjPopupData             &popupData;
    NEdataObj                  &dataObj;

    NEpopupMenuShell           shell        { popupData => <-.popupData;
                                              dataObj => <-.dataObj;
                                              visible => <-.popupData.visible;
                                              items => {
                                                  <-.close,
                                                  <-.reduce,
                                                  <-.open,
                                                  <-.show_params,
                                                  <-.maximize,
                                                  <-.modeSep,
                                                  <-.info,
                                                  <-.help,
                                                  <-.rename,
                                                  <-.objEditor,
                                                  <-.properties,
                                                  <-.find,
                                                  <-.portSep,
                                                  <-.addIport,
                                                  <-.addOport,
                                                  <-.exportPort,
                                                  <-.removePort,
                                                  <-.deleteSep1,
                                                  <-.deleteSep2,
                                                  <-.delete };
                                            };
    NEpopupCloseItem           close        { popupData => <-.popupData;
                                              dataObj   => <-.dataObj;   };
    NEpopupReduceItem          reduce       { popupData => <-.popupData;
                                              dataObj   => <-.dataObj;   };
    NEpopupOpenItem            open         { popupData => <-.popupData;
                                              dataObj   => <-.dataObj;   };
    NEpopupShowParamsItem      show_params  { popupData => <-.popupData;
                                              dataObj   => <-.dataObj;   };
    NEpopupMaximizeItem        maximize     { popupData => <-.popupData;
                                              dataObj   => <-.dataObj;   };
    NEpopupModeItemsSeparator  modeSep      { popupData => <-.popupData;
                                              dataObj   => <-.dataObj;   };
    NEpopupInfoItem            info         { popupData => <-.popupData;
                                              dataObj   => <-.dataObj;   };
    NEpopupHelpItem            help         { popupData => <-.popupData;
                                              dataObj   => <-.dataObj;   };
    NEpopupRenameItem          rename       { popupData => <-.popupData;
                                              dataObj   => <-.dataObj;   };
    NEpopupObjEditorItem       objEditor    { popupData => <-.popupData;
                                              dataObj   => <-.dataObj;   };
    NEpopupPropertiesItem      properties   { popupData => <-.popupData;
                                              dataObj   => <-.dataObj;   };
    NEpopupFindItem            find         { popupData => <-.popupData;
                                              dataObj   => <-.dataObj;   };
    NEpopupPortItemsSeparator  portSep      { popupData => <-.popupData;
                                              dataObj   => <-.dataObj;   };
    NEpopupAddIportItem        addIport     { popupData => <-.popupData;
                                              dataObj   => <-.dataObj;   };
    NEpopupAddOportItem        addOport     { popupData => <-.popupData;
                                              dataObj   => <-.dataObj;   };
    NEpopupExportPortItem      exportPort   { popupData => <-.popupData;
                                              dataObj   => <-.dataObj;   };
    NEpopupRemovePortItem      removePort   { popupData => <-.popupData;
                                              dataObj   => <-.dataObj;   };
    NEpopupMenuSeparator       deleteSep1   { popupData => <-.popupData;
                                              dataObj   => <-.dataObj;   };
    NEpopupMenuSeparator       deleteSep2   { popupData => <-.popupData;
                                              dataObj   => <-.dataObj;   };
    NEpopupDeleteItem          delete       { popupData => <-.popupData;
                                              dataObj   => <-.dataObj;   };
};

//---------------------------------------------------------------------//

// This object launches the help viewer for a given topic.

group NEhelpLauncher {

    NEdataObj &dataObj;
    string    topic;
    int       do;

    NEintTriggerFunc triggerFunc {
        trigger => do;
        func = "NEhelp_launcher";
    };
};

//---------------------------------------------------------------------//

// Object Editor Macros
// 64-bit porting. Only Modified Internally //
flibrary OEM<compile_subs=0> {

   //------------------------------------------------------------------//

   macro propertyPage {
      UIoption option {
	 set => widgets.panel.visible;
	 message => "NE_OE_PROP_PAGE_OPT_MSG";
      };
      GMOD.instancer instancer {
	 Group => <-.widgets;
	 Value => option.set;
	 active = 2;
      };
      string helpTopic;
      macro widgets<instanced=0> {
	 UIpanel panel {
	    UIcontainer+IPort3 &parent_ref;
	    parent => parent_ref;
	    x = 0;
	    y = 0;
	    width => parent_ref.clientWidth;
	    height => parent_ref.clientHeight;
	 };
      };
   };

    //------------------------------------------------------------------//

    // Declaration page: Controls an object's name, type, reference mode,
    // array dimensions, export properties, value, and connection.

    propertyPage declarationPage {

        option.label = "NE_OE_DECL_PAGE";
        helpTopic = "OEdeclarationPage";

        // This uses a lower-level module to perform the actual updates
        // to the selected object.

        OE.edit_general declarationModule;

        // Width of all label widgets.  This should really be based on the
        // length of the longest label string, but we need a UI string length
        // function in order to do this.

        int labelWidth = 100;

        // Flags indicating whether certain controls are active.

	int valueActive = 1;
	int connectionActive = 1;
	int portActive = 1;
	int baseTypeActive = 1;
	int arrayActive = 1;
        int editable = 1;

        // The page's UI components are defined in the following macro,
        // which is specified as the Group subobject of an instancer object
        // that prevents the objects from being instanced until the page
        // is displayed.

        widgets {

            // Label and text widget for setting the object name.

            UIlabel nameLabel {
                label = "NE_OE_DECL_NAME";
                parent => <-.panel;
                x = 0;
                y => <-.nameText.y + 5;
                width => <-.<-.labelWidth;
                alignment = 0;
                active => <-.<-.editable;
            };

            UItext nameText {
                parent => <-.panel;
                x => <-.nameLabel.width + 5;
                y = 3;
                width => <-.panel.clientWidth - x - 3;
                height = 33;
                text => <-.<-.declarationModule.name;
                updateMode = 3;
                active => <-.<-.editable;
            };

            // Option menu for setting the reference mode.  This is
            // available for groups only.

            UIlabel refModeLabel {
                label = "NE_OE_DECL_REFMODE";
                parent => <-.panel;
                x = 0;
                y => <-.refModeMenu.y + 5;
                width => <-.<-.labelWidth;
                alignment = 0;
                visible => <-.refModeMenu.visible;
                active => <-.<-.editable;
            };

            UIoptionMenu30 refModeMenu {
                parent => <-.panel;
                x => <-.refModeLabel.width + 5;
                y => <-.nameText.y + <-.nameText.height + 5;
                optionLabel = 0;
                cmdList => { <-.byValOption,
                             <-.byRefOption,
                             <-.byPtrOption };
                selectedItem => <-.<-.declarationModule.ref_mode;
                visible => <-.<-.declarationModule.ref_mode_active;
                active => <-.<-.editable;
            };

            UIoption byValOption { label = "NE_OE_DECL_BYVAL"; };
            UIoption byRefOption { label = "NE_OE_DECL_BYREF"; };
            UIoption byPtrOption { label = "NE_OE_DECL_BYPTR"; };

            // Option menu for setting the base type.  This is
            // available for primitives only.  Note that this is never
            // visible at the same time as the reference mode option menu;
            // the attachement specifications assume this.

            UIlabel baseTypeLabel {
                label = "NE_OE_DECL_TYPE";
                parent => <-.panel;
                x = 0;
                y => <-.baseTypeMenu.y + 5;
                width => <-.<-.labelWidth;
                alignment = 0;
                visible => <-.baseTypeMenu.visible;
		active => (<-.<-.baseTypeActive &&
                           <-.<-.editable);
            };

            UIoptionMenu30 baseTypeMenu {
                parent => <-.panel;
                x => <-.baseTypeLabel.width + 5;
                y => <-.nameText.y + <-.nameText.height + 5;
                optionLabel = 0;
                cmdList => { <-.primOption,
			     <-.charOption,
			     <-.byteOption,
                             <-.shortOption,
                             <-.intOption,
                             <-.longOption,
                             <-.floatOption,
                             <-.doubleOption};
                selectedItem => <-.<-.declarationModule.base_type;
                visible => <-.<-.declarationModule.base_type_active;
		active => (<-.<-.baseTypeActive &&
                           <-.<-.editable);
            };

            UIoption primOption   { label = "prim"; };
            UIoption charOption   { label = "char"; };
            UIoption byteOption   { label = "byte"; };
            UIoption shortOption  { label = "short"; };
            UIoption intOption    { label = "int"; };
            UIoption longOption   { label = "long"; };
            UIoption floatOption  { label = "float"; };
            UIoption doubleOption { label = "double"; };

            // Option box for setting the "export" and port levels properties.

            UIoptionBox portOptionBox {
                parent => <-.panel;
                cmdList => { <-.exportOption,
                             <-.inputPortOption,
                             <-.outputPortOption };
                x = 0;

                // This widget is below the reference mode menu or the base
                // type menu, if either is visible.  Otherwise, it is below
                // the name text widget.

                y => <-.nameText.y + <-.nameText.height + 5 +
                     (<-.refModeMenu.visible  * <-.refModeMenu.height) +
                     (<-.baseTypeMenu.visible * <-.baseTypeMenu.height);
                width => <-.panel.clientWidth;
		active => (<-.<-.portActive &&
                           <-.<-.editable);
            };

            UIoption exportOption {
                label = "NE_OE_DECL_EXPORT";
                set => <-.<-.declarationModule.export;
		active => (<-.<-.portActive &&
                           <-.<-.editable);
            };

            UIoption inputPortOption {
                label = "NE_OE_DECL_IPORT";
                set => <-.<-.declarationModule.input_port;
                active => (<-.<-.declarationModule.conn_active &&
                           <-.<-.portActive &&
                           <-.<-.editable);
            };

            UIoption outputPortOption {
                label = "NE_OE_DECL_OPORT";
                set => <-.<-.declarationModule.output_port;
		active => (<-.<-.portActive &&
                           <-.<-.editable);
            };

            // This section controls whether or not the object is an
            // array.  It also controls the dimensions of the array.
            // This is available for objects that can have dimensions.

            UItoggle arrayToggle {
                label = "NE_OE_DECL_ARRAY";
                parent => <-.panel;
                x = 0;
                y => <-.portOptionBox.y + <-.portOptionBox.height + 5;
                width => <-.panel.clientWidth;
                height = 30;
                set => <-.<-.declarationModule.array;
                visible => <-.<-.declarationModule.array_active;
		active => (<-.<-.arrayActive &&
                           <-.<-.editable);
            };

            UIlabel dimsLabel {
                label = "NE_OE_DECL_DIMS";
                parent => <-.panel;
                x = 0;
                y => <-.dimsText.y + 5;
                width => <-.<-.labelWidth;
                alignment = 0;
                visible => <-.arrayToggle.visible;
                active => <-.arrayToggle.set;
            };

            UItext dimsText {
                parent => <-.panel;
                x => <-.dimsLabel.width + 5;
                y => <-.arrayToggle.y + <-.arrayToggle.height + 5;
                width => <-.panel.clientWidth - x - 3;
                height = 33;
                text => <-.<-.declarationModule.dims;
                updateMode = 3;
                visible => <-.arrayToggle.visible;
                active => <-.arrayToggle.set;
            };

            // This section controls the object's value and/or connection.
            // The value field is available for primitive objects, and the
            // connection field is available for everything except by-value
            // groups.

            UIlabel valueLabel {
                label => "NE_OE_DECL_VAL" + " =";
                parent => <-.panel;
                x = 0;
                y => <-.valueText.y + 5;
                width => <-.<-.labelWidth;
                alignment = 0;
                visible => <-.<-.declarationModule.value_active;
		active => <-.<-.valueActive;
            };

            UItext valueText {
                parent => <-.panel;
                x => <-.valueLabel.width + 5;

                // This widget is below the dimensions widget, if it is
                // visible.  Otherwise, it is below the export option box.

                y =>    <-.arrayToggle.y
                     + (<-.arrayToggle.visible * (<-.arrayToggle.height + 5))
                     + (<-.dimsText.visible    * (<-.dimsText.height + 5));

                width => <-.panel.clientWidth - x - 3;
                height = 33;
                text => <-.<-.declarationModule.value;
                updateMode = 3;
                visible => <-.valueLabel.visible;
		active => <-.<-.valueActive;
            };

            UIlabel connectionLabel {
                label => "NE_OE_DECL_CONN" + " =>";
                parent => <-.panel;
                x = 0;
                y => <-.connectionText.y + 5;
                width => <-.<-.labelWidth;
                alignment = 0;
                visible => <-.<-.declarationModule.conn_active;
		active => <-.<-.connectionActive;
            };

            UItext connectionText {
                parent => <-.panel;
                x => <-.connectionLabel.width + 5;

                // This widget is below the value widget, if it is visible.
                // Otherwise, it is where the value widget would be.

                y => <-.valueText.y +
                     (<-.valueText.visible * (<-.valueText.height + 5));

                width => <-.panel.clientWidth - x - 3;
                height = 33;
                text => <-.<-.declarationModule.conn;
                updateMode = 3;
                visible => <-.connectionLabel.visible;
		active => <-.<-.connectionActive;
            };
        };
    };

    //------------------------------------------------------------------//

    // Parameter page: Controls the interaction between a parameter and
    // the methods of the module to which it belongs.

    propertyPage parameterPage {

        option.label = "NE_OE_PARAM_PAGE";
        helpTopic = "OEparameterPage";

        // This uses a lower-level module to perform the actual updates
        // to the selected object.

        OE.edit_parameter parameterModule {
            method = 0;
        };

        // The page's UI components are defined in the following macro,
        // which is specified as the Group subobject of an instancer object
        // that prevents the objects from being instanced until the page
        // is displayed.

        widgets {

            // List containing one entry for each of the module's methods.

            UIlabel methodListLabel {
                label = "NE_OE_PARAM_METHODS";
                parent => <-.panel;
                x = 5;
                y = 0;
                width => <-.panel.clientWidth;
                height = 20;
                alignment = 0;
            };

            UIlist methodList {
                parent => <-.panel;
                x = 5;
                y => <-.methodListLabel.y + <-.methodListLabel.height;
                width => <-.panel.clientWidth - 10;
                height = 75;
                selectedItem => <-.<-.parameterModule.method;
                strings => <-.<-.parameterModule.method_list;
            };

            // Option box for setting parameter attributes that affect
            // the selected method.

            UIlabel optionLabel {
                label = "NE_OE_PARAM_SETTINGS";
                parent => <-.panel;
                x = 5;
                y => <-.methodList.y + <-.methodList.height + 10;
                width => <-.panel.clientWidth;
                height = 20;
                alignment = 0;
                // visible => <-.<-.parameterModule....
                visible = 1;
            };

            // This frame's height is determined by the height of its
            // UIoptionBox child.

            UIframe optionFrame {
                parent => <-.panel;
                x = 5;
                y => <-.optionLabel.y + <-.optionLabel.height;
                width => <-.panel.clientWidth - 10;
                height => <-.attsOptionBox.height + (2 * shadowThickness);
                shadowType = 2;
                shadowThickness = 3;
                visible => <-.optionLabel.visible;
            };

            UIoptionBox attsOptionBox {
                parent => <-.optionFrame;
                cmdList => { <-.notifyOption,
                             <-.readOption,
                             <-.writeOption,
                             <-.reqOption };
                x = 0;
                y = 0;
                width => <-.optionFrame.clientWidth;
            };

            UIoption notifyOption {
                label = "NE_OE_PARAM_NOTIFY";
                set => <-.<-.parameterModule.notify_state;
            };

            UIoption readOption {
                label = "NE_OE_PARAM_READ";
                set => <-.<-.parameterModule.read_state;
            };

            UIoption writeOption {
                label = "NE_OE_PARAM_WRITE";
                set => <-.<-.parameterModule.write_state;
            };

            UIoption reqOption {
                label = "NE_OE_PARAM_REQ";
                set => <-.<-.parameterModule.req_state;
            };

            // Frame containing a message and a button that allows the
            // user to convert a method to the new style.

            UIframe convertFrame {
                parent => <-.panel;
                x = 5;
                y => <-.methodList.y + <-.methodList.height + 10;
                width => <-.panel.clientWidth - 10;
                height => <-.convertButton.y + <-.convertButton.height +
                          (2 * shadowThickness);
                shadowType = 2;
                shadowThickness = 3;
                // visible => <-.<-.parameterModule....
                visible = 0;
            };

            UIlabel convertLabel {
                label = "NE_OE_PARAM_CONVERT_MSG";
                parent => <-.convertFrame;
                x = 0;
                y = 0;
                width => <-.convertFrame.clientWidth;
                height = 60;
                alignment = 0;
            };

            UIbutton convertButton {
                label = "NE_OE_PARAM_CONVERT";
                parent => <-.convertFrame;
                x => (<-.convertFrame.clientWidth / 2) - (width / 2);
                y => <-.convertLabel.y + <-.convertLabel.height;
                width = 70;
                height = 25;
                // do => <-.<-.parameterModule...
            };
        };
    };

    //------------------------------------------------------------------//

    // Method page: Controls a method's attributes.

    propertyPage methodPage {

        option.label = "NE_OE_METH_PAGE";
        helpTopic = "OEmethodPage";

        // This uses a lower-level module to perform the actual updates
        // to the selected object.

        OE.edit_method methodModule;

        // The page's UI components are defined in the following macro,
        // which is specified as the Group subobject of an instancer object
        // that prevents the objects from being instanced until the page
        // is displayed.

        widgets {

            // Label and text widget for setting the object name.

            UIlabel nameLabel {
                label = "NE_OE_DECL_NAME";
                parent => <-.panel;
                x = 0;
                y => <-.nameText.y + 5;
                width = 100;
                alignment = 0;
            };

            UItext nameText {
                parent => <-.panel;
                x => <-.nameLabel.width + 5;
                y = 3;
                width => <-.panel.clientWidth - x - 3;
                height = 33;
                text => <-.<-.methodModule.name;
                updateMode = 3;
            };

            // Label for displaying the method type.

            UIlabel typeLabel {
                label => "NE_OE_METH_TYPE" + " " +
                         switch(<-.<-.methodModule.method_type + 1,
                                "NE_OE_METH_O",
                                "NE_OE_METH_CXX",
                                "NE_OE_METH_F");
                parent => <-.panel;
                x = 0;
                y => <-.nameText.y + <-.nameText.height + 5;
                width => <-.panel.clientWidth;
                alignment = 0;
            };

            // Option box for setting notify_inst and/or notify_deinst.

            UIoptionBox attsOptionBox {
                parent => <-.panel;
                cmdList => { <-.instOption,
                             <-.deinstOption };
                x = 0;
                y => <-.typeLabel.y + <-.typeLabel.height + 5;
                width => <-.panel.clientWidth;
            };

            UIoption instOption {
                label = "NE_OE_METH_INST";
                set => <-.<-.methodModule.notify_inst_state;
            };

            UIoption deinstOption {
                label = "NE_OE_METH_DEINST";
                set => <-.<-.methodModule.notify_deinst_state;
            };

            // Label and text widget for entering the value of the weight
            // (execution priority) property.

            UIlabel weightLabel {
                label = "NE_OE_METH_WEIGHT";
                parent => <-.panel;
                x = 0;
                y => <-.weightField.y + 5;
                width = 255;
                alignment = 0;
            };

            UIfield weightField {
                parent => <-.panel;
                x => <-.weightLabel.width + 5;
                y => <-.attsOptionBox.y + <-.attsOptionBox.height + 5;
                width => <-.panel.clientWidth - x - 3;
                height = 33;
                updateMode = 3;
		mode = 1;
                value => <-.<-.methodModule.weight;
            };

            // Label and text widget for entering the function name.
            // This is not available for C++ methods.

            UIlabel functionLabel {
                label => switch(<-.<-.methodModule.method_type + 1,
                                "NE_OE_METH_OFUNC",
       // shouldn't see this but the PC label does not implement visibility
                                "NE_OE_METH_CXXFUNC",
                                "NE_OE_METH_FFUNC");
                parent => <-.panel;
                x = 0;
                y => <-.functionText.y + 5;
                width = 220;
                alignment = 0;
                visible => (<-.<-.methodModule.method_type != 1);
            };

            UItext functionText {
                parent => <-.panel;
                x => <-.functionLabel.width + 5;
                y => <-.weightField.y + <-.weightField.height + 5;
                width => <-.panel.clientWidth - x - 3;
                height = 33;
                text => <-.<-.methodModule.meth_value;
                updateMode = 3;
                visible => <-.functionLabel.visible;
            };
        };
    };

    //------------------------------------------------------------------//

    // Source code page: Provides the ability to edit a module's source
    // code and compile a module's process.

    propertyPage sourcePage {

        option.label = "NE_OE_SRC_PAGE";
        helpTopic = "OEsourcePage";

	int+IPort2 projectEditable = 1;

        // This uses a lower-level module to perform the actual updates
        // to the selected object.

        OE.edit_source sourceModule {
	     property_name => 
		 widgets.propertyList[widgets.advancedMenu.selectedItem];
	};

        // The page's UI components are defined in the following macro,
        // which is specified as the Group subobject of an instancer object
        // that prevents the objects from being instanced until the page
        // is displayed.

        widgets {

            // Option menu for selecting the module's process.

            UIoptionMenuLabel processMenu {
                title = "NE_OE_SRC_PROC";
                parent => <-.panel;
                x = 0;
                y = 0;
                width => <-.panel.clientWidth;
                labels => <-.<-.sourceModule.process_names;
                selectedItem => <-.<-.sourceModule.process;
            };

	    UIlabel pathLabel {
		label=> "NE_OE_SRC_DIR" + " " + <-.<-.sourceModule.build_path;
		parent => <-.panel;
		x = 0;
		y => <-.processMenu.y + processMenu.height + 5;
		width => <-.panel.clientWidth;
		alignment = 0;
	    };

            // Label and text widget for setting the module's source file.

            UIlabel fileLabel {
                label = "NE_OE_SRC_FILE";
                parent => <-.panel;
                x = 0;
                y => fileText.y + 5;
                width = 110;
                alignment = 0;
            };

            UItext fileText {
                parent => <-.panel;
                x => <-.fileLabel.width + 5;
                y => <-.pathLabel.y + <-.pathLabel.height + 5;
                width => <-.panel.clientWidth - x - 3;
                height = 33;
                text => <-.<-.sourceModule.source_file;
                updateMode = 3;
            };

            // Frame containing controls for setting "advanced" properties.

            UIframe advancedFrame {
                parent => <-.panel;
                x = 5;
                y => <-.fileText.y + <-.fileText.height + 10;
                width => <-.panel.clientWidth - 10;
                height => <-.helpLabel.y + <-.helpLabel.height +
                          (2 * shadowThickness);
                shadowType = 2;
                shadowThickness = 3;
            };

            UIlabel advancedLabel {
                label = "NE_OE_SRC_PROPS";
                parent => <-.advancedFrame;
                x = 0;
                y = 0;
                width => <-.advancedFrame.clientWidth;
                alignment = 0;
            };

            UIoptionMenu30 advancedMenu {
                parent => <-.advancedFrame;
                x = 0;
                y => <-.advancedLabel.y + <-.advancedLabel.height;
                width = 120;
                optionLabel = 0;
                cmdList => propertyOptions;
		selectedItem = 0;
            };

	    string propertyList[] = {
	       "build_dir", "out_src_file", "out_hdr_file",
	       "cxx_src_files", "cxx_hdr_files",
	       "c_src_files", "c_hdr_files",
	       "f_src_files", "link_files",
	       "init_code", "pre_init_code", "hdr_code"};

	    string propertyUsage[] => {
               "NE_OE_SRC_BLDDIR",
               "NE_OE_SRC_OUTSRC",
               "NE_OE_SRC_OUTHDR",
               "NE_OE_SRC_CXXSRC",
               "NE_OE_SRC_CXXHDR",
               "NE_OE_SRC_CSRC",
               "NE_OE_SRC_CHDR",
               "NE_OE_SRC_FSRC",
               "NE_OE_SRC_LINK",
               "NE_OE_SRC_INIT",
               "NE_OE_SRC_PREINIT",
               "NE_OE_SRC_HDRCODE"};

	    UIoption propertyOptions[array_size(propertyList)] {
	       label => propertyList[index_of(propertyOptions)];
	    };

            UItext advancedText {
                parent => <-.advancedFrame;
                x => <-.advancedFrame.clientWidth - 5 - width;
                y => <-.advancedMenu.y;
                width = 250;  // ..should really be attached to the option menu
                height = 33;
                text => <-.<-.sourceModule.property_value;
                updateMode = 3;
            };

            UIlabel helpLabel {
                label => propertyUsage[advancedMenu.selectedItem];
                parent => <-.advancedFrame;
                x = 0;
                y => <-.advancedMenu.y + <-.advancedMenu.height + 5;
                width => <-.advancedFrame.clientWidth;
                alignment = 0;
            };

            // Buttons for editing source and compiling the process.

            UIbutton editButton {
                label = "NE_OE_SRC_EDIT";
                parent => <-.panel;
                x => 10;
                y => <-.advancedFrame.y + <-.advancedFrame.height + 5;
                width = 120;
                height = 25;
                do => <-.<-.sourceModule.edit_file;
		active => <-.<-.sourceModule.edit_src_active &&
			  projectEditable;
            };

            UIbutton compileButton {
                label = "NE_OE_SRC_COMPILE";
                parent => <-.panel;
                x => <-.panel.clientWidth - 10 - width;
                y => <-.editButton.y;
                width = 120;
                height = 25;
                do => <-.<-.sourceModule.compile_process;
		active => projectEditable;
            };

	    UIlabel makeEditable {
		parent => <-.panel;
		x = 5;
		y => <-.editButton.y + <-.editButton.height;
		visible => !projectEditable;
		label = "NE_INIT_USE_SAVE";
		alignment = 0;
		width => <-.panel.width;
	    };
        };
    };

    //------------------------------------------------------------------//

    // Module page: Contains launchers for the "Add Method" and
    // "Add Parameter" wizards.

    propertyPage modulePage {

        option.label = "NE_OE_MOD_PAGE";
        helpTopic = "OEmodulePage";

	link edit_obj;		  // path name of object being edited
	string cur_obj_path;	  // currently selected object in NE
	int new_param;		  // flag indicating a new param was added
	string new_param_path;    // path name of the new parameter
        GMOD.copy_on_change path_change {
	    input => cur_obj_path;
	    output => addSelected.copy_path;
	    copy_on_change<status=0>;
	};

        // This uses a lower-level module to perform the actual updates
        // to the selected object.

        OE.edit_module modModule;
        OE.add_object addMethod {
	   parent_obj => edit_obj;
	   mode = 0; // add base type
	   base_type_name=>
		widgets.methodTypes[widgets.methodMenu.selectedItem];
	   special = 1;
	   new_name = "NewMethod";
        };
        OE.add_object addParameter {
	   parent_obj => edit_obj;
	   mode = 0;
	   base_type_name=>
		widgets.paramTypes[widgets.parameterMenu.selectedItem];
	   new_name = "NewParameter";
	   new_path => <-.new_param_path;
	   done => new_param;
        };
        OE.add_object addSelected {
	   parent_obj => edit_obj;
	   mode = 1;
	   new_name = "NewParameter";
	   new_path => <-.new_param_path;
	   done => new_param;
        };
	OE.prop_group  propGroup {
	   edit_path => <-.addSelected.copy_path;
	};

        // The page's UI components are defined in the following macro,
        // which is specified as the Group subobject of an instancer object
        // that prevents the objects from being instanced until the page
        // is displayed.

        widgets {

            // Label and text widget for setting the object name.

            UIlabel nameLabel {
                label = "NE_OE_DECL_NAME";
                parent => <-.panel;
                x = 0;
                y => <-.nameText.y + 5;
                width = 100;
                alignment = 0;
            };

            UItext nameText {
                parent => <-.panel;
                x => <-.nameLabel.width + 5;
                y = 3;
                width => <-.panel.clientWidth - x - 3;
                height = 33;
                text => <-.<-.modModule.name;
                updateMode = 3;
            };

            // Frame containing controls for launching the Add Method wizard.

            UIframe methodFrame {
                parent => <-.panel;
                x = 5;
                y => <-.nameText.y +
                     (<-.nameText.visible * (<-.nameText.height + 10));
                width => <-.panel.clientWidth - 10;
                height => <-.methodMenu.y + <-.methodMenu.height +
                          (2 * shadowThickness);
                shadowType = 2;
                shadowThickness = 3;
            };

            UIlabel methodLabel {
                label = "NE_OE_MOD_METH";
                parent => <-.methodFrame;
                x = 0;
                y = 0;
                width => <-.methodFrame.clientWidth;
                alignment = 0;
            };

            UIoptionMenu30 methodMenu {
                label = "NE_OE_MOD_TYPE";
                parent => <-.methodFrame;
                x = 0;
                y => <-.methodLabel.y + <-.methodLabel.height;
                width = 300;
                cmdList => { <-.cxxmethodOption,
                             <-.omethodOption,
                             <-.fmethodOption };
		selectedItem = 0;
            };

	    // base type array order corresponds to the above order
	    string methodTypes[] = {"cxxmethod", "omethod", "fmethod"};

            UIoption cxxmethodOption {
                label = "NE_OE_MOD_METH_CXX";
            };

            UIoption omethodOption {
                label = "NE_OE_MOD_METH_O";
            };

            UIoption fmethodOption {
                label = "NE_OE_MOD_METH_F";
            };

            UIbutton methodButton {
                label = "NE_OE_MOD_ADD";
                parent => <-.methodFrame;
                x => <-.methodFrame.clientWidth - 5 - width;
                y => <-.methodMenu.y;
                width = 60;
                height = 25;
                do => <-.<-.addMethod.do;
            };

            // Frame containing controls for launching the Add
            // Parameter wizard.

            UIframe parameterFrame {
                parent => <-.panel;
                x = 5;
                y => <-.methodFrame.y +
                     (<-.methodFrame.visible * (<-.methodFrame.height + 10));
                width => <-.panel.clientWidth - 10;
                height => switch(<-.selectedText.visible + 1,
                                 <-.parameterMenu.y + <-.parameterMenu.height,
                                 <-.selectedText.y + <-.selectedText.height)
                          + (2 * shadowThickness);
                shadowType = 2;
                shadowThickness = 3;
            };

            UIlabel parameterLabel {
                label = "NE_OE_MOD_PARAM";
                parent => <-.parameterFrame;
                x = 0;
                y = 0;
                width => <-.parameterFrame.clientWidth;
                alignment = 0;
            };

            UIoptionMenu30 parameterMenu {
                label = "NE_OE_MOD_TYPE";
                parent => <-.parameterFrame;
                x = 0;
                y => <-.parameterLabel.y + <-.parameterLabel.height;
                cmdList => paramTypeOptions;
		selectedItem = 0;
            };

	    string paramTypes[] => {
		"boolean", "char", "byte", "double", "float", "group",
		"long", "int", "short", "string", "NE_OE_MOD_OTHER"
	    };

	    UIoption paramTypeOptions[array_size(paramTypes)] {
	       label => paramTypes[index_of(paramTypeOptions)];
	    };

            UIbutton parameterButton {
                label = "NE_OE_MOD_ADD";
                parent => <-.parameterFrame;
                x => <-.parameterFrame.clientWidth - 5 - width;
                y => <-.parameterMenu.y;
                width = 60;
                height = 25;
                do => <-.<-.addParameter.do;
                visible => (<-.parameterMenu.selectedItem <
                            (array_size(<-.paramTypes) - 1));
            };

            UIlabel selectedLabel {
                label = "NE_OE_MOD_SELECTED";
                parent => <-.parameterFrame;
                x = 0;
                y => <-.parameterMenu.y + <-.parameterMenu.height + 5;
                width => <-.parameterFrame.clientWidth;
                alignment = 0;
                visible => !(<-.parameterButton.visible);
            };

            UItext selectedText {
                parent => <-.parameterFrame;
                x = 0;
                y => <-.selectedLabel.y + <-.selectedLabel.height;
                width => <-.parameterFrame.clientWidth;
                height = 33;
                text => <-.<-.addSelected.copy_path;
                visible => <-.selectedLabel.visible;
                updateMode = 3;
            };

            UIbutton selectedButton {
                label = "NE_OE_MOD_ADD";
                parent => <-.parameterFrame;
                x => <-.parameterButton.x;
                y => <-.parameterButton.y;
                width = 60;
                height = 25;
                do => <-.<-.addSelected.do;
		/* If prop_group has PROP_GROUP_METHOD */
		active => <-.<-.propGroup.prop_group & 0x40;
                visible => <-.selectedLabel.visible;
            };
        };
    };

    //------------------------------------------------------------------//

   propertyPage edit_library {

        option.label = "NE_OE_LIB_PAGE";
        helpTopic = "OElibraryPage";

      OE.edit_library edit_library {
	 edit_obj<NEportLevels={3,0}>;
      };
      widgets {
	 UItoggle Sort_objects {
            label = "NE_OE_LIB_SORT";
	    parent => <-.panel;
	    x = 0;
	    set = 0;
	    width = 300;
	    y = 0;
	    set => edit_library.sort_state;
	 };
	 UItoggle Make_objects_global {
            label = "NE_OE_LIB_GLOBAL";
	    parent => <-.panel;
	    x = 0;
	    set = 0;
	    width = 300;
	    y => Sort_objects.y + Sort_objects.height + 10;
	    set => edit_library.global_state;
	 };
      };
   };

   //------------------------------------------------------------------//

   //------------------------------------------------------------------//
   //        Custom Editors
   //------------------------------------------------------------------//


    /*********************************/
    /******* edit_file_variable ******/
    /*********************************/

    propertyPage edit_file_variable {

        option.label = "NE_OE_FILE_PAGE";
        helpTopic = "OEfileVariablePage";

      int name_active = 1;
      string &offset => widgets.Start.text;
      int ncolumns=0;
      int columns[]=> widgets.columns_toggle.set;

      OE.edit_file_variable edit_file_variable {
	 edit_obj<NEportLevels={3,0}>;
	 &offset => <-.offset;
	 &ncolumns => <-.ncolumns;
	 &columns => <-.columns;
      };

      widgets {
         int col2 = 160;
	 string base_type_list[]=>{"char", "byte", "short", "int", "long", "float", "double"};

	 UIlabeledText Name {
	    parent=> <-.panel;
	    label = "NE_OE_FILE_OBJ";
	    text => <-.<-.edit_file_variable.file_name;
	    x = 0;
            y = 0;
	    width => <-.panel.clientWidth - 5 - x;
	    label_width => <-.col2;
	    active => <-.<-.name_active;
            updateMode = 3;
	 };

	 UIlabel Stored {
	    parent => <-.panel;
	    label = "NE_OE_FILE_STORAGE";
	    y => <-.Name.y + <-.Name.height + 5;
	    x = 0;
	    alignment=2;
	    width = col2;
	 };
	 UIoption ascii {
	    label = "NE_OE_FILE_ASCII";
	 };
	 UIoption binary {
	    label = "NE_OE_FILE_BINARY";
	 };
	 UIoption xdr_binary {
	    label = "NE_OE_FILE_XDR";
	 };
	 UIradioBox ascii_binary {
	    parent => <-.panel;
	    x => col2 + 5;
	    y => Stored.y;
	    cmdList => {ascii,binary, xdr_binary};
	    selectedItem => <-.<-.edit_file_variable.ascii_binary;
	    height = 60;
	 };

	 UIlabel Type {
	    parent => <-.panel;
	    label = "NE_OE_FILE_DTYPE";
	    x = 0;
	    y => base_type_menu.y + 5;
	    width => col2;
	    alignment = 2;
	 };
	 UIoption base_type_array[array_size(base_type_list)] {
	    label => base_type_list[index_of(base_type_array)];
	 };
	 UIoptionMenu30 base_type_menu {
	    optionLabel = 0;
	    parent => <-.panel;
	    x => col2 + 5;
	    y => <-.ascii_binary.y + <-.ascii_binary.height + 10;
	    cmdList => base_type_array;
	    selectedItem => <-.<-.edit_file_variable.type;
	 };

         UIheaderText Start {
	    parent=> <-.panel;
	    label = "Offset";
	    header = "NE_OE_FILE_OFFSET";
	    x = 0;
            y => <-.base_type_menu.y + <-.base_type_menu.height;
	    width => <-.panel.clientWidth - 5 - x;
	    label_width => <-.col2;
            updateMode = 3;
	 };

	 UIlabeledField Stride {
	    parent=> <-.panel;
	    label = "NE_OE_FILE_STRIDE";
	    value => <-.<-.edit_file_variable.stride;
	    x = 0;
            y => Start.y + Start.height + 10;
	    width => <-.panel.clientWidth - 5 - x;
	    label_width => <-.col2;
	    active => <-.<-.edit_file_variable.is_array & (<-.<-.edit_file_variable.ascii_binary!=0);
	    UIlabel.visible => <-.<-.panel.visible & <-.active;
	    UIfield.visible => <-.<-.panel.visible & <-.active;
            updateMode = 3;
	 };

	 UIlabeledField Ncols {
	    parent=> <-.panel;
	    label = "NE_OE_FILE_NCOLS";
	    value => <-.<-.ncolumns;
	    x = 0;
            y => Start.y + Start.height + 10;
	    width => <-.panel.clientWidth - 5 - x;
	    label_width => <-.col2;
	    active => <-.<-.edit_file_variable.is_array & (<-.<-.edit_file_variable.ascii_binary==0);
	    UIlabel.visible => <-.<-.panel.visible & <-.active;
	    UIfield.visible => <-.<-.panel.visible & <-.active;
            updateMode = 3;
	 };

	 UIlabel Read_Columns {
	    label = "NE_OE_FILE_RCOLS";
	    parent => <-.panel;
	    x = 0;
	    y => Ncols.y + Ncols.height + 10;
	    width => col2;
	    alignment=2;
	    active => <-.<-.edit_file_variable.is_array & (<-.<-.edit_file_variable.ascii_binary==0);
	    visible => <-.panel.visible & active;
	 };
	 UIscrolledWindow UIscrolledWindow {
	    parent => <-.panel;
	    x => col2 + 5;
	    y => <-.Read_Columns.y;
	    width => <-.panel.clientWidth - 5 - x;
	    resizeMode = "any";
	    height = 75;
	    virtualWidth => width-100;
	    active => <-.<-.edit_file_variable.is_array & (<-.<-.edit_file_variable.ascii_binary==0);
	    visible => <-.panel.visible & active;
	 };

/**
	 UIframe UIframe {
		parent => <-.UIscrolledWindow;
		x = 2;
		y = 2;
		width => <-.UIscrolledWindow.clientWidth - 5 - x;
		height => <-.UIscrolledWindow.virtualHeight-4;
		shadowType = "shadow_etched_in";
		shadowThickness = 2;
	 };
**/
	 UItoggle columns_toggle[<-.ncolumns] {
	    parent => <-.UIscrolledWindow;
	    label => "NE_OE_FILE_COL_NUM"+index_of(columns_toggle);
//	    width	=> <-.UIscrolledWindow.virtualWidth;
	    y => height*index_of(columns_toggle);
	    height =><-.cache_toggle.height + 8;
	};
	UItoggle cache_toggle {
	    parent => <-.panel;
	    label = "NE_OE_FILE_CACHE";
	    set => <-.<-.edit_file_variable.cache;
	    x = 0;
	    y => <-.UIscrolledWindow.y + <-.UIscrolledWindow.height;
	    width => <-.panel.clientWidth - 5 - x;
	    active => <-.<-.edit_file_variable.connect;
	};
      };
   };

    /*********************************/
    /******* edit_file_offset ******/
    /*********************************/

   propertyPage edit_file_offset {

        option.label = "NE_OE_FO_PAGE";
        helpTopic = "OEfileOffsetVariablePage";

      string operation_list[]=>{"NE_OE_FO_PATTERN",
                                "NE_OE_FO_NLINES",
                                "NE_OE_FO_NWORDS"};
      string operand_list[]=>{"pattern","nlines", "nwords"};
      string operand_help[]=>{"NE_OE_FO_PATTERN_MSG",
			      "NE_OE_FO_NLINES_MSG",
			      "NE_OE_FO_NWORDS_MSG"};

      int name_active = 1;
      string &offset => widgets.Start.text;
      string &operand => widgets.Operand.text;

      OE.edit_file_offset edit_file_offset {
	 edit_obj<NEportLevels={3,0}>;
	 &offset => <-.offset;
	 &operand => <-.operand;
	 operation = 0;
      };

      widgets {
         int col2 = 160;

	 UIlabeledText Name {
	    parent=> <-.panel;
	    label = "NE_OE_FILE_OBJ";
	    text => <-.<-.edit_file_offset.file_name;
	    x = 0;
            y = 0;
	    width => <-.panel.clientWidth - 5 - x;
	    label_width => <-.col2;
	    active => <-.<-.name_active;
            updateMode = 3;
	 };

         UIheaderText Start {
	    parent=> <-.panel;
	    label = "offset";
	    header = "NE_OE_FILE_OFFSET";
	    x = 0;
            y => <-.Name.y + <-.Name.height + 10;
	    width => <-.panel.clientWidth - 5 - x;
	    label_width => <-.col2;
            updateMode = 3;
	 };

	 UIlabel Operation {
	    parent => <-.panel;
	    label = "NE_OE_FO_OPERATION";
	    x = 0;
	    y => Start.y + Start.height + 10;
	    width => <-.col2;
	    alignment = 2;
	 };
	 UIoption operation_array[array_size(operation_list)] {
	    label => operation_list[index_of(operation_array)];
	    active => <-.<-.edit_file_offset.connect;
	 };
	 UIradioBox operation_box {
	    parent => <-.panel;
	    x => <-.Operation.x + <-.Operation.width + 5;
	    y => Operation.y;
	    width => <-.panel.clientWidth - 5 - x;
	    cmdList => operation_array;
	    selectedItem => <-.<-.edit_file_offset.operation;
	    active => <-.<-.edit_file_offset.connect;
	 };

	 UIheaderText Operand {
	    parent=> <-.panel;
	    label => operand_list[operation_box.selectedItem];
	    header => operand_help[operation_box.selectedItem];
	    x = 0;
            y => <-.operation_box.y + <-.operation_box.height + 10;
	    width => <-.panel.clientWidth - 5 - x;
	    label_width => <-.col2;
            updateMode = 3;
	 };

	 UItoggle cache_toggle {
	    parent => <-.panel;
	    label = "NE_OE_FILE_CACHE";
	    set => <-.<-.edit_file_offset.cache;
	    x = 0;
	    y => <-.Operand.y + <-.Operand.height + 10;
	    width => <-.panel.clientWidth - 5 - x;
	    active => <-.<-.edit_file_offset.connect;
	};
      };
   };


    /*********************************/
    /******* edit_mesh          ******/
    /*********************************/

   propertyPage edit_mesh {

        option.label = "NE_OE_MESH_PAGE";
        helpTopic = "OEmeshPage";

      string mesh_type_list[]=>{"NE_OE_MESH_UNIF",
                                "NE_OE_MESH_RECT",
                                "NE_OE_MESH_STRUCT",
                                "NE_OE_MESH_UNSTRUCT"};

      OE.edit_mesh edit_mesh {
	 edit_obj<NEportLevels={3,0}>;
      };

      widgets {
         int col2 = 220;

	 UIlabel Type {
	    parent => <-.panel;
	    label = "NE_OE_MESH_TYPE";
	    x = 0;
	    y => <-.mesh_type_box.y + 5;
	    width => col2;
	    alignment = 2;
	 };
	 UIoption mesh_type_array[array_size(mesh_type_list)] {
	    label => mesh_type_list[index_of(mesh_type_array)];
	 };

	UIoptionMenu30 mesh_type_box {
	    optionLabel = 0;
	    parent => <-.panel;
	    x => col2 + 5;
	    y = 5;
            width = 120;
	    cmdList => mesh_type_array;
	    selectedItem => <-.<-.edit_mesh.mesh_type;
	 };
	 UIlabeledText Nspace {
	    parent=> <-.panel;
	    label = "NE_OE_MESH_NSPACE";
	    text => <-.<-.edit_mesh.nspace;
	    x = 0;
            y => <-.mesh_type_box.y + <-.mesh_type_box.height + 5;
	    width => <-.panel.clientWidth - 5 - x;
	    label_width => <-.col2;
	    active = 1;
            updateMode = 3;
	 };
	 UIlabeledText Ndim {
	    parent=> <-.panel;
	    label = "NE_OE_MESH_NDIM";
	    text => <-.<-.edit_mesh.ndim;
	    x = 0;
            y => <-.Nspace.y + <-.Nspace.height + 5;
	    width => <-.panel.clientWidth - 5 - x;
	    label_width => <-.col2;
	    active => <-.<-.edit_mesh.ndim_active;
            updateMode = 3;
	 };

	 UIlabeledText Dims {
	    parent=> <-.panel;
	    label = "NE_OE_MESH_DIMS";
	    text => <-.<-.edit_mesh.dims;
	    x = 0;
            y => <-.Ndim.y + <-.Ndim.height + 5;
	    width => <-.panel.clientWidth - 5 - x;
	    label_width => <-.col2;
	    active => <-.<-.edit_mesh.dims_active;
            updateMode = 3;
	 };

	 UIlabeledText Nnode {
	    parent=> <-.panel;
	    label = "NE_OE_MESH_NNODES";
	    text => <-.<-.edit_mesh.nnodes;
	    x = 0;
            y => <-.Dims.y + <-.Dims.height + 5;
	    width => <-.panel.clientWidth - 5 - x;
	    label_width => <-.col2;
	    active => <-.<-.edit_mesh.nnodes_active;
            updateMode = 3;
	 };

	 UIlabeledText Points {
	    parent=> <-.panel;
	    label = "NE_OE_MESH_POINTS";
	    text => <-.<-.edit_mesh.points;
	    x = 0;
            y => <-.Nnode.y + <-.Nnode.height + 5;
	    width => <-.panel.clientWidth - 5 - x;
	    label_width => <-.col2;
	    active => <-.<-.edit_mesh.points_active;
            updateMode = 3;
	 };

	 UIlabeledText Coordinates {
	    parent=> <-.panel;
	    label = "NE_OE_MESH_COORDS";
	    text => <-.<-.edit_mesh.coordinates;
	    x = 0;
            y => <-.Points.y + <-.Points.height + 5;
	    width => <-.panel.clientWidth - 5 - x;
	    label_width => <-.col2;
	    active => <-.<-.edit_mesh.coordinates_active;
            updateMode = 3;
	 };
	 UIbutton add_node_data_button {
            parent => <-.panel;
            label => "NE_OE_MESH_ADD_NODE_DATA";
	    y => <-.Coordinates.y + <-.Coordinates.height+10;
	    x = 10;
            do => <-.<-.edit_mesh.add_node_data;
	    active => <-.<-.edit_mesh.add_node_data_active;
         };
	 UIbutton add_cell_data_button {
            parent => <-.panel;
            label => "NE_OE_MESH_ADD_CELL_DATA";
	    y => <-.Coordinates.y + <-.Coordinates.height+10;
	    x => col2+5;
            do => <-.<-.edit_mesh.add_cell_data;
	    active => <-.<-.edit_mesh.add_cell_data_active;
         };
	 UItoggle port_toggle {
	    parent => <-.panel;
	    label = "NE_OE_MESH_ADD_PORTS";
	    set => <-.<-.edit_mesh.add_ports;
	    x = 0;
	    y => <-.add_cell_data_button.y + <-.add_cell_data_button.height + 10;
	    width => <-.panel.clientWidth - 5 - x;
	    active = 1;
	};
      };
   };

    /*********************************/
    /******* edit_cell_set      ******/
    /*********************************/

   propertyPage edit_cell_set {

        option.label = "NE_OE_CSET_PAGE";
        helpTopic = "OEcellSetPage";

      string cell_type_list[]=>{ "NE_OE_CSET_CSET",
                                 "NE_OE_CSET_POINT",
                                 "NE_OE_CSET_LINE",
                                 "NE_OE_CSET_POLYLINE",
                                 "NE_OE_CSET_TRI",
                                 "NE_OE_CSET_POLYTRI",
                                 "NE_OE_CSET_QUAD",
                                 "NE_OE_CSET_POLYH",
                                 "NE_OE_CSET_HEX",
                                 "NE_OE_CSET_PYR",
                                 "NE_OE_CSET_PRISM",
                                 "NE_OE_CSET_TET",
                                 "NE_OE_CSET_LINE2",
                                 "NE_OE_CSET_TRI2",
                                 "NE_OE_CSET_QUAD2",
                                 "NE_OE_CSET_TET2",
                                 "NE_OE_CSET_HEX2",
                                 "NE_OE_CSET_PRISM2",
                                 "NE_OE_CSET_PYR2" };

      string ncells_name[]=>{"NE_OE_CSET_NCELLS", "NE_OE_CSET_NPOLYS"};
      string connect_name[]={"node_connect_list","poly_connect_list"};

      OE.edit_cell_set edit_cell_set {
	 edit_obj<NEportLevels={3,0}>;
      };

      widgets {
         int col2 = 160;

	 UIlabeledField Nsets {
	    parent=> <-.panel;
	    label ="NE_OE_CSET_NCSETS";
	    value => <-.<-.edit_cell_set.ncell_sets;
	    x = 0;
            y = 0;
	    width => <-.panel.clientWidth - 5 - x;
	    label_width => <-.col2;
	    active => <-.<-.edit_cell_set.ncell_sets_active;
            updateMode = 3;
	 };

	 UIlabel Cell_Set_Label {
	    parent => <-.panel;
	    label = "NE_OE_CSET_CURRSET";
	    x = 0;
	    y => <-.cell_set_box.y + 5;
	    width => col2;
	    alignment = 2;
	    active => <-.<-.edit_cell_set.cell_set_active;
	 };
	 UIoption cell_set_array[<-.edit_cell_set.ncell_sets] {
	    label => "NE_OE_CSET_SET_NUM" + index_of(cell_set_array);
	    active => <-.<-.edit_cell_set.cell_set_active;
	 };
	 UIoptionMenu30 cell_set_box {
            optionLabel = 0;
	    parent => <-.panel;
	    x => col2 + 5;
	    y => <-.Nsets.y + <-.Nsets.height + 5;
	    cmdList => cell_set_array;
	    selectedItem => <-.<-.edit_cell_set.cell_set;
	    active => <-.<-.edit_cell_set.cell_set_active;
	 };

	 UIlabel Type {
	    parent => <-.panel;
	    label = "NE_OE_CSET_TYPE";
	    x = 0;
	    y => <-.cell_type_box.y + 5;
	    width => col2;
	    alignment = 2;
	    active => <-.<-.edit_cell_set.cell_type_active;
	 };
	 UIoption cell_type_array[array_size(cell_type_list)] {
	    label => cell_type_list[index_of(cell_type_array)];
	    active => <-.<-.edit_cell_set.cell_type_active;
	 };
	 UIoptionMenu30 cell_type_box {
            optionLabel = 0;
	    parent => <-.panel;
	    x => col2 + 5;
	    y => <-.cell_set_box.y + <-.cell_set_box.height + 5;
	    cmdList => cell_type_array;
	    selectedItem => <-.<-.edit_cell_set.cell_type;
	    active => <-.<-.edit_cell_set.cell_type_active;
	 };


	 UIlabeledText Ncells {
	    parent=> <-.panel;
	    label => <-.<-.ncells_name[edit_cell_set.poly_flag];
	    text => <-.<-.edit_cell_set.ncells;
	    x = 0;
            y => <-.cell_type_box.y + <-.cell_type_box.height + 5;
	    width => <-.panel.clientWidth - 5 - x;
	    label_width => <-.col2;
	    active => <-.<-.edit_cell_set.ncells_active;
            updateMode = 3;
	 };
	 UIlabeledText Connect {
	    parent=> <-.panel;
	    label => <-.<-.connect_name[edit_cell_set.poly_flag];
	    text => <-.<-.edit_cell_set.connect_list;
	    x = 0;
            y => <-.Ncells.y + <-.Ncells.height + 5;
	    width => <-.panel.clientWidth - 5 - x;
	    label_width => <-.col2;
	    active => <-.<-.edit_cell_set.connect_list_active;
            updateMode = 3;
	 };

	 UIlabeledText Poly {
	    parent=> <-.panel;
	    label = "poly_nnodes";
	    text => <-.<-.edit_cell_set.poly_nnodes;
	    x = 0;
            y => <-.Connect.y + <-.Connect.height + 5;
	    width => <-.panel.clientWidth - 5 - x;
	    label_width => <-.col2;
	    active => <-.<-.edit_cell_set.poly_nnodes_active;
            updateMode = 3;
	 };

	 UIlabeledText Concave {
	    parent=> <-.panel;
	    label = "concave_flag";
	    text => <-.<-.edit_cell_set.concave_flag;
	    x = 0;
            y => <-.Poly.y + <-.Poly.height + 5;
	    width => <-.panel.clientWidth - 5 - x;
	    label_width => <-.col2;
	    active => <-.<-.edit_cell_set.concave_flag_active;
            updateMode = 3;
	 };

	 UIlabeledText Name {
	    parent=> <-.panel;
	    label = "NE_OE_CSET_NAME";
	    text => <-.<-.edit_cell_set.name;
	    x = 0;
            y => <-.Concave.y + <-.Concave.height + 5;
	    width => <-.panel.clientWidth - 5 - x;
	    label_width => <-.col2;
	    active => <-.<-.edit_cell_set.name_active;
            updateMode = 3;
	 };
	 UItoggle port_toggle {
	    parent => <-.panel;
	    label = "NE_OE_CSET_ADD_PORTS";
	    set => <-.<-.edit_cell_set.add_ports;
	    x = 0;
	    y => <-.Name.y + <-.Name.height + 5;
	    width => <-.panel.clientWidth - 5 - x;
	    active = 1;
	 };
      };
   };


    /*********************************/
    /******* edit_node_data ******/
    /*********************************/

   propertyPage edit_node_data {

        option.label = "NE_OE_NODE_PAGE";
        helpTopic = "OEnodeDataPage";

      string data_id_list[]=>{"NE_OE_NODE_NO_ID", "NORMALS", "COLORS", "RADIUS", "RGB",
			   "UVW", "PICK"};
      string base_type_list[]=>{"byte", "char", "short", "int", "long", "float", "double"};

      OE.edit_node_data edit_node_data {
	 edit_obj<NEportLevels={3,0}>;
      };

      widgets {
         int col2 = 160;

	 UIlabeledField Ncomp {
	    parent=> <-.panel;
	    label ="NE_OE_NODE_NNODE_DATA";
	    value => <-.<-.edit_node_data.nnode_data;
	    x = 0;
            y = 0;
	    width => <-.panel.clientWidth - 5 - x;
	    label_width => <-.col2;
	    active = 1;
            updateMode = 3;
	 };

	 UIlabel Node_Data_Label {
	    parent => <-.panel;
	    label = "NE_OE_NODE_CURRENT";
	    x = 0;
	    width = col2;
	    y => <-.node_data_box.y + 5;
	    alignment = 2;
	    active => <-.<-.edit_node_data.node_data_active;
	 };
	 UIoption node_data_array[<-.edit_node_data.nnode_data] {
	    label => "NE_OE_NODE_COMP_NUM" + index_of(node_data_array);
	    active => <-.<-.edit_node_data.node_data_active;
	 };
	 UIoptionMenu30 node_data_box {
            optionLabel = 0;
	    parent => <-.panel;
	    x => col2 + 5;
	    y => <-.Ncomp.y + <-.Ncomp.height + 5;
	    cmdList => node_data_array;
	    selectedItem => <-.<-.edit_node_data.node_data;
	    active => <-.<-.edit_node_data.node_data_active;
	 };

	UIlabel Type {
	    parent => <-.panel;
	    label = "NE_OE_NODE_DTYPE";
	    x = 0;
	    y => <-.base_type_menu.y + 5;
	    width => col2;
	    alignment = 2;
	    active => <-.<-.edit_node_data.node_data_active;
	 };
	 UIoption base_type_array[array_size(base_type_list)] {
	    label => base_type_list[index_of(base_type_array)];
	 };
	 UIoptionMenu30 base_type_menu {
	    optionLabel = 0;
	    parent => <-.panel;
	    x => col2 + 5;
	    y => <-.node_data_box.y + <-.node_data_box.height + 5;
	    cmdList => base_type_array;
	    selectedItem => <-.<-.edit_node_data.data_type;
	    active => <-.<-.edit_node_data.node_data_active;
	 };

	 UIlabeledField Veclen {
	    parent=> <-.panel;
	    label = "veclen";
	    value => <-.<-.edit_node_data.veclen;
	    x = 0;
            y => <-.base_type_menu.y + <-.base_type_menu.height + 5;
	    width => <-.panel.clientWidth - 5 - x;
	    label_width => <-.col2;
	    active = 1;
	    active => <-.<-.edit_node_data.node_data_active;
            updateMode = 3;
	 };

	 UIlabeledText Labels {
	    parent=> <-.panel;
	    label = "NE_OE_NODE_DLABEL";
	    text => <-.<-.edit_node_data.labels;
	    x = 0;
            y => <-.Veclen.y + <-.Veclen.height + 5;
	    width => <-.panel.clientWidth - 5 - x;
	    label_width => <-.col2;
	    active => <-.<-.edit_node_data.node_data_active;
            updateMode = 3;
	 };

	 UIlabel Id {
	    parent => <-.panel;
	    label = "NE_OE_NODE_SPEC_ID";
	    x = 0;
	    y => <-.data_id_box.y + 5;
	    width = col2;
	    alignment = 2;
	    active => <-.<-.edit_node_data.node_data_active;
	 };
	 UIoption data_id_array[array_size(data_id_list)] {
	    label => data_id_list[index_of(data_id_array)];
	    active => <-.<-.edit_node_data.node_data_active;
	 };
	 UIoptionMenu30 data_id_box {
	    optionLabel = 0;
	    parent => <-.panel;
	    x => col2 + 5;
	    y => <-.Labels.y + <-.Labels.height + 5;
	    cmdList => data_id_array;
	    selectedItem => <-.<-.edit_node_data.data_id;
	    active => <-.<-.edit_node_data.node_data_active;
	 };

	 UIlabeledText Values {
	    parent=> <-.panel;
	    label = "NE_OE_NODE_DVALS";
	    text => <-.<-.edit_node_data.values;
	    x = 0;
            y => <-.data_id_box.y + <-.data_id_box.height + 5;
	    width => <-.panel.clientWidth - 5 - x;
	    label_width => <-.col2;
	    active => <-.<-.edit_node_data.node_data_active;
            updateMode = 3;
	 };
	 UItoggle port_toggle {
	    parent => <-.panel;
	    label = "NE_OE_NODE_ADD_PORTS";
	    set => <-.<-.edit_node_data.add_ports;
	    x = 0;
	    y => <-.Values.y + <-.Values.height + 5;
	    width => <-.panel.clientWidth - 5 - x;
	    active = 1;
	 };
      };
   };

    /*********************************/
    /******* edit_cell_data ******/
    /*********************************/

   propertyPage edit_cell_data {

        option.label = "NE_OE_CELL_PAGE";
        helpTopic = "OEcellDataPage";

      string data_id_list[]=>{"NE_OE_NODE_NO_ID", "NORMALS", "COLORS"};
      string base_type_list[]=>{"byte", "char", "short", "int", "long", "float", "double"};

      OE.edit_cell_data edit_cell_data {
	 edit_obj<NEportLevels={3,0}>;
      };

      widgets {
         int col2 = 160;

	 UIlabeledField Ncomp {
	    parent=> <-.panel;
	    label ="NE_OE_CELL_NCELL_DATA";
	    value => <-.<-.edit_cell_data.ncell_data;
	    x = 0;
            y = 0;
	    width => <-.panel.clientWidth - 5 - x;
	    label_width => <-.col2;
	    active = 1;
            updateMode = 3;
	 };

	 UIlabel Cell_Data_Label {
	    parent => <-.panel;
	    label = "NE_OE_NODE_CURRENT";
	    x = 0;
	    width = col2;
	    y => <-.cell_data_box.y + 5;
	    alignment = 2;
	    active => <-.<-.edit_cell_data.cell_data_active;
	 };
	 UIoption cell_data_array[<-.edit_cell_data.ncell_data] {
	    label => "NE_OE_NODE_COMP_NUM" + index_of(cell_data_array);
	    active => <-.<-.edit_cell_data.cell_data_active;
	 };
	 UIoptionMenu30 cell_data_box {
	    optionLabel = 0;
	    parent => <-.panel;
	    x => col2 + 5;
	    y => <-.Ncomp.y + <-.Ncomp.height + 5;
	    cmdList => cell_data_array;
	    selectedItem => <-.<-.edit_cell_data.cell_data;
	    active => <-.<-.edit_cell_data.cell_data_active;
	 };

	UIlabel Type {
	    parent => <-.panel;
	    label = "NE_OE_NODE_DTYPE";
	    x = 0;
	    y => <-.base_type_menu.y + 5;
	    width => col2;
	    alignment = 2;
	    active => <-.<-.edit_cell_data.cell_data_active;
	 };
	 UIoption base_type_array[array_size(base_type_list)] {
	    label => base_type_list[index_of(base_type_array)];
	 };
	 UIoptionMenu30 base_type_menu {
	    optionLabel = 0;
	    parent => <-.panel;
	    x => col2 + 5;
	    y => <-.cell_data_box.y + <-.cell_data_box.height + 5;
	    cmdList => base_type_array;
	    selectedItem => <-.<-.edit_cell_data.data_type;
	    active => <-.<-.edit_cell_data.cell_data_active;
	 };

	 UIlabeledField Veclen {
	    parent=> <-.panel;
	    label = "veclen";
	    value => <-.<-.edit_cell_data.veclen;
	    x = 0;
            y => <-.base_type_menu.y + <-.base_type_menu.height + 5;
	    width => <-.panel.clientWidth - 5 - x;
	    label_width => <-.col2;
	    active = 1;
	    active => <-.<-.edit_cell_data.cell_data_active;
            updateMode = 3;
	 };

	 UIlabeledText Labels {
	    parent=> <-.panel;
	    label = "NE_OE_NODE_DLABEL";
	    text => <-.<-.edit_cell_data.labels;
	    x = 0;
            y => <-.Veclen.y + <-.Veclen.height + 5;
	    width => <-.panel.clientWidth - 5 - x;
	    label_width => <-.col2;
	    active => <-.<-.edit_cell_data.cell_data_active;
            updateMode = 3;
	 };

	 UIlabel Id {
	    parent => <-.panel;
	    label = "NE_OE_NODE_SPEC_ID";
	    x = 0;
	    y => <-.data_id_box.y + 5;
	    width = col2;
	    alignment = 2;
	    active => <-.<-.edit_cell_data.cell_data_active;
	 };
	 UIoption data_id_array[array_size(data_id_list)] {
	    label => data_id_list[index_of(data_id_array)];
	    active => <-.<-.edit_cell_data.cell_data_active;
	 };
	 UIoptionMenu30 data_id_box {
	    optionLabel = 0;
	    parent => <-.panel;
	    x => col2 + 5;
	    y => <-.Labels.y + <-.Labels.height + 5;
	    cmdList => data_id_array;
	    selectedItem => <-.<-.edit_cell_data.data_id;
	    active => <-.<-.edit_cell_data.cell_data_active;
	 };

	 UIlabeledText Values {
	    parent=> <-.panel;
	    label = "NE_OE_NODE_DVALS";
	    text => <-.<-.edit_cell_data.values;
	    x = 0;
            y => <-.data_id_box.y + <-.data_id_box.height + 5;
	    width => <-.panel.clientWidth - 5 - x;
	    label_width => <-.col2;
	    active => <-.<-.edit_cell_data.cell_data_active;
            updateMode = 3;
	 };
	 UItoggle port_toggle {
	    parent => <-.panel;
	    label = "NE_OE_CELL_ADD_PORTS";
	    set => <-.<-.edit_cell_data.add_ports;
	    x = 0;
	    y => <-.Values.y + <-.Values.height + 5;
	    width => <-.panel.clientWidth - 5 - x;
	    active = 1;
	 };
      };
   };

    /******************************************/
    /******* This page is used  only     ******/
    /******* in the Import Data Wizard   ******/
    /******************************************/

   propertyPage add_file_variable {

        option.label = "NE_OE_ADDFILE_PAGE";
        helpTopic = "OEaddFileVariablePage";

      OE.add_file_variable add_file_variable {
	 edit_obj<NEportLevels={3,0}>;
      };

      widgets {
         int col2 = 240;
	 UIlabel File_Variable_Help {
	    parent => <-.panel;
	    label = "NE_OE_ADDFILE_LABEL";
	    x = 0;
	    y = 10;
	    width => <-.panel.clientWidth - x;
	    height = 50;
	    alignment = 0;
	 };
	 UIbutton Add_File_Variable {
            label = "NE_OE_ADDFILE_FILEBTN";
	    parent => <-.panel;
	    do => <-.<-.add_file_variable.add_variable;
	    x = 0;
	    y => <-.File_Variable_Help.y + <-.File_Variable_Help.height+10;
	    width => col2;
	 };

         UIlabel File_Position_Help {
	    parent => <-.panel;
	    label = "NE_OE_ADDFILE_OFFSET_LABEL";
	    x = 0;
	    y => <-.Add_File_Variable.y + <-.Add_File_Variable.height + 30;
	    width => <-.panel.clientWidth - x;
	    height = 50;
	    alignment = 0;
	 };
	 UIbutton Add_File_Offset_Variable {
	    parent => <-.panel;
            label = "NE_OE_ADDFILE_OFFBTN";
	    do => <-.<-.add_file_variable.add_offset;
	    x = 0;
	    y =>  File_Position_Help.y +  File_Position_Help.height + 10;
	    width => col2;
	 };
      };
   };

    // Popup menu for NE objects inside the Object Editor.

    module NEobjEditorPopupMenu {

        NEobjPopupData             &popupData;
        NEdataObj                  &dataObj;

        NEpopupMenuShell           shell        { popupData => <-.popupData;
                                                  dataObj => <-.dataObj;
                                                  visible =>
                                                      <-.popupData.visible;
                                                  items => {
                                                      <-.close,
                                                      <-.open,
                                                      <-.show_params,
                                                      <-.modeSep,
                                                      <-.info,
                                                      <-.help,
                                                      <-.properties,
                                                      <-.deleteSep1,
                                                      <-.deleteSep2,
                                                      <-.delete };
                                                };
        NEpopupCloseItem           close        { popupData => <-.popupData;
                                                  dataObj   => <-.dataObj;   };
        NEpopupOpenItem            open         { popupData => <-.popupData;
                                                  dataObj   => <-.dataObj;   };
        NEpopupShowParamsItem      show_params  { popupData => <-.popupData;
                                                  dataObj   => <-.dataObj;   };
        NEpopupModeItemsSeparator  modeSep      { popupData => <-.popupData;
                                                  dataObj   => <-.dataObj;   };
        NEpopupInfoItem            info         { popupData => <-.popupData;
                                                  dataObj   => <-.dataObj;   };
        NEpopupHelpItem            help         { popupData => <-.popupData;
                                                  dataObj   => <-.dataObj;   };
        NEpopupPropertiesItem      properties   { popupData => <-.popupData;
                                                  dataObj   => <-.dataObj;   };
        NEpopupMenuSeparator       deleteSep1   { popupData => <-.popupData;
                                                  dataObj   => <-.dataObj;   };
        NEpopupMenuSeparator       deleteSep2   { popupData => <-.popupData;
                                                  dataObj   => <-.dataObj;   };
        NEpopupDeleteItem          delete       { popupData => <-.popupData;
                                                  dataObj   => <-.dataObj;   };
    };

    //------------------------------------------------------------------//

    // This is the definition of the UI for the Object Editor.  The Object
    // Editor contains an object display and a property sheet.
    //
    // A property sheet contains a client area which displays pages, only
    // one of which is visible at a time.  In the current implementation,
    // pages are selected using an option menu.  A property sheet also
    // contains a row of buttons along the bottom.
    //
    // The property sheet (and Object Editor) can be displayed in normal
    // or "wizard" mode.
    //
    // In "wizard" mode, the property sheet's option menu is not shown.
    // Instead, the bottom of the sheet contains buttons which can be
    // used to select the current page (although automatic selection is
    // currently unimplemented).
    //
    // Also, when the Object Editor is displayed in wizard mode, the top
    // of the editor contains a panel displaying instructional text.
    //
    // The pages apply to the "edited object", which is either the displayed
    // object or one of its descendants.  Initially, the displayed object is
    // the edited object.  The user can change the edited object by selecting
    // any subobject in the object display.

    macro objectEditor {

        // Inputs:

        int wizardMode = 0;
        string wizardString = "";  // Text for the wizard label

        string wizardTitle = "NE_OE_TITLE";  // Wizard shell title

        string wizardHelpTopic = "";  // Help topic for wizard mode

        // Visibility of method and parameter frames on "module page".

        int methodFrameVisible = 1;
        int parameterFrameVisible = 1;

        int nextActive = 1;  // Active state of "Next" button.

        int firstPage = 0;  // Indicates if current page is the first or
        int lastPage = 0;   // last page of a wizard.

        // Trigger for updating the current object and popping up the
        // editor, if necessary.

        int updateAndShow;

	int projectEditable;

        string projectDir;

        // Outputs:

        int back => backButton.do;      // Triggers from buttons
        int cancel => cancelButton.do;
        int close => shell.cancel;
        int next => nextButton.do;

        // Include an edit_control object which manages the setting of
        // the displayed object and the edited object.

        OE.edit_control editControl {

            // The edited object is the first object selected in the NE,
            // as long as it is a descendant of the displayed object.
            // (This restriction is managed internally).  However, if the
            // edit_current trigger object is set, the displayed object
            // and the edited object both change to the current_obj.

            edit_current => <-.updateAndShow;

            // The "closed" trigger clears the edited and displayed objects.

            closed => (<-.shell.visible == 0);

            // If we are in wizard mode, don't allow the current object to
            // be changed using selection in the NE.

            disable_current_obj => <-.wizardMode;
        };

        // Top level shell widget for the editor.  The title is set externally
        // if wizard mode is in use.

        UIshell shell {
            visible = 0;
            width = 640;
            height = 550;
            title => switch(<-.wizardMode + 1,
                            "NE_OE_TITLE" + " -- " + <-.editControl.edit_obj_path,
                            <-.wizardTitle);
        };

        // The visibility of the shell is changed to true or false by the
        // the trigger objects in the two parse_v objects below.

        GMOD.parse_v visibilityTrigger {
            relative = <-.<-;
            trigger => updateAndShow;
	    active => updateAndShow;
            v_commands = "shell.visible = 1;";
        };

        GMOD.parse_v invisibilityTrigger {
            relative = <-.<-;
            trigger => closeButton.do;
	    on_inst = 0;
            v_commands = "shell.visible = 0;";
        };

        // Framed label for displaying instructional text when
        // wizard mode is in use.

        UIframe wizardTextFrame {
            parent => <-.shell;
            x = 5;
            y = 5;
            width => <-.shell.clientWidth - 10;
            height = 90;
            visible => <-.wizardMode;
            shadowType = 2;
            shadowThickness = 3;
        };

        UIlabel wizardTextLabel {
            parent => <-.wizardTextFrame;
            x = 0;
            y = 0;
            width => <-.wizardTextFrame.clientWidth;
            height => <-.wizardTextFrame.clientHeight;
            label => <-.wizardString;
            alignment = 0;
        };

        // Left-side panel containing the object display.  This is
        // displayed below the wizard text frame, if it is visible.
        // The displayed object is controlled by the editControl object.

        UIpanel objDispPanel {
            parent => <-.shell;
            x = 5;
            y => 5 + (<-.wizardTextFrame.visible *
                 (<-.wizardTextFrame.y + <-.wizardTextFrame.height));
            width = 200;
#ifdef MSDOS
            height => <-.shell.clientHeight - y - 5;
#else
            height => <-.shell.clientHeight - y - 25;
#endif
        };

#ifdef NOTIFY_IS_FIXED
        NEdataObj dataObj {
            parent => <-.objDispPanel;
            inObjectEditor = 1;
            displayedObj => <-.editControl.disp_obj_out;
            editedObj => <-.editControl.edit_obj_out;
        };
        NEobjPopupData popupData;
        NEobjEditorPopupMenu objPopupMenu { popupData => <-.popupData;
                                            dataObj => <-.dataObj; };
        NEdataObj &dataObjRef => dataObj;
#else
        // TEMPORARY WORKAROUND: For some reason, if we don't put the
        // dataObj in a subobject, the object editor never pops up when
        // requested...

        group dataObjGroup {
            NEdataObj dataObj {
                parent => <-.<-.objDispPanel;
                inObjectEditor = 1;
                displayedObj => <-.<-.editControl.disp_obj_out;
                editedObj => <-.<-.editControl.edit_obj_out;
            };
            NEobjPopupData popupData;
            NEobjEditorPopupMenu objPopupMenu { popupData => <-.popupData;
                                                dataObj => <-.dataObj; };
        };
        NEdataObj &dataObjRef => dataObjGroup.dataObj;
#endif

        // Currently, the property sheet definition is embedded in this
        // object.  It will eventually be converted into a UI object.
        // The property sheet occupies the remainder of the shell.

        UIpanel propertySheet {
            parent => <-.shell;
            x => <-.objDispPanel.x + <-.objDispPanel.width + 10;
            y => <-.objDispPanel.y;
            width => <-.shell.clientWidth - x - 5;
            height => <-.objDispPanel.height;
        };

        // The option menu, located at the top of the property sheet,
        // selects the currently visible page.

        UIoptionMenu30 pageSelector {
            label => "NE_OE_PAGE_SELECTOR";
            parent => <-.propertySheet;
            x = 0;
            y = 0;
            visible => (<-.wizardMode == 0);
	    selectedItem = 0; // needs a default value

            // We want this to run after the selectCmd and other modules.
            // UI objects do not set read on cmdList right now or the deps
            // would handle this automatically

            update<weight=2>;

            cmdList => <-.selectCmd.array_output;
        };

        // The page frame, located under the option menu, is the actual
        // parent of all the pages.

        UIframe pageFrame {
            parent => <-.propertySheet;
            x = 0;
            y => <-.pageSelector.visible *
                 (<-.pageSelector.y + <-.pageSelector.height + 5);
            width => <-.propertySheet.clientWidth;
            height => <-.buttonPanel.y - y;
        };

        // The button panel, located under the page frame, contains a
        // row of buttons.  In normal mode, the Close and Help buttons
        // are displayed.  In wizard mode, the Back, Next, Cancel, and
        // Help buttons are displayed.

        UIpanel buttonPanel {
            parent => <-.propertySheet;
            x = 0;
            y => <-.propertySheet.clientHeight - height;
            width => <-.propertySheet.clientWidth;
            height = 35;
        };

        int numButtons = 4;
        int margin = 10;
        int buttonWidth = 70;
        float spacing => (   buttonPanel.clientWidth
                          - (2 * margin)
                          - (numButtons * buttonWidth))
                         / (numButtons - 1);

        UIbutton closeButton {
            label = "NE_CLOSE";
            parent => <-.buttonPanel;
            x = <-.margin;
            y = 5;
            width = <-.buttonWidth;
            height = 25;
            visible => (<-.wizardMode == 0);
        };

        UIbutton backButton {
            label = "NE_BACK";
            parent => <-.buttonPanel;
            x = <-.margin;
            y = 5;
            width = <-.buttonWidth;
            height = 25;
            visible => <-.wizardMode;
            active => (<-.firstPage == 0);
        };

        UIbutton nextButton {
            label => switch(<-.lastPage + 1, "NE_NEXT", "NE_DONE");
            parent => <-.buttonPanel;
            x => <-.backButton.x + <-.backButton.width + <-.spacing;
            y = 5;
            width = <-.buttonWidth;
            height = 25;
            visible => <-.wizardMode;
            active => <-.nextActive;
        };

        UIbutton cancelButton {
            label = "NE_CANCEL";
            parent => <-.buttonPanel;
            x => <-.nextButton.x + <-.nextButton.width + <-.spacing;
            y = 5;
            width = <-.buttonWidth;
            height = 25;
            visible => <-.wizardMode;
            active = 1;
        };

        UIbutton helpButton {
            label = "NE_HELP";
            parent => <-.buttonPanel;
            x => <-.buttonPanel.clientWidth - <-.margin - width;
            y = 5;
            width = <-.buttonWidth;
            height = 25;
            active = 0;
        };

        //----------------------------------------------------------//
        // These are the pages for the property sheet
        //----------------------------------------------------------//

        // Custom Editors

	 edit_file_variable Edit_File_Object {
	    widgets.panel {
	       visible => <-.<-.<-.visible[0];
	       parent_ref => <-.<-.<-.pageFrame;
	    };
	    option.set => 0;
	    edit_file_variable.edit_obj => editControl.edit_obj_out;
	    edit_file_variable.trigger => <-.<-.Declaration.declarationModule.array+
					  <-.<-.Declaration.declarationModule.base_type;
	 };
	 edit_file_offset Edit_File_Offset {
	    widgets.panel {
	       visible => <-.<-.<-.visible[1];
	       parent_ref => <-.<-.<-.pageFrame;
	    };
	    option.set => 0;
	    edit_file_offset.edit_obj => editControl.edit_obj_out;
	 };

	 //-----------------------------------------------------//
	 //     General Editors
	 //-----------------------------------------------------//

	 declarationPage Declaration {
	    widgets.panel {
	       visible => <-.<-.<-.visible[2];
	       parent_ref => <-.<-.<-.pageFrame;
	    };
	    option.set => 1;
	    declarationModule.edit_obj => editControl.edit_obj_out;
	    declarationModule.disp_obj => editControl.disp_obj_out;
	 };
	 parameterPage Parameter {
	    widgets.panel {
	       visible => <-.<-.<-.visible[3];
	       parent_ref => <-.<-.<-.pageFrame;
	    };
	    option.set => 0;
	    parameterModule.edit_obj => editControl.edit_obj_out;
	    parameterModule.disp_obj => editControl.disp_obj_out;
	 };
	 methodPage Method {
	    widgets.panel {
	       visible => <-.<-.<-.visible[4];
	       parent_ref => <-.<-.<-.pageFrame;
	    };
	    option.set => 0;
	    methodModule.edit_obj => editControl.edit_obj_out;
	 };
	 edit_library Library {
	    widgets.panel {
	       visible => <-.<-.<-.visible[5];
	       parent_ref => <-.<-.<-.pageFrame;
	    };
	    option.set => 0;
	    edit_library.edit_obj => editControl.edit_obj_out;
	 };
	 modulePage Module {
	    widgets.panel {
	       visible => <-.<-.<-.visible[6];
	       parent_ref => <-.<-.<-.pageFrame;
	    };
	    option.set => 0;
	    modModule.edit_obj => editControl.edit_obj_out;

            // The following assignment provides this page with access to
            // the NE's currently selected object, because the editControl's
            // current_obj is connected to the dataObj's first selected
            // object in ne_macro.v

	    cur_obj_path => editControl.current_obj;

	    edit_obj => editControl.edit_obj_out;
	    widgets {
	       nameLabel.visible => <-.<-.<-.methodFrameVisible;
	       nameText.visible => <-.<-.<-.methodFrameVisible;
	       methodFrame.visible => <-.<-.<-.methodFrameVisible;
	       parameterFrame.visible => <-.<-.<-.parameterFrameVisible;
	    };
	 };
	 sourcePage Source_Code {
	    projectEditable => <-.projectEditable;
	    widgets.panel {
	       visible => <-.<-.<-.visible[7];
	       parent_ref => <-.<-.<-.pageFrame;
	    };
	    option.set => 0;
	    sourceModule.edit_obj => editControl.edit_obj_out;
	    sourceModule.project_dir => projectDir;
	 };

	 add_file_variable Add_File_Variable {
	    widgets.panel {
	       visible => <-.<-.<-.visible[8];
	       parent_ref => <-.<-.<-.pageFrame;
	    };
	    option.set => 0;
	    add_file_variable.edit_obj => editControl.edit_obj_out;
	 };

	/*
	 * FLD - Field editors
	 */
	 edit_mesh Edit_Mesh {
	    widgets.panel {
	       visible => <-.<-.<-.visible[9];
	       parent_ref => <-.<-.<-.pageFrame;
	    };
	    option.set => 0;
	    edit_mesh.edit_obj => editControl.edit_obj_out;
	    edit_mesh.add_ports = 0;
	 };
	 edit_cell_set Edit_Cell_Set {
	    widgets.panel {
	       visible => <-.<-.<-.visible[10];
	       parent_ref => <-.<-.<-.pageFrame;
	    };
	    option.set => 0;
	    edit_cell_set.edit_obj => editControl.edit_obj_out;
	    edit_cell_set.mesh_type => <-.<-.Edit_Mesh.edit_mesh.ndim_active;
	    edit_cell_set.add_ports = 0;
	 };
	 edit_node_data Edit_Node_Data {
	    widgets.panel {
	       visible => <-.<-.<-.visible[11];
	       parent_ref => <-.<-.<-.pageFrame;
	    };
	    option.set => 0;
	    edit_node_data.edit_obj => editControl.edit_obj_out;
	    edit_node_data.mesh_type => <-.<-.Edit_Mesh.edit_mesh.ndim_active+
					<-.<-.Edit_Mesh.edit_mesh.add_node_data;
	    edit_node_data.add_ports = 0;
	 };
	 edit_cell_data Edit_Cell_Data {
	    widgets.panel {
	       visible => <-.<-.<-.visible[12];
	       parent_ref => <-.<-.<-.pageFrame;
	    };
	    option.set => 0;
	    edit_cell_data.edit_obj => editControl.edit_obj_out;
	    edit_cell_data.mesh_type => <-.<-.Edit_Mesh.edit_mesh.ndim_active+
					<-.<-.Edit_Mesh.edit_mesh.add_cell_data+
					<-.<-.Edit_Cell_Set.edit_cell_set.ncell_sets;
	    edit_cell_data.add_ports = 0;
	 };

	 int active[]=>{
			Edit_File_Object.edit_file_variable.panel_active,
			Edit_File_Offset.edit_file_offset.panel_active,
			1, /* Declaration */
			Parameter.parameterModule.panel_active,
			Method.methodModule.panel_active,
			Library.edit_library.panel_active,
			Module.modModule.panel_active,
			Source_Code.sourceModule.panel_active,
			Add_File_Variable.add_file_variable.panel_active,
			Edit_Mesh.edit_mesh.panel_active,
			Edit_Cell_Set.edit_cell_set.panel_active,
			Edit_Node_Data.edit_node_data.panel_active,
			Edit_Cell_Data.edit_cell_data.panel_active
			};
	 int ostate[]=>{
	       Edit_File_Object.option.set,
	       Edit_File_Offset.option.set,
	       Declaration.option.set,
	       Parameter.option.set,
	       Method.option.set,
	       Library.option.set,
	       Module.option.set,
	       Source_Code.option.set,
	       Add_File_Variable.option.set,
	       Edit_Mesh.option.set,
	       Edit_Cell_Set.option.set,
	       Edit_Node_Data.option.set,
	       Edit_Cell_Data.option.set
	       };
	 int visible[] => active && ostate;

	 GMOD.select_array selectCmd {
	    select => active;
	    array_input => {
			    Edit_File_Object.option,
		            Edit_File_Offset.option,
			    Declaration.option,
			    Parameter.option,
			    Method.option,
			    Library.option,
			    Module.option,
			    Source_Code.option,
			    Add_File_Variable.option,
			    Edit_Mesh.option,
			    Edit_Cell_Set.option,
			    Edit_Node_Data.option,
			    Edit_Cell_Data.option
			    };
	 };

         // This object installs the hourglass cursor when certain
         // buttons are pressed.

         NEhourglass hourglass {
             dataObj => <-.dataObjRef;
             install => (Source_Code.widgets.editButton.do |
                         Source_Code.widgets.compileButton.do);
         };

         // This array gathers together all of the help topics for the
         // various property pages.  It must be in the same order as the
         // array_input of the selectCmd above.

         string helpTopics[] => {
             Edit_File_Object.helpTopic,
             Edit_File_Offset.helpTopic,
             Declaration.helpTopic,
             Parameter.helpTopic,
             Method.helpTopic,
             Library.helpTopic,
             Module.helpTopic,
             Source_Code.helpTopic,
             Add_File_Variable.helpTopic,
             Edit_Mesh.helpTopic,
             Edit_Cell_Set.helpTopic,
             Edit_Node_Data.helpTopic,
             Edit_Cell_Data.helpTopic
         };

         // This object's output indicates the index of the currently selected
         // page.  It is used for determining the current help topic.

         GMOD.selected_index helpSelector {
             select => visible;
             output = 0;
         };

         // This object displays online help when the Help button is pressed.

         NEhelpLauncher helpLauncher {
             dataObj => <-.dataObjRef;
             topic => switch(<-.wizardMode + 1,
                             <-.helpTopics[helpSelector.output],
                             <-.wizardHelpTopic);
             do => <-.helpButton.do;
         };
    };

    //------------------------------------------------------------------//

   macro add_file_import_dialog {
      int back;
      int done;
      int cancel;
      int back_active;

      string cur_obj_path;
      string parent_path;

      string wizardTitle;
      string wizardText;

      GMOD.instancer instancer {
	 Group => <-.widgets;
	 Value => widgets.shell.visible;
	 active = 2;
      };
      macro widgets<instanced=0> {
	 OE.add_file_module add_file_module {
	    parent_path => <-.<-.parent_path;
	    do => <-.<-.done;
	    add_browser = 1;
	 };
	 UIshell shell {
	    title => <-.<-.wizardTitle;
	    width => 425;
	    height => 370;
	 };
	 int col1 = 160;
	 int col2 = 380;
	 UIframe dialogFrame {
	    x = 5;
	    y = 5;
	    parent => <-.shell;
	    width => <-.shell.clientWidth - 10;
	    height = 80;
            shadowType = 2;
            shadowThickness = 3;
	 };
	 UIlabel title {
	    parent => dialogFrame;
	    x = 5;
	    y = 5;
	    width => dialogFrame.width - 10;
	    label => <-.<-.wizardText;
	    height => dialogFrame.height - 10;
	    alignment = 0;
	 };
	 UIlabel object_name_label {
	    parent => <-.shell;
	    x = 10;
	    y => <-.object_name_typein.y + 5;
	    width => col1 - 10;
	    label = "NE_FILEIMP_NAME";
	    alignment = 2;
	 };
	 UItext object_name_typein {
	    parent => <-.shell;
	    y => dialogFrame.y + dialogFrame.height + 5;
	    x => col1 + 10;
	    width = col2-col1;
	    text => <-.add_file_module.name;
	    height = 33;
            updateMode = 3;
	 };
	 UItoggle add_ui {
	    parent => <-.shell;
	    x = col1+10;
	    y => <-.object_name_label.y + <-.object_name_label.height + 25;
	    set => <-.add_file_module.add_browser;
	    label = "NE_FILEIMP_ADD_BROWSER";
	    width => col2 - col1;
	 };
	 UIlabeledText Def_Dir {
	    parent=> <-.shell;
	    label = "NE_FILEIMP_DIR";
	    text => <-.add_file_module.default_dir;
	    x = 0;
            y => <-.add_ui.y + <-.add_ui.height + 10;
	    width => <-.col2;
	    label_width => <-.col1;
	    active => <-.add_file_module.add_browser;
            updateMode = 3;
	 };
	 UIlabeledText Def_Suff {
	    parent=> <-.shell;
	    label = "NE_FILEIMP_EXT";
	    text => <-.add_file_module.default_suffix;
	    x = 0;
            y => <-.Def_Dir.y + <-.Def_Dir.height + 10;
	    width => <-.col2;
	    label_width => <-.col1;
	    active => <-.add_file_module.add_browser;
            updateMode = 3;
	 };

	 UIbutton backButton {
	    label = "NE_BACK";
	    parent => <-.shell;
	    x => (<-.shell.clientWidth - 3 * width - 20) / 2;
	    y => <-.Def_Suff.y + <-.Def_Suff.height + 30;
	    width = 70;
	    height = 25;
	    do => <-.<-.back;
	    active => <-.<-.back_active;
	 };
	 UIbutton nextButton {
	    label = "NE_NEXT";
	    parent => <-.shell;
	    x => backButton.x + backButton.width + 10;
	    y => backButton.y;
	    width = 70;
	    height = 25;
	    active => is_valid(add_file_module.name);
	    do => <-.<-.done;
	 };
	 UIbutton cancelButton {
	    label = "NE_CANCEL";
	    parent => <-.shell;
	    x => nextButton.x + nextButton.width + 10;
	    y => backButton.y;
	    width = 70;
	    height = 25;
	    do => <-.<-.cancel;
	 };
      };
      GMOD.parse_v closeDialog {
         on_inst = 0;
         trigger => widgets.cancelButton.do;
         relative => <-;
         v_commands = "widgets.shell.visible = 0;";
      };
   };

   //------------------------------------------------------------------//

   macro check_module_parent_dialog {
      int done;
      string parent_path;
      string invalid_parent_message;
      string inactive_message;
      OE.check_module_parent  check_module_parent {
	 parent_path => <-.parent_path;
	 done => <-.done;
	 invalid_parent_error = 0;
	 inactive_error = 0;
      };
      UIerrorDialog invalidParentDialog {
         visible => <-.check_module_parent.invalid_parent_error;
         title = "NE_ERROR";
         message => <-.invalid_parent_message;
         cancelButton = 0;
      };
      UIerrorDialog inactiveDialog {
         visible => <-.check_module_parent.inactive_error;
         title = "NE_ERROR";
         message => <-.inactive_message;
         cancelButton = 0;
      };
   };
};  // flibrary OEM

}; // End of flibrary NE -- Do not add any objects after this line.

//---------------------------------------------------------------------//
//                            End of ne.v                              //
//---------------------------------------------------------------------//
