//
//                      Copyright (c) 1994 by
//                      Advanced Visual Systems Inc.
//                      All Rights Reserved
//
//      This software comprises unpublished confidential information of
//      Advanced Visual Systems Inc. and may not be used, copied or made
//      available to anyone, except in accordance with the license
//      under which it is furnished.
//
//      This file is under Perforce control
//      $Id: //depot/express/fcs70/v/ne_macro.v#1 $
//
// ne_macro.v - High-level network editor objects.
//
//---------------------------------------------------------------------//

flibrary+global NE_MACROS <
   compile_subs = 0,
   NEvisible    = 0
> {

//---------------------------------------------------------------------//

// The Unix version currently requires a correction for the
// window manager border.

#ifdef MSDOS
#define WM_BORDER 0
#else
#define WM_BORDER 26
#endif

// Definition of the default version of the network editor shell and
// pulldown menu system.

macro NEdefaultNetworkEditor <dictionary = "root.dct"> {

    // The top level shell for the NE.  This will use a menu bar that is
    // defined later in this file.  We use a special subclass of UIapp
    // that allows the status bar message to be controlled.

    UIapp appShell {
        title    => "NE_SHELL_TITLE" + " - " + dataObj.projectDir;
        iconName =  "NE_SHELL_TITLE";
        x        => (UIdata.UIdisplays[0].width * 1 / 3) - WM_BORDER;
        y        =  0;
        width    => UIdata.UIdisplays[0].width * 2 / 3;
        height   => UIdata.UIdisplays[0].height * 5 / 6;
        menu     => menuBar;
        statusString => dataObj.statusString;
	update<status=0>;
    };

    // The shell contains a panel which has an NEdataObj as its "child".
    // The NEdataObj will create the main body of the NE as a child of
    // the panel.

    UIpanel panel {
        parent => appShell;
        width  => appShell.clientWidth;
        height => appShell.clientHeight;
    };

    NEdataObj dataObj {
        parent => <-.panel;
        displayedObj+nres => Libraries;
        appObj => Applications;
        paneHeight = 227;
        appList => Templates.APPS;
    };

    // Include a dialog box for displaying NE messages.

    NEmessageDialog messageDialog { dataObj => <-.dataObj; };

    // The following object contains all methods for managing journaling.
    // A reference to the object will be passed to the Journal menu, allowing
    // connections to be established between items on that menu and subobjects
    // of this journal object.

    GMOD.journal journalObj {
        record          = 0;
    };

    // The following object contains subobjects that control the UI kit.
    // A reference to this object is passed to the UI builder menu.

    NEuiBuilderObj builderObj;

    // The menu bar is composed of a number of pulldown menus.  The
    // templates for these menus are defined in ne.v.

    NEfileMenu      fileMenu      { dataObj => <-.dataObj; };
    NEeditMenu      editMenu      { dataObj => <-.dataObj; };
    NEobjectMenu    objectMenu    { dataObj => <-.dataObj; };
    NEprojectMenu   projectMenu   { dataObj => <-.dataObj; };
    NEjournalMenu   journalMenu   { dataObj => <-.dataObj;
                                    journalObj => <-.journalObj; };
    NEuiBuilderMenu uiBuilderMenu { dataObj => <-.dataObj;
                                    builderObj => <-.builderObj; };
    NEoptionsMenu   optionsMenu   { dataObj => <-.dataObj; };
    NEhelpMenu      helpMenu      { dataObj => <-.dataObj; };
#ifdef ACKIT
    NEavsMenu	    avsMenu	  { dataObj => <-.dataObj; };
#endif

    UIcmdList menuBar {
        cmdList => { fileMenu.pulldown,
                     editMenu.pulldown,
                     objectMenu.pulldown,
                     projectMenu.pulldown,
                     journalMenu.pulldown,
                     uiBuilderMenu.pulldown,
                     optionsMenu.pulldown,
#ifdef ACKIT
		     avsMenu.pulldown,
#endif
                     helpMenu.pulldown };
    };

    // Include a popup data object and a default object popup menu.

    NEobjPopupData         popupData;

    NEdefaultObjPopupMenu  objPopupMenu { popupData => <-.popupData;
                                          dataObj => <-.dataObj; };

#define NE_DIALOG_X 300
#define NE_DIALOG_Y 150
    GMOD.instancer OEinstancer {
       Value => ObjectEditor.shell.visible | ObjectEditor.updateAndShow;
       Group => ObjectEditor;
       active = 2;
    };
    OEM.objectEditor ObjectEditor<instanced=0> {
       shell {
          visible = 0;
	  x = NE_DIALOG_X;
	  y = NE_DIALOG_Y;
       };
       updateAndShow => dataObj.displayObjectEditor;
       projectDir => dataObj.projectDir;
       projectEditable => dataObj.projectEditable;
       editControl {
	    // Must connect to the current object list in the main dataObj
	    // since this one will be updated when we are instanced the 
	    // first time.  The local one is not updated until the dataObj
	    // instance method is run.
	   current_obj => <-.<-.dataObj.curObjList[0];
       };
    };
    OE.destroy_object Destroy;

    //-----------------------------------------------------------------//

    OE.op_control BasicOp {
       next => ObjectEditor.next;
       back => ObjectEditor.back;
       cancel => ObjectEditor.cancel;
       close => ObjectEditor.close;
       relative => <-;
       group save {
	  int visible;
	  int editor_page;
	  string dialog_string;
	  string dialog_title;
	  int dialog_type;
	  string dialog_help;
	  int add_module_disabled;
	  int add_file_disabled;
	  int method_frame_vis;
	  int param_frame_vis;

	  link edit_obj_out, disp_obj_out;
	  int first_state;
	  int last_state;
          int next_active;
       };
       module_state {
          enter_commands = <"
             save {
	        visible = ObjectEditor.shell.visible;
	        editor_page = ObjectEditor.pageSelector.selectedItem;
	        dialog_string = ObjectEditor.wizardString;
	        dialog_title = ObjectEditor.wizardTitle;
	        dialog_type = ObjectEditor.wizardMode;
	        dialog_help = ObjectEditor.wizardHelpTopic;
	        add_module_disabled = AddModuleOp.disabled;
	        add_file_disabled = AddFileOp.disabled;
	        method_frame_vis = ObjectEditor.methodFrameVisible;
	        param_frame_vis = ObjectEditor.parameterFrameVisible;
	     };
             $set_obj_ref_indirect save.disp_obj_out <-.ObjectEditor.editControl.disp_obj_out
             $set_obj_ref_indirect save.edit_obj_out <-.ObjectEditor.editControl.edit_obj_out
             $set_obj_ref_indirect save.first_state <-.ObjectEditor.firstPage
             $set_obj_ref_indirect save.last_state <-.ObjectEditor.lastPage
             $set_obj_ref_indirect save.next_active <-.ObjectEditor.nextActive
          ">;
       };
    };

    //-----------------------------------------------------------------//

    OEM.check_module_parent_dialog CheckModuleParent {
       parent_path => dataObj.curObjList[0];
       invalid_parent_message = "NE_AMW_NO_PARENT";
       inactive_message = "NE_AMW_WIZARD_UP";
       check_module_parent {
           active => (ObjectEditor.shell.visible == 0 ||
                      ObjectEditor.wizardMode == 0);
   	   trigger => objectMenu.addModuleItem.cmd.do;
       };
    };
    OE.add_object AddModuleObject {
       parent_path => CheckModuleParent.parent_path;
       mode = 0;
       base_type_name = "module";
       new_name = "NewModule";
       do => CheckModuleParent.done;
    };

    //-----------------------------------------------------------------//

    BasicOp AddModuleOp {
       begin => AddModuleObject.done;
       num_states = 3;

       save {
	  string cur_module;
       };

       module_state {
          exit_commands = <"
	     ObjectEditor {
	        shell.visible = AddModuleOp.save.visible;
	        pageSelector.selectedItem = AddModuleOp.save.editor_page;
	        wizardString = AddModuleOp.save.dialog_string;
	        wizardTitle = AddModuleOp.save.dialog_title;
	        wizardMode = AddModuleOp.save.dialog_type;
	        wizardHelpTopic = AddModuleOp.save.dialog_help;
	        methodFrameVisible = AddModuleOp.save.method_frame_vis;
	        parameterFrameVisible = AddModuleOp.save.param_frame_vis;
	     };
             $set_obj_ref_indirect <-.ObjectEditor.editControl.disp_obj_out save.disp_obj_out
             $set_obj_ref_indirect <-.ObjectEditor.editControl.edit_obj_out save.edit_obj_out
             $set_obj_ref_indirect <-.ObjectEditor.firstPage save.first_state
             $set_obj_ref_indirect <-.ObjectEditor.lastPage save.last_state
             $set_obj_ref_indirect <-.ObjectEditor.nextActive save.next_active
          ">;

          cancel_commands = <"
             $push
             Destroy {
                destroy_obj => ObjectEditor.editControl.disp_obj_out;
                do = 1;
             };
             $pop
          "> + exit_commands;

          close_commands = exit_commands;
       };
    
       states = {
       {
	  enter_commands = <"
	     ObjectEditor {
		// Module page
	        pageSelector.selectedItem = 1;
	        shell.visible = 1;
		wizardMode = 1;
		wizardTitle = "NE_AMW_TITLE1";
	        wizardString = "NE_AMW_STRING1";
	        wizardHelpTopic = "AMWmain1";
	        editControl.disp_obj_path = AddModuleObject.new_path;
	        editControl.edit_obj_path = AddModuleObject.new_path;
		AddModuleOp.save.cur_module = AddModuleObject.new_path;
		methodFrameVisible = 1;
		parameterFrameVisible = 0;

	        firstPage => AddModuleOp.first_state;
	        lastPage => AddModuleOp.last_state;
	     };
	  ">,
	  exit_commands = <"
	      /* ObjectEditor.shell.visible = 0; XXX */
	  ">,
       },
       {
	  enter_commands = <"
	     ObjectEditor {
		// Module page
	        pageSelector.selectedItem = 1;
	        shell.visible = 1;
		wizardMode = 1;
		wizardTitle = "NE_AMW_TITLE2";
	        wizardString = "NE_AMW_STRING2";
	        wizardHelpTopic = "AMWmain2";
	        editControl.disp_obj_path = AddModuleObject.new_path;
	        editControl.edit_obj_path = AddModuleObject.new_path;
		AddModuleOp.save.cur_module = AddModuleObject.new_path;
		methodFrameVisible = 0;
		parameterFrameVisible = 1;

	        firstPage => AddModuleOp.first_state;
	        lastPage => AddModuleOp.last_state;
	     };
	  ">,
	  exit_commands = <"
	      /* ObjectEditor.shell.visible = 0; XXX */
	  ">,
       },
       {
	  enter_commands = <"
	     // Source_Code page...
	     ObjectEditor {
	        pageSelector.selectedItem = 2;
	        shell.visible = 1;
		wizardMode = 1;
		wizardTitle = "NE_AMW_TITLE3";
	        wizardString = "NE_AMW_STRING3";
	        wizardHelpTopic = "AMWmain3";
	        editControl.disp_obj_path = AddModuleOp.save.cur_module;
	        editControl.edit_obj_path = AddModuleOp.save.cur_module;
		methodFrameVisible = 1;
		parameterFrameVisible = 1;
	     };
	  ">,
	  exit_commands = <"
	    /* ObjectEditor.shell.visible = 0; XXX */
	  ">
       }};
    };

    //-----------------------------------------------------------------//

    BasicOp AddParameterOp {
       begin => ObjectEditor.Module.new_param;
       num_states = 2;

       save {
 	  string cur_param;
       };

       module_state {
          exit_commands = <"
	     ObjectEditor {
   
	        shell.visible = AddParameterOp.save.visible;
	        pageSelector.selectedItem = AddParameterOp.save.editor_page;
	        wizardString = AddParameterOp.save.dialog_string;
	        wizardTitle = AddParameterOp.save.dialog_title;
	        wizardMode = AddParameterOp.save.dialog_type;
	        wizardHelpTopic = AddParameterOp.save.dialog_help;
	        methodFrameVisible = AddParameterOp.save.method_frame_vis;
	        parameterFrameVisible = AddParameterOp.save.param_frame_vis;
	     };
	     AddModuleOp.disabled = AddParameterOp.save.add_module_disabled;
             $set_obj_ref_indirect <-.ObjectEditor.editControl.disp_obj_out save.disp_obj_out
             $set_obj_ref_indirect <-.ObjectEditor.editControl.edit_obj_out save.edit_obj_out
             $set_obj_ref_indirect <-.ObjectEditor.firstPage save.first_state
             $set_obj_ref_indirect <-.ObjectEditor.lastPage save.last_state
             $set_obj_ref_indirect <-.ObjectEditor.nextActive save.next_active
          ">;

          cancel_commands = <"
             $push
             Destroy {
                destroy_obj => ObjectEditor.editControl.edit_obj_out;
                do = 1;
             };
             $pop
             $push
          "> + exit_commands + <"
             $pop
          ">;

          close_commands = <"
             $push
          "> + exit_commands + <"
             $pop
             $push
             ObjectEditor.shell.cancel = 1;
             $pop
          ">;
       };
    
       states = {
       {
	  enter_commands = <"
	     // disable add module while this is on
	     AddModuleOp.disabled = 1;
	     // should be "Declaration" page...
	     ObjectEditor {
	        pageSelector.selectedItem = 0;
	        shell.visible = 1;
		wizardMode = 1;
	        editControl.edit_obj_path = Module.new_param_path;
		wizardTitle = "NE_AMW_TITLE2A";
	        wizardString = "NE_AMW_STRING2A";
	        wizardHelpTopic = "AMWparam1";
	        firstPage => AddParameterOp.first_state;
	        lastPage => AddParameterOp.last_state;
	     };
	  ">,
	  exit_commands = <"
	  ">
       },
       {
          enter_commands = <"
	     ObjectEditor {
		// Parameter page
	        pageSelector.selectedItem = 1;
		wizardTitle = "NE_AMW_TITLE2B";
	        wizardString = "NE_AMW_STRING2B";
	        wizardHelpTopic = "AMWparam2";
	     };
	  ">,
	  exit_commands = <"
/*	     ObjectEditor.shell.visible = 0; XXX */
	  ">
       }};
       // Since both the AddModuleOp and AddParameterOp methods are tied to
       // buttons on the object editor, we have to prevent the AddModuleOp
       // methods from running when we are exiting from AddParameterOp.
       // The Next and Cancel buttons can result in exits, so we make sure
       // the set_next and set_cancel methods for AddParameterOp run AFTER
       // the AddModuleOp's methods, which will run silently since AddModuleOp
       // is disabled while AddParameterOp is running.
       set_next   <weight=3>;
       set_cancel <weight=3>;
       set_close  <weight=3>;
    };

    //-----------------------------------------------------------------//

    BasicOp AddMethodOp {
       begin => ObjectEditor.Module.addMethod.done;
       num_states = 1;

       save {
 	  string cur_method;
       };

       module_state {
          exit_commands = <"
	     ObjectEditor {
	        shell.visible = AddMethodOp.save.visible;
	        pageSelector.selectedItem = AddMethodOp.save.editor_page;
	        wizardString = AddMethodOp.save.dialog_string;
	        wizardTitle = AddMethodOp.save.dialog_title;
	        wizardMode = AddMethodOp.save.dialog_type;
	        wizardHelpTopic = AddMethodOp.save.dialog_help;
	        methodFrameVisible = AddMethodOp.save.method_frame_vis;
	        parameterFrameVisible = AddMethodOp.save.param_frame_vis;
	     };
	     AddModuleOp.disabled = AddMethodOp.save.add_module_disabled;
             $set_obj_ref_indirect <-.ObjectEditor.editControl.disp_obj_out save.disp_obj_out
             $set_obj_ref_indirect <-.ObjectEditor.editControl.edit_obj_out save.edit_obj_out
             $set_obj_ref_indirect <-.ObjectEditor.firstPage save.first_state
             $set_obj_ref_indirect <-.ObjectEditor.lastPage save.last_state
             $set_obj_ref_indirect <-.ObjectEditor.nextActive save.next_active
          ">;

          cancel_commands = <"
             $push
             Destroy {
                destroy_obj => ObjectEditor.editControl.edit_obj_out;
                do = 1;
             };
             $pop
             $push
          "> + exit_commands + <"
             $pop
          ">;

          close_commands = <"
             $push
          "> + exit_commands + <"
             $pop
             $push
             ObjectEditor.shell.cancel = 1;
             $pop
          ">;
       };
    
       states = {
       {
          enter_commands = <"
	     AddModuleOp.disabled = 1;
	     ObjectEditor {
	        pageSelector.selectedItem = 1;
		wizardMode = 1;
	        editControl.edit_obj_path = 
				Module.addMethod.new_path;
		wizardTitle = "NE_AMW_TITLE1A";
	        wizardString = "NE_AMW_STRING1A";
	        wizardHelpTopic = "AMWmethod1";
	        firstPage => AddMethodOp.first_state;
	        lastPage => AddMethodOp.last_state;
                nextActive => Method.methodModule.valid;
	     };
	  ">,
	  exit_commands = <"
/*	     ObjectEditor.shell.visible = 0; */
	  ">
       }};
       set_next   <weight=3>;
       set_cancel <weight=3>;
       set_close  <weight=3>;
    };

    //-----------------------------------------------------------------//

    OEM.check_module_parent_dialog CheckFileParent {
       parent_path => dataObj.curObjList[0];
       invalid_parent_message = "NE_AFW_NO_PARENT";
       inactive_message = "NE_AFW_WIZARD_UP";
       check_module_parent {
           active => (ObjectEditor.shell.visible == 0 ||
                      ObjectEditor.wizardMode == 0);
   	   trigger => objectMenu.importFileItem.cmd.do;
       };
    };
    OEM.add_file_import_dialog AddFileImport {
       wizardTitle = "NE_AFW_TITLE1";
       wizardText = "NE_AFW_STRING1";
       back_active = 0;
       widgets.shell.visible => CheckFileParent.done;
       // Since this is only used in one context, set this up to be constant
       parent_path => CheckFileParent.parent_path;
       widgets.add_file_module {
	  default_dir = ".";
	  default_suffix = "*";
       };
    };
       
    BasicOp AddFileOp {
       next => ObjectEditor.next;
       cancel => ObjectEditor.cancel;
       close => ObjectEditor.close;
       back => ObjectEditor.back;
       begin => AddFileImport.done;
       num_states = 1;

       save {
	  string cur_module;
       };

       module_state {
          exit_commands = <"
	     ObjectEditor {
	        shell.visible = AddFileOp.save.visible;
	        pageSelector.selectedItem = AddFileOp.save.editor_page;
	        wizardString = AddFileOp.save.dialog_string;
	        wizardTitle = AddFileOp.save.dialog_title;
	        wizardMode = AddFileOp.save.dialog_type;
	        wizardHelpTopic = AddFileOp.save.dialog_help;
	        methodFrameVisible = AddFileOp.save.method_frame_vis;
	        parameterFrameVisible = AddFileOp.save.param_frame_vis;
	     };
             $set_obj_ref_indirect <-.ObjectEditor.editControl.disp_obj_out save.disp_obj_out
             $set_obj_ref_indirect <-.ObjectEditor.editControl.edit_obj_out save.edit_obj_out
             $set_obj_ref_indirect <-.ObjectEditor.firstPage save.first_state
             $set_obj_ref_indirect <-.ObjectEditor.lastPage save.last_state
             $set_obj_ref_indirect <-.ObjectEditor.nextActive save.next_active
          ">;

          cancel_commands = <"
             $push
             Destroy {
                destroy_obj => ObjectEditor.editControl.edit_obj_out;
                do = 1;
             };
             $pop
          "> + exit_commands;

          close_commands = exit_commands;
       };
    
       states = {
       {
	  enter_commands = <"
	     // should be "Add_File_Variable" page...
	     ObjectEditor {
	        pageSelector.selectedItem = 3;
	        shell.visible = 1;
		wizardMode = 1;
		wizardTitle = "NE_AFW_TITLE2";
	        wizardString = "NE_AFW_STRING2";
		wizardHelpTopic = "AFWmain2";
	        editControl.disp_obj_path =
		   AddFileImport.widgets.add_file_module.new_obj_path;
	        editControl.edit_obj_path =
		   AddFileImport.widgets.add_file_module.new_obj_path;
	        AddFileImport.widgets.shell.visible = 0;

	        firstPage => AddFileOp.first_state;
		lastPage => AddFileOp.last_state;
	     };
	  ">,
	  exit_commands = <"
	     // ObjectEditor.shell.visible = 0;
	  ">
       }};
    };
    BasicOp AddFileVariableOp {
       next => ObjectEditor.next;
       cancel => ObjectEditor.cancel;
       close => ObjectEditor.close;
       back => ObjectEditor.back;
       begin => ObjectEditor.Add_File_Variable.add_file_variable.variable_created;
       num_states = 2;

       save {
	  string cur_module;
	  int save_file_name_active;
	  int valueActive;
	  int connectionActive;
	  int portActive;
	  int baseTypeActive;
	  int arrayActive;
          int cache;
       };

       module_state {
          exit_commands = <"
	     ObjectEditor {
	        shell.visible = AddFileVariableOp.save.visible;
	        pageSelector.selectedItem = AddFileVariableOp.save.editor_page;
	        wizardString = AddFileVariableOp.save.dialog_string;
	        wizardTitle = AddFileVariableOp.save.dialog_title;
	        wizardMode = AddFileVariableOp.save.dialog_type;
	        wizardHelpTopic = AddFileVariableOp.save.dialog_help;
	        methodFrameVisible = AddFileVariableOp.save.method_frame_vis;
	        parameterFrameVisible = AddFileVariableOp.save.param_frame_vis;
	     };
	     ObjectEditor.Declaration.portActive = AddFileVariableOp.save.portActive;
	     ObjectEditor.Declaration.valueActive = AddFileVariableOp.save.valueActive;
	     ObjectEditor.Declaration.connectionActive = AddFileVariableOp.save.connectionActive;
 	     AddFileOp.disabled = AddFileVariableOp.save.add_file_disabled;
             $set_obj_ref_indirect <-.ObjectEditor.editControl.disp_obj_out save.disp_obj_out
             $set_obj_ref_indirect <-.ObjectEditor.editControl.edit_obj_out save.edit_obj_out
             $set_obj_ref_indirect <-.ObjectEditor.firstPage save.first_state
             $set_obj_ref_indirect <-.ObjectEditor.lastPage save.last_state
             $set_obj_ref_indirect <-.ObjectEditor.nextActive save.next_active
          ">;

          cancel_commands = <"
             $push
             Destroy {
                destroy_obj => ObjectEditor.editControl.edit_obj_out;
                do = 1;
             };
             $pop
             $push
          "> + exit_commands + <"
             $pop
          ">;

          close_commands = <"
             $push
          "> + exit_commands + <"
             $pop
             $push
             ObjectEditor.shell.cancel = 1;
             $pop
          ">;
       };
    
       states = {
       {
	  enter_commands = <"
	     AddFileOp.disabled = 1; // disable AddFileOp while this is going on.
	     // should be "Declaration" page...
	     ObjectEditor {
	        pageSelector.selectedItem = 1;
	        shell.visible = 1;
	        editControl.edit_obj_path = 
  		          Add_File_Variable.add_file_variable.new_obj_path;
		wizardMode = 1;
	        wizardString = "NE_AFW_STRING1A";
		wizardTitle = "NE_AFW_TITLE1A";
		wizardHelpTopic = "AFWfileVariable1";

	        firstPage => AddFileVariableOp.first_state;
		lastPage => AddFileVariableOp.last_state;
	     };
	     AddFileVariableOp.save.portActive = ObjectEditor.Declaration.portActive;
	     AddFileVariableOp.save.valueActive = ObjectEditor.Declaration.valueActive;
	     AddFileVariableOp.save.connectionActive = ObjectEditor.Declaration.connectionActive;
	     ObjectEditor.Declaration.portActive = 0;
	     ObjectEditor.Declaration.valueActive = 0;
	     ObjectEditor.Declaration.connectionActive = 0;
	  ">,
	  exit_commands = <"
	     ObjectEditor.shell.visible = 0;
	  ">
       },
       {
	  enter_commands = <"
	     // should be "Edit_File_Object" page...
	     AddFileVariableOp.save.save_file_name_active = ObjectEditor.Edit_File_Object.name_active;
	     AddFileVariableOp.save.cache = ObjectEditor.Edit_File_Object.edit_file_variable.cache;
	     ObjectEditor.Edit_File_Object.name_active = 0;
             ObjectEditor.Edit_File_Object.edit_file_variable.cache = 1;
	     ObjectEditor {
	  	shell.visible = 1;
	        pageSelector.selectedItem = 0;
	        wizardString = "NE_AFW_STRING1B";
		wizardTitle = "NE_AFW_TITLE1B";
		wizardHelpTopic = "AFWfileVariable2";
	     };
	  ">,
	  exit_commands = <"
	     ObjectEditor.Edit_File_Object.name_active = AddFileVariableOp.save.save_file_name_active;
	     ObjectEditor.Edit_File_Object.edit_file_variable.cache = AddFileVariableOp.save.cache;
	     ObjectEditor.shell.visible = 0;
	  ">
       }};
       set_next   <weight=3>;
       set_cancel <weight=3>;
       set_close  <weight=3>;
    };
    AddFileVariableOp AddFileOffsetOp {
       begin => ObjectEditor.Add_File_Variable.add_file_variable.offset_created;
       num_states = 2;

       save {
	  string cur_module;
	  int save_file_name_active;
	  int valueActive;
	  int connectionActive;
	  int portActive;
	  int baseTypeActive;
	  int arrayActive;
          int cache;
       };

       module_state {
          exit_commands = <"
	     ObjectEditor {
	        shell.visible = AddFileOffsetOp.save.visible;
	        pageSelector.selectedItem = AddFileOffsetOp.save.editor_page;
	        wizardString = AddFileOffsetOp.save.dialog_string;
	        wizardTitle = AddFileOffsetOp.save.dialog_title;
	        wizardMode = AddFileOffsetOp.save.dialog_type;
	        wizardHelpTopic = AddFileOffsetOp.save.dialog_help;
	        methodFrameVisible = AddFileOffsetOp.save.method_frame_vis;
	        parameterFrameVisible = AddFileOffsetOp.save.param_frame_vis;
	     };
	     ObjectEditor.Declaration.portActive = AddFileVariableOp.save.portActive;
	     ObjectEditor.Declaration.valueActive = AddFileVariableOp.save.valueActive;
	     ObjectEditor.Declaration.connectionActive = AddFileVariableOp.save.connectionActive;
	     ObjectEditor.Declaration.baseTypeActive = AddFileVariableOp.save.baseTypeActive;
	     ObjectEditor.Declaration.arrayActive  = AddFileVariableOp.save.arrayActive;
 	     AddFileOp.disabled = AddFileOffsetOp.save.add_file_disabled;
             $set_obj_ref_indirect <-.ObjectEditor.editControl.disp_obj_out save.disp_obj_out
             $set_obj_ref_indirect <-.ObjectEditor.editControl.edit_obj_out save.edit_obj_out
             $set_obj_ref_indirect <-.ObjectEditor.firstPage save.first_state
             $set_obj_ref_indirect <-.ObjectEditor.lastPage save.last_state
             $set_obj_ref_indirect <-.ObjectEditor.nextActive save.next_active
          ">;

          cancel_commands = <"
             $push
             Destroy {
                destroy_obj => ObjectEditor.editControl.edit_obj_out;
                do = 1;
             };
             $pop
             $push
          "> + exit_commands + <"
             $pop
          ">;

          close_commands = <"
             $push
          "> + exit_commands + <"
             $pop
             $push
             ObjectEditor.shell.cancel = 1;
             $pop
          ">;
       };
    
       states = {
       {
	  enter_commands = <"
	     AddFileOp.disabled = 1; // disable AddFileOp while this is going on.
	     // should be "Declaration" page...
	     ObjectEditor {
	        pageSelector.selectedItem = 1;
	        shell.visible = 1;
	        editControl.edit_obj_path = 
  		       Add_File_Variable.add_file_variable.new_obj_path;
		wizardMode = 1;
	        wizardString = "NE_AFW_STRING2A";
		wizardTitle = "NE_AFW_TITLE2A";
		wizardHelpTopic = "AFWfileOffsetVariable1";

	        firstPage => AddFileOffsetOp.first_state;
		lastPage => AddFileOffsetOp.last_state;
	     };
	     AddFileVariableOp.save.portActive = ObjectEditor.Declaration.portActive;
	     AddFileVariableOp.save.valueActive = ObjectEditor.Declaration.valueActive;
	     AddFileVariableOp.save.connectionActive = ObjectEditor.Declaration.connectionActive;
	     AddFileVariableOp.save.baseTypeActive = ObjectEditor.Declaration.baseTypeActive;
	     AddFileVariableOp.save.arrayActive = ObjectEditor.Declaration.arrayActive;
	     ObjectEditor.Declaration.portActive = 0;
	     ObjectEditor.Declaration.valueActive = 0;
	     ObjectEditor.Declaration.connectionActive = 0;
	     ObjectEditor.Declaration.baseTypeActive = 0;
	     ObjectEditor.Declaration.arrayActive =0;
	  ">,
	  exit_commands = <"
	     ObjectEditor.shell.visible = 0;
	  ">
       },
       {
	  enter_commands = <"
	     // should be "Edit_File_Offset" page...
	     AddFileOffsetOp.save.save_file_name_active = ObjectEditor.Edit_File_Offset.name_active;
	     AddFileOffsetOp.save.cache = ObjectEditor.Edit_File_Offset.edit_file_offset.cache;
	     ObjectEditor.Edit_File_Offset.name_active = 0;
             ObjectEditor.Edit_File_Offset.edit_file_offset.cache = 1;
	     ObjectEditor {
	  	shell.visible = 1;
	        pageSelector.selectedItem = 0;
	        wizardString = "NE_AFW_STRING2B";
		wizardTitle = "NE_AFW_TITLE2B";
		wizardHelpTopic = "AFWfileOffsetVariable2";
	     };
	  ">,
	  exit_commands = <"
	     ObjectEditor.shell.visible = 0;
	     ObjectEditor.Edit_File_Offset.name_active = AddFileOffsetOp.save.save_file_name_active;
             ObjectEditor.Edit_File_Offset.edit_file_offset.cache = AddFileOffsetOp.save.cache;
	  ">
       }};
    };
    UIinfoDialog FileModuleComplete {
        parent => appShell;
	visible => AddFileOp.done;
	title = "NE_DONE";
	message = "NE_AFW_DONE_MSG";
        isModal = 1;
        cancelButton = 0;
    };

    //
    // Set up the error handler that will redirect messages to the 
    // display
    //
    GMOD.err_handler ErrorHandler {
        enabled => !is_valid(getenv("NE_NO_ERROR_DIALOG"));
    };
    UI_MACROS.UIerrorDisplay Error_Dialog {
	message_nl => ErrorHandler.num_lines;
	message => ErrorHandler.err_message;
    };
};

//---------------------------------------------------------------------//

// Special version of the NE to be used by compiled projects.

NEdefaultNetworkEditor NEdefaultRuntimeNetworkEditor {

    menuBar.cmdList => { fileMenu.pulldown,
                         editMenu.pulldown,
                         objectMenu.pulldown,
                         journalMenu.pulldown,
                         uiBuilderMenu.pulldown,
                         optionsMenu.pulldown,
#ifdef ACKIT
		         avsMenu.pulldown,
#endif
                         helpMenu.pulldown };
};

//---------------------------------------------------------------------//

}; // End of flibrary NE_MACROS -- Don't add any objects after this line.

//---------------------------------------------------------------------//
//                         End of ne_macro.v                           //
//---------------------------------------------------------------------//
