/*
			Copyright (c) 2001 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/netcdf.v#1 $
*/

flibrary NETCDF <
    disabled => Templates.CONFIG.netcdf_kit_disabled,
    needs_use_lic="GD", needs_edit_lic="DV"
    >
{

enum NCfld_type<NEvisible=0> {
    choices = {"Unspecified", "Unif", "Rect", "Struct"};
    values  = { 0, 1, 2, 3 };
};

library+buffered NC_Modules <
    build_dir="netcdf",
    build_cmd="$(MAKE)",
    use_src_file=0,
    link_files="-lnc_mods -lnetcdf"
    >
{

module NClist_vars {
    string+Iparam filename;

    string+Oparam variables[];
    int+Oparam timeSteps;
    string+Oparam title;
    string+Oparam history;

    omethod+notify_val+notify_inst update<status=1> =
        "NClist_vars_update";
};

module NCread_array {
    string+Iparam filename;
    string+Iparam variable;

    prim+Oparam outArr[];

    omethod+notify_val+notify_inst update<status=1> =
        "NCread_array_update";
};

// Read a field from a standard netCDF file.
module NCread_field<need_objs="Mesh_Unif Mesh_Rect Mesh_Struct"> {
    string+Iparam filename;
    string+Iparam variables[];
    int+Iparam timeStep = -1; // -1 means don't look at time steps.
    NCfld_type+Iparam fldType = "Unspecified";

    Mesh_Struct+Node_Data+Oparam &outFld;

    omethod+notify_val+notify_inst update<status=1> =
        "NCread_field_update";
};

// Read an Express object - usually a field, but it doesn't have to be one -
// from an Express-centric netCDF file.
module NCread_object<locked=0> {
    string+Iparam   filename;

    olink    out;

    omethod+notify_val+notify_inst read_update<status=1> =
        "NCread_object_update";
};

// Write a field to a standard netCDF file.
module NCwrite_field {
    string+Iparam filename;
    Mesh_Struct+Node_Data+Iparam &inFld;

    omethod+notify_val+notify_inst update<status=1> =
        "NCwrite_field_update";
};

// Write an Express object - usually a field, but it doesn't have to be one -
// to an Express-centric netCDF file.
module NCwrite_object {
    ilink+nonotify   in;
    string+Iparam  filename;

    omethod+notify_val+notify_inst write_update<status=1> =
        "NCwrite_object_update";
};

}; // NC_Modules;

library+buffered NC_Macros<compile_subs=0> {

macro Read_Field<NEhelpTopic="Read_netCDF_Field"> {

    group Read_NetCDF_Param <NEportLevels={0,1}> {
        string filename<NEportLevels={1,2}>;
        string variables<NEportLevels={1,2}>[];
        int timeSteps<NEportLevels={1,2}>;
        string title<NEportLevels={1,2}>;
        string history<NEportLevels={1,2}>;
        int selectedVariables<NEportLevels={1,2}>[];
        int timeEnable<NEportLevels={1,2}> = 0;
        int timeStep<NEportLevels={1,2}> = 0;
        NCfld_type fldType<NEportLevels={1,2}> = "Unspecified";
        int trigger<NEportLevels={1,2}>;
    };

    NClist_vars list_vars {
       filename  => <-.Read_NetCDF_Param.filename;
       variables => <-.Read_NetCDF_Param.variables;
       timeSteps => <-.Read_NetCDF_Param.timeSteps;
       title     => <-.Read_NetCDF_Param.title;
       history   => <-.Read_NetCDF_Param.history;
    };

    int timeEnable => is_valid(.Read_NetCDF_Param.timeSteps) &&
                      (.Read_NetCDF_Param.timeSteps>0) &&
                      (.Read_NetCDF_Param.timeEnable!=0);

    NCread_field read_field {
       // Note that the first two are new variables
       int+Iparam selectedVariables[] => 
                             <-.Read_NetCDF_Param.selectedVariables;
       int+Iparam trigger => <-.Read_NetCDF_Param.trigger;
       filename    =>        <-.Read_NetCDF_Param.filename;
       variables[] =>        <-.Read_NetCDF_Param.variables;
       timeStep    =>        switch( (<-.timeEnable==0)+1,
                                     <-.Read_NetCDF_Param.timeStep,
                                     -1 );
       fldType     =>        <-.Read_NetCDF_Param.fldType;

       // This seems redundant, but the +req on selectedVariables
       // and trigger aren't respected unless you do this. 
       omethod+notify_val+notify_inst update<status=1> =
           "NCread_field_update";
    };

    macro read_netcdf_ui {
        group &param<NEportLevels={2,0}> => <-.Read_NetCDF_Param;

        UImod_panel panel {
            title => name_of(<-.<-.<-,1);
            message = "Select Read NetCDF control panel.";
            parent<NEportLevels={4,0}>;
            height => switch( is_valid(<-.apply.y)+1,
                              800,
                              <-.apply.y + 100 );
        };

        UIlabel Field_Filename {
            parent => <-.panel;
            label  => "netCDF filename:";
            y      => 0;
            width  => 200;
            alignment = 0;
        };
        UItext file_name {
            parent => <-.panel;
            y => Field_Filename.y + Field_Filename.height + 5;
            text => <-.param.filename;
            width = 170;
            showLastPosition = 1;
        };
        UIbutton browser_visible {
            parent => <-.panel;
            x => file_name.x + file_name.width + 5;
            y => file_name.y;
            width = 75;
            height => <-.file_name.height;
            label = "Browse...";
        };

        UIfileSB file_browser {
            GMOD.copy_on_change copy_on_change {
               trigger => <-.<-.browser_visible.do;
               input   => <-.<-.browser_visible.do;
               output  =>    <-.visible;
            };
            title = "Read NetCDF Filename";
            searchPattern = "$XP_PATH<0>/data/netCDF/*.nc";
            filename => <-.param.filename;
        };

        UIlabel title_label {
            parent => <-.panel;
            label  => <-.param.title;
            visible => is_valid(<-.param.title);
            y+nres => <-.file_name.y + <-.file_name.height + 5;
            width  => <-.panel.width;
            int actual_h => switch( .visible+1, 0, .height );
        };

        UIlabel hist_label {
            parent => <-.panel;
            label  => <-.param.history;
            visible => is_valid(<-.param.history);
            y+nres => <-.title_label.y + <-.title_label.actual_h + 2;
            width  => <-.panel.width;
            int actual_h => switch( .visible+1, 0, .height );
        };
        VUI.VUIOptionMenuLabel fldType {
            label   =  "Field Type";
            parent  => <-.panel;
            x       => -25; // I want it centered
            y+nres  => <-.hist_label.y + <-.hist_label.actual_h + 15;
            width   => <-.panel.clientWidth;
            options => { "Unspecified", "Uniform", 
                         "Rectilinear", "Structured" };
            selectedItem <NEportLevels={3,0}> => <-.param.fldType;
        };

        // Show the possible variables and let the user pick.

        UIoptionBoxLabel  UIoptionBoxLabel {
            parent        => <-.panel;
            labels+IPort2         => <-.param.variables;
            &selectedItems+IPort2 => <-.param.selectedVariables;
            UIframe UIpanel { // trick to turn the panel into a frame
                parent => <-.parent;
                x      => <-.x;
                y      => <-.y;
                width  => <-.width;
                height => <-.height + 3;
            };
            UIlabel {
                y = 2;
                visible   => (array_size(<-.<-.param.variables) != 0);
            };
            title = "Select netCDF variables:";
            y             => <-.fldType.y + <-.fldType.height + 5;
            width         => <-.panel.width;
        };

        UItoggle use_time {
            parent => <-.panel;
            y => <-.UIoptionBoxLabel.y + <-.UIoptionBoxLabel.height + 12;
            width => <-.panel.clientWidth;
            visible => is_valid(param.timeSteps) && (param.timeSteps>0);
            label => switch( .visible+1,
                             "<no time steps in file>",
                             str_format( "Extract time step (%d time steps in file)",
                                         param.timeSteps ) );
            set => <-.param.timeEnable;
        };
        UIslider time_slider {
            parent => <-.panel;
            y => <-.use_time.y + <-.use_time.height + 5;
            visible => is_valid(param.timeSteps) && (param.timeSteps>0);
            min = 0;
            max+nres => switch( ((param.timeSteps-1)>0)+1, 
                                 0,
                                 param.timeSteps-1 );
            value => param.timeStep;
            mode = "integer";
            title = "Time Step";
        };

        UIbutton apply {
            parent => <-.panel;
            y => <-.time_slider.y + <-.time_slider.height + 10;
            width = 75;
            height => <-.file_name.height;
            label = "Read File";
            active => (array_size(<-.param.selectedVariables) != 0);
            do => param.trigger;
        };

    };

    DataObjectNoTexture DataObject {
        in => <-.read_field.outFld;
        Obj {
            name => name_of(<-.<-.<-);
        };
    };

    olink field<export_all=2> => read_field.outFld;
    olink out_obj => DataObject.obj;
};

macro Read_Object<NEhelpTopic="Read_netCDF_Object"> {

    macro read_ui {
        UImod_panel panel {
            title => name_of(<-.<-.<-);
            message = "Select read control panel.";
            parent<NEportLevels={4,0}>;
        };

        UIlabel netCDF_Filename {
            parent => <-.panel;
            y = 0;
            width => 200;
            alignment = 0;
        };
        UItext file_name {
            parent => panel;
            y => netCDF_Filename.y + netCDF_Filename.height + 5;
            text => <-.filename;
            width = 170;
            showLastPosition = 1;
        };
        UIbutton visible {
            parent => panel;
            x => file_name.x + file_name.width + 5;
            y => file_name.y;
            width = 75;
            height => <-.file_name.height;
            label = "Browse...";
        };
        UIfileSB file_browser {
            GMOD.copy_on_change copy_on_change {
                trigger => <-.<-.visible.do;
                input => <-.<-.visible.do;
                output => <-.visible;
            };
            title = "netCDF Filename";
            searchPattern = "$XP_PATH<0>/data/netCDF/*";
            filename => <-.filename;
        };

        string filename<export=3>;
    };

    NCread_object read_object {
        filename => read_ui.filename;
    };

    DataObjectNoTexture DataObject {
        in => read_object.out;
        Obj {
            name => name_of(<-.<-.<-);
        };
    };
    olink field<export_all=2> => read_object.out;
    olink obj => DataObject.obj;
};

macro Write_Field<NEhelpTopic="Write_netCDF_Field"> {
    ilink in<export_all=1>;

    group Write_NetCDF_Param <NEportLevels={0,1}> {
        string filename<NEportLevels={1,2}>;
        int trigger<NEportLevels={1,2}>;
    };

    NCwrite_field write_field {
       // Note that the first is a new variable
       int+Iparam trigger => <-.Write_NetCDF_Param.trigger;
       filename    =>        <-.Write_NetCDF_Param.filename;
       inFld       =>        <-.in;
       // This seems redundant, but the +req on trigger
       // isn't respected unless you do this. 
       omethod+notify_inst+notify_val update<status=1> = 
           "NCwrite_field_update";
    };

    macro write_netcdf_ui {
        group &param<NEportLevels={2,0}> => <-.Write_NetCDF_Param;

        UImod_panel panel {
            title => name_of(<-.<-.<-,1);
            message = "Select Write NetCDF control panel.";
            parent<NEportLevels={4,0}>;
        };

        UIlabel Field_Filename {
            parent => <-.panel;
            y      => 0;
            width  => 200;
            alignment = 0;
        };
        UItext file_name {
            parent => <-.panel;
            y => Field_Filename.y + Field_Filename.height + 5;
            text => <-.param.filename;
            width = 170;
            showLastPosition = 1;
        };
        UIbutton browser_visible {
            parent => <-.panel;
            x => file_name.x + file_name.width + 5;
            y => file_name.y;
            width = 75;
            height => <-.file_name.height;
            label = "Browse...";
        };

        UIfileSB file_browser {
            GMOD.copy_on_change copy_on_change {
               trigger => <-.<-.browser_visible.do;
               input   => <-.<-.browser_visible.do;
               output  =>    <-.visible;
            };
            title = "Write NetCDF Filename";
            searchPattern = "$XP_PATH<0>/data/netCDF/*.nc";
            filename => <-.param.filename;
        };

        UIbutton apply {
            parent => <-.panel;
            y => <-.browser_visible.y + <-.browser_visible.height + 10;
            width = 75;
            height => <-.file_name.height;
            label = "Write File";
            //active => (array_size(param.selectedVariables) != 0);
            do => param.trigger;
        };
    };
};

macro Write_Object<NEhelpTopic="Write_netCDF_Object"> {
     ilink in<export_all=1>;

     macro write_ui {
        UImod_panel panel {
            title => name_of(<-.<-.<-,1);
            message = "Select write control panel.";
            parent<NEportLevels={4,0}>;
        };
        UIlabel netCDF_Filename {
            parent => <-.panel;
            y = 0;
            width => 200;
            alignment = 0;
        };
        UItext file_name {
            parent => panel;
            y => netCDF_Filename.y + netCDF_Filename.height + 5;
            text => <-.filename;
            width = 170;
            showLastPosition = 1;
        };
        UIbutton visible {
            parent => panel;
            x => file_name.x + file_name.width + 5;
            y => file_name.y;
            width = 75;
            height => <-.file_name.height;
            label = "Browse...";
        };
        UIfileSB file_browser {
            GMOD.copy_on_change copy_on_change {
               trigger => <-.<-.visible.do;
               input => <-.<-.visible.do;
               output => <-.visible;
            };
            title = "netCDF Filename";
            searchPattern = "$XP_PATH<0>/data/*";
            filename => <-.filename;
        };

        string filename<export=3>;
    };

    NCwrite_object write_object {
        in => <-.in;
        filename => write_ui.filename;
    };
};

};  // NC_Macros

}; // NETCDF
