/*
		Copyright (c) 1994 by
		Advanced Visual Systems Inc.
		All Rights Reserved

 This software comprises unpublished confidential information of
 Advanced Visual Systems Inc. and may not be used, copied or made
 available to anyone, except in accordance with the license
 under which it is furnished.

 This file is under Perforce control
 $Id: //depot/express/fcs70/v/pal.v#1 $
*/

flibrary+global+sort PAL <
   build_dir="pal",
   build_cmd="$(MAKE)",
   link_files="-lpal -ldmap -ldbxx $(WINLIBS)",
   c_hdr_files="../include/avs/gd.h",
   out_hdr_file="uci_pal.h",
   out_src_file="uci_pal.c",
   hdr_code="void PALsys_init (void);",
   init_code="    PALsys_init();"
> {

$include ../include/avs/pal_def.h

group+OPort PALvirt<struct_name = "PALvirt",
		    struct_bitmask = "PALvirtBitmask",
		    cxx_name="PALXvirt",
		    NEnumColors=6,
		    NEcolor0=0xff0000,NEcolor1=0xffff00,NEcolor2=0x00ff00,
		    NEcolor3=0x00ffff,NEcolor4=0x0000ff,NEcolor5=0xff00ff> {
   int update;
   int vclass;
   int vid;
   int share;
   float gamma;
   int cube_size;
   cmethod+notify_inst init = "PALvirtif_init";
   cmethod+notify_val upd<weight=0> = "PALvirtif_update";
   cmethod+notify_del delete = "PALvirtif_delete";
};

/* This is the default virtual palette used in the
   display kit. It specifies a visual class of best
   which means we will look for the best visual
   we can find to render into. We will try to share
   the colormap if possible and on 8-bit systems
   we will try to create a ramp of 6-6-6.
*/
PALvirt BestVirtPal {
   vclass = VIS_CLASS_BEST;
   share = SHARE_CMAP;
   cube_size = 6;
};

PALvirt DefaultVirtPal {
   vclass = VIS_CLASS_DEFAULT;
   share = SHARE_CMAP;
   cube_size = 6;
};

PALvirt MaxCube {
   vclass = VIS_CLASS_PSEUDO;
   share = SHARE_CMAP;
   cube_size = 6;
};

PALvirt MinCube {
   vclass = VIS_CLASS_PSEUDO;
   share = SHARE_CMAP;
   cube_size = 2;
};


};
