// PST
// pst.v
// James S Perrin Time-stamp: <Sunday 08/08/04 14:33:21 root>
// Main PST library where everything actually exists

// PST_DEV_AVAIL is used to control library presentation and should be
// defined is PST module are going to be developed (does not imply this
// is the developer edition of Express
//#define PST_DEV_AVAIL

// PST_PROJECT is defined is PST is has been compiled as a standard project
// rather than into the Express source tree
//#define PST_PROJECT

// PST_LOGGED is used to control profiling, it turns on the compile option
// and also turns on options in PST_Control
//#define PST_LOGGED

/* which version of MPICH to use pc/linux/sg6/linux_ia64 */
/* NOTE: mpich under unix uses its own compiler macros to link correct mpi libraries */
#define PST_USE_MPICH
//#define PST_USE_MPICH2

/* MPICH is not the default on sg6 and linux_ia64 */
#ifdef xp_sg6
#ifdef PST_USE_MPICH
#undef PST_USE_MPICH
#endif
#ifdef PST_USE_MPICH2
#undef PST_USE_MPICH2
#endif
#endif

#ifdef xp_linux_ia64
#ifdef PST_USE_MPICH
#undef PST_USE_MPICH
#endif
#ifdef PST_USE_MPICH2
#undef PST_USE_MPICH2
#endif
#endif

flibrary PST<build_dir="pst", build_cmd="$(MAKE)", out_hdr_file="Xpst.h", out_src_file="Xpst.cxx", c_hdr_files="pst/pst.h pst/pst_comp.h pst/pst_xp_init.h", cxx_hdr_files="fld/Xfld.h", lib_deps="FLD DV", init_code="PST_mpi_init(argc, &argv);",
#ifdef PST_USE_MPICH
hdr_dirs="$(MPICH_BASE)/include",
#else
#ifdef PST_USE_MPICH2
hdr_dirs="$(MPICH2_BASE)/include",
#endif
#endif

#ifdef MPU_RENDERER
/* This is now fixed in MPE */
/* cxx_hdr_files="fld/Xfld.h wand/fmp_comm/fmpc_gen.hxx", */
#endif

#ifdef xp_pc
	// ###### PC (WIN32) ######
	#ifdef PST_USE_MPICH
		// ------ Use MPICH 1.5 ------
		#ifdef PST_LOGGED    
			link_files="$(MPICH_BASE)/lib/mpe.lib $(MPICH_BASE)/lib/mpich.lib -lpstmodules -lpstxp -lpst"
		#else
			link_files="$(MPICH_BASE)/lib/mpich.lib -lpstmodules -lpstxp -lpst"
		#endif
	#else      
		// ------ Use MPICH2  ------
		link_files="$(MPICH2_BASE)/lib/mpich2.lib -lpstmodules -lpstxp  -lpst"
	#endif      
#else
	#ifdef xp_sg6
		// ###### SG6 (IRIX) ######
		#ifdef PST_USE_MPICH
			// ------ Use MPICH 1.5 ------
			link_files="-lpstmodules -lpstxp -lpst"
		#else      
			// ------ Use IRIX MPI ------
			link_files="-lpstmodules -lpstxp -lpst -lmpi"
		#endif
	#else
		#ifdef xp_linux_ia64
			// ###### LINUX_IA64 (SGI) ######
			// ------ Use SGI MPI ------
			link_files="-lpstmodules -lpstxp -lpst -lmpi"
		#else
			// ###### LINUX ######
			link_files="-lpstmodules -lpstxp -lpst"
		#endif
	#endif
#endif

> {
   "pst/pst_data" DATA;
   "pst/pst_mods" MODS;
   "pst/pst_ui" UI;
   "pst/pst_macs" MACS;
   "pst/pst_viz" VIZ;
   "pst/pst_apps" APPS; 
};
