// PST
// p_combine_vector.v
// James S Perrin (MVC)
// Time-stamp: <Tuesday 01/06/04 17:24:47 james>

flibrary Combine_Vector {
   group Combine_VectorParam {
      int veclen;
      int vector_comps[];
   };

   PST.MODS.pModule pCombine_Vector<use_src_file=0> {
      Combine_VectorParam+IPort2 &param;
      int veclen => .param.veclen;
      int vector_comps[veclen] => .param.vector_comps;
      Node_Data+IPort2 &in;
      Node_Data+OPort2 out;      
      cxxmethod+req combine_vector (
	 // pModule params
	 in_tags+read+opt+notify,
	 schema+read+req+notify,
	 out_tags+write,
	 // combine_vector params
	 in+read+req+notify,
	 veclen+read+req+notify,
	 vector_comps+read+req+notify,
	 out+write
      );      
   };
   
   PST.UI.pMacroUI pCombine_VectorUI {
      Combine_VectorParam+IPort2 &param;
      Node_Data+IPort2 &in;
      DVnode_data_labels DVnode_data_labels {
	 in => <-.in;
      };
      UIslider UIveclenSlider {
	 x = 2;
	 y => <-.y0;
	 parent => <-.parent;
	 width => .parent.clientWidth -4;
	 min = 1;
	 max => <-.in.nnode_data;
	 mode = "integer";
	 title = "Vector size";
	 value => <-.param.veclen;
      };
      UIoptionBoxLabel UIcompsOptionBox {
	 x = 2;
	 y => <-.UIveclenSlider.y +<-.UIveclenSlider.height +4;
	 parent => <-.parent;
	 width => .parent.clientWidth -4;
	 labels => <-.DVnode_data_labels.labels;
	 max => <-.param.veclen;
	 title = "Vector components";
	 selectedItems => <-.param.vector_comps;
      };
      UIlabel UIerrorLabel {
	 x = 2;
	 y => <-.UIcompsOptionBox.y + <-.UIcompsOptionBox.height +4;
	 parent => <-.parent;
	 width => .parent.clientWidth -4;
	 label = "There are not enough vector_comps selected";
	 visible => <-.param.veclen != <-.UIcompsOptionBox.UIoptionBox.numSelectedItems;
	 color {
	    foregroundColor = "red";
	 };
      };
   };

   PST.MACS.pMacro p_combine_vector {
      ilink in_field;
      Combine_VectorParam+OPort param {
	 veclen = 3;
	 vector_comps = {0,1,2};
      };
      GMOD.parse_v auto_select_comps{
	 on_inst = 0;
	 trigger => <-.param.veclen;
	 relative => <-.param;
	 v_commands = "vector_comps = init_array(veclen,0,veclen-1);";
	 parse_v_relative<weight=0>;
      };
      pCombine_VectorUI pCombine_VectorUI {
	 param => <-.param;
	 schema => <-.schema;
	 in => <-.in_field;
      };
      pCombine_Vector pCombine_Vector {
	 in => <-.in_field;
	 param => <-.param;
	 schema => <-.schema;
	 in_tags => <-.in_tags;
	 prev_schema => <-.in_schema;
      };
      GMOD.parse_v reset_vector_comps {
	 v_commands = "vector_comps = init_array(veclen, 0, veclen-1);";
	 trigger => <-.param.veclen;
	 on_inst = 0;
	 relative => <-.param;
      };
      PST.MODS.combine_mesh_data_tags out_combine_mesh_data_tags {
	 trigger => <-.pCombine_Vector.done;
         mesh_tags => <-.in_tags;
         in_mesh => <-.in_field;
         nd_tags => <-.pCombine_Vector.out_tags;
         in_nd => <-.pCombine_Vector.out;
         schema => <-.schema;
      };
      out_tags => .out_combine_mesh_data_tags.out_tags;
      thru_tags => .pCombine_Vector.thru_tags;
      olink out_field => .out_combine_mesh_data_tags.out;
   };
};
