// PST
// p_crop_struct.v
// James S Perrin (MVC)
// Time-stamp: <Monday 05/07/04 17:49:00 james>

flibrary Crop_Struct {
   group Crop_StructParam {
      int cropMin[];
      int cropMax[];
   };

   PST.MODS.pModule pCrop_Struct<use_src_file=0> {
      Crop_StructParam+IPort2 &param;
      int cropMin[] => .param.cropMin;
      int cropMax[] => .param.cropMax;
      Mesh_Struct+Node_Data+IPort2 &in;
      Mesh_Struct+Node_Data+OPort2 out;      
      cxxmethod+req crop_struct (
	 // pModule params
	 in_tags+read+opt+notify,
	 schema+read+req+notify,
	 out_tags+write,
	 // crop_struct params
	 in+read+req+notify,
	 cropMin+read+req+notify,
	 cropMax+read+req+notify,
	 out+write
      );      
   };
   
   PST.UI.pMacroUI pCrop_StructUI {
      Crop_StructParam+IPort2 &param;
      Mesh_Struct+Node_Data+IPort2 &in;
      UIslider UIminXSlider {
	 x = 2;
	 y => <-.y0;
	 parent => <-.parent;
	 width => .parent.clientWidth -4;
	 min = 0;
	 max => <-.in.dims[0]-1;
	 mode = "integer";
	 title = "Min X";
	 value => <-.param.cropMin[0];
      };
      UIslider UImaxXSlider {
	 x = 2;
	 y => <-.UIminXSlider.y + <-.UIminXSlider.height +4;
	 parent => <-.parent;
	 width => .parent.clientWidth -4;
	 min = 0;
	 max => <-.in.dims[0]-1;
	 mode = "integer";
	 title = "Max X";
	 value => <-.param.cropMax[0];
      };
      UIslider UIminYSlider {
	 x = 2;
	 y => <-.UImaxXSlider.y + <-.UImaxXSlider.height +4;
	 parent => <-.parent;
	 width => .parent.clientWidth -4;
	 min = 0;
	 max => <-.in.dims[1]-1;
	 mode = "integer";
	 title = "Min Y";
	 value => <-.param.cropMin[1];
	 visible => <-.in.nspace>1;
      };
      UIslider UImaxYSlider {
	 x = 2;
	 y => <-.UIminYSlider.y + <-.UIminYSlider.height +4;
	 parent => <-.parent;
	 width => .parent.clientWidth -4;
	 min = 0;
	 max => <-.in.dims[1]-1;
	 mode = "integer";
	 title = "Max Y";
	 value => <-.param.cropMax[1];
	 visible => <-.in.nspace>1;
      };
      UIslider UIminZSlider {
	 x = 2;
	 y => <-.UImaxYSlider.y + <-.UImaxYSlider.height +4;
	 parent => <-.parent;
	 width => .parent.clientWidth -4;
	 min = 0;
	 max => <-.in.dims[2]-1;
	 mode = "integer";
	 title = "Min Z";
	 value => <-.param.cropMin[2];
	 visible => <-.in.nspace>2;
      };
      UIslider UImaxZSlider {
	 x = 2;
	 y => <-.UIminZSlider.y + <-.UIminZSlider.height +4;
	 parent => <-.parent;
	 width => .parent.clientWidth -4;
	 min = 0;
	 max => <-.in.dims[2]-1;
	 mode = "integer";
	 title = "Max Z";
	 value => <-.param.cropMax[2];
	 visible => <-.in.nspace>2;
      };
      UIbutton UIresetButton {
	 x = 2;
	 y => <-.UImaxZSlider.y + <-.UImaxZSlider.height +4;
	 parent => <-.parent;
	 width => .parent.clientWidth -4;
	 label = "Reset";
      };
   };

   PST.MACS.pMacro p_crop_struct {
      ilink in_field;
      Crop_StructParam+OPort param {
	 cropMin+nres => init_array(<-.in_field.ndim,0,0);
	 cropMax+nres => <-.in_field.dims-1;
      };
      pCrop_StructUI pCrop_StructUI {
	 param => <-.param;
	 schema => <-.schema;
	 in => <-.in_field;
      };
      pCrop_Struct pCrop_Struct {
	 in => <-.in_field;
	 param => <-.param;
	 schema => <-.schema;
	 in_tags => <-.in_tags;
	 prev_schema => <-.in_schema;
      };
      GMOD.parse_v reset_crop_values {
	 v_commands = "param.cropMin = init_array(<-.in_field.ndim,0,0); param.cropMax = <-.in_field.dims-1;";
	 trigger => <-.pCrop_StructUI.UIresetButton.do;
	 on_inst = 0;
	 relative => <-;
      };
      out_tags => .pCrop_Struct.out_tags;
      thru_tags => .pCrop_Struct.thru_tags;
      olink out_field => .pCrop_Struct.out;
   };
};
