// PST
// p_isosurface_struct.v
// James S Perrin (MVC)
// Time-stamp: <Wednesday 18/08/04 11:48:26 james>

flibrary Isosurface_Struct {
   group IsosurfaceStructParam {
      int+Port2 comp;
      int+Port2 matchNodes;
      double+Port2 isoLevel;
   };

   PST.MODS.pModule pIsosurface_Struct<use_src_file=0> {
      IsosurfaceStructParam+IPort2 &param;
      int comp => .param.comp;
      int matchNodes => .param.matchNodes;
      double isoLevel => .param.isoLevel;
      Mesh_Struct+Node_Data+IPort2 &in;
      Mesh+OPort2 out;      
      cxxmethod+req isosurface (
	 // pModule params
	 in_tags+read+opt+notify,
	 schema+read+req+notify,
	 out_tags+write,
	 // isosurface params
	 in+read+req+notify,
	 comp+read+req+notify,
	 matchNodes+read+req+notify,
	 isoLevel+read+req+notify,
	 out+write
      );      
   };

   PST.UI.pMacroUI pIsosurfaceStructUI {
      IsosurfaceStructParam+IPort2 &param;
      Node_Data+IPort2 &in;
      Mesh+IPort2 &out;
      DVnode_data_labels DVnode_data_labels {
	 in => <-.in;
      };
      UIradioBoxLabel UIcompRadioBox {
	 x = 2;
	 y => <-.y0;
	 parent => <-.parent;
	 width => .parent.clientWidth -4;
	 labels => <-.DVnode_data_labels.labels;
	 selectedItem => <-.param.comp;
	 title = "Component to isosurface";
      };
      UIslider UIisoLevelSlider {
	 x = 2;
	 y => <-.UIcompRadioBox.y + <-.UIcompRadioBox.height +4;
	 parent => <-.parent;
	 width => 9*.parent.clientWidth/10 -4;
	 min => <-.in.node_data[<-.param.comp].min;
	 max => <-.in.node_data[<-.param.comp].max;
	 mode = "real";
	 title = "Iso value";
	 value => <-.param.isoLevel;
      };
      VUIslider_typein UIisoLevelTypein {
	 slider	=> UIisoLevelSlider;
      };
      UItoggle UImatchNodesToggle {
	 x = 2;
	 y => <-.UIisoLevelSlider.y + <-.UIisoLevelSlider.height +4;
	 parent => <-.parent;
	 width => .parent.clientWidth -4;
	 label = "Match nodes";
	 set => <-.param.matchNodes;
      };
      UIframe UIoutputFrame {
	 x = 2;
	 y => <-.UImatchNodesToggle.y + <-.UImatchNodesToggle.height +4;
	 parent => <-.parent;
	 width => .parent.clientWidth -4;
	 height+nres => <-.UIstorageField.y + <-.UIstorageField.height +4;
      };
      UIlabel UIoutputLabel {
	 x = 0;
	 y = 0;
	 parent => <-.UIoutputFrame;
	 width => .parent.clientWidth;
	 label = "Output Information";
	 color {
	    backgroundColor = "blue";
	    foregroundColor = "white";
	 };
      };
      UIlabel UInNodesLabel {
	 x = 2;
	 y => <-.UIoutputLabel.y + <-.UIoutputLabel.height +4;
	 parent => <-.UIoutputFrame;
	 width => .parent.clientWidth/2 -4;
	 label = "# nodes";
      };
      UIfield UInNodesField {
	 x => .parent.clientWidth/2 +2;
	 y => <-.UInNodesLabel.y;
	 parent => <-.UIoutputFrame;
	 width => .parent.clientWidth/2 -4;
	 nullString = "";
	 outputOnly = 1;
	 mode = "integer";
	 decimalPoints = 0;
	 value+nres => <-.out.nnodes;
      };
      UIlabel UInTrisLabel {
	 x = 2;
	 y => <-.UInNodesField.y + <-.UInNodesField.height +4;
	 parent => <-.UIoutputFrame;
	 width => .parent.clientWidth/2 -4;
	 label = "# triangles";
      };
      UIfield UInTrisField {
	 x => .parent.clientWidth/2 +2;
	 y => <-.UInTrisLabel.y;
	 parent => <-.UIoutputFrame;
	 width => .parent.clientWidth/2 -4;
	 nullString = "";
	 outputOnly = 1;
	 mode = "integer";
	 decimalPoints = 0;
	 value+nres => <-.out.cell_set[0].ncells;
      };
      UIlabel UIstorageLabel {
	 x = 2;
	 y => <-.UInTrisField.y + <-.UInTrisField.height +4;
	 parent => <-.UIoutputFrame;
	 width => .parent.clientWidth/2 -4;
	 label = "Approx size (MB)";
      };
      UIfield UIstorageField {
	 x => .parent.clientWidth/2 +2;
	 y => <-.UIstorageLabel.y;
	 parent => <-.UIoutputFrame;
	 width => .parent.clientWidth/2 -4;
	 nullString = "";
	 outputOnly = 1;
	 mode = "real";
	 decimalPoints = 2;
	 value+nres => 12.0*(<-.out.nnodes+<-.out.cell_set[0].ncells)/(1024.0*1024.0);
      };
   };

   PST.MACS.pMacro p_isosurface_struct {
      ilink in_field;
      schema {
	 domain_boundary = 1;
      };
      IsosurfaceStructParam+OPort param {
	 comp = 0;
	 matchNodes = 0;
	 isoLevel+nres => (<-.in_field.node_data[.comp].max- <-.in_field.node_data[.comp].max)/2 +0;
      };
      pIsosurfaceStructUI pIsosurfaceStructUI {
	 param => <-.param;
	 schema => <-.schema;
	 in => <-.in_field;
	 out => <-.pIsosurface_Struct.out;
      };
      pIsosurface_Struct pIsosurface_Struct {
	 in => <-.in_field;
	 in_tags => <-.in_tags;
	 param => <-.param;
	 schema => <-.schema;
	 prev_schema => <-.in_schema;
      };
      DATAMAPS.DefaultLinear dmap {
	 dataMin+nres => cache(<-.in_field.node_data[<-.param.comp].min);
	 dataMax+nres => cache(<-.in_field.node_data[<-.param.comp].max);
      };
      PST.MODS.get_colour_from_dmap get_colour_from_dmap {
	 dmap => <-.dmap;
	 value => <-.param.isoLevel;
      };
      GDM.DataObject DataObject {
	 in => <-.pIsosurface_Struct.out;
	 Props {
	    col => <-.<-.get_colour_from_dmap.colour;
	    inherit = 0;
	 };
	 Obj {
	    dmap => <-.<-.dmap;
	    name => name_of(<-.<-.<-);
	 };
      };
      out_tags => .pIsosurface_Struct.out_tags;
      thru_tags => .pIsosurface_Struct.thru_tags;
      olink out_field => .pIsosurface_Struct.out;
      olink obj => .DataObject.obj;
   };
};
