// PST
// p_null_brick.v
// Tobias Schiebeck (MVC)
// Time-stamp: <Friday 03/12/04 00:25:10 root>


flibrary Null_Brick {
   group Null_BrickParam {
      int+Port2 comp;
      int+Port2 inside;
      float+Port2 xmin;
      float+Port2 xmax;
      float+Port2 ymin;
      float+Port2 ymax;
      float+Port2 zmin;
      float+Port2 zmax;
      double+Port2 null_value;
   };

   PST.MODS.pModule pNull_Brick<use_src_file=0> {
      Null_BrickParam+IPort2 &param;
      int comp => .param.comp;
      int inside => .param.inside;
      float xmin => .param.xmin;
      float xmax => .param.xmax;
      float ymin => .param.ymin;
      float ymax => .param.ymax;
      float zmin => .param.zmin;
      float zmax => .param.zmax;
      double null_value => .param.null_value;
      Node_Data+IPort2 &in;
      Node_Data+OPort2 out;		
      cxxmethod+req null_brick (
	 // pModule params
	 in_tags+read+opt+notify,
	 schema+read+req+notify,
	 out_tags+write,
	 // clamp params
	 in+read+req+notify,
	 comp+read+req+notify,
	 inside+read+req+notify,
	 xmin+read+req+notify,
	 xmax+read+req+notify,
	 ymin+read+req+notify,
	 ymax+read+req+notify,
	 zmin+read+opt+notify,
	 zmax+read+opt+notify,
	 null_value+read+notify,
	 out+write
      );		  
   };

   PST.UI.pMacroUI pNull_BrickUI {
      Null_BrickParam+IPort2 &param;
      Node_Data+IPort2 &in;
      DVnode_data_labels DVnode_data_labels {
	 in => <-.in;
      };
      UIradioBoxLabel UIcompRadioBox {
	 x = 2;
	 y => <-.y0;
	 parent => <-.parent;
	 width => .parent.clientWidth -4;
	 title = "Data component";
	 labels => <-.DVnode_data_labels.labels;
	 selectedItem => <-.param.comp;
      };
      UItoggle UIinsideToggle {
	 x = 2;
	 y => <-.UIcompRadioBox.y + <-.UIcompRadioBox.height +4;
	 parent => <-.parent;
	 width => parent.clientWidth -4;
	 label = "leave inside";
	 set => <-.param.inside;
      };
      UIslider UIxminSlider {
	 x = 2;
	 y => <-.UIinsideToggle.y + <-.UIinsideToggle.height +4;
	 parent => <-.parent;
	 width => .parent.clientWidth -4;
	 min+nres => cache(<-.in.coordinates.min_vec[0]);
	 max+nres => cache(<-.in.coordinates.max_vec[0]);
	 mode = "integer";
	 title = "x min";
	 value => <-.param.xmin;
      };
      UIslider UIxmaxSlider {
	 x = 2;
	 y => <-.UIxminSlider.y + <-.UIxminSlider.height +4;
	 parent => <-.parent;
	 width => .parent.clientWidth -4;
	 min+nres => cache(<-.in.coordinates.min_vec[0]);
	 max+nres => cache(<-.in.coordinates.max_vec[0]);
	 mode = "integer";
	 title = "xmax";
	 value => <-.param.xmax;
      };
      UIslider UIyminSlider {
	 x = 2;
	 y => <-.UIxmaxSlider.y + <-.UIxmaxSlider.height +4;
	 parent => <-.parent;
	 width => .parent.clientWidth -4;
	 min+nres => cache(<-.in.coordinates.min_vec[1]);
	 max+nres => cache(<-.in.coordinates.max_vec[1]);
	 mode = "integer";
	 title = "y min";
	 value => <-.param.ymin;
      };
      UIslider UIymaxSlider {
	 x = 2;
	 y => <-.UIyminSlider.y + <-.UIyminSlider.height +4;
	 parent => <-.parent;
	 width => .parent.clientWidth -4;
	 min+nres => cache(<-.in.coordinates.min_vec[1]);
	 max+nres => cache(<-.in.coordinates.max_vec[1]);
	 mode = "integer";
	 title = "y max";
	 value => <-.param.ymax;
      };
      UIslider UIzminSlider {
	 x = 2;
	 y => <-.UIymaxSlider.y + <-.UIymaxSlider.height +4;
	 parent => <-.parent;
	 visible => cache(<-.in.ndim == 3);
	 width => .parent.clientWidth -4;
	 min+nres => cache(<-.in.coordinates.min_vec[2]);
	 max+nres => cache(<-.in.coordinates.max_vec[2]);
	 mode = "integer";
	 title = "z min";
	 value => <-.param.zmin;
      };
      UIslider UIzmaxSlider {
	 x = 2;
	 y => <-.UIzminSlider.y + <-.UIzminSlider.height +4;
	 parent => <-.parent;
	 visible => cache(<-.in.ndim == 3);
	 width => .parent.clientWidth -4;
	 min+nres => cache(<-.in.coordinates.min_vec[2]);
	 max+nres => cache(<-.in.coordinates.max_vec[2]);
	 mode = "integer";
	 title = "z max";
	 value => <-.param.zmax;
      };
      UIlabel UInullLabel {
	 x = 2;
	 y => <-.UIzmaxSlider.y + <-.UIzmaxSlider.height +4;
	 parent => <-.parent;
	 width => .parent.clientWidth/2 -4;
	 label = "Null value";
      };
      UIfield UInullField {
	 x => .parent.clientWidth/2 +2;
	 y => <-.UInullLabel.y;
	 parent => <-.parent;
	 width => .parent.clientWidth/2 -4;
	 nullString = "";
	 value => <-.param.null_value;
      };
      UIbutton UIresetButton {
	 x = 2;
	 y => <-.UInullField.y + <-.UInullField.height +4;
	 parent => <-.parent;
	 width => .parent.clientWidth -4;
	 label = "Reset";
      };
   };

   PST.MACS.pMacro p_null_brick {
      ilink in_field;
      Null_BrickParam+OPort param {
	 comp = 0;
	 inside = 1;
	 xmin+nres => cache(<-.in_field.coordinates.min_vec[0]);
	 xmax+nres => cache(<-.in_field.coordinates.max_vec[0]);
	 ymin+nres => cache(<-.in_field.coordinates.min_vec[1]);
	 ymax+nres => cache(<-.in_field.coordinates.max_vec[1]);
	 zmin+nres => cache(<-.in_field.coordinates.min_vec[2]);
	 zmax+nres => cache(<-.in_field.coordinates.max_vec[2]);
	 null_value+nres => switch(is_valid(<-.in_field.node_data[.comp].null_value)+1,
	 0.0, <-.in_field.node_data[.comp].null_value+0);
      };
      GMOD.parse_v reset_null_brick_values {
	 v_commands = "
	 param.xmin=> cache(<-.in_field.coordinates.min_vec[0]); param.xmax=> cache(<-.in_field.coordinates.max_vec[0]);
	 param.ymin=> cache(<-.in_field.coordinates.min_vec[1]); param.ymax=> cache(<-.in_field.coordinates.max_vec[1]);
	 param.zmin=> cache(<-.in_field.coordinates.min_vec[2]); param.zmax=> cache(<-.in_field.coordinates.max_vec[2]);
	 param.null_value=> switch(is_valid(<-.in_field.node_data[.comp].null_value)+1, 0.0, <-.in_field.node_data[.comp].null_value+0);";
	 trigger => <-.pNull_BrickUI.UIresetButton.do;
	 on_inst = 0;
	 relative => <-;
      };
      pNull_BrickUI pNull_BrickUI {
	 param => <-.param;
	 schema => <-.schema;
	 in => <-.in_field;
      };
      pNull_Brick pNull_Brick {
	 in => <-.in_field;
	 in_tags => <-.in_tags;
	 param => <-.param;
	 schema => <-.schema;
	 prev_schema => <-.in_schema;
      };
      PST.MODS.combine_mesh_data_tags out_combine_mesh_data_tags {
	 trigger => <-.pNull_Brick.done;
	 mesh_tags => <-.in_tags;
	 in_mesh => <-.in_field;
	 nd_tags => <-.pNull_Brick.out_tags;
	 in_nd => <-.pNull_Brick.out;
	 schema => <-.schema;
      };
      out_tags => .out_combine_mesh_data_tags.out_tags;
      thru_tags => .pNull_Brick.thru_tags;
      olink out_field => .out_combine_mesh_data_tags.out;
   };
};
