// PST
// orthoslice.v
// James S Perrin (MVC)
// Time-stamp: <Wednesday 04/08/04 14:26:31 james>

flibrary Orthoslice {
   group OrthosliceParam {
      int+Port2 axis;
      int+Port2 plane;
   };

   PST.MODS.pModule pOrthoslice<use_src_file=0> {
      OrthosliceParam+IPort2 &param;
      int axis => .param.axis;
      int plane => .param.plane;
      Mesh_Struct+Node_Data+IPort2 &in;
      Mesh_Struct+Node_Data+OPort2 out;      
      cxxmethod+req orthoslice (
	 // pModule params
	 in_tags+read+opt+notify,
	 schema+read+req+notify,
	 out_tags+write,
	 // orthoslice params
	 in+read+req+notify,
	 axis+read+req+notify,
	 plane+read+req+notify,
	 out+write
      );      
   };

   PST.UI.pMacroUI pOrthosliceUI {
      OrthosliceParam+IPort2 &param;
      Node_Data+IPort2 &in;
      DVnode_data_labels DVnode_data_labels {
	 in => <-.in;
      };
      UIslider UIaxisSlider {
	 x = 2;
	 y => <-.y0;
	 parent => <-.parent;
	 width => .parent.clientWidth -4;
	 min = 0; 
	 max+nres => <-.in.ndim-1;
	 mode = "integer";
	 title = "Axis";
	 value => <-.param.axis;
      };
      UIslider UIplaneSlider {
	 x = 2;
	 y => <-.UIaxisSlider.y + <-.UIaxisSlider.height +4;
	 parent => <-.parent;
	 width => .parent.clientWidth -4;
	 min = 0;
	 max+nres => <-.in.dims[<-.param.axis]-1;
	 mode = "integer";
	 title = "Plane";
	 value => <-.param.plane;
      };
      UItoggle UIimmediateToggle {
	 x = 2;
	 y => <-.UIplaneSlider.y + <-.UIplaneSlider.height +4;
	 parent => <-.parent;
	 width => .parent.clientWidth -4;
	 label = "Continuous update";
	 set => <-.UIplaneSlider.immediateMode;
      };
   };

   PST.MACS.pMacro p_orthoslice {
      ilink in_field;
      OrthosliceParam+OPort param {
	 axis = 0;
	 plane+nres => <-.in_field.dims[.axis]/2 + 0;
      };
      pOrthosliceUI pOrthosliceUI {
	 param => <-.param;
	 schema => <-.schema;
	 in => <-.in_field;
      };
      pOrthoslice pOrthoslice {
	 in => <-.in_field;
	 in_tags => <-.in_tags;
	 param => <-.param;
	 schema => <-.schema;
	 prev_schema => <-.in_schema;
      };
      GDM.DataObject DataObject {
	 in => <-.pOrthoslice.out;
	 Obj {
	    name => name_of(<-.<-.<-);
	 };
      };
      out_tags => .pOrthoslice.out_tags;
      thru_tags => .pOrthoslice.thru_tags;
      olink out_field => .pOrthoslice.out;
      olink obj => .DataObject.obj;
	 
   };
};
