// PST
// p_read_field.v
// James S Perrin (MVC)
// Time-stamp: <Monday 01/03/04 11:21:45 james>

flibrary Read_Field {
   group pReadFieldParam {
      int+Port2 portable;
      int+Port2 swap;
      int+Port2 flip;
      int+Port2 useRemotePath;
      string+Port2 filename;
      string+Port2 remotePath;
   };

   PST.MODS.pModuleImport pReadField<use_src_file=0> {
      pReadFieldParam+IPort2 &param;
      int portable => param.portable;
      int swap => param.swap;
      int flip => param.flip;
      string filename => .param.filename;
      int useRemotePath => .param.useRemotePath;
      string remotePath => .param.remotePath;
      Mesh_Struct+Node_Data+OPort2 out;      
      cxxmethod+req+notify_inst read (
	 // pModule params
	 schema+read+req+notify,
	 out_tags+write,
	 // read_field params
	 portable+read+req+notify,
	 swap+read+req+notify,
	 flip+read+req+notify,
	 filename+read+req+notify,
	 useRemotePath+read+notify,
	 remotePath+read+notify,	 
	 out+write
      );
   };
   
   PST.UI.pMacroImportUI pReadFieldUI {
      pReadFieldParam+IPort2 &param;
      UItoggle UIportableToggle {
	 x = 2;
	 y => <-.y0;
	 parent => <-.parent;
	 width => .parent.clientWidth -4;
	 label = "Portable (XDR)";
	 set => <-.param.portable;
      };
      UItoggle UIswapToggle {
	 x = 2;
	 y => <-.UIportableToggle.y + <-.UIportableToggle.height +4;
	 parent => <-.parent;
	 width => .parent.clientWidth -4;
	 label = "Swap";
	 set => <-.param.swap;
	 visible => !<-.param.portable;
      };
      // !!!!! This option is not currently supported !!!!!!!
      UItoggle UIflipToggle {
	 x = 2;
	 y => <-.UIswapToggle.y + <-.UIswapToggle.height +4;
	 parent => <-.parent;
	 width => .parent.clientWidth -4;
	 label = "Flip";
	 set => <-.param.flip;
	 visible = 0;
      };
      UIbutton UIbrowseButton {
	 x = 2;
	 y => <-.UIflipToggle.y + <-.UIflipToggle.height +4;
	 parent => <-.parent;
	 width => .parent.clientWidth -4;
	 label = "Read Field";
      };
      UItext UIfilenameText {
	 x = 2;
	 y => <-.UIbrowseButton.y + <-.UIbrowseButton.height +4;
	 parent => <-.parent;
	 width => .parent.clientWidth -4;
	 text => <-.param.filename;
      };
      UIfileDialog UIfileDialog {
	 title = "Read field...";
	 searchPattern = "$XP_PATH<0>/data/field/*.fld";
	 visible => <-.UIbrowseButton.do;
	 filename => <-.param.filename;
      };
      UItoggle UIremotePathToggle {
	 x = 2;
	 y => <-.UIfilenameText.y + <-.UIfilenameText.height +4;
	 parent => <-.parent;
	 width => .parent.clientWidth -4;
	 label = "Use remote path:";
	 set => <-.param.useRemotePath;
      };
      UItext UIremotePathText {
	 x = 2;
	 y => <-.UIremotePathToggle.y + <-.UIremotePathToggle.height +4;
	 parent => <-.parent;
	 width => .parent.clientWidth -4;
	 text => <-.param.remotePath;
	 active => <-.param.useRemotePath;
      };
   };

   PST.MACS.pMacroImport p_read_field {
      pReadFieldParam+OPort param {
	 portable = 1;
	 swap = 0;
	 flip = 0;
      };
      pReadField pReadField {
	 schema => <-.schema;
	 param => <-.param;
      };
      pReadFieldUI pReadFieldUI {
	 schema => <-.schema;
	 param => <-.param;
      };
      out_tags => .pReadField.out_tags;
      olink out_field => .pReadField.out;
   };
};
