// PST
// p_redistribute.v
// James S Perrin (MVC)
// Time-stamp: <Wednesday 01/09/04 17:39:42 james>

flibrary Redistribute {
   PST.MODS.pModule pRedistribute<use_src_file=0> {
      Mesh_Struct+Node_Data+IPort2 &in;
      int trigger;
      Mesh_Struct+Node_Data+OPort2 out;      
      cxxmethod+req redistribute (
	 // pModule params
	 in_tags+read+opt+notify,
	 schema+read+req+notify,
	 out_tags+write,
	 // redistribute params
	 in+read+req+notify,
	 trigger+notify,
	 out+write
      );      
   };
   
   PST.UI.pMacroImportUI pRedistributeUI {
      PST.DATA.pSchema &prev_schema;
      UIschemaImport {
	 UIxpOutToggle {
	    active = 0;
	 };
      };
      UIlabel UIboundaryInLabel {
	 x = 2;
	 y => <-.y0;
	 parent => <-.parent;
	 width => .parent.clientWidth -4;
	 label => "Input's domain boundary is : " + <-.prev_schema.domain_boundary;
	 alignment = "left";
      };
      
      UIlabel UINPSTNodesInLabel {
	 x = 2;
	 y => <-.UIboundaryInLabel.y +<-.UIboundaryInLabel.height +4;
	 parent => <-.parent;
	 width => .parent.clientWidth -4;
	 label => "Input's " + <-.prev_schema.npstnodes + " PSTNodes are :";
	 alignment = "left";
      };
      UIlabel UIPSTNodelabel[prev_schema.npstnodes] {
	 int i => index_of(<-.UIPSTNodelabel);
	 x = 2;
	 y => <-.UINPSTNodesInLabel.y + <-.UINPSTNodesInLabel.height +4 +(height+4)*i;
	 parent => <-.parent;
	 width => .parent.clientWidth -4;
#ifndef MSDOS
	 height => (UIdata.UIfonts[0].height + 0);
#endif	 
	 label => Templates.PST_CONFIG.pstnode_names[<-.prev_schema.pstnodes[i]];
	 alignment = "left";
      };
   };

   PST.MACS.pMacro p_redistribute {
      ilink in_field;
      schema {
	 xp_in = 0;
	 xp_out_user = 0;
	 no_resolve = 1;
      };
      pRedistributeUI pRedistributeUI {
	 schema => <-.schema;
	 prev_schema => <-.in_schema;
      };
      pRedistribute pRedistribute {
	 in => <-.in_field;
	 schema => <-.schema;
	 in_tags => <-.in_tags;
	 prev_schema => <-.in_schema;
	 trigger => schema.npstnodes+is_valid(schema.pstnodes)+schema.domain_boundary;
      };
      
      out_tags => .pRedistribute.out_tags;
      thru_tags => .pRedistribute.thru_tags;
      olink out_field => .pRedistribute.out;
   };
};
