// PST
// p_skeleton.v
// James S Perrin (MVC)
// Time-stamp: <Thursday 04/12/03 14:00:42 james>

flibrary Skeleton {
   group SkeletonParam {
      int intValue;
      float floatValue;
   };

   PST.MODS.pModule pSkeleton<use_src_file=0> {
      SkeletonParam+IPort2 &param;
      int intValue => .param.intValue;
      int floatValue => .param.floatValue;
      Mesh_Struct+Node_Data+IPort2 &in;
      Mesh_Struct+Node_Data+OPort2 out;      
      cxxmethod+req skeleton (
	 // pModule params
	 in_tags+read+opt+notify,
	 schema+read+req+notify,
	 out_tags+write,
	 // skeleton params
	 in+read+req+notify,
	 intValue+read+req+notify,
	 floatValue+read+req+notify,
	 out+write
      );      
   };
   
   PST.UI.pMacroUI pSkeletonUI {
      SkeletonParam+IPort2 &param;
      Mesh_Struct+Node_Data+IPort2 &in;
      UItoggle UIintToggle {
	 x = 2;
	 y => <-.y0;
	 parent => <-.parent;
	 width => .parent.clientWidth -4;
	 label = "int value";
	 set => <-.param.intValue;
      };
      UIslider UIfloatSlider {
	 x = 2;
	 y => <-.UIintToggle.y + <-.UIintToggle.height +4;
	 parent => <-.parent;
	 width => .parent.clientWidth -4;
	 min = 1;
	 max = 100;
	 mode = "real";
	 title = "float value";
	 value => <-.param.floatValue;
      };
   };

   PST.MACS.pMacro p_skeleton {
      ilink in_field;
      SkeletonParam+OPort param {
	 intValue = 1;
	 floatValue = 10.0;
      };
      pSkeletonUI pSkeletonUI {
	 param => <-.param;
	 schema => <-.schema;
	 in => <-.in_field;
      };
      pSkeleton pSkeleton {
	 in => <-.in_field;
	 param => <-.param;
	 schema => <-.schema;
	 in_tags => <-.in_tags;
	 prev_schema => <-.in_schema;
      };
      
      out_tags => .pSkeleton.out_tags;
      thru_tags => .pSkeleton.thru_tags;
      olink out_field => .pSkeleton.out;
   };
};
