// PST
// pst_ui.v
// James S Perrin (MVC)
// Time-stamp: <Friday 07/01/05 13:47:28 james>

flibrary UI {
   library Base {
      // **** UIschema ****
      // UI for accessing a pModules schema
      macro UIschemaBase {
	 ilink parent;
	 string name = ""; // name of current module
	 PST.DATA.pSchema+IPort2 &schema;
	 UIframe UIframe {
	    x = 0;
	    y = 0;
	    parent => <-.parent;
	    width => .parent.clientWidth;
	 };
	 UIlabel UIschemaLabel {
	    x = 0;
	    y = 0;
	    width => .parent.clientWidth-40;
	    parent => <-.UIframe;
	    label = "Edit Schema";
	    color {
	       foregroundColor = "white";
	       backgroundColor = "blue";
	    };
	 };
	 UIbutton UIexpandButton {
	    parent => <-.UIframe;
	    height => <-.UIschemaLabel.height;
	    label => "v";
	    labelPixmap {
#ifdef PST_PROJECT
#ifdef MSDOS	 
	       filename = "$XP_PATH<1>/runtime/pixmaps/expand_pc.xbm";
#else
	       filename = "$XP_PATH<1>/runtime/pixmaps/expand.xbm";
#endif	       
#else
#ifdef MSDOS	 
	       filename = "$XP_PATH<0>/runtime/pixmaps/expand_pc.xbm";
#else
	       filename = "$XP_PATH<0>/runtime/pixmaps/expand.xbm";
#endif	       
#endif	       
	    };
	    x => (parent.clientWidth - 40);
	    y = 0;
	    width = 20;
	 };
	 UIbutton UIcollapseButton {
	    parent => <-.UIframe;
	    height => <-.UIschemaLabel.height;
	    label => "^";
	    labelPixmap {
#ifdef PST_PROJECT	       
#ifdef MSDOS	 
	       filename = "$XP_PATH<1>/runtime/pixmaps/collapse_pc.xbm";
#else
	       filename = "$XP_PATH<1>/runtime/pixmaps/collapse.xbm";
#endif	       
#else
#ifdef MSDOS	 
	       filename = "$XP_PATH<0>/runtime/pixmaps/collapse_pc.xbm";
#else
	       filename = "$XP_PATH<0>/runtime/pixmaps/collapse.xbm";
#endif	       
#endif	       
	    };
	    x => (parent.clientWidth - 20);
	    y = 0;
	    width = 20;
	 };
	 GMOD.copy_on_change expand_frame {
	    trigger => <-.UIexpandButton.do;
	    input = 335;
	    output => <-.UIframe.height;
	    on_inst = 0;
	 };
	 GMOD.copy_on_change collapse_frame {
	    trigger => <-.UIcollapseButton.do;
#ifdef MSDOS
	    input = 19;
#else	    
	    input = 32;
#endif	    
	    output => <-.UIframe.height;
	    on_inst = 1;
	 };
	 UItoggle UIeditToggle {
	    x = 2;
	    y => <-.UIschemaLabel.y + <-.UIschemaLabel.height +4;
	    parent => <-.UIframe;
	    width => .parent.clientWidth/2 -4;
	    label = "Edit PSTNodes";
	    set => Scheduler.interrupt;
  	    active => <-.schema.npstnodes == <-.UIoptionBoxLabel.UIoptionBox.numSelectedItems;
	 };
	 UIlabel UIeditLabel {
	    x => .parent.clientWidth/2 +2;
	    y => <-.UIeditToggle.y;
	    parent => <-.parent;
	    width => .parent.clientWidth/2 -4;
	    label => switch(<-.UIeditToggle.active+1,
	       switch((<-.schema.npstnodes < <-.UIoptionBoxLabel.UIoptionBox.numSelectedItems)+1,
	       "Need more PSTNodes", "Need less PSTNodes"),
	       "");
	    color {
	       foregroundColor = "red";
	    };
	    visible => !<-.UIeditToggle.active;
	 };
	 UIslider UInPSTNodeSlider {
	    x = 2;
	    y => <-.UIeditToggle.y + <-.UIeditToggle.height +4;
	    parent => <-.UIframe;
	    width => .parent.clientWidth -4;
	    min = 1;
	    max => <-.schema.max_npstnodes;
	    value => <-.schema.npstnodes;
	    mode = "integer";
	    title = "Number of PSTNodes";
	    active => <-.UIeditToggle.set;
	 };
	 UIframe UIpstnodeFrame {
	    x = 2;
	    y => <-.UInPSTNodeSlider.y + <-.UInPSTNodeSlider.height +4;
	    width => parent.clientWidth -4;
	    height = 150;
	    parent => <-.UIframe;
	 };
	 UIscrolledWindow UIscrolledWindow {
	    x = 0;
	    y = 0;
	    width => parent.clientWidth;
	    height => parent.clientHeight;
	    parent => <-.UIpstnodeFrame;
	 };
	 UIpanel UIpanel {
	    x = 0;
	    y = 0;
	    parent => <-.UIscrolledWindow;
	    width => .parent.clientWidth -4;
	    height => <-.UIoptionBoxLabel.height;
	 };
	 UIoptionBoxLabel UIoptionBoxLabel {
	    x = 2;
	    y = 0;
	    parent => <-.UIpanel;
	    labels => Templates.PST_CONFIG.pstnode_names;
	    max => <-.schema.npstnodes;
	    selectedItems => <-.schema.pstnodes;
	    title = "PSTNodes";
	    UIoptionBox {
	       active => <-.<-.UIeditToggle.set;
	    };
	 };
      };
     
      UIschemaBase UIschema {
	 expand_frame {
#ifdef MSDOS	 
	    input = 268;
#else
	    input = 335;
#endif
	 };
	 UItoggle UIxpInToggle {
	    x = 2;
	    y => <-.UIschemaLabel.y + <-.UIschemaLabel.height +4;
	    parent => <-.UIframe;
	    width => .parent.clientWidth-4;
	    label = "Use Express input";
	    set => <-.schema.xp_in; 
	 };
	 UItoggle UIxpOutToggle {
	    x = 2;
	    y => <-.UIxpInToggle.y + <-.UIxpInToggle.height +4;
	    parent => <-.UIframe;
	    width => .parent.clientWidth-4;
	    label = "Create Express output";
	    set => <-.schema.xp_out_user; 
	 };
	 UIeditToggle {
	    y => <-.UIxpOutToggle.y + <-.UIxpOutToggle.height +4;
	 };
      };
      
      UIschemaBase UIschemaImport {
	 expand_frame {
#ifdef MSDOS	 
	    input = 285;
#else
	    input = 370;
#endif
	 };
	 UItoggle UIxpOutToggle {
	    x = 2;
	    y => <-.UIschemaLabel.y + <-.UIschemaLabel.height +4;
	    parent => <-.UIframe;
	    width => .parent.clientWidth-4;
	    label = "Create Express output";
	    set => <-.schema.xp_out_user; 
	 };
	 UIslider UIboundarySlider {
	    x = 2;
	    y => <-.UIxpOutToggle.y + <-.UIxpOutToggle.height +4;
	    parent => <-.UIframe;
	    width => parent.clientWidth -4;
	    min = 0;
	    max = 8;
	    mode = "integer";
	    title = "Domain boundary";
	    value => <-.schema.domain_boundary;
	 };
	 UIeditToggle {
	    y => <-.UIboundarySlider.y + <-.UIboundarySlider.height +4;
	 };
      };
	 
      UIschemaBase UIschemaExport {
	 expand_frame {
#ifdef MSDOS	 
	    input = 245;
#else
	    input = 310;
#endif
	 };
	 UItoggle UIxpInToggle {
	    x = 2;
	    y => <-.UIschemaLabel.y + <-.UIschemaLabel.height +4;
	    parent => <-.UIframe;
	    width => .parent.clientWidth-4;
	    label = "Use Express input";
	    set => <-.schema.xp_in; 
	 };
	 UIeditToggle {
	    y => <-.UIxpInToggle.y + <-.UIxpInToggle.height +4;
	 };
      };
	 
      
      // **** pMacroBaseUI ****
      // base UI macro for all pModules contains stuff they all need
      // such as interface to Schema
      macro pMacroUIBase {
	 ilink schema;
	 UImod_panel parent {
	    title => name_of(<-.<-.<-);
	 };
      };
      
      // **** pMacroUI ****
      // base UI macro for all pModules contains stuff they all need
      // such as interface to Schema
      pMacroUIBase pMacroUI {
	 UIschema UIschema {
	    parent => <-.parent;
	    schema => <-.schema;
	 };
	 int y0 => .UIschema.UIframe.y + .UIschema.UIframe.height+4;
      };

      // **** pMacroImportUI ****
      // base UI macro for all pModules contains stuff they all need
      // such as interface to Schema
      pMacroUIBase pMacroImportUI {
	 UIschemaImport UIschemaImport {
	    parent => <-.parent;
	    schema => <-.schema;
	 };
	 int y0 => .UIschemaImport.UIframe.y + .UIschemaImport.UIframe.height+4;
      };

      // **** pMacroExportUI ****
      // base UI macro for all pModules contains stuff they all need
      // such as interface to Schema
      pMacroUIBase pMacroExportUI {
	 UIschemaExport UIschemaExport {
	    parent => <-.parent;
	    schema => <-.schema;
	 };
	 int y0 => .UIschemaExport.UIframe.y + .UIschemaExport.UIframe.height+4;
      };

   };

   library Utility {
      macro PSTControlUI {
	 UImod_panel parent {
	    title = "PST Control";
	 };
	 UItoggle UIstopToggle {
	    x = 2;
	    y = 2;
	    parent => <-.parent;
	    width => .parent.clientWidth -4;
	    label = "Prime PST Shutdown";
	 };
	 UIbutton UIstopButton {
	    x = 2;
	    y => <-.UIstopToggle.y + <-.UIstopToggle.height +4;
	    parent => <-.parent;
	    width => .parent.clientWidth -4;
	    label = "Stop PST";
	    active => <-.UIstopToggle.set;
	    color {
	       foregroundColor = "white";
	       backgroundColor = "red";
	    };
	 };
	 UItoggle UIprofileToggle {
	    x = 2;
	    y => <-.UIstopButton.y + <-.UIstopButton.height +4;
	    parent => <-.parent;
	    width => .parent.clientWidth -4;
	    label = "Profile";
	    set = 0;
#ifdef PST_LOGGED
	    visible = 1;
#else
	    visible = 0;
#endif
	 };
	 int+OPort2 stop => .UIstopButton.do;
	 int+OPort2 profile => .UIprofileToggle.set;
      };

      macro ExamineTagsUI {
	 group+IPort2 &tags_info {
	    string name;
	    int ncomps; // # of components
	    int ndomains; // equiv to npstnodes in associated schema
	    int decomp_dim;
	    int fieldid;
	    group comps[ncomps] {
	       int distributed; /* 0 = local, 1 = remote */
	       int composed; /* 0 = remote, 1 = local */
	       int moduleid; // the module that performed this decompostion
	       int fieldid; // the field from which it was distributed  (pass thrus can skip fields)
	       int compid;
	       int comp_type; /*  0 = coords, 1 = node_data, 2 = cell_set (conn_list),see pst_defs.h */
	       int coord_type; /* 0 = struct, 1 = implicit unif, 2 = implicit rect, 3 = unstruct */
	       int ndomains => <-.ndomains;
	       int veclen;
	       int domain_st[ndomains];
	       int domain_en[ndomains];
	       int domain_boundary;
	       enum type {
		  choices = {"char","byte","short","int","float","double"};
	       };  // data type
	       int locations[ndomains]; // where the data is
	    };
	 };
	 UImod_panel parent {
	    title => name_of(<-.<-.<-);
	 };
	 UIbutton UItriggerButton {
	    x = 2;
	    parent => <-.parent;
	    width => .parent.clientWidth -4;
	    label = "Update";
	 };
	 UItext UInamelabel {
	    x = 2;
	    parent => <-.parent;
	    width => .parent.clientWidth -4;
	    text => <-.tags_info.name;
	    multiLine = 1;
	    outputOnly = 1;
	    height = 40;
	 };
	 UIlabel UIncompsLabel {
	    x = 2;
	    parent => <-.parent;
	    width => .parent.clientWidth/2 -4;
	    label = "# components";
	 };
	 UIfield UIncompsField {
	    x => parent.clientWidth/2 +2;
	    y => <-.UIncompsLabel.y;
	    parent => <-.parent;
	    width => .parent.clientWidth/2 -4;
	    nullString = "";
	    mode = "integer";
	    outputOnly = 1;
	    value => <-.tags_info.ncomps;
	 };
	 UIlabel UIndomainsLabel {
	    x = 2;
	    parent => <-.parent;
	    width => .parent.clientWidth/2 -4;
	    label = "# domains";
	 };
	 UIfield UIndomainsField {
	    x => parent.clientWidth/2 +2;
	    y => <-.UIndomainsLabel.y;
	    parent => <-.parent;
	    width => .parent.clientWidth/2 -4;
	    nullString = "";
	    outputOnly = 1;
	    mode = "integer";
	    value => <-.tags_info.ndomains;
	 };
	 UIlabel UIdecomp_dimLabel {
	    x = 2;
	    parent => <-.parent;
	    width => .parent.clientWidth/2 -4;
	    label = "decomp_dim";
	 };
	 UIfield UIdecomp_dimField {
	    x => parent.clientWidth/2 +2;
	    y => <-.UIdecomp_dimLabel.y;
	    parent => <-.parent;
	    width => .parent.clientWidth/2 -4;
	    nullString = "";
	    outputOnly = 1;
	    mode = "integer";
	    value => <-.tags_info.decomp_dim;
	 };
	 UIlabel UIfieldidLabel {
	    x = 2;
	    parent => <-.parent;
	    width => .parent.clientWidth/2 -4;
	    label = "fieldid";
	 };
	 UIfield UIfieldidField {
	    x => parent.clientWidth/2 +2;
	    y => <-.UIfieldidLabel.y;
	    parent => <-.parent;
	    width => .parent.clientWidth/2 -4;
	    nullString = "";
	    outputOnly = 1;
	    mode = "integer";
	    value => <-.tags_info.fieldid;
	 };
	 UIslider UIcompsSlider {
	    x = 2;
	    parent => <-.parent;
	    width => .parent.clientWidth -4;
	    min = 0;
	    max => <-.tags_info.ncomps-1;
	    mode = "integer";
	    title = "Component";
	    value = 0;
	 };
	 int comp => UIcompsSlider.value;
	 UIframe UIcompsFrame {
	    x = 2;
	    parent => <-.parent;
	    width => .parent.clientWidth -4;
#ifdef MSDOS
	       height = 440;
#else
	       height = 465;
#endif
	 };
	 macro CompsUI {
	    ilink parentFrame => <-.UIcompsFrame;
	    int i => <-.comp;
	    UIpanel parent {
	       x = 2;
	       parent => <-.parentFrame;
	       width => .parent.clientWidth -4;
	       height => .parent.clientHeight;
	    };
	    UIlabel UIdistributedLabel {
	       x = 2;
	       parent => <-.parent;
	       width => .parent.clientWidth/2 -4;
	       label = "distributed";
	    };
	    UIfield UIdistributedField {
	       x => parent.clientWidth/2 +2;
	       y => <-.UIdistributedLabel.y;
	       parent => <-.parent;
	       width => .parent.clientWidth/2 -4;
	       nullString = "";
	       outputOnly = 1;
	       mode = "integer";
	       value => <-.<-.tags_info.comps[i].distributed;
	    };
	    UIlabel UIcomposedLabel {
	       x = 2;
	       parent => <-.parent;
	       width => .parent.clientWidth/2 -4;
	       label = "composed";
	    };
	    UIfield UIcomposedField {
	       x => parent.clientWidth/2 +2;
	       y => <-.UIcomposedLabel.y;
	       parent => <-.parent;
	       width => .parent.clientWidth/2 -4;
	       nullString = "";
	       outputOnly = 1;
	       mode = "integer";
	       value => <-.<-.tags_info.comps[i].composed;
	    };
	    UIlabel UImoduleidLabel {
	       x = 2;
	       parent => <-.parent;
	       width => .parent.clientWidth/2 -4;
	       label = "moduleid";
	    };
	    UIfield UImoduleidField {
	       x => parent.clientWidth/2 +2;
	       y => <-.UImoduleidLabel.y;
	       parent => <-.parent;
	       width => .parent.clientWidth/2 -4;
	       nullString = "";
	       outputOnly = 1;
	       mode = "integer";
	       value => <-.<-.tags_info.comps[i].moduleid;
	    };
	    UIlabel UIfieldidLabel {
	       x = 2;
	       parent => <-.parent;
	       width => .parent.clientWidth/2 -4;
	       label = "fieldid";
	    };
	    UIfield UIfieldidField {
	       x => parent.clientWidth/2 +2;
	       y => <-.UIfieldidLabel.y;
	       parent => <-.parent;
	       width => .parent.clientWidth/2 -4;
	       nullString = "";
	       outputOnly = 1;
	       mode = "integer";
	       value => <-.<-.tags_info.comps[i].fieldid;
	    };
	    UIlabel UIcompidLabel {
	       x = 2;
	       parent => <-.parent;
	       width => .parent.clientWidth/2 -4;
	       label = "compid";
	    };
	    UIfield UIcompidField {
	       x => parent.clientWidth/2 +2;
	       y => <-.UIcompidLabel.y;
	       parent => <-.parent;
	       width => .parent.clientWidth/2 -4;
	       nullString = "";
	       outputOnly = 1;
	       mode = "integer";
	       value => <-.<-.tags_info.comps[i].compid;
	    };
	    UIlabel UIcomp_typeLabel {
	       x = 2;
	       parent => <-.parent;
	       width => .parent.clientWidth/2 -4;
	       label = "comp_type";
	    };
	    UItext UIcomp_typeText {
	       x => parent.clientWidth/2 +2;
	       y => <-.UIcomp_typeLabel.y;
	       parent => <-.parent;
	       width => .parent.clientWidth/2 -4;
	       outputOnly = 1;
	       text => switch(<-.<-.tags_info.comps[i].comp_type+1, "coords", "node_data", "cell_set", "cell_data", "user");
	    };
	    UIlabel UIcoord_typeLabel {
	       x = 2;
	       parent => <-.parent;
	       width => .parent.clientWidth/2 -4;
	       label = "coord_type";
	       active => (<-.<-.tags_info.comps[i].comp_type == 0);
	    };
	    UItext UIcoord_typeText {
	       x => parent.clientWidth/2 +2;
	       y => <-.UIcoord_typeLabel.y;
	       parent => <-.parent;
	       width => .parent.clientWidth/2 -4;
	       outputOnly = 1;
	       text => switch(<-.<-.tags_info.comps[i].coord_type+1, "struct", "implicit unif", "implicit rect", "unstruct");
	       active => (<-.<-.tags_info.comps[i].comp_type == 0);
	    };
	    UIlabel UIveclenLabel {
	       x = 2;
	       parent => <-.parent;
	       width => .parent.clientWidth/2 -4;
	       label = "veclen";
	    };
	    UIfield UIveclenField {
	       x => parent.clientWidth/2 +2;
	       y => <-.UIveclenLabel.y;
	       parent => <-.parent;
	       width => .parent.clientWidth/2 -4;
	       nullString = "";
	       outputOnly = 1;
	       mode = "integer";
	       value => <-.<-.tags_info.comps[i].veclen;
	    };
	    UIlabel UIdomain_boundaryLabel {
	       x = 2;
	       parent => <-.parent;
	       width => .parent.clientWidth/2 -4;
	       label = "domain_boundary";
	    };
	    UIfield UIdomain_boundaryField {
	       x => parent.clientWidth/2 +2;
	       y => <-.UIdomain_boundaryLabel.y;
	       parent => <-.parent;
	       width => .parent.clientWidth/2 -4;
	       nullString = "";
	       outputOnly = 1;
	       mode = "integer";
	       value => <-.<-.tags_info.comps[i].domain_boundary;
	    };
	    UIlabel UItypeLabel {
	       x = 2;
	       parent => <-.parent;
	       width => .parent.clientWidth/2 -4;
	       label = "type";
	    };
	    UItext UItypeText {
	       x => parent.clientWidth/2 +2;
	       y => <-.UItypeLabel.y;
	       parent => <-.parent;
	       width => .parent.clientWidth/2 -4;
	       text => switch(<-.<-.tags_info.comps[i].type+1, "char","byte","short","int","float","double");
	       outputOnly = 1;
	    };
	    UIslider UIdomainSlider {
	       x = 2;
	       parent => <-.parent;
	       width => .parent.clientWidth -4;
	       min = 0;
	       max => <-.<-.tags_info.comps[i].ndomains-1;
	       mode = "integer";
	       title = "Domain";
	       value = 0;
	    };
	    int domain => .UIdomainSlider.value;
	    UIframe UIdomainFrame {
	       x = 2;
	       parent => <-.parent;
	       width => .parent.clientWidth -4;
	       height = 100;
	    };
	    macro DomainUI {
	       int i => <-.i;
	       int j => <-.domain;
	       UIpanel parent {
		  parent => <-.<-.UIdomainFrame;
		  width => .parent.clientWidth;
		  height => .parent.clientHeight;
	       };
	       UIlabel UIdomain_stLabel {
		  x = 2;
		  parent => <-.parent;
		  width => .parent.clientWidth/2 -4;
		  label = "domain_st";
	       };
	       UIfield UIField {
		  x => parent.clientWidth/2 +2;
		  y => <-.UIdomain_stLabel.y;
		  parent => <-.parent;
		  width => .parent.clientWidth/2 -4;
		  nullString = "";
		  outputOnly = 1;
		  mode = "integer";
		  value => <-.<-.<-.tags_info.comps[i].domain_st[j];
	       };
	       UIlabel UIdomain_enLabel {
		  x = 2;
		  parent => <-.parent;
		  width => .parent.clientWidth/2 -4;
		  label = "domain_en";
	       };
	       UIfield UIdomain_enField {
		  x => parent.clientWidth/2 +2;
		  y => <-.UIdomain_enLabel.y;
		  parent => <-.parent;
		  width => .parent.clientWidth/2 -4;
		  nullString = "";
		  outputOnly = 1;
		  mode = "integer";
		  value => <-.<-.<-.tags_info.comps[i].domain_en[j];
	       };
	       UIlabel UIlocationsLabel {
		  x = 2;
		  parent => <-.parent;
		  width => .parent.clientWidth/2 -4;
		  label = "location";
	       };
	       UIfield UIlocationsField {
		  x => parent.clientWidth/2 +2;
		  y => <-.UIlocationsLabel.y;
		  parent => <-.parent;
		  width => .parent.clientWidth/2 -4;
		  nullString = "";
		  outputOnly = 1;
		  mode = "integer";
		  value => <-.<-.<-.tags_info.comps[i].locations[j];
	       };
	    };
	 };
	 int+OPort2 trigger => .UItriggerButton.do;
      };
   };
};
