/*
                Copyright (c) 1999 by
                Advanced Visual Systems Inc.
                All Rights Reserved

        This software comprises unpublished confidential information of
        Advanced Visual Systems Inc. and may not be used, copied or made
        available to anyone, except in accordance with the license
        under which it is furnished.

        This file is under Perforce control
        $Id: //depot/express/fcs70/v/reduct.v#1 $
*/

flibrary+buffered RDCT<disabled => Templates.CONFIG.reduct_kit_disabled>
{
library RDCT_MODS <
    build_dir="reduct",
    build_cmd="$(MAKE)",
    libdeps="GD FLD DV",
    cxx_hdr_files="fld/Xfld.h surfRed.h dataSurfRed.h",
    out_src_file="rdct_gen.cxx",
    out_hdr_file="rdct_gen.h",
    use_src_file=0,
    link_files="-lrdct"
> {
  // module
  module ReduceTriCells
  {
    Mesh &mesh_in<NEportLevels={2,0}>;
    Mesh mesh_out<NEportLevels={0,2}>;

    float MaxSurfTol<NEportLevels={1,1}>;
    float ReductionTarget<NEportLevels={1,1}>;
    float FinalReduction<NEportLevels={1,1}>;
    boolean Speed<NEportLevels={1,1}>;
    enum Mode<NEportLevels={2,2}> {
      choices = {"Manual", "Dynamic"};
    };
    boolean Go<NEportLevels={1,1}>;

    cxxmethod+notify_inst+req reduce<status=1>(
      mesh_in+notify+read+req,
      mesh_out+write,
      MaxSurfTol+notify+read+req,
      ReductionTarget+notify+read+req,
      FinalReduction+write,
      Speed+notify+read+req,
      Mode+notify+read+req,
      Go+notify+read
    );
  };

  // module
  module DataReduceTriCells
  {
    Mesh &mesh_in<NEportLevels={2,0}>;
    Mesh mesh_out<NEportLevels={0,2}>;
    
    float InitSurfTol<NEportLevels={1,1}>;
    float SurfTolInc<NEportLevels={1,1}>;
    float ReductionTarget<NEportLevels={1,1}>;
    float FinalReduction<NEportLevels={1,1}>;
    int MaxIterations<NEportLevels={1,1}>;
    boolean PreserveEdges<NEportLevels={1,1}>;
    int DataDependence<NEportLevels={1,1}>;
    float Weight<NEportLevels={1,1}>;
    enum Mode<NEportLevels={1,1}> {
      choices={"Manual", "Dynamic"};
    };
    boolean Go<NEportLevels={1,1}>;

    cxxmethod+notify_inst+req reduce<status=1>(
      mesh_in+notify+read+req,
      mesh_out+write,
      InitSurfTol+notify+read+req,
      SurfTolInc+notify+read+req,
      ReductionTarget+notify+read+req,
      FinalReduction+write,
      PreserveEdges+notify+read+req,
      MaxIterations+notify+read+req,
      DataDependence+notify+read+req,
      Weight+notify+read+req,
      Mode+notify+read+req,
      Go+notify+read
    );
  };
};

library RDCT_MACS<compile_subs=0> {

  // parameter block
  group SurfRedParams <NEportLevels={0,1}>{
    float MaxSurfTol<NEportLevels={2,2},export=2>;
    float ReductionTarget<NEportLevels={2,2}>;
    float FinalReduction<NEportLevels={2,2}>;
    boolean Speed<NEportLevels={2,2}>;
    enum Mode<NEportLevels={2,2}> {
      choices = {"Manual", "Dynamic"};
    };
    boolean Go<NEportLevels={2,2}>;
  };

  // functional macro
  macro SurfaceReduction {
    link in<NEportLevels={2,1}>;
    SurfRedParams &SurfRedParams<NEportLevels={2,1}>;
    ReduceTriCells ReduceTriCells {
      mesh_in => <-.in;
      &MaxSurfTol      => SurfRedParams.MaxSurfTol;
      &ReductionTarget => SurfRedParams.ReductionTarget;
      &FinalReduction  => SurfRedParams.FinalReduction;
      &Speed           => SurfRedParams.Speed;
      &Mode            => SurfRedParams.Mode;
      &Go              => SurfRedParams.Go;
    };
    link out<NEportLevels={1,2}> => .ReduceTriCells.mesh_out;
  };

  // user interface macro
  macro SurfaceReductionUI {
    SurfRedParams &SurfRedParams<NEportLevels={2,0}>;
    UImod_panel surface_reduction {
      height = 200;
      option {
        set = 1;
      };
    };
    UIslider Reduction_Target {
      y = 0;
      width = 240;
      parent => <-.surface_reduction;
      min = 0.;
      max = 100.;
      value => <-.SurfRedParams.ReductionTarget;
      mode = "real";
      decimalPoints = 1;
      title => "Reduction Target %";
      increment = 0.5;
    };
    UIfield MaxSurfTol {
      x = 165;
      y = 60;
      width = 65;
      parent => <-.surface_reduction;
      value => <-.SurfRedParams.MaxSurfTol;
      mode = "real";
      decimalPoints = 5;
      nullString = "";
    };
    UIlabel MST_label {
      y = 64;
      width = 160;
      parent => <-.surface_reduction;
      label => "Max Surface Tolerance";
    };
    UItoggle Speed {
      x = 4;
      y = 95;
      parent => <-.surface_reduction;
      set => <-.SurfRedParams.Speed;
    };
    UItoggle Dynamic {
      parent => <-.surface_reduction;
      x = 4;
      y = 120;
      set => <-.SurfRedParams.Mode;
    };
    UIbutton Reduce {
      x = 110;
      y = 120;
      parent => <-.surface_reduction;
      active=> (!<-.Dynamic.set);
      do<NEportLevels={2,2}> => <-.SurfRedParams.Go;
    };
    UIlabel Final_Reduction {
      parent => <-.surface_reduction;
      label => str_format("Final Reduction is %.1f%%",<-.SurfRedParams.FinalReduction);
      y = 150;
      width = 250;
    };
   };

  // user macro
  macro surface_reduction {
    link in<NEportLevels={2,1}>;
    SurfRedParams SurfRedParams<NEportLevels={0,1}>
    {
      MaxSurfTol = 0.001;
      ReductionTarget = 80.;
      FinalReduction = 0.;
      Speed = 0;
      Mode = "Manual";
    };
    SurfaceReduction SurfaceReduction {
      in => <-.in;
      SurfRedParams => <-.SurfRedParams;
    };
    SurfaceReductionUI SurfaceReductionUI {
      SurfRedParams => <-.SurfRedParams;
      surface_reduction {
        parent<NEportLevels={4,0}>;
        title => name_of(<-.<-.<-);
        message = "Surface Reduction control panel.";
      };
    };
    GDM.DataObject DataObject {
      in => <-.SurfaceReduction.out;
      Obj {
        name=> name_of(<-.<-.<-);
      };
    };
    link out<NEportLevels={1,2}> => .SurfaceReduction.out;
    link obj<NEportLevels={1,2}> => .DataObject.obj;
  };


  // parameter block
  group DataSurfRedParams<NEportLevels={0,1},export=1> {
    float InitSurfTol<NEportLevels={2,2},export=2>;
    float SurfTolInc<NEportLevels={2,2}>;
    float ReductionTarget<NEportLevels={2,2}>;
    float FinalReduction<NEportLevels={2,2}>;
    int MaxIterations<NEportLevels={2,2}>;
    boolean PreserveEdges<NEportLevels={2,2}>;
    int DataDependence<NEportLevels={2,2}>;
    float Weight<NEportLevels={2,2}>;
    enum Mode<NEportLevels={2,2}>{
      choices={"Manual", "Dynamic"};
    };
    boolean Go<NEportLevels={2,2}>;
  };

  // functional macro
  macro DataSurfaceReduction {
    link in<NEportLevels={2,1}>;
    DataSurfRedParams &DataSurfRedParams<NEportLevels={2,1}>;
    DataReduceTriCells DataReduceTriCells {
      mesh_in => <-.in;
      InitSurfTol     => DataSurfRedParams.InitSurfTol;
      SurfTolInc      => DataSurfRedParams.SurfTolInc;
      ReductionTarget => DataSurfRedParams.ReductionTarget;
      FinalReduction  => DataSurfRedParams.FinalReduction;
      MaxIterations   => DataSurfRedParams.MaxIterations;
      PreserveEdges   => DataSurfRedParams.PreserveEdges;
      DataDependence  => DataSurfRedParams.DataDependence;
      Weight          => DataSurfRedParams.Weight;
      Mode            => DataSurfRedParams.Mode;
      Go              => DataSurfRedParams.Go;
    };
    link out<NEportLevels={1,2}> => .DataReduceTriCells.mesh_out;
  };

  // user interface
  macro DataSurfaceReductionUI {
    DataSurfRedParams &DataSurfRedParams<NEportLevels={2,0}>;
    UImod_panel data_surface_reduction {
      height = 390;
      option {
        set = 1;
      };
    };
    UIslider Reduction_Target {
      y = 0;
      width = 240;
      parent => <-.data_surface_reduction;
      min = 0.;
      max = 100.;
      value => <-.DataSurfRedParams.ReductionTarget;
      increment = 5.;
    };
    UIframe Surf_Tol_Frame {
      y = 60;
      width = 240;
      height = 80;
      parent => <-.data_surface_reduction;
    };
    UIfield Init_Surf_Tol {
      x = 160;
      y = 4;
      width = 65;
      parent => <-.Surf_Tol_Frame;
      min = 0.;
      max = 1.;
      value => <-.DataSurfRedParams.InitSurfTol;
      mode = "real";
      decimalPoints = 5;
      nullString = "";
    };
    UIfield Surf_Tol_Inc {
      x = 160;
      y = 40;
      width = 65;
      parent => <-.Surf_Tol_Frame;
      min = 0.;
      max = 1.;
      value => <-.DataSurfRedParams.SurfTolInc;
      mode = "real";
      decimalPoints = 5;
      nullString = "";
    };
    UIlabel IST_Label {
      x = 4;
      y = 8;
      width = 147;
      parent => <-.Surf_Tol_Frame;
      label => "Initial Surface Tolerance";
      alignment = "left";
    };
    UIlabel STI_Label {
      x = 4;
      y = 44;
      width = 147;
      parent => <-.Surf_Tol_Frame;
      label => "Surface Tolerance Inc";
      alignment = "left";
    };
   UIfield Maximum_Iterations {
      x = 128;
      y = 145;
      parent => <-.data_surface_reduction;
      min = 0.;
      value => <-.DataSurfRedParams.MaxIterations;
      mode = "integer";
      nullString = "";
    };
    UIlabel MI_Label {
      x = 4;
      y = 145;
      width = 125;
      parent => <-.data_surface_reduction;
      label => "Max Iterations";
      alignment = "left";
    };
    macro DataDependenceUI {
      UIframe DD_Frame {
        y = 180;
        width = 240;
        height = 105;
        parent<NEportLevels={3,0}> => <-.<-.data_surface_reduction;
      };
      UIslider Data_Weight {
        y = 40;
        width = 230;
        active<NEportLevels={2,1}> => <-.Data_Dependence.selectedItem;
        parent => <-.DD_Frame;
        min = 0.;
        max = 1.;
        value<NEportLevels={3,2}> => <-.<-.DataSurfRedParams.Weight;
        mode = "real";
        decimalPoints = 3;
        increment = 0.05;
      };
      UIoption None;
      UIoption Gradient;
      UIoption Curvature;
      UIoptionMenu Data_Dependence {
        parent => <-.DD_Frame;
        cmdList => {<-.None,<-.Gradient,<-.Curvature};
        selectedItem =><-.<-.DataSurfRedParams.DataDependence;
        x = 4;
        y = 4;
        active = 1;
      };
    };
    UItoggle Preserve_Edges {
      parent => <-.data_surface_reduction;
      set<NEportLevels={2,2}> => <-.DataSurfRedParams.PreserveEdges;
      y = 290;
      width = 200;
    };
    UIlabel Final_Reduction {
      parent => <-.data_surface_reduction;
      label => str_format("Final Reduction is %.1f%%",<-.DataSurfRedParams.FinalReduction);
      y = 350;
      width = 230;
    };
    UItoggle Dynamic {
      parent => <-.data_surface_reduction;
      set<NEportLevels={2,2}> => <-.DataSurfRedParams.Mode;
      y = 320;
    };
    UIbutton Reduce<NEx=517.,NEy=484.> {
      x = 100;
      y = 320;
      parent => <-.data_surface_reduction;
      active => (!<-.Dynamic.set);
      do<NEportLevels={2,1}> => <-.DataSurfRedParams.Go;
    };
  };

  // user macro
  macro data_surface_reduction {
    link in<NEportLevels={2,1}>;
    DataSurfRedParams DataSurfRedParams {
      InitSurfTol = 0.001;
      SurfTolInc = 0.001;
      ReductionTarget = 80.;
      FinalReduction = 0.;
      MaxIterations = 10;
      PreserveEdges = 0;
      DataDependence = 0;
      Weight = 0.2;
      Mode = "Manual";
    };
    DataSurfaceReduction DataSurfaceReduction {
      in => <-.in;
      DataSurfRedParams => <-.DataSurfRedParams;
    };
    GDM.DataObject DataObject {
      in => <-.DataSurfaceReduction.out;
      Obj {
        name => name_of(<-.<-.<-);
      };
    };
    DataSurfaceReductionUI DataSurfaceReductionUI {
      DataSurfRedParams => <-.DataSurfRedParams;
      data_surface_reduction {
        parent<NEportLevels={4,0}>;
        title => name_of(<-.<-.<-);
        message = "Data Surface Reduction control panel.";
      };
    };
    link out<NEportLevels={1,2}> => .DataSurfaceReduction.out;
    link obj<NEportLevels={1,2}> => .DataObject.obj;
  };

};

};
