/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/ren.v#1 $
*/
flibrary+global REN <
   indexed=0,
   // need this to get loaded before user libraries are so virt data is
   // defined
   libimm=1
> {

   /* These are the definitions of the functions that will
      be invoked to do primitive level picking for all 
      renderers.
   */
   group pick_funcs<NEvisible=1> {
      data_method+virtual pick_points = "GDpick_points"; 
      data_method+virtual pick_spheres = "GDpick_spheres";
      data_method+virtual pick_lines = "GDpick_lines";
      data_method+virtual pick_polyline = "GDpick_polyline";
      data_method+virtual pick_polytri = "GDpick_polytri";
      data_method+virtual pick_tris = "GDpick_tris";
      data_method+virtual pick_wiretris = "GDpick_wiretris";
      data_method+virtual pick_quads = "GDpick_quads";
      data_method+virtual pick_wirequads = "GDpick_wirequads";
      data_method+virtual pick_polygon = "GDpick_polygon";
      data_method+virtual pick_image = "GDpick_2dimage";
   };

/*------------------------------------------------------------------*/

   /* These are the defintions of the functions that will
      be invoked to render a specific type of Express field.
      For each different type a field, a rendering function
      will exist that will take the input field and decompose
      it into low-level renderer specific rendering primitives.

      When the user wants to render a new type of data, a new
      function is added for that data to convert it into
      renderable primitives.
   */

   Grid_Unif+Cells_Struct+Dim2 Render_UnifMesh<NEvisible=1> {
      nnodes+read;
      group+read coordinates {
	long+read nvals => nnodes;
	int+read veclen => nspace;
	float+read values[nvals][veclen];
      }; 
      int+read+opt nnode_data;
      Data_Array_Simple+read+opt node_data[nnode_data];
      cell_set+read {
         int+read+opt ncell_data;
         Data_Array_Simple+read+opt cell_data[ncell_data];
      };
      data_method+virtual+nosave render = "GDdraw_mesh_unif";
      data_method+virtual+nosave pick = "GDpick_mesh_unif";
#ifdef INVENTOR
      data_method+virtual+nosave in_render = "INdraw_mesh";
      data_method+virtual+nosave in_pick = "INpick_mesh";
#endif
   };

   Grid_Rect+Cells_Struct+Dim2 Render_RectMesh<NEvisible=1> {
      nnodes+read;
      group+read coordinates {
	long+read nvals => nnodes;
	int+read veclen => nspace;
	float+read values[nvals][veclen];
      }; 
      int+read+opt nnode_data;
      Data_Array_Simple+read+opt node_data[nnode_data];
      cell_set+read {
         int+read+opt ncell_data;
         Data_Array_Simple+read+opt cell_data[ncell_data];
      };
      data_method+virtual+nosave render = "GDdraw_mesh_rect";
      data_method+virtual+nosave pick = "GDpick_mesh";
#ifdef INVENTOR
      data_method+virtual+nosave in_render = "INdraw_mesh";
      data_method+virtual+nosave in_pick = "INpick_mesh";
#endif
   };

   Grid_Struct+Cells_Struct+Dim2 Render_Mesh<NEvisible=1> {
      nnodes+read;
      group+read coordinates {
	long+read nvals => nnodes;
	int+read veclen => nspace;
	float+read values[nvals][veclen];
      }; 
      int+read+opt nnode_data;
      Data_Array_Simple+read+opt node_data[nnode_data];
      cell_set+read {
         int+read+opt ncell_data;
         Data_Array_Simple+read+opt cell_data[ncell_data];
      };
      data_method+virtual+nosave render = "GDdraw_mesh";
      data_method+virtual+nosave pick = "GDpick_mesh";
#ifdef INVENTOR
      data_method+virtual+nosave in_render = "INdraw_mesh";
      data_method+virtual+nosave in_pick = "INpick_mesh";
#endif
   };

   Grid_Rect+Cells_Struct+Dim3+Space3 Render_Rect3<NEvisible=1> {
      nnodes+read;
      group+read coordinates {
	long+read nvals => nnodes;
	int+read veclen => nspace;
	float+read values[nvals][veclen];
      }; 
      int+read+opt nnode_data;
      Data_Array_Simple+read+opt node_data[nnode_data];
      cell_set+read {
         int+read+opt ncell_data;
         Data_Array_Simple+read+opt cell_data[ncell_data];
      };
      // Renders a 3D structured field by turning the external
      // faces into Quads
      data_method+virtual+nosave render = "GDdraw_struct_3d";
      data_method+virtual+nosave pick = "GDpick_struct_3d";
   };

   Grid_Unif+Cells_Struct+Dim3+Space3 Render_Unif3<NEvisible=1> {
      nnodes+read;
      group+read coordinates {
	long+read nvals => nnodes;
	int+read veclen => nspace;
	float+read values[nvals][veclen];
      }; 
      int+read+opt nnode_data;
      Data_Array_Simple+read+opt node_data[nnode_data];
      cell_set+read {
         int+read+opt ncell_data;
         Data_Array_Simple+read+opt cell_data[ncell_data];
      };
      // Renders a 3D structured field by turning the external
      // faces into Quads
      data_method+virtual+nosave render = "GDdraw_struct_3d";
      data_method+virtual+nosave pick = "GDpick_struct_3d";
   };

   Grid_Unif+Cells_Struct+Dim3+Space3 Render_Volume<NEvisible=1> {
      nnodes+read;
      group+read coordinates {
	long+read nvals => nnodes;
	int+read veclen => nspace;
	float+read values[nvals][veclen];
      };
      int+read nnode_data = 1;
      Data_Array_Simple+read node_data[nnode_data] {
         veclen = 1;
      };
      data_method+virtual+nosave render = "GDdraw_volume";
      data_method+virtual+nosave pick = "GDpick_volume";
   };

   TextField Render_TextArray<NEvisible=1> {
      stroke = 0;
      data_method+virtual+nosave render = "GDdraw_text_array";
      data_method+virtual+nosave pick = "GDpick_text_array";
   };

   TextField Render_StrokeTextArray<NEvisible=1> {
      stroke = 1;
      data_method+virtual+nosave render = "GDdraw_stroke_text_array";
      data_method+virtual+nosave pick = "GDpick_stroke_text_array";
   };

   Grid+Cells Render_Polyhedra<NEvisible=1> {
      nnodes+read;

      group+read coordinates {
	long+read nvals => nnodes;
	int+read veclen => nspace;
	float+read values[nvals][veclen];
      }; 

      int+read+opt nnode_data;
      cell_set+read {
         int+read+opt ncell_data;
         Data_Array_Simple+read+opt cell_data[ncell_data];
      };
      ncell_sets+read;
      Data_Array_Simple+read+opt node_data[nnode_data];
      data_method+virtual+nosave render = "GDdraw_polyh";
      data_method+virtual+nosave pick = "GDpick_polyh";
#ifdef INVENTOR
      data_method+virtual+nosave in_render = "INdraw_polyh";
      data_method+virtual+nosave in_pick = "INpick_polyh";
#endif
   };

   Text_NoXform Render_Text<NEvisible=1> {
      stroke = 0;
      data_method+virtual+nosave render = "GDdraw_text";
      data_method+virtual+nosave pick = "GDpick_text";
   };

   Text_NoXform Render_StrokeText<NEvisible=1> {
      stroke = 1;
      data_method+virtual+nosave render = "GDdraw_stroke_text";
      data_method+virtual+nosave pick = "GDpick_stroke_text";
   };

   Mesh_Array Render_MeshArray<NEvisible=1> {
      data_method+virtual+nosave render = "GDdraw_mesh_array";
      data_method+virtual+nosave pick = "GDpick_mesh_array";
   };

   Tiled_Volume Render_UnifVol<NEvisible=1> {
      data_method+virtual+nosave render = "GDdraw_volume_tiled";
      data_method+virtual+nosave pick = "GDpick_volume_tiled";
   };

   /* These are different cells types in an unstructured field.  They are
      used to match cell type and call the right function if GDxxx_polyh is
      called.
    */

   Point Render_PointCells<NEvisible=1> {
      data_method+virtual+nosave render = "GDdraw_point_cells";
      data_method+virtual+nosave pick = "GDpick_point_cells";
#ifdef INVENTOR
      data_method+virtual+nosave in_render = "INdraw_point_cells";
      data_method+virtual+nosave in_pick = "INpick_point_cells";
#endif
   };

   Line Render_LineCells<NEvisible=1> {
      data_method+virtual+nosave render = "GDdraw_line_cells";
      data_method+virtual+nosave pick = "GDpick_line_cells";
#ifdef INVENTOR
      data_method+virtual+nosave in_render = "INdraw_ind_cells";
      data_method+virtual+nosave in_pick = "INpick_ind_cells";
#endif
   };

   Line2 Render_Line2Cells<NEvisible=1> {
      data_method+virtual+nosave render = "GDdraw_line2_cells";
      data_method+virtual+nosave pick = "GDpick_line2_cells";
   };

   Polyline Render_PolylineCells<NEvisible=1> {
      data_method+virtual+nosave render = "GDdraw_polyline_cells";
      data_method+virtual+nosave pick = "GDpick_polyline_cells";
#ifdef INVENTOR
      data_method+virtual+nosave in_render = "INdraw_nonind_cells";
      data_method+virtual+nosave in_pick = "INpick_nonind_cells";
#endif
   };

   Polytri Render_PolytriCells<NEvisible=1> {
      data_method+virtual+nosave render = "GDdraw_polytri_cells";
      data_method+virtual+nosave pick = "GDpick_polytri_cells";
#ifdef INVENTOR
      data_method+virtual+nosave in_render = "INdraw_nonind_cells";
      data_method+virtual+nosave in_pick = "INpick_nonind_cells";
#endif
   };

   Tri Render_TriCells<NEvisible=1> {
      data_method+virtual+nosave render = "GDdraw_tri_cells";
      data_method+virtual+nosave pick = "GDpick_tri_cells";
#ifdef INVENTOR
      data_method+virtual+nosave in_render = "INdraw_ind_cells";
      data_method+virtual+nosave in_pick = "INpick_ind_cells";
#endif
   };

   Tri2 Render_Tri2Cells<NEvisible=1> {
      data_method+virtual+nosave render = "GDdraw_tri2_cells";
      data_method+virtual+nosave pick = "GDpick_tri2_cells";
   };

   Quad Render_QuadCells<NEvisible=1> {
      data_method+virtual+nosave render = "GDdraw_quad_cells";
      data_method+virtual+nosave pick = "GDpick_quad_cells";
#ifdef INVENTOR
      data_method+virtual+nosave in_render = "INdraw_ind_cells";
      data_method+virtual+nosave in_pick = "INpick_ind_cells";
#endif
   };

   Quad2 Render_Quad2Cells<NEvisible=1> {
      data_method+virtual+nosave render = "GDdraw_quad2_cells";
      data_method+virtual+nosave pick = "GDpick_quad2_cells";
   };

   Polyhedron Render_PolyhedronCells<NEvisible=1> {
      data_method+virtual+nosave render = "GDdraw_polyh_cells";
      data_method+virtual+nosave pick = "GDpick_polyh_cells";
   };

};
