/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved
	
	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.
	
	This file is under Perforce control
        $Id: //depot/express/fcs70/v/ren_mpu.v#1 $

*/

$include ../include/avs/gd_def.h

   /* These are the definitions of the functions that will
      be invoked to do view level device dependent processing
      for the GL based renderer.
   */

   group mpu_view_funcs<NEvisible=1> {
      int renderer = GD_MPU_RENDERER;
      func+virtual view_available      = "GDmpu_view_available";
      func+virtual view_create         = "GDmpu_view_create";
      func+virtual view_clear          = "GDmpu_view_clear";
      func+virtual view_transp_pass    = "GDmpu_view_transp_pass";
      func+virtual view_image_pass     = "GDmpu_view_image_pass";
      func+virtual view_accel          = "GDmpu_view_accel";
      func+virtual view_accel2d        = "GDmpu_view_accel2d";
      func+virtual view_get_buffers    = "GDmpu_view_get_buffers";
      func+virtual view_get_image      = "GDmpu_view_get_image";
      func+virtual view_put_image      = "GDmpu_view_put_image";
      func+virtual view_swap1          = "GDmpu_view_swap1";
      func+virtual view_swap2          = "GDmpu_view_swap2";
      func+virtual view_refresh        = "GDmpu_view_refresh";
      func+virtual view_delete         = "GDmpu_view_delete";
      func+virtual view_resize         = "GDmpu_view_resize";
      func+virtual view_set_video_mode = "GDmpu_view_set_video_mode";
      func+virtual view_set_left_eye   = "GDmpu_view_set_left_eye";
      func+virtual view_set_right_eye  = "GDmpu_view_set_right_eye";
   };

   /* These are the definitions of the functions that will
      be invoked to do the state levele device dependent
      processing by the GL based renderer.
   */
   group mpu_state_funcs<NEvisible=1> {
      int renderer = GD_MPU_RENDERER;
      func+virtual state_create               = "GDmpu_state_create";
      func+virtual state_delete               = "GDmpu_state_delete";
      func+virtual state_init                 = "GDmpu_state_init";
      func+virtual state_set_color            = "GDmpu_set_color";
      func+virtual state_set_highlight_colors = "GDstate_set_highlight_colors";
      func+virtual state_set_draw_mode        = "GDmpu_set_draw_mode";
      func+virtual state_set_font             = "GDmpu_set_font";
      func+virtual state_set_line_width       = "GDmpu_set_line_width";
      func+virtual state_set_line_style       = "GDmpu_set_line_style";
      func+virtual state_set_line_aa          = "GDmpu_set_line_aa";
      func+virtual state_set_dir_pt_size      = "GDstate_set_dir_pt_size";
      func+virtual state_set_subdiv           = "GDstate_set_subdiv";
      func+virtual state_set_jitter           = "GDstate_set_jitter";
      func+virtual state_set_material         = "GDmpu_set_material";
      func+virtual state_set_mode             = "GDmpu_set_mode";
      func+virtual state_set_mode_normals     = "GDstate_set_mode_normals";
      func+virtual state_set_mode_outline     = "GDstate_set_mode_outline";
      func+virtual state_set_texture          = "GDmpu_set_texture";
      func+virtual state_set_depth_cue        = "GDmpu_set_depth_cue";
      func+virtual state_set_transparency     = "GDmpu_set_transparency";
      func+virtual state_set_obj_matrix       = "GDstate_set_obj_matrix";
      func+virtual state_concat_obj_matrix    = "GDstate_concat_obj_matrix";
      func+virtual state_update_matrix        = "GDmpu_update_matrix";
      func+virtual state_set_specular_color   = "GDmpu_set_specular_color";
      func+virtual state_set_backface_cull    = "GDmpu_set_backface_cull";
      func+virtual state_set_vox_interp       = "GDstate_set_vox_interp";
      func+virtual state_set_blend_mode       = "GDstate_set_blend_mode";
      func+virtual state_set_cmap             = "GDstate_set_cmap";
      func+virtual state_set_camera_attrs     = "GDmpu_set_camera_attrs";
      func+virtual state_set_lights           = "GDmpu_set_lights";
      func+virtual state_set_viewport         = "GDstate_set_viewport";
     // IAC: func+virtual state_set_stereo_attrs     = "GDstate_set_stereo_attrs";
      func+virtual state_set_stereo_attrs     = "GDmpu_state_set_stereo_attrs";	
   };

   /* These are the definitions of the functions that will
      be invoked to do primitive level device dependent processing
      for the GL based renderer.
   */
   group mpu_prim_funcs<NEvisible=1> {
      int renderer = GD_MPU_RENDERER;
      func+virtual prim_3d_points   = "GDmpu_points"; 
      func+virtual prim_3d_lines    = "GDmpu_lines";
      func+virtual prim_3d_polyline = "GDmpu_polyline";
      func+virtual prim_3d_polytri  = "GDmpu_polytri";
      func+virtual prim_3d_tris	    = "GDmpu_tris";
      func+virtual prim_3d_quads    = "GDmpu_quads";
      func+virtual prim_3d_spheres  = "GDmpu_spheres";
      func+virtual prim_3d_text     = "GDmpu_text";
      func+virtual prim_3d_volume   = "GDmpu_volume";

      func+virtual prim_2d_text     = "GDmpu_2d_text";
      func+virtual prim_2d_points   = "GDmpu_2d_points";
      func+virtual prim_2d_lines    = "GDmpu_2d_lines";
      func+virtual prim_2d_polyline = "GDmpu_2d_polyline";
      func+virtual prim_2d_polytri  = "GDmpu_2d_polytri";
      func+virtual prim_2d_tris	    = "GDmpu_2d_tris";
      func+virtual prim_2d_quads    = "GDmpu_2d_quads";
      func+virtual prim_2d_polygons = "GDmpu_2d_polygons";
      func+virtual prim_2d_image    = "GDmpu_image";
   };

   /* These are the definitions of the functions that will
      be invoked to do device dependent geom data manipulation
      for the GL based renderer.
   */
   group mpu_geom_funcs<NEvisible=1> {
      int renderer = GD_MPU_RENDERER;
      func+virtual geom_init  = "GDmpu_geom_init";
      func+virtual geom_build = "GDmpu_geom_build";
      func+virtual geom_free  = "GDmpu_geom_free";
   };
