/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
        $Id: //depot/express/fcs70/v/ren_ogl.v#1 $
*/

$include ../include/avs/gd_def.h

   /* These are the definitions of the functions that will
      be invoked to do view level device dependent processing
      for the GL based renderer.
   */
   group gl_view_funcs<NEvisible=1> {
      int renderer = GD_GL_RENDERER;
      func+virtual view_available      = "GDgl_view_available";
      func+virtual view_create         = "GDgl_view_create";
      func+virtual view_clear          = "GDgl_view_clear";
      func+virtual view_transp_pass    = "GDgl_view_transp_pass";
      func+virtual view_image_pass     = "GDgl_view_image_pass";
      func+virtual view_accel          = "GDgl_view_accel";
      func+virtual view_accel2d        = "GDgl_view_accel2d";
      func+virtual view_get_buffers    = "GDgl_view_get_buffers";
      func+virtual view_get_image      = "GDgl_view_get_image";
      func+virtual view_put_image      = "GDgl_view_put_image";
      func+virtual view_swap1          = "GDgl_view_swap1";
      func+virtual view_swap2          = "GDgl_view_swap2";
      func+virtual view_refresh        = "GDgl_view_refresh";
      func+virtual view_delete         = "GDgl_view_delete";
      func+virtual view_resize         = "GDgl_view_resize";
      func+virtual view_set_video_mode = "GDgl_view_set_video_mode";
      func+virtual view_set_left_eye   = "GDgl_view_set_left_eye";
      func+virtual view_set_right_eye  = "GDgl_view_set_right_eye";
   };

   /* These are the definitions of the functions that will
      be invoked to do the state levele device dependent
      processing by the GL based renderer.
   */
   group gl_state_funcs<NEvisible=1> {
      int renderer = GD_GL_RENDERER;
      func+virtual state_create               = "GDgl_state_create";
      func+virtual state_delete               = "GDgl_state_delete";
      func+virtual state_init                 = "GDgl_state_init";
      func+virtual state_set_color            = "GDgl_set_color";
      func+virtual state_set_highlight_colors = "GDstate_set_highlight_colors";
      func+virtual state_set_draw_mode        = "GDgl_set_draw_mode";
      func+virtual state_set_font             = "GDgl_set_font";
      func+virtual state_set_line_width       = "GDgl_set_line_width";
      func+virtual state_set_line_style       = "GDgl_set_line_style";
      func+virtual state_set_line_aa          = "GDgl_set_line_aa";
      func+virtual state_set_dir_pt_size      = "GDstate_set_dir_pt_size";
      func+virtual state_set_subdiv           = "GDstate_set_subdiv";
      func+virtual state_set_jitter           = "GDstate_set_jitter";
      func+virtual state_set_material         = "GDgl_set_material";
      func+virtual state_set_mode             = "GDgl_set_mode";
      func+virtual state_set_mode_normals     = "GDstate_set_mode_normals";
      func+virtual state_set_mode_outline     = "GDstate_set_mode_outline";
      func+virtual state_set_texture          = "GDgl_set_texture";
      func+virtual state_set_depth_cue        = "GDgl_set_depth_cue";
      func+virtual state_set_transparency     = "GDgl_set_transparency";
      func+virtual state_set_obj_matrix       = "GDstate_set_obj_matrix";
      func+virtual state_concat_obj_matrix    = "GDstate_concat_obj_matrix";
      func+virtual state_update_matrix        = "GDgl_update_matrix";
      func+virtual state_set_specular_color   = "GDgl_set_specular_color";
      func+virtual state_set_backface_cull    = "GDgl_set_backface_cull";
      func+virtual state_set_vox_interp       = "GDstate_set_vox_interp";
      func+virtual state_set_blend_mode       = "GDstate_set_blend_mode";
      func+virtual state_set_cmap             = "GDstate_set_cmap";
      func+virtual state_set_camera_attrs     = "GDgl_set_camera_attrs";
      func+virtual state_set_lights           = "GDgl_set_lights";
      func+virtual state_set_viewport         = "GDstate_set_viewport";
      func+virtual state_set_stereo_attrs     = "GDstate_set_stereo_attrs";
   };

   /* These are the definitions of the functions that will
      be invoked to do primitive level device dependent processing
      for the GL based renderer.
   */
   group gl_prim_funcs<NEvisible=1> {
      int renderer = GD_GL_RENDERER;
      func+virtual prim_3d_points   = "GDgl_points";
      func+virtual prim_3d_lines    = "GDgl_lines";
      func+virtual prim_3d_polyline = "GDgl_polyline";
      func+virtual prim_3d_polytri  = "GDgl_polytri";
      func+virtual prim_3d_tris	    = "GDgl_tris";
      func+virtual prim_3d_quads    = "GDgl_quads";
      func+virtual prim_3d_spheres  = "GDgl_spheres";
      func+virtual prim_3d_text     = "GDgl_text";
      func+virtual prim_3d_volume   = "GDgl_volume";

      func+virtual prim_2d_text     = "GDgl_2d_text";
      func+virtual prim_2d_points   = "GDgl_2d_points";
      func+virtual prim_2d_lines    = "GDgl_2d_lines";
      func+virtual prim_2d_polyline = "GDgl_2d_polyline";
      func+virtual prim_2d_polytri  = "GDgl_2d_polytri";
      func+virtual prim_2d_tris	    = "GDgl_2d_tris";
      func+virtual prim_2d_quads    = "GDgl_2d_quads";
      func+virtual prim_2d_polygons = "GDgl_2d_polygons";
      func+virtual prim_2d_image    = "GDgl_image";
   };

   /* These are the definitions of the functions that will
      be invoked to do device dependent geom data manipulation
      for the GL based renderer.
   */
   group gl_geom_funcs<NEvisible=1> {
      int renderer = GD_GL_RENDERER;
      func+virtual geom_init  = "GDgl_geom_init";
      func+virtual geom_build = "GDgl_geom_build";
      func+virtual geom_free  = "GDgl_geom_free";
   };
