/*
			Copyright (c) 1997 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/ren_vps.v#1 $
*/

$include ../include/avs/gd_def.h

   /* device dependent view  functions for VPS renderer */
   group vps_view_funcs<NEvisible=1> {
      int renderer = GD_VPS_RENDERER;
      func+virtual view_available      = "GDvps_view_available";
      func+virtual view_create         = "GDvps_view_create";
      func+virtual view_clear          = "GDvps_view_clear";
      func+virtual view_delete         = "GDvps_view_delete";
      func+virtual view_transp_pass    = "GDvps_view_transp_pass";
      func+virtual view_accel          = "GDvps_view_accel";
      func+virtual view_accel2d        = "GDvps_view_accel2d";
      func+virtual view_swap1          = "GDvps_view_swap1";
      func+virtual view_swap2          = "GDvps_view_swap2";
      func+virtual view_image_pass     = "GDvps_view_image_pass";
      func+virtual view_refresh        = "GDvps_view_refresh";
      func+virtual view_resize         = "GDvps_view_resize";
      func+virtual view_set_video_mode = "GDsw_view_set_video_mode";
      func+virtual view_set_left_eye   = "GDsw_view_set_left_eye";
      func+virtual view_set_right_eye  = "GDsw_view_set_right_eye";
      func+virtual view_get_image      = "GDvps_view_get_image";
      func+virtual view_put_image      = "GDvps_view_put_image";
   };

   /* device dependent state functions for VPS renderer */
   group vps_state_funcs<NEvisible=1> {
      int renderer = GD_VPS_RENDERER;
      func+virtual state_create               = "GDvps_state_create";
      func+virtual state_delete               = "GDvps_state_delete";
      func+virtual state_init                 = "GDstate_init";
      func+virtual state_set_color            = "GDstate_set_color";
      func+virtual state_set_highlight_colors = "GDstate_set_highlight_colors";
      func+virtual state_set_font             = "GDstate_set_font";
      func+virtual state_set_dir_pt_size      = "GDstate_set_dir_pt_size";
      func+virtual state_set_subdiv           = "GDstate_set_subdiv";
      func+virtual state_set_jitter           = "GDstate_set_jitter";
      func+virtual state_set_line_width       = "GDvps_set_line_width";
      func+virtual state_set_line_style       = "GDvps_set_line_style";
      func+virtual state_set_material         = "GDstate_set_material";
      func+virtual state_set_mode             = "GDstate_set_mode";
      func+virtual state_set_mode_normals     = "GDstate_set_mode_normals";
      func+virtual state_set_mode_outline     = "GDstate_set_mode_outline";
      func+virtual state_set_texture          = "GDstate_set_texture";
      func+virtual state_set_depth_cue        = "GDstate_set_depth_cue";
      func+virtual state_set_transparency     = "GDstate_set_transparency";
      func+virtual state_set_obj_matrix       = "GDstate_set_obj_matrix";
      func+virtual state_concat_obj_matrix    = "GDstate_concat_obj_matrix";
      func+virtual state_update_matrix        = "GDstate_update_matrix";
      func+virtual state_set_specular_color   = "GDstate_set_specular_color";
      func+virtual state_set_backface_cull    = "GDstate_set_backface_cull";
      func+virtual state_set_cmap             = "GDstate_set_cmap";
      func+virtual state_set_camera_attrs     = "GDvps_set_camera_attrs";
      func+virtual state_set_lights           = "GDvps_set_lights";
      func+virtual state_set_viewport         = "GDstate_set_viewport";
      func+virtual state_set_stereo_attrs     = "GDstate_set_stereo_attrs";
   };

   /* device dependent primitive functions for VPS renderer */
   group vps_prim_funcs<NEvisible=1> {
      int renderer = GD_VPS_RENDERER;
      func+virtual prim_3d_points   = "GDvps_points3d"; 
      func+virtual prim_3d_lines    = "GDvps_lines3d";
      func+virtual prim_3d_polyline = "GDvps_polyline3d";
      func+virtual prim_3d_polytri  = "GDvps_polytri3d";
      func+virtual prim_3d_spheres  = "GDvps_spheres3d";
      func+virtual prim_3d_text     = "GDvps_text3d";

      func+virtual prim_2d_points    = "GDvps_points2d";
      func+virtual prim_2d_lines     = "GDvps_lines2d";
      func+virtual prim_2d_polyline  = "GDvps_polyline2d";
      func+virtual prim_2d_polylines = "GDvps_polylines2d";
      func+virtual prim_2d_polytri   = "GDvps_polytri2d";
      func+virtual prim_2d_polygons  = "GDvps_polygons2d";
      func+virtual prim_2d_text      = "GDvps_text2d";
   };

   /* device dependent geom data for VPS renderer */
   group vps_geom_funcs<NEvisible=1> {
      int renderer = GD_VPS_RENDERER;
/*
      func+virtual geom_init  = "GDvps_geom_init";
      func+virtual geom_build = "GDvps_geom_build";
      func+virtual geom_free  = "GDvps_geom_free";
*/
   };
