/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved
	
	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.
	
	This file is under Perforce control
        $Id: //depot/express/fcs70/v/ren_vrml.v#1 $
*/

$include ../include/avs/gd_def.h

   /* device dependent view  functions for VRML renderer */
   group vrml_view_funcs<NEvisible=1> {
      int renderer = GD_VRML_RENDERER;
      func+virtual view_available      = "GDvrml_view_available";
      func+virtual view_create         = "GDvrml_view_create";
      func+virtual view_clear          = "GDvrml_view_clear";
      func+virtual view_delete         = "GDvrml_view_delete";
      func+virtual view_transp_pass    = "GDvrml_view_transp_pass";
      func+virtual view_accel          = "GDvrml_view_accel";
      func+virtual view_accel2d        = "GDvrml_view_accel2d";
      func+virtual view_swap1          = "GDvrml_view_swap1";
      func+virtual view_swap2          = "GDvrml_view_swap2";
      func+virtual view_image_pass     = "GDvrml_view_image_pass";
      func+virtual view_refresh        = "GDvrml_view_refresh";
      func+virtual view_resize         = "GDvrml_view_resize";
      func+virtual view_set_video_mode = "GDsw_view_set_video_mode";
      func+virtual view_set_left_eye   = "GDsw_view_set_left_eye";
      func+virtual view_set_right_eye  = "GDsw_view_set_right_eye";
      func+virtual view_get_image      = "GDsw_view_get_image";
      func+virtual view_put_image      = "GDsw_view_put_image";
   };

   /* device dependent state functions for VRML renderer */
   group vrml_state_funcs<NEvisible=1> {
      int renderer = GD_VRML_RENDERER;
      func+virtual state_create               = "GDvrml_state_create";
      func+virtual state_delete               = "GDvrml_state_delete";
      func+virtual state_init                 = "GDstate_init";
      func+virtual state_set_color            = "GDstate_set_color";
      func+virtual state_set_highlight_colors = "GDstate_set_highlight_colors";
      func+virtual state_set_font             = "GDstate_set_font";
      func+virtual state_set_dir_pt_size      = "GDstate_set_dir_pt_size";
      func+virtual state_set_subdiv           = "GDstate_set_subdiv";
      func+virtual state_set_jitter           = "GDstate_set_jitter";
      func+virtual state_set_material         = "GDstate_set_material";
      func+virtual state_set_mode             = "GDstate_set_mode";
      func+virtual state_set_mode_normals     = "GDstate_set_mode_normals";
      func+virtual state_set_mode_outline     = "GDstate_set_mode_outline";
      func+virtual state_set_www_anchor       = "GDvrml_set_www_anchor";
      func+virtual state_set_texture          = "GDvrml_set_texture";
      func+virtual state_set_depth_cue        = "GDstate_set_depth_cue";
      func+virtual state_set_transparency     = "GDstate_set_transparency";
      func+virtual state_set_obj_matrix       = "GDstate_set_obj_matrix";
      func+virtual state_concat_obj_matrix    = "GDstate_concat_obj_matrix";
      func+virtual state_update_matrix        = "GDstate_update_matrix";
      func+virtual state_set_specular_color   = "GDstate_set_specular_color";
      func+virtual state_set_backface_cull    = "GDstate_set_backface_cull";
      func+virtual state_set_cmap             = "GDstate_set_cmap";
      func+virtual state_set_camera_attrs     = "GDvrml_set_camera_attrs";
      func+virtual state_set_lights           = "GDvrml_set_lights";
      func+virtual state_set_viewport         = "GDstate_set_viewport";
      func+virtual state_set_stereo_attrs     = "GDstate_set_stereo_attrs";
   };

   /* device dependent primitive functions for VRML renderer */
   group vrml_prim_funcs<NEvisible=1> {
      int renderer = GD_VRML_RENDERER;
      func+virtual prim_3d_points   = "GDvrml_points3d"; 
      func+virtual prim_3d_lines    = "GDvrml_lines3d";
      func+virtual prim_3d_polyline = "GDvrml_polyline3d";
      func+virtual prim_3d_polytri  = "GDvrml_polytri3d";
      func+virtual prim_3d_tris     = "GDvrml_tris3d";
      func+virtual prim_3d_quads    = "GDvrml_quads3d";
      func+virtual prim_3d_spheres  = "GDvrml_spheres3d";
      func+virtual prim_3d_text     = "GDvrml_text3d";
      func+virtual prim_2d_tris     = "GDvrml_dummy";
      func+virtual prim_2d_quads    = "GDvrml_dummy";
   };

   /* device dependent geom data for VRML renderer */
   group vrml_geom_funcs<NEvisible=1> {
      int renderer = GD_VRML_RENDERER;
/*
      func+virtual geom_init  = "GDvrml_geom_init";
      func+virtual geom_build = "GDvrml_geom_build";
      func+virtual geom_free  = "GDvrml_geom_free";
*/
   };
