/*
#  		Copyright (c) 1993 by
#  		Advanced Visual Systems Inc.
#  		All Rights Reserved
#
#  This software comprises unpublished confidential information of
#  Advanced Visual Systems Inc. and may not be used, copied or made
#  available to anyone, except in accordance with the license
#  under which it is furnished.
#
*/
flibrary+global UI_GLOBAL <
   locked=1,
   need_cxx=1,
   need_objs="WT_OBJS",
   hdr_code="int UIglobal_init (int *, char **);",
   init_code="   UIglobal_init(argc,argv);"
> {

/* Global object for Display attributes */
group UIdisplay {
    string+read	displayName;
    int+write	width, height;
    ptr+write	displayPtr;
    double	scaleX => width / 1280;
    double	scaleY => height / 1024;
    method_upd	update = "UIdisplayUpdate";
};

/* Global object for font description */
group UIfont {
    UIdisplay+read+req+nres	*Display => UIdisplays[0];

    string+read		isoFontString;

    string+read		familyName;
    string+read		familyType;
    int+read		weight;
    Boolean+read	italic;
    Boolean+read	underline;
    Boolean+read	strikeout;
    float+read		pointSize;

    ptr+write		fontPtr;
    Boolean+write	matched;
    int+write		height;
    int+write		lineHeight;
    method_upd		update = "UIfontUpdate";
};

group UIdata {

    int num_displays;
    UIdisplay UIdisplays[num_displays];

    int num_fonts;
    UIfont UIfonts[num_fonts];
};

// The DBoptions object is used by UI objects in binary V files such as
// db.vo and ne.vo for determining whether config.h contains definitions
// for the DB kit.
//
// NOTE: This object is unsupported, and may not be present in future releases.

group DBoptions {

    int DBKit =
#ifdef DB_KIT
    1;
#else
    0;
#endif

    int oracleKit =
#ifdef ORACLE_KIT
    1;
#else
    0;
#endif

    int sybaseKit =
#ifdef SYBASE_KIT
    1;
#else
    0;
#endif

    int informixKit =
#ifdef INFORMIX_KIT
    1;
#else
    0;
#endif

    int odbcKit =
#ifdef ODBC_KIT
    1;
#else
    0;
#endif
};

};
