/*
                Copyright (c) 1992,1994 by
                Advanced Visual Systems Inc.
                All Rights Reserved


 This software comprises unpublished confidential information of Advanced
 Visual Systems Inc. and may not be used, copied or made available to
 anyone, except in accordance with the license under which it is furnished.

 This file is under Perforce control
 $Id: //depot/express/fcs70/v/vizxp/aghlm.v#1 $
*/

/* the "needs_edit_lic" property is set so that the macros can only
   be opened in Display List Mode in vxp;

   could use <NEopenable=0> on individual macros but then they'd come up
   in DLM for xp too
 */
flibrary+sort+buffered AGHLM
   <needs_edit_lic="GD", disabled => Templates.CONFIG.ag_kit_disabled> {

macro XYAxis {
   macro XAxis<instanced=0> {
      macro XAxle_UI {
         UItoggle Axle_on_off {
            parent => <-.UIframe_Axle;
            y = 0;
            set => <-.<-.<-.X_Axis_params.Axle_on_off;
            label => "Axle on/off";
         };
         UIfield Yposition {
            parent => <-.UIframe_Axle;
            value<NEportLevels={2,2}> => <-.<-.<-.X_Axis_params.Y_Axis_pos;
            y => (<-.Axle_on_off.y + <-.Axle_on_off.height) + 10;
         };
         UIlabel Yposition_label {
            parent => <-.UIframe_Axle;
            label => "Y Axis \ncrossing position";
            x => <-.<-.XText_UI.Axis_text.width + 10;
            y => <-.Yposition.y;
            height => UIdata.UIfonts[0].lineHeight + 20;
         };
         UIfield Axle_width_typein {
            parent => <-.UIframe_Axle;
            value<NEportLevels={2,2}> => <-.Axle_width.value;
            x => <-.Axle_width.width + 5;
            y => <-.Axle_width.y;
            width = 40;
         };
         UIslider Axle_width {
            parent => <-.UIframe_Axle;
            value<NEportLevels={2,2}> => <-.<-.<-.X_Axis_params.Axle_width;
            title => "Axle width";
            y => (<-.Yposition.y + <-.Yposition.height) + 10;
            min = 0.01;
            max = 20.;
         };
         UIoptionMenu Axle_color {
            parent => <-.UIframe_Axle;
            cmdList => <-.<-.<-.color1;
            y => (<-.Axle_width.y + <-.Axle_width.height) + 10;
            width => .UIradioBox.y + .UIradioBox.height;
            height = 20;
            selectedItem => <-.<-.<-.X_Axis_params.Axle_color;
            x = 0;
         };
         UIframe UIframe_Axle {
            parent => <-.<-.<-.panel;
            x = 5;
            y => <-.<-.<-.panelY;
            width = 245;
            height => (<-.Axle_color.y + <-.Axle_color.height) + 20;
         };
      };
      macro XText_UI {
         UItext Axis_text {
            y => (<-.Text_color.y + <-.Text_color.height) + 10;
            parent => <-.UIframe_Text;
            text => <-.<-.<-.X_Axis_params.X_Axis_text;
         };
         UIlabel Axis_text_label {
            parent => <-.UIframe_Text;
            label => "X Axis Text";
            x => <-.Axis_text.width + 10;
            y => <-.Axis_text.y;
         };
         UIslider Text_Height_slider {
            parent => <-.UIframe_Text;
            value<NEportLevels={2,2}> => <-.<-.<-.X_Axis_params.text_height;
            title => "Text height";
            y => (<-.reverse_text_alignment.y + <-.reverse_text_alignment.height) + 10;
            min = 0.;
            max = 10.;
         };
         UIfield Text_Height_typein {
            parent => <-.UIframe_Text;
            value<NEportLevels={2,2}> => <-.Text_Height_slider.value;
            x => <-.Text_Height_slider.width + 5;
            y => <-.Text_Height_slider.y;
            width = 40;
         };
         UItoggle reverse_text_alignment {
            parent => <-.UIframe_Text;
            y = 0;
            width => <-.UIframe_Text.width - 5;
            set => <-.<-.<-.X_Axis_params.reverse_text;
         };
         UIframe UIframe_Text {
            parent => <-.<-.<-.panel;
            x => <-.<-.XAxle_UI.UIframe_Axle.x;
            y => (<-.<-.XAxle_UI.UIframe_Axle.y + <-.<-.XAxle_UI.UIframe_Axle.height) + 10;
            width => <-.<-.XAxle_UI.UIframe_Axle.width;
            height => (<-.Axis_text.y + <-.Axis_text.height) + 20;
         };
         UIoptionMenu Text_color {
            parent => <-.UIframe_Text;
            cmdList => <-.<-.<-.color2;
            y => (<-.Text_Height_slider.y + <-.Text_Height_slider.height) + 10;
            width => .UIradioBox.y + .UIradioBox.height;
            height = 20;
            selectedItem => <-.<-.<-.X_Axis_params.Text_color;
            x = 0;
         };
      };
      macro XLabel_UI {
         UIoptionMenu Label_color {
            parent => <-.UIframe_Label;
            cmdList => <-.<-.<-.color3;
            y => (<-.Label_Height_slider.y + <-.Label_Height_slider.height) + 10;
            width => .UIradioBox.y + .UIradioBox.height;
            height = 20;
            selectedItem => <-.<-.<-.X_Axis_params.Label_color;
            x = 0;
         };
         UIframe UIframe_Label {
            parent => <-.<-.<-.panel;
            x => <-.<-.XAxle_UI.UIframe_Axle.x;
            y => (<-.<-.XText_UI.UIframe_Text.y + <-.<-.XText_UI.UIframe_Text.height) + 10;
            width => <-.<-.XAxle_UI.UIframe_Axle.width;
            height => (<-.Label_Decimals.y + <-.Label_Decimals.height) + 20;
         };
         UIslider Label_Height_slider {
            parent => <-.UIframe_Label;
            value<NEportLevels={2,2}> => <-.<-.<-.X_Axis_params.label_height;
            title => "Label height";
            y = 0;
            min = 0.;
            max = 10.;
         };
         UIfield Label_Height_typein {
            parent => <-.UIframe_Label;
            value<NEportLevels={2,2}> => <-.Label_Height_slider.value;
            x => <-.Label_Height_slider.width + 5;
            y => <-.Label_Height_slider.y;
            width = 40;
         };
         UIslider Label_Decimals {
            parent => <-.UIframe_Label;
            value<NEportLevels={2,2}> => <-.<-.<-.X_Axis_params.label_Decimals;
            title => "Label Decimals";
            y => (<-.Label_color.y + <-.Label_color.height) + 10;
            min = 0.;
            max = 10.;
            decimalPoints = 0;
         };
      };
      macro XTickLine_UI {
         UItoggle Major_Tick_on_off {
            y = 0;
            width = 120;
            label => "X Tickline on/off";
            set => <-.<-.<-.X_Axis_params.X_Tickline_on_off;
            parent => <-.UIframe_MajorTick;
         };
         UIframe UIframe_MajorTick {
            parent => <-.<-.<-.panel;
            x => <-.<-.XAxle_UI.UIframe_Axle.x;
            y => (<-.<-.XLabel_UI.UIframe_Label.y + <-.<-.XLabel_UI.UIframe_Label.height) + 10;
            width => <-.<-.XAxle_UI.UIframe_Axle.width;
            height => (<-.Minor_tick_color.y + <-.Minor_tick_color.height) + 10;
         };
         UIfield major_step {
            parent => <-.UIframe_MajorTick;
            value<NEportLevels={2,2}> => <-.<-.<-.X_Axis_params.Steps_for_Major;
            y => (<-.Major_Tick_on_off.y + <-.Major_Tick_on_off.height) + 10;
         };
         UIlabel major_step_label {
            parent => <-.UIframe_MajorTick;
            height => (UIdata.UIfonts[0].lineHeight + 0) * 2;
            label => "Steps for \nMajor tick marks";
            x => (<-.major_step.x + <-.major_step.width) + 20;
            y => <-.major_step.y;
         };
         UIfield minor_step {
            parent => <-.UIframe_MajorTick;
            value<NEportLevels={2,2}> => <-.<-.<-.X_Axis_params.Steps_for_Minor;
            y => (<-.major_step.y + <-.major_step.height) + 10;
            decimalPoints = 0;
         };
         UIlabel minor_step_label {
            parent => <-.UIframe_MajorTick;
            height => (UIdata.UIfonts[0].lineHeight + 0) * 2;
            label => "Steps for \nMinor tick marks";
            x => (<-.minor_step.x + <-.minor_step.width) + 20;
            y => <-.minor_step.y;
         };
         UIslider Major_tick_width {
            parent => <-.UIframe_MajorTick;
            value<NEportLevels={2,2}> => <-.<-.<-.X_Axis_params.Major_tick_width;
            y => (<-.minor_step.y + <-.minor_step.height) + 10;
            min = 0.01;
            max = 20.;
         };
         UIfield Major_tick_typein {
            parent => <-.UIframe_MajorTick;
            value<NEportLevels={2,2}> => <-.Major_tick_width.value;
            x => <-.Major_tick_width.width + 5;
            y => <-.Major_tick_width.y;
            width = 40;
         };
         UIslider Minor_tick_width {
            parent => <-.UIframe_MajorTick;
            y => (<-.Major_tick_width.y + <-.Major_tick_width.height) + 10;
            value<NEportLevels={2,2}> => <-.<-.<-.X_Axis_params.Minor_tick_width;
            min = 0.01;
            max = 20.;
         };
         UIfield Minor_tick_typein {
            parent => <-.UIframe_MajorTick;
            value<NEportLevels={2,2}> => <-.Minor_tick_width.value;
            x => <-.Minor_tick_width.width + 5;
            y => <-.Minor_tick_width.y;
            width = 40;
         };
         UIoptionMenu Major_tick_style {
            parent => <-.UIframe_MajorTick;
            cmdList => <-.<-.<-.style1;
            selectedItem => <-.<-.<-.X_Axis_params.Major_tick_style;
            y => (<-.Minor_tick_width.y + <-.Minor_tick_width.height) + 20;
            x = 0;
         };
         UIoptionMenu Minor_tick_style {
            parent => <-.UIframe_MajorTick;
            cmdList => <-.<-.<-.style2;
            selectedItem => <-.<-.<-.X_Axis_params.Minor_tick_style;
            y => <-.Major_tick_color.y + <-.Major_tick_color.height;
            x = 0;
         };
         UIoptionMenu Major_tick_color {
            parent => <-.UIframe_MajorTick;
            cmdList => <-.<-.<-.color4;
            selectedItem => <-.<-.<-.X_Axis_params.Major_tick_color;
            y => <-.Major_tick_style.y + <-.Major_tick_style.height;
            x = 0;
         };
         UIoptionMenu Minor_tick_color {
            parent => <-.UIframe_MajorTick;
            cmdList => <-.<-.<-.color5;
            selectedItem => <-.<-.<-.X_Axis_params.Minor_tick_color;
            y => <-.Minor_tick_style.y + <-.Minor_tick_style.height;
            x = 0;
         };
         boolean valuesX_used => array_size(<-.<-.Graph_in.valuesX);
      };
   };
   macro YAxis {
      macro YAxle_UI {
         UItoggle Axle_on_off {
            parent => <-.UIframe_Axle;
            y = 0;
            set => <-.<-.<-.Y_Axis_params.Axle_on_off;
            label => "Axle on/off";
         };
         UIfield Yposition {
            parent => <-.UIframe_Axle;
            value<NEportLevels={2,2}> => <-.<-.<-.Y_Axis_params.X_Axis_pos;
            y => (<-.Axle_on_off.y + <-.Axle_on_off.height) + 10;
         };
         UIlabel Yposition_label {
            parent => <-.UIframe_Axle;
            label => "X Axis \ncrossing position";
            x => <-.<-.YText_UI.Axis_text.width + 10;
            y => <-.Yposition.y;
            height => (UIdata.UIfonts[0].lineHeight + 20);
         };
         UIfield Axle_width_typein {
            parent => <-.UIframe_Axle;
            value<NEportLevels={2,2}> => <-.Axle_width.value;
            x => <-.Axle_width.width + 5;
            y => <-.Axle_width.y;
            width = 40;
         };
         UIslider Axle_width {
            parent => <-.UIframe_Axle;
            value<NEportLevels={2,2}> => <-.<-.<-.Y_Axis_params.Axle_width;
            title => "Axle width";
            y => (<-.Yposition.y + <-.Yposition.height) + 10;
            min = 0.01;
            max = 20.;
         };
         UIoptionMenu Axle_color {
            parent => <-.UIframe_Axle;
            cmdList => <-.<-.<-.color1;
            y => (<-.Axle_width.y + <-.Axle_width.height) + 10;
            width => .UIradioBox.y + .UIradioBox.height;
            height = 20;
            selectedItem => <-.<-.<-.Y_Axis_params.Axle_color;
            x = 0;
         };
         UIframe UIframe_Axle {
            parent => <-.<-.<-.panel;
            x = 5;
            y => <-.<-.<-.panelY;
            width = 245;
            height => (<-.Axle_color.y + <-.Axle_color.height) + 20;
         };
      };
      macro YText_UI {
         UItext Axis_text {
            y => (<-.Text_color.y + <-.Text_color.height) + 10;
            parent => <-.UIframe_Text;
            text => <-.<-.<-.Y_Axis_params.Y_Axis_text;
         };
         UIlabel Axis_text_label {
            parent => <-.UIframe_Text;
            label => "Y Axis Text";
            x => <-.Axis_text.width + 10;
            y => <-.Axis_text.y;
         };
         UIslider Text_Height_slider {
            parent => <-.UIframe_Text;
            value<NEportLevels={2,2}> => <-.<-.<-.Y_Axis_params.text_height;
            title => "Text height";
            y => (<-.reverse_text_alignment.y + <-.reverse_text_alignment.height) + 10;
            min = 0.;
            max = 10.;
         };
         UIfield Text_Height_typein {
            parent => <-.UIframe_Text;
            value<NEportLevels={2,2}> => <-.Text_Height_slider.value;
            x => <-.Text_Height_slider.width + 5;
            y => <-.Text_Height_slider.y;
            width = 40;
         };
         UItoggle reverse_text_alignment {
            parent => <-.UIframe_Text;
            y = 0;
            width => <-.UIframe_Text.width - 5;
            set => <-.<-.<-.Y_Axis_params.reverse_text;
         };
         UIframe UIframe_Text {
            parent => <-.<-.<-.panel;
            x => <-.<-.YAxle_UI.UIframe_Axle.x;
            y => (<-.<-.YAxle_UI.UIframe_Axle.y + <-.<-.YAxle_UI.UIframe_Axle.height) + 10;
            width => <-.<-.YAxle_UI.UIframe_Axle.width;
            height => (<-.Axis_text.y + <-.Axis_text.height) + 20;
         };
         UIoptionMenu Text_color {
            parent => <-.UIframe_Text;
            cmdList => <-.<-.<-.color2;
            y => (<-.Text_Height_slider.y + <-.Text_Height_slider.height) + 10;
            width => .UIradioBox.y + .UIradioBox.height;
            height = 20;
            selectedItem => <-.<-.<-.Y_Axis_params.Text_color;
            x = 0;
         };
      };
      macro YLabel_UI {
         UIoptionMenu Label_color {
            parent => <-.UIframe_Label;
            cmdList => <-.<-.<-.color3;
            y => (<-.Label_Height_slider.y + <-.Label_Height_slider.height) + 10;
            width => .UIradioBox.y + .UIradioBox.height;
            height = 20;
            selectedItem => <-.<-.<-.Y_Axis_params.Label_color;
            x = 0;
         };
         UIframe UIframe_Label {
            parent => <-.<-.<-.panel;
            x => <-.<-.YAxle_UI.UIframe_Axle.x;
            y => (<-.<-.YText_UI.UIframe_Text.y + <-.<-.YText_UI.UIframe_Text.height) + 10;
            width => <-.<-.YAxle_UI.UIframe_Axle.width;
            height => (<-.Label_Decimals.y + <-.Label_Decimals.height) + 20;
         };
         UIslider Label_Height_slider {
            parent => <-.UIframe_Label;
            value<NEportLevels={2,2}> => <-.<-.<-.Y_Axis_params.label_height;
            title => "Label height";
            y = 0;
            min = 0.;
            max = 10.;
         };
         UIfield Label_Height_typein {
            parent => <-.UIframe_Label;
            value<NEportLevels={2,2}> => <-.Label_Height_slider.value;
            x => <-.Label_Height_slider.width + 5;
            y => <-.Label_Height_slider.y;
            width = 40;
         };
         UIslider Label_Decimals {
            parent => <-.UIframe_Label;
            value<NEportLevels={2,2}> => <-.<-.<-.Y_Axis_params.label_Decimals;
            title => "Label Decimals";
            y => (<-.Label_color.y + <-.Label_color.height) + 10;
            min = 0.;
            max = 10.;
            decimalPoints = 0;
         };
      };
      macro YTickLine_UI {
         UItoggle Major_Tick_on_off {
            y = 0;
            width = 120;
            label => "Y Tickline on/off";
            set => <-.<-.<-.Y_Axis_params.Y_Tickline_on_off;
            parent => <-.UIframe_MajorTick;
         };
         UIframe UIframe_MajorTick {
            parent => <-.<-.<-.panel;
            x => <-.<-.YAxle_UI.UIframe_Axle.x;
            y => (<-.<-.YLabel_UI.UIframe_Label.y + <-.<-.YLabel_UI.UIframe_Label.height) + 10;
            width => <-.<-.YAxle_UI.UIframe_Axle.width;
            height => (<-.Minor_tick_color.y + <-.Minor_tick_color.height) + 10;
         };
         UIfield major_step {
            parent => <-.UIframe_MajorTick;
            value<NEportLevels={2,2}> => <-.<-.<-.Y_Axis_params.Steps_for_Major;
            y => (<-.Major_Tick_on_off.y + <-.Major_Tick_on_off.height) + 10;
         };
         UIlabel major_step_label {
            parent => <-.UIframe_MajorTick;
            height => (UIdata.UIfonts[0].lineHeight + 0) * 2;
            label => "Steps for \nMajor tick marks";
            x => (<-.major_step.x + <-.major_step.width) + 20;
            y => <-.major_step.y;
         };
         UIfield minor_step {
            parent => <-.UIframe_MajorTick;
            value<NEportLevels={2,2}> => <-.<-.<-.Y_Axis_params.Steps_for_Minor;
            y => (<-.major_step.y + <-.major_step.height) + 10;
            decimalPoints = 0;
         };
         UIlabel minor_step_label {
            parent => <-.UIframe_MajorTick;
            height => (UIdata.UIfonts[0].lineHeight + 0) * 2;
            label => "Steps for \nMinor tick marks";
            x => (<-.minor_step.x + <-.minor_step.width) + 20;
            y => <-.minor_step.y;
         };
         UIslider Major_tick_width {
            parent => <-.UIframe_MajorTick;
            value<NEportLevels={2,2}> => <-.<-.<-.Y_Axis_params.Major_tick_width;
            y => (<-.minor_step.y + <-.minor_step.height) + 10;
            min = 0.01;
            max = 20.;
         };
         UIfield Major_tick_typein {
            parent => <-.UIframe_MajorTick;
            value<NEportLevels={2,2}> => <-.Major_tick_width.value;
            x => <-.Major_tick_width.width + 5;
            y => <-.Major_tick_width.y;
            width = 40;
         };
         UIslider Minor_tick_width {
            parent => <-.UIframe_MajorTick;
            y => (<-.Major_tick_width.y + <-.Major_tick_width.height) + 10;
            value<NEportLevels={2,2}> => <-.<-.<-.Y_Axis_params.Minor_tick_width;
            min = 0.01;
            max = 20.;
         };
         UIfield Minor_tick_typein {
            parent => <-.UIframe_MajorTick;
            value<NEportLevels={2,2}> => <-.Minor_tick_width.value;
            x => <-.Minor_tick_width.width + 5;
            y => <-.Minor_tick_width.y;
            width = 40;
         };
         UIoptionMenu Major_tick_style {
            parent => <-.UIframe_MajorTick;
            cmdList => <-.<-.<-.style1;
            selectedItem => <-.<-.<-.Y_Axis_params.Major_tick_style;
            y => (<-.Minor_tick_width.y + <-.Minor_tick_width.height) + 20;
            x = 0;
         };
         UIoptionMenu Minor_tick_style {
            parent => <-.UIframe_MajorTick;
            cmdList => <-.<-.<-.style2;
            selectedItem => <-.<-.<-.Y_Axis_params.Minor_tick_style;
            y => <-.Major_tick_color.y + <-.Major_tick_color.height;
            x = 0;
         };
         UIoptionMenu Major_tick_color {
            parent => <-.UIframe_MajorTick;
            cmdList => <-.<-.<-.color4;
            selectedItem => <-.<-.<-.Y_Axis_params.Major_tick_color;
            y => <-.Major_tick_style.y + <-.Major_tick_style.height;
            x = 0;
         };
         UIoptionMenu Minor_tick_color {
            parent => <-.UIframe_MajorTick;
            cmdList => <-.<-.<-.color5;
            selectedItem => <-.<-.<-.Y_Axis_params.Minor_tick_color;
            y => <-.Minor_tick_style.y + <-.Minor_tick_style.height;
            x = 0;
         };
      };
   };
   UImod_panel panel<NEportLevels={3,0}> {
      x = 0;
      y = 0;
      title => name_of(<-.<-);
      height = 1300;
      parent<NEportLevels={3,0}>;
      option {
         set = 1;
      };
   };
   GMOD.instancer inst_XAxis {
      Group => <-.XAxis;
      Value => ((<-.Axis.selectedItem == 0) && (<-.panel.visible == 1));
   };
   GMOD.instancer inst_YAxis {
      Group => <-.YAxis;
      Value => ((<-.Axis.selectedItem == 1) && (<-.panel.visible == 1));
   };
   UIradioBoxLabel Axis {
      labels => <-.axis;
      parent => <-.panel;
      selectedItem = 1;
   };
   string axis[] = {"XAxis","YAxis"};
   float panelX => .Axis.x;
   float panelY => (.Axis.y + .Axis.height) + 10;
   mlink mlink<NEportLevels={1,2}> => {.AGXAxis,
      .AGXTicklines,.AGYAxis,.AGYTicklines};
   AGXAxis AGXAxis {
      majorTickOn = 1;
      text<NEportLevels={2,0}> => <-.XAxis.XText_UI.Axis_text.text;
      visibility  => <-.XAxis.XAxle_UI.Axle_on_off.set;
      labelHeight => <-.XAxis.XLabel_UI.Label_Height_slider.value;
      positionY   => <-.XAxis.XAxle_UI.Yposition.value;
      majorStepX  => <-.XAxis.XTickLine_UI.major_step.value;
      labelMode   => <-.XAxis.XText_UI.reverse_text_alignment.set;
      majorTickLineStyle => <-.XAxis.XTickLine_UI.Major_tick_style.selectedItem;
      majorTickWidth => <-.XAxis.XTickLine_UI.Major_tick_width.value;
      minorTickCount => <-.XAxis.XTickLine_UI.minor_step.value;
      minorTickLineStyle => <-.XAxis.XTickLine_UI.Minor_tick_style.selectedItem;
      minorTickWidth => <-.XAxis.XTickLine_UI.Minor_tick_width.value;
      majorTickColor => <-.XAxis.XTickLine_UI.Major_tick_color.cmdList[<-.XAxis.XTickLine_UI.Major_tick_color.selectedItem].label;
      minorTickColor => <-.XAxis.XTickLine_UI.Minor_tick_color.cmdList[<-.XAxis.XTickLine_UI.Minor_tick_color.selectedItem].label;
      majorReferenceX => <-.XAxis.XTickLine_UI.major_step.value;
      axleColor => <-.XAxis.XAxle_UI.Axle_color.cmdList[<-.XAxis.XAxle_UI.Axle_color.selectedItem].label;
      axleWidth => <-.XAxis.XAxle_UI.Axle_width.value;
      labelColor => <-.XAxis.XLabel_UI.Label_color.cmdList[<-.XAxis.XLabel_UI.Label_color.selectedItem].label;
      textColor => <-.XAxis.XText_UI.Text_color.cmdList[<-.XAxis.XText_UI.Text_color.selectedItem].label;
      textHeight => <-.XAxis.XText_UI.Text_Height_slider.value;
      labelDecimals => <-.XAxis.XLabel_UI.Label_Decimals.value;
   };
   AGXTicklines AGXTicklines {
      visibility<NEportLevels={2,0}> => <-.XAxis.XTickLine_UI.Major_Tick_on_off.set;
      majorTickOn = 1;
      majorTickWidth => <-.XAxis.XTickLine_UI.Major_tick_width.value;
      majorTickLineStyle => <-.XAxis.XTickLine_UI.Major_tick_style.selectedItem;
      minorTickLineStyle => <-.XAxis.XTickLine_UI.Minor_tick_style.selectedItem;
      majorTickColor => <-.XAxis.XTickLine_UI.Major_tick_color.cmdList[<-.XAxis.XTickLine_UI.Major_tick_color.selectedItem].label;
      minorTickColor => <-.XAxis.XTickLine_UI.Minor_tick_color.cmdList[<-.XAxis.XTickLine_UI.Minor_tick_color.selectedItem].label;
      minorTickCount => <-.XAxis.XTickLine_UI.minor_step.value;
      minorTickWidth => <-.XAxis.XTickLine_UI.Minor_tick_width.value;
      majorReferenceX => <-.XAxis.XTickLine_UI.major_step.value;
      majorStepX => <-.XAxis.XTickLine_UI.major_step.value;
   };
   AGYAxis AGYAxis {
      majorTickOn = 1;
      text<NEportLevels={2,0}> => <-.YAxis.YText_UI.Axis_text.text;
      visibility => <-.YAxis.YAxle_UI.Axle_on_off.set;
      labelHeight => <-.YAxis.YLabel_UI.Label_Height_slider.value;
      positionX => <-.YAxis.YAxle_UI.Yposition.value;
      majorStepY => <-.YAxis.YTickLine_UI.major_step.value;
      labelMode => <-.YAxis.YText_UI.reverse_text_alignment.set;
      majorTickLineStyle => <-.YAxis.YTickLine_UI.Major_tick_style.selectedItem;
      majorTickWidth => <-.YAxis.YTickLine_UI.Major_tick_width.value;
      minorTickCount => <-.YAxis.YTickLine_UI.minor_step.value;
      minorTickLineStyle => <-.YAxis.YTickLine_UI.Minor_tick_style.selectedItem;
      minorTickWidth => <-.YAxis.YTickLine_UI.Minor_tick_width.value;
      majorReferenceY => <-.YAxis.YTickLine_UI.major_step.value;
      majorTickColor => <-.YAxis.YTickLine_UI.Major_tick_color.cmdList[<-.YAxis.YTickLine_UI.Major_tick_color.selectedItem].label;
      minorTickColor => <-.YAxis.YTickLine_UI.Minor_tick_color.cmdList[<-.YAxis.YTickLine_UI.Minor_tick_color.selectedItem].label;
      axleColor => <-.YAxis.YAxle_UI.Axle_color.cmdList[<-.YAxis.YAxle_UI.Axle_color.selectedItem].label;
      axleWidth => <-.YAxis.YAxle_UI.Axle_width.value;
      labelColor => <-.YAxis.YLabel_UI.Label_color.cmdList[<-.YAxis.YLabel_UI.Label_color.selectedItem].label;
      textColor => <-.YAxis.YText_UI.Text_color.cmdList[<-.YAxis.YText_UI.Text_color.selectedItem].label;
      textHeight => <-.YAxis.YText_UI.Text_Height_slider.value;
      labelDecimals => <-.YAxis.YLabel_UI.Label_Decimals.value;
   };
   AGYTicklines AGYTicklines {
      visibility<NEportLevels={2,0}> => <-.YAxis.YTickLine_UI.Major_Tick_on_off.set;
      majorTickOn = 1;
      majorTickWidth => <-.YAxis.YTickLine_UI.Major_tick_width.value;
      minorTickCount => <-.YAxis.YTickLine_UI.minor_step.value;
      minorTickWidth => <-.YAxis.YTickLine_UI.Minor_tick_width.value;
      majorReferenceY => <-.YAxis.YTickLine_UI.major_step.value;
      majorStepY => <-.YAxis.YTickLine_UI.major_step.value;
      majorTickColor => <-.YAxis.YTickLine_UI.Major_tick_color.cmdList[<-.YAxis.YTickLine_UI.Major_tick_color.selectedItem].label;
      majorTickLineStyle => <-.YAxis.YTickLine_UI.Major_tick_style.selectedItem;
      minorTickColor => <-.YAxis.YTickLine_UI.Minor_tick_color.cmdList[<-.YAxis.YTickLine_UI.Minor_tick_color.selectedItem].label;
      minorTickLineStyle => <-.YAxis.YTickLine_UI.Minor_tick_style.selectedItem;
   };
   UIoption color1[12] = {
      {
         set=1,,,,,,,,,label="antibackground",,,,,,,,,,,
      },
      {
         label="background",,,,,,,,,,,
      },
      {
         label="red",,,,,,,,,,,
      },
      {
         label="green",,,,,,,,,,,
      },
      {
         label="blue",,,,,,,,,,,
      },
      {
         label="yellow",,,,,,,,,,,
      },
      {
         label="magenta",,,,,,,,,,,
      },
      {
         label="cyan",,,,,,,,,,,
      },
      {
         label="black",,,,,,,,,,,
      },
      {
         label="white",,,,,,,,,,,
      },
      {
         label="grey",,,,,,,,,,,
      }
   };
   UIoption style1[15] = {
      {
         set=1,,,,,,,,,label="solid",,,,,,,,,,,
      },
      {
         label="dashed",,,,,,,,,,,
      },
      {
         label="dotted",,,,,,,,,,,
      },
      {
         label="dasheddotted",,,,,,,,,,,
      },
      {
         label="______________",,,,,,,,,,,
      },
      {
         label=". . . . . . .",,,,,,,,,,,
      },
      {
         label="_ _ _ _ _ _ _",,,,,,,,,,,
      },
      {
         label="__ __ __ __ __",,,,,,,,,,,
      },
      {
         label="__ . __ . __ .",,,,,,,,,,,
      },
      {
         label="_ __ _ __ _ __",,,,,,,,,,,
      },
      {
         label=".  .  .  .  .",,,,,,,,,,,
      },
      {
         label="___ ___ ___ __",,,,,,,,,,,
      },
      {
         label="_ _  _ _  _ _",,,,,,,,,,,
      },
      {
         label="__ .. __ .. __",,,,,,,,,,,
      },
      {
         label="__ ... __ ...",,,,,,,,,,,
      }
   };
   UIoption color2[12] = {
      {
         set=1,,,,,,,,,label="antibackground",,,,,,,,,,,
      },
      {
         label="background",,,,,,,,,,,
      },
      {
         label="red",,,,,,,,,,,
      },
      {
         label="green",,,,,,,,,,,
      },
      {
         label="blue",,,,,,,,,,,
      },
      {
         label="yellow",,,,,,,,,,,
      },
      {
         label="magenta",,,,,,,,,,,
      },
      {
         label="cyan",,,,,,,,,,,
      },
      {
         label="black",,,,,,,,,,,
      },
      {
         label="white",,,,,,,,,,,
      },
      {
         label="grey",,,,,,,,,,,
      }
   };
   UIoption color3[12] = {
      {
         set=1,,,,,,,,,label="antibackground",,,,,,,,,,,
      },
      {
         label="background",,,,,,,,,,,
      },
      {
         label="red",,,,,,,,,,,
      },
      {
         label="green",,,,,,,,,,,
      },
      {
         label="blue",,,,,,,,,,,
      },
      {
         label="yellow",,,,,,,,,,,
      },
      {
         label="magenta",,,,,,,,,,,
      },
      {
         label="cyan",,,,,,,,,,,
      },
      {
         label="black",,,,,,,,,,,
      },
      {
         label="white",,,,,,,,,,,
      },
      {
         label="grey",,,,,,,,,,,
      }
   };
   UIoption color4[12] = {
      {
         set=1,,,,,,,,,label="antibackground",,,,,,,,,,,
      },
      {
         label="background",,,,,,,,,,,
      },
      {
         label="red",,,,,,,,,,,
      },
      {
         label="green",,,,,,,,,,,
      },
      {
         label="blue",,,,,,,,,,,
      },
      {
         label="yellow",,,,,,,,,,,
      },
      {
         label="magenta",,,,,,,,,,,
      },
      {
         label="cyan",,,,,,,,,,,
      },
      {
         label="black",,,,,,,,,,,
      },
      {
         label="white",,,,,,,,,,,
      },
      {
         label="grey",,,,,,,,,,,
      }
   };
   UIoption color5[12] = {
      {
         set=1,,,,,,,,,label="antibackground",,,,,,,,,,,
      },
      {
         label="background",,,,,,,,,,,
      },
      {
         label="red",,,,,,,,,,,
      },
      {
         label="green",,,,,,,,,,,
      },
      {
         label="blue",,,,,,,,,,,
      },
      {
         label="yellow",,,,,,,,,,,
      },
      {
         label="magenta",,,,,,,,,,,
      },
      {
         label="cyan",,,,,,,,,,,
      },
      {
         label="black",,,,,,,,,,,
      },
      {
         label="white",,,,,,,,,,,
      },
      {
         label="grey",,,,,,,,,,,
      }
   };
   UIoption style2[15] = {
      {
         label="solid",,,,,,,,,,,
      },
      {
         set=1,,,,,,,,,label="dashed",,,,,,,,,,,
      },
      {
         label="dotted",,,,,,,,,,,
      },
      {
         label="dasheddotted",,,,,,,,,,,
      },
      {
         label="______________",,,,,,,,,,,
      },
      {
         label=". . . . . . .",,,,,,,,,,,
      },
      {
         label="_ _ _ _ _ _ _",,,,,,,,,,,
      },
      {
         label="__ __ __ __ __",,,,,,,,,,,
      },
      {
         label="__ . __ . __ .",,,,,,,,,,,
      },
      {
         label="_ __ _ __ _ __",,,,,,,,,,,
      },
      {
         label=".  .  .  .  .",,,,,,,,,,,
      },
      {
         label="___ ___ ___ __",,,,,,,,,,,
      },
      {
         label="_ _  _ _  _ _",,,,,,,,,,,
      },
      {
         label="__ .. __ .. __",,,,,,,,,,,
      },
      {
         label="__ ... __ ...",,,,,,,,,,,
      }
   };
   AGPrimitive &Graph_in<NEportLevels={2,0}>;
   group X_Axis_params<export_all=2> {
      int Axle_on_off<NEportLevels={2,2}> = 1;
      float Y_Axis_pos<NEportLevels={2,2}>;
      float Axle_width<NEportLevels={2,2}> = 1.;
      int Axle_color<NEportLevels={2,2}> = 0;
      int reverse_text<NEportLevels={2,2}> = 0;
      float text_height<NEportLevels={2,2}> = 5.;
      int Text_color<NEportLevels={2,2}> = 0;
      string X_Axis_text<NEportLevels={2,2}> = "X axis text";
      float label_height<NEportLevels={2,2}> = 5.;
      int Label_color<NEportLevels={2,2}> = 0;
      float label_Decimals<NEportLevels={2,2}> = 0.;
      int X_Tickline_on_off<NEportLevels={2,2}> = 1;
      float Steps_for_Major<NEportLevels={2,2}>;
      int Steps_for_Minor<NEportLevels={2,2}> = 2;
      float Major_tick_width<NEportLevels={2,2}> = 0.8;
      float Minor_tick_width<NEportLevels={2,2}> = 0.01;
      int Major_tick_style<NEportLevels={2,2}> = 0;
      int Major_tick_color<NEportLevels={2,2}> = 0;
      int Minor_tick_style<NEportLevels={2,2}> = 1;
      int Minor_tick_color<NEportLevels={2,2}> = 0;
   };
   group Y_Axis_params<export_all=2> {
      int Axle_on_off<NEportLevels={2,2}> = 1;
      float X_Axis_pos<NEportLevels={2,2}>;
      float Axle_width<NEportLevels={2,2}> = 1.;
      int Axle_color<NEportLevels={2,2}> = 0;
      int reverse_text<NEportLevels={2,2}> = 0;
      float text_height<NEportLevels={2,2}> = 5.;
      int Text_color<NEportLevels={2,2}> = 0;
      string Y_Axis_text<NEportLevels={2,2}> = "Y axis text";
      float label_height<NEportLevels={2,2}> = 5.;
      int Label_color<NEportLevels={2,2}> = 0;
      float label_Decimals<NEportLevels={2,2}> = 0.;
      int Y_Tickline_on_off<NEportLevels={2,2}> = 1;
      float Steps_for_Major<NEportLevels={2,2}>;
      int Steps_for_Minor<NEportLevels={2,2}> = 2;
      float Major_tick_width<NEportLevels={2,2}> = 0.8;
      float Minor_tick_width<NEportLevels={2,2}> = 0.01;
      int Major_tick_style<NEportLevels={2,2}> = 0;
      int Major_tick_color<NEportLevels={2,2}> = 0;
      int Minor_tick_style<NEportLevels={2,2}> = 1;
      int Minor_tick_color<NEportLevels={2,2}> = 0;
   };
}; // XYAXis

macro Graph {
   AGGraph AGGraph {
      visibility<NEportLevels={2,0}> => <-.GraphUI.UItoggle.set;
      graphType<NEportLevels={0,2}> => <-.GraphUI.graphtype.selectedItem;
      lineStyle<NEportLevels={0,2}> => <-.GraphUI.line_style.cmdList[<-.GraphUI.line_style.selectedItem].label;
      color => <-.GraphUI.line_color.cmdList[<-.GraphUI.line_color.selectedItem].label;
      legendText => <-.GraphUI.Graph_Name.text;
      valuesX<NEportLevels={3,0}>;
      valuesY<NEportLevels={3,0}> => ;
      priority => <-.GraphUI.priority_typein.value;
      barWidth => <-.GraphUI.Bar_width_typein.value;
      lineWidth => <-.GraphUI.Line_width_typein.value;
      scatterSymbols => <-.GraphUI.symbol.text;
      symbolHeight => <-.GraphUI.symbol_height_typein.value;
   };
   UImod_panel UIpanel {
      parent<NEportLevels={3,0}>;
      message = "Select Graph type";
      title => name_of(<-.<-);
      option {
         set = 1;
      };
   };
   macro GraphUI {
      link panel<NEportLevels={2,0}> => <-.UIpanel;
      UItoggle UItoggle {
         y = 0;
         width = 120;
         parent => <-.panel;
         label => "Graph On/Off";
         set => <-.<-.Graph_params.Graph_on_off;
      };
      UIlabel priority_label {
         parent => <-.panel;
         label => "Graph priority";
         y => (<-.UItoggle.y + <-.UItoggle.height) + 10;
      };
      UIfield priority_typein {
         parent => <-.panel;
         value<NEportLevels={2,2}> => <-.<-.Graph_params.priority;
         x => <-.priority_label.x + <-.priority_label.width;
         y => <-.priority_label.y;
         decimalPoints = 0;
         format = "mixed";
      };
      string type<NEportLevels={0,1}>[8] = {
         "bars","barlines","area","curve","line","scatter","staircase",
         "stairarea"
      };
      UIradioBoxLabel graphtype {
         parent => <-.panel;
         labels => <-.type;
         title  => "Graph type";
         selectedItem => <-.<-.Graph_params.graphtype;
         y => (<-.priority_label.y + <-.priority_typein.height) + 10;
      };
      UIlabel Bar_width_label {
         parent => <-.panel;
         label => "Bar width";
         y => (<-.graphtype.y + <-.graphtype.height) + 10;
         active => (<-.graphtype.selectedItem < 2);
      };
      UIfield Bar_width_typein {
         parent => <-.panel;
         value<NEportLevels={2,2}> => <-.<-.Graph_params.Bar_width;
         x => <-.Bar_width_label.x + <-.Bar_width_label.width;
         y => <-.Bar_width_label.y;
         active => (<-.graphtype.selectedItem < 2);
      };
      UIlabel Line_width_label {
         parent => <-.panel;
         label => "Line width";
         y => <-.Bar_width_label.y + <-.Bar_width_typein.height;
         active => ((<-.graphtype.selectedItem > 2) && (<-.graphtype.selectedItem < 5));
      };
      UIfield Line_width_typein {
         parent => <-.panel;
         value<NEportLevels={2,2}> => <-.<-.Graph_params.Line_width;
         x => <-.Line_width_label.x + <-.Line_width_label.width;
         y => <-.Line_width_label.y;
         active => ((<-.graphtype.selectedItem > 2) && (<-.graphtype.selectedItem < 5));
      };
      UIlabel symbol_label {
         parent => <-.panel;
         label => "Scatter symbol";
         y => <-.Line_width_label.y + <-.Line_width_typein.height;
         active => (<-.graphtype.selectedItem == 5);
      };
      UItext symbol {
         parent => <-.panel;
         text => <-.<-.Graph_params.Scatter_symbols;
         x => <-.symbol_label.x + <-.symbol_label.width;
         y => <-.symbol_label.y;
         active => (<-.graphtype.selectedItem == 5);
      };
      UIlabel symbol_typein_label {
         label => "Scatter size";
         y => <-.symbol_label.y + <-.symbol.height;
         active => (<-.graphtype.selectedItem == 5);
         parent => <-.panel;
      };
      UIfield symbol_height_typein {
         parent => <-.panel;
         value<NEportLevels={2,2}> => <-.<-.Graph_params.Scatter_size;
         x => <-.symbol_typein_label.x + <-.symbol_typein_label.width;
         y => <-.symbol_typein_label.y;
         active => (<-.graphtype.selectedItem == 5);
      };
      UIlabel graphname_label {
         parent => <-.panel;
         label => "Graph Name";
         x = 100;
         y => <-.Graph_Name.y;
      };
      UItext Graph_Name {
         parent => <-.panel;
         text => <-.<-.Graph_params.Graph_Name;
         y => (<-.symbol_typein_label.y + <-.symbol_typein_label.height) + 20;
      };
      UIoption style[15] = {
         {
            set=1,,,,,,,,,label="solid",,,,,,,,,,,
         },
         {
            label="dashed",,,,,,,,,,,
         },
         {
            label="dotted",,,,,,,,,,,
         },
         {
            label="dasheddotted",,,,,,,,,,,
         },
         {
            label="______________",,,,,,,,,,,
         },
         {
            label=". . . . . . .",,,,,,,,,,,
         },
         {
            label="_ _ _ _ _ _ _",,,,,,,,,,,
         },
         {
            label="__ __ __ __ __",,,,,,,,,,,
         },
         {
            label="__ . __ . __ .",,,,,,,,,,,
         },
         {
            label="_ __ _ __ _ __",,,,,,,,,,,
         },
         {
            label=".  .  .  .  .",,,,,,,,,,,
         },
         {
            label="___ ___ ___ __",,,,,,,,,,,
         },
         {
            label="_ _  _ _  _ _",,,,,,,,,,,
         },
         {
            label="__ .. __ .. __",,,,,,,,,,,
         },
         {
            label="__ ... __ ...",,,,,,,,,,,
         }
      };
      UIoptionMenu line_style {
         parent => <-.panel;
         cmdList => <-.style;
         y => (<-.Graph_Name.y + <-.Graph_Name.height) + 10;
         width => .UIradioBox.y + .UIradioBox.height;
         selectedItem => <-.<-.Graph_params.line_style;
         x = 0;
      };
      UIoption color[12] = {
         {
            label="antibackground",,,,,,,,,,,
         },
         {
            label="background",,,,,,,,,,,
         },
         {
            set=1,,,,,,,,,label="red",,,,,,,,,,,
         },
         {
            label="green",,,,,,,,,,,
         },
         {
            label="blue",,,,,,,,,,,
         },
         {
            label="yellow",,,,,,,,,,,
         },
         {
            label="magenta",,,,,,,,,,,
         },
         {
            label="cyan",,,,,,,,,,,
         },
         {
            label="black",,,,,,,,,,,
         },
         {
            label="white",,,,,,,,,,,
         },
         {
            label="grey",,,,,,,,,,,
         }
      };
      UIoptionMenu line_color {
         parent => <-.panel;
         cmdList => <-.color;
         y => <-.line_style.y + 40;
         width => .UIradioBox.y + .UIradioBox.height;
         selectedItem => <-.<-.Graph_params.line_color;
         x = 0;
      };
   };
   GMOD.instancer inst_GraphUI {
      Value => <-.UIpanel.visible;
      Group => <-.GraphUI;
   };
   group Graph_params<export_all=2> {
      int Graph_on_off<NEportLevels={2,2}> = 1;
      int priority<NEportLevels={2,2}> = 1;
      int graphtype<NEportLevels={2,2}> = 0;
      float Bar_width<NEportLevels={2,2}>;
      float Line_width<NEportLevels={2,2}>;
      string Scatter_symbols<NEportLevels={2,2}> = "+";
      float Scatter_size<NEportLevels={2,2}> = 10.;
      string Graph_Name<NEportLevels={2,2}> = "Graph";
      int line_style<NEportLevels={2,2}> = 0;
      int line_color<NEportLevels={2,2}> = 2;
   };
   link output<NEportLevels={1,2}> => AGGraph;
}; // Graph


macro GraphLegend {
   AGGraphLegend AGGraphLegend {
      visibility => <-.LegendUI.Position_UI.visible.set;
      geometry => {
         <-.LegendUI.Position_UI.position_x.value,
         <-.LegendUI.Position_UI.position_y.value};
      fillColor => <-.LegendUI.Frame_UI.FillColor.cmdList[<-.LegendUI.Frame_UI.FillColor.selectedItem].label;
      frameColor => <-.LegendUI.Frame_UI.FrameColor.cmdList[<-.LegendUI.Frame_UI.FrameColor.selectedItem].label;
      frameWidth => <-.LegendUI.Frame_UI.Frame_Width.value;
      labelHeight => <-.LegendUI.Label_UI.Label_Height.value;
      labelColor => <-.LegendUI.Label_UI.Label_Color.cmdList[<-.LegendUI.Label_UI.Label_Color.selectedItem].label;
      numColumns => <-.LegendUI.Label_UI.Number_of_Column.value;
      title => <-.LegendUI.Title_UI.Title.text;
      titleHeight => <-.LegendUI.Title_UI.Title_Height.value;
      titleColor => <-.LegendUI.Title_UI.Title_Color.cmdList[<-.LegendUI.Title_UI.Title_Color.selectedItem].label;
      graphs<NEportLevels={3,0}>;
   };
   UImod_panel panel {
      y = 0;
      parent<NEportLevels={3,0}>;
      title => name_of(<-.<-);
      option {
         set = 1;
      };
   };
   macro LegendUI {
      macro Frame_UI {
         UIframe UIframe_Frame {
            parent => <-.<-.<-.panel;
            x = 5;
            y => (<-.<-.Position_UI.UIframe_Position.y + <-.<-.Position_UI.UIframe_Position.height) + 10;
            width = 245;
            height => (<-.Frame_Width.y + <-.Frame_Width.height) + 10;
         };
         UIoptionMenu FillColor {
            parent => <-.UIframe_Frame;
            cmdList => <-.<-.color1;
            y = 0;
            selectedItem => <-.<-.<-.Legend_params.FillColor;
            x = 0;
         };
         UIoptionMenu FrameColor {
            parent => <-.UIframe_Frame;
            y => (<-.FillColor.y + <-.FillColor.height) + 10;
            cmdList => <-.<-.color2;
            selectedItem => <-.<-.<-.Legend_params.FrameColor;
            x = 0;
         };
         UIslider Frame_Width {
            parent => <-.UIframe_Frame;
            value<NEportLevels={2,2}> => <-.<-.<-.Legend_params.Frame_Width;
            y => (<-.FrameColor.y + <-.FrameColor.height) + 20;
            width = 150;
            min = 0.;
            max = 4.;
         };
         UIfield Frame_Width_Typein {
            parent => <-.UIframe_Frame;
            value<NEportLevels={2,2}> => <-.Frame_Width.value;
            x => <-.Frame_Width.width + 5;
            y => <-.Frame_Width.y;
            width = 50;
         };
      };
      macro Label_UI {
         UIframe UIframe_Label {
            parent => <-.<-.<-.panel;
            x = 5;
            y => (<-.<-.Frame_UI.UIframe_Frame.y + <-.<-.Frame_UI.UIframe_Frame.height) + 10;
            width = 245;
            height => (<-.Label_Color.y + <-.Label_Color.height) + 10;
         };
         UIslider Label_Height {
            parent => <-.UIframe_Label;
            value<NEportLevels={2,2}> => <-.<-.<-.Legend_params.Label_Height;
            y = 0;
            width = 150;
            min = 0.;
            max = 5.;
         };
         UIfield Label_Height_typein {
            parent => <-.UIframe_Label;
            value<NEportLevels={2,2}> => <-.Label_Height.value;
            x => <-.Label_Height.width + 5;
            y => <-.Label_Height.y;
            width = 50;
         };
         UIfield Number_of_Column {
            parent => <-.UIframe_Label;
            value<NEportLevels={2,2}> => <-.<-.<-.Legend_params.Number;
            y => (<-.Label_Height.y + <-.Label_Height.height) + 10;
            min = 1.;
            max = 5.;
            decimalPoints = 0;
         };
         UIlabel NColumun_label {
            parent => <-.UIframe_Label;
            label => "Number of Column";
            x = 120;
            y => <-.Number_of_Column.y;
            width = 110;
         };
         UIoptionMenu Label_Color {
            parent => <-.UIframe_Label;
            y => (<-.Number_of_Column.y + <-.Number_of_Column.height) + 10;
            cmdList => <-.<-.color3;
            selectedItem => <-.<-.<-.Legend_params.Label_Color;
            x = 0;
         };
      };
      macro Title_UI {
         UIframe UIframe_Title {
            parent => <-.<-.<-.panel;
            x = 5;
            y => (<-.<-.Label_UI.UIframe_Label.y + <-.<-.Label_UI.UIframe_Label.height) + 10;
            width = 245;
            height => (<-.Title_Color.y + <-.Title_Color.height) + 10;
         };
         UIslider Title_Height {
            parent => <-.UIframe_Title;
            value<NEportLevels={2,2}> => <-.<-.<-.Legend_params.Title_Height;
            y => (<-.Title.y + <-.Title.height) + 10;
            width = 150;
            min = 0.;
            max = 10.;
         };
         UIfield Title_Height_Typein {
            parent => <-.UIframe_Title;
            value<NEportLevels={2,2}> => <-.Title_Height.value;
            x => <-.Title_Height.width + 5;
            y => <-.Title_Height.y;
            width = 50;
         };
         UIoptionMenu Title_Color {
            parent => <-.UIframe_Title;
            y => (<-.Title_Height.y + <-.Title_Height.height) + 10;
            cmdList => <-.<-.color4;
            selectedItem => <-.<-.<-.Legend_params.Title_Color;
            x = 0;
         };
         UItext Title {
            parent => <-.UIframe_Title;
            text => <-.<-.<-.Legend_params.Title;
            y = 0;
         };
         UIlabel Title_label {
            parent => <-.UIframe_Title;
            label => "Title";
            x = 120;
            y => <-.Title.y;
         };
      };
      UIoption color1[12] = {
         {
            label="antibackground",,,,,,,,,,,
         },
         {
            set=1,,,,,,,,,label="background",,,,,,,,,,,
         },
         {
            label="red",,,,,,,,,,,
         },
         {
            label="green",,,,,,,,,,,
         },
         {
            label="blue",,,,,,,,,,,
         },
         {
            label="yellow",,,,,,,,,,,
         },
         {
            label="magenta",,,,,,,,,,,
         },
         {
            label="cyan",,,,,,,,,,,
         },
         {
            label="black",,,,,,,,,,,
         },
         {
            label="white",,,,,,,,,,,
         },
         {
            label="grey",,,,,,,,,,,
         }
      };
      UIoption color2[12] = {
         {
            set=1,,,,,,,,,label="antibackground",,,,,,,,,,,
         },
         {
            label="background",,,,,,,,,,,
         },
         {
            label="red",,,,,,,,,,,
         },
         {
            label="green",,,,,,,,,,,
         },
         {
            label="blue",,,,,,,,,,,
         },
         {
            label="yellow",,,,,,,,,,,
         },
         {
            label="magenta",,,,,,,,,,,
         },
         {
            label="cyan",,,,,,,,,,,
         },
         {
            label="black",,,,,,,,,,,
         },
         {
            label="white",,,,,,,,,,,
         },
         {
            label="grey",,,,,,,,,,,
         }
      };
      UIoption color3[12] = {
         {
            set=1,,,,,,,,,label="antibackground",,,,,,,,,,,
         },
         {
            label="background",,,,,,,,,,,
         },
         {
            label="red",,,,,,,,,,,
         },
         {
            label="green",,,,,,,,,,,
         },
         {
            label="blue",,,,,,,,,,,
         },
         {
            label="yellow",,,,,,,,,,,
         },
         {
            label="magenta",,,,,,,,,,,
         },
         {
            label="cyan",,,,,,,,,,,
         },
         {
            label="black",,,,,,,,,,,
         },
         {
            label="white",,,,,,,,,,,
         },
         {
            label="grey",,,,,,,,,,,
         }
      };
      UIoption color4[12] = {
         {
            set=1,,,,,,,,,label="antibackground",,,,,,,,,,,
         },
         {
            label="background",,,,,,,,,,,
         },
         {
            label="red",,,,,,,,,,,
         },
         {
            label="green",,,,,,,,,,,
         },
         {
            label="blue",,,,,,,,,,,
         },
         {
            label="yellow",,,,,,,,,,,
         },
         {
            label="magenta",,,,,,,,,,,
         },
         {
            label="cyan",,,,,,,,,,,
         },
         {
            label="black",,,,,,,,,,,
         },
         {
            label="white",,,,,,,,,,,
         },
         {
            label="grey",,,,,,,,,,,
         }
      };
      macro Position_UI {
         UIfield position_x {
            y => (<-.visible.y + <-.visible.height) + 5;
            parent => <-.UIframe_Position;
            value<NEportLevels={2,2}> => <-.<-.<-.Legend_params.Legend_X;
         };
         UIfield position_y {
            y => (<-.position_x.y + .height) + 10;
            parent => <-.UIframe_Position;
            value<NEportLevels={2,2}> => <-.<-.<-.Legend_params.Legend_Y;
         };
         UItoggle visible {
            y = 0;
            width = 120;
            parent => <-.UIframe_Position;
            label => "Legend on/off";
            set => <-.<-.<-.Legend_params.Legend_on_off;
         };
         UIframe UIframe_Position {
            parent => <-.<-.<-.panel;
            x = 5;
            y = 0;
            width = 245;
            height => (<-.position_y.y + <-.position_y.height) + 10;
         };
         UIlabel position_x_label {
            parent => <-.UIframe_Position;
            label => "Legend X position";
            x = 120;
            y => <-.position_x.y;
            width = 110;
         };
         UIlabel position_y_label {
            label => "Legend Y position";
            x = 120;
            y => <-.position_y.y;
            parent => <-.UIframe_Position;
            width = 110;
         };
      };
   };
   GMOD.instancer inst_LegendUI {
      Value => <-.panel.visible;
      Group => <-.LegendUI;
   };
   group Legend_params<export_all=2> {
      int Legend_on_off<NEportLevels={2,2}> = 1;
      float Legend_X<NEportLevels={2,2}> = 5.5;
      float Legend_Y<NEportLevels={2,2}> = -3.;
      int FillColor<NEportLevels={2,2}> = 1;
      int FrameColor<NEportLevels={2,2}> = 0;
      float Frame_Width<NEportLevels={2,2}> = 0.1;
      float Label_Height<NEportLevels={2,2}> = 2.;
      int Number<NEportLevels={2,2}> = 1;
      int Label_Color<NEportLevels={2,2}> = 0;
      string Title<NEportLevels={2,2}> = "Title";
      float Title_Height<NEportLevels={2,2}> = 4.;
      int Title_Color<NEportLevels={2,2}> = 0;
   };
   link obj<NEportLevels={1,2}> => AGGraphLegend;
}; // GraphLegend


macro GraphViewport {
   AGGraphViewportObj AGGraphViewportObj {
      graphViewport {
         visibility => <-.<-.GraphViewport_UI.Frame_visible.set;
         frameColor => <-.<-.GraphViewport_UI.FrameColor.cmdList[<-.<-.GraphViewport_UI.FrameColor.selectedItem].label;
         frameWidth => <-.<-.GraphViewport_UI.Frame_Width.value;
         children<NEportLevels={4,0}>;
         fillColor => <-.<-.GraphViewport_UI.FillColor.cmdList[<-.<-.GraphViewport_UI.FillColor.selectedItem].label;
      };
   };
   UImod_panel UImod_panel {
      parent<NEportLevels={3,0}>;
      title => name_of(<-.<-);
      option {
         set = 1;
      };
   };
   macro GraphViewport_UI {
      UItoggle Frame_visible {
         y = 0;
         width = 120;
         parent => <-.<-.UImod_panel;
         set => <-.<-.Viewport_params.Frame_visible;
      };
      UIslider Frame_Width {
         parent => <-.<-.UImod_panel;
         value<NEportLevels={2,2}> => <-.<-.Viewport_params.Frame_Width;
         y => (<-.Frame_visible.x + <-.Frame_visible.height) + 10;
         width = 150;
         min = 0.;
         max = 4.;
      };
      UIfield Frame_Width_Typein {
         parent => <-.<-.UImod_panel;
         value<NEportLevels={2,2}> => <-.Frame_Width.value;
         x => <-.Frame_Width.width + 5;
         y => <-.Frame_Width.y;
         width = 50;
      };
      UIoptionMenu FrameColor {
         parent => <-.<-.UImod_panel;
         y => (<-.Frame_Width.y + <-.Frame_Width.height) + 10;
         selectedItem => <-.<-.Viewport_params.Frame_Color;
         label => "Frame Color";
         cmdList => <-.color1;
         x = 0;
      };
      UIoptionMenu FillColor {
         parent => <-.<-.UImod_panel;
         y => <-.FrameColor.y + <-.FrameColor.height;
         selectedItem => <-.<-.Viewport_params.Fill_Color;
         label => "Fill Color";
         cmdList => <-.color2;
         x = 0;
      };
      UIoption color1[12] = {
         {
            set=1,,,,,,,,,label="antibackground",,,,,,,,,,,
         },
         {
            label="background",,,,,,,,,,,
         },
         {
            label="red",,,,,,,,,,,
         },
         {
            label="green",,,,,,,,,,,
         },
         {
            label="blue",,,,,,,,,,,
         },
         {
            label="yellow",,,,,,,,,,,
         },
         {
            label="magenta",,,,,,,,,,,
         },
         {
            label="cyan",,,,,,,,,,,
         },
         {
            label="black",,,,,,,,,,,
         },
         {
            label="white",,,,,,,,,,,
         },
         {
            label="grey",,,,,,,,,,,
         }
      };
      UIoption color2[12] = {
         {
            label="antibackground",,,,,,,,,,,
         },
         {
            set=1,,,,,,,,,label="background",,,,,,,,,,,
         },
         {
            label="red",,,,,,,,,,,
         },
         {
            label="green",,,,,,,,,,,
         },
         {
            label="blue",,,,,,,,,,,
         },
         {
            label="yellow",,,,,,,,,,,
         },
         {
            label="magenta",,,,,,,,,,,
         },
         {
            label="cyan",,,,,,,,,,,
         },
         {
            label="black",,,,,,,,,,,
         },
         {
            label="white",,,,,,,,,,,
         },
         {
            label="grey",,,,,,,,,,,
         }
      };
   };
   GMOD.instancer inst_GraphViewport_UI {
      Value => <-.UImod_panel.visible;
      Group => <-.GraphViewport_UI;
   };
   group Viewport_params<export_all=2> {
      int Frame_visible<NEportLevels={2,2}> = 1;
      float Frame_Width<NEportLevels={2,2}> = 0.01;
      int Frame_Color<NEportLevels={2,2}> = 0;
      int Fill_Color<NEportLevels={2,2}> = 1;
   };
   link obj<NEportLevels={1,2}> => AGGraphViewportObj.dataObject.obj;
};


macro GraphWorld {
   AGGraphWorld AGGraphWorld<NEwidth=242.,NEheight=286.> {
      clip => <-.GraphWorldUI.clip_toggle.set;
      limitsX => {
         <-.GraphWorldUI.X_min.value,<-.GraphWorldUI.X_max.value};
      limitsY => {
         <-.GraphWorldUI.Y_min.value,<-.GraphWorldUI.Y_max.value};
      children => <-.AGCombineGraphWorldInput.output;
      scaleTypeX => <-.GraphWorldUI.scale_type_X.selectedItem;
      scaleTypeY => <-.GraphWorldUI.scale_type_Y.selectedItem;
   };
   AGCombineGraphWorldInput AGCombineGraphWorldInput {
      input1<NEportLevels={3,0}>;
      input2<NEportLevels={3,0}>;
   };
   UImod_panel panel {
      title => name_of(<-.<-);
      option {
         set = 1;
      };
      parent<NEportLevels={3,0}>;
   };
   macro GraphWorldUI {
      UItoggle clip_toggle {
         y = 0;
         parent => <-.<-.panel;
         set => <-.<-.World_params.clip_toggle;
      };
      UIlabel X_min_label {
         //y => <-.Y_max.y + <-.Y_max.height;
         y => <-.clip_toggle.y + <-.clip_toggle.height + 4;
         parent => <-.<-.panel;
         label => "X region min";
         alignment = "left";
         width = 80;
      };
      UIfield X_min {
         x => <-.X_min_label.x;
         y => <-.X_min_label.y + <-.X_min_label.height;
         width = 50;
         parent => <-.<-.panel;
         value<NEportLevels={2,2}> => <-.<-.World_params.X_min;
      };
      UIlabel X_max_label {
         y => <-.X_min.y + <-.X_min.height + 4;
         parent => <-.<-.panel;
         label => "X region max";
         alignment = "left";
         width = 80;
      };
      UIfield X_max {
         y => <-.X_max_label.y + <-.X_max_label.height;
         parent => <-.<-.panel;
         value<NEportLevels={2,2}> => <-.<-.World_params.X_max;
         width = 50;
      };
      UIlabel Y_min_label {
         //y => <-.clip_toggle.y + <-.clip_toggle.height;
         y => <-.X_max.y + <-.X_max.height + 4;
         parent => <-.<-.panel;
         label => "Y region min";
         alignment = "left";
         width = 80;
      };
      UIfield Y_min {
         y => <-.Y_min_label.y + <-.Y_min_label.height;
         parent => <-.<-.panel;
         value<NEportLevels={2,2}> => <-.<-.World_params.Y_min;
         width = 50;
      };
      UIlabel Y_max_label {
         y => <-.Y_min.y + <-.Y_min.height + 4;
         parent => <-.<-.panel;
         label => "Y region max";
         alignment = "left";
         width = 80;
      };
      UIfield Y_max {
         y => <-.Y_max_label.y + <-.Y_max_label.height;
         parent => <-.<-.panel;
         value<NEportLevels={2,2}> => <-.<-.World_params.Y_max;
         width = 50;
      };
      UIradioBoxLabel scale_type_X {
         parent => <-.<-.panel;
         labels => <-.type;
         selectedItem => <-.<-.World_params.scale_type_X;
         //y => (<-.X_max.y + <-.X_max.height) + 5;
         y => (<-.Y_max.y + <-.Y_max.height) + 8;
      };
      UIradioBoxLabel scale_type_Y {
         parent => <-.<-.panel;
         labels => <-.type;
         selectedItem => <-.<-.World_params.scale_type_Y;
         //y => <-.scale_type_X.y + <-.scale_type_X.height;
         y => <-.scale_type_X.y + <-.scale_type_X.height + 4;
      };
      string type<NEportLevels=1>[] = {"linear","log10","power"};
   };
   GMOD.instancer instancer {
      Value => <-.panel.visible;
      Group => <-.GraphWorldUI;
   };
   group World_params<export_all=2> {
      int clip_toggle<NEportLevels={2,2}> = 0;
      float Y_min<NEportLevels={2,2}> = 0.;
      float Y_max<NEportLevels={2,2}> = 0.;
      float X_min<NEportLevels={2,2}> = 0.;
      float X_max<NEportLevels={2,2}> = 0.;
      int scale_type_X<NEportLevels={2,2}> = 0;
      int scale_type_Y<NEportLevels={2,2}> = 0;
   };
   link out<NEportLevels={1,2}> => AGGraphWorld;
}; // GraphViewport


macro PolarGraph {
   AGPolarGraph AGPolarGraph {
      visibility<NEportLevels={2,0}> => <-.GraphUI.UItoggle.set;
      graphType<NEportLevels={0,2}> => <-.GraphUI.graphtype.selectedItem + 4;
      lineStyle<NEportLevels={0,2}> => <-.GraphUI.line_style.cmdList[<-.GraphUI.line_style.selectedItem].label;
      color => <-.GraphUI.line_color.cmdList[<-.GraphUI.line_color.selectedItem].label;
      legendText => <-.GraphUI.Graph_Name.text;
      valuesR<NEportLevels={3,0}> => ;
      valuesT<NEportLevels={3,0}>;
      priority => GraphUI.priority_typein.value;
      lineWidth => <-.GraphUI.Line_width_typein.value;
      scatterSymbols => <-.GraphUI.symbol.text;
      symbolHeight => <-.GraphUI.symbol_height_typein.value;
   };
   UImod_panel UIpanel {
      parent<NEportLevels={3,0}>;
      message = "Select Graph type";
      title => name_of(<-.<-);
      option {
         set = 1;
      };
   };
   macro GraphUI {
      link panel<NEportLevels={2,1}> => <-.UIpanel;
      UItoggle UItoggle {
         y = 0;
         width = 120;
         parent => <-.panel;
         label => "Graph On/Off";
         set => <-.<-.Graph_params.Graph_on_off;
      };
      UIlabel priority_label {
         parent => <-.panel;
         label => "Graph priority";
         y => (<-.UItoggle.y + <-.UItoggle.height + 10);
      };
      UIfield priority_typein {
         parent => <-.panel;
         value<NEportLevels={2,2}> => <-.<-.Graph_params.priority;
         x => <-.priority_label.x + <-.priority_label.width;
         y => <-.priority_label.y;
         decimalPoints = 0;
         format = "mixed";
      };
      string type<NEportLevels={0,1}>[2] = {"curve","scatter"};
      UIradioBoxLabel graphtype {
         parent => <-.panel;
         labels => <-.type;
         title  => "Graph type";
         selectedItem => <-.<-.Graph_params.graphtype;
         y => (<-.priority_typein.y + <-.priority_typein.height) + 10;
      };
      UIlabel Line_width_label {
         parent => <-.panel;
         label => "Line width";
         y => (<-.graphtype.y + <-.graphtype.height + 10);
         active => (<-.graphtype.selectedItem == 0);
      };
      UIfield Line_width_typein {
         parent => <-.panel;
         value<NEportLevels={2,2}> => <-.<-.Graph_params.Line_width;
         x => <-.Line_width_label.x + <-.Line_width_label.width;
         y => <-.Line_width_label.y;
         active => (<-.graphtype.selectedItem == 0);
      };
      UIlabel symbol_label {
         parent => <-.panel;
         label => "Scatter symbol";
         y => <-.Line_width_label.y + <-.Line_width_typein.height;
         active => (<-.graphtype.selectedItem == 1);
      };
      UItext symbol {
         parent => <-.panel;
         text => <-.<-.Graph_params.Scatter_symbols;
         x => <-.symbol_label.x + <-.symbol_label.width;
         y => <-.symbol_label.y;
         active => (<-.graphtype.selectedItem == 1);
      };
      UIlabel symbol_typein_label {
         label => "Scatter size";
         y => <-.symbol_label.y + <-.symbol.height;
         active => (<-.graphtype.selectedItem == 1);
         parent => <-.panel;
      };
      UIfield symbol_height_typein {
         parent => <-.panel;
         value<NEportLevels={2,2}> => <-.<-.Graph_params.Scatter_size;
         x => <-.symbol_typein_label.x + <-.symbol_typein_label.width;
         y => <-.symbol_typein_label.y;
         active => (<-.graphtype.selectedItem == 1);
      };
      UIlabel graphname_label {
         parent => <-.panel;
         label => "Graph Name";
         y => <-.Graph_Name.y;
      };
      UItext Graph_Name {
         parent => <-.panel;
         text => <-.<-.Graph_params.Graph_Name;
         y => (<-.symbol_height_typein.y + <-.symbol_height_typein.height) + 20;
         x => <-.graphname_label.x + <-.graphname_label.width;
      };
      UIoption style[15] = {
         {
            set=1,,,,,,,,,label="solid",,,,,,,,,,,
         },
         {
            label="dashed",,,,,,,,,,,
         },
         {
            label="dotted",,,,,,,,,,,
         },
         {
            label="dasheddotted",,,,,,,,,,,
         },
         {
            label="______________",,,,,,,,,,,
         },
         {
            label=". . . . . . .",,,,,,,,,,,
         },
         {
            label="_ _ _ _ _ _ _",,,,,,,,,,,
         },
         {
            label="__ __ __ __ __",,,,,,,,,,,
         },
         {
            label="__ . __ . __ .",,,,,,,,,,,
         },
         {
            label="_ __ _ __ _ __",,,,,,,,,,,
         },
         {
            label=".  .  .  .  .",,,,,,,,,,,
         },
         {
            label="___ ___ ___ __",,,,,,,,,,,
         },
         {
            label="_ _  _ _  _ _",,,,,,,,,,,
         },
         {
            label="__ .. __ .. __",,,,,,,,,,,
         },
         {
            label="__ ... __ ...",,,,,,,,,,,
         }
      };
      UIoptionMenu line_style {
         parent => <-.panel;
         cmdList => <-.style;
         y => (<-.Graph_Name.y + <-.Graph_Name.height) + 10;
         width => .UIradioBox.y + .UIradioBox.height;
         selectedItem => <-.<-.Graph_params.line_style;
         x = 0;
      };
      UIoption color[12] = {
         {
            label="antibackground",,,,,,,,,,,
         },
         {
            label="background",,,,,,,,,,,
         },
         {
            set=1,,,,,,,,,label="red",,,,,,,,,,,
         },
         {
            label="green",,,,,,,,,,,
         },
         {
            label="blue",,,,,,,,,,,
         },
         {
            label="yellow",,,,,,,,,,,
         },
         {
            label="magenta",,,,,,,,,,,
         },
         {
            label="cyan",,,,,,,,,,,
         },
         {
            label="black",,,,,,,,,,,
         },
         {
            label="white",,,,,,,,,,,
         },
         {
            label="grey",,,,,,,,,,,
         }
      };
      UIoptionMenu line_color {
         parent => <-.panel;
         cmdList => <-.color;
         y => <-.line_style.y + 40;
         width => .UIradioBox.y + .UIradioBox.height;
         selectedItem => <-.<-.Graph_params.line_color;
         x = 0;
      };
   };
   GMOD.instancer instancer {
      Value => <-.UIpanel.visible;
      Group => <-.GraphUI;
   };
   group Graph_params<export_all=2> {
      int Graph_on_off<NEportLevels={2,2}> = 1;
      int priority<NEportLevels={2,2}> = 1;
      int graphtype<NEportLevels={2,2}> = 0;
      float Line_width<NEportLevels={2,2}>;
      string Scatter_symbols<NEportLevels={2,2}> = "+";
      float Scatter_size<NEportLevels={2,2}> = 10.;
      string Graph_Name<NEportLevels={2,2}> = "Graph";
      int line_style<NEportLevels={2,2}> = 0;
      int line_color<NEportLevels={2,2}> = 2;
   };
   link output<NEportLevels={1,2}> => AGPolarGraph;
}; // PolarGraph

macro PolarAxis {
   macro RAxis {
      macro RAxle_UI {
         UItoggle Axle_on_off {
            parent => <-.UIframe_Axle;
            y = 0;
            set => <-.<-.<-.R_Axis_params.Axle_on_off;
            label => "Axle on/off";
         };
         UIfield Tposition {
            parent => <-.UIframe_Axle;
            value<NEportLevels={2,2}> => <-.<-.<-.R_Axis_params.T_Axis_pos;
            y => (<-.Axle_on_off.y + <-.Axle_on_off.height) + 10;
         };
         UIlabel Tposition_label {
            parent => <-.UIframe_Axle;
            label => "T Axis \ncrossing position";
            x => <-.<-.RText_UI.Axis_text.width + 10;
            y => <-.Tposition.y;
            height => UIdata.UIfonts[0].lineHeight + 20;
         };
         UIfield Axle_width_typein {
            parent => <-.UIframe_Axle;
            value<NEportLevels={2,2}> => <-.Axle_width.value;
            x => <-.Axle_width.width + 5;
            y => <-.Axle_width.y;
            width = 40;
         };
         UIslider Axle_width {
            parent => <-.UIframe_Axle;
            value<NEportLevels={2,2}> => <-.<-.<-.R_Axis_params.Axle_width;
            title => "Axle width";
            y => (<-.Tposition.y + <-.Tposition.height) + 10;
            min = 0.01;
            max = 20.;
         };
         UIoptionMenu Axle_color {
            parent => <-.UIframe_Axle;
            cmdList => <-.<-.<-.color1;
            y => (<-.Axle_width.y + <-.Axle_width.height) + 10;
            width => .UIradioBox.y + .UIradioBox.height;
            height = 20;
            selectedItem => <-.<-.<-.R_Axis_params.Axle_color;
            x = 0;
         };
         UIframe UIframe_Axle {
            parent => <-.<-.<-.panel;
            x = 5;
            y => <-.<-.<-.panelY;
            width = 245;
            height => (<-.Axle_color.y + <-.Axle_color.height) + 20;
         };
      };
      macro RText_UI {
         UItext Axis_text {
            y => (<-.Text_color.y + <-.Text_color.height) + 10;
            parent => <-.UIframe_Text;
            text => <-.<-.<-.R_Axis_params.R_Axis_text;
         };
         UIlabel Axis_text_label {
            parent => <-.UIframe_Text;
            label => "R Axis Text";
            x => <-.Axis_text.width + 10;
            y => <-.Axis_text.y;
         };
         UIslider Text_Height_slider {
            parent => <-.UIframe_Text;
            value<NEportLevels={2,2}> => <-.<-.<-.R_Axis_params.text_height;
            title => "Text height";
            y => (<-.reverse_text_alignment.y + <-.reverse_text_alignment.height) + 10;
            min = 0.;
            max = 10.;
         };
         UIfield Text_Height_typein {
            parent => <-.UIframe_Text;
            value<NEportLevels={2,2}> => <-.Text_Height_slider.value;
            x => <-.Text_Height_slider.width + 5;
            y => <-.Text_Height_slider.y;
            width = 40;
         };
         UItoggle reverse_text_alignment {
            parent => <-.UIframe_Text;
            y = 0;
            width => <-.UIframe_Text.width - 5;
            set => <-.<-.<-.R_Axis_params.reverse_text;
         };
         UIframe UIframe_Text {
            parent => <-.<-.<-.panel;
            x => <-.<-.RAxle_UI.UIframe_Axle.x;
            y => (<-.<-.RAxle_UI.UIframe_Axle.y + <-.<-.RAxle_UI.UIframe_Axle.height) + 10;
            width => <-.<-.RAxle_UI.UIframe_Axle.width;
            height => (<-.Axis_text.y + <-.Axis_text.height) + 20;
         };
         UIoptionMenu Text_color {
            parent => <-.UIframe_Text;
            cmdList => <-.<-.<-.color2;
            y => (<-.Text_Height_slider.y + <-.Text_Height_slider.height) + 10;
            width => .UIradioBox.y + .UIradioBox.height;
            height = 20;
            selectedItem => <-.<-.<-.R_Axis_params.Text_color;
            x = 0;
         };
      };
      macro RLabel_UI {
         UIoptionMenu Label_color {
            parent => <-.UIframe_Label;
            cmdList => <-.<-.<-.color3;
            y => (<-.Label_Height_slider.y + <-.Label_Height_slider.height) + 10;
            width => .UIradioBox.y + .UIradioBox.height;
            height = 20;
            selectedItem => <-.<-.<-.R_Axis_params.Label_color;
            x = 0;
         };
         UIframe UIframe_Label {
            parent => <-.<-.<-.panel;
            x => <-.<-.RAxle_UI.UIframe_Axle.x;
            y => (<-.<-.RText_UI.UIframe_Text.y + <-.<-.RText_UI.UIframe_Text.height) + 10;
            width => <-.<-.RAxle_UI.UIframe_Axle.width;
            height => (<-.Label_Decimals.y + <-.Label_Decimals.height) + 20;
         };
         UIslider Label_Height_slider {
            parent => <-.UIframe_Label;
            value<NEportLevels={2,2}> => <-.<-.<-.R_Axis_params.label_height;
            title => "Label height";
            y = 0;
            min = 0.;
            max = 10.;
         };
         UIfield Label_Height_typein {
            parent => <-.UIframe_Label;
            value<NEportLevels={2,2}> => <-.Label_Height_slider.value;
            x => <-.Label_Height_slider.width + 5;
            y => <-.Label_Height_slider.y;
            width = 40;
         };
         UIslider Label_Decimals {
            parent => <-.UIframe_Label;
            value<NEportLevels={2,2}> => <-.<-.<-.R_Axis_params.label_Decimals;
            title => "Label Decimals";
            y => (<-.Label_color.y + <-.Label_color.height) + 10;
            min = 0.;
            max = 10.;
            decimalPoints = 0;
         };
      };
      macro RTickLine_UI {
         UItoggle Major_Tick_on_off {
            y = 0;
            width = 120;
            label => "R Tickline on/off";
            set => <-.<-.<-.R_Axis_params.R_Tickline_on_off;
            parent => <-.UIframe_MajorTick;
         };
         UIframe UIframe_MajorTick {
            parent => <-.<-.<-.panel;
            x => <-.<-.RAxle_UI.UIframe_Axle.x;
            y => (<-.<-.RLabel_UI.UIframe_Label.y + <-.<-.RLabel_UI.UIframe_Label.height) + 10;
            width => <-.<-.RAxle_UI.UIframe_Axle.width;
            height => (<-.Minor_tick_color.y + <-.Minor_tick_color.height) + 10;
         };
         UIfield major_step {
            parent => <-.UIframe_MajorTick;
            value<NEportLevels={2,2}> => <-.<-.<-.R_Axis_params.Steps_for_Major;
            y => (<-.Major_Tick_on_off.y + <-.Major_Tick_on_off.height) + 10;
         };
         UIlabel major_step_label {
            parent => <-.UIframe_MajorTick;
            height => (UIdata.UIfonts[0].lineHeight + 0) * 2;
            label => "Steps for \nMajor tick marks";
            x => (<-.major_step.x + <-.major_step.width) + 20;
            y => <-.major_step.y;
         };
         UIfield minor_step {
            parent => <-.UIframe_MajorTick;
            value<NEportLevels={2,2}> => <-.<-.<-.R_Axis_params.Steps_for_Minor;
            y => (<-.major_step.y + <-.major_step.height) + 10;
            decimalPoints = 0;
         };
         UIlabel minor_step_label {
            parent => <-.UIframe_MajorTick;
            height => (UIdata.UIfonts[0].lineHeight + 0) * 2;
            label => "Steps for \nMinor tick marks";
            x => (<-.minor_step.x + <-.minor_step.width) + 20;
            y => <-.minor_step.y;
         };
         UIslider Major_tick_width {
            parent => <-.UIframe_MajorTick;
            value<NEportLevels={2,2}> => <-.<-.<-.R_Axis_params.Major_tick_width;
            y => (<-.minor_step.y + <-.minor_step.height) + 10;
            min = 0.01;
            max = 20.;
         };
         UIfield Major_tick_typein {
            parent => <-.UIframe_MajorTick;
            value<NEportLevels={2,2}> => <-.Major_tick_width.value;
            x => <-.Major_tick_width.width + 5;
            y => <-.Major_tick_width.y;
            width = 40;
         };
         UIslider Minor_tick_width {
            parent => <-.UIframe_MajorTick;
            y => (<-.Major_tick_width.y + <-.Major_tick_width.height) + 10;
            value<NEportLevels={2,2}> => <-.<-.<-.R_Axis_params.Minor_tick_width;
            min = 0.01;
            max = 20.;
         };
         UIfield Minor_tick_typein {
            parent => <-.UIframe_MajorTick;
            value<NEportLevels={2,2}> => <-.Minor_tick_width.value;
            x => <-.Minor_tick_width.width + 5;
            y => <-.Minor_tick_width.y;
            width = 40;
         };
         UIoptionMenu Major_tick_style {
            parent => <-.UIframe_MajorTick;
            cmdList => <-.<-.<-.style1;
            selectedItem => <-.<-.<-.R_Axis_params.Major_tick_style;
            y => (<-.Minor_tick_width.y + <-.Minor_tick_width.height) + 20;
            x = 0;
         };
         UIoptionMenu Minor_tick_style {
            parent => <-.UIframe_MajorTick;
            cmdList => <-.<-.<-.style2;
            selectedItem => <-.<-.<-.R_Axis_params.Minor_tick_style;
            y => <-.Major_tick_color.y + <-.Major_tick_color.height;
            x = 0;
         };
         UIoptionMenu Major_tick_color {
            parent => <-.UIframe_MajorTick;
            cmdList => <-.<-.<-.color4;
            selectedItem => <-.<-.<-.R_Axis_params.Major_tick_color;
            y => <-.Major_tick_style.y + <-.Major_tick_style.height;
            x = 0;
         };
         UIoptionMenu Minor_tick_color {
            parent => <-.UIframe_MajorTick;
            cmdList => <-.<-.<-.color5;
            selectedItem => <-.<-.<-.R_Axis_params.Minor_tick_color;
            y => <-.Minor_tick_style.y + <-.Minor_tick_style.height;
            x = 0;
         };
      };
   };
   macro TAxis<instanced=0> {
      macro TAxle_UI {
         UItoggle Axle_on_off {
            parent => <-.UIframe_Axle;
            y = 0;
            set => <-.<-.<-.T_Axis_params.Axle_on_off;
            label => "Axle on/off";
         };
         UIfield Rposition {
            parent => <-.UIframe_Axle;
            value<NEportLevels={2,2}> => <-.<-.<-.T_Axis_params.R_Axis_pos;
            y => (<-.Axle_on_off.y + <-.Axle_on_off.height) + 10;
         };
         UIlabel Rposition_label {
            parent => <-.UIframe_Axle;
            label => "R Axis \ncrossing position";
            x => <-.<-.TText_UI.Axis_text.width + 10;
            y => <-.Rposition.y;
            height => (UIdata.UIfonts[0].lineHeight + 20);
         };
         UIfield Axle_width_typein {
            parent => <-.UIframe_Axle;
            value<NEportLevels={2,2}> => <-.Axle_width.value;
            x => <-.Axle_width.width + 5;
            y => <-.Axle_width.y;
            width = 40;
         };
         UIslider Axle_width {
            parent => <-.UIframe_Axle;
            value<NEportLevels={2,2}> => <-.<-.<-.T_Axis_params.Axle_width;
            title => "Axle width";
            y => (<-.Rposition.y + <-.Rposition.height) + 10;
            min = 0.01;
            max = 20.;
         };
         UIoptionMenu Axle_color {
            parent => <-.UIframe_Axle;
            cmdList => <-.<-.<-.color1;
            y => (<-.Axle_width.y + <-.Axle_width.height) + 10;
            width => .UIradioBox.y + .UIradioBox.height;
            height = 20;
            selectedItem => <-.<-.<-.T_Axis_params.Axle_color;
            x = 0;
         };
         UIframe UIframe_Axle {
            parent => <-.<-.<-.panel;
            x = 5;
            y => <-.<-.<-.panelY;
            width = 245;
            height => (<-.Axle_color.y + <-.Axle_color.height) + 20;
         };
      };
      macro TText_UI {
         UItext Axis_text {
            y => (<-.Text_color.y + <-.Text_color.height) + 10;
            parent => <-.UIframe_Text;
            text => <-.<-.<-.T_Axis_params.T_Axis_text;
         };
         UIlabel Axis_text_label {
            parent => <-.UIframe_Text;
            label => "T Axis Text";
            x => <-.Axis_text.width + 10;
            y => <-.Axis_text.y;
         };
         UIslider Text_Height_slider {
            parent => <-.UIframe_Text;
            value<NEportLevels={2,2}> => <-.<-.<-.T_Axis_params.text_height;
            title => "Text height";
            y => (<-.reverse_text_alignment.y + <-.reverse_text_alignment.height) + 10;
            min = 0.;
            max = 10.;
         };
         UIfield Text_Height_typein {
            parent => <-.UIframe_Text;
            value<NEportLevels={2,2}> => <-.Text_Height_slider.value;
            x => <-.Text_Height_slider.width + 5;
            y => <-.Text_Height_slider.y;
            width = 40;
         };
         UItoggle reverse_text_alignment {
            parent => <-.UIframe_Text;
            y = 0;
            width = 130;
            set => <-.<-.<-.T_Axis_params.reverse_text;
         };
         UIframe UIframe_Text {
            parent => <-.<-.<-.panel;
            x => <-.<-.TAxle_UI.UIframe_Axle.x;
            y => (<-.<-.TAxle_UI.UIframe_Axle.y + <-.<-.TAxle_UI.UIframe_Axle.height) + 10;
            width => <-.<-.TAxle_UI.UIframe_Axle.width;
            height => (<-.Axis_text.y + <-.Axis_text.height) + 20;
         };
         UIoptionMenu Text_color {
            parent => <-.UIframe_Text;
            cmdList => <-.<-.<-.color2;
            y => (<-.Text_Height_slider.y + <-.Text_Height_slider.height) + 10;
            width => .UIradioBox.y + .UIradioBox.height;
            height = 20;
            selectedItem => <-.<-.<-.T_Axis_params.Text_color;
            x = 0;
         };
      };
      macro TLabel_UI {
         UIoptionMenu Label_color {
            parent => <-.UIframe_Label;
            cmdList => <-.<-.<-.color3;
            y => (<-.Label_Height_slider.y + <-.Label_Height_slider.height) + 10;
            width => .UIradioBox.y + .UIradioBox.height;
            height = 20;
            selectedItem => <-.<-.<-.T_Axis_params.Label_color;
            x = 0;
         };
         UIframe UIframe_Label {
            parent => <-.<-.<-.panel;
            x => <-.<-.TAxle_UI.UIframe_Axle.x;
            y => (<-.<-.TText_UI.UIframe_Text.y + <-.<-.TText_UI.UIframe_Text.height) + 10;
            width => <-.<-.TAxle_UI.UIframe_Axle.width;
            height => (<-.Label_Decimals.y + <-.Label_Decimals.height) + 20;
         };
         UIslider Label_Height_slider {
            parent => <-.UIframe_Label;
            value<NEportLevels={2,2}> => <-.<-.<-.T_Axis_params.label_height;
            title => "Label height";
            y = 0;
            min = 0.;
            max = 10.;
         };
         UIfield Label_Height_typein {
            parent => <-.UIframe_Label;
            value<NEportLevels={2,2}> => <-.Label_Height_slider.value;
            x => <-.Label_Height_slider.width + 5;
            y => <-.Label_Height_slider.y;
            width = 40;
         };
         UIslider Label_Decimals {
            parent => <-.UIframe_Label;
            value<NEportLevels={2,2}> => <-.<-.<-.T_Axis_params.label_Decimals;
            title => "Label Decimals";
            y => (<-.Label_color.y + <-.Label_color.height) + 10;
            min = 0.;
            max = 10.;
            decimalPoints = 0;
         };
      };
      macro TTickLine_UI {
         UItoggle Major_Tick_on_off {
            y = 0;
            width = 120;
            label => "T Tickline on/off";
            set => <-.<-.<-.T_Axis_params.T_Tickline_on_off;
            parent => <-.UIframe_MajorTick;
         };
         UIframe UIframe_MajorTick {
            parent => <-.<-.<-.panel;
            x => <-.<-.TAxle_UI.UIframe_Axle.x;
            y => (<-.<-.TLabel_UI.UIframe_Label.y + <-.<-.TLabel_UI.UIframe_Label.height) + 10;
            width => <-.<-.TAxle_UI.UIframe_Axle.width;
            height => (<-.Minor_tick_color.y + <-.Minor_tick_color.height) + 10;
         };
         UIfield major_step {
            parent => <-.UIframe_MajorTick;
            value<NEportLevels={2,2}> => <-.<-.<-.T_Axis_params.Steps_for_Major;
            y => (<-.Major_Tick_on_off.y + <-.Major_Tick_on_off.height) + 10;
         };
         UIlabel major_step_label {
            parent => <-.UIframe_MajorTick;
            height => (UIdata.UIfonts[0].lineHeight + 0) * 2;
            label => "Steps for \nMajor tick marks";
            x => (<-.major_step.x + <-.major_step.width) + 20;
            y => <-.major_step.y;
         };
         UIfield minor_step {
            parent => <-.UIframe_MajorTick;
            value<NEportLevels={2,2}> => <-.<-.<-.T_Axis_params.Steps_for_Minor;
            y => (<-.major_step.y + <-.major_step.height) + 10;
            decimalPoints = 0;
         };
         UIlabel minor_step_label {
            parent => <-.UIframe_MajorTick;
            height => (UIdata.UIfonts[0].lineHeight + 0) * 2;
            label => "Steps for \nMinor tick marks";
            x => (<-.minor_step.x + <-.minor_step.width) + 20;
            y => <-.minor_step.y;
         };
         UIslider Major_tick_width {
            parent => <-.UIframe_MajorTick;
            value<NEportLevels={2,2}> => <-.<-.<-.T_Axis_params.Major_tick_width;
            y => (<-.minor_step.y + <-.minor_step.height) + 10;
            min = 0.01;
            max = 20.;
         };
         UIfield Major_tick_typein {
            parent => <-.UIframe_MajorTick;
            value<NEportLevels={2,2}> => <-.Major_tick_width.value;
            x => <-.Major_tick_width.width + 5;
            y => <-.Major_tick_width.y;
            width = 40;
         };
         UIslider Minor_tick_width {
            parent => <-.UIframe_MajorTick;
            y => (<-.Major_tick_width.y + <-.Major_tick_width.height) + 10;
            value<NEportLevels={2,2}> => <-.<-.<-.T_Axis_params.Minor_tick_width;
            min = 0.01;
            max = 20.;
         };
         UIfield Minor_tick_typein {
            parent => <-.UIframe_MajorTick;
            value<NEportLevels={2,2}> => <-.Minor_tick_width.value;
            x => <-.Minor_tick_width.width + 5;
            y => <-.Minor_tick_width.y;
            width = 40;
         };
         UIoptionMenu Major_tick_style {
            parent => <-.UIframe_MajorTick;
            cmdList => <-.<-.<-.style1;
            selectedItem => <-.<-.<-.T_Axis_params.Major_tick_style;
            y => (<-.Minor_tick_width.y + <-.Minor_tick_width.height) + 20;
            x = 0;
         };
         UIoptionMenu Minor_tick_style {
            parent => <-.UIframe_MajorTick;
            cmdList => <-.<-.<-.style2;
            selectedItem => <-.<-.<-.T_Axis_params.Minor_tick_style;
            y => <-.Major_tick_color.y + <-.Major_tick_color.height;
            x = 0;
         };
         UIoptionMenu Major_tick_color {
            parent => <-.UIframe_MajorTick;
            cmdList => <-.<-.<-.color4;
            selectedItem => <-.<-.<-.T_Axis_params.Major_tick_color;
            y => <-.Major_tick_style.y + <-.Major_tick_style.height;
            x = 0;
         };
         UIoptionMenu Minor_tick_color {
            parent => <-.UIframe_MajorTick;
            cmdList => <-.<-.<-.color5;
            selectedItem => <-.<-.<-.T_Axis_params.Minor_tick_color;
            y => <-.Minor_tick_style.y + <-.Minor_tick_style.height;
            x = 0;
         };
      };
   };
   UImod_panel panel<NEportLevels={3,0}> {
      x = 0;
      y = 0;
      title => name_of(<-.<-);
      height = 1300;
      parent<NEportLevels={3,0}>;
      option {
         set = 1;
      };
   };
   GMOD.instancer inst_RAxis {
      Group => <-.RAxis;
      Value => ((<-.Axis.selectedItem == 0) && (<-.panel.visible == 1));
   };
   GMOD.instancer inst_TAxis {
      Group => <-.TAxis;
      Value => ((<-.Axis.selectedItem == 1) && (<-.panel.visible == 1));
   };
   UIradioBoxLabel Axis {
      labels => <-.axis;
      parent => <-.panel;
      selectedItem = 0;
   };
   string axis[] = {"RAxis","TAxis"};
   float panelX => .Axis.x;
   float panelY => (.Axis.y + .Axis.height) + 10;
   mlink mlink<NEportLevels={1,2}> => {.AGPolarRAxis,
      .AGPolarRTicklines,.AGPolarTAxis,.AGPolarTTicklines};
   AGPolarRAxis AGPolarRAxis {
      majorTickOn = 1;
      text<NEportLevels={2,0}> => <-.RAxis.RText_UI.Axis_text.text;
      visibility => <-.RAxis.RAxle_UI.Axle_on_off.set;
      labelHeight => <-.RAxis.RLabel_UI.Label_Height_slider.value;
      positionT => <-.RAxis.RAxle_UI.Tposition.value;
      majorStepR => <-.RAxis.RTickLine_UI.major_step.value;
      labelMode => <-.RAxis.RText_UI.reverse_text_alignment.set;
      majorTickLineStyle => <-.RAxis.RTickLine_UI.Major_tick_style.selectedItem;
      majorTickWidth => <-.RAxis.RTickLine_UI.Major_tick_width.value;
      minorTickCount => <-.RAxis.RTickLine_UI.minor_step.value;
      minorTickLineStyle => <-.RAxis.RTickLine_UI.Minor_tick_style.selectedItem;
      minorTickWidth => <-.RAxis.RTickLine_UI.Minor_tick_width.value;
      majorTickColor => <-.RAxis.RTickLine_UI.Major_tick_color.cmdList[<-.RAxis.RTickLine_UI.Major_tick_color.selectedItem].label;
      minorTickColor => <-.RAxis.RTickLine_UI.Minor_tick_color.cmdList[<-.RAxis.RTickLine_UI.Minor_tick_color.selectedItem].label;
      majorReferenceR => <-.RAxis.RTickLine_UI.major_step.value;
      axleColor => <-.RAxis.RAxle_UI.Axle_color.cmdList[<-.RAxis.RAxle_UI.Axle_color.selectedItem].label;
      axleWidth => <-.RAxis.RAxle_UI.Axle_width.value;
      labelColor => <-.RAxis.RLabel_UI.Label_color.cmdList[<-.RAxis.RLabel_UI.Label_color.selectedItem].label;
      textColor => <-.RAxis.RText_UI.Text_color.cmdList[<-.RAxis.RText_UI.Text_color.selectedItem].label;
      textHeight => <-.RAxis.RText_UI.Text_Height_slider.value;
      labelDecimals => <-.RAxis.RLabel_UI.Label_Decimals.value;
   };
   AGPolarRTicklines AGPolarRTicklines {
      visibility<NEportLevels={2,0}> => <-.RAxis.RTickLine_UI.Major_Tick_on_off.set;
      majorTickOn = 1;
      majorTickWidth => <-.RAxis.RTickLine_UI.Major_tick_width.value;
      majorTickLineStyle => <-.RAxis.RTickLine_UI.Major_tick_style.selectedItem;
      minorTickLineStyle => <-.RAxis.RTickLine_UI.Minor_tick_style.selectedItem;
      majorTickColor => <-.RAxis.RTickLine_UI.Major_tick_color.cmdList[<-.RAxis.RTickLine_UI.Major_tick_color.selectedItem].label;
      minorTickColor => <-.RAxis.RTickLine_UI.Minor_tick_color.cmdList[<-.RAxis.RTickLine_UI.Minor_tick_color.selectedItem].label;
      minorTickCount => <-.RAxis.RTickLine_UI.minor_step.value;
      minorTickWidth => <-.RAxis.RTickLine_UI.Minor_tick_width.value;
//      majorReferenceR = 1.;
      majorStepR => <-.RAxis.RTickLine_UI.major_step.value;
   };
   AGPolarTAxis AGPolarTAxis {
      majorTickOn = 1;
      text<NEportLevels={2,0}> => <-.TAxis.TText_UI.Axis_text.text;
      visibility => <-.TAxis.TAxle_UI.Axle_on_off.set;
      labelHeight => <-.TAxis.TLabel_UI.Label_Height_slider.value;
      positionR => <-.TAxis.TAxle_UI.Rposition.value;
      majorStepT => <-.TAxis.TTickLine_UI.major_step.value;
      labelMode => <-.TAxis.TText_UI.reverse_text_alignment.set;
      majorTickLineStyle => <-.TAxis.TTickLine_UI.Major_tick_style.selectedItem;
      majorTickWidth => <-.TAxis.TTickLine_UI.Major_tick_width.value;
      minorTickCount => <-.TAxis.TTickLine_UI.minor_step.value;
      minorTickLineStyle => <-.TAxis.TTickLine_UI.Minor_tick_style.selectedItem;
      minorTickWidth => <-.TAxis.TTickLine_UI.Minor_tick_width.value;
      majorReferenceT => <-.TAxis.TTickLine_UI.major_step.value;
      majorTickColor => <-.TAxis.TTickLine_UI.Major_tick_color.cmdList[<-.TAxis.TTickLine_UI.Major_tick_color.selectedItem].label;
      minorTickColor => <-.TAxis.TTickLine_UI.Minor_tick_color.cmdList[<-.TAxis.TTickLine_UI.Minor_tick_color.selectedItem].label;
      axleColor => <-.TAxis.TAxle_UI.Axle_color.cmdList[<-.TAxis.TAxle_UI.Axle_color.selectedItem].label;
      axleWidth => <-.TAxis.TAxle_UI.Axle_width.value;
      labelColor => <-.TAxis.TLabel_UI.Label_color.cmdList[<-.TAxis.TLabel_UI.Label_color.selectedItem].label;
      textColor => <-.TAxis.TText_UI.Text_color.cmdList[<-.TAxis.TText_UI.Text_color.selectedItem].label;
      textHeight => <-.TAxis.TText_UI.Text_Height_slider.value;
      labelDecimals => <-.TAxis.TLabel_UI.Label_Decimals.value;
   };
   AGPolarTTicklines AGPolarTTicklines {
      visibility<NEportLevels={2,0}> => <-.TAxis.TTickLine_UI.Major_Tick_on_off.set;
      majorTickOn = 1;
      majorTickWidth => <-.TAxis.TTickLine_UI.Major_tick_width.value;
      minorTickCount => <-.TAxis.TTickLine_UI.minor_step.value;
      minorTickWidth => <-.TAxis.TTickLine_UI.Minor_tick_width.value;
//      majorReferenceT = 1.;
      majorStepT => <-.TAxis.TTickLine_UI.major_step.value;
      majorTickColor => <-.TAxis.TTickLine_UI.Major_tick_color.cmdList[<-.TAxis.TTickLine_UI.Major_tick_color.selectedItem].label;
      majorTickLineStyle => <-.TAxis.TTickLine_UI.Major_tick_style.selectedItem;
      minorTickColor => <-.TAxis.TTickLine_UI.Minor_tick_color.cmdList[<-.TAxis.TTickLine_UI.Minor_tick_color.selectedItem].label;
      minorTickLineStyle => <-.TAxis.TTickLine_UI.Minor_tick_style.selectedItem;
   };
   UIoption color1[12] = {
      {
         set=1,,,,,,,,,label="antibackground",,,,,,,,,,,
      },
      {
         label="background",,,,,,,,,,,
      },
      {
         label="red",,,,,,,,,,,
      },
      {
         label="green",,,,,,,,,,,
      },
      {
         label="blue",,,,,,,,,,,
      },
      {
         label="yellow",,,,,,,,,,,
      },
      {
         label="magenta",,,,,,,,,,,
      },
      {
         label="cyan",,,,,,,,,,,
      },
      {
         label="black",,,,,,,,,,,
      },
      {
         label="white",,,,,,,,,,,
      },
      {
         label="grey",,,,,,,,,,,
      }
   };
   UIoption style1[15] = {
      {
         set=1,,,,,,,,,label="solid",,,,,,,,,,,
      },
      {
         label="dashed",,,,,,,,,,,
      },
      {
         label="dotted",,,,,,,,,,,
      },
      {
         label="dasheddotted",,,,,,,,,,,
      },
      {
         label="______________",,,,,,,,,,,
      },
      {
         label=". . . . . . .",,,,,,,,,,,
      },
      {
         label="_ _ _ _ _ _ _",,,,,,,,,,,
      },
      {
         label="__ __ __ __ __",,,,,,,,,,,
      },
      {
         label="__ . __ . __ .",,,,,,,,,,,
      },
      {
         label="_ __ _ __ _ __",,,,,,,,,,,
      },
      {
         label=".  .  .  .  .",,,,,,,,,,,
      },
      {
         label="___ ___ ___ __",,,,,,,,,,,
      },
      {
         label="_ _  _ _  _ _",,,,,,,,,,,
      },
      {
         label="__ .. __ .. __",,,,,,,,,,,
      },
      {
         label="__ ... __ ...",,,,,,,,,,,
      }
   };
   UIoption color2[12] = {
      {
         set=1,,,,,,,,,label="antibackground",,,,,,,,,,,
      },
      {
         label="background",,,,,,,,,,,
      },
      {
         label="red",,,,,,,,,,,
      },
      {
         label="green",,,,,,,,,,,
      },
      {
         label="blue",,,,,,,,,,,
      },
      {
         label="yellow",,,,,,,,,,,
      },
      {
         label="magenta",,,,,,,,,,,
      },
      {
         label="cyan",,,,,,,,,,,
      },
      {
         label="black",,,,,,,,,,,
      },
      {
         label="white",,,,,,,,,,,
      },
      {
         label="grey",,,,,,,,,,,
      }
   };
   UIoption color3[12] = {
      {
         set=1,,,,,,,,,label="antibackground",,,,,,,,,,,
      },
      {
         label="background",,,,,,,,,,,
      },
      {
         label="red",,,,,,,,,,,
      },
      {
         label="green",,,,,,,,,,,
      },
      {
         label="blue",,,,,,,,,,,
      },
      {
         label="yellow",,,,,,,,,,,
      },
      {
         label="magenta",,,,,,,,,,,
      },
      {
         label="cyan",,,,,,,,,,,
      },
      {
         label="black",,,,,,,,,,,
      },
      {
         label="white",,,,,,,,,,,
      },
      {
         label="grey",,,,,,,,,,,
      }
   };
   UIoption color4[12] = {
      {
         set=1,,,,,,,,,label="antibackground",,,,,,,,,,,
      },
      {
         label="background",,,,,,,,,,,
      },
      {
         label="red",,,,,,,,,,,
      },
      {
         label="green",,,,,,,,,,,
      },
      {
         label="blue",,,,,,,,,,,
      },
      {
         label="yellow",,,,,,,,,,,
      },
      {
         label="magenta",,,,,,,,,,,
      },
      {
         label="cyan",,,,,,,,,,,
      },
      {
         label="black",,,,,,,,,,,
      },
      {
         label="white",,,,,,,,,,,
      },
      {
         label="grey",,,,,,,,,,,
      }
   };
   UIoption color5[12] = {
      {
         set=1,,,,,,,,,label="antibackground",,,,,,,,,,,
      },
      {
         label="background",,,,,,,,,,,
      },
      {
         label="red",,,,,,,,,,,
      },
      {
         label="green",,,,,,,,,,,
      },
      {
         label="blue",,,,,,,,,,,
      },
      {
         label="yellow",,,,,,,,,,,
      },
      {
         label="magenta",,,,,,,,,,,
      },
      {
         label="cyan",,,,,,,,,,,
      },
      {
         label="black",,,,,,,,,,,
      },
      {
         label="white",,,,,,,,,,,
      },
      {
         label="grey",,,,,,,,,,,
      }
   };
   UIoption style2[15] = {
      {
         label="solid",,,,,,,,,,,
      },
      {
         set=1,,,,,,,,,label="dashed",,,,,,,,,,,
      },
      {
         label="dotted",,,,,,,,,,,
      },
      {
         label="dasheddotted",,,,,,,,,,,
      },
      {
         label="______________",,,,,,,,,,,
      },
      {
         label=". . . . . . .",,,,,,,,,,,
      },
      {
         label="_ _ _ _ _ _ _",,,,,,,,,,,
      },
      {
         label="__ __ __ __ __",,,,,,,,,,,
      },
      {
         label="__ . __ . __ .",,,,,,,,,,,
      },
      {
         label="_ __ _ __ _ __",,,,,,,,,,,
      },
      {
         label=".  .  .  .  .",,,,,,,,,,,
      },
      {
         label="___ ___ ___ __",,,,,,,,,,,
      },
      {
         label="_ _  _ _  _ _",,,,,,,,,,,
      },
      {
         label="__ .. __ .. __",,,,,,,,,,,
      },
      {
         label="__ ... __ ...",,,,,,,,,,,
      }
   };
   AGPrimitive &Graph_in<NEportLevels={2,0}>;
   group R_Axis_params<export_all=2> {
      int Axle_on_off<NEportLevels={2,2}> = 1;
      float T_Axis_pos<NEportLevels={2,2}>;
      float Axle_width<NEportLevels={2,2}> = 1.;
      int Axle_color<NEportLevels={2,2}> = 0;
      int reverse_text<NEportLevels={2,2}> = 0;
      float text_height<NEportLevels={2,2}> = 5.;
      int Text_color<NEportLevels={2,2}> = 0;
      string R_Axis_text<NEportLevels={2,2}> = "R axis";
      float label_height<NEportLevels={2,2}> = 5.;
      int Label_color<NEportLevels={2,2}> = 0;
      float label_Decimals<NEportLevels={2,2}> = 0.;
      int R_Tickline_on_off<NEportLevels={2,2}> = 1;
      float Steps_for_Major<NEportLevels={2,2}>;
      int Steps_for_Minor<NEportLevels={2,2}> = 1;
      float Major_tick_width<NEportLevels={2,2}> = 0.5;
      float Minor_tick_width<NEportLevels={2,2}> = 0.01;
      int Major_tick_style<NEportLevels={2,2}> = 0;
      int Major_tick_color<NEportLevels={2,2}> = 0;
      int Minor_tick_style<NEportLevels={2,2}> = 1;
      int Minor_tick_color<NEportLevels={2,2}> = 0;
   };
   group T_Axis_params<export_all=2> {
      int Axle_on_off<NEportLevels={2,2}> = 1;
      float R_Axis_pos<NEportLevels={2,2}>;
      float Axle_width<NEportLevels={2,2}> = 1.;
      int Axle_color<NEportLevels={2,2}> = 0;
      int reverse_text<NEportLevels={2,2}> = 0;
      float text_height<NEportLevels={2,2}> = 5.;
      int Text_color<NEportLevels={2,2}> = 0;
      string T_Axis_text<NEportLevels={2,2}> = "T axis";
      float label_height<NEportLevels={2,2}> = 5.;
      int Label_color<NEportLevels={2,2}> = 0;
      float label_Decimals<NEportLevels={2,2}> = 0.;
      int T_Tickline_on_off<NEportLevels={2,2}> = 1;
      float Steps_for_Major<NEportLevels={2,2}> = 20;
      int Steps_for_Minor<NEportLevels={2,2}> = 1;
      float Major_tick_width<NEportLevels={2,2}> = 0.5;
      float Minor_tick_width<NEportLevels={2,2}> = 0.01;
      int Major_tick_style<NEportLevels={2,2}> = 0;
      int Major_tick_color<NEportLevels={2,2}> = 0;
      int Minor_tick_style<NEportLevels={2,2}> = 1;
      int Minor_tick_color<NEportLevels={2,2}> = 0;
   };
}; // PolarAxis


macro PolarWorld {
   AGPolarGraphWorld AGPolarGraphWorld {
      limitsT => {
         <-.PolarWorld_UI.T_min.value,<-.PolarWorld_UI.T_max.value};
      limitsR => {
         <-.PolarWorld_UI.R_min.value,<-.PolarWorld_UI.R_max.value};
      children => <-.AGCombinePolarGraphWorldInput.output;
   };
   AGCombinePolarGraphWorldInput AGCombinePolarGraphWorldInput {
      input1<NEportLevels={3,0}>;
      input2<NEportLevels={3,0}>;
   };
   UImod_panel panel {
      title => name_of(<-.<-);
      parent<NEportLevels={3,0}>;
      option {
         set = 1;
      };
   };
   macro PolarWorld_UI {
      UIfield T_min {
         y = 0;
         width = 60;
         parent => <-.<-.panel;
         value<NEportLevels={2,2}> => <-.<-.World_params.T_min;
      };
      UIlabel T_min_label {
         x => (<-.T_min.x + <-.T_min.width) + 5;
         y => <-.T_min.y;
         parent => <-.<-.panel;
         label => "T region min";
      };
      UIfield T_max {
         y => (<-.T_min.y + <-.T_min.height) + 5;
         parent => <-.<-.panel;
         value<NEportLevels={2,2}> => <-.<-.World_params.T_max;
         width = 60;
      };
      UIlabel T_max_label {
         x => (<-.T_max.x + <-.T_max.width) + 5;
         y => <-.T_max.y;
         parent => <-.<-.panel;
         label => "T region max";
      };
      UIfield R_min {
         y => (<-.T_max.y + <-.T_max.height) + 5;
         parent => <-.<-.panel;
         value<NEportLevels={2,2}> => <-.<-.World_params.R_min;
         width = 60;
      };
      UIlabel R_min_label {
         x => (<-.R_min.x + <-.R_min.width) + 5;
         y => <-.R_min.y;
         parent => <-.<-.panel;
         label => "R region min";
      };
      UIfield R_max {
         y => (<-.R_min.y + <-.R_min.height) + 5;
         parent => <-.<-.panel;
         value<NEportLevels={2,2}> => <-.<-.World_params.R_max;
         width = 60;
      };
      UIlabel R_max_label {
         x => (<-.R_max.x + <-.R_max.width) + 5;
         y => <-.R_max.y;
         parent => <-.<-.panel;
         label => "R region max";
      };
   };
   GMOD.instancer inst_PolarWorld_UI {
      Value => <-.panel.visible;
      Group => <-.PolarWorld_UI;
   };
   group World_params<export_all=2> {
      float T_min<NEportLevels={2,2}>;
      float T_max<NEportLevels={2,2}>;
      float R_min<NEportLevels={2,2}>;
      float R_max<NEportLevels={2,2}>;
   };
   link out<NEportLevels={1,2}> => AGPolarGraphWorld;
}; // PolarWorld

macro General_Graph {
   mlink ValuesX<NEportLevels={2,1}>;
   link  ValuesY1<NEportLevels={2,1},NEx=22.,NEy=44.>;
   link  ValuesY2<NEportLevels={2,1},NEx=22.,NEy=44.>;
   link  ValuesY3<NEportLevels={2,1},NEx=22.,NEy=44.>;
   link  ValuesY4<NEportLevels={2,1},NEx=22.,NEy=44.>;
   link  ValuesY5<NEportLevels={2,1},NEx=22.,NEy=44.>;
   macro Graph#1<NEx=11.,NEy=76.> {
      AGGraph AGGraph {
         visibility<NEportLevels={2,0}> => <-.GraphUI.UItoggle.set;
         graphType<NEportLevels={0,2}> => <-.GraphUI.graphtype.selectedItem;
         lineStyle<NEportLevels={0,2}> => <-.GraphUI.line_style.cmdList[<-.GraphUI.line_style.selectedItem].label;
         color => <-.GraphUI.line_color.cmdList[<-.GraphUI.line_color.selectedItem].label;
         legendText => <-.GraphUI.Graph_Name.text;
         valuesX => <-.<-.ValuesX;
         valuesY<NEportLevels={3,0}> => {<-.<-.ValuesY1};
         priority => <-.GraphUI.priority_typein.value;
         barWidth => <-.GraphUI.Bar_width_typein.value;
         lineWidth => <-.GraphUI.Line_width_typein.value;
         scatterSymbols => <-.GraphUI.symbol.text;
         symbolHeight => <-.GraphUI.symbol_height_typein.value;
      };
      float frameheight => <-.GraphParam.height + 10;
      UIframe UIframe {
         parent => <-.<-.GraphParam.UIpanel;
         y => <-.frameheight;
         width => <-.<-.GeneralGraph.width;
         height => <-.<-.GeneralGraph.height;
      };
      macro GraphUI {
         link panel<NEportLevels={2,0}> => <-.UIframe;
         UItoggle UItoggle {
            x = 2;
            y = 2;
            width = 120;
            parent => <-.panel;
            label => "Graph On/Off";
            set => <-.<-.Gparams.Graph_params1.Graph_on_off;
         };
         UIlabel priority_label {
            parent => <-.panel;
            label => "Graph priority";
            y => (<-.UItoggle.y + <-.UItoggle.height) + 10;
         };
         UIfield priority_typein {
            parent => <-.panel;
            value<NEportLevels={2,2}> => <-.<-.Gparams.Graph_params1.priority;
            x => <-.priority_label.x + <-.priority_label.width;
            y => <-.priority_label.y;
            decimalPoints = 0;
            format = "mixed";
         };
         string type<NEportLevels={0,1}>[8] = {
            "bars","barlines","area","curve","line","scatter","staircase",
            "stairarea"
         };
         UIradioBoxLabel graphtype {
            parent => <-.panel;
            labels => <-.type;
            title  => "Graph type";
            selectedItem => <-.<-.Gparams.Graph_params1.graphtype;
            y => (<-.priority_label.y + <-.priority_typein.height) + 10;
         };
         UIlabel Bar_width_label {
            parent => <-.panel;
            label => "Bar width";
            y => (<-.graphtype.y + <-.graphtype.height) + 10;
            active => (<-.graphtype.selectedItem < 2);
         };
         UIfield Bar_width_typein {
            parent => <-.panel;
            value<NEportLevels={2,2}> => <-.<-.Gparams.Graph_params1.Bar_width;
            x => <-.Bar_width_label.x + <-.Bar_width_label.width;
            y => <-.Bar_width_label.y;
            active => (<-.graphtype.selectedItem < 2);
         };
         UIlabel Line_width_label {
            parent => <-.panel;
            label => "Line width";
            y => <-.Bar_width_label.y + <-.Bar_width_typein.height;
            active => ((<-.graphtype.selectedItem > 2) && (<-.graphtype.selectedItem < 5));
         };
         UIfield Line_width_typein {
            parent => <-.panel;
            value<NEportLevels={2,2}> => <-.<-.Gparams.Graph_params1.Line_width;
            x => <-.Line_width_label.x + <-.Line_width_label.width;
            y => <-.Line_width_label.y;
            active => ((<-.graphtype.selectedItem > 2) && (<-.graphtype.selectedItem < 5));
         };
         UIlabel symbol_label {
            parent => <-.panel;
            label => "Scatter symbol";
            y => <-.Line_width_label.y + <-.Line_width_typein.height;
            active => (<-.graphtype.selectedItem == 5);
         };
         UItext symbol {
            parent => <-.panel;
            text => <-.<-.Gparams.Graph_params1.Scatter_symbols;
            x => <-.symbol_label.x + <-.symbol_label.width;
            y => <-.symbol_label.y;
            active => (<-.graphtype.selectedItem == 5);
         };
         UIlabel symbol_typein_label {
            label => "Scatter size";
            y => <-.symbol_label.y + <-.symbol.height;
            active => (<-.graphtype.selectedItem == 5);
            parent => <-.panel;
         };
         UIfield symbol_height_typein {
            parent => <-.panel;
            value<NEportLevels={2,2}> => <-.<-.Gparams.Graph_params1.Scatter_size;
            x => <-.symbol_typein_label.x + <-.symbol_typein_label.width;
            y => <-.symbol_typein_label.y;
            active => (<-.graphtype.selectedItem == 5);
         };
         UItext Graph_Name {
            parent => <-.panel;
            text => <-.<-.Gparams.Graph_params1.Graph_Name;
            y => (<-.symbol_typein_label.y + <-.symbol_height_typein.height) + 5;
         };
         UIlabel graphname_label {
            parent => <-.panel;
            label => "Graph Name";
            x = 100;
            y => <-.Graph_Name.y;
         };
         UIoption style[15] = {
            {
               set=1,,,,,,,,,label="solid",,,,,,,,,,,
            },
            {
               label="dashed",,,,,,,,,,,
            },
            {
               label="dotted",,,,,,,,,,,
            },
            {
               label="dasheddotted",,,,,,,,,,,
            },
            {
               label="______________",,,,,,,,,,,
            },
            {
               label=". . . . . . .",,,,,,,,,,,
            },
            {
               label="_ _ _ _ _ _ _",,,,,,,,,,,
            },
            {
               label="__ __ __ __ __",,,,,,,,,,,
            },
            {
               label="__ . __ . __ .",,,,,,,,,,,
            },
            {
               label="_ __ _ __ _ __",,,,,,,,,,,
            },
            {
               label=".  .  .  .  .",,,,,,,,,,,
            },
            {
               label="___ ___ ___ __",,,,,,,,,,,
            },
            {
               label="_ _  _ _  _ _",,,,,,,,,,,
            },
            {
               label="__ .. __ .. __",,,,,,,,,,,
            },
            {
               label="__ ... __ ...",,,,,,,,,,,
            }
         };
         UIoptionMenu line_style {
            parent => <-.panel;
            cmdList => <-.style;
            x = 2;
            y => (<-.Graph_Name.y + <-.Graph_Name.height) + 10;
            width => .UIradioBox.y + .UIradioBox.height;
            selectedItem => <-.<-.Gparams.Graph_params1.line_style;
         };
         UIoption color[12] = {
            {
               label="antibackground",,,,,,,,,,,
            },
            {
               label="background",,,,,,,,,,,
            },
            {
               set=1,,,,,,,,,label="red",,,,,,,,,,,
            },
            {
               label="green",,,,,,,,,,,
            },
            {
               label="blue",,,,,,,,,,,
            },
            {
               label="yellow",,,,,,,,,,,
            },
            {
               label="magenta",,,,,,,,,,,
            },
            {
               label="cyan",,,,,,,,,,,
            },
            {
               label="black",,,,,,,,,,,
            },
            {
               label="white",,,,,,,,,,,
            },
            {
               label="grey",,,,,,,,,,,
            }
         };
         UIoptionMenu line_color {
            parent => <-.panel;
            cmdList => <-.color;
            x = 2;
            y => <-.line_style.y + 40;
            width => .UIradioBox.y + .UIradioBox.height;
            selectedItem => <-.<-.Gparams.Graph_params1.line_color;
         };
      };
      GMOD.instancer inst_GraphUI {
         Value => (<-.<-.GraphParam.selectedItem == 0);
         Group => <-.UIframe;
      };
      macro Gparams<export_all=3> {
        group Graph_params1<export_all=2> {
           int Graph_on_off<NEportLevels={2,2}> = 1;
           int priority<NEportLevels={2,2}> = 1;
           int graphtype<NEportLevels={2,2}> = 0;
           float Bar_width<NEportLevels={2,2}>;
           float Line_width<NEportLevels={2,2}>;
           string Scatter_symbols<NEportLevels={2,2}> = "+";
           float Scatter_size<NEportLevels={2,2}> = 10.;
           string Graph_Name<NEportLevels={2,2}> = "Graph1";
           int line_style<NEportLevels={2,2}> = 0;
           int line_color<NEportLevels={2,2}> = 2;
        };
      };
      link output<NEportLevels={1,2}> => AGGraph;
   };
   macro Graph#2<NEx=11.,NEy=109.> {
      AGGraph AGGraph {
         visibility<NEportLevels={2,0}> => <-.GraphUI.UItoggle.set;
         graphType<NEportLevels={0,2}> => <-.GraphUI.graphtype.selectedItem;
         lineStyle<NEportLevels={0,2}> => <-.GraphUI.line_style.cmdList[<-.GraphUI.line_style.selectedItem].label;
         color => <-.GraphUI.line_color.cmdList[<-.GraphUI.line_color.selectedItem].label;
         legendText => <-.GraphUI.Graph_Name.text;
         valuesX => <-.<-.ValuesX;
         valuesY<NEportLevels={3,0}> => {<-.<-.ValuesY2};
         priority => <-.GraphUI.priority_typein.value;
         barWidth => <-.GraphUI.Bar_width_typein.value;
         lineWidth => <-.GraphUI.Line_width_typein.value;
         scatterSymbols => <-.GraphUI.symbol.text;
         symbolHeight => <-.GraphUI.symbol_height_typein.value;
      };
      float frameheight => <-.GraphParam.height + 10;
      UIframe UIframe {
         parent => <-.<-.GraphParam.UIpanel;
         y => <-.frameheight;
         width => <-.<-.GeneralGraph.width;
         height => <-.<-.GeneralGraph.height;
      };
      macro GraphUI {
         link panel<NEportLevels={2,0}> => <-.UIframe;
         UItoggle UItoggle {
            x = 2;
            y = 2;
            width = 120;
            parent => <-.panel;
            label => "Graph On/Off";
            set => <-.<-.Gparams.Graph_params2.Graph_on_off;
         };
         UIlabel priority_label {
            parent => <-.panel;
            label => "Graph priority";
            y => (<-.UItoggle.y + <-.UItoggle.height) + 10;
         };
         UIfield priority_typein {
            parent => <-.panel;
            value<NEportLevels={2,2}> => <-.<-.Gparams.Graph_params2.priority;
            x => <-.priority_label.x + <-.priority_label.width;
            y => <-.priority_label.y;
            decimalPoints = 0;
            format = "mixed";
         };
         string type<NEportLevels={0,1}>[8] = {
            "bars","barlines","area","curve","line","scatter","staircase",
            "stairarea"
         };
         UIradioBoxLabel graphtype {
            parent => <-.panel;
            labels => <-.type;
            title  => "Graph type";
            selectedItem => <-.<-.Gparams.Graph_params2.graphtype;
            y => (<-.priority_label.y + <-.priority_typein.height) + 10;
         };
         UIlabel Bar_width_label {
            parent => <-.panel;
            label => "Bar width";
            y => (<-.graphtype.y + <-.graphtype.height) + 10;
            active => (<-.graphtype.selectedItem < 2);
         };
         UIfield Bar_width_typein {
            parent => <-.panel;
            value<NEportLevels={2,2}> => <-.<-.Gparams.Graph_params2.Bar_width;
            x => <-.Bar_width_label.x + <-.Bar_width_label.width;
            y => <-.Bar_width_label.y;
            active => (<-.graphtype.selectedItem < 2);
         };
         UIlabel Line_width_label {
            parent => <-.panel;
            label => "Line width";
            y => <-.Bar_width_label.y + <-.Bar_width_typein.height;
            active => ((<-.graphtype.selectedItem > 2) && (<-.graphtype.selectedItem < 5));
         };
         UIfield Line_width_typein {
            parent => <-.panel;
            value<NEportLevels={2,2}> => <-.<-.Gparams.Graph_params2.Line_width;
            x => <-.Line_width_label.x + <-.Line_width_label.width;
            y => <-.Line_width_label.y;
            active => ((<-.graphtype.selectedItem > 2) && (<-.graphtype.selectedItem < 5));
         };
         UIlabel symbol_label {
            parent => <-.panel;
            label => "Scatter symbol";
            y => <-.Line_width_label.y + <-.Line_width_typein.height;
            active => (<-.graphtype.selectedItem == 5);
         };
         UItext symbol {
            parent => <-.panel;
            text => <-.<-.Gparams.Graph_params2.Scatter_symbols;
            x => <-.symbol_label.x + <-.symbol_label.width;
            y => <-.symbol_label.y;
            active => (<-.graphtype.selectedItem == 5);
         };
         UIlabel symbol_typein_label {
            label => "Scatter size";
            y => <-.symbol_label.y + <-.symbol.height;
            active => (<-.graphtype.selectedItem == 5);
            parent => <-.panel;
         };
         UIfield symbol_height_typein {
            parent => <-.panel;
            value<NEportLevels={2,2}> => <-.<-.Gparams.Graph_params2.Scatter_size;
            x => <-.symbol_typein_label.x + <-.symbol_typein_label.width;
            y => <-.symbol_typein_label.y;
            active => (<-.graphtype.selectedItem == 5);
         };
         UIlabel graphname_label {
            parent => <-.panel;
            label => "Graph Name";
            x = 100;
            y => <-.Graph_Name.y;
         };
         UItext Graph_Name {
            parent => <-.panel;
            text => <-.<-.Gparams.Graph_params2.Graph_Name;
            y => (<-.symbol_typein_label.y + <-.symbol_height_typein.height) + 5;
         };
         UIoption style[15] = {
            {
               set=1,,,,,,,,,label="solid",,,,,,,,,,,
            },
            {
               label="dashed",,,,,,,,,,,
            },
            {
               label="dotted",,,,,,,,,,,
            },
            {
               label="dasheddotted",,,,,,,,,,,
            },
            {
               label="______________",,,,,,,,,,,
            },
            {
               label=". . . . . . .",,,,,,,,,,,
            },
            {
               label="_ _ _ _ _ _ _",,,,,,,,,,,
            },
            {
               label="__ __ __ __ __",,,,,,,,,,,
            },
            {
               label="__ . __ . __ .",,,,,,,,,,,
            },
            {
               label="_ __ _ __ _ __",,,,,,,,,,,
            },
            {
               label=".  .  .  .  .",,,,,,,,,,,
            },
            {
               label="___ ___ ___ __",,,,,,,,,,,
            },
            {
               label="_ _  _ _  _ _",,,,,,,,,,,
            },
            {
               label="__ .. __ .. __",,,,,,,,,,,
            },
            {
               label="__ ... __ ...",,,,,,,,,,,
            }
         };
         UIoptionMenu line_style {
            parent => <-.panel;
            cmdList => <-.style;
            x = 2;
            y => (<-.Graph_Name.y + <-.Graph_Name.height) + 10;
            width => .UIradioBox.y + .UIradioBox.height;
            selectedItem => <-.<-.Gparams.Graph_params2.line_style;
         };
         UIoption color[12] = {
            {
               label="antibackground",,,,,,,,,,,
            },
            {
               label="background",,,,,,,,,,,
            },
            {
               set=1,,,,,,,,,label="red",,,,,,,,,,,
            },
            {
               label="green",,,,,,,,,,,
            },
            {
               label="blue",,,,,,,,,,,
            },
            {
               label="yellow",,,,,,,,,,,
            },
            {
               label="magenta",,,,,,,,,,,
            },
            {
               label="cyan",,,,,,,,,,,
            },
            {
               label="black",,,,,,,,,,,
            },
            {
               label="white",,,,,,,,,,,
            },
            {
               label="grey",,,,,,,,,,,
            }
         };
         UIoptionMenu line_color {
            parent => <-.panel;
            cmdList => <-.color;
            x = 2;
            y => <-.line_style.y + 40;
            width => .UIradioBox.y + .UIradioBox.height;
            selectedItem => <-.<-.Gparams.Graph_params2.line_color;
         };
      };
      GMOD.instancer inst_GraphUI {
         Value => (<-.<-.GraphParam.selectedItem == 1);
         Group => <-.UIframe;
      };
      macro Gparams<export_all=3> {
        group Graph_params2<export_all=2> {
           int Graph_on_off<NEportLevels={2,2}> = 1;
           int priority<NEportLevels={2,2}> = 1;
           int graphtype<NEportLevels={2,2}> = 0;
           float Bar_width<NEportLevels={2,2}>;
           float Line_width<NEportLevels={2,2}>;
           string Scatter_symbols<NEportLevels={2,2}> = "+";
           float Scatter_size<NEportLevels={2,2}> = 10.;
           string Graph_Name<NEportLevels={2,2}> = "Graph2";
           int line_style<NEportLevels={2,2}> = 0;
           int line_color<NEportLevels={2,2}> = 2;
        };
      };
      link output<NEportLevels={1,2}> => AGGraph;
   };
   macro Graph#3<NEx=11.,NEy=142.> {
      AGGraph AGGraph {
         visibility<NEportLevels={2,0}> => <-.GraphUI.UItoggle.set;
         graphType<NEportLevels={0,2}> => <-.GraphUI.graphtype.selectedItem;
         lineStyle<NEportLevels={0,2}> => <-.GraphUI.line_style.cmdList[<-.GraphUI.line_style.selectedItem].label;
         color => <-.GraphUI.line_color.cmdList[<-.GraphUI.line_color.selectedItem].label;
         legendText => <-.GraphUI.Graph_Name.text;
         valuesX => <-.<-.ValuesX;
         valuesY<NEportLevels={3,0}> => {<-.<-.ValuesY3};
         priority => <-.GraphUI.priority_typein.value;
         barWidth => <-.GraphUI.Bar_width_typein.value;
         lineWidth => <-.GraphUI.Line_width_typein.value;
         scatterSymbols => <-.GraphUI.symbol.text;
         symbolHeight => <-.GraphUI.symbol_height_typein.value;
      };
      float frameheight => <-.GraphParam.height + 10;
      UIframe UIframe {
         parent => <-.<-.GraphParam.UIpanel;
         y => <-.frameheight;
         width => <-.<-.GeneralGraph.width;
         height => <-.<-.GeneralGraph.height;
      };
      macro GraphUI {
         link panel<NEportLevels={2,0}> => <-.UIframe;
         UItoggle UItoggle {
            x = 2;
            y = 2;
            width = 120;
            parent => <-.panel;
            label => "Graph On/Off";
            set => <-.<-.Gparams.Graph_params3.Graph_on_off;
         };
         UIlabel priority_label {
            parent => <-.panel;
            label => "Graph priority";
            y => (<-.UItoggle.y + <-.UItoggle.height) + 10;
         };
         UIfield priority_typein {
            parent => <-.panel;
            value<NEportLevels={2,2}> => <-.<-.Gparams.Graph_params3.priority;
            x => <-.priority_label.x + <-.priority_label.width;
            y => <-.priority_label.y;
            decimalPoints = 0;
            format = "mixed";
         };
         string type<NEportLevels={0,1}>[8] = {
            "bars","barlines","area","curve","line","scatter","staircase",
            "stairarea"
         };
         UIradioBoxLabel graphtype {
            parent => <-.panel;
            labels => <-.type;
            title  => "Graph type";
            selectedItem => <-.<-.Gparams.Graph_params3.graphtype;
            y => (<-.priority_label.y + <-.priority_typein.height) + 10;
         };
         UIlabel Bar_width_label {
            parent => <-.panel;
            label => "Bar width";
            y => (<-.graphtype.y + <-.graphtype.height) + 10;
            active => (<-.graphtype.selectedItem < 2);
         };
         UIfield Bar_width_typein {
            parent => <-.panel;
            value<NEportLevels={2,2}> => <-.<-.Gparams.Graph_params3.Bar_width;
            x => <-.Bar_width_label.x + <-.Bar_width_label.width;
            y => <-.Bar_width_label.y;
            active => (<-.graphtype.selectedItem < 2);
         };
         UIlabel Line_width_label {
            parent => <-.panel;
            label => "Line width";
            y => <-.Bar_width_label.y + <-.Bar_width_typein.height;
            active => ((<-.graphtype.selectedItem > 2) && (<-.graphtype.selectedItem < 5));
         };
         UIfield Line_width_typein {
            parent => <-.panel;
            value<NEportLevels={2,2}> => <-.<-.Gparams.Graph_params3.Line_width;
            x => <-.Line_width_label.x + <-.Line_width_label.width;
            y => <-.Line_width_label.y;
            active => ((<-.graphtype.selectedItem > 2) && (<-.graphtype.selectedItem < 5));
         };
         UIlabel symbol_label {
            parent => <-.panel;
            label => "Scatter symbol";
            y => <-.Line_width_label.y + <-.Line_width_typein.height;
            active => (<-.graphtype.selectedItem == 5);
         };
         UItext symbol {
            parent => <-.panel;
            text => <-.<-.Gparams.Graph_params3.Scatter_symbols;
            x => <-.symbol_label.x + <-.symbol_label.width;
            y => <-.symbol_label.y;
            active => (<-.graphtype.selectedItem == 5);
         };
         UIlabel symbol_typein_label {
            label => "Scatter size";
            y => <-.symbol_label.y + <-.symbol.height;
            active => (<-.graphtype.selectedItem == 5);
            parent => <-.panel;
         };
         UIfield symbol_height_typein {
            parent => <-.panel;
            value<NEportLevels={2,2}> => <-.<-.Gparams.Graph_params3.Scatter_size;
            x => <-.symbol_typein_label.x + <-.symbol_typein_label.width;
            y => <-.symbol_typein_label.y;
            active => (<-.graphtype.selectedItem == 5);
         };
         UIlabel graphname_label {
            parent => <-.panel;
            label => "Graph Name";
            x = 100;
            y => <-.Graph_Name.y;
         };
         UItext Graph_Name {
            parent => <-.panel;
            text => <-.<-.Gparams.Graph_params3.Graph_Name;
            y => (<-.symbol_typein_label.y + <-.symbol_height_typein.height) + 5;
         };
         UIoption style[15] = {
            {
               set=1,,,,,,,,,label="solid",,,,,,,,,,,
            },
            {
               label="dashed",,,,,,,,,,,
            },
            {
               label="dotted",,,,,,,,,,,
            },
            {
               label="dasheddotted",,,,,,,,,,,
            },
            {
               label="______________",,,,,,,,,,,
            },
            {
               label=". . . . . . .",,,,,,,,,,,
            },
            {
               label="_ _ _ _ _ _ _",,,,,,,,,,,
            },
            {
               label="__ __ __ __ __",,,,,,,,,,,
            },
            {
               label="__ . __ . __ .",,,,,,,,,,,
            },
            {
               label="_ __ _ __ _ __",,,,,,,,,,,
            },
            {
               label=".  .  .  .  .",,,,,,,,,,,
            },
            {
               label="___ ___ ___ __",,,,,,,,,,,
            },
            {
               label="_ _  _ _  _ _",,,,,,,,,,,
            },
            {
               label="__ .. __ .. __",,,,,,,,,,,
            },
            {
               label="__ ... __ ...",,,,,,,,,,,
            }
         };
         UIoptionMenu line_style {
            parent => <-.panel;
            cmdList => <-.style;
            x = 2;
            y => (<-.Graph_Name.y + <-.Graph_Name.height) + 10;
            width => .UIradioBox.y + .UIradioBox.height;
            selectedItem => <-.<-.Gparams.Graph_params3.line_style;
         };
         UIoption color[12] = {
            {
               label="antibackground",,,,,,,,,,,
            },
            {
               label="background",,,,,,,,,,,
            },
            {
               set=1,,,,,,,,,label="red",,,,,,,,,,,
            },
            {
               label="green",,,,,,,,,,,
            },
            {
               label="blue",,,,,,,,,,,
            },
            {
               label="yellow",,,,,,,,,,,
            },
            {
               label="magenta",,,,,,,,,,,
            },
            {
               label="cyan",,,,,,,,,,,
            },
            {
               label="black",,,,,,,,,,,
            },
            {
               label="white",,,,,,,,,,,
            },
            {
               label="grey",,,,,,,,,,,
            }
         };
         UIoptionMenu line_color {
            parent => <-.panel;
            cmdList => <-.color;
            x = 2;
            y => <-.line_style.y + 40;
            width => .UIradioBox.y + .UIradioBox.height;
            selectedItem => <-.<-.Gparams.Graph_params3.line_color;
         };
      };
      GMOD.instancer inst_GraphUI {
         Value => (<-.<-.GraphParam.selectedItem == 2);
         Group => <-.UIframe;
      };
      macro Gparams<export_all=3> {
        group Graph_params3<export_all=2> {
           int Graph_on_off<NEportLevels={2,2}> = 1;
           int priority<NEportLevels={2,2}> = 1;
           int graphtype<NEportLevels={2,2}> = 0;
           float Bar_width<NEportLevels={2,2}>;
           float Line_width<NEportLevels={2,2}>;
           string Scatter_symbols<NEportLevels={2,2}> = "+";
           float Scatter_size<NEportLevels={2,2}> = 10.;
           string Graph_Name<NEportLevels={2,2}> = "Graph3";
           int line_style<NEportLevels={2,2}> = 0;
           int line_color<NEportLevels={2,2}> = 2;
        };
      };
      link output<NEportLevels={1,2}> => AGGraph;
   };
   macro Graph#4<NEx=11.,NEy=175.> {
      AGGraph AGGraph {
         visibility<NEportLevels={2,0}> => <-.GraphUI.UItoggle.set;
         graphType<NEportLevels={0,2}> => <-.GraphUI.graphtype.selectedItem;
         lineStyle<NEportLevels={0,2}> => <-.GraphUI.line_style.cmdList[<-.GraphUI.line_style.selectedItem].label;
         color => <-.GraphUI.line_color.cmdList[<-.GraphUI.line_color.selectedItem].label;
         legendText => <-.GraphUI.Graph_Name.text;
         valuesX => <-.<-.ValuesX;
         valuesY<NEportLevels={3,0}> => {<-.<-.ValuesY4};
         priority => <-.GraphUI.priority_typein.value;
         barWidth => <-.GraphUI.Bar_width_typein.value;
         lineWidth => <-.GraphUI.Line_width_typein.value;
         scatterSymbols => <-.GraphUI.symbol.text;
         symbolHeight => <-.GraphUI.symbol_height_typein.value;
      };
      float frameheight => <-.GraphParam.height + 10;
      UIframe UIframe {
         parent => <-.<-.GraphParam.UIpanel;
         y => <-.frameheight;
         width => <-.<-.GeneralGraph.width;
         height => <-.<-.GeneralGraph.height;
      };
      macro GraphUI {
         link panel<NEportLevels={2,0}> => <-.UIframe;
         UItoggle UItoggle {
            x = 2;
            y = 2;
            width = 120;
            parent => <-.panel;
            label => "Graph On/Off";
            set => <-.<-.Gparams.Graph_params4.Graph_on_off;
         };
         UIlabel priority_label {
            parent => <-.panel;
            label => "Graph priority";
            y => (<-.UItoggle.y + <-.UItoggle.height) + 10;
         };
         UIfield priority_typein {
            parent => <-.panel;
            value<NEportLevels={2,2}> => <-.<-.Gparams.Graph_params4.priority;
            x => <-.priority_label.x + <-.priority_label.width;
            y => <-.priority_label.y;
            decimalPoints = 0;
            format = "mixed";
         };
         string type<NEportLevels={0,1}>[8] = {
            "bars","barlines","area","curve","line","scatter","staircase",
            "stairarea"
         };
         UIradioBoxLabel graphtype {
            parent => <-.panel;
            labels => <-.type;
            title  => "Graph type";
            selectedItem => <-.<-.Gparams.Graph_params4.graphtype;
            y => (<-.priority_label.y + <-.priority_typein.height) + 10;
         };
         UIlabel Bar_width_label {
            parent => <-.panel;
            label => "Bar width";
            y => (<-.graphtype.y + <-.graphtype.height) + 10;
            active => (<-.graphtype.selectedItem < 2);
         };
         UIfield Bar_width_typein {
            parent => <-.panel;
            value<NEportLevels={2,2}> => <-.<-.Gparams.Graph_params4.Bar_width;
            x => <-.Bar_width_label.x + <-.Bar_width_label.width;
            y => <-.Bar_width_label.y;
            active => (<-.graphtype.selectedItem < 2);
         };
         UIlabel Line_width_label {
            parent => <-.panel;
            label => "Line width";
            y => <-.Bar_width_label.y + <-.Bar_width_typein.height;
            active => ((<-.graphtype.selectedItem > 2) && (<-.graphtype.selectedItem < 5));
         };
         UIfield Line_width_typein {
            parent => <-.panel;
            value<NEportLevels={2,2}> => <-.<-.Gparams.Graph_params4.Line_width;
            x => <-.Line_width_label.x + <-.Line_width_label.width;
            y => <-.Line_width_label.y;
            active => ((<-.graphtype.selectedItem > 2) && (<-.graphtype.selectedItem < 5));
         };
         UIlabel symbol_label {
            parent => <-.panel;
            label => "Scatter symbol";
            y => <-.Line_width_label.y + <-.Line_width_typein.height;
            active => (<-.graphtype.selectedItem == 5);
         };
         UItext symbol {
            parent => <-.panel;
            text => <-.<-.Gparams.Graph_params4.Scatter_symbols;
            x => <-.symbol_label.x + <-.symbol_label.width;
            y => <-.symbol_label.y;
            active => (<-.graphtype.selectedItem == 5);
         };
         UIlabel symbol_typein_label {
            label => "Scatter size";
            y => <-.symbol_label.y + <-.symbol.height;
            active => (<-.graphtype.selectedItem == 5);
            parent => <-.panel;
         };
         UIfield symbol_height_typein {
            parent => <-.panel;
            value<NEportLevels={2,2}> => <-.<-.Gparams.Graph_params4.Scatter_size;
            x => <-.symbol_typein_label.x + <-.symbol_typein_label.width;
            y => <-.symbol_typein_label.y;
            active => (<-.graphtype.selectedItem == 5);
         };
         UIlabel graphname_label {
            parent => <-.panel;
            label => "Graph Name";
            x = 100;
            y => <-.Graph_Name.y;
         };
         UItext Graph_Name {
            parent => <-.panel;
            text => <-.<-.Gparams.Graph_params4.Graph_Name;
            y => (<-.symbol_typein_label.y + <-.symbol_height_typein.height) + 5;
         };
         UIoption style[15] = {
            {
               set=1,,,,,,,,,label="solid",,,,,,,,,,,
            },
            {
               label="dashed",,,,,,,,,,,
            },
            {
               label="dotted",,,,,,,,,,,
            },
            {
               label="dasheddotted",,,,,,,,,,,
            },
            {
               label="______________",,,,,,,,,,,
            },
            {
               label=". . . . . . .",,,,,,,,,,,
            },
            {
               label="_ _ _ _ _ _ _",,,,,,,,,,,
            },
            {
               label="__ __ __ __ __",,,,,,,,,,,
            },
            {
               label="__ . __ . __ .",,,,,,,,,,,
            },
            {
               label="_ __ _ __ _ __",,,,,,,,,,,
            },
            {
               label=".  .  .  .  .",,,,,,,,,,,
            },
            {
               label="___ ___ ___ __",,,,,,,,,,,
            },
            {
               label="_ _  _ _  _ _",,,,,,,,,,,
            },
            {
               label="__ .. __ .. __",,,,,,,,,,,
            },
            {
               label="__ ... __ ...",,,,,,,,,,,
            }
         };
         UIoptionMenu line_style {
            parent => <-.panel;
            cmdList => <-.style;
            x = 2;
            y => (<-.Graph_Name.y + <-.Graph_Name.height) + 10;
            width => .UIradioBox.y + .UIradioBox.height;
            selectedItem => <-.<-.Gparams.Graph_params4.line_style;
         };
         UIoption color[12] = {
            {
               label="antibackground",,,,,,,,,,,
            },
            {
               label="background",,,,,,,,,,,
            },
            {
               set=1,,,,,,,,,label="red",,,,,,,,,,,
            },
            {
               label="green",,,,,,,,,,,
            },
            {
               label="blue",,,,,,,,,,,
            },
            {
               label="yellow",,,,,,,,,,,
            },
            {
               label="magenta",,,,,,,,,,,
            },
            {
               label="cyan",,,,,,,,,,,
            },
            {
               label="black",,,,,,,,,,,
            },
            {
               label="white",,,,,,,,,,,
            },
            {
               label="grey",,,,,,,,,,,
            }
         };
         UIoptionMenu line_color {
            parent => <-.panel;
            cmdList => <-.color;
            x = 2;
            y => <-.line_style.y + 40;
            width => .UIradioBox.y + .UIradioBox.height;
            selectedItem => <-.<-.Gparams.Graph_params4.line_color;
         };
      };
      GMOD.instancer inst_GraphUI {
         Value => (<-.<-.GraphParam.selectedItem == 3);
         Group => <-.UIframe;
      };
      macro Gparams<export_all=3> {
        group Graph_params4<export_all=2> {
           int Graph_on_off<NEportLevels={2,2}> = 1;
           int priority<NEportLevels={2,2}> = 1;
           int graphtype<NEportLevels={2,2}> = 0;
           float Bar_width<NEportLevels={2,2}>;
           float Line_width<NEportLevels={2,2}>;
           string Scatter_symbols<NEportLevels={2,2}> = "+";
           float Scatter_size<NEportLevels={2,2}> = 10.;
           string Graph_Name<NEportLevels={2,2}> = "Graph4";
           int line_style<NEportLevels={2,2}> = 0;
           int line_color<NEportLevels={2,2}> = 2;
        };
      };
      link output<NEportLevels={1,2}> => AGGraph;
   };
   macro Graph#5<NEx=11.,NEy=208.> {
      AGGraph AGGraph {
         visibility<NEportLevels={2,0}> => <-.GraphUI.UItoggle.set;
         graphType<NEportLevels={0,2}> => <-.GraphUI.graphtype.selectedItem;
         lineStyle<NEportLevels={0,2}> => <-.GraphUI.line_style.cmdList[<-.GraphUI.line_style.selectedItem].label;
         color => <-.GraphUI.line_color.cmdList[<-.GraphUI.line_color.selectedItem].label;
         legendText => <-.GraphUI.Graph_Name.text;
         valuesX => <-.<-.ValuesX;
         valuesY<NEportLevels={3,0}> => {<-.<-.ValuesY5};
         priority => <-.GraphUI.priority_typein.value;
         barWidth => <-.GraphUI.Bar_width_typein.value;
         lineWidth => <-.GraphUI.Line_width_typein.value;
         scatterSymbols => <-.GraphUI.symbol.text;
         symbolHeight => <-.GraphUI.symbol_height_typein.value;
      };
      float frameheight => <-.GraphParam.height + 10;
      UIframe UIframe {
         parent => <-.<-.GraphParam.UIpanel;
         y => <-.frameheight;
         width => <-.<-.GeneralGraph.width;
         height => <-.<-.GeneralGraph.height;
      };
      macro GraphUI {
         link panel<NEportLevels={2,0}> => <-.UIframe;
         UItoggle UItoggle {
            x = 2;
            y = 2;
            width = 120;
            parent => <-.panel;
            label => "Graph On/Off";
            set => <-.<-.Gparams.Graph_params5.Graph_on_off;
         };
         UIlabel priority_label {
            parent => <-.panel;
            label => "Graph priority";
            y => (<-.UItoggle.y + <-.UItoggle.height) + 10;
         };
         UIfield priority_typein {
            parent => <-.panel;
            value<NEportLevels={2,2}> => <-.<-.Gparams.Graph_params5.priority;
            x => <-.priority_label.x + <-.priority_label.width;
            y => <-.priority_label.y;
            decimalPoints = 0;
            format = "mixed";
         };
         string type<NEportLevels={0,1}>[8] = {
            "bars","barlines","area","curve","line","scatter","staircase",
            "stairarea"
         };
         UIradioBoxLabel graphtype {
            parent => <-.panel;
            labels => <-.type;
            title  => "Graph type";
            selectedItem => <-.<-.Gparams.Graph_params5.graphtype;
            y => (<-.priority_label.y + <-.priority_typein.height) + 10;
         };
         UIlabel Bar_width_label {
            parent => <-.panel;
            label => "Bar width";
            y => (<-.graphtype.y + <-.graphtype.height) + 10;
            active => (<-.graphtype.selectedItem < 2);
         };
         UIfield Bar_width_typein {
            parent => <-.panel;
            value<NEportLevels={2,2}> => <-.<-.Gparams.Graph_params5.Bar_width;
            x => <-.Bar_width_label.x + <-.Bar_width_label.width;
            y => <-.Bar_width_label.y;
            active => (<-.graphtype.selectedItem < 2);
         };
         UIlabel Line_width_label {
            parent => <-.panel;
            label => "Line width";
            y => <-.Bar_width_label.y + <-.Bar_width_typein.height;
            active => ((<-.graphtype.selectedItem > 2) && (<-.graphtype.selectedItem < 5));
         };
         UIfield Line_width_typein {
            parent => <-.panel;
            value<NEportLevels={2,2}> => <-.<-.Gparams.Graph_params5.Line_width;
            x => <-.Line_width_label.x + <-.Line_width_label.width;
            y => <-.Line_width_label.y;
            active => ((<-.graphtype.selectedItem > 2) && (<-.graphtype.selectedItem < 5));
         };
         UIlabel symbol_label {
            parent => <-.panel;
            label => "Scatter symbol";
            y => <-.Line_width_label.y + <-.Line_width_typein.height;
            active => (<-.graphtype.selectedItem == 5);
         };
         UItext symbol {
            parent => <-.panel;
            text => <-.<-.Gparams.Graph_params5.Scatter_symbols;
            x => <-.symbol_label.x + <-.symbol_label.width;
            y => <-.symbol_label.y;
            active => (<-.graphtype.selectedItem == 5);
         };
         UIlabel symbol_typein_label {
            label => "Scatter size";
            y => <-.symbol_label.y + <-.symbol.height;
            active => (<-.graphtype.selectedItem == 5);
            parent => <-.panel;
         };
         UIfield symbol_height_typein {
            parent => <-.panel;
            value<NEportLevels={2,2}> => <-.<-.Gparams.Graph_params5.Scatter_size;
            x => <-.symbol_typein_label.x + <-.symbol_typein_label.width;
            y => <-.symbol_typein_label.y;
            active => (<-.graphtype.selectedItem == 5);
         };
         UIlabel graphname_label {
            parent => <-.panel;
            label => "Graph Name";
            x = 100;
            y => <-.Graph_Name.y;
         };
         UItext Graph_Name {
            parent => <-.panel;
            text => <-.<-.Gparams.Graph_params5.Graph_Name;
            y => (<-.symbol_typein_label.y + <-.symbol_height_typein.height) + 5;
         };
         UIoption style[15] = {
            {
               set=1,,,,,,,,,label="solid",,,,,,,,,,,
            },
            {
               label="dashed",,,,,,,,,,,
            },
            {
               label="dotted",,,,,,,,,,,
            },
            {
               label="dasheddotted",,,,,,,,,,,
            },
            {
               label="______________",,,,,,,,,,,
            },
            {
               label=". . . . . . .",,,,,,,,,,,
            },
            {
               label="_ _ _ _ _ _ _",,,,,,,,,,,
            },
            {
               label="__ __ __ __ __",,,,,,,,,,,
            },
            {
               label="__ . __ . __ .",,,,,,,,,,,
            },
            {
               label="_ __ _ __ _ __",,,,,,,,,,,
            },
            {
               label=".  .  .  .  .",,,,,,,,,,,
            },
            {
               label="___ ___ ___ __",,,,,,,,,,,
            },
            {
               label="_ _  _ _  _ _",,,,,,,,,,,
            },
            {
               label="__ .. __ .. __",,,,,,,,,,,
            },
            {
               label="__ ... __ ...",,,,,,,,,,,
            }
         };
         UIoptionMenu line_style {
            parent => <-.panel;
            cmdList => <-.style;
            x = 2;
            y => (<-.Graph_Name.y + <-.Graph_Name.height) + 10;
            width => .UIradioBox.y + .UIradioBox.height;
            selectedItem => <-.<-.Gparams.Graph_params5.line_style;
         };
         UIoption color[12] = {
            {
               label="antibackground",,,,,,,,,,,
            },
            {
               label="background",,,,,,,,,,,
            },
            {
               set=1,,,,,,,,,label="red",,,,,,,,,,,
            },
            {
               label="green",,,,,,,,,,,
            },
            {
               label="blue",,,,,,,,,,,
            },
            {
               label="yellow",,,,,,,,,,,
            },
            {
               label="magenta",,,,,,,,,,,
            },
            {
               label="cyan",,,,,,,,,,,
            },
            {
               label="black",,,,,,,,,,,
            },
            {
               label="white",,,,,,,,,,,
            },
            {
               label="grey",,,,,,,,,,,
            }
         };
         UIoptionMenu line_color {
            parent => <-.panel;
            cmdList => <-.color;
            x = 2;
            y => <-.line_style.y + 40;
            width => .UIradioBox.y + .UIradioBox.height;
            selectedItem => <-.<-.Gparams.Graph_params5.line_color;
         };
      };
      GMOD.instancer inst_GraphUI {
         Value => (<-.<-.GraphParam.selectedItem == 4);
         Group => <-.UIframe;
      };
      macro Gparams<export_all=3> {
        group Graph_params5<export_all=2> {
           int Graph_on_off<NEportLevels={2,2}> = 1;
           int priority<NEportLevels={2,2}> = 1;
           int graphtype<NEportLevels={2,2}> = 0;
           float Bar_width<NEportLevels={2,2}>;
           float Line_width<NEportLevels={2,2}>;
           string Scatter_symbols<NEportLevels={2,2}> = "+";
           float Scatter_size<NEportLevels={2,2}> = 10.;
           string Graph_Name<NEportLevels={2,2}> = "Graph5";
           int line_style<NEportLevels={2,2}> = 0;
           int line_color<NEportLevels={2,2}> = 2;
        };
      };
      link output<NEportLevels={1,2}> => AGGraph;
   };

   UImod_panel GeneralGraph<NEx=330.,NEy=11.> {
      parent<NEportLevels={3,0}>;
      option {
         set = 1;
      };
      title => name_of(<-.<-);
   };

   macro SelectParam<NEx=506.,NEy=22.> {
      UIoptionMenu Parameter {
         parent<NEportLevels={3,0}> => <-.<-.GeneralGraph;
         cmdList => <-.label_cmd.cmd;
         selectedItem = 0;
         x = 0;
         y = 0;
         width = 180;
         height = 30;
         label = " Object ";
      };
      label_cmd label_cmd {
         labels = {
            "Graph","Axis","World","Viewport","Legend"
         };
         cmd<NEportLevels={0,2}>[] = {
            ,,,,
            {
               set=1
            }
         };
      };
   };
   GMOD.instancer inst_Graph<NEx=506.,NEy=99.> {
      Value => (<-.SelectParam.Parameter.selectedItem == 0);
      Group => <-.GraphParam;
   };
   GMOD.instancer inst_Axis<NEx=506.,NEy=132.> {
      Value => (<-.SelectParam.Parameter.selectedItem == 1);
      Group => <-.XYAxis.panel;
   };
   GMOD.instancer inst_World<NEx=506.,NEy=167.> {
      Value => (<-.SelectParam.Parameter.selectedItem == 2);
      Group => <-.GraphWorld.panel;
   };
   GMOD.instancer inst_Viewport<NEx=506.,NEy=200.> {
      Value => (<-.SelectParam.Parameter.selectedItem == 3);
      Group => <-.GraphViewport.panel;
   };
   GMOD.instancer inst_Legend<NEx=506.,NEy=244.> {
      Value => (<-.SelectParam.Parameter.selectedItem == 4);
      Group => <-.GraphLegend.panel;
   };
   macro GraphParam<NEx=341.,NEy=66.> {
      ilink parent<NEportLevels={2,1}> => <-.GeneralGraph;
      imlink labels<NEportLevels={2,1}> => <-.graph;
      int selectedItem<NEportLevels={2,0},NEx=319.,NEy=33.> = 0;
      string+nres selectedString<NEportLevels={2,0},NEx=319.,NEy=198.> => labels[.selectedItem];
      int visible = 1;
      int active = 1;
      int x = 0;
      int y = 30;
      int width => <-.GeneralGraph.width ;
      int height => .UIradioBox.y + .UIradioBox.height;
      label_cmd label_cmd {
         labels => <-.labels;
         cmd[5] {
            active => <-.<-.active;
         } = {
            {
               set=1,,,,,,,,,,,,,,,,,,,,
            },,,,
         };
         inItem => <-.selectedItem;
         outItem => .inItem;
      };
      UIpanel UIpanel {
         x => <-.x;
         y => <-.y;
         width => <-.width;
         height => <-.<-.GeneralGraph.height;
         parent => <-.parent;
      };
      UIradioBox UIradioBox {
         y = 0;
         width => <-.UIpanel.width;
         &visible => <-.visible;
         parent => <-.UIpanel;
         cmdList => <-.label_cmd.cmd;
         selectedItem => <-.label_cmd.outItem;
      };
   };
   string graph<NEx=506.,NEy=66.>[] = {
      "Graph1","Graph2","Graph3","Graph4","Graph5"
   };
   macro GraphWorld<NEx=187.,NEy=132.> {
      AGGraphWorld AGGraphWorld {
         clip => <-.GraphWorldUI.clip_toggle.set;
         limitsX => {
            <-.GraphWorldUI.X_min.value,<-.GraphWorldUI.X_max.value};
         limitsY => {
            <-.GraphWorldUI.Y_min.value,<-.GraphWorldUI.Y_max.value};
         children => <-.AGCombineGraphWorldInput.output;
         scaleTypeX => <-.GraphWorldUI.scale_type_X.selectedItem;
         scaleTypeY => <-.GraphWorldUI.scale_type_Y.selectedItem;
      };
      AGCombineGraphWorldInput AGCombineGraphWorldInput {
         input1<NEportLevels={3,0}> => {
            <-.<-.Graph#1.output,<-.<-.Graph#2.output,<-.<-.Graph#3.output,
            <-.<-.Graph#4.output,<-.<-.Graph#5.output
         };
         input2<NEportLevels={3,0}> => <-.<-.XYAxis.mlink;
      };
      UIpanel panel<NEx=11.,NEy=110.,instanced=0> {
         parent<NEportLevels={3,0}> => <-.<-.GeneralGraph;
         y = 30;
         width => <-.<-.GeneralGraph.width;
         height => <-.<-.GeneralGraph.height;
      };
      macro GraphWorldUI {
         UItoggle clip_toggle {
            y = 0;
            parent => <-.<-.panel;
            set => <-.<-.World_params.clip_toggle;
         };
         UIfield X_min {
            x => <-.X_min_label.x;
            y => <-.X_min_label.y + <-.X_min_label.height;
            width = 50;
            parent => <-.<-.panel;
            value<NEportLevels={2,2}> => <-.<-.World_params.X_min;
         };
         UIlabel X_min_label {
            y => <-.Y_max.y + <-.Y_max.height;
            width = 80;
            parent => <-.<-.panel;
            label => "X region min";
            alignment = "left";
         };
         UIfield X_max {
            y => <-.X_max_label.y + <-.X_max_label.height;
            width = 50;
            parent => <-.<-.panel;
            value<NEportLevels={2,2}> => <-.<-.World_params.X_max;
         };
         UIlabel X_max_label {
            y => <-.X_min.y + <-.X_min.height;
            width = 80;
            parent => <-.<-.panel;
            label => "X region max";
            alignment = "left";
         };
         UIfield Y_min {
            y => <-.Y_min_label.y + <-.Y_min_label.height;
            width = 50;
            parent => <-.<-.panel;
            value<NEportLevels={2,2}> => <-.<-.World_params.Y_min;
         };
         UIlabel Y_min_label {
            y => <-.clip_toggle.y + <-.clip_toggle.height;
            width = 80;
            parent => <-.<-.panel;
            label => "Y region min";
            alignment = "left";
         };
         UIfield Y_max {
            y => <-.Y_max_label.y + <-.Y_max_label.height;
            width = 50;
            parent => <-.<-.panel;
            value<NEportLevels={2,2}> => <-.<-.World_params.Y_max;
         };
         UIlabel Y_max_label {
            y => <-.Y_min.y + <-.Y_min.height;
            width = 80;
            parent => <-.<-.panel;
            label => "Y region max";
            alignment = "left";
         };
         UIradioBoxLabel scale_type_X {
            parent => <-.<-.panel;
            labels => <-.type;
            selectedItem => <-.<-.World_params.scale_type_X;
            y => (<-.X_max.y + <-.X_max.height) + 5;
         };
         UIradioBoxLabel scale_type_Y {
            parent => <-.<-.panel;
            labels => <-.type;
            selectedItem => <-.<-.World_params.scale_type_Y;
            y => <-.scale_type_X.y + <-.scale_type_X.height;
         };
         string type<NEportLevels=1>[] = {"linear","log10","power"};
      };
      GMOD.instancer instancer<NEx=319.,NEy=33.> {
         Value = 1;
         Group => <-.GraphWorldUI;
      };
      group World_params<export_all=2,NEx=473.,NEy=33.> {
         int clip_toggle<NEportLevels={2,2}> = 0;
         float Y_min<NEportLevels={2,2}> = 0.;
         float Y_max<NEportLevels={2,2}> = 0.;
         float X_min<NEportLevels={2,2}> = 0.;
         float X_max<NEportLevels={2,2}> = 0.;
         int scale_type_X<NEportLevels={2,2}> = 0;
         int scale_type_Y<NEportLevels={2,2}> = 0;
      };
      link out<NEportLevels={1,2}> => AGGraphWorld;
   };
   macro GraphLegend<NEx=341.,NEy=176.> {
      AGGraphLegend AGGraphLegend {
         visibility => <-.LegendUI.Position_UI.visible.set;
         geometry => {
            <-.LegendUI.Position_UI.position_x.value,
            <-.LegendUI.Position_UI.position_y.value};
         fillColor => <-.LegendUI.Frame_UI.FillColor.cmdList[<-.LegendUI.Frame_UI.FillColor.selectedItem].label;
         frameColor => <-.LegendUI.Frame_UI.FrameColor.cmdList[<-.LegendUI.Frame_UI.FrameColor.selectedItem].label;
         frameWidth => <-.LegendUI.Frame_UI.Frame_Width.value;
         labelHeight => <-.LegendUI.Label_UI.Label_Height.value;
         labelColor => <-.LegendUI.Label_UI.Label_Color.cmdList[<-.LegendUI.Label_UI.Label_Color.selectedItem].label;
         numColumns => <-.LegendUI.Label_UI.Number_of_Column.value;
         title => <-.LegendUI.Title_UI.Title.text;
         titleHeight => <-.LegendUI.Title_UI.Title_Height.value;
         titleColor => <-.LegendUI.Title_UI.Title_Color.cmdList[<-.LegendUI.Title_UI.Title_Color.selectedItem].label;
         graphs<NEportLevels={3,0}> => {
            <-.<-.Graph#1.output,<-.<-.Graph#2.output,<-.<-.Graph#3.output,
            <-.<-.Graph#4.output,<-.<-.Graph#5.output
         };
      };
      UIpanel panel<instanced=0> {
         y = 30;
         width => <-.<-.GeneralGraph.width;
         height => <-.<-.GeneralGraph.height;
         parent<NEportLevels={3,0}> => <-.<-.GeneralGraph;
      };
      macro LegendUI {
         macro Frame_UI {
            UIframe UIframe_Frame {
               parent => <-.<-.<-.panel;
               x = 5;
               y => (<-.<-.Position_UI.UIframe_Position.y + <-.<-.Position_UI.UIframe_Position.height) + 10;
               width = 245;
               height => (<-.Frame_Width.y + <-.Frame_Width.height) + 10;
            };
            UIoptionMenu FillColor {
               parent => <-.UIframe_Frame;
               cmdList => <-.<-.color1;
               x = 0;
               y = 0;
               selectedItem => <-.<-.<-.Legend_params.FillColor;
            };
            UIoptionMenu FrameColor {
               parent => <-.UIframe_Frame;
               x = 0;
               y => (<-.FillColor.y + <-.FillColor.height) + 10;
               cmdList => <-.<-.color2;
               selectedItem => <-.<-.<-.Legend_params.FrameColor;
            };
            UIslider Frame_Width {
               parent => <-.UIframe_Frame;
               value<NEportLevels={2,2}> => <-.<-.<-.Legend_params.Frame_Width;
               y => (<-.FrameColor.y + <-.FrameColor.height) + 20;
               width = 150;
               min = 0.;
               max = 4.;
            };
            UIfield Frame_Width_Typein {
               parent => <-.UIframe_Frame;
               value<NEportLevels={2,2}> => <-.Frame_Width.value;
               x => <-.Frame_Width.width + 5;
               y => <-.Frame_Width.y;
               width = 50;
            };
         };
         macro Label_UI {
            UIframe UIframe_Label {
               parent => <-.<-.<-.panel;
               x = 5;
               y => (<-.<-.Frame_UI.UIframe_Frame.y + <-.<-.Frame_UI.UIframe_Frame.height) + 10;
               width = 245;
               height => (<-.Label_Color.y + <-.Label_Color.height) + 10;
            };
            UIslider Label_Height {
               parent => <-.UIframe_Label;
               value<NEportLevels={2,2}> => <-.<-.<-.Legend_params.Label_Height;
               y = 0;
               width = 150;
               min = 0.;
               max = 5.;
            };
            UIfield Label_Height_typein {
               parent => <-.UIframe_Label;
               value<NEportLevels={2,2}> => <-.Label_Height.value;
               x => <-.Label_Height.width + 5;
               y => <-.Label_Height.y;
               width = 50;
            };
            UIfield Number_of_Column {
               parent => <-.UIframe_Label;
               value<NEportLevels={2,2}> => <-.<-.<-.Legend_params.Number;
               y => (<-.Label_Height.y + <-.Label_Height.height) + 10;
               min = 1.;
               max = 5.;
               decimalPoints = 0;
            };
            UIlabel NColumun_label {
               parent => <-.UIframe_Label;
               label => "Number of Column";
               x = 120;
               y => <-.Number_of_Column.y;
            };
            UIoptionMenu Label_Color {
               parent => <-.UIframe_Label;
               y => (<-.Number_of_Column.y + <-.Number_of_Column.height) + 10;
               cmdList => <-.<-.color3;
               selectedItem => <-.<-.<-.Legend_params.Label_Color;
               x = 0;
            };
         };
         macro Title_UI {
            UIframe UIframe_Title {
               parent => <-.<-.<-.panel;
               x = 5;
               y => (<-.<-.Label_UI.UIframe_Label.y + <-.<-.Label_UI.UIframe_Label.height) + 10;
               width = 245;
               height => (<-.Title_Color.y + <-.Title_Color.height) + 10;
            };
            UIslider Title_Height {
               parent => <-.UIframe_Title;
               value<NEportLevels={2,2}> => <-.<-.<-.Legend_params.Title_Height;
               y => (<-.Title.y + <-.Title.height) + 10;
               width = 150;
               min = 0.;
               max = 10.;
            };
            UIfield Title_Height_Typein {
               parent => <-.UIframe_Title;
               value<NEportLevels={2,2}> => <-.Title_Height.value;
               x => <-.Title_Height.width + 5;
               y => <-.Title_Height.y;
               width = 50;
            };
            UIoptionMenu Title_Color {
               parent => <-.UIframe_Title;
               y => (<-.Title_Height.y + <-.Title_Height.height) + 10;
               cmdList => <-.<-.color4;
               selectedItem => <-.<-.<-.Legend_params.Title_Color;
               x = 0;
            };
            UItext Title {
               parent => <-.UIframe_Title;
               text => <-.<-.<-.Legend_params.Title;
               y = 0;
            };
            UIlabel Title_label {
               parent => <-.UIframe_Title;
               label => "Title";
               x = 120;
               y => <-.Title.y;
            };
         };
         UIoption color1[12] = {
            {
               label="antibackground",,,,,,,,,,,
            },
            {
               set=1,,,,,,,,,label="background",,,,,,,,,,,
            },
            {
               label="red",,,,,,,,,,,
            },
            {
               label="green",,,,,,,,,,,
            },
            {
               label="blue",,,,,,,,,,,
            },
            {
               label="yellow",,,,,,,,,,,
            },
            {
               label="magenta",,,,,,,,,,,
            },
            {
               label="cyan",,,,,,,,,,,
            },
            {
               label="black",,,,,,,,,,,
            },
            {
               label="white",,,,,,,,,,,
            },
            {
               label="grey",,,,,,,,,,,
            }
         };
         UIoption color2[12] = {
            {
               set=1,,,,,,,,,label="antibackground",,,,,,,,,,,
            },
            {
               label="background",,,,,,,,,,,
            },
            {
               label="red",,,,,,,,,,,
            },
            {
               label="green",,,,,,,,,,,
            },
            {
               label="blue",,,,,,,,,,,
            },
            {
               label="yellow",,,,,,,,,,,
            },
            {
               label="magenta",,,,,,,,,,,
            },
            {
               label="cyan",,,,,,,,,,,
            },
            {
               label="black",,,,,,,,,,,
            },
            {
               label="white",,,,,,,,,,,
            },
            {
               label="grey",,,,,,,,,,,
            }
         };
         UIoption color3[12] = {
            {
               set=1,,,,,,,,,label="antibackground",,,,,,,,,,,
            },
            {
               label="background",,,,,,,,,,,
            },
            {
               label="red",,,,,,,,,,,
            },
            {
               label="green",,,,,,,,,,,
            },
            {
               label="blue",,,,,,,,,,,
            },
            {
               label="yellow",,,,,,,,,,,
            },
            {
               label="magenta",,,,,,,,,,,
            },
            {
               label="cyan",,,,,,,,,,,
            },
            {
               label="black",,,,,,,,,,,
            },
            {
               label="white",,,,,,,,,,,
            },
            {
               label="grey",,,,,,,,,,,
            }
         };
         UIoption color4[12] = {
            {
               set=1,,,,,,,,,label="antibackground",,,,,,,,,,,
            },
            {
               label="background",,,,,,,,,,,
            },
            {
               label="red",,,,,,,,,,,
            },
            {
               label="green",,,,,,,,,,,
            },
            {
               label="blue",,,,,,,,,,,
            },
            {
               label="yellow",,,,,,,,,,,
            },
            {
               label="magenta",,,,,,,,,,,
            },
            {
               label="cyan",,,,,,,,,,,
            },
            {
               label="black",,,,,,,,,,,
            },
            {
               label="white",,,,,,,,,,,
            },
            {
               label="grey",,,,,,,,,,,
            }
         };
         macro Position_UI {
            UIfield position_x {
               y => (<-.visible.y + <-.visible.height) + 5;
               parent => <-.UIframe_Position;
               value<NEportLevels={2,2}> => <-.<-.<-.Legend_params.Legend_X;
            };
            UIfield position_y {
               y => (<-.position_x.y + .height) + 10;
               parent => <-.UIframe_Position;
               value<NEportLevels={2,2}> => <-.<-.<-.Legend_params.Legend_Y;
            };
            UItoggle visible {
               y = 0;
               width = 120;
               parent => <-.UIframe_Position;
               label => "Legend on/off";
               set => <-.<-.<-.Legend_params.Legend_on_off;
            };
            UIframe UIframe_Position {
               parent => <-.<-.<-.panel;
               x = 5;
               y = 0;
               width = 245;
               height => (<-.position_y.y + <-.position_y.height) + 10;
            };
            UIlabel position_x_label {
               parent => <-.UIframe_Position;
               label => "Legend X position";
               x = 120;
               y => <-.position_x.y;
            };
            UIlabel position_y_label {
               label => "Legend Y position";
               x = 120;
               y => <-.position_y.y;
               parent => <-.UIframe_Position;
            };
         };
      };
      GMOD.instancer inst_LegendUI {
         Value = 1;
         Group => <-.LegendUI;
      };
      group Legend_params<export_all=2> {
         int Legend_on_off<NEportLevels={2,2}> = 1;
         float Legend_X<NEportLevels={2,2}> = 5.5;
         float Legend_Y<NEportLevels={2,2}> = -3.;
         int FillColor<NEportLevels={2,2}> = 1;
         int FrameColor<NEportLevels={2,2}> = 0;
         float Frame_Width<NEportLevels={2,2}> = 0.1;
         float Label_Height<NEportLevels={2,2}> = 2.;
         int Number<NEportLevels={2,2}> = 1;
         int Label_Color<NEportLevels={2,2}> = 0;
         string Title<NEportLevels={2,2}> = "Title";
         float Title_Height<NEportLevels={2,2}> = 4.;
         int Title_Color<NEportLevels={2,2}> = 0;
      };
      link obj<NEportLevels={1,2}> => AGGraphLegend;
   };
   macro XYAxis<NEx=187.,NEy=77.> {
      macro XAxis {
         macro XAxle_UI {
            UItoggle Axle_on_off {
               y = 0;
               parent => <-.UIframe_Axle;
               label => "Axle on/off";
               set => <-.<-.<-.X_Axis_params.Axle_on_off;
            };
            UIfield Yposition {
               y => (<-.Axle_on_off.y + <-.Axle_on_off.height) + 10;
               parent => <-.UIframe_Axle;
               value<NEportLevels={2,2}> => <-.<-.<-.X_Axis_params.Y_Axis_pos;
            };
            UIlabel Yposition_label {
               x => <-.<-.XText_UI.Axis_text.width + 10;
               y => <-.Yposition.y;
               height => (UIdata.UIfonts[0].lineHeight + 20);
               parent => <-.UIframe_Axle;
               label => "Y Axis \ncrossing position";
            };
            UIfield Axle_width_typein {
               x => <-.Axle_width.width + 5;
               y => <-.Axle_width.y;
               width = 40;
               parent => <-.UIframe_Axle;
               value<NEportLevels={2,2}> => <-.Axle_width.value;
            };
            UIslider Axle_width {
               y => (<-.Yposition.y + <-.Yposition.height) + 10;
               parent => <-.UIframe_Axle;
               min = 0.01;
               max = 20.;
               value<NEportLevels={2,2}> => <-.<-.<-.X_Axis_params.Axle_width;
               title => "Axle width";
            };
            UIoptionMenu Axle_color {
               x = 0;
               y => (<-.Axle_width.y + <-.Axle_width.height) + 10;
               width => .UIradioBox.y + .UIradioBox.height;
               height = 20;
               parent => <-.UIframe_Axle;
               cmdList => <-.<-.<-.color1;
               selectedItem => <-.<-.<-.X_Axis_params.Axle_color;
            };
            UIframe UIframe_Axle<NEx=242.,NEy=66.> {
               x = 5;
               y => <-.<-.<-.panelY;
               width = 245;
               height => (<-.Axle_color.y + <-.Axle_color.height) + 20;
               parent<NEdisplayMode="open"> => <-.<-.<-.panel;
            };
         };
         macro XText_UI {
            UItext Axis_text {
               y => (<-.Text_color.y + <-.Text_color.height) + 10;
               parent => <-.UIframe_Text;
               text => <-.<-.<-.X_Axis_params.X_Axis_text;
            };
            UIlabel Axis_text_label {
               x => <-.Axis_text.width + 10;
               y => <-.Axis_text.y;
               parent => <-.UIframe_Text;
               label => "X Axis Text";
            };
            UIslider Text_Height_slider {
               y => (<-.reverse_text_alignment.y + <-.reverse_text_alignment.height) + 10;
               parent => <-.UIframe_Text;
               min = 0.;
               max = 10.;
               value<NEportLevels={2,2}> => <-.<-.<-.X_Axis_params.text_height;
               title => "Text height";
            };
            UIfield Text_Height_typein {
               x => <-.Text_Height_slider.width + 5;
               y => <-.Text_Height_slider.y;
               width = 40;
               parent => <-.UIframe_Text;
               value<NEportLevels={2,2}> => <-.Text_Height_slider.value;
            };
            UItoggle reverse_text_alignment {
               y = 0;
               width => <-.UIframe_Text.width - 5;
               parent => <-.UIframe_Text;
               set => <-.<-.<-.X_Axis_params.reverse_text;
            };
            UIframe UIframe_Text {
               x => <-.<-.XAxle_UI.UIframe_Axle.x;
               y => (<-.<-.XAxle_UI.UIframe_Axle.y + <-.<-.XAxle_UI.UIframe_Axle.height) + 10;
               width => <-.<-.XAxle_UI.UIframe_Axle.width;
               height => (<-.Axis_text.y + <-.Axis_text.height) + 20;
               parent<NEdisplayMode="open"> => <-.<-.<-.panel;
            };
            UIoptionMenu Text_color {
               x = 0;
               y => (<-.Text_Height_slider.y + <-.Text_Height_slider.height) + 10;
               width => .UIradioBox.y + .UIradioBox.height;
               height = 20;
               parent => <-.UIframe_Text;
               cmdList => <-.<-.<-.color2;
               selectedItem => <-.<-.<-.X_Axis_params.Text_color;
            };
         };
         macro XLabel_UI {
            UIoptionMenu Label_color {
               x = 0;
               y => (<-.Label_Height_slider.y + <-.Label_Height_slider.height) + 10;
               width => .UIradioBox.y + .UIradioBox.height;
               height = 20;
               parent => <-.UIframe_Label;
               cmdList => <-.<-.<-.color3;
               selectedItem => <-.<-.<-.X_Axis_params.Label_color;
            };
            UIframe UIframe_Label {
               x => <-.<-.XAxle_UI.UIframe_Axle.x;
               y => (<-.<-.XText_UI.UIframe_Text.y + <-.<-.XText_UI.UIframe_Text.height) + 10;
               width => <-.<-.XAxle_UI.UIframe_Axle.width;
               height => (<-.Label_Decimals.y + <-.Label_Decimals.height) + 20;
               parent<NEdisplayMode="open"> => <-.<-.<-.panel;
            };
            UIslider Label_Height_slider {
               y = 0;
               parent => <-.UIframe_Label;
               min = 0.;
               max = 10.;
               value<NEportLevels={2,2}> => <-.<-.<-.X_Axis_params.label_height;
               title => "Label height";
            };
            UIfield Label_Height_typein {
               x => <-.Label_Height_slider.width + 5;
               y => <-.Label_Height_slider.y;
               width = 40;
               parent => <-.UIframe_Label;
               value<NEportLevels={2,2}> => <-.Label_Height_slider.value;
            };
            UIslider Label_Decimals {
               y => (<-.Label_color.y + <-.Label_color.height) + 10;
               parent => <-.UIframe_Label;
               min = 0.;
               max = 10.;
               value<NEportLevels={2,2}> => <-.<-.<-.X_Axis_params.label_Decimals;
               decimalPoints = 0;
               title => "Label Decimals";
            };
         };
         macro XTickLine_UI {
            UItoggle Major_Tick_on_off {
               y = 0;
               width = 120;
               parent => <-.UIframe_MajorTick;
               label => "X Tickline on/off";
               set => <-.<-.<-.X_Axis_params.X_Tickline_on_off;
            };
            UIframe UIframe_MajorTick {
               x => <-.<-.XAxle_UI.UIframe_Axle.x;
               y => (<-.<-.XLabel_UI.UIframe_Label.y + <-.<-.XLabel_UI.UIframe_Label.height) + 10;
               width => <-.<-.XAxle_UI.UIframe_Axle.width;
               height => (<-.Minor_tick_color.y + <-.Minor_tick_color.height) + 10;
               parent<NEdisplayMode="open"> => <-.<-.<-.panel;
            };
            UIfield major_step {
               y => (<-.Major_Tick_on_off.y + <-.Major_Tick_on_off.height) + 10;
               parent => <-.UIframe_MajorTick;
               value<NEportLevels={2,2}> => <-.<-.<-.X_Axis_params.Steps_for_Major;
            };
            UIlabel major_step_label {
               x => (<-.major_step.x + <-.major_step.width) + 20;
               y => <-.major_step.y;
               height => (UIdata.UIfonts[0].lineHeight + 0) + 10;
               parent => <-.UIframe_MajorTick;
               label => "Steps for \nMajor tick marks";
            };
            UIfield minor_step {
               y => (<-.major_step.y + <-.major_step.height) + 10;
               parent => <-.UIframe_MajorTick;
               value<NEportLevels={2,2}> => <-.<-.<-.X_Axis_params.Steps_for_Minor;
               decimalPoints = 0;
            };
            UIlabel minor_step_label {
               x => (<-.minor_step.x + <-.minor_step.width) + 20;
               y => <-.minor_step.y;
               height => (UIdata.UIfonts[0].lineHeight + 0) + 10;
               parent => <-.UIframe_MajorTick;
               label => "Steps for \nMinor tick marks";
            };
            UIslider Major_tick_width {
               y => (<-.minor_step.y + <-.minor_step.height) + 10;
               parent => <-.UIframe_MajorTick;
               min = 0.01;
               max = 20.;
               value<NEportLevels={2,2}> => <-.<-.<-.X_Axis_params.Major_tick_width;
            };
            UIfield Major_tick_typein {
               x => <-.Major_tick_width.width + 5;
               y => <-.Major_tick_width.y;
               width = 40;
               parent => <-.UIframe_MajorTick;
               value<NEportLevels={2,2}> => <-.Major_tick_width.value;
            };
            UIslider Minor_tick_width {
               y => (<-.Major_tick_width.y + <-.Major_tick_width.height) + 10;
               parent => <-.UIframe_MajorTick;
               min = 0.01;
               max = 20.;
               value<NEportLevels={2,2}> => <-.<-.<-.X_Axis_params.Minor_tick_width;
            };
            UIfield Minor_tick_typein {
               x => <-.Minor_tick_width.width + 5;
               y => <-.Minor_tick_width.y;
               width = 40;
               parent => <-.UIframe_MajorTick;
               value<NEportLevels={2,2}> => <-.Minor_tick_width.value;
            };
            UIoptionMenu Major_tick_style {
               x = 0;
               y => (<-.Minor_tick_width.y + <-.Minor_tick_width.height) + 20;
               parent => <-.UIframe_MajorTick;
               cmdList => <-.<-.<-.style1;
               selectedItem => <-.<-.<-.X_Axis_params.Major_tick_style;
            };
            UIoptionMenu Minor_tick_style {
               x = 0;
               y => <-.Major_tick_color.y + <-.Major_tick_color.height;
               parent => <-.UIframe_MajorTick;
               cmdList => <-.<-.<-.style2;
               selectedItem => <-.<-.<-.X_Axis_params.Minor_tick_style;
            };
            UIoptionMenu Major_tick_color {
               x = 0;
               y => <-.Major_tick_style.y + <-.Major_tick_style.height;
               parent => <-.UIframe_MajorTick;
               cmdList => <-.<-.<-.color4;
               selectedItem => <-.<-.<-.X_Axis_params.Major_tick_color;
            };
            UIoptionMenu Minor_tick_color {
               x = 0;
               y => <-.Minor_tick_style.y + <-.Minor_tick_style.height;
               parent => <-.UIframe_MajorTick;
               cmdList => <-.<-.<-.color5;
               selectedItem => <-.<-.<-.X_Axis_params.Minor_tick_color;
            };
            boolean valuesX_used => array_size(<-.<-.Graph_in.valuesX);
         };
      };
      macro YAxis<instanced=0> {
         macro YAxle_UI {
            UItoggle Axle_on_off {
               y = 0;
               parent => <-.UIframe_Axle;
               label => "Axle on/off";
               set => <-.<-.<-.Y_Axis_params.Axle_on_off;
            };
            UIfield Yposition {
               y => (<-.Axle_on_off.y + <-.Axle_on_off.height) + 10;
               parent => <-.UIframe_Axle;
               value<NEportLevels={2,2}> => <-.<-.<-.Y_Axis_params.X_Axis_pos;
            };
            UIlabel Yposition_label {
               x => <-.<-.YText_UI.Axis_text.width + 10;
               y => <-.Yposition.y;
               height => (UIdata.UIfonts[0].lineHeight + 20);
               parent => <-.UIframe_Axle;
               label => "X Axis \ncrossing position";
            };
            UIfield Axle_width_typein {
               x => <-.Axle_width.width + 5;
               y => <-.Axle_width.y;
               width = 40;
               parent => <-.UIframe_Axle;
               value<NEportLevels={2,2}> => <-.Axle_width.value;
            };
            UIslider Axle_width {
               y => (<-.Yposition.y + <-.Yposition.height) + 10;
               parent => <-.UIframe_Axle;
               min = 0.01;
               max = 20.;
               value<NEportLevels={2,2}> => <-.<-.<-.Y_Axis_params.Axle_width;
               title => "Axle width";
            };
            UIoptionMenu Axle_color {
               x = 0;
               y => (<-.Axle_width.y + <-.Axle_width.height) + 10;
               width => .UIradioBox.y + .UIradioBox.height;
               height = 20;
               parent => <-.UIframe_Axle;
               cmdList => <-.<-.<-.color1;
               selectedItem => <-.<-.<-.Y_Axis_params.Axle_color;
            };
            UIframe UIframe_Axle<NEx=187.,NEy=33.> {
               x = 5;
               y => <-.<-.<-.panelY;
               width = 245;
               height => (<-.Axle_color.y + <-.Axle_color.height) + 20;
               parent<NEdisplayMode="open"> => <-.<-.<-.panel;
            };
         };
         macro YText_UI {
            UItext Axis_text {
               y => (<-.Text_color.y + <-.Text_color.height) + 10;
               parent => <-.UIframe_Text;
               text => <-.<-.<-.Y_Axis_params.Y_Axis_text;
            };
            UIlabel Axis_text_label<NEx=154.,NEy=143.> {
               x => <-.Axis_text.width + 10;
               y => <-.Axis_text.y;
               parent => <-.UIframe_Text;
               label => "Y Axis Text";
            };
            UIslider Text_Height_slider<NEx=297.,NEy=143.> {
               y => (<-.reverse_text_alignment.y + <-.reverse_text_alignment.height) + 10;
               parent => <-.UIframe_Text;
               min = 0.;
               max = 10.;
               value<NEportLevels={2,2}> => <-.<-.<-.Y_Axis_params.text_height;
               title => "Text height";
            };
            UIfield Text_Height_typein {
               x => <-.Text_Height_slider.width + 5;
               y => <-.Text_Height_slider.y;
               width = 40;
               parent => <-.UIframe_Text;
               value<NEportLevels={2,2}> => <-.Text_Height_slider.value;
            };
            UItoggle reverse_text_alignment {
               y = 0;
               width => <-.UIframe_Text.width - 5;
               parent => <-.UIframe_Text;
               set => <-.<-.<-.Y_Axis_params.reverse_text;
            };
            UIframe UIframe_Text {
               x => <-.<-.YAxle_UI.UIframe_Axle.x;
               y => (<-.<-.YAxle_UI.UIframe_Axle.y + <-.<-.YAxle_UI.UIframe_Axle.height) + 10;
               width => <-.<-.YAxle_UI.UIframe_Axle.width;
               height => (<-.Axis_text.y + <-.Axis_text.height) + 20;
               parent<NEdisplayMode="open"> => <-.<-.<-.panel;
            };
            UIoptionMenu Text_color {
               x = 0;
               y => (<-.Text_Height_slider.y + <-.Text_Height_slider.height) + 10;
               width => .UIradioBox.y + .UIradioBox.height;
               height = 20;
               parent => <-.UIframe_Text;
               cmdList => <-.<-.<-.color2;
               selectedItem => <-.<-.<-.Y_Axis_params.Text_color;
            };
         };
         macro YLabel_UI {
            UIoptionMenu Label_color {
               x = 0;
               y => (<-.Label_Height_slider.y + <-.Label_Height_slider.height) + 10;
               width => .UIradioBox.y + .UIradioBox.height;
               height = 20;
               parent => <-.UIframe_Label;
               cmdList => <-.<-.<-.color3;
               selectedItem => <-.<-.<-.Y_Axis_params.Label_color;
            };
            UIframe UIframe_Label {
               x => <-.<-.YAxle_UI.UIframe_Axle.x;
               y => (<-.<-.YText_UI.UIframe_Text.y + <-.<-.YText_UI.UIframe_Text.height) + 10;
               width => <-.<-.YAxle_UI.UIframe_Axle.width;
               height => (<-.Label_Decimals.y + <-.Label_Decimals.height) + 20;
               parent<NEdisplayMode="open"> => <-.<-.<-.panel;
            };
            UIslider Label_Height_slider {
               y = 0;
               parent => <-.UIframe_Label;
               min = 0.;
               max = 10.;
               value<NEportLevels={2,2}> => <-.<-.<-.Y_Axis_params.label_height;
               title => "Label height";
            };
            UIfield Label_Height_typein {
               x => <-.Label_Height_slider.width + 5;
               y => <-.Label_Height_slider.y;
               width = 40;
               parent => <-.UIframe_Label;
               value<NEportLevels={2,2}> => <-.Label_Height_slider.value;
            };
            UIslider Label_Decimals {
               y => (<-.Label_color.y + <-.Label_color.height) + 10;
               parent => <-.UIframe_Label;
               min = 0.;
               max = 10.;
               value<NEportLevels={2,2}> => <-.<-.<-.Y_Axis_params.label_Decimals;
               decimalPoints = 0;
               title => "Label Decimals";
            };
         };
         macro YTickLine_UI {
            UItoggle Major_Tick_on_off {
               y = 0;
               width = 120;
               parent => <-.UIframe_MajorTick;
               label => "Y Tickline on/off";
               set => <-.<-.<-.Y_Axis_params.Y_Tickline_on_off;
            };
            UIframe UIframe_MajorTick {
               x => <-.<-.YAxle_UI.UIframe_Axle.x;
               y => (<-.<-.YLabel_UI.UIframe_Label.y + <-.<-.YLabel_UI.UIframe_Label.height) + 10;
               width => <-.<-.YAxle_UI.UIframe_Axle.width;
               height => (<-.Minor_tick_color.y + <-.Minor_tick_color.height) + 10;
               parent<NEdisplayMode="open"> => <-.<-.<-.panel;
            };
            UIfield major_step {
               y => (<-.Major_Tick_on_off.y + <-.Major_Tick_on_off.height) + 10;
               parent => <-.UIframe_MajorTick;
               value<NEportLevels={2,2}> => <-.<-.<-.Y_Axis_params.Steps_for_Major;
            };
            UIlabel major_step_label {
               x => (<-.major_step.x + <-.major_step.width) + 20;
               y => <-.major_step.y;
               height => (UIdata.UIfonts[0].lineHeight + 0) + 10;
               parent => <-.UIframe_MajorTick;
               label => "Steps for \nMajor tick marks";
            };
            UIfield minor_step {
               y => (<-.major_step.y + <-.major_step.height) + 10;
               parent => <-.UIframe_MajorTick;
               value<NEportLevels={2,2}> => <-.<-.<-.Y_Axis_params.Steps_for_Minor;
               decimalPoints = 0;
            };
            UIlabel minor_step_label {
               x => (<-.minor_step.x + <-.minor_step.width) + 20;
               y => <-.minor_step.y;
               height => (UIdata.UIfonts[0].lineHeight + 0) + 10;
               parent => <-.UIframe_MajorTick;
               label => "Steps for \nMinor tick marks";
            };
            UIslider Major_tick_width {
               y => (<-.minor_step.y + <-.minor_step.height) + 10;
               parent => <-.UIframe_MajorTick;
               min = 0.01;
               max = 20.;
               value<NEportLevels={2,2}> => <-.<-.<-.Y_Axis_params.Major_tick_width;
            };
            UIfield Major_tick_typein {
               x => <-.Major_tick_width.width + 5;
               y => <-.Major_tick_width.y;
               width = 40;
               parent => <-.UIframe_MajorTick;
               value<NEportLevels={2,2}> => <-.Major_tick_width.value;
            };
            UIslider Minor_tick_width {
               y => (<-.Major_tick_width.y + <-.Major_tick_width.height) + 10;
               parent => <-.UIframe_MajorTick;
               min = 0.01;
               max = 20.;
               value<NEportLevels={2,2}> => <-.<-.<-.Y_Axis_params.Minor_tick_width;
            };
            UIfield Minor_tick_typein {
               x => <-.Minor_tick_width.width + 5;
               y => <-.Minor_tick_width.y;
               width = 40;
               parent => <-.UIframe_MajorTick;
               value<NEportLevels={2,2}> => <-.Minor_tick_width.value;
            };
            UIoptionMenu Major_tick_style {
               x = 0;
               y => (<-.Minor_tick_width.y + <-.Minor_tick_width.height) + 20;
               parent => <-.UIframe_MajorTick;
               cmdList => <-.<-.<-.style1;
               selectedItem => <-.<-.<-.Y_Axis_params.Major_tick_style;
            };
            UIoptionMenu Minor_tick_style {
               x = 0;
               y => <-.Major_tick_color.y + <-.Major_tick_color.height;
               parent => <-.UIframe_MajorTick;
               cmdList => <-.<-.<-.style2;
               selectedItem => <-.<-.<-.Y_Axis_params.Minor_tick_style;
            };
            UIoptionMenu Major_tick_color {
               x = 0;
               y => <-.Major_tick_style.y + <-.Major_tick_style.height;
               parent => <-.UIframe_MajorTick;
               cmdList => <-.<-.<-.color4;
               selectedItem => <-.<-.<-.Y_Axis_params.Major_tick_color;
            };
            UIoptionMenu Minor_tick_color {
               x = 0;
               y => <-.Minor_tick_style.y + <-.Minor_tick_style.height;
               parent => <-.UIframe_MajorTick;
               cmdList => <-.<-.<-.color5;
               selectedItem => <-.<-.<-.Y_Axis_params.Minor_tick_color;
            };
         };
      };
      GMOD.instancer inst_XAxis<NEx=297.,NEy=22.> {
         Value => ((<-.Axis.selectedItem == 0) && (<-.panel.visible == 1));
         Group => <-.XAxis;
      };
      GMOD.instancer inst_YAxis<NEx=605.,NEy=22.> {
         Value => ((<-.Axis.selectedItem == 1) && (<-.panel.visible == 1));
         Group => <-.YAxis;
      };
      macro Axis<NEx=451.,NEy=22.> {
         ilink parent<NEportLevels={2,1},NEx=5.,NEy=23.> => <-.panel;
         imlink labels<NEx=155.,NEy=23.> => <-.axis;
         int selectedItem<NEportLevels={2,0},NEx=305.,NEy=23.> = 0;
         string+nres selectedString<NEportLevels={2,0}> => labels[.selectedItem];
         string title<NEx=455.,NEy=23.> => name_of(<-,1);
         int visible<NEx=605.,NEy=23.> = 1;
         int active<NEx=5.,NEy=98.> = 1;
         int x<NEx=155.,NEy=98.> = 0;
         int y<NEx=305.,NEy=98.> = 0;
         int width<NEx=455.,NEy=98.> = 200;
         int height<NEx=605.,NEy=98.> => .UIradioBox.y + .UIradioBox.height;
         label_cmd label_cmd<NEx=261.,NEy=173.> {
            labels => <-.labels;
            cmd[2] {
               active => <-.<-.active;
            };
            inItem => <-.selectedItem;
            outItem => inItem;
         };
         UIpanel UIpanel<NEx=88.,NEy=198.> {
            x => <-.x;
            y => <-.y;
            width => <-.width;
            height => <-.height;
            parent => <-.parent;
         };
         UIradioBox UIradioBox<NEx=88.,NEy=297.> {
            y = 4;
            width => <-.UIpanel.width;
            &visible => <-.visible;
            parent => <-.UIpanel;
            cmdList => <-.label_cmd.cmd;
            selectedItem => <-.label_cmd.outItem;
         };
      };
      string axis[] = {"XAxis","YAxis"};
      float panelX => .Axis.x;
      float panelY = 64.;
      mlink mlink<NEportLevels={1,2}> => {.AGXAxis,
         .AGXTicklines,.AGYAxis,.AGYTicklines};
      AGXAxis AGXAxis {
         visibility => <-.XAxis.XAxle_UI.Axle_on_off.set;
         majorTickColor => <-.XAxis.XTickLine_UI.Major_tick_color.cmdList[<-.XAxis.XTickLine_UI.Major_tick_color.selectedItem].label;
         majorTickLineStyle => <-.XAxis.XTickLine_UI.Major_tick_style.selectedItem;
         majorTickOn = 1;
         majorTickWidth => <-.XAxis.XTickLine_UI.Major_tick_width.value;
         minorTickColor => <-.XAxis.XTickLine_UI.Minor_tick_color.cmdList[<-.XAxis.XTickLine_UI.Minor_tick_color.selectedItem].label;
         minorTickCount => <-.XAxis.XTickLine_UI.minor_step.value;
         minorTickLineStyle => <-.XAxis.XTickLine_UI.Minor_tick_style.selectedItem;
         minorTickWidth => <-.XAxis.XTickLine_UI.Minor_tick_width.value;
         axleColor => <-.XAxis.XAxle_UI.Axle_color.cmdList[<-.XAxis.XAxle_UI.Axle_color.selectedItem].label;
         axleWidth => <-.XAxis.XAxle_UI.Axle_width.value;
         labelColor => <-.XAxis.XLabel_UI.Label_color.cmdList[<-.XAxis.XLabel_UI.Label_color.selectedItem].label;
         labelHeight => <-.XAxis.XLabel_UI.Label_Height_slider.value;
         textColor => <-.XAxis.XText_UI.Text_color.cmdList[<-.XAxis.XText_UI.Text_color.selectedItem].label;
         textHeight => <-.XAxis.XText_UI.Text_Height_slider.value;
         majorReferenceX => <-.XAxis.XTickLine_UI.major_step.value;
         majorStepX => <-.XAxis.XTickLine_UI.major_step.value;
         labelDecimals => <-.XAxis.XLabel_UI.Label_Decimals.value;
         labelMode => <-.XAxis.XText_UI.reverse_text_alignment.set;
         positionY => <-.XAxis.XAxle_UI.Yposition.value;
         text<NEportLevels={2,0}> => <-.XAxis.XText_UI.Axis_text.text;
      };
      AGXTicklines AGXTicklines {
         visibility<NEportLevels={2,0}> => <-.XAxis.XTickLine_UI.Major_Tick_on_off.set;
         majorTickColor => <-.XAxis.XTickLine_UI.Major_tick_color.cmdList[<-.XAxis.XTickLine_UI.Major_tick_color.selectedItem].label;
         majorTickLineStyle => <-.XAxis.XTickLine_UI.Major_tick_style.selectedItem;
         majorTickOn = 1;
         majorTickWidth => <-.XAxis.XTickLine_UI.Major_tick_width.value;
         minorTickColor => <-.XAxis.XTickLine_UI.Minor_tick_color.cmdList[<-.XAxis.XTickLine_UI.Minor_tick_color.selectedItem].label;
         minorTickCount => <-.XAxis.XTickLine_UI.minor_step.value;
         minorTickLineStyle => <-.XAxis.XTickLine_UI.Minor_tick_style.selectedItem;
         minorTickWidth => <-.XAxis.XTickLine_UI.Minor_tick_width.value;
         majorReferenceX => <-.XAxis.XTickLine_UI.major_step.value;
         majorStepX => <-.XAxis.XTickLine_UI.major_step.value;
      };
      AGYAxis AGYAxis<NEx=5.,NEy=173.> {
         visibility => <-.YAxis.YAxle_UI.Axle_on_off.set;
         majorTickColor => <-.YAxis.YTickLine_UI.Major_tick_color.cmdList[<-.YAxis.YTickLine_UI.Major_tick_color.selectedItem].label;
         majorTickLineStyle => <-.YAxis.YTickLine_UI.Major_tick_style.selectedItem;
         majorTickOn = 1;
         majorTickWidth => <-.YAxis.YTickLine_UI.Major_tick_width.value;
         minorTickColor => <-.YAxis.YTickLine_UI.Minor_tick_color.cmdList[<-.YAxis.YTickLine_UI.Minor_tick_color.selectedItem].label;
         minorTickCount => <-.YAxis.YTickLine_UI.minor_step.value;
         minorTickLineStyle => <-.YAxis.YTickLine_UI.Minor_tick_style.selectedItem;
         minorTickWidth => <-.YAxis.YTickLine_UI.Minor_tick_width.value;
         axleColor => <-.YAxis.YAxle_UI.Axle_color.cmdList[<-.YAxis.YAxle_UI.Axle_color.selectedItem].label;
         axleWidth => <-.YAxis.YAxle_UI.Axle_width.value;
         labelColor => <-.YAxis.YLabel_UI.Label_color.cmdList[<-.YAxis.YLabel_UI.Label_color.selectedItem].label;
         labelHeight => <-.YAxis.YLabel_UI.Label_Height_slider.value;
         textColor => <-.YAxis.YText_UI.Text_color.cmdList[<-.YAxis.YText_UI.Text_color.selectedItem].label;
         textHeight => <-.YAxis.YText_UI.Text_Height_slider.value;
         majorReferenceY => <-.YAxis.YTickLine_UI.major_step.value;
         majorStepY => <-.YAxis.YTickLine_UI.major_step.value;
         labelDecimals => <-.YAxis.YLabel_UI.Label_Decimals.value;
         labelMode => <-.YAxis.YText_UI.reverse_text_alignment.set;
         positionX => <-.YAxis.YAxle_UI.Yposition.value;
         text<NEportLevels={2,0}> => <-.YAxis.YText_UI.Axis_text.text;
      };
      AGYTicklines AGYTicklines {
         visibility<NEportLevels={2,0}> => <-.YAxis.YTickLine_UI.Major_Tick_on_off.set;
         majorTickColor => <-.YAxis.YTickLine_UI.Major_tick_color.cmdList[<-.YAxis.YTickLine_UI.Major_tick_color.selectedItem].label;
         majorTickLineStyle => <-.YAxis.YTickLine_UI.Major_tick_style.selectedItem;
         majorTickOn = 1;
         majorTickWidth => <-.YAxis.YTickLine_UI.Major_tick_width.value;
         minorTickColor => <-.YAxis.YTickLine_UI.Minor_tick_color.cmdList[<-.YAxis.YTickLine_UI.Minor_tick_color.selectedItem].label;
         minorTickCount => <-.YAxis.YTickLine_UI.minor_step.value;
         minorTickLineStyle => <-.YAxis.YTickLine_UI.Minor_tick_style.selectedItem;
         minorTickWidth => <-.YAxis.YTickLine_UI.Minor_tick_width.value;
         majorReferenceY => <-.YAxis.YTickLine_UI.major_step.value;
         majorStepY => <-.YAxis.YTickLine_UI.major_step.value;
      };
      UIoption color1[12] = {
         {
            set=1,,,,,,,,,label="antibackground",,,,,,,,,,,
         },
         {
            label="background",,,,,,,,,,,
         },
         {
            label="red",,,,,,,,,,,
         },
         {
            label="green",,,,,,,,,,,
         },
         {
            label="blue",,,,,,,,,,,
         },
         {
            label="yellow",,,,,,,,,,,
         },
         {
            label="magenta",,,,,,,,,,,
         },
         {
            label="cyan",,,,,,,,,,,
         },
         {
            label="black",,,,,,,,,,,
         },
         {
            label="white",,,,,,,,,,,
         },
         {
            label="grey",,,,,,,,,,,
         }
      };
      UIoption style1[15] = {
         {
            set=1,,,,,,,,,label="solid",,,,,,,,,,,
         },
         {
            label="dashed",,,,,,,,,,,
         },
         {
            label="dotted",,,,,,,,,,,
         },
         {
            label="dasheddotted",,,,,,,,,,,
         },
         {
            label="______________",,,,,,,,,,,
         },
         {
            label=". . . . . . .",,,,,,,,,,,
         },
         {
            label="_ _ _ _ _ _ _",,,,,,,,,,,
         },
         {
            label="__ __ __ __ __",,,,,,,,,,,
         },
         {
            label="__ . __ . __ .",,,,,,,,,,,
         },
         {
            label="_ __ _ __ _ __",,,,,,,,,,,
         },
         {
            label=".  .  .  .  .",,,,,,,,,,,
         },
         {
            label="___ ___ ___ __",,,,,,,,,,,
         },
         {
            label="_ _  _ _  _ _",,,,,,,,,,,
         },
         {
            label="__ .. __ .. __",,,,,,,,,,,
         },
         {
            label="__ ... __ ...",,,,,,,,,,,
         }
      };
      UIoption color2[12] = {
         {
            set=1,,,,,,,,,label="antibackground",,,,,,,,,,,
         },
         {
            label="background",,,,,,,,,,,
         },
         {
            label="red",,,,,,,,,,,
         },
         {
            label="green",,,,,,,,,,,
         },
         {
            label="blue",,,,,,,,,,,
         },
         {
            label="yellow",,,,,,,,,,,
         },
         {
            label="magenta",,,,,,,,,,,
         },
         {
            label="cyan",,,,,,,,,,,
         },
         {
            label="black",,,,,,,,,,,
         },
         {
            label="white",,,,,,,,,,,
         },
         {
            label="grey",,,,,,,,,,,
         }
      };
      UIoption color3[12] = {
         {
            set=1,,,,,,,,,label="antibackground",,,,,,,,,,,
         },
         {
            label="background",,,,,,,,,,,
         },
         {
            label="red",,,,,,,,,,,
         },
         {
            label="green",,,,,,,,,,,
         },
         {
            label="blue",,,,,,,,,,,
         },
         {
            label="yellow",,,,,,,,,,,
         },
         {
            label="magenta",,,,,,,,,,,
         },
         {
            label="cyan",,,,,,,,,,,
         },
         {
            label="black",,,,,,,,,,,
         },
         {
            label="white",,,,,,,,,,,
         },
         {
            label="grey",,,,,,,,,,,
         }
      };
      UIoption color4[12] = {
         {
            set=1,,,,,,,,,label="antibackground",,,,,,,,,,,
         },
         {
            label="background",,,,,,,,,,,
         },
         {
            label="red",,,,,,,,,,,
         },
         {
            label="green",,,,,,,,,,,
         },
         {
            label="blue",,,,,,,,,,,
         },
         {
            label="yellow",,,,,,,,,,,
         },
         {
            label="magenta",,,,,,,,,,,
         },
         {
            label="cyan",,,,,,,,,,,
         },
         {
            label="black",,,,,,,,,,,
         },
         {
            label="white",,,,,,,,,,,
         },
         {
            label="grey",,,,,,,,,,,
         }
      };
      UIoption color5[12] = {
         {
            set=1,,,,,,,,,label="antibackground",,,,,,,,,,,
         },
         {
            label="background",,,,,,,,,,,
         },
         {
            label="red",,,,,,,,,,,
         },
         {
            label="green",,,,,,,,,,,
         },
         {
            label="blue",,,,,,,,,,,
         },
         {
            label="yellow",,,,,,,,,,,
         },
         {
            label="magenta",,,,,,,,,,,
         },
         {
            label="cyan",,,,,,,,,,,
         },
         {
            label="black",,,,,,,,,,,
         },
         {
            label="white",,,,,,,,,,,
         },
         {
            label="grey",,,,,,,,,,,
         }
      };
      UIoption style2[15] = {
         {
            label="solid",,,,,,,,,,,
         },
         {
            set=1,,,,,,,,,label="dashed",,,,,,,,,,,
         },
         {
            label="dotted",,,,,,,,,,,
         },
         {
            label="dasheddotted",,,,,,,,,,,
         },
         {
            label="______________",,,,,,,,,,,
         },
         {
            label=". . . . . . .",,,,,,,,,,,
         },
         {
            label="_ _ _ _ _ _ _",,,,,,,,,,,
         },
         {
            label="__ __ __ __ __",,,,,,,,,,,
         },
         {
            label="__ . __ . __ .",,,,,,,,,,,
         },
         {
            label="_ __ _ __ _ __",,,,,,,,,,,
         },
         {
            label=".  .  .  .  .",,,,,,,,,,,
         },
         {
            label="___ ___ ___ __",,,,,,,,,,,
         },
         {
            label="_ _  _ _  _ _",,,,,,,,,,,
         },
         {
            label="__ .. __ .. __",,,,,,,,,,,
         },
         {
            label="__ ... __ ...",,,,,,,,,,,
         }
      };
      AGPrimitive &Graph_in<NEx=0.,NEy=330.,NEportLevels={2,0}>;
      group X_Axis_params<export_all=2> {
         int Axle_on_off<NEportLevels={2,2}> = 1;
         float Y_Axis_pos<NEportLevels={2,2}>;
         float Axle_width<NEportLevels={2,2}> = 1.33;
         int Axle_color<NEportLevels={2,2}> = 0;
         int reverse_text<NEportLevels={2,2}> = 0;
         float text_height<NEportLevels={2,2}> = 5.;
         int Text_color<NEportLevels={2,2}> = 0;
         string X_Axis_text<NEportLevels={2,2}> = "X axis text";
         float label_height<NEportLevels={2,2}> = 5.;
         int Label_color<NEportLevels={2,2}> = 0;
         float label_Decimals<NEportLevels={2,2}> = 0.;
         int X_Tickline_on_off<NEportLevels={2,2}> = 1;
         float Steps_for_Major<NEportLevels={2,2}>;
         int Steps_for_Minor<NEportLevels={2,2}> = 2;
         float Major_tick_width<NEportLevels={2,2}> = 0.8;
         float Minor_tick_width<NEportLevels={2,2}> = 0.01;
         int Major_tick_style<NEportLevels={2,2}> = 0;
         int Major_tick_color<NEportLevels={2,2}> = 0;
         int Minor_tick_style<NEportLevels={2,2}> = 1;
         int Minor_tick_color<NEportLevels={2,2}> = 0;
      };
      group Y_Axis_params<export_all=2> {
         int Axle_on_off<NEportLevels={2,2}> = 1;
         float X_Axis_pos<NEportLevels={2,2}>;
         float Axle_width<NEportLevels={2,2}> = 1.;
         int Axle_color<NEportLevels={2,2}> = 0;
         int reverse_text<NEportLevels={2,2}> = 0;
         float text_height<NEportLevels={2,2}> = 5.;
         int Text_color<NEportLevels={2,2}> = 0;
         string Y_Axis_text<NEportLevels={2,2}> = "Y axis text";
         float label_height<NEportLevels={2,2}> = 5.;
         int Label_color<NEportLevels={2,2}> = 0;
         float label_Decimals<NEportLevels={2,2}> = 0.;
         int Y_Tickline_on_off<NEportLevels={2,2}> = 1;
         float Steps_for_Major<NEportLevels={2,2}>;
         int Steps_for_Minor<NEportLevels={2,2}> = 2;
         float Major_tick_width<NEportLevels={2,2}> = 0.8;
         float Minor_tick_width<NEportLevels={2,2}> = 0.01;
         int Major_tick_style<NEportLevels={2,2}> = 0;
         int Major_tick_color<NEportLevels={2,2}> = 0;
         int Minor_tick_style<NEportLevels={2,2}> = 1;
         int Minor_tick_color<NEportLevels={2,2}> = 0;
      };
      UIpanel panel<NEx=0.,NEy=-33.,instanced=0> {
         y<NEdisplayMode="open"> = 25;
         width => <-.<-.GeneralGraph.width;
         height => <-.<-.GeneralGraph.height;
         parent<NEportLevels={3,0}> => <-.<-.GeneralGraph;
      };
   };
   macro GraphViewport<NEx=187.,NEy=187.> {
      AGGraphViewportObj AGGraphViewportObj {
         graphViewport {
            visibility => <-.<-.GraphViewport_UI.Frame_visible.set;
            frameColor => <-.<-.GraphViewport_UI.FrameColor.cmdList[<-.<-.GraphViewport_UI.FrameColor.selectedItem].label;
            frameWidth => <-.<-.GraphViewport_UI.Frame_Width.value;
            children<NEportLevels={4,0}> => {
               <-.<-.<-.GraphWorld.out,<-.<-.<-.GraphLegend.obj};
            fillColor => <-.<-.GraphViewport_UI.FillColor.cmdList[<-.<-.GraphViewport_UI.FillColor.selectedItem].label;
         };
      };
      UIpanel panel<instanced=0> {
         parent<NEportLevels={3,0}> => <-.<-.GeneralGraph;
         y = 30;
         width => <-.<-.GeneralGraph.width;
         height => <-.<-.GeneralGraph.height;
      };
      macro GraphViewport_UI {
         UItoggle Frame_visible {
            y = 0;
            width = 120;
            parent => <-.<-.panel;
            set => <-.<-.Viewport_params.Frame_visible;
         };
         UIslider Frame_Width {
            parent => <-.<-.panel;
            value<NEportLevels={2,2}> => <-.<-.Viewport_params.Frame_Width;
            y => (<-.Frame_visible.x + <-.Frame_visible.height) + 10;
            width = 150;
            min = 0.;
            max = 4.;
         };
         UIfield Frame_Width_Typein {
            parent => <-.<-.panel;
            value<NEportLevels={2,2}> => <-.Frame_Width.value;
            x => <-.Frame_Width.width + 5;
            y => <-.Frame_Width.y;
            width = 50;
         };
         UIoptionMenu FrameColor {
            parent => <-.<-.panel;
            x = 0;
            y => (<-.Frame_Width.y + <-.Frame_Width.height) + 10;
            selectedItem => <-.<-.Viewport_params.Frame_Color;
            label => "Frame Color";
            cmdList => <-.color1;
         };
         UIoptionMenu FillColor {
            parent => <-.<-.panel;
            x = 0;
            y => <-.FrameColor.y + <-.FrameColor.height;
            selectedItem => <-.<-.Viewport_params.Fill_Color;
            label => "Fill Color";
            cmdList => <-.color2;
         };
         UIoption color1[12] = {
            {
               set=1,,,,,,,,,label="antibackground",,,,,,,,,,,
            },
            {
               label="background",,,,,,,,,,,
            },
            {
               label="red",,,,,,,,,,,
            },
            {
               label="green",,,,,,,,,,,
            },
            {
               label="blue",,,,,,,,,,,
            },
            {
               label="yellow",,,,,,,,,,,
            },
            {
               label="magenta",,,,,,,,,,,
            },
            {
               label="cyan",,,,,,,,,,,
            },
            {
               label="black",,,,,,,,,,,
            },
            {
               label="white",,,,,,,,,,,
            },
            {
               label="grey",,,,,,,,,,,
            }
         };
         UIoption color2[12] = {
            {
               label="antibackground",,,,,,,,,,,
            },
            {
               set=1,,,,,,,,,label="background",,,,,,,,,,,
            },
            {
               label="red",,,,,,,,,,,
            },
            {
               label="green",,,,,,,,,,,
            },
            {
               label="blue",,,,,,,,,,,
            },
            {
               label="yellow",,,,,,,,,,,
            },
            {
               label="magenta",,,,,,,,,,,
            },
            {
               label="cyan",,,,,,,,,,,
            },
            {
               label="black",,,,,,,,,,,
            },
            {
               label="white",,,,,,,,,,,
            },
            {
               label="grey",,,,,,,,,,,
            }
         };
      };
      GMOD.instancer inst_GraphViewport_UI {
         Value = 1;
         Group => <-.GraphViewport_UI;
      };
      group Viewport_params<export_all=2> {
         int Frame_visible<NEportLevels={2,2}> = 1;
         float Frame_Width<NEportLevels={2,2}> = 1.06;
         int Frame_Color<NEportLevels={2,2}> = 0;
         int Fill_Color<NEportLevels={2,2}> = 1;
      };
      link obj<NEportLevels={1,3}> => AGGraphViewportObj.dataObject.obj;
   };
}; // General_Graph


macro General_PolarGraph {
   mlink ValuesT<NEportLevels={2,1},NEx=22.,NEy=22.>;
   link  ValuesR1<NEportLevels={2,1},NEx=22.,NEy=44.>;
   link  ValuesR2<NEportLevels={2,1},NEx=22.,NEy=44.>;
   link  ValuesR3<NEportLevels={2,1},NEx=22.,NEy=44.>;
   link  ValuesR4<NEportLevels={2,1},NEx=22.,NEy=44.>;
   link  ValuesR5<NEportLevels={2,1},NEx=22.,NEy=44.>;
   macro PolarGraph#1<NEx=22.,NEy=76.> {
      AGPolarGraph AGPolarGraph {
         visibility<NEportLevels={2,0}> => <-.GraphUI.UItoggle.set;
         graphType<NEportLevels={0,2}> => <-.GraphUI.graphtype.selectedItem + 4;
         lineStyle<NEportLevels={0,2}> => <-.GraphUI.line_style.cmdList[<-.GraphUI.line_style.selectedItem].label;
         color => <-.GraphUI.line_color.cmdList[<-.GraphUI.line_color.selectedItem].label;
         legendText => <-.GraphUI.Graph_Name.text;
         priority => GraphUI.priority_typein.value;
         lineWidth => <-.GraphUI.Line_width_typein.value;
         scatterSymbols => <-.GraphUI.symbol.text;
         symbolHeight => <-.GraphUI.symbol_height_typein.value;
         valuesR<NEportLevels={3,0}>=> {<-.<-.ValuesR1};
         valuesT => <-.<-.ValuesT;
      };
      float frameheight => <-.GraphParam.height + 10;
      UIframe UIframe {
         parent => <-.<-.GraphParam.UIpanel;
         y => <-.frameheight;
         width => <-.<-.GeneralPGraph.width;
         height => <-.<-.GeneralPGraph.height;
      };
      macro GraphUI {
         string type<NEportLevels={0,1}>[2] = {"curve","scatter"};
         UIradioBoxLabel graphtype {
            parent => <-.panel;
            labels => <-.type;
            title  => "Graph type";
            selectedItem => <-.<-.Gparams.Graph_params1.graphtype;
            y => (<-.priority_typein.y + <-.priority_typein.height) + 10;
         };
         UIoption style[15] = {
            {
               set=1,,,,,,,,,label="solid",,,,,,,,,,,
            },
            {
               label="dashed",,,,,,,,,,,
            },
            {
               label="dotted",,,,,,,,,,,
            },
            {
               label="dasheddotted",,,,,,,,,,,
            },
            {
               label="______________",,,,,,,,,,,
            },
            {
               label=". . . . . . .",,,,,,,,,,,
            },
            {
               label="_ _ _ _ _ _ _",,,,,,,,,,,
            },
            {
               label="__ __ __ __ __",,,,,,,,,,,
            },
            {
               label="__ . __ . __ .",,,,,,,,,,,
            },
            {
               label="_ __ _ __ _ __",,,,,,,,,,,
            },
            {
               label=".  .  .  .  .",,,,,,,,,,,
            },
            {
               label="___ ___ ___ __",,,,,,,,,,,
            },
            {
               label="_ _  _ _  _ _",,,,,,,,,,,
            },
            {
               label="__ .. __ .. __",,,,,,,,,,,
            },
            {
               label="__ ... __ ...",,,,,,,,,,,
            }
         };
         UIoptionMenu line_style {
            parent => <-.panel;
            cmdList => <-.style;
            x = 2;
            y => (<-.Graph_Name.y + <-.Graph_Name.height) + 10;
            width => .UIradioBox.y + .UIradioBox.height;
            selectedItem => <-.<-.Gparams.Graph_params1.line_style;
         };
         UIoption color[12] = {
            {
               label="antibackground",,,,,,,,,,,
            },
            {
               label="background",,,,,,,,,,,
            },
            {
               set=1,,,,,,,,,label="red",,,,,,,,,,,
            },
            {
               label="green",,,,,,,,,,,
            },
            {
               label="blue",,,,,,,,,,,
            },
            {
               label="yellow",,,,,,,,,,,
            },
            {
               label="magenta",,,,,,,,,,,
            },
            {
               label="cyan",,,,,,,,,,,
            },
            {
               label="black",,,,,,,,,,,
            },
            {
               label="white",,,,,,,,,,,
            },
            {
               label="grey",,,,,,,,,,,
            }
         };
         UIoptionMenu line_color {
            parent => <-.panel;
            cmdList => <-.color;
            x = 2;
            y => <-.line_style.y + 40;
            width => .UIradioBox.y + .UIradioBox.height;
            selectedItem => <-.<-.Gparams.Graph_params1.line_color;
         };
         UItext Graph_Name {
            parent => <-.panel;
            text => <-.<-.Gparams.Graph_params1.Graph_Name;
            y => (<-.symbol_height_typein.y + <-.symbol_height_typein.height) + 5;
            x => <-.graphname_label.x + <-.graphname_label.width;
         };
         UIlabel graphname_label {
            parent => <-.panel;
            label => "Graph Name";
            y => <-.Graph_Name.y;
         };
         link panel<NEportLevels={2,1}> => <-.UIframe;
         UItoggle UItoggle {
            x = 2;
            y = 2;
            width = 120;
            parent => <-.panel;
            label => "Graph On/Off";
            set => <-.<-.Gparams.Graph_params1.Graph_on_off;
         };
         UIfield priority_typein {
            parent => <-.panel;
            value<NEportLevels={2,2}> => <-.<-.Gparams.Graph_params1.priority;
            x => <-.priority_label.x + <-.priority_label.width;
            y => <-.priority_label.y;
            decimalPoints = 0;
            format = "mixed";
         };
         UIlabel priority_label {
            parent => <-.panel;
            label => "Graph priority";
            y => (<-.UItoggle.y + <-.UItoggle.height) + 10;
         };
         UIlabel Line_width_label {
            parent => <-.panel;
            label => "Line width";
            y => (<-.graphtype.y + <-.graphtype.height) + 10;
            active => (<-.graphtype.selectedItem == 0);
         };
         UItext symbol {
            parent => <-.panel;
            text => <-.<-.Gparams.Graph_params1.Scatter_symbols;
            x => <-.symbol_label.x + <-.symbol_label.width;
            y => <-.symbol_label.y;
            active => (<-.graphtype.selectedItem == 1);
         };
         UIlabel symbol_label {
            parent => <-.panel;
            label => "Scatter symbol";
            y => <-.Line_width_label.y + <-.Line_width_typein.height;
            active => (<-.graphtype.selectedItem == 1);
         };
         UIlabel symbol_typein_label {
            label => "Scatter size";
            y => <-.symbol_label.y + <-.symbol.height;
            active => (<-.graphtype.selectedItem == 1);
            parent => <-.panel;
         };
         UIfield symbol_height_typein {
            parent => <-.panel;
            value<NEportLevels={2,2}> => <-.<-.Gparams.Graph_params1.Scatter_size;
            x => <-.symbol_typein_label.x + <-.symbol_typein_label.width;
            y => <-.symbol_typein_label.y;
            active => (<-.graphtype.selectedItem == 1);
         };
         UIfield Line_width_typein {
            parent => <-.panel;
            value<NEportLevels={2,2}> => <-.<-.Gparams.Graph_params1.Line_width;
            x => <-.Line_width_label.x + <-.Line_width_label.width;
            y => <-.Line_width_label.y;
            active => (<-.graphtype.selectedItem == 0);
         };
      };
      GMOD.instancer instancer {
         Value => (<-.<-.GraphParam.selectedItem == 0);
         Group => <-.UIframe;
      };
      macro Gparams<export_all=3> {
        group Graph_params1<export_all=2> {
           int Graph_on_off<NEportLevels={2,2}> = 1;
           int priority<NEportLevels={2,2}> = 1;
           int graphtype<NEportLevels={2,2}> = 0;
           float Line_width<NEportLevels={2,2}>;
           string Scatter_symbols<NEportLevels={2,2}> = "+";
           float Scatter_size<NEportLevels={2,2}> = 10.;
           string Graph_Name<NEportLevels={2,2}> = "Graph1";
           int line_style<NEportLevels={2,2}> = 0;
           int line_color<NEportLevels={2,2}> = 2;
        };
      };
      link output<NEportLevels={1,2}> => AGPolarGraph;
   };
   macro PolarGraph#2<NEx=22.,NEy=120.> {
      AGPolarGraph AGPolarGraph {
         visibility<NEportLevels={2,0}> => <-.GraphUI.UItoggle.set;
         graphType<NEportLevels={0,2}> => <-.GraphUI.graphtype.selectedItem + 4;
         lineStyle<NEportLevels={0,2}> => <-.GraphUI.line_style.cmdList[<-.GraphUI.line_style.selectedItem].label;
         color => <-.GraphUI.line_color.cmdList[<-.GraphUI.line_color.selectedItem].label;
         legendText => <-.GraphUI.Graph_Name.text;
         valuesR<NEportLevels={3,0}>=> {<-.<-.ValuesR2};
         valuesT => <-.<-.ValuesT;
         priority => GraphUI.priority_typein.value;
         lineWidth => <-.GraphUI.Line_width_typein.value;
         scatterSymbols => <-.GraphUI.symbol.text;
         symbolHeight => <-.GraphUI.symbol_height_typein.value;
      };
      float frameheight => <-.GraphParam.height + 10;
      UIframe UIframe {
         parent => <-.<-.GraphParam.UIpanel;
         y => <-.frameheight;
         width => <-.<-.GeneralPGraph.width;
         height => <-.<-.GeneralPGraph.height;
      };
      macro GraphUI {
         string type<NEportLevels={0,1}>[2] = {"curve","scatter"};
         UIradioBoxLabel graphtype {
            parent => <-.panel;
            labels => <-.type;
            title  => "Graph type";
            selectedItem => <-.<-.Gparams.Graph_params2.graphtype;
            y => (<-.priority_typein.y + <-.priority_typein.height) + 10;
         };
         UIoption style[15] = {
            {
               set=1,,,,,,,,,label="solid",,,,,,,,,,,
            },
            {
               label="dashed",,,,,,,,,,,
            },
            {
               label="dotted",,,,,,,,,,,
            },
            {
               label="dasheddotted",,,,,,,,,,,
            },
            {
               label="______________",,,,,,,,,,,
            },
            {
               label=". . . . . . .",,,,,,,,,,,
            },
            {
               label="_ _ _ _ _ _ _",,,,,,,,,,,
            },
            {
               label="__ __ __ __ __",,,,,,,,,,,
            },
            {
               label="__ . __ . __ .",,,,,,,,,,,
            },
            {
               label="_ __ _ __ _ __",,,,,,,,,,,
            },
            {
               label=".  .  .  .  .",,,,,,,,,,,
            },
            {
               label="___ ___ ___ __",,,,,,,,,,,
            },
            {
               label="_ _  _ _  _ _",,,,,,,,,,,
            },
            {
               label="__ .. __ .. __",,,,,,,,,,,
            },
            {
               label="__ ... __ ...",,,,,,,,,,,
            }
         };
         UIoptionMenu line_style {
            parent => <-.panel;
            cmdList => <-.style;
            x = 2;
            y => (<-.Graph_Name.y + <-.Graph_Name.height) + 10;
            width => .UIradioBox.y + .UIradioBox.height;
            selectedItem => <-.<-.Gparams.Graph_params2.line_style;
         };
         UIoption color[12] = {
            {
               label="antibackground",,,,,,,,,,,
            },
            {
               label="background",,,,,,,,,,,
            },
            {
               set=1,,,,,,,,,label="red",,,,,,,,,,,
            },
            {
               label="green",,,,,,,,,,,
            },
            {
               label="blue",,,,,,,,,,,
            },
            {
               label="yellow",,,,,,,,,,,
            },
            {
               label="magenta",,,,,,,,,,,
            },
            {
               label="cyan",,,,,,,,,,,
            },
            {
               label="black",,,,,,,,,,,
            },
            {
               label="white",,,,,,,,,,,
            },
            {
               label="grey",,,,,,,,,,,
            }
         };
         UIoptionMenu line_color {
            parent => <-.panel;
            cmdList => <-.color;
            x = 2;
            y => <-.line_style.y + 40;
            width => .UIradioBox.y + .UIradioBox.height;
            selectedItem => <-.<-.Gparams.Graph_params2.line_color;
         };
         UItext Graph_Name {
            parent => <-.panel;
            text => <-.<-.Gparams.Graph_params2.Graph_Name;
            y => (<-.symbol_height_typein.y + <-.symbol_height_typein.height) + 5;
            x => <-.graphname_label.x + <-.graphname_label.width;
         };
         UIlabel graphname_label {
            parent => <-.panel;
            label => "Graph Name";
            y => <-.Graph_Name.y;
         };
         link panel<NEportLevels={2,1}> => <-.UIframe;
         UItoggle UItoggle {
            x = 2;
            y = 2;
            width = 120;
            parent => <-.panel;
            label => "Graph On/Off";
            set => <-.<-.Gparams.Graph_params2.Graph_on_off;
         };
         UIfield priority_typein {
            parent => <-.panel;
            value<NEportLevels={2,2}> => <-.<-.Gparams.Graph_params2.priority;
            x => <-.priority_label.x + <-.priority_label.width;
            y => <-.priority_label.y;
            decimalPoints = 0;
            format = "mixed";
         };
         UIlabel priority_label {
            parent => <-.panel;
            label => "Graph priority";
            y => (<-.UItoggle.y + <-.UItoggle.height) + 10;
         };
         UIlabel Line_width_label {
            parent => <-.panel;
            label => "Line width";
            y => (<-.graphtype.y + <-.graphtype.height) + 10;
            active => (<-.graphtype.selectedItem == 0);
         };
         UItext symbol {
            parent => <-.panel;
            text => <-.<-.Gparams.Graph_params2.Scatter_symbols;
            x => <-.symbol_label.x + <-.symbol_label.width;
            y => <-.symbol_label.y;
            active => (<-.graphtype.selectedItem == 1);
         };
         UIlabel symbol_label {
            parent => <-.panel;
            label => "Scatter symbol";
            y => <-.Line_width_label.y + <-.Line_width_typein.height;
            active => (<-.graphtype.selectedItem == 1);
         };
         UIlabel symbol_typein_label {
            label => "Scatter size";
            y => <-.symbol_label.y + <-.symbol.height;
            active => (<-.graphtype.selectedItem == 1);
            parent => <-.panel;
         };
         UIfield symbol_height_typein {
            parent => <-.panel;
            value<NEportLevels={2,2}> => <-.<-.Gparams.Graph_params2.Scatter_size;
            x => <-.symbol_typein_label.x + <-.symbol_typein_label.width;
            y => <-.symbol_typein_label.y;
            active => (<-.graphtype.selectedItem == 1);
         };
         UIfield Line_width_typein {
            parent => <-.panel;
            value<NEportLevels={2,2}> => <-.<-.Gparams.Graph_params2.Line_width;
            x => <-.Line_width_label.x + <-.Line_width_label.width;
            y => <-.Line_width_label.y;
            active => (<-.graphtype.selectedItem == 0);
         };
      };
      GMOD.instancer instancer {
         Value => (<-.<-.GraphParam.selectedItem == 1);
         Group => <-.UIframe;
      };
      macro Gparams<export_all=3> {
        group Graph_params2<export_all=2> {
           int Graph_on_off<NEportLevels={2,2}> = 1;
           int priority<NEportLevels={2,2}> = 1;
           int graphtype<NEportLevels={2,2}> = 0;
           float Line_width<NEportLevels={2,2}>;
           string Scatter_symbols<NEportLevels={2,2}> = "+";
           float Scatter_size<NEportLevels={2,2}> = 10.;
           string Graph_Name<NEportLevels={2,2}> = "Graph2";
           int line_style<NEportLevels={2,2}> = 0;
           int line_color<NEportLevels={2,2}> = 2;
        };
      };
      link output<NEportLevels={1,2}> => AGPolarGraph;
   };
   macro PolarGraph#3<NEx=22.,NEy=164.> {
      AGPolarGraph AGPolarGraph {
         visibility<NEportLevels={2,0}> => <-.GraphUI.UItoggle.set;
         graphType<NEportLevels={0,2}> => <-.GraphUI.graphtype.selectedItem + 4;
         lineStyle<NEportLevels={0,2}> => <-.GraphUI.line_style.cmdList[<-.GraphUI.line_style.selectedItem].label;
         color => <-.GraphUI.line_color.cmdList[<-.GraphUI.line_color.selectedItem].label;
         legendText => <-.GraphUI.Graph_Name.text;
         priority => GraphUI.priority_typein.value;
         lineWidth => <-.GraphUI.Line_width_typein.value;
         scatterSymbols => <-.GraphUI.symbol.text;
         symbolHeight => <-.GraphUI.symbol_height_typein.value;
         valuesR<NEportLevels={3,0}>=> {<-.<-.ValuesR3};
         valuesT => <-.<-.ValuesT;
      };
      float frameheight => <-.GraphParam.height + 10;
      UIframe UIframe {
         parent => <-.<-.GraphParam.UIpanel;
         y => <-.frameheight;
         width => <-.<-.GeneralPGraph.width;
         height => <-.<-.GeneralPGraph.height;
      };
      macro GraphUI {
         string type<NEportLevels={0,1}>[2] = {"curve","scatter"};
         UIradioBoxLabel graphtype {
            parent => <-.panel;
            labels => <-.type;
            title  => "Graph type";
            selectedItem => <-.<-.Gparams.Graph_params3.graphtype;
            y => (<-.priority_typein.y + <-.priority_typein.height) + 10;
         };
         UIoption style[15] = {
            {
               set=1,,,,,,,,,label="solid",,,,,,,,,,,
            },
            {
               label="dashed",,,,,,,,,,,
            },
            {
               label="dotted",,,,,,,,,,,
            },
            {
               label="dasheddotted",,,,,,,,,,,
            },
            {
               label="______________",,,,,,,,,,,
            },
            {
               label=". . . . . . .",,,,,,,,,,,
            },
            {
               label="_ _ _ _ _ _ _",,,,,,,,,,,
            },
            {
               label="__ __ __ __ __",,,,,,,,,,,
            },
            {
               label="__ . __ . __ .",,,,,,,,,,,
            },
            {
               label="_ __ _ __ _ __",,,,,,,,,,,
            },
            {
               label=".  .  .  .  .",,,,,,,,,,,
            },
            {
               label="___ ___ ___ __",,,,,,,,,,,
            },
            {
               label="_ _  _ _  _ _",,,,,,,,,,,
            },
            {
               label="__ .. __ .. __",,,,,,,,,,,
            },
            {
               label="__ ... __ ...",,,,,,,,,,,
            }
         };
         UIoptionMenu line_style {
            parent => <-.panel;
            cmdList => <-.style;
            x = 2;
            y => (<-.Graph_Name.y + <-.Graph_Name.height) + 10;
            width => .UIradioBox.y + .UIradioBox.height;
            selectedItem => <-.<-.Gparams.Graph_params3.line_style;
         };
         UIoption color[12] = {
            {
               label="antibackground",,,,,,,,,,,
            },
            {
               label="background",,,,,,,,,,,
            },
            {
               set=1,,,,,,,,,label="red",,,,,,,,,,,
            },
            {
               label="green",,,,,,,,,,,
            },
            {
               label="blue",,,,,,,,,,,
            },
            {
               label="yellow",,,,,,,,,,,
            },
            {
               label="magenta",,,,,,,,,,,
            },
            {
               label="cyan",,,,,,,,,,,
            },
            {
               label="black",,,,,,,,,,,
            },
            {
               label="white",,,,,,,,,,,
            },
            {
               label="grey",,,,,,,,,,,
            }
         };
         UIoptionMenu line_color {
            parent => <-.panel;
            cmdList => <-.color;
            x = 2;
            y => <-.line_style.y + 40;
            width => .UIradioBox.y + .UIradioBox.height;
            selectedItem => <-.<-.Gparams.Graph_params3.line_color;
         };
         UItext Graph_Name {
            parent => <-.panel;
            text => <-.<-.Gparams.Graph_params3.Graph_Name;
            y => (<-.symbol_height_typein.y + <-.symbol_height_typein.height) + 5;
            x => <-.graphname_label.x + <-.graphname_label.width;
         };
         UIlabel graphname_label {
            parent => <-.panel;
            label => "Graph Name";
            y => <-.Graph_Name.y;
         };
         link panel<NEportLevels={2,1}> => <-.UIframe;
         UItoggle UItoggle {
            x = 2;
            y = 2;
            width = 120;
            parent => <-.panel;
            label => "Graph On/Off";
            set => <-.<-.Gparams.Graph_params3.Graph_on_off;
         };
         UIfield priority_typein {
            parent => <-.panel;
            value<NEportLevels={2,2}> => <-.<-.Gparams.Graph_params3.priority;
            x => <-.priority_label.x + <-.priority_label.width;
            y => <-.priority_label.y;
            decimalPoints = 0;
            format = "mixed";
         };
         UIlabel priority_label {
            parent => <-.panel;
            label => "Graph priority";
            y => (<-.UItoggle.y + <-.UItoggle.height) + 10;
         };
         UIlabel Line_width_label {
            parent => <-.panel;
            label => "Line width";
            y => (<-.graphtype.y + <-.graphtype.height) + 10;
            active => (<-.graphtype.selectedItem == 0);
         };
         UItext symbol {
            parent => <-.panel;
            text => <-.<-.Gparams.Graph_params3.Scatter_symbols;
            x => <-.symbol_label.x + <-.symbol_label.width;
            y => <-.symbol_label.y;
            active => (<-.graphtype.selectedItem == 1);
         };
         UIlabel symbol_label {
            parent => <-.panel;
            label => "Scatter symbol";
            y => <-.Line_width_label.y + <-.Line_width_typein.height;
            active => (<-.graphtype.selectedItem == 1);
         };
         UIlabel symbol_typein_label {
            label => "Scatter size";
            y => <-.symbol_label.y + <-.symbol.height;
            active => (<-.graphtype.selectedItem == 1);
            parent => <-.panel;
         };
         UIfield symbol_height_typein {
            parent => <-.panel;
            value<NEportLevels={2,2}> => <-.<-.Gparams.Graph_params3.Scatter_size;
            x => <-.symbol_typein_label.x + <-.symbol_typein_label.width;
            y => <-.symbol_typein_label.y;
            active => (<-.graphtype.selectedItem == 1);
         };
         UIfield Line_width_typein {
            parent => <-.panel;
            value<NEportLevels={2,2}> => <-.<-.Gparams.Graph_params3.Line_width;
            x => <-.Line_width_label.x + <-.Line_width_label.width;
            y => <-.Line_width_label.y;
            active => (<-.graphtype.selectedItem == 0);
         };
      };
      GMOD.instancer instancer {
         Value => (<-.<-.GraphParam.selectedItem == 2);
         Group => <-.UIframe;
      };
      macro Gparams<export_all=3> {
        group Graph_params3<export_all=2> {
           int Graph_on_off<NEportLevels={2,2}> = 1;
           int priority<NEportLevels={2,2}> = 1;
           int graphtype<NEportLevels={2,2}> = 0;
           float Line_width<NEportLevels={2,2}>;
           string Scatter_symbols<NEportLevels={2,2}> = "+";
           float Scatter_size<NEportLevels={2,2}> = 10.;
           string Graph_Name<NEportLevels={2,2}> = "Graph3";
           int line_style<NEportLevels={2,2}> = 0;
           int line_color<NEportLevels={2,2}> = 2;
        };
      };
      link output<NEportLevels={1,2}> => AGPolarGraph;
   };
   macro PolarGraph#4<NEx=22.,NEy=208.> {
      AGPolarGraph AGPolarGraph {
         visibility<NEportLevels={2,0}> => <-.GraphUI.UItoggle.set;
         graphType<NEportLevels={0,2}> => <-.GraphUI.graphtype.selectedItem + 4;
         lineStyle<NEportLevels={0,2}> => <-.GraphUI.line_style.cmdList[<-.GraphUI.line_style.selectedItem].label;
         color => <-.GraphUI.line_color.cmdList[<-.GraphUI.line_color.selectedItem].label;
         legendText => <-.GraphUI.Graph_Name.text;
         priority => GraphUI.priority_typein.value;
         lineWidth => <-.GraphUI.Line_width_typein.value;
         scatterSymbols => <-.GraphUI.symbol.text;
         symbolHeight => <-.GraphUI.symbol_height_typein.value;
         valuesR<NEportLevels={3,0}>=> {<-.<-.ValuesR4};
         valuesT => <-.<-.ValuesT;
      };
      float frameheight => <-.GraphParam.height + 10;
      UIframe UIframe {
         parent => <-.<-.GraphParam.UIpanel;
         y => <-.frameheight;
         width => <-.<-.GeneralPGraph.width;
         height => <-.<-.GeneralPGraph.height;
      };
      macro GraphUI {
         string type<NEportLevels={0,1}>[2] = {"curve","scatter"};
         UIradioBoxLabel graphtype {
            parent => <-.panel;
            labels => <-.type;
            title  => "Graph type";
            selectedItem => <-.<-.Gparams.Graph_params4.graphtype;
            y => (<-.priority_typein.y + <-.priority_typein.height) + 10;
         };
         UIoption style[15] = {
            {
               set=1,,,,,,,,,label="solid",,,,,,,,,,,
            },
            {
               label="dashed",,,,,,,,,,,
            },
            {
               label="dotted",,,,,,,,,,,
            },
            {
               label="dasheddotted",,,,,,,,,,,
            },
            {
               label="______________",,,,,,,,,,,
            },
            {
               label=". . . . . . .",,,,,,,,,,,
            },
            {
               label="_ _ _ _ _ _ _",,,,,,,,,,,
            },
            {
               label="__ __ __ __ __",,,,,,,,,,,
            },
            {
               label="__ . __ . __ .",,,,,,,,,,,
            },
            {
               label="_ __ _ __ _ __",,,,,,,,,,,
            },
            {
               label=".  .  .  .  .",,,,,,,,,,,
            },
            {
               label="___ ___ ___ __",,,,,,,,,,,
            },
            {
               label="_ _  _ _  _ _",,,,,,,,,,,
            },
            {
               label="__ .. __ .. __",,,,,,,,,,,
            },
            {
               label="__ ... __ ...",,,,,,,,,,,
            }
         };
         UIoptionMenu line_style {
            parent => <-.panel;
            cmdList => <-.style;
            x = 2;
            y => (<-.Graph_Name.y + <-.Graph_Name.height) + 10;
            width => .UIradioBox.y + .UIradioBox.height;
            selectedItem => <-.<-.Gparams.Graph_params4.line_style;
         };
         UIoption color[12] = {
            {
               label="antibackground",,,,,,,,,,,
            },
            {
               label="background",,,,,,,,,,,
            },
            {
               set=1,,,,,,,,,label="red",,,,,,,,,,,
            },
            {
               label="green",,,,,,,,,,,
            },
            {
               label="blue",,,,,,,,,,,
            },
            {
               label="yellow",,,,,,,,,,,
            },
            {
               label="magenta",,,,,,,,,,,
            },
            {
               label="cyan",,,,,,,,,,,
            },
            {
               label="black",,,,,,,,,,,
            },
            {
               label="white",,,,,,,,,,,
            },
            {
               label="grey",,,,,,,,,,,
            }
         };
         UIoptionMenu line_color {
            parent => <-.panel;
            cmdList => <-.color;
            x = 2;
            y => <-.line_style.y + 40;
            width => .UIradioBox.y + .UIradioBox.height;
            selectedItem => <-.<-.Gparams.Graph_params4.line_color;
         };
         UItext Graph_Name {
            parent => <-.panel;
            text => <-.<-.Gparams.Graph_params4.Graph_Name;
            y => (<-.symbol_height_typein.y + <-.symbol_height_typein.height) + 5;
            x => <-.graphname_label.x + <-.graphname_label.width;
         };
         UIlabel graphname_label {
            parent => <-.panel;
            label => "Graph Name";
            y => <-.Graph_Name.y;
         };
         link panel<NEportLevels={2,1}> => <-.UIframe;
         UItoggle UItoggle {
            x = 2;
            y = 2;
            width = 120;
            parent => <-.panel;
            label => "Graph On/Off";
            set => <-.<-.Gparams.Graph_params4.Graph_on_off;
         };
         UIfield priority_typein {
            parent => <-.panel;
            value<NEportLevels={2,2}> => <-.<-.Gparams.Graph_params4.priority;
            x => <-.priority_label.x + <-.priority_label.width;
            y => <-.priority_label.y;
            decimalPoints = 0;
            format = "mixed";
         };
         UIlabel priority_label {
            parent => <-.panel;
            label => "Graph priority";
            y => (<-.UItoggle.y + <-.UItoggle.height) + 10;
         };
         UIlabel Line_width_label {
            parent => <-.panel;
            label => "Line width";
            y => (<-.graphtype.y + <-.graphtype.height) + 10;
            active => (<-.graphtype.selectedItem == 0);
         };
         UItext symbol {
            parent => <-.panel;
            text => <-.<-.Gparams.Graph_params4.Scatter_symbols;
            x => <-.symbol_label.x + <-.symbol_label.width;
            y => <-.symbol_label.y;
            active => (<-.graphtype.selectedItem == 1);
         };
         UIlabel symbol_label {
            parent => <-.panel;
            label => "Scatter symbol";
            y => <-.Line_width_label.y + <-.Line_width_typein.height;
            active => (<-.graphtype.selectedItem == 1);
         };
         UIlabel symbol_typein_label {
            label => "Scatter size";
            y => <-.symbol_label.y + <-.symbol.height;
            active => (<-.graphtype.selectedItem == 1);
            parent => <-.panel;
         };
         UIfield symbol_height_typein {
            parent => <-.panel;
            value<NEportLevels={2,2}> => <-.<-.Gparams.Graph_params4.Scatter_size;
            x => <-.symbol_typein_label.x + <-.symbol_typein_label.width;
            y => <-.symbol_typein_label.y;
            active => (<-.graphtype.selectedItem == 1);
         };
         UIfield Line_width_typein {
            parent => <-.panel;
            value<NEportLevels={2,2}> => <-.<-.Gparams.Graph_params4.Line_width;
            x => <-.Line_width_label.x + <-.Line_width_label.width;
            y => <-.Line_width_label.y;
            active => (<-.graphtype.selectedItem == 0);
         };
      };
      GMOD.instancer instancer {
         Value => (<-.<-.GraphParam.selectedItem == 3);
         Group => <-.UIframe;
      };
      macro Gparams<export_all=3> {
        group Graph_params4<export_all=2> {
           int Graph_on_off<NEportLevels={2,2}> = 1;
           int priority<NEportLevels={2,2}> = 1;
           int graphtype<NEportLevels={2,2}> = 0;
           float Line_width<NEportLevels={2,2}>;
           string Scatter_symbols<NEportLevels={2,2}> = "+";
           float Scatter_size<NEportLevels={2,2}> = 10.;
           string Graph_Name<NEportLevels={2,2}> = "Graph4";
           int line_style<NEportLevels={2,2}> = 0;
           int line_color<NEportLevels={2,2}> = 2;
        };
      };
      link output<NEportLevels={1,2}> => AGPolarGraph;
   };
   macro PolarGraph#5<NEx=22.,NEy=252.> {
      AGPolarGraph AGPolarGraph {
         visibility<NEportLevels={2,0}> => <-.GraphUI.UItoggle.set;
         graphType<NEportLevels={0,2}> => <-.GraphUI.graphtype.selectedItem + 4;
         lineStyle<NEportLevels={0,2}> => <-.GraphUI.line_style.cmdList[<-.GraphUI.line_style.selectedItem].label;
         color => <-.GraphUI.line_color.cmdList[<-.GraphUI.line_color.selectedItem].label;
         legendText => <-.GraphUI.Graph_Name.text;
         priority => GraphUI.priority_typein.value;
         lineWidth => <-.GraphUI.Line_width_typein.value;
         scatterSymbols => <-.GraphUI.symbol.text;
         symbolHeight => <-.GraphUI.symbol_height_typein.value;
         valuesR<NEportLevels={3,0}>=> {<-.<-.ValuesR5};
         valuesT => <-.<-.ValuesT;
      };
      float frameheight => <-.GraphParam.height + 10;
      UIframe UIframe {
         parent => <-.<-.GraphParam.UIpanel;
         y => <-.frameheight;
         width => <-.<-.GeneralPGraph.width;
         height => <-.<-.GeneralPGraph.height;
      };
      macro GraphUI {
         string type<NEportLevels={0,1}>[2] = {"curve","scatter"};
         UIradioBoxLabel graphtype {
            parent => <-.panel;
            labels => <-.type;
            title  => "Graph type";
            selectedItem => <-.<-.Gparams.Graph_params5.graphtype;
            y => (<-.priority_typein.y + <-.priority_typein.height) + 10;
         };
         UIoption style[15] = {
            {
               set=1,,,,,,,,,label="solid",,,,,,,,,,,
            },
            {
               label="dashed",,,,,,,,,,,
            },
            {
               label="dotted",,,,,,,,,,,
            },
            {
               label="dasheddotted",,,,,,,,,,,
            },
            {
               label="______________",,,,,,,,,,,
            },
            {
               label=". . . . . . .",,,,,,,,,,,
            },
            {
               label="_ _ _ _ _ _ _",,,,,,,,,,,
            },
            {
               label="__ __ __ __ __",,,,,,,,,,,
            },
            {
               label="__ . __ . __ .",,,,,,,,,,,
            },
            {
               label="_ __ _ __ _ __",,,,,,,,,,,
            },
            {
               label=".  .  .  .  .",,,,,,,,,,,
            },
            {
               label="___ ___ ___ __",,,,,,,,,,,
            },
            {
               label="_ _  _ _  _ _",,,,,,,,,,,
            },
            {
               label="__ .. __ .. __",,,,,,,,,,,
            },
            {
               label="__ ... __ ...",,,,,,,,,,,
            }
         };
         UIoptionMenu line_style {
            parent => <-.panel;
            cmdList => <-.style;
            x = 2;
            y => (<-.Graph_Name.y + <-.Graph_Name.height) + 10;
            width => .UIradioBox.y + .UIradioBox.height;
            selectedItem => <-.<-.Gparams.Graph_params5.line_style;
         };
         UIoption color[12] = {
            {
               label="antibackground",,,,,,,,,,,
            },
            {
               label="background",,,,,,,,,,,
            },
            {
               set=1,,,,,,,,,label="red",,,,,,,,,,,
            },
            {
               label="green",,,,,,,,,,,
            },
            {
               label="blue",,,,,,,,,,,
            },
            {
               label="yellow",,,,,,,,,,,
            },
            {
               label="magenta",,,,,,,,,,,
            },
            {
               label="cyan",,,,,,,,,,,
            },
            {
               label="black",,,,,,,,,,,
            },
            {
               label="white",,,,,,,,,,,
            },
            {
               label="grey",,,,,,,,,,,
            }
         };
         UIoptionMenu line_color {
            parent => <-.panel;
            cmdList => <-.color;
            x = 2;
            y => <-.line_style.y + 40;
            width => .UIradioBox.y + .UIradioBox.height;
            selectedItem => <-.<-.Gparams.Graph_params5.line_color;
         };
         UItext Graph_Name {
            parent => <-.panel;
            text => <-.<-.Gparams.Graph_params5.Graph_Name;
            y => (<-.symbol_height_typein.y + <-.symbol_height_typein.height) + 5;
            x => <-.graphname_label.x + <-.graphname_label.width;
         };
         UIlabel graphname_label {
            parent => <-.panel;
            label => "Graph Name";
            y => <-.Graph_Name.y;
         };
         link panel<NEportLevels={2,1}> => <-.UIframe;
         UItoggle UItoggle {
            y = 0;
            width = 120;
            parent => <-.panel;
            label => "Graph On/Off";
            set => <-.<-.Gparams.Graph_params5.Graph_on_off;
         };
         UIfield priority_typein {
            parent => <-.panel;
            value<NEportLevels={2,2}> => <-.<-.Gparams.Graph_params5.priority;
            x => <-.priority_label.x + <-.priority_label.width;
            y => <-.priority_label.y;
            decimalPoints = 0;
            format = "mixed";
         };
         UIlabel priority_label {
            parent => <-.panel;
            label => "Graph priority";
            y => (<-.UItoggle.y + <-.UItoggle.height) + 10;
         };
         UIlabel Line_width_label {
            parent => <-.panel;
            label => "Line width";
            y => (<-.graphtype.y + <-.graphtype.height) + 10;
            active => (<-.graphtype.selectedItem == 0);
         };
         UItext symbol {
            parent => <-.panel;
            text => <-.<-.Gparams.Graph_params5.Scatter_symbols;
            x => <-.symbol_label.x + <-.symbol_label.width;
            y => <-.symbol_label.y;
            active => (<-.graphtype.selectedItem == 1);
         };
         UIlabel symbol_label {
            parent => <-.panel;
            label => "Scatter symbol";
            y => <-.Line_width_label.y + <-.Line_width_typein.height;
            active => (<-.graphtype.selectedItem == 1);
         };
         UIlabel symbol_typein_label {
            label => "Scatter size";
            y => <-.symbol.y + <-.symbol.height;
            active => (<-.graphtype.selectedItem == 1);
            parent => <-.panel;
         };
         UIfield symbol_height_typein {
            parent => <-.panel;
            value<NEportLevels={2,2}> => <-.<-.Gparams.Graph_params5.Scatter_size;
            x => <-.symbol_typein_label.x + <-.symbol_typein_label.width;
            y => <-.symbol_typein_label.y;
            active => (<-.graphtype.selectedItem == 1);
         };
         UIfield Line_width_typein {
            parent => <-.panel;
            value<NEportLevels={2,2}> => <-.<-.Gparams.Graph_params5.Line_width;
            x => <-.Line_width_label.x + <-.Line_width_label.width;
            y => <-.Line_width_label.y;
            active => (<-.graphtype.selectedItem == 0);
         };
      };
      GMOD.instancer instancer {
         Value => (<-.<-.GraphParam.selectedItem == 4);
         Group => <-.UIframe;
      };
      macro Gparams<export_all=3> {
        group Graph_params5<export_all=2> {
           int Graph_on_off<NEportLevels={2,2}> = 1;
           int priority<NEportLevels={2,2}> = 1;
           int graphtype<NEportLevels={2,2}> = 0;
           float Line_width<NEportLevels={2,2}>;
           string Scatter_symbols<NEportLevels={2,2}> = "+";
           float Scatter_size<NEportLevels={2,2}> = 10.;
           string Graph_Name<NEportLevels={2,2}> = "Graph5";
           int line_style<NEportLevels={2,2}> = 0;
           int line_color<NEportLevels={2,2}> = 2;
        };
      };
      link output<NEportLevels={1,2}> => AGPolarGraph;
   };

   UImod_panel GeneralPGraph<NEx=330.,NEy=11.> {
      parent<NEportLevels={3,0}>;
      option {
         set = 1;
      };
      title => name_of(<-.<-);
   };
   macro SelectParam<NEx=506.,NEy=22.> {
      UIoptionMenu Parameter {
         parent<NEportLevels={3,0}> => <-.<-.GeneralPGraph;
         cmdList => <-.label_cmd.cmd;
         selectedItem = 0;
         x = 0;
         y = 0;
         width = 180;
         height = 30;
         label = " Object ";
      };
      label_cmd label_cmd {
         labels = {
            "Graph","Axis","World","Viewport","Legend"
         };
         cmd<NEportLevels={0,2}>[] = {
            ,,,,
            {
               set=1
            }
         };
      };
   };
   GMOD.instancer inst_Graph<NEx=506.,NEy=99.> {
      Value => (<-.SelectParam.Parameter.selectedItem == 0);
      Group => <-.GraphParam;
   };
   GMOD.instancer inst_Axis<NEx=506.,NEy=132.> {
      Value => (<-.SelectParam.Parameter.selectedItem == 1);
      Group => <-.PolarAxis.panel;
   };
   GMOD.instancer inst_World<NEx=506.,NEy=167.> {
      Value => (<-.SelectParam.Parameter.selectedItem == 2);
      Group => <-.PolarWorld.panel;
   };
   GMOD.instancer inst_Viewport<NEx=506.,NEy=200.> {
      Value => (<-.SelectParam.Parameter.selectedItem == 3);
      Group => <-.GraphViewport.panel;
   };
   GMOD.instancer inst_Legend<NEx=506.,NEy=244.> {
      Value => (<-.SelectParam.Parameter.selectedItem == 4);
      Group => <-.GraphLegend.panel;
   };
   macro GraphParam<NEx=341.,NEy=66.> {
      ilink parent<NEportLevels={2,1}> => <-.GeneralPGraph;
      imlink labels<NEportLevels={2,1}> => <-.graph;
      int selectedItem<NEportLevels={2,0},NEx=319.,NEy=33.> = 0;
      string+nres selectedString<NEportLevels={2,0},NEx=319.,NEy=198.> => labels[.selectedItem];
      int visible = 1;
      int active = 1;
      int x = 0;
      int y = 30;
      int width => <-.GeneralPGraph.width ;
      int height => .UIradioBox.y + .UIradioBox.height;
      label_cmd label_cmd {
         labels => <-.labels;
         cmd[5] {
            active => <-.<-.active;
         } = {
            {
               set=1,,,,,,,,,,,,,,,,,,,,
            },,,,
         };
         inItem => <-.selectedItem;
         outItem => .inItem;
      };
      UIpanel UIpanel {
         x => <-.x;
         y => <-.y;
         width => <-.width;
         height => <-.<-.GeneralPGraph.height;
         parent => <-.parent;
      };
      UIradioBox UIradioBox {
         y = 0;
         width => <-.UIpanel.width;
         &visible => <-.visible;
         parent => <-.UIpanel;
         cmdList => <-.label_cmd.cmd;
         selectedItem => <-.label_cmd.outItem;
      };
   };
   string graph<NEx=506.,NEy=66.>[] = {
      "Graph1","Graph2","Graph3","Graph4","Graph5"
   };

   macro PolarAxis<NEx=198.,NEy=121.> {
      macro RAxis<instanced=0> {
         macro RAxle_UI {
            UItoggle Axle_on_off {
               parent => <-.UIframe_Axle;
               y = 0;
               set => <-.<-.<-.R_Axis_params.Axle_on_off;
               label => "Axle on/off";
            };
            UIfield Tposition {
               parent => <-.UIframe_Axle;
               value<NEportLevels={2,2}> => <-.<-.<-.R_Axis_params.T_Axis_pos;
               y => (<-.Axle_on_off.y + <-.Axle_on_off.height) + 10;
            };
            UIlabel Tposition_label {
               parent => <-.UIframe_Axle;
               label => "T Axis \ncrossing position";
               x => <-.<-.RText_UI.Axis_text.width + 10;
               y => <-.Tposition.y;
               height => (UIdata.UIfonts[0].lineHeight + 20);
            };
            UIfield Axle_width_typein {
               parent => <-.UIframe_Axle;
               value<NEportLevels={2,2}> => <-.Axle_width.value;
               x => <-.Axle_width.width + 5;
               y => <-.Axle_width.y;
               width = 40;
            };
            UIslider Axle_width {
               parent => <-.UIframe_Axle;
               value<NEportLevels={2,2}> => <-.<-.<-.R_Axis_params.Axle_width;
               title => "Axle width";
               y => (<-.Tposition.y + <-.Tposition.height) + 10;
               min = 0.01;
               max = 20.;
            };
            UIoptionMenu Axle_color {
               parent => <-.UIframe_Axle;
               cmdList => <-.<-.<-.color1;
               y => (<-.Axle_width.y + <-.Axle_width.height) + 10;
               width => .UIradioBox.y + .UIradioBox.height;
               height = 20;
               selectedItem => <-.<-.<-.R_Axis_params.Axle_color;
               x = 0;
            };
            UIframe UIframe_Axle {
               parent => <-.<-.<-.panel;
               x = 5;
               y => <-.<-.<-.panelY;
               width = 245;
               height => (<-.Axle_color.y + <-.Axle_color.height) + 20;
            };
         };
         macro RText_UI {
            UItext Axis_text {
               y => (<-.Text_color.y + <-.Text_color.height) + 10;
               parent => <-.UIframe_Text;
               text => <-.<-.<-.R_Axis_params.R_Axis_text;
            };
            UIlabel Axis_text_label {
               parent => <-.UIframe_Text;
               label => "R Axis Text";
               x => <-.Axis_text.width + 10;
               y => <-.Axis_text.y;
            };
            UIslider Text_Height_slider {
               parent => <-.UIframe_Text;
               value<NEportLevels={2,2}> => <-.<-.<-.R_Axis_params.text_height;
               title => "Text height";
               y => (<-.reverse_text_alignment.y + <-.reverse_text_alignment.height) + 10;
               min = 0.;
               max = 10.;
            };
            UIfield Text_Height_typein {
               parent => <-.UIframe_Text;
               value<NEportLevels={2,2}> => <-.Text_Height_slider.value;
               x => <-.Text_Height_slider.width + 5;
               y => <-.Text_Height_slider.y;
               width = 40;
            };
            UItoggle reverse_text_alignment {
               parent => <-.UIframe_Text;
               y = 0;
               width => <-.UIframe_Text.width - 5;
               set => <-.<-.<-.R_Axis_params.reverse_text;
            };
            UIframe UIframe_Text {
               parent => <-.<-.<-.panel;
               x => <-.<-.RAxle_UI.UIframe_Axle.x;
               y => (<-.<-.RAxle_UI.UIframe_Axle.y + <-.<-.RAxle_UI.UIframe_Axle.height) + 10;
               width => <-.<-.RAxle_UI.UIframe_Axle.width;
               height => (<-.Axis_text.y + <-.Axis_text.height) + 20;
            };
            UIoptionMenu Text_color {
               parent => <-.UIframe_Text;
               cmdList => <-.<-.<-.color2;
               y => (<-.Text_Height_slider.y + <-.Text_Height_slider.height) + 10;
               width => .UIradioBox.y + .UIradioBox.height;
               height = 20;
               selectedItem => <-.<-.<-.R_Axis_params.Text_color;
               x = 0;
            };
         };
         macro RLabel_UI {
            UIoptionMenu Label_color {
               parent => <-.UIframe_Label;
               cmdList => <-.<-.<-.color3;
               y => (<-.Label_Height_slider.y + <-.Label_Height_slider.height) + 10;
               width => .UIradioBox.y + .UIradioBox.height;
               height = 20;
               selectedItem => <-.<-.<-.R_Axis_params.Label_color;
               x = 0;
            };
            UIframe UIframe_Label {
               parent => <-.<-.<-.panel;
               x => <-.<-.RAxle_UI.UIframe_Axle.x;
               y => (<-.<-.RText_UI.UIframe_Text.y + <-.<-.RText_UI.UIframe_Text.height) + 10;
               width => <-.<-.RAxle_UI.UIframe_Axle.width;
               height => (<-.Label_Decimals.y + <-.Label_Decimals.height) + 20;
            };
            UIslider Label_Height_slider {
               parent => <-.UIframe_Label;
               value<NEportLevels={2,2}> => <-.<-.<-.R_Axis_params.label_height;
               title => "Label height";
               y = 0;
               min = 0.;
               max = 10.;
            };
            UIfield Label_Height_typein {
               parent => <-.UIframe_Label;
               value<NEportLevels={2,2}> => <-.Label_Height_slider.value;
               x => <-.Label_Height_slider.width + 5;
               y => <-.Label_Height_slider.y;
               width = 40;
            };
            UIslider Label_Decimals {
               parent => <-.UIframe_Label;
               value<NEportLevels={2,2}> => <-.<-.<-.R_Axis_params.label_Decimals;
               title => "Label Decimals";
               y => (<-.Label_color.y + <-.Label_color.height) + 10;
               min = 0.;
               max = 10.;
               decimalPoints = 0;
            };
         };
         macro RTickLine_UI {
            UItoggle Major_Tick_on_off {
               y = 0;
               width = 120;
               label => "R Tickline on/off";
               set => <-.<-.<-.R_Axis_params.R_Tickline_on_off;
               parent => <-.UIframe_MajorTick;
            };
            UIframe UIframe_MajorTick {
               parent => <-.<-.<-.panel;
               x => <-.<-.RAxle_UI.UIframe_Axle.x;
               y => (<-.<-.RLabel_UI.UIframe_Label.y + <-.<-.RLabel_UI.UIframe_Label.height) + 10;
               width => <-.<-.RAxle_UI.UIframe_Axle.width;
               height => (<-.Minor_tick_color.y + <-.Minor_tick_color.height) + 10;
            };
            UIfield major_step {
               parent => <-.UIframe_MajorTick;
               value<NEportLevels={2,2}> => <-.<-.<-.R_Axis_params.Steps_for_Major;
               y => (<-.Major_Tick_on_off.y + <-.Major_Tick_on_off.height) + 10;
            };
            UIlabel major_step_label {
               parent => <-.UIframe_MajorTick;
               height => (UIdata.UIfonts[0].lineHeight + 0) + 10;
               label => "Steps for \nMajor tick marks";
               x => (<-.major_step.x + <-.major_step.width) + 20;
               y => <-.major_step.y;
            };
            UIfield minor_step {
               parent => <-.UIframe_MajorTick;
               value<NEportLevels={2,2}> => <-.<-.<-.R_Axis_params.Steps_for_Minor;
               y => (<-.major_step.y + <-.major_step.height) + 10;
               decimalPoints = 0;
            };
            UIlabel minor_step_label {
               parent => <-.UIframe_MajorTick;
               height => (UIdata.UIfonts[0].lineHeight + 0) + 10;
               label => "Steps for \nMinor tick marks";
               x => (<-.minor_step.x + <-.minor_step.width) + 20;
               y => <-.minor_step.y;
            };
            UIslider Major_tick_width {
               parent => <-.UIframe_MajorTick;
               value<NEportLevels={2,2}> => <-.<-.<-.R_Axis_params.Major_tick_width;
               y => (<-.minor_step.y + <-.minor_step.height) + 10;
               min = 0.01;
               max = 20.;
            };
            UIfield Major_tick_typein {
               parent => <-.UIframe_MajorTick;
               value<NEportLevels={2,2}> => <-.Major_tick_width.value;
               x => <-.Major_tick_width.width + 5;
               y => <-.Major_tick_width.y;
               width = 40;
            };
            UIslider Minor_tick_width {
               parent => <-.UIframe_MajorTick;
               y => (<-.Major_tick_width.y + <-.Major_tick_width.height) + 10;
               value<NEportLevels={2,2}> => <-.<-.<-.R_Axis_params.Minor_tick_width;
               min = 0.01;
               max = 20.;
            };
            UIfield Minor_tick_typein {
               parent => <-.UIframe_MajorTick;
               value<NEportLevels={2,2}> => <-.Minor_tick_width.value;
               x => <-.Minor_tick_width.width + 5;
               y => <-.Minor_tick_width.y;
               width = 40;
            };
            UIoptionMenu Major_tick_style {
               parent => <-.UIframe_MajorTick;
               cmdList => <-.<-.<-.style1;
               selectedItem => <-.<-.<-.R_Axis_params.Major_tick_style;
               y => (<-.Minor_tick_width.y + <-.Minor_tick_width.height) + 20;
               x = 0;
            };
            UIoptionMenu Minor_tick_style {
               parent => <-.UIframe_MajorTick;
               cmdList => <-.<-.<-.style2;
               selectedItem => <-.<-.<-.R_Axis_params.Minor_tick_style;
               y => <-.Major_tick_color.y + <-.Major_tick_color.height;
               x = 0;
            };
            UIoptionMenu Major_tick_color {
               parent => <-.UIframe_MajorTick;
               cmdList => <-.<-.<-.color4;
               selectedItem => <-.<-.<-.R_Axis_params.Major_tick_color;
               y => <-.Major_tick_style.y + <-.Major_tick_style.height;
               x = 0;
            };
            UIoptionMenu Minor_tick_color {
               parent => <-.UIframe_MajorTick;
               cmdList => <-.<-.<-.color5;
               selectedItem => <-.<-.<-.R_Axis_params.Minor_tick_color;
               y => <-.Minor_tick_style.y + <-.Minor_tick_style.height;
               x = 0;
            };
         };
      };
      macro TAxis<instanced=0> {
         macro TAxle_UI {
            UItoggle Axle_on_off {
               parent => <-.UIframe_Axle;
               y = 0;
               set => <-.<-.<-.T_Axis_params.Axle_on_off;
               label => "Axle on/off";
            };
            UIfield Rposition {
               parent => <-.UIframe_Axle;
               value<NEportLevels={2,2}> => <-.<-.<-.T_Axis_params.R_Axis_pos;
               y => (<-.Axle_on_off.y + <-.Axle_on_off.height) + 10;
            };
            UIlabel Rposition_label {
               parent => <-.UIframe_Axle;
               label => "R Axis \ncrossing position";
               x => <-.<-.TText_UI.Axis_text.width + 10;
               y => <-.Rposition.y;
               height => (UIdata.UIfonts[0].lineHeight + 20);
            };
            UIfield Axle_width_typein {
               parent => <-.UIframe_Axle;
               value<NEportLevels={2,2}> => <-.Axle_width.value;
               x => <-.Axle_width.width + 5;
               y => <-.Axle_width.y;
               width = 40;
            };
            UIslider Axle_width {
               parent => <-.UIframe_Axle;
               value<NEportLevels={2,2}> => <-.<-.<-.T_Axis_params.Axle_width;
               title => "Axle width";
               y => (<-.Rposition.y + <-.Rposition.height) + 10;
               min = 0.01;
               max = 20.;
            };
            UIoptionMenu Axle_color {
               parent => <-.UIframe_Axle;
               cmdList => <-.<-.<-.color1;
               y => (<-.Axle_width.y + <-.Axle_width.height) + 10;
               width => .UIradioBox.y + .UIradioBox.height;
               height = 20;
               selectedItem => <-.<-.<-.T_Axis_params.Axle_color;
               x = 0;
            };
            UIframe UIframe_Axle {
               parent => <-.<-.<-.panel;
               x = 5;
               y => <-.<-.<-.panelY;
               width = 245;
               height => (<-.Axle_color.y + <-.Axle_color.height) + 20;
            };
         };
         macro TText_UI {
            UItext Axis_text {
               y => (<-.Text_color.y + <-.Text_color.height) + 10;
               parent => <-.UIframe_Text;
               text => <-.<-.<-.T_Axis_params.T_Axis_text;
            };
            UIlabel Axis_text_label {
               parent => <-.UIframe_Text;
               label => "T Axis Text";
               x => <-.Axis_text.width + 10;
               y => <-.Axis_text.y;
            };
            UIslider Text_Height_slider {
               parent => <-.UIframe_Text;
               value<NEportLevels={2,2}> => <-.<-.<-.T_Axis_params.text_height;
               title => "Text height";
               y => (<-.reverse_text_alignment.y + <-.reverse_text_alignment.height) + 10;
               min = 0.;
               max = 10.;
            };
            UIfield Text_Height_typein {
               parent => <-.UIframe_Text;
               value<NEportLevels={2,2}> => <-.Text_Height_slider.value;
               x => <-.Text_Height_slider.width + 5;
               y => <-.Text_Height_slider.y;
               width = 40;
            };
            UItoggle reverse_text_alignment {
               parent => <-.UIframe_Text;
               y = 0;
               width = 130;
               set => <-.<-.<-.T_Axis_params.reverse_text;
            };
            UIframe UIframe_Text {
               parent => <-.<-.<-.panel;
               x => <-.<-.TAxle_UI.UIframe_Axle.x;
               y => (<-.<-.TAxle_UI.UIframe_Axle.y + <-.<-.TAxle_UI.UIframe_Axle.height) + 10;
               width => <-.<-.TAxle_UI.UIframe_Axle.width;
               height => (<-.Axis_text.y + <-.Axis_text.height) + 20;
            };
            UIoptionMenu Text_color {
               parent => <-.UIframe_Text;
               cmdList => <-.<-.<-.color2;
               y => (<-.Text_Height_slider.y + <-.Text_Height_slider.height) + 10;
               width => .UIradioBox.y + .UIradioBox.height;
               height = 20;
               selectedItem => <-.<-.<-.T_Axis_params.Text_color;
               x = 0;
            };
         };
         macro TLabel_UI {
            UIoptionMenu Label_color {
               parent => <-.UIframe_Label;
               cmdList => <-.<-.<-.color3;
               y => (<-.Label_Height_slider.y + <-.Label_Height_slider.height) + 10;
               width => .UIradioBox.y + .UIradioBox.height;
               height = 20;
               selectedItem => <-.<-.<-.T_Axis_params.Label_color;
               x = 0;
            };
            UIframe UIframe_Label {
               parent => <-.<-.<-.panel;
               x => <-.<-.TAxle_UI.UIframe_Axle.x;
               y => (<-.<-.TText_UI.UIframe_Text.y + <-.<-.TText_UI.UIframe_Text.height) + 10;
               width => <-.<-.TAxle_UI.UIframe_Axle.width;
               height => (<-.Label_Decimals.y + <-.Label_Decimals.height) + 20;
            };
            UIslider Label_Height_slider {
               parent => <-.UIframe_Label;
               value<NEportLevels={2,2}> => <-.<-.<-.T_Axis_params.label_height;
               title => "Label height";
               y = 0;
               min = 0.;
               max = 10.;
            };
            UIfield Label_Height_typein {
               parent => <-.UIframe_Label;
               value<NEportLevels={2,2}> => <-.Label_Height_slider.value;
               x => <-.Label_Height_slider.width + 5;
               y => <-.Label_Height_slider.y;
               width = 40;
            };
            UIslider Label_Decimals {
               parent => <-.UIframe_Label;
               value<NEportLevels={2,2}> => <-.<-.<-.T_Axis_params.label_Decimals;
               title => "Label Decimals";
               y => (<-.Label_color.y + <-.Label_color.height) + 10;
               min = 0.;
               max = 10.;
               decimalPoints = 0;
            };
         };
         macro TTickLine_UI {
            UItoggle Major_Tick_on_off {
               y = 0;
               width = 120;
               label => "T Tickline on/off";
               set => <-.<-.<-.T_Axis_params.T_Tickline_on_off;
               parent => <-.UIframe_MajorTick;
            };
            UIframe UIframe_MajorTick {
               parent => <-.<-.<-.panel;
               x => <-.<-.TAxle_UI.UIframe_Axle.x;
               y => (<-.<-.TLabel_UI.UIframe_Label.y + <-.<-.TLabel_UI.UIframe_Label.height) + 10;
               width => <-.<-.TAxle_UI.UIframe_Axle.width;
               height => (<-.Minor_tick_color.y + <-.Minor_tick_color.height) + 10;
            };
            UIfield major_step {
               parent => <-.UIframe_MajorTick;
               value<NEportLevels={2,2}> => <-.<-.<-.T_Axis_params.Steps_for_Major;
               y => (<-.Major_Tick_on_off.y + <-.Major_Tick_on_off.height) + 10;
            };
            UIlabel major_step_label {
               parent => <-.UIframe_MajorTick;
               height => (UIdata.UIfonts[0].lineHeight + 0) + 10;
               label => "Steps for \nMajor tick marks";
               x => (<-.major_step.x + <-.major_step.width) + 20;
               y => <-.major_step.y;
            };
            UIfield minor_step {
               parent => <-.UIframe_MajorTick;
               value<NEportLevels={2,2}> => <-.<-.<-.T_Axis_params.Steps_for_Minor;
               y => (<-.major_step.y + <-.major_step.height) + 10;
               decimalPoints = 0;
            };
            UIlabel minor_step_label {
               parent => <-.UIframe_MajorTick;
               height => (UIdata.UIfonts[0].lineHeight + 0) + 10;
               label => "Steps for \nMinor tick marks";
               x => (<-.minor_step.x + <-.minor_step.width) + 20;
               y => <-.minor_step.y;
            };
            UIslider Major_tick_width {
               parent => <-.UIframe_MajorTick;
               value<NEportLevels={2,2}> => <-.<-.<-.T_Axis_params.Major_tick_width;
               y => (<-.minor_step.y + <-.minor_step.height) + 10;
               min = 0.01;
               max = 20.;
            };
            UIfield Major_tick_typein {
               parent => <-.UIframe_MajorTick;
               value<NEportLevels={2,2}> => <-.Major_tick_width.value;
               x => <-.Major_tick_width.width + 5;
               y => <-.Major_tick_width.y;
               width = 40;
            };
            UIslider Minor_tick_width {
               parent => <-.UIframe_MajorTick;
               y => (<-.Major_tick_width.y + <-.Major_tick_width.height) + 10;
               value<NEportLevels={2,2}> => <-.<-.<-.T_Axis_params.Minor_tick_width;
               min = 0.01;
               max = 20.;
            };
            UIfield Minor_tick_typein {
               parent => <-.UIframe_MajorTick;
               value<NEportLevels={2,2}> => <-.Minor_tick_width.value;
               x => <-.Minor_tick_width.width + 5;
               y => <-.Minor_tick_width.y;
               width = 40;
            };
            UIoptionMenu Major_tick_style {
               parent => <-.UIframe_MajorTick;
               cmdList => <-.<-.<-.style1;
               selectedItem => <-.<-.<-.T_Axis_params.Major_tick_style;
               y => (<-.Minor_tick_width.y + <-.Minor_tick_width.height) + 20;
               x = 0;
            };
            UIoptionMenu Minor_tick_style {
               parent => <-.UIframe_MajorTick;
               cmdList => <-.<-.<-.style2;
               selectedItem => <-.<-.<-.T_Axis_params.Minor_tick_style;
               y => <-.Major_tick_color.y + <-.Major_tick_color.height;
               x = 0;
            };
            UIoptionMenu Major_tick_color {
               parent => <-.UIframe_MajorTick;
               cmdList => <-.<-.<-.color4;
               selectedItem => <-.<-.<-.T_Axis_params.Major_tick_color;
               y => <-.Major_tick_style.y + <-.Major_tick_style.height;
               x = 0;
            };
            UIoptionMenu Minor_tick_color {
               parent => <-.UIframe_MajorTick;
               cmdList => <-.<-.<-.color5;
               selectedItem => <-.<-.<-.T_Axis_params.Minor_tick_color;
               y => <-.Minor_tick_style.y + <-.Minor_tick_style.height;
               x = 0;
            };
         };
      };
      UIpanel panel<NEx=0.,NEy=-33.,instanced=0> {
         y<NEdisplayMode="open"> = 25;
         width => <-.<-.GeneralPGraph.width;
         height => <-.<-.GeneralPGraph.height;
         parent<NEportLevels={3,0}> => <-.<-.GeneralPGraph;
      };
      GMOD.instancer inst_RAxis {
         Group => <-.RAxis;
         Value => ((<-.Axis.selectedItem == 0) && (<-.panel.visible == 1));
      };
      GMOD.instancer inst_TAxis {
         Group => <-.TAxis;
         Value => ((<-.Axis.selectedItem == 1) && (<-.panel.visible == 1));
      };
      macro Axis<NEx=451.,NEy=22.> {
         ilink parent<NEportLevels={2,1},NEx=5.,NEy=23.> => <-.panel;
         imlink labels<NEx=155.,NEy=23.> => <-.axis;
         int selectedItem<NEportLevels={2,0},NEx=305.,NEy=23.> = 0;
         string+nres selectedString<NEportLevels={2,0}> => labels[.selectedItem];
         string title<NEx=455.,NEy=23.> => name_of(<-,1);
         int visible<NEx=605.,NEy=23.> = 1;
         int active<NEx=5.,NEy=98.> = 1;
         int x<NEx=155.,NEy=98.> = 0;
         int y<NEx=305.,NEy=98.> = 0;
         int width<NEx=455.,NEy=98.> = 200;
         int height<NEx=605.,NEy=98.> => .UIradioBox.y + .UIradioBox.height;
         label_cmd label_cmd<NEx=261.,NEy=173.> {
            labels => <-.labels;
            cmd[2] {
               active => <-.<-.active;
            };
            inItem => <-.selectedItem;
            outItem => inItem;
         };
         UIpanel UIpanel<NEx=88.,NEy=198.> {
            x => <-.x;
            y => <-.y;
            width => <-.width;
            height => <-.height;
            parent => <-.parent;
         };
         UIradioBox UIradioBox<NEx=88.,NEy=297.> {
            y = 4;
            width => <-.UIpanel.width;
            &visible => <-.visible;
            parent => <-.UIpanel;
            cmdList => <-.label_cmd.cmd;
            selectedItem => <-.label_cmd.outItem;
         };
      };
      string axis[] = {"RAxis","TAxis"};
      float panelX => .Axis.x;
      float panelY => (.Axis.y + .Axis.height) + 10;
      mlink mlink<NEportLevels={1,2}> => {.AGPolarRAxis,
         .AGPolarRTicklines,.AGPolarTAxis,.AGPolarTTicklines};
      AGPolarRAxis AGPolarRAxis {
         majorTickOn = 1;
         text<NEportLevels={2,0}> => <-.RAxis.RText_UI.Axis_text.text;
         visibility => <-.RAxis.RAxle_UI.Axle_on_off.set;
         labelHeight => <-.RAxis.RLabel_UI.Label_Height_slider.value;
         positionT => <-.RAxis.RAxle_UI.Tposition.value;
         majorStepR => <-.RAxis.RTickLine_UI.major_step.value;
         labelMode => <-.RAxis.RText_UI.reverse_text_alignment.set;
         majorTickLineStyle => <-.RAxis.RTickLine_UI.Major_tick_style.selectedItem;
         majorTickWidth => <-.RAxis.RTickLine_UI.Major_tick_width.value;
         minorTickCount => <-.RAxis.RTickLine_UI.minor_step.value;
         minorTickLineStyle => <-.RAxis.RTickLine_UI.Minor_tick_style.selectedItem;
         minorTickWidth => <-.RAxis.RTickLine_UI.Minor_tick_width.value;
         majorTickColor => <-.RAxis.RTickLine_UI.Major_tick_color.cmdList[<-.RAxis.RTickLine_UI.Major_tick_color.selectedItem].label;
         minorTickColor => <-.RAxis.RTickLine_UI.Minor_tick_color.cmdList[<-.RAxis.RTickLine_UI.Minor_tick_color.selectedItem].label;
         majorReferenceR => <-.RAxis.RTickLine_UI.major_step.value;
         axleColor => <-.RAxis.RAxle_UI.Axle_color.cmdList[<-.RAxis.RAxle_UI.Axle_color.selectedItem].label;
         axleWidth => <-.RAxis.RAxle_UI.Axle_width.value;
         labelColor => <-.RAxis.RLabel_UI.Label_color.cmdList[<-.RAxis.RLabel_UI.Label_color.selectedItem].label;
         textColor => <-.RAxis.RText_UI.Text_color.cmdList[<-.RAxis.RText_UI.Text_color.selectedItem].label;
         textHeight => <-.RAxis.RText_UI.Text_Height_slider.value;
         labelDecimals => <-.RAxis.RLabel_UI.Label_Decimals.value;
      };
      AGPolarRTicklines AGPolarRTicklines {
         visibility<NEportLevels={2,0}> => <-.RAxis.RTickLine_UI.Major_Tick_on_off.set;
         majorTickOn = 1;
         majorTickWidth => <-.RAxis.RTickLine_UI.Major_tick_width.value;
         majorTickLineStyle => <-.RAxis.RTickLine_UI.Major_tick_style.selectedItem;
         minorTickLineStyle => <-.RAxis.RTickLine_UI.Minor_tick_style.selectedItem;
         majorTickColor => <-.RAxis.RTickLine_UI.Major_tick_color.cmdList[<-.RAxis.RTickLine_UI.Major_tick_color.selectedItem].label;
         minorTickColor => <-.RAxis.RTickLine_UI.Minor_tick_color.cmdList[<-.RAxis.RTickLine_UI.Minor_tick_color.selectedItem].label;
         minorTickCount => <-.RAxis.RTickLine_UI.minor_step.value;
         minorTickWidth => <-.RAxis.RTickLine_UI.Minor_tick_width.value;
         majorStepR => <-.RAxis.RTickLine_UI.major_step.value;
      };
      AGPolarTAxis AGPolarTAxis {
         majorTickOn = 1;
         text<NEportLevels={2,0}> => <-.TAxis.TText_UI.Axis_text.text;
         visibility => <-.TAxis.TAxle_UI.Axle_on_off.set;
         labelHeight => <-.TAxis.TLabel_UI.Label_Height_slider.value;
         positionR => <-.TAxis.TAxle_UI.Rposition.value;
         majorStepT => <-.TAxis.TTickLine_UI.major_step.value;
         labelMode => <-.TAxis.TText_UI.reverse_text_alignment.set;
         majorTickLineStyle => <-.TAxis.TTickLine_UI.Major_tick_style.selectedItem;
         majorTickWidth => <-.TAxis.TTickLine_UI.Major_tick_width.value;
         minorTickCount => <-.TAxis.TTickLine_UI.minor_step.value;
         minorTickLineStyle => <-.TAxis.TTickLine_UI.Minor_tick_style.selectedItem;
         minorTickWidth => <-.TAxis.TTickLine_UI.Minor_tick_width.value;
         majorReferenceT => <-.TAxis.TTickLine_UI.major_step.value;
         majorTickColor => <-.TAxis.TTickLine_UI.Major_tick_color.cmdList[<-.TAxis.TTickLine_UI.Major_tick_color.selectedItem].label;
         minorTickColor => <-.TAxis.TTickLine_UI.Minor_tick_color.cmdList[<-.TAxis.TTickLine_UI.Minor_tick_color.selectedItem].label;
         axleColor => <-.TAxis.TAxle_UI.Axle_color.cmdList[<-.TAxis.TAxle_UI.Axle_color.selectedItem].label;
         axleWidth => <-.TAxis.TAxle_UI.Axle_width.value;
         labelColor => <-.TAxis.TLabel_UI.Label_color.cmdList[<-.TAxis.TLabel_UI.Label_color.selectedItem].label;
         textColor => <-.TAxis.TText_UI.Text_color.cmdList[<-.TAxis.TText_UI.Text_color.selectedItem].label;
         textHeight => <-.TAxis.TText_UI.Text_Height_slider.value;
         labelDecimals => <-.TAxis.TLabel_UI.Label_Decimals.value;
      };
      AGPolarTTicklines AGPolarTTicklines {
         visibility<NEportLevels={2,0}> => <-.TAxis.TTickLine_UI.Major_Tick_on_off.set;
         majorTickOn = 1;
         majorTickWidth => <-.TAxis.TTickLine_UI.Major_tick_width.value;
         minorTickCount => <-.TAxis.TTickLine_UI.minor_step.value;
         minorTickWidth => <-.TAxis.TTickLine_UI.Minor_tick_width.value;
         majorStepT => <-.TAxis.TTickLine_UI.major_step.value;
         majorTickColor => <-.TAxis.TTickLine_UI.Major_tick_color.cmdList[<-.TAxis.TTickLine_UI.Major_tick_color.selectedItem].label;
         majorTickLineStyle => <-.TAxis.TTickLine_UI.Major_tick_style.selectedItem;
         minorTickColor => <-.TAxis.TTickLine_UI.Minor_tick_color.cmdList[<-.TAxis.TTickLine_UI.Minor_tick_color.selectedItem].label;
         minorTickLineStyle => <-.TAxis.TTickLine_UI.Minor_tick_style.selectedItem;
      };
      UIoption color1[12] = {
         {
            set=1,,,,,,,,,label="antibackground",,,,,,,,,,,
         },
         {
            label="background",,,,,,,,,,,
         },
         {
            label="red",,,,,,,,,,,
         },
         {
            label="green",,,,,,,,,,,
         },
         {
            label="blue",,,,,,,,,,,
         },
         {
            label="yellow",,,,,,,,,,,
         },
         {
            label="magenta",,,,,,,,,,,
         },
         {
            label="cyan",,,,,,,,,,,
         },
         {
            label="black",,,,,,,,,,,
         },
         {
            label="white",,,,,,,,,,,
         },
         {
            label="grey",,,,,,,,,,,
         }
      };
      UIoption style1[15] = {
         {
            set=1,,,,,,,,,label="solid",,,,,,,,,,,
         },
         {
            label="dashed",,,,,,,,,,,
         },
         {
            label="dotted",,,,,,,,,,,
         },
         {
            label="dasheddotted",,,,,,,,,,,
         },
         {
            label="______________",,,,,,,,,,,
         },
         {
            label=". . . . . . .",,,,,,,,,,,
         },
         {
            label="_ _ _ _ _ _ _",,,,,,,,,,,
         },
         {
            label="__ __ __ __ __",,,,,,,,,,,
         },
         {
            label="__ . __ . __ .",,,,,,,,,,,
         },
         {
            label="_ __ _ __ _ __",,,,,,,,,,,
         },
         {
            label=".  .  .  .  .",,,,,,,,,,,
         },
         {
            label="___ ___ ___ __",,,,,,,,,,,
         },
         {
            label="_ _  _ _  _ _",,,,,,,,,,,
         },
         {
            label="__ .. __ .. __",,,,,,,,,,,
         },
         {
            label="__ ... __ ...",,,,,,,,,,,
         }
      };
      UIoption color2[12] = {
         {
            set=1,,,,,,,,,label="antibackground",,,,,,,,,,,
         },
         {
            label="background",,,,,,,,,,,
         },
         {
            label="red",,,,,,,,,,,
         },
         {
            label="green",,,,,,,,,,,
         },
         {
            label="blue",,,,,,,,,,,
         },
         {
            label="yellow",,,,,,,,,,,
         },
         {
            label="magenta",,,,,,,,,,,
         },
         {
            label="cyan",,,,,,,,,,,
         },
         {
            label="black",,,,,,,,,,,
         },
         {
            label="white",,,,,,,,,,,
         },
         {
            label="grey",,,,,,,,,,,
         }
      };
      UIoption color3[12] = {
         {
            set=1,,,,,,,,,label="antibackground",,,,,,,,,,,
         },
         {
            label="background",,,,,,,,,,,
         },
         {
            label="red",,,,,,,,,,,
         },
         {
            label="green",,,,,,,,,,,
         },
         {
            label="blue",,,,,,,,,,,
         },
         {
            label="yellow",,,,,,,,,,,
         },
         {
            label="magenta",,,,,,,,,,,
         },
         {
            label="cyan",,,,,,,,,,,
         },
         {
            label="black",,,,,,,,,,,
         },
         {
            label="white",,,,,,,,,,,
         },
         {
            label="grey",,,,,,,,,,,
         }
      };
      UIoption color4[12] = {
         {
            set=1,,,,,,,,,label="antibackground",,,,,,,,,,,
         },
         {
            label="background",,,,,,,,,,,
         },
         {
            label="red",,,,,,,,,,,
         },
         {
            label="green",,,,,,,,,,,
         },
         {
            label="blue",,,,,,,,,,,
         },
         {
            label="yellow",,,,,,,,,,,
         },
         {
            label="magenta",,,,,,,,,,,
         },
         {
            label="cyan",,,,,,,,,,,
         },
         {
            label="black",,,,,,,,,,,
         },
         {
            label="white",,,,,,,,,,,
         },
         {
            label="grey",,,,,,,,,,,
         }
      };
      UIoption color5[12] = {
         {
            set=1,,,,,,,,,label="antibackground",,,,,,,,,,,
         },
         {
            label="background",,,,,,,,,,,
         },
         {
            label="red",,,,,,,,,,,
         },
         {
            label="green",,,,,,,,,,,
         },
         {
            label="blue",,,,,,,,,,,
         },
         {
            label="yellow",,,,,,,,,,,
         },
         {
            label="magenta",,,,,,,,,,,
         },
         {
            label="cyan",,,,,,,,,,,
         },
         {
            label="black",,,,,,,,,,,
         },
         {
            label="white",,,,,,,,,,,
         },
         {
            label="grey",,,,,,,,,,,
         }
      };
      UIoption style2[15] = {
         {
            label="solid",,,,,,,,,,,
         },
         {
            set=1,,,,,,,,,label="dashed",,,,,,,,,,,
         },
         {
            label="dotted",,,,,,,,,,,
         },
         {
            label="dasheddotted",,,,,,,,,,,
         },
         {
            label="______________",,,,,,,,,,,
         },
         {
            label=". . . . . . .",,,,,,,,,,,
         },
         {
            label="_ _ _ _ _ _ _",,,,,,,,,,,
         },
         {
            label="__ __ __ __ __",,,,,,,,,,,
         },
         {
            label="__ . __ . __ .",,,,,,,,,,,
         },
         {
            label="_ __ _ __ _ __",,,,,,,,,,,
         },
         {
            label=".  .  .  .  .",,,,,,,,,,,
         },
         {
            label="___ ___ ___ __",,,,,,,,,,,
         },
         {
            label="_ _  _ _  _ _",,,,,,,,,,,
         },
         {
            label="__ .. __ .. __",,,,,,,,,,,
         },
         {
            label="__ ... __ ...",,,,,,,,,,,
         }
      };
      AGPrimitive &Graph_in<NEportLevels={2,0}>;
      group R_Axis_params<export_all=2> {
         int Axle_on_off<NEportLevels={2,2}> = 1;
         float T_Axis_pos<NEportLevels={2,2}>;
         float Axle_width<NEportLevels={2,2}> = 1.;
         int Axle_color<NEportLevels={2,2}> = 0;
         int reverse_text<NEportLevels={2,2}> = 0;
         float text_height<NEportLevels={2,2}> = 5.;
         int Text_color<NEportLevels={2,2}> = 0;
         string R_Axis_text<NEportLevels={2,2}> = "R axis";
         float label_height<NEportLevels={2,2}> = 5.;
         int Label_color<NEportLevels={2,2}> = 0;
         float label_Decimals<NEportLevels={2,2}> = 0.;
         int R_Tickline_on_off<NEportLevels={2,2}> = 1;
         float Steps_for_Major<NEportLevels={2,2}>;
         int Steps_for_Minor<NEportLevels={2,2}> = 1;
         float Major_tick_width<NEportLevels={2,2}> = 0.5;
         float Minor_tick_width<NEportLevels={2,2}> = 0.01;
         int Major_tick_style<NEportLevels={2,2}> = 0;
         int Major_tick_color<NEportLevels={2,2}> = 0;
         int Minor_tick_style<NEportLevels={2,2}> = 1;
         int Minor_tick_color<NEportLevels={2,2}> = 0;
      };
      group T_Axis_params<export_all=2> {
         int Axle_on_off<NEportLevels={2,2}> = 1;
         float R_Axis_pos<NEportLevels={2,2}>;
         float Axle_width<NEportLevels={2,2}> = 1.;
         int Axle_color<NEportLevels={2,2}> = 0;
         int reverse_text<NEportLevels={2,2}> = 0;
         float text_height<NEportLevels={2,2}> = 5.;
         int Text_color<NEportLevels={2,2}> = 0;
         string T_Axis_text<NEportLevels={2,2}> = "T axis";
         float label_height<NEportLevels={2,2}> = 5.;
         int Label_color<NEportLevels={2,2}> = 0;
         float label_Decimals<NEportLevels={2,2}> = 0.;
         int T_Tickline_on_off<NEportLevels={2,2}> = 1;
         float Steps_for_Major<NEportLevels={2,2}> = 20;
         int Steps_for_Minor<NEportLevels={2,2}> = 1;
         float Major_tick_width<NEportLevels={2,2}> = 0.5;
         float Minor_tick_width<NEportLevels={2,2}> = 0.01;
         int Major_tick_style<NEportLevels={2,2}> = 0;
         int Major_tick_color<NEportLevels={2,2}> = 0;
         int Minor_tick_style<NEportLevels={2,2}> = 1;
         int Minor_tick_color<NEportLevels={2,2}> = 0;
      };
   };
   macro PolarWorld<NEx=198.,NEy=176.> {
      AGPolarGraphWorld AGPolarGraphWorld {
         limitsT => {
            <-.PolarWorld_UI.T_min.value,<-.PolarWorld_UI.T_max.value};
         limitsR => {
            <-.PolarWorld_UI.R_min.value,<-.PolarWorld_UI.R_max.value};
         children => <-.AGCombinePolarGraphWorldInput.output;
      };
      AGCombinePolarGraphWorldInput AGCombinePolarGraphWorldInput<NEx=55.,NEy=121.> {
         input1<NEportLevels={3,0}> => {
            <-.<-.PolarGraph#1.output,<-.<-.PolarGraph#2.output,
            <-.<-.PolarGraph#3.output,<-.<-.PolarGraph#4.output,
            <-.<-.PolarGraph#5.output
         };
         input2<NEportLevels={3,0}> => <-.<-.PolarAxis.mlink;
      };
      UIpanel panel<NEx=11.,NEy=110.,instanced=0> {
         parent<NEportLevels={3,0}> => <-.<-.GeneralPGraph;
         y = 30;
         width => <-.<-.GeneralPGraph.width;
         height => <-.<-.GeneralPGraph.height;
      };
      macro PolarWorld_UI<instanced=0> {
         UIfield T_min {
            y = 0;
            width = 60;
            parent => <-.<-.panel;
            value<NEportLevels={2,2}> => <-.<-.World_params.T_min;
         };
         UIlabel T_min_label {
            x => (<-.T_min.x + <-.T_min.width) + 5;
            y => <-.T_min.y;
            parent => <-.<-.panel;
            label => "T region min";
         };
         UIfield T_max {
            y => (<-.T_min.y + <-.T_min.height) + 5;
            parent => <-.<-.panel;
            value<NEportLevels={2,2}> => <-.<-.World_params.T_max;
            width = 60;
         };
         UIlabel T_max_label {
            x => (<-.T_max.x + <-.T_max.width) + 5;
            y => <-.T_max.y;
            parent => <-.<-.panel;
            label => "T region max";
         };
         UIfield R_min {
            y => (<-.T_max.y + <-.T_max.height) + 5;
            parent => <-.<-.panel;
            value<NEportLevels={2,2}> => <-.<-.World_params.R_min;
            width = 60;
         };
         UIlabel R_min_label {
            x => (<-.R_min.x + <-.R_min.width) + 5;
            y => <-.R_min.y;
            parent => <-.<-.panel;
            label => "R region min";
         };
         UIfield R_max {
            y => (<-.R_min.y + <-.R_min.height) + 5;
            parent => <-.<-.panel;
            value<NEportLevels={2,2}> => <-.<-.World_params.R_max;
            width = 60;
         };
         UIlabel R_max_label {
            x => (<-.R_max.x + <-.R_max.width) + 5;
            y => <-.R_max.y;
            parent => <-.<-.panel;
            label => "R region max";
         };
      };
      GMOD.instancer inst_PolarWorld_UI {
         Value = 1;
         Group => <-.PolarWorld_UI;
      };
      group World_params<export_all=2> {
         float T_min<NEportLevels={2,2}>;
         float T_max<NEportLevels={2,2}>;
         float R_min<NEportLevels={2,2}>;
         float R_max<NEportLevels={2,2}>;
      };
      link out<NEportLevels={1,2}> => AGPolarGraphWorld;
   };
   macro GraphViewport<NEx=198.,NEy=231.> {
      AGGraphViewportObj AGGraphViewportObj {
         graphViewport<NEdisplayMode="open"> {
            visibility => <-.<-.GraphViewport_UI.Frame_visible.set;
            frameColor => <-.<-.GraphViewport_UI.FrameColor.cmdList[<-.<-.GraphViewport_UI.FrameColor.selectedItem].label;
            frameWidth => <-.<-.GraphViewport_UI.Frame_Width.value;
            fillColor => <-.<-.GraphViewport_UI.FillColor.cmdList[<-.<-.GraphViewport_UI.FillColor.selectedItem].label;
            children<NEportLevels={4,0}> => {
               <-.<-.<-.PolarWorld.out,<-.<-.<-.GraphLegend.obj};
         };
      };
      UIpanel panel<instanced=0> {
         parent<NEportLevels={3,0}> => <-.<-.GeneralPGraph;
         y = 30;
         width => <-.<-.GeneralPGraph.width;
         height => <-.<-.GeneralPGraph.height;
      };
      macro GraphViewport_UI<instanced=0> {
         UItoggle Frame_visible {
            y = 0;
            width = 120;
            parent => <-.<-.panel;
            set => <-.<-.Viewport_params.Frame_visible;
         };
         UIslider Frame_Width {
            parent => <-.<-.panel;
            value<NEportLevels={2,2}> => <-.<-.Viewport_params.Frame_Width;
            y => (<-.Frame_visible.x + <-.Frame_visible.height) + 10;
            width = 150;
            min = 0.;
            max = 4.;
         };
         UIfield Frame_Width_Typein {
            parent => <-.<-.panel;
            value<NEportLevels={2,2}> => <-.Frame_Width.value;
            x => <-.Frame_Width.width + 5;
            y => <-.Frame_Width.y;
            width = 50;
         };
         UIoptionMenu FrameColor {
            parent => <-.<-.panel;
            y => (<-.Frame_Width.y + <-.Frame_Width.height) + 10;
            selectedItem => <-.<-.Viewport_params.Frame_Color;
            label => "Frame Color";
            cmdList => <-.color1;
            x = 0;
         };
         UIoptionMenu FillColor {
            parent => <-.<-.panel;
            y => <-.FrameColor.y + <-.FrameColor.height;
            selectedItem => <-.<-.Viewport_params.Fill_Color;
            label => "Fill Color";
            cmdList => <-.color2;
            x = 0;
         };
         UIoption color1[12] = {
            {
               set=1,,,,,,,,,label="antibackground",,,,,,,,,,,
            },
            {
               label="background",,,,,,,,,,,
            },
            {
               label="red",,,,,,,,,,,
            },
            {
               label="green",,,,,,,,,,,
            },
            {
               label="blue",,,,,,,,,,,
            },
            {
               label="yellow",,,,,,,,,,,
            },
            {
               label="magenta",,,,,,,,,,,
            },
            {
               label="cyan",,,,,,,,,,,
            },
            {
               label="black",,,,,,,,,,,
            },
            {
               label="white",,,,,,,,,,,
            },
            {
               label="grey",,,,,,,,,,,
            }
         };
         UIoption color2[12] = {
            {
               label="antibackground",,,,,,,,,,,
            },
            {
               set=1,,,,,,,,,label="background",,,,,,,,,,,
            },
            {
               label="red",,,,,,,,,,,
            },
            {
               label="green",,,,,,,,,,,
            },
            {
               label="blue",,,,,,,,,,,
            },
            {
               label="yellow",,,,,,,,,,,
            },
            {
               label="magenta",,,,,,,,,,,
            },
            {
               label="cyan",,,,,,,,,,,
            },
            {
               label="black",,,,,,,,,,,
            },
            {
               label="white",,,,,,,,,,,
            },
            {
               label="grey",,,,,,,,,,,
            }
         };
      };
      GMOD.instancer inst_GraphViewport_UI {
         Value = 1;
         Group => <-.GraphViewport_UI;
      };
      group Viewport_params<export_all=2> {
         int Frame_visible<NEportLevels={2,2}> = 1;
         float Frame_Width<NEportLevels={2,2}> = 0.01;
         int Frame_Color<NEportLevels={2,2}> = 0;
         int Fill_Color<NEportLevels={2,2}> = 1;
      };
      link obj<NEportLevels={1,3}> => AGGraphViewportObj.dataObject.obj;
   };
   macro GraphLegend<NEx=363.,NEy=176.> {
      AGGraphLegend AGGraphLegend {
         visibility => <-.LegendUI.Position_UI.visible.set;
         geometry => {
            <-.LegendUI.Position_UI.position_x.value,
            <-.LegendUI.Position_UI.position_y.value};
         fillColor => <-.LegendUI.Frame_UI.FillColor.cmdList[<-.LegendUI.Frame_UI.FillColor.selectedItem].label;
         frameColor => <-.LegendUI.Frame_UI.FrameColor.cmdList[<-.LegendUI.Frame_UI.FrameColor.selectedItem].label;
         frameWidth => <-.LegendUI.Frame_UI.Frame_Width.value;
         labelHeight => <-.LegendUI.Label_UI.Label_Height.value;
         labelColor => <-.LegendUI.Label_UI.Label_Color.cmdList[<-.LegendUI.Label_UI.Label_Color.selectedItem].label;
         numColumns => <-.LegendUI.Label_UI.Number_of_Column.value;
         title => <-.LegendUI.Title_UI.Title.text;
         titleHeight => <-.LegendUI.Title_UI.Title_Height.value;
         titleColor => <-.LegendUI.Title_UI.Title_Color.cmdList[<-.LegendUI.Title_UI.Title_Color.selectedItem].label;
         graphs<NEportLevels={3,0}> => {
            <-.<-.PolarGraph#1.output,<-.<-.PolarGraph#2.output,
            <-.<-.PolarGraph#3.output,<-.<-.PolarGraph#4.output,
            <-.<-.PolarGraph#5.output
         };
      };
      UIpanel panel<instanced=0> {
         y = 30;
         width => <-.<-.GeneralPGraph.width;
         height => <-.<-.GeneralPGraph.height;
         parent<NEportLevels={3,0}> => <-.<-.GeneralPGraph;
      };
      macro LegendUI {
         macro Frame_UI {
            UIframe UIframe_Frame {
               parent => <-.<-.<-.panel;
               x = 5;
               y => (<-.<-.Position_UI.UIframe_Position.y + <-.<-.Position_UI.UIframe_Position.height) + 10;
               width = 245;
               height => (<-.Frame_Width.y + <-.Frame_Width.height) + 10;
            };
            UIoptionMenu FillColor {
               parent => <-.UIframe_Frame;
               cmdList => <-.<-.color1;
               y = 0;
               selectedItem => <-.<-.<-.Legend_params.FillColor;
               x = 0;
            };
            UIoptionMenu FrameColor {
               parent => <-.UIframe_Frame;
               y => (<-.FillColor.y + <-.FillColor.height) + 10;
               cmdList => <-.<-.color2;
               selectedItem => <-.<-.<-.Legend_params.FrameColor;
               x = 0;
            };
            UIslider Frame_Width {
               parent => <-.UIframe_Frame;
               value<NEportLevels={2,2}> => <-.<-.<-.Legend_params.Frame_Width;
               y => (<-.FrameColor.y + <-.FrameColor.height) + 20;
               width = 150;
               min = 0.;
               max = 4.;
            };
            UIfield Frame_Width_Typein {
               parent => <-.UIframe_Frame;
               value<NEportLevels={2,2}> => <-.Frame_Width.value;
               x => <-.Frame_Width.width + 5;
               y => <-.Frame_Width.y;
               width = 50;
            };
         };
         macro Label_UI {
            UIframe UIframe_Label {
               parent => <-.<-.<-.panel;
               x = 5;
               y => (<-.<-.Frame_UI.UIframe_Frame.y + <-.<-.Frame_UI.UIframe_Frame.height) + 10;
               width = 245;
               height => (<-.Label_Color.y + <-.Label_Color.height) + 10;
            };
            UIslider Label_Height {
               parent => <-.UIframe_Label;
               value<NEportLevels={2,2}> => <-.<-.<-.Legend_params.Label_Height;
               y = 0;
               width = 150;
               min = 0.;
               max = 5.;
            };
            UIfield Label_Height_typein {
               parent => <-.UIframe_Label;
               value<NEportLevels={2,2}> => <-.Label_Height.value;
               x => <-.Label_Height.width + 5;
               y => <-.Label_Height.y;
               width = 50;
            };
            UIfield Number_of_Column {
               parent => <-.UIframe_Label;
               value<NEportLevels={2,2}> => <-.<-.<-.Legend_params.Number;
               y => (<-.Label_Height.y + <-.Label_Height.height) + 10;
               min = 1.;
               max = 5.;
               decimalPoints = 0;
            };
            UIlabel NColumun_label {
               parent => <-.UIframe_Label;
               label => "Number of Column";
               x = 120;
               y => <-.Number_of_Column.y;
            };
            UIoptionMenu Label_Color {
               parent => <-.UIframe_Label;
               y => (<-.Number_of_Column.y + <-.Number_of_Column.height) + 10;
               cmdList => <-.<-.color3;
               selectedItem => <-.<-.<-.Legend_params.Label_Color;
               x = 0;
            };
         };
         macro Title_UI {
            UIframe UIframe_Title {
               parent => <-.<-.<-.panel;
               x = 5;
               y => (<-.<-.Label_UI.UIframe_Label.y + <-.<-.Label_UI.UIframe_Label.height) + 10;
               width = 245;
               height => (<-.Title_Color.y + <-.Title_Color.height) + 10;
            };
            UIslider Title_Height {
               parent => <-.UIframe_Title;
               value<NEportLevels={2,2}> => <-.<-.<-.Legend_params.Title_Height;
               y => (<-.Title.y + <-.Title.height) + 10;
               width = 150;
               min = 0.;
               max = 10.;
            };
            UIfield Title_Height_Typein {
               parent => <-.UIframe_Title;
               value<NEportLevels={2,2}> => <-.Title_Height.value;
               x => <-.Title_Height.width + 5;
               y => <-.Title_Height.y;
               width = 50;
            };
            UIoptionMenu Title_Color {
               parent => <-.UIframe_Title;
               y => (<-.Title_Height.y + <-.Title_Height.height) + 10;
               cmdList => <-.<-.color4;
               selectedItem => <-.<-.<-.Legend_params.Title_Color;
               x = 0;
            };
            UItext Title {
               parent => <-.UIframe_Title;
               text => <-.<-.<-.Legend_params.Title;
               y = 0;
            };
            UIlabel Title_label {
               parent => <-.UIframe_Title;
               label => "Title";
               x = 120;
               y => <-.Title.y;
            };
         };
         UIoption color1[12] = {
            {
               label="antibackground",,,,,,,,,,,
            },
            {
               set=1,,,,,,,,,label="background",,,,,,,,,,,
            },
            {
               label="red",,,,,,,,,,,
            },
            {
               label="green",,,,,,,,,,,
            },
            {
               label="blue",,,,,,,,,,,
            },
            {
               label="yellow",,,,,,,,,,,
            },
            {
               label="magenta",,,,,,,,,,,
            },
            {
               label="cyan",,,,,,,,,,,
            },
            {
               label="black",,,,,,,,,,,
            },
            {
               label="white",,,,,,,,,,,
            },
            {
               label="grey",,,,,,,,,,,
            }
         };
         UIoption color2[12] = {
            {
               set=1,,,,,,,,,label="antibackground",,,,,,,,,,,
            },
            {
               label="background",,,,,,,,,,,
            },
            {
               label="red",,,,,,,,,,,
            },
            {
               label="green",,,,,,,,,,,
            },
            {
               label="blue",,,,,,,,,,,
            },
            {
               label="yellow",,,,,,,,,,,
            },
            {
               label="magenta",,,,,,,,,,,
            },
            {
               label="cyan",,,,,,,,,,,
            },
            {
               label="black",,,,,,,,,,,
            },
            {
               label="white",,,,,,,,,,,
            },
            {
               label="grey",,,,,,,,,,,
            }
         };
         UIoption color3[12] = {
            {
               set=1,,,,,,,,,label="antibackground",,,,,,,,,,,
            },
            {
               label="background",,,,,,,,,,,
            },
            {
               label="red",,,,,,,,,,,
            },
            {
               label="green",,,,,,,,,,,
            },
            {
               label="blue",,,,,,,,,,,
            },
            {
               label="yellow",,,,,,,,,,,
            },
            {
               label="magenta",,,,,,,,,,,
            },
            {
               label="cyan",,,,,,,,,,,
            },
            {
               label="black",,,,,,,,,,,
            },
            {
               label="white",,,,,,,,,,,
            },
            {
               label="grey",,,,,,,,,,,
            }
         };
         UIoption color4[12] = {
            {
               set=1,,,,,,,,,label="antibackground",,,,,,,,,,,
            },
            {
               label="background",,,,,,,,,,,
            },
            {
               label="red",,,,,,,,,,,
            },
            {
               label="green",,,,,,,,,,,
            },
            {
               label="blue",,,,,,,,,,,
            },
            {
               label="yellow",,,,,,,,,,,
            },
            {
               label="magenta",,,,,,,,,,,
            },
            {
               label="cyan",,,,,,,,,,,
            },
            {
               label="black",,,,,,,,,,,
            },
            {
               label="white",,,,,,,,,,,
            },
            {
               label="grey",,,,,,,,,,,
            }
         };
         macro Position_UI {
            UIfield position_x {
               y => (<-.visible.y + <-.visible.height) + 5;
               parent => <-.UIframe_Position;
               value<NEportLevels={2,2}> => <-.<-.<-.Legend_params.Legend_X;
            };
            UIfield position_y {
               y => (<-.position_x.y + .height) + 10;
               parent => <-.UIframe_Position;
               value<NEportLevels={2,2}> => <-.<-.<-.Legend_params.Legend_Y;
            };
            UItoggle visible {
               y = 0;
               width = 120;
               parent => <-.UIframe_Position;
               label => "Legend on/off";
               set => <-.<-.<-.Legend_params.Legend_on_off;
            };
            UIframe UIframe_Position {
               parent => <-.<-.<-.panel;
               x = 5;
               y = 0;
               width = 245;
               height => (<-.position_y.y + <-.position_y.height) + 10;
            };
            UIlabel position_x_label {
               parent => <-.UIframe_Position;
               label => "Legend X position";
               x = 120;
               y => <-.position_x.y;
            };
            UIlabel position_y_label {
               label => "Legend Y position";
               x = 120;
               y => <-.position_y.y;
               parent => <-.UIframe_Position;
            };
         };
      };
      GMOD.instancer inst_LegendUI {
         Value = 1;
         Group => <-.LegendUI;
      };
      group Legend_params<export_all=2> {
         int Legend_on_off<NEportLevels={2,2}> = 1;
         float Legend_X<NEportLevels={2,2}> = 5.5;
         float Legend_Y<NEportLevels={2,2}> = -3.;
         int FillColor<NEportLevels={2,2}> = 1;
         int FrameColor<NEportLevels={2,2}> = 0;
         float Frame_Width<NEportLevels={2,2}> = 0.1;
         float Label_Height<NEportLevels={2,2}> = 2.;
         int Number<NEportLevels={2,2}> = 1;
         int Label_Color<NEportLevels={2,2}> = 0;
         string Title<NEportLevels={2,2}> = "Title";
         float Title_Height<NEportLevels={2,2}> = 4.;
         int Title_Color<NEportLevels={2,2}> = 0;
      };
      link obj<NEportLevels={1,2}> => AGGraphLegend;
   };
}; // General_PolarGraph


macro extract_column {
   DVtable_xyz_create DVtable_xyz_create<NEx=33.,NEy=110.> {
      columns<NEportLevels={3,0}>;
   };
   UIradioBoxLabel UIradioBoxLabel<NEx=187.,NEy=110.> {
      labels => <-.DVtable_xyz_create.xyz_names;
      parent => <-.UImod_panel;
      selectedItem => <-.comp;
      title => "Select Data Column";
   };
   int comp<NEportLevels={2,1},NEx=33.,NEy=165.>;
   UImod_panel UImod_panel<NEx=176.,NEy=33.> {
      parent<NEportLevels={3,0}>;
      title => name_of(<-.<-);
   };
   prim out<NEportLevels={1,2},NEx=33.,NEy=220.>[] => DVtable_xyz_create.field_xyz[comp].values;
};

};
