/*
                Copyright (c) 1992,1994 by
                Advanced Visual Systems Inc.
                All Rights Reserved

 This software comprises unpublished confidential information of Advanced
 Visual Systems Inc. and may not be used, copied or made available to
 anyone, except in accordance with the license under which it is furnished.

 This file is under Perforce control
 $Id: //depot/express/fcs70/v/vizxp/hlm.v#1 $
*/

flibrary+buffered+sort HLM <needs_edit_lic="GD DV"> {

MODS.slice_plane Arbitrary_Slicer {
   UIpanel {
      option {
         set = 1;
      };
   };
   SliceUI {
      xform_toggle {
         y => <-.bounds_toggle.y + <-.bounds_toggle.height;
      };
      UItoggle bounds_toggle {
         parent => <-.UIpanel;
         label => "bounds";
         set<NEportLevels=1, export=4> = 1;
         y = 0;
         width = 110;
      };
      plane_dist {
         width => <-.UIpanel.width * 11 / 12;
      };
   };
   plane_obj {
      Obj {
         visible => <-.<-.SliceUI.bounds_toggle.set;
      };
      Modes {
         mode = {0,2,1,0,0};
      };
   };
};


macro Bubbleviz{
   macro glyph{
      ilink in_field<export_all=1,NEportLevels={3,1}>;
      ilink in_glyph<export_all=1> => <-.Sphere.bounds.out;
      DV_Param_glyph GlyphParam<export_all=2> {
         glyph_comp = 0;
         map_comp<export=4>= 0;
         scale_comp = 0;
         vector = 0;
         scale<export=4>= 0.5;
         scale_x = 1;
         scale_y = 1;
         scale_z = 1;
         normalize = 1;
      };
      DVglyph DVglyph {
         in => <-.in_field;
         glyph => <-.in_glyph;
         vector => param.vector;
         glyph_comp => param.glyph_comp;
         map_comp => param.map_comp;
         scale_comp => param.scale_comp;
         scale => param.scale;
         scale_x => param.scale_x;
         scale_y => param.scale_y;
         scale_z => param.scale_z;
         normalize => param.normalize;
         DV_Param_glyph &param<NEportLevels={2,0}> => <-.GlyphParam;
      };
      GMOD.instancer instancer {
         Value => <-.<-.UIpanel.visible;
         Group => <-.GlyphUI;
         active = 2;
      };
      macro GlyphUI {
         ilink in_fld => <-.in_field;
         DV_Param_glyph &param<NEportLevels={2,0}> => <-.GlyphParam;
         DVnode_data_labels DVnode_data_labels{
            in => <-.in_fld;
            int+nres ncomp => in.nnode_data;
         };
         ilink UIpanel<NEportLevels={3,1}> => <-.<-.UIpanel;
         UIradioBoxLabel UIradioBoxLabel_map {
            parent => <-.UIpanel;
            labels<NEportLevels={2,0}> => <-.DVnode_data_labels.labels;
            &selectedItem => param.map_comp;
            title => "Color Component";
            visible => <-.UIpanel.visible;
            width => <-.UIpanel.width;
         };
         UItoggle norm_toggle{
            y => <-.UIradioBoxLabel_map.y + <-.UIradioBoxLabel_map.height + 4;
            width  => <-.UIpanel.width;
            parent => <-.UIpanel;
            label  => "Normalize";
            set => param.normalize;
         };
         UIslider scale_slider{
            y => <-.norm_toggle.y + <-.norm_toggle.height + 4;
            width  => <-.UIpanel.width;
            parent => <-.UIpanel;
            min = -10.;
            max = 10.;
            value<NEportLevels={2,0}> => param.scale;
            title => "scale";
         };
      };
      DataObjectNoTexture obj {
         in => <-.DVglyph.out;
         Modes {
            mode => {
               0,0,4,0,0
            };
         };
         Obj {
            xform_mode = "Parent";
         };
      };
      olink out_fld<export_all=2,NEportLevels={1,2}> => .DVglyph.out;
      olink out_obj<NEportLevels={1,2}> => .obj.obj;
   };
   macro Sphere{
      int subdiv<export=3> = 6;
      macro sphere_ui{
         ilink isubdiv => <-.subdiv;
         UIslider SubDiv {
            y => ((<-.<-.<-.glyph.GlyphUI.scale_slider.y + <-.<-.<-.glyph.GlyphUI.scale_slider.height) + 10);
            width => <-.<-.<-.UIpanel.width;
            parent<NEportLevels={4,0}> => <-.<-.<-.UIpanel;
            min = 5.;
            max = 50.;
            value => <-.isubdiv;
            mode = "integer";
            title => "Subdivision";
         };
      };
      Field_Spher_Unif sphere{
         nspace = 3;
         ndim = 3;
         dims => {2,<-.subdiv,
            <-.subdiv};
         points = {0.,0.,0.,0.5,
3.14159,6.28318};
      };
      DVbounds bounds {
         in => <-.sphere;
         hull = 0;
         edges = 0;
         faces = 1;
         imin = 0;
         imax = 1;
         jmin = 0;
         jmax = 0;
         kmin = 0;
         kmax = 0;
         data = 0;
         component = 0;
         out<NEportLevels={0,3}>;
         method+notify_val+notify_inst upd_bounds = "DVbounds_update";
      };
   };
   UImod_panel UIpanel {
      parent<NEportLevels={3,0}>;
      message = "Select Glyph control panel.";
      title => name_of(<-.<-);
      option {
         set = 1;
      };
   };
   link out_fld<NEportLevels={1,1},export=3> => glyph.out_fld;
   link out_obj<NEportLevels={1,2}> => glyph.out_obj;
};


macro Orthogonal_Slicer {
   macro Orthogonal_slicer_UI{
      macro OrthoSliceUI {
         DV_Param_ortho_slice &param<NEportLevels={2,0}> => <-.<-.OrthoSliceParam;
         UIslider axis_slider {
            y => <-.bounds_toggle.y + <-.bounds_toggle.height + 5;
            parent => <-.UIpanel;
            max+nres<NEportLevels={2,0}> => in_field.ndim - 1;
            value<NEportLevels={2,0}> => param.axis;
            mode = "integer";
            title => "axis";
         };
         UIslider plane_slider {
            y => <-.axis_slider.y + <-.axis_slider.height + 4;
            parent => <-.UIpanel;
            max+nres<NEportLevels={2,0}> => in_field.dims[param.axis] - 1;
            value<NEportLevels={2,0}> => param.plane;
            mode = "integer";
            title => "plane";
         };
         UItoggle bounds_toggle {
            parent => <-.UIpanel;
            set<NEportLevels={1,0},export=5>= 1;
            y = 0;
            label ="bounds" ;
            width = 110;
         };
         UIfield typein_axis {
            parent => <-.UIpanel;
            value => <-.axis_slider.value;
            x => <-.axis_slider.width;
            y => <-.axis_slider.y;
            width = 50;
         };
         UIfield typein_plane {
            parent => <-.UIpanel;
            value => <-.plane_slider.value;
            x => <-.plane_slider.width;
            y => <-.plane_slider.y;
            width = 50;
         };
         link UIpanel<NEportLevels={2,1}> => <-.panel;
      };
      link in_field<NEportLevels={2,1}> => <-.in_field;
      link panel<NEportLevels={2,1}> => UIpanel;
   };
   DV_Param_ortho_slice OrthoSliceParam<export_all=2,NEportLevels={0,1}> {
      axis<NEportLevels={2,2}> => 0;
      plane+nres<NEportLevels={2,2}> = 0;
   };
   DVorthoslice DVorthoslice {
      in => <-.in_field;
      &axis => param.axis;
      &plane => param.plane;
      DV_Param_ortho_slice &param<NEportLevels={2,0}> => <-.OrthoSliceParam;
   };
   DataObjectNoTexture obj_orthoslice {
      in => <-.DVorthoslice.out;
      Obj {
         xform_mode = "Parent";
      };
   };
   DVbounds DVbounds {
      in => DVorthoslice.out;
      hull = 1;
      edges = 0;
      faces = 0;
      imin = 0;
      imax = 0;
      jmin = 0;
      jmax = 0;
      kmin = 0;
      kmax = 0;
      data = 0;
      component = 0;
   };
   DataObjectNoTexture obj_bounds{
      in => <-.DVbounds.out;
      Obj {
         xform_mode = "Parent";
         visible => <-.<-.Orthogonal_slicer_UI.OrthoSliceUI.bounds_toggle.set;
      };
      instancer;
   };
   link in_field<NEportLevels={2,1}>;
   link out_fld<NEportLevels={1,2}> => .DVorthoslice.out;
   UImod_panel UIpanel{
      parent<NEportLevels={3,0}>;
      message = "Select Slice control panel.";
      title => name_of(<-.<-);
      option {
         set = 1;
      };
   };
   GMOD.instancer inst_ortho_UI{
      Value => <-.UIpanel.visible;
      Group => Orthogonal_slicer_UI;
   };
   link slice_plane<NEportLevels={1,2}> => obj_orthoslice.obj;
   link boundary<NEportLevels={1,2}> => obj_bounds.obj;
};

/* a copy of GDM.Viewers.OutputField to avoid runtime mapping issue (7767) */
macro HLMOutputField<NEvisible=0> {
   GDview_templ &view_in<NEportLevels={2,1}>;
   VIEW.Viewers.OutputField output_field {
      UImod_panel {
         title => name_of(<-.<-.<-);
      };
      render_view+nres => <-.view_in.render_view;
      view_in => <-.view_in;
      Output {
         output<NEportLevels={0,4}>;
      };
      DataObject {
         Obj {
            name => name_of(<-.<-.<-.<-);
         };
         obj<NEportLevels={0,4}>;
      };
   };
};

HLMOutputField OutputImage<NEvisible=1> {
   int width  => output_field.UIrenderView.width;
   int height => output_field.UIrenderView.height;
   macro output_field {
      UIrenderView+nres &render_view<NEportLevels={2,1}> => <-.view_in.render_view;
      GDview_templ &view_in<NEportLevels={2,1}> => <-.view_in;
      UIrenderView UIrenderView {
         y = 0;
         width =>  <-.write_image_ui.UIslider_width.value;
         height => <-.write_image_ui.UIslider_height.value;
         visible = 0;
         parent => <-.render_view.parent;
      };
      BestVirtPal VirtPal {
         vclass => view_in.virtpal.vclass;
         vid => view_in.virtpal.vid;
         share = 0;
         gamma = 1.;
         cube_size => view_in.virtpal.cube_size;
      };
      DefaultFieldOutput Output;
      DefaultView View {
         mode = "Manual";
         back_col => view_in.back_col;
         light_info => view_in.light_info;
         cameras => view_in.cameras;
         output => <-.Output;
         handle => <-.UIrenderView.handle;
         virtpal => <-.VirtPal;
         output_enabled = 1;
      };
      macro write_image_ui {
         UImod_panel panel {
            title => name_of(<-.<-.<-.<-);
            message = "Select write image control panel.";
            parent<NEportLevels={4,0}>;
            option {
               set = 1;
            };
         };
         UIlabel Image_Filename {
            parent => <-.panel;
            y = 0;
            width = 200;
            alignment = "left";
         };
         UItext file_name {
            parent => <-.panel;
            y => <-.Image_Filename.y + <-.Image_Filename.height + 5;
            text => <-.filename;
            width = 170;
            showLastPosition = 1;
         };
         UIbutton visible {
            parent => <-.panel;
            x => <-.file_name.x + <-.file_name.width + 5;
            y => <-.file_name.y;
            width = 75;
            height => <-.file_name.height;
            label => "Browse...";
         };
         UIbutton write_oneshot {
            parent => <-.panel;
            label => "Write File";
            y => <-.visible.y + <-.visible.height + 8;
            width => <-.panel.width;
            do => <-.<-.View.refresh;
         };
         UItoggle overwrite_toggle {
            parent => <-.panel;
            label => "Overwrite";
            set<NEportLevels={2,0}>;
            y => <-.write_oneshot.y + <-.write_oneshot.height + 4;
            width => <-.panel.width;
         };
         UItoggle flip_toggle {
            parent => <-.panel;
            label => "flip";
            set<NEportLevels={2,0}> = 1;
            y => <-.overwrite_toggle.y + <-.overwrite_toggle.height + 4;
            width => <-.panel.width;
         };
         UIfileSB file_browser {
            GMOD.copy_on_change copy_on_change {
               trigger => <-.<-.visible.do;
               input => <-.<-.visible.do;
               output => <-.visible;
            };
            title => "Write IMAGE Filename";
            searchPattern = "";
         };
         UIframe format_frame {
            parent => <-.panel;
            visible => <-.panel.visible;
            y => <-.flip_toggle.y + <-.flip_toggle.height + 4;
            width => <-.panel.width;
            height => <-.format_rb.y + <-.format_rb.height + 6;
         };
         UIlabel format_label {
            parent => <-.format_frame;
            label => "File Format";
            x = 4;
            y = 0;
            width => <-.panel.width;
         };
         UIoption format_avsx {
            label => "avs .x";
            message = "AVS .x format";
            active = 1;
            set = 1;
         };
         UIoption format_bmp {
            label => "BMP";
            message = "Microsoft BMP format";
            active = 1;
         };
         UIoption format_gif {
            label => "GIF";
            message = "Graphics Interchange Format";
            active = 1;
         };
         UIoption format_jpeg {
            label => "JPEG";
            message = "JFIF: JPEG File Interchange Format";
            active = 1;
         };
         UIoption format_pbm {
            label => "PBM";
            message = "Portable Bitmap Utilities";
            active = 1;
         };
         UIoption format_sgi {
            label => "SGI Image";
            message = "SGI Image format";
            active = 1;
         };
         UIoption format_sun {
            label => "Sun Raster";
            message = "Sun Rasterfile format";
            active = 0;
         };
         UIoption format_tiff {
            label => "TIFF";
            message = "Tag Image File Format";
            active = 1;
         };
         UIradioBox format_rb {
            parent => <-.format_frame;
            cmdList => {
               <-.format_avsx,<-.format_bmp,<-.format_gif,<-.format_jpeg,
               <-.format_pbm,<-.format_sgi,<-.format_sun,<-.format_tiff
            };
            visible => <-.panel.visible;
            selectedItem = 0;
            x = 4;
            y => <-.format_label.y + <-.format_label.height + 4;
            width => <-.panel.width;
         };
         UIframe bpp_frame {
            parent => <-.panel;
            visible => <-.panel.visible;
            y => <-.format_frame.y + <-.format_frame.height + 4;
            width => <-.panel.width;
            height => <-.bpp_rb.y + <-.bpp_rb.height + 6;
         };
         UIlabel bpp_label {
            parent => <-.bpp_frame;
            label => "Bits Per Pixel";
            x = 4;
            y = 0;
            width => <-.panel.width;
         };
         UIoption bpp_0 {
            label => "Not Applicable";
            message = "Not applicable";
            active => switch((<-.format_rb.selectedItem + 1),0,0,0,1,1,1,0,1);
         };
         UIoption bpp_1 {
            label => "1";
            message = "1 bit per pixel";
            active => switch((<-.format_rb.selectedItem + 1),0,0,0,0,0,0,0,0);
         };
         UIoption bpp_4 {
            label => "4";
            message = "4 bits per pixel";
            active => switch((<-.format_rb.selectedItem + 1),0,0,0,0,0,0,0,0);
         };
         UIoption bpp_8 {
            label => "8";
            message = "8 bits per pixel";
            active => switch((<-.format_rb.selectedItem + 1),0,0,1,0,0,0,0,0);
         };
         UIoption bpp_16 {
            label => "16";
            message = "16 bits per pixel";
            active => switch((<-.format_rb.selectedItem + 1),0,0,0,0,0,0,0,0);
         };
         UIoption bpp_24 {
            label => "24";
            message = "24 bits per pixel";
            active => switch((<-.format_rb.selectedItem + 1),0,1,0,0,0,0,0,0);
         };
         UIoption bpp_32 {
            label => "32";
            message = "32 bits per pixel";
            active => switch((<-.format_rb.selectedItem + 1),1,0,0,0,0,0,0,0);
            set = 1;
         };
         UIradioBox bpp_rb {
            parent => <-.bpp_frame;
            cmdList => {
               <-.bpp_0,<-.bpp_1,<-.bpp_4,<-.bpp_8,<-.bpp_16,<-.bpp_24,
               <-.bpp_32
            };
            visible => <-.panel.visible;
            selectedItem => switch((<-.format_rb.selectedItem + 1),6,5,3,0,0,0,0,0);
            x = 4;
            y => <-.bpp_label.y + <-.bpp_label.height + 4;
            width => <-.panel.width;
         };
         UIframe color_frame {
            parent => <-.panel;
            visible => <-.panel.visible;
            y => <-.bpp_frame.y + <-.bpp_frame.height + 4;
            width => <-.panel.width;
            height => <-.color_rb.y + <-.color_rb.height + 6;
         };
         UIlabel color_label {
            parent => <-.color_frame;
            label => "Color Type";
            x = 4;
            y = 0;
            width => <-.panel.width;
         };
         UIoption color_rgb {
            label => "RGB";
            message = "Red, Green, Blue";
            active => switch((<-.format_rb.selectedItem + 1),1,1,1,1,1,1,0,1);
            set = 1;
         };
         UIoption color_grey {
            label => "Greyscale";
            message = "Grey levels";
            active => switch((<-.format_rb.selectedItem + 1),1,0,1,1,1,0,0,1);
         };
         UIoption color_bw {
            label => "BW";
            message = "Black, White";
            active => switch((<-.format_rb.selectedItem + 1),0,0,0,0,1,0,0,0);
         };
         UIradioBox color_rb {
            parent => <-.color_frame;
            cmdList => {<-.color_rgb,<-.color_grey,<-.color_bw};
            visible => <-.panel.visible;
            selectedItem => switch((<-.format_rb.selectedItem + 1),0,0,0,0,0,0,0,0);
            x = 4;
            y => <-.color_label.y + <-.color_label.height + 4;
            width => <-.panel.width;
         };
         UIframe compression_frame {
            parent => <-.panel;
            visible => <-.panel.visible;
            y => <-.color_frame.y + <-.color_frame.height + 4;
            width  => <-.panel.width;
            height => <-.quality.y + <-.quality.height + 6;
         };
         UIlabel compression_label {
            parent => <-.compression_frame;
            label => "Compression Type";
            x = 4;
            y = 0;
            width => <-.panel.width;
         };
         UIoption compression_none {
            label => "none";
            message = "no compression";
            active => switch((<-.format_rb.selectedItem + 1),1,1,0,0,1,1,0,1);
            set = 1;
         };
         UIoption compression_rle {
            label => "RLE";
            message = "Run Length Encoded";
            active => switch((<-.format_rb.selectedItem + 1),0,0,0,0,0,1,0,1);
         };
         UIoption compression_lzw {
            label => "LZW";
            message = "LZW Compression";
            active => switch((<-.format_rb.selectedItem + 1),0,0,1,0,0,0,0,1);
         };
         UIoption compression_jpeg {
            label => "JPEG";
            message = "JPEG Compression";
            active => switch((<-.format_rb.selectedItem + 1),0,0,0,1,0,0,0,0);
         };
         UIoption compression_ccitt3 {
            label => "CCITT Group 3";
            message = "CCITT T.4 Compression";
            active => switch((<-.format_rb.selectedItem + 1),0,0,0,0,0,0,0,1);
         };
         UIoption compression_ccitt4 {
            label => "CCITT Group 4";
            message = "CCITT T.6 Compression";
            active => switch((<-.format_rb.selectedItem + 1),0,0,0,0,0,0,0,1);
         };
         UIradioBox compression_rb {
            parent => <-.compression_frame;
            cmdList => {
               <-.compression_none,<-.compression_rle,<-.compression_lzw,
               <-.compression_jpeg,<-.compression_ccitt3,<-.compression_ccitt4
            };
            visible => <-.panel.visible;
            selectedItem => switch((<-.format_rb.selectedItem + 1),0,0,2,3,0,0,0,1);
            x = 4;
            y => <-.compression_label.y + <-.compression_label.height + 4;
            width => <-.panel.width;
         };
         UIslider quality {
            parent => <-.compression_frame;
            title => "Quality";
            min = 0.;
            max = 100.;
            value = 75.;
            active => switch((<-.format_rb.selectedItem + 1),0,0,0,1,0,0,0,0);
            visible => <-.panel.visible;
            x = 4;
            y => <-.compression_rb.y + <-.compression_rb.height + 4;
            width => <-.panel.width;
         };
         UIframe reduction_frame {
            parent => <-.panel;
            visible => <-.panel.visible;
            y => <-.compression_frame.y + <-.compression_frame.height + 4;
            width => <-.panel.width;
            height => <-.reduction_rb.y + <-.reduction_rb.height + 6;
         };
         UIlabel reduction_label {
            parent => <-.reduction_frame;
            label => "Reduction Type";
            x = 4;
            y = 0;
            width => <-.panel.width;
         };
         UIoption reduction_na {
            label => "Not Applicable";
            message = "Not applicable";
            active => switch((<-.format_rb.selectedItem + 1),1,0,0,1,1,0,0,1);
            set = 1;
         };
         UIoption reduction_ex {
            label => "Exhaustive";
            message = "Exhaustive Reduction";
            active => switch((<-.format_rb.selectedItem + 1),0,0,0,0,0,0,0,0);
         };
         UIoption reduction_mc {
            label => "Median Cut";
            message = "Median Cut Reduction";
            active => switch((<-.format_rb.selectedItem + 1),0,0,0,0,0,0,0,0);
         };
         UIoption reduction_pop {
            label => "Popularity";
            message = "Popularity Reduction";
            active => switch((<-.format_rb.selectedItem + 1),0,0,0,0,0,0,0,0);
         };
         UIoption reduction_fs {
            label => "Floyd Steinberg";
            message = "Floyd Steinberg Dithering";
            active => switch((<-.format_rb.selectedItem + 1),0,0,1,0,0,0,0,0);
         };
         UIradioBox reduction_rb {
            parent => <-.reduction_frame;
            cmdList => {
               <-.reduction_na,<-.reduction_ex,<-.reduction_mc,
               <-.reduction_pop,<-.reduction_fs
            };
            visible => <-.panel.visible;
            selectedItem => switch((<-.format_rb.selectedItem + 1),0,0,4,0,0,0,0,0);
            x = 4;
            y => <-.reduction_label.y + <-.reduction_label.height + 4;
            width => <-.panel.width;
         };
         UIframe filetype_frame {
            parent => <-.panel;
            visible => <-.panel.visible;
            y => <-.reduction_frame.y + <-.reduction_frame.height + 4;
            width => <-.panel.width;
            height => <-.filetype_rb.y + <-.filetype_rb.height + 6;
         };
         UIlabel filetype_label {
            parent => <-.filetype_frame;
            label => "File Type";
            x = 4;
            y = 0;
            width => <-.panel.width;
         };
         UIoption filetype_binary {
            label => "binary";
            message = "binary type";
            active => switch((<-.format_rb.selectedItem + 1),1,1,1,1,1,0,0,1);
            set = 1;
         };
         UIoption filetype_ascii {
            label => "ASCII";
            message = "ASCII type";
            active => switch((<-.format_rb.selectedItem + 1),0,0,0,0,1,0,0,0);
         };
         UIradioBox filetype_rb {
            parent => <-.filetype_frame;
            cmdList => {<-.filetype_binary,
               <-.filetype_ascii};
            visible => <-.panel.visible;
            selectedItem => switch((<-.format_rb.selectedItem + 1),0,0,0,0,0,0,0,0);
            x = 4;
            y => <-.filetype_label.y + <-.filetype_label.height + 4;
            width => <-.panel.width;
         };
         UIframe resolution_frame {
            parent => <-.panel;
            y => <-.filetype_frame.y + <-.filetype_frame.height + 4;
            width = 250;
            int height_tmp => <-.UIslider_height.y + <-.UIslider_height.height + 20;
            // The Motif version of UIframe has a quirk where if it sees
            // an undefined value for height (or width) it will supply a
            // default value and write that value back out to the OM,
            // potentially wiping out a connection.  Avoid the issue by
            // making sure height always has a valid value.  CFS PR 29888.
            height => switch( is_valid( .height_tmp)+1, 150, .height_tmp );
         };
         UIlabel Resolution {
            parent => <-.resolution_frame;
            label => "Output Image Size";
            y = 0;
            width => .parent.clientWidth;
            alignment = "center";
         };
         VUISlider UIslider_width {
            y => <-.Resolution.y + <-.Resolution.height + 5;
            parent => <-.resolution_frame;
            width  => .parent.clientWidth;
            max = 4096.;
            value = 500.;
            //mode = "integer";
            mode = 1;
            title => "Width";
         };
         VUISlider UIslider_height {
            y => <-.UIslider_width.y + <-.UIslider_width.height + 5;
            parent => <-.resolution_frame;
            width  => .parent.clientWidth;
            max = 4096.;
            value = 500.;
            // mode = "integer";
            mode = 1;
            title => "Height";
         };
         string filename<export=4,NEportLevels={1,2}> => .file_browser.filename;
         int output<export=4,NEportLevels={1,2}> => .write_oneshot.do;
         int overwrite<export=4,NEportLevels={1,2}> => .overwrite_toggle.set;
         int flip<export=4,NEportLevels={1,2}> => .flip_toggle.set;
         int format<export=4,NEportLevels={1,2}> => .format_rb.selectedItem;
         int depth<export=4,NEportLevels={1,2}> => .bpp_rb.selectedItem;
         int colortype<export=4,NEportLevels={1,2}> => .color_rb.selectedItem;
         int compresstype<export=4,NEportLevels={1,2}> => .compression_rb.selectedItem;
         float compressqual<export=4,NEportLevels={1,2}> => .quality.value;
         int reducetype<export=4,NEportLevels={1,2}> => .reduction_rb.selectedItem;
         int filetype<export=4,NEportLevels={1,2}> => .filetype_rb.selectedItem;
         int width<export=4,NEportLevels={1,2}> => .UIslider_width.value;
         int height<export=4,NEportLevels={1,2}> => .UIslider_height.value;
      };
      DVwrite_image DVwrite_image {
         in {nnodes+req;} => <-.Output.output;
         filename => <-.write_image_ui.filename;
         output => <-.write_image_ui.output;
         flip => <-.write_image_ui.flip;
         format => <-.write_image_ui.format;
         filetype => <-.write_image_ui.filetype;
         depth => <-.write_image_ui.depth;
         colortype => <-.write_image_ui.colortype;
         compresstype => <-.write_image_ui.compresstype;
         compressqual => <-.write_image_ui.compressqual;
         reducetype => <-.write_image_ui.reducetype;
         overwrite => <-.write_image_ui.overwrite;
      };
   };
};


macro Particle_Advector {
   macro advector {
      ilink in_field<export_all=1,NEportLevels={2,1}> => <-.in_field;
      ilink in_probe<export_all=1,NEportLevels={2,1}> => <-.particle_probes.DVswitch.out;
      ilink in_glyph<export_all=1,NEportLevels={2,1}> => <-.particle_glyph.DVswitch.out;
      DV_Param_advect AdvectParam<NEportLevels=1,export_all=3> {
         component = 0;
         order = 2;
         forw_back = 1;
         nseg = 2;
         max_seg = 256;
         min_vel = 1e-05;
         run = 0;
         reset = 0;
         cycle = 0;
         start = 0.;
         end = 1.;
         incr = 0.2;
         count = 0.;
         release_interval = 0.;
         vector = 1;
         scale = 0.2;
         normalize = 0.;
      };
      Advect Advect {
         in_fld => <-.in_field;
         in_prb => <-.in_probe;
         in_glp => <-.in_glyph;
         param => <-.AdvectParam;
      };
      GMOD.instancer instancer {
         Group => <-.AdvectUI;
         active = 2;
      };
      macro AdvectUI {
         ilink in_fld => <-.in_field;
         DV_Param_advect &param<NEportLevels={2,0}> => <-.AdvectParam;
         ilink UIpanel<NEportLevels={3,1}> => .UIframe_advector;
         UIslider nseg_slider {
            y => <-.Advect_label.y + <-.Advect_label.height + 10;
            width => <-.UIpanel.width - 10;
            parent => <-.UIpanel;
            max = 16.;
            value<NEportLevels={2,0}> => param.nseg;
            mode = "integer";
            title => "N-segments";
         };
         UIslider max_seg_slider {
            y => <-.nseg_slider.y + <-.nseg_slider.height + 4;
            width => <-.UIpanel.width - 10;
            parent => <-.UIpanel;
            min = 1.;
            max = 10000.;
            value<NEportLevels={2,0}> => param.max_seg;
            mode = "integer";
            title => "Max Segments";
         };
         UIslider order_slider {
            y => <-.max_seg_slider.y + <-.max_seg_slider.height + 4;
            width => <-.UIpanel.width - 10;
            parent => <-.UIpanel;
            min = 1.;
            max = 4.;
            value<NEportLevels={2,0}> => param.order;
            mode = "integer";
            title => "Order";
         };
         UIslider vel_slider {
            y => <-.order_slider.y + <-.order_slider.height + 4;
            parent => <-.UIpanel;
            value<NEportLevels={2,0}> => param.min_vel;
            title => "Min Velocity";
            width => (<-.UIpanel.width - 10) * 11 / 12;
         };
         VUIslider_typein vel_slider_typein {
            slider      => vel_slider;
            width = 20;
         };
         UIradioBoxLabel UIradioBoxLabel_dir {
            parent => <-.UIpanel;
            labels<NEportLevels={2,0}> => {,};
            &selectedItem => param.forw_back;
            title => "Direction";
            visible => <-.UIpanel.visible;
            y => <-.vel_slider.y + <-.vel_slider.height + 4;
            width => <-.UIpanel.width;
            label_cmd {
               cmd[2] = {
                  {
                     label="backward",,,,,,,,,,,
                  },
                  {
                     set=1,,,,,,,,,label="forward",,,,,,,,,,,
                  }};
               outItem => inItem;
            };
         };
         UIradioBoxLabel UIradioBoxLabel_mode {
            parent => <-.UIpanel;
            labels<NEportLevels={2,0}> => {,,};
            &selectedItem => param.vector;
            title => "Mode";
            visible => <-.UIpanel.visible;
            y => <-.UIradioBoxLabel_dir.y + <-.UIradioBoxLabel_dir.height + 4;
            width => <-.UIpanel.width;
            label_cmd {
               cmd[3] = {
                  {
                     label="scalar",,,,,,,,,,,
                  },
                  {
                     set=1,,,,,,,,,label="vector",,,,,,,,,,,
                  },
                  {
                     label="components",,,,,,,,,,,
                  }};
               outItem => inItem;
            };
         };
         UItoggle norm_toggle {
            y => <-.UIradioBoxLabel_mode.y + <-.UIradioBoxLabel_mode.height + 4;
            width => <-.UIpanel.width;
            parent => <-.UIpanel;
            label => "Glyph Normalize";
            set<NEportLevels={2,0}> => param.normalize;
         };
         UIslider scale_slider {
            y => <-.norm_toggle.y + <-.norm_toggle.height + 4;
            parent => <-.UIpanel;
            min = -10.;
            max = 10.;
            value<NEportLevels={2,0}> => param.scale;
            title => "Glyph Scale";
            width => (<-.UIpanel.width - 10) * 11 / 12;
         };
         VUIslider_typein scale_slider_typein {
            slider      => scale_slider;
            width = 20;
         };
         UIslider start_slider {
            y => <-.scale_slider.y + <-.scale_slider.height + 4;
            parent => <-.UIpanel;
            value<NEportLevels={2,0}> => param.start;
            title => "Start Time";
            width => (<-.UIpanel.width - 10) * 11 / 12;
         };
         VUIslider_typein start_slider_typein {
            slider      => start_slider;
            width = 20;
         };
         UIslider end_slider {
            y => <-.start_slider.y + <-.start_slider.height + 4;
            parent => <-.UIpanel;
            value<NEportLevels={2,0}> => param.end;
            title => "End Time";
            width => (<-.UIpanel.width - 10) * 11 / 12;
         };
         VUIslider_typein end_slider_typein {
            slider      => end_slider;
            width = 20;
         };
         UIslider incr_slider {
            y => <-.end_slider.y + <-.end_slider.height + 4;
            parent => <-.UIpanel;
            max = 10.;
            value<NEportLevels={2,0}> => param.incr;
            title => "Step";
            width => (<-.UIpanel.width - 10) * 11 / 12;
         };
         VUIslider_typein incr_slider_typein {
            slider => incr_slider;
            width = 20;
         };
         UIslider interval_slider {
            y => <-.incr_slider.y + <-.incr_slider.height + 4;
            parent => <-.UIpanel;
            max = 10.;
            value<NEportLevels={2,0}> => param.release_interval;
            title => "Release Interval";
            width => (<-.UIpanel.width - 10) * 11 / 12;
         };
         VUIslider_typein interval_slider_typein {
            slider => interval_slider;
            width = 20;
         };
         UIfieldTypein time_typein {
            UIparent => <-.UIpanel;
            flabel => "Time";
            fval<NEportLevels={2,0}> => param.count;
            panel {
               y => <-.<-.interval_slider.y + <-.<-.interval_slider.height + 4;
               width => <-.<-.UIpanel.width;
            };
            x = 0;
         };
         UItoggle run_toggle {
            y => <-.time_typein.panel.y + <-.time_typein.panel.height + 4;
            width => <-.UIpanel.width;
            parent => <-.UIpanel;
            label => "Run";
            set<NEportLevels={2,0}> => param.run;
         };
         UItoggle reset_toggle {
            y => <-.run_toggle.y + <-.run_toggle.height + 4;
            width => <-.UIpanel.width;
            parent => <-.UIpanel;
            label => "Reset Time";
            set<NEportLevels={2,0}> => param.reset;
         };
         UItoggle cycle_toggle {
            y => <-.reset_toggle.y + <-.reset_toggle.height + 4;
            width => <-.UIpanel.width;
            parent => <-.UIpanel;
            label => "Cycle";
            set<NEportLevels={2,0}> => param.cycle;
         };
         UItoggle stream_toggle {
            parent => <-.UIpanel;
            label => "Streamline on/off";
            set = 1;
            y = 2;
            width = 130;
         };
         UIlabel Advect_label {
            parent => <-.UIpanel;
            label => "Advector parameter";
            x => (.width / 2);
            width = 120;
            y => <-.stream_toggle.y + <-.stream_toggle.height + 10;
            alignment = "center";
         };
         UIframe UIframe_advector {
            parent => <-.<-.<-.panel;
            width = 240;
            y => ((<-.<-.<-.particle_glyph.UIframe_probe.y + <-.<-.<-.particle_glyph.UIframe_probe.height) + 10);
            height => <-.cycle_toggle.y + <-.cycle_toggle.height + 10;
         };
      };
      DataObjectNoTexture obj {
         in => <-.Advect.out_fld;
         Obj {
            alt_xform+nres => <-.<-.plane.xform;
            xform_mode = "Parent";
            type = "Dynamic";
         };
         Modes {
            mode => { 0,GD_LINES,0,0,0 };
            outline => (<-.<-.<-.particle_glyph.outline_on_off.set == 0);
         };
      };
      DataObjectNoTexture obj1 {
         in => <-.Advect.out_fld1;
         Obj {
            alt_xform+nres => <-.<-.in_probe.xform;
            xform_mode = "Parent";
            visible => <-.<-.AdvectUI.stream_toggle.set;
         };
      };
      olink out_fld<export_all=2,NEportLevels={1,2}> => .Advect.out_fld;
      olink out_fld1<export_all=2,NEportLevels={1,2}> => .Advect.out_fld1;
      olink out_obj<NEportLevels={1,2}> => .obj.obj;
      olink out_obj1<NEportLevels={1,2}> => .obj1.obj;
      int stream_on_off<export=3,NEportLevels=1> => AdvectUI.stream_toggle.set;
   };
   macro particle_probes {
      macro FLine3D {
         group &in<NEportLevels={2,0}> {
            group coordinates;
         } => <-.Field_in;
         float+nres xlate[3] => {0.,
            ((in.coordinates.min_vec[1] + in.coordinates.max_vec[1]) / 2),
            ((in.coordinates.min_vec[2] + in.coordinates.max_vec[2]) / 2)};
         Mesh_Unif line3<NEcolor1=255> {
            nspace = 1;
            ndim = 1;
            dims => {<-.<-.dim1};
            points+nres => {
               in.coordinates.min_vec[0],in.coordinates.max_vec[0]};
            xform {
               xlate+nres => cache(<-.<-.xlate);
               mat = {
                  -0.00485718,0.000537954,-0.999988,0.,0.999672,0.0251314,-0.00484213,
0.,0.0251285,-0.999684,-0.000659846,0.,0.,0.,0.,1.
               };
            };
         };
         olink out_fld<NEportLevels={1,2}> => .line3;
      };
      macro FPoint3D {
         group &in<NEportLevels={2,0}> {
            group coordinates;
         } => <-.Field_in;
         Mesh point3 {
            nnodes = 1;
            nspace = 3;
            coordinates {
               values+nres => {
                  {
                     ((in.coordinates.min_vec[0] + in.coordinates.max_vec[0]) / 2.),
                     ((in.coordinates.min_vec[1] + in.coordinates.max_vec[1]) / 2.),
                     ((in.coordinates.min_vec[2] + in.coordinates.max_vec[2]) / 2.)}};
            };
            ncell_sets = 1;
            Point cell_set {
               ncells = 1;
               node_connect_list = {0};
            };
         };
         olink out_fld<NEportLevels={1,2}> => .point3;
      };
      macro FPlane {
         group &in<NEportLevels={2,0}> {
            group coordinates;
         } => <-.Field_in;
         float+nres xlate[3] => {0.,0.,
            ((in.coordinates.min_vec[2] + in.coordinates.max_vec[2]) / 2)};
         Mesh_Unif plane<NEcolor1=65280> {
            nspace = 2;
            ndim = 2;
            dims => {<-.<-.dim1,
               <-.<-.dim2};
            points+nres => {
               in.coordinates.min_vec[0],in.coordinates.min_vec[1],
               in.coordinates.max_vec[0],in.coordinates.max_vec[1]};
            xform {
               xlate+nres;
            };
         };
         olink out_fld<NEportLevels={1,2}> => .plane;
      };
      macro probe_ui {
         ilink idim1<NEportLevels={2,1}> => <-.dim1;
         ilink idim2<NEportLevels={2,1}> => <-.dim2;
         ilink iobj<NEportLevels={2,1}> => <-.DVswitch.out;
         UIslider dim1_slider {
            y => <-.UIradioBoxLabel.y + <-.UIradioBoxLabel.height + 4;
            parent => <-.link;
            min = 2.;
            max = 100.;
            value => <-.idim1;
            mode = "integer";
            title => "x-dimension";
            active => switch((<-.UIradioBoxLabel.selectedItem + 1),0,1,1);
         };
         UIslider dim2_slider {
            y => <-.dim1_slider.y + <-.dim1_slider.height + 4;
            parent => <-.link;
            min = 2.;
            max = 100.;
            value => <-.idim2;
            mode = "integer";
            title => "y-dimension";
            active => switch((<-.UIradioBoxLabel.selectedItem + 1),0,0,1);
         };
         UItoggle xform_toggle {
            y => <-.dim2_slider.y + <-.dim2_slider.height + 8;
            width = 200;
            parent => <-.link;
            label => "Transformation Editor";
         };
         XformEditor probe_edit {
            obj_in => <-.iobj;
            vis => <-.xform_toggle.set;
            GDxform_editor {
               x_rot = 0.;
               y_rot = 0.;
               z_rot = 0.;
               abs_z_rot = 35.06999969;
               abs_y_rot = 78.79000092;
               abs_x_rot = 38.53572083;
            };
            XformEditorUI {
               trans_shell {
                  ok = 1;
               };
            };
         };
         UIradioBoxLabel UIradioBoxLabel {
            labels => <-.string;
            selectedItem = 2;
            label_cmd {
               cmd[3] = {,,
                  {
                     set=1,,,,,,,,,,,,,,,,,,,,
                  }};
            };
            parent => <-.link;
            title => "Probe parameter";
            y => <-.probe_toggle.y + <-.probe_toggle.height;
         };
         string string<NEportLevels={1,1}>[] = {"Point","Line", "Plane"};
         link link<NEportLevels={3,1}> => <-.<-.particle_glyph.UIframe_probe;
         UItoggle probe_toggle {
            parent => <-.link;
            label => "Probe on/off";
            set = 1;
            y = 2;
         };
      };
      int dim1<export=3> = 4;
      int dim2<export=3> = 4;
      DVM.DVswitch DVswitch {
         in => {
            <-.FPoint3D.out_fld,<-.FLine3D.out_fld,<-.FPlane.out_fld};
         index => <-.probe;
         out<NEportLevels={1,3}>;
      };
      link Field_in<NEportLevels={2,1}> => <-.in_field;
      int probe<NEportLevels={1,1}> => .probe_ui.UIradioBoxLabel.selectedItem;
      int probe_on_off<export=3,NEportLevels={1,0}> => probe_ui.probe_toggle.set;
   };
   macro particle_glyph {
      macro Diamond3D {
         Tri set1 {
            ncells = 8;
            node_connect_list = {
               2,5,0,2,1,5,2,4,1,2,0,4,3,0,5,3,5,1,3,1,4,3,4,0
            };
         };
         Mesh diamond {
            int nnodes = 6;
            int nspace = 3;
            coordinates {
               float values[.nvals][.veclen] = {
                  -0.5,0.,0.,0.5,0.,0.,0.,-0.5,0.,0.,0.5,0.,0.,0.,-0.5,0.,
0.,0.5
               };
            };
            int ncell_sets = 1;
            cell_set => {<-.set1};
         };
         olink out_fld<NEportLevels={1,2}> => .diamond;
      };
      macro Arrow2 {
         Quad set1 {
            ncells = 1;
            node_connect_list = {0,1,2,3};
         };
         Tri set2 {
            ncells = 1;
            node_connect_list = {4,5,6};
         };
         Mesh glyph2 {
            int nnodes = 7;
            int nspace = 3;
            coordinates {
               float values[.nvals][.veclen] = {
                  0.,-0.1,0.,0.7,-0.1,0.,0.7,0.1,0.,0.,0.1,0.,0.7,-0.17,0.,
1.,0.,0.,0.7,0.17,0.
               };
            };
            int ncell_sets = 2;
            cell_set => {<-.set1,<-.set2};
         };
         olink out_fld<NEportLevels={1,2}> => .glyph2;
      };
      macro Jet {
         Tri set1 {
            ncells = 4;
            node_connect_list = {
               0,1,3,0,2,1,0,2,3,1,2,3
            };
         };
         Mesh jet {
            int nnodes = 4;
            int nspace = 3;
            coordinates {
               float values[.nvals][.veclen] = {
                  1.,0.,0.,0.,0.3,0.,0.,0.,-0.2,0.,0.,0.2
               };
            };
            int ncell_sets = 1;
            cell_set => {<-.set1};
         };
         olink out_fld<NEportLevels={1,2}> => .jet;
      };
      DVM.DVswitch DVswitch {
         in => {
            <-.Sphere.out_fld,<-.Diamond3D.out_fld,<-.Arrow1.out_fld,
            <-.Arrow2.out_fld,<-.Arrow3.out_fld,<-.Arrow4.out_fld,<-.Jet.out_fld
         };
         index => <-.glyph_type;
         out<NEportLevels={1,3}>;
      };
      string string<NEportLevels=1>[] = {
         "Sphere","Diamond","Arrow1","Arrow2","Arrow3","Arrow4","Jet"
      };
      UItoggle outline_on_off {
         y => <-.UIradioBoxLabel.y + <-.UIradioBoxLabel.height + 5;
         parent => <-.UIframe_probe;
         label => "outline";
         set = 0;
      };
      UIradioBoxLabel UIradioBoxLabel {
         parent => <-.UIframe_probe;
         labels => <-.string;
         selectedItem = 0;
         title => " Glyph parameter";
         label_cmd {
            cmd[7] = {
               {
                  set=1,,,,,,,,,,,,,,,,,,,,
               },,,,,
               ,
            };
         };
         y => <-.y;
      };
      int y<NEportLevels=1> => ((<-.particle_probes.probe_ui.xform_toggle.y + <-.particle_probes.probe_ui.xform_toggle.height) + 8);
      UIframe UIframe_probe {
         parent<NEportLevels={3,0}> => <-.<-.panel;
         y = 0;
         width = 240;
         height => <-.Arrow4.cone_ui.SubDiv.y + <-.Arrow4.cone_ui.SubDiv.height + 10;
      };
      macro Sphere {
         int subdiv<export=4> = 6;
         macro sphere_ui {
            ilink isubdiv => subdiv;
            UIslider SubDiv {
               y => <-.<-.<-.outline_on_off.y + <-.<-.<-.outline_on_off.height + 10;
               width => .parent.width - 40;
               parent<NEportLevels={4,0}> => <-.<-.<-.UIframe_probe;
               min = 5.;
               max = 50.;
               value => isubdiv;
               mode = "integer";
               title => "Sphere Subdivision";
               active => (<-.<-.<-.UIradioBoxLabel.selectedItem == 0);
            };
         };
         Field_Spher_Unif sphere {
            nspace = 3;
            ndim = 3;
            dims => {2,subdiv,subdiv};
            points = {0.,0.,0.,0.5,
3.14159,6.28318};
         };
         DVbounds bounds {
            in => <-.sphere;
            hull = 0;
            edges = 0;
            faces = 1;
            imin = 0;
            imax = 1;
            jmin = 0;
            jmax = 0;
            kmin = 0;
            kmax = 0;
            data = 0;
            component = 0;
            method+notify_val+notify_inst upd_bounds = "DVbounds_update";
         };
         link out_fld<NEportLevels={1,2}> => bounds.out;
      };
      macro Arrow1 {
         Line set1 {
            ncells = 3;
            node_connect_list = {0,1,1,2,1,3};
         };
         Mesh glyph1 {
            int nnodes = 4;
            int nspace = 3;
            coordinates {
               float values[nvals][veclen] = {
                  0.,0.,0.,1.,0.,0.,0.7,0.15,0.,0.7,-0.15,0.
               };
            };
            int ncell_sets = 1;
            cell_set => {set1};
         };
         olink out_fld => glyph1;
      };
      macro Arrow3 {
         Line set1 {
            ncells = 4;
            node_connect_list = {0,1,1,2,1,3,1,4};
         };
         Mesh arrow3 {
            int nnodes = 5;
            int nspace = 3;
            coordinates {
               float values[nvals][veclen] = {
                  0.,0.,0.,1.,0.,0.,0.7,0.15,0.,0.7,-0.15,-0.15,0.7,-0.15,
0.15
               };
            };
            int ncell_sets = 1;
            cell_set => {set1};
         };
         olink out_fld => arrow3;
      };
      macro Arrow4{
         float radius<export=2> = 0.15;
         int subdiv<export=2> = 4;
         float cone_height<export=2> = 0.3;
         float height<export=2> = 1.;
         macro cone_ui {
            ilink isubdiv => subdiv;
            UIslider SubDiv {
               y => <-.<-.<-.Sphere.sphere_ui.SubDiv.y + <-.<-.<-.Sphere.sphere_ui.SubDiv.height;
               parent<NEportLevels={4,0}> => <-.<-.<-.UIframe_probe;
               min = 3.;
               max = 64.;
               value => isubdiv;
               mode = "integer";
               title => "Base Subdivision";
               active => (<-.<-.<-.UIradioBoxLabel.selectedItem == 5);
            };
         };
         macro cone {
            float ang[(subdiv + 1)] => init_array((subdiv + 1),0,(2 * 3.141592653));
            float x[(subdiv + 1)][1] => init_array((subdiv + 1),(height - cone_height),(height - cone_height));
            float y[(subdiv + 1)][1] => (radius * cos(ang));
            float z[(subdiv + 1)][1] => (radius * sin(ang));
            float xyz_circle[(subdiv + 1)][3] => combine_array(x,y,z);
            float xyz_tip[3] => {height,0,0};
            int conn0[(subdiv + 1)][1] => init_array((subdiv + 1),0,0);
            int conn1[(subdiv + 1)][1] => init_array((subdiv + 1),1,(subdiv + 1));
            int c21[subdiv][1] => conn1[1:subdiv][];
            int c22[1][1] = {1};
            int conn2[(subdiv + 1)][1] => concat_array(c21,c22);
            int nxyz<NEportLevels={0,2}> => (subdiv + 2);
            int ntri<NEportLevels={0,2}> => (subdiv + 1);
            float xyz<NEportLevels={0,2}>[nxyz][3] => concat_array(xyz_tip,xyz_circle);
            int connect<NEportLevels={0,2}>[(3 * (subdiv + 1))] => combine_array(conn0,conn1,conn2);
         };
         macro line {
            int nlines<NEportLevels={0,2}> = 2;
            int nxyz<NEportLevels={0,2}> = 2;
            float xyz[2][3] => {{0,0,0},
               {height,0,0}};
            int connect<NEportLevels={0,2}>[2] => {<-.cone.nxyz,
               (<-.cone.nxyz + 1)};
         };
         Line line_set {
            ncells = 1;
            node_connect_list => <-.line.connect;
         };
         Tri tri_set {
            ncells => <-.cone.ntri;
            node_connect_list => <-.cone.connect;
         };
         Mesh arrow4 {
            int nnodes => (<-.line.nxyz + <-.cone.nxyz);
            int nspace = 3;
            coordinates {
               values => concat_array(cone.xyz,line.xyz);
            };
            int ncell_sets = 2;
            cell_set => {line_set,tri_set};
         };
         olink out_fld => arrow4;
      };
      int glyph_type<NEportLevels=1,export=3> => .UIradioBoxLabel.selectedItem;
   };
   link in_field<NEportLevels={2,1}>;
   UImod_panel panel {
      message = "Select plane control panel.";
      height = 1800;
      title => name_of(<-.<-);
      option {
         set = 1;
      };
      parent<NEportLevels={3,0}>;
   };
   DataObjectLite DataObjectLite {
      in => <-.particle_probes.DVswitch.out;
      Obj {
         visible => <-.<-.particle_probes.probe_ui.probe_toggle.set;
         xform_mode = "Normal";
      };
      Modes {
         mode = {0,2,1,0,0};
      };
   };
   link out_probe_obj<NEportLevels={1,2}> => .DataObjectLite.obj;
   link out_stream_obj<NEportLevels={1,2}> => .advector.out_obj1;
   link out_glyph_obj<NEportLevels={1,2}> => advector.out_obj;
   link out_stream_fld<NEportLevels={1,1},export=2> => advector.out_fld1;
};


macro Streamline {
   macro streamlines {
      ilink in_field<export_all=1> => <-.in_field;
      ilink in_probe<export_all=1> => <-.streamlines_probes.DVswitch.out;
      DV_Param_stream StreamParam<export_all=3> {
         component = 0;
         order = 2;
         forw_back = 1;
         nseg = 2;
         max_seg = 256;
         min_vel = 1e-05;
         color = 1;
         ribbons = 0;
         rib_width = 1.;
         rib_angle = 0.;
      };
      DVstream DVstream {
         in => <-.in_field;
         probe => <-.in_probe;
         &order => param.order;
         &forw_back => param.forw_back;
         &nseg => param.nseg;
         &min_vel => param.min_vel;
         &max_seg => param.max_seg;
         &stream_comp => param.component;
         &ribbons => param.ribbons;
         &rib_width => param.rib_width;
         &rib_angle => param.rib_angle;
         out {
            nnode_data = 1;
            node_data = {
               {
                  max_vec= ,,,,,,min_vec= ,max= ,min= ,
               }};
         };
         DV_Param_stream &param<NEportLevels={2,0}> => <-.StreamParam;
      };
      DVmagnitude DVmagnitude {
         in => <-.DVstream.out;
      };
      GMOD.instancer instancer {
         Value => <-.<-.UIpanel.visible;
         Group => <-.StreamUI;
         active = 2;
      };
      macro StreamUI {
         ilink in_fld => <-.in_field;
         DV_Param_stream &param<NEportLevels={2,0}> => <-.StreamParam;
         DVnode_data_labels DVnode_data_labels {
            in => <-.in_fld;
            int+nres ncomp => in.nnode_data;
         };
         UIradioBoxLabel UIradioBoxLabel {
            parent => <-.UIframe_stream;
            labels<NEportLevels={2,0}> => <-.DVnode_data_labels.labels;
            &selectedItem => param.component;
            title => "velocity vector";
            visible => <-.UIframe_stream.visible;
            width => <-.UIframe_stream.width;
         };
         UIradioBoxLabel UIradioBoxLabel_dir {
            parent => <-.UIframe_stream;
            labels<NEportLevels={2,0}> => {,};
            &selectedItem => param.forw_back;
            title => "Direction";
            visible => <-.UIframe_stream.visible;
            y => <-.UIradioBoxLabel.y + <-.UIradioBoxLabel.height + 4;
            width => <-.UIframe_stream.width;
            label_cmd {
               cmd[2] = {
                  {
                     label="backward",,,,,,,,,,,
                  },
                  {
                     set=1,,,,,,,,,label="forward",,,,,,,,,,,
                  }};
            };
         };
         UIslider nseg_slider {
            y => <-.UIradioBoxLabel_dir.y + <-.UIradioBoxLabel_dir.height + 4;
            width =>  <-.UIframe_stream.width - 10;
            parent => <-.UIframe_stream;
            max = 16.;
            value<NEportLevels={2,0}> => param.nseg;
            mode = "integer";
            title => "nsegments";
         };
         UIslider max_seg_slider {
            y => <-.nseg_slider.y + <-.nseg_slider.height + 4;
            width  => <-.UIframe_stream.width - 10;
            parent => <-.UIframe_stream;
            min = 1.;
            max = 10000.;
            value<NEportLevels={2,0}> => param.max_seg;
            mode = "integer";
            title => "max segments";
         };
         UIslider order_slider {
            y => <-.max_seg_slider.y + <-.max_seg_slider.height + 4;
            width =>  <-.UIframe_stream.width - 10;
            parent => <-.UIframe_stream;
            min = 1.;
            max = 4.;
            value<NEportLevels={2,0}> => param.order;
            mode = "integer";
            title => "order";
         };
         UIslider vel_slider {
            y => <-.order_slider.y + <-.order_slider.height + 4;
            parent => <-.UIframe_stream;
            value<NEportLevels={2,0}> => param.min_vel;
            title => "min_velocity";
            width => (<-.UIframe_stream.width - 10) * 11 / 12;
         };
         VUIslider_typein vel_slider_typein {
            slider => vel_slider;
            width = 20;
         };
         UItoggle color_toggle {
            y => <-.vel_slider.y + <-.vel_slider.height + 4;
            width  => <-.UIpanel.width;
            parent => <-.UIframe_stream;
            label => "Color";
            set<NEportLevels={2,0}> => param.color;
         };
         UItoggle ribbon_toggle {
            y => <-.color_toggle.y + <-.color_toggle.height + 4;
            width  => <-.UIpanel.width;
            parent => <-.UIframe_stream;
            label => "Ribbons";
            set<NEportLevels={2,0}> => param.ribbons;
         };
         UIslider ribbon_width_slider {
            y => <-.ribbon_toggle.y + <-.ribbon_toggle.height + 4;
            parent => <-.UIframe_stream;
            value<NEportLevels={2,0}> => param.rib_width;
            title => "ribbon width";
            width => (<-.UIframe_stream.width - 10) * 11 / 12;
         };
         VUIslider_typein ribbon_width_slider_typein {
            slider => ribbon_width_slider;
            width = 20;
         };
         UIslider ribbon_angle_slider {
            y => <-.ribbon_width_slider.y + <-.ribbon_width_slider.height + 4;
            parent => <-.UIframe_stream;
            min = 0.;
            max = 360.;
            value<NEportLevels={2,0}> => param.rib_angle;
            title => "ribbon angle";
            width => (<-.UIframe_stream.width - 10) * 11 / 12;
         };
         VUIslider_typein ribbon_angle_slider_typein {
            slider => ribbon_angle_slider;
            width = 20;
         };
         UIframe UIframe_stream {
            parent<NEportLevels={4,0}> => <-.<-.<-.UIpanel;
            y => <-.<-.<-.streamlines_probes.probe_ui.UIframe_probe.y + <-.<-.<-.streamlines_probes.probe_ui.UIframe_probe.height + 10;
            width = 240;
            height => <-.ribbon_angle_slider.y + <-.ribbon_angle_slider.height + 20;
         };
      };
      DVswitch DVswitch {
         in => {<-.DVstream.out,
            <-.DVmagnitude.out};
         index => <-.StreamParam.color;
      };
      DataObjectNoTexture obj {
         in => <-.DVswitch.out;
         Obj {
            alt_xform+nres => <-.<-.in_probe.xform;
            xform_mode = "Alternate";
         };
      };
      olink out_fld<export_all=2,NEportLevels={1,2}> => .DVswitch.out;
      olink out_obj<NEportLevels={1,2}> => .obj.obj;
   };
   macro streamlines_probes {
      macro FLine3D {
         group &in<NEportLevels={2,0}> {
            group coordinates;
         } => <-.Field_in;
         float+nres xlate[3] => {0.,
            ((in.coordinates.min_vec[1] + in.coordinates.max_vec[1]) / 2),
            ((in.coordinates.min_vec[2] + in.coordinates.max_vec[2]) / 2)};
         Mesh_Unif line3<NEcolor1=255> {
            nspace = 1;
            ndim = 1;
            dims => {<-.<-.dim1};
            points+nres => {
               in.coordinates.min_vec[0],in.coordinates.max_vec[0]};
            xform {
               xlate+nres => cache(<-.<-.xlate);
               mat = {
                  -0.00485718,0.000537954,-0.999988,0.,0.999672,0.0251314,-0.00484213,
0.,0.0251285,-0.999684,-0.000659846,0.,0.,0.,0.,1.
               };
            };
         };
         olink out_fld<NEportLevels={1,2}> => .line3;
      };
      macro FPoint3D {
         group &in<NEportLevels={2,0}> {
            group coordinates;
         } => <-.Field_in;
         Mesh point3 {
            nnodes = 1;
            nspace = 3;
            coordinates {
               values+nres => {
                  {
                     ((in.coordinates.min_vec[0] + in.coordinates.max_vec[0]) / 2.),
                     ((in.coordinates.min_vec[1] + in.coordinates.max_vec[1]) / 2.),
                     ((in.coordinates.min_vec[2] + in.coordinates.max_vec[2]) / 2.)}};
            };
            ncell_sets = 1;
            Point cell_set {
               ncells = 1;
               node_connect_list = {0};
            };
         };
         olink out_fld<NEportLevels={1,2}> => .point3;
      };
      macro FPlane<module_stack_menu=1> {
         group &in<NEportLevels={2,0}> {
            group coordinates;
         } => <-.Field_in;
         float+nres xlate[3] => {0.,0.,
            ((in.coordinates.min_vec[2] + in.coordinates.max_vec[2]) / 2)};
         Mesh_Unif plane<NEcolor1=65280> {
            nspace = 2;
            ndim = 2;
            dims => {<-.<-.dim1,
               <-.<-.dim2};
            points+nres => {
               in.coordinates.min_vec[0],in.coordinates.min_vec[1],
               in.coordinates.max_vec[0],in.coordinates.max_vec[1]};
            xform {
               xlate+nres => cache(<-.<-.xlate);
               mat = {
                  0.577966,0.689526,-0.436473,0.,-0.590228,0.72256,0.359913,0.,
0.563548,0.0496012,0.824593,0.,0.,0.,0.,1.
               };
            };
         };
         olink out_fld<NEportLevels={1,2}> => .plane;
      };
      macro probe_ui {
         ilink idim1<NEportLevels={2,1}> => <-.dim1;
         ilink idim2<NEportLevels={2,1}> => <-.dim2;
         ilink iobj<NEportLevels={2,1}> => <-.DVswitch.out;
         UIslider dim1_slider {
            y => <-.UIradioBoxLabel.y + <-.UIradioBoxLabel.height + 4;
            width  => <-.UIframe_probe.width - 10;
            parent => <-.UIframe_probe;
            min = 2.;
            max = 100.;
            value => <-.idim1;
            mode = "integer";
            title => "x-dimension";
            active => switch((<-.UIradioBoxLabel.selectedItem + 1),0,1,1);
         };
         UIslider dim2_slider {
            y => <-.dim1_slider.y + <-.dim1_slider.height + 4;
            width  => <-.UIframe_probe.width - 10;
            parent => <-.UIframe_probe;
            min = 2.;
            max = 100.;
            value => <-.idim2;
            mode = "integer";
            title => "y-dimension";
            active => switch((<-.UIradioBoxLabel.selectedItem + 1),0,0,1);
         };
         UItoggle xform_toggle {
            y => <-.dim2_slider.y + <-.dim2_slider.height + 8;
            width = 200;
            parent => <-.UIframe_probe;
            label => "Transformation Editor";
         };
         XformEditor probe_edit {
            obj_in => <-.iobj;
            vis => <-.xform_toggle.set;
            GDxform_editor {
               x_rot = 23.58;
               y_rot = 25.87908554;
               z_rot = -50.02999878;
               abs_z_rot = -50.02999878;
               abs_y_rot = 25.87908554;
               abs_x_rot = 23.57999992;
            };
            //XformEditorUI {
            //   trans_shell {
            //      ok = 1;
            //   };
            //};
         };
         UIradioBoxLabel UIradioBoxLabel {
            labels => <-.string;
            selectedItem => <-.<-.start_point;
            label_cmd {
               cmd[3] = {
                  {
                     set=1,,,,,,,,,,,,,,,,,,,,
                  },
                  ,};
            };
            parent => <-.UIframe_probe;
            title => "start point";
            y => <-.probe_toggle.y + <-.probe_toggle.height + 10;
         };
         string string<NEportLevels={1,1}>[] = {"Point","Line", "Plane"};
         UIframe UIframe_probe {
            parent<NEportLevels={4,0}> => <-.<-.<-.UIpanel;
            y = 0;
            width = 240;
            height => <-.xform_toggle.y + <-.xform_toggle.height + 10;
         };
         UItoggle probe_toggle {
            parent => <-.UIframe_probe;
            label => "Probe on/off";
            set => <-.<-.Probe_on_off;
            y = 2;
            width = 120;
         };
      };
      int dim1<export=3> = 8;
      int dim2<export=3> = 8;
      DVM.DVswitch DVswitch {
         in => {
            <-.FPoint3D.out_fld,<-.FLine3D.out_fld,<-.FPlane.out_fld};
         index => <-.probe_ui.UIradioBoxLabel.selectedItem;
         out<NEportLevels={1,3}>;
      };
      link Field_in<NEportLevels={2,1}> => <-.in_field;
      GMOD.instancer instancer {
         Value => <-.<-.UIpanel.visible;
         Group => probe_ui;
      };
      int start_point<NEportLevels={1,0},export=3> = 0;
      int Probe_on_off<NEportLevels={1,0},export=3> = 1;
   };
   link in_field<NEportLevels={2,1}>;
   UImod_panel UIpanel {
      parent<NEportLevels={3,0}>;
      message = "Select streamline control panel.";
      title => name_of(<-.<-);
      option {
         set = 1;
      };
   };
   DataObjectLite Probe_obj {
      in => <-.streamlines_probes.DVswitch.out;
      Obj {
         visible => <-.<-.streamlines_probes.probe_ui.probe_toggle.set;
      };
      Modes {
         mode = {0,2,1,0,0};
      };
   };
   link out_stream_obj<NEportLevels={1,2}> => .streamlines.out_obj;
   link out_probe_obj<NEportLevels={1,2}> => .Probe_obj.obj;
   link out_stream_fld<NEportLevels={1,1},export=2> => streamlines.out_fld;
};


macro Text_Glyph {
   int Display_Data<NEportLevels=1,export=2> = 0;

   group extract_data_array {
      Node_Data &in<NEportLevels={2,0}> => switch(<-.switch,<-.in_field,<-.DVcell_centres.out);
      int comp<NEportLevels={2,0}> = 0;
      prim data<NEportLevels={0,2}>[] => in.node_data[.comp].values;
      string &label<NEportLevels={0,2}> => in.node_data[.comp].labels;
      DVnode_data_labels DVnode_data_labels {
         in => <-.in;
         int+nres ncomp => <-.in.nnode_data;
      };
      UIradioBoxLabel UIradioBoxLabel_mode2 {
         parent<NEportLevels={3,1}> => <-.<-.UImod_panel;
         labels<NEportLevels={2,0}> => <-.DVnode_data_labels.labels;
         &selectedItem => <-.comp;
         title => "Select Data Component";
         visible => <-.<-.UImod_panel.visible;
         y => <-.<-.TextGlyphUI.UIradioBoxLabel.height + 10;
         UIlabel {
            alignment = "left";
            visible => array_size(<-.labels) > 0;
         };
      };
   };

   macro text_glyph {
      Mesh &in_mesh<NEportLevels={2,0},export_all=1> => switch(<-.switch,<-.in_field,<-.DVcell_centres.out);
      string in_text<NEportLevels={2,0},export_all=1>[] => str_format("%3.2f",<-.extract_data_array.data);
      GMOD.instancer instancer {
         Value => <-.<-.UImod_panel.visible;
         Group => <-.TextUI;
         active = 2;
      };
      macro TextUI {
         int active_array[];
         ilink UImod_panel => <-.UIframe;
         UIlabel UIlabel {
            y = 0;
            width = 45;
            parent => <-.UImod_panel;
            label => "Font";
            alignment = "left";
         };
         UItext Font {
            x = <-.UIlabel.width;
            y = 0;
            width = 200;
            active => <-.active_array[<-.StrokeText.set];
            parent => <-.UImod_panel;
            text<NEportLevels={0,3}> = "-adobe-times-bold-r-*-*-20-*-*-*-*-*-*-*";
         };
         UIframe UIframe {
            y => <-.Font.y + <-.Font.height + 4;
            width  => <-.UImod_panel.width;
            height => <-.OffsetZValue.y + <-.OffsetZValue.height + 2;
            parent => <-.UImod_panel;
         };
         UIoption UIoption {
            label => "Left";
            set = 1;
         };
         UIoption UIoption#1 {
            label => "Center";
         };
         UIoption UIoption#2 {
            label => "Right";
         };
         UIoptionMenu AlignHorizMenu {
            parent => <-.UIframe;
            label => "Align Horizontal";
            cmdList => {<-.UIoption,<-.UIoption#1,<-.UIoption#2};
            selectedItem<NEportLevels={0,3}> = 0;
            alignment = "left";
            x = 2;
            y = 2;
         };
         UIoption UIoption#3 {
            label => "Base";
            set = 1;
         };
         UIoption UIoption#4 {
            label => "Bottom";
         };
         UIoption UIoption#5 {
            label => "Center";
         };
         UIoption UIoption#6 {
            label => "Top";
         };
         UIoptionMenu AlignVertMenu {
            y = 30;
            parent => <-.UIframe;
            label => "Align Vertical";
            cmdList => {<-.UIoption#3,
               <-.UIoption#4,<-.UIoption#5,<-.UIoption#6};
            selectedItem<NEportLevels={0,3}> = 0;
            alignment = "left";
            x = 2;
         };
         UItoggle DropShadow {
            x = 2;
            y = 60;
            width = 150;
            active => <-.active_array[<-.StrokeText.set];
            parent => <-.UIframe;
            label => "Drop Shadow";
            alignment = "left";
            set<NEportLevels={0,3}>;
         };
         UItoggle Bounds {
            x = 2;
            y = 90;
            active => <-.active_array[<-.StrokeText.set];
            parent => <-.UIframe;
            label => "Bounds";
            set<NEportLevels={0,3}>;
         };
         UItoggle Underline {
            x = 2;
            y = 120;
            active => <-.active_array[<-.StrokeText.set];
            parent => <-.UIframe;
            label => "Underline";
            set<NEportLevels={0,3}>;
         };
         UItoggle Background {
            x = 2;
            y = 150;
            active => <-.active_array[<-.StrokeText.set];
            parent => <-.UIframe;
            label => "Background";
            set<NEportLevels={0,3}>;
         };
         UItoggle Leadline {
            x = 2;
            y = 180;
            active => <-.active_array[<-.StrokeText.set];
            parent => <-.UIframe;
            label => "Leadline";
            set<NEportLevels={0,3}>;
         };
         UItoggle Radial {
            x = 2;
            y => <-.Leadline.y + <-.Leadline.height + 5;
            width => <-.UIframe.clientWidth - 8;
            active => <-.active_array[<-.StrokeText.set];
            parent => <-.UIframe;
            label => "Radial";
            set<NEportLevels={0,3}>;
         };
         UItoggle Offset {
            x = 2;
            y => <-.Radial.y + <-.Radial.height + 5;
            width => <-.UIframe.clientWidth - 8;
            active => <-.active_array[<-.StrokeText.set];
            parent => <-.UIframe;
            label => "Offset";
            set<NEportLevels={0,3}>;
         };
         UIfieldTypein OffsetXValue {
            UIparent => <-.UIframe;
            flabel => "X Offset";
            label {
               alignment = "center";
            };
            field {
               active => <-.<-.active_array[<-.<-.StrokeText.set];
               value => 0.05;
            };
            x = 4;
            y => <-.Offset.y + <-.Offset.height + 5;
            width  => <-.UIframe.clientWidth - 8;
            height => field.height + 6;
         };
         UIfieldTypein OffsetYValue {
            UIparent => <-.UIframe;
            flabel => "Y Offset";
            label {
               alignment = "center";
            };
            field {
               active => <-.<-.active_array[<-.<-.StrokeText.set];
               value => 0.05;
            };
            x = 4;
            y => <-.OffsetXValue.y + <-.OffsetXValue.height + 5;
            width  => <-.UIframe.clientWidth - 8;
            height => field.height + 6;
         };
         UIfieldTypein OffsetZValue {
            UIparent => <-.UIframe;
            flabel => "Z Offset";
            label {
               alignment = "center";
            };
            field {
               active => <-.<-.active_array[<-.<-.StrokeText.set];
               value => 0.;
            };
            x = 4;
            y => <-.OffsetYValue.y + <-.OffsetYValue.height + 5;
            width => <-.UIframe.clientWidth - 8;
            height => field.height + 6;
         };
         UItoggle StrokeText {
            y => <-.UIframe.y + <-.UIframe.height + 5;
            width => <-.UImod_panel.clientWidth - 50;
            parent => <-.UImod_panel;
            label => "StrokeText";
            set => <-.<-.TextValues.stroke;
         };
         UIframe StrokeFrame {
            y => <-.StrokeText.y + <-.StrokeText.height + 10;
            width => <-.UImod_panel.clientWidth;
            height => <-.StrokeExpansion.y + <-.StrokeExpansion.height + 6;
            visible => <-.StrokeText.set;
            parent => <-.UImod_panel;
         };
         UIoptionMenu StrokeFontType {
            x = 4;
            y = 0;
            width => <-.StrokeFrame.clientWidth - 8;
            parent => <-.StrokeFrame;
            label => "Font Type";
            cmdList => {
               <-.Font1,<-.Font2,<-.Font3,<-.Font4,<-.Font5,<-.Font6,
               <-.Font7,<-.Font8,<-.Font9,<-.Font10
            };
            selectedItem<NEportLevels={0,3}> = 0;
            alignment = "left";
         };
         UIoption Font1 {
            label => "Roman Simplex";
            set = 1;
         };
         UIoption Font2 {
            label => "Roman Duplex";
         };
         UIoption Font3 {
            label => "Roman Triplex";
         };
         UIoption Font4 {
            label => "Roman Complex";
         };
         UIoption Font5 {
            label => "Script Simplex";
         };
         UIoption Font6 {
            label => "Script Complex";
         };
         UIoption Font7 {
            label => "Italics Triplex";
         };
         UIoption Font8 {
            label => "Italics Duplex";
         };
         UIoption Font9 {
            label => "Greek Simplex";
         };
         UIoption Font10 {
            label => "Greek Complex";
         };
         UIoptionMenu StrokePlane {
            x = 4;
            y => <-.StrokeFontType.y + <-.StrokeFontType.height + 5;
            width => <-.StrokeFrame.clientWidth - 8;
            parent => <-.StrokeFrame;
            label => "Plane";
            cmdList => {<-.XYplane,<-.XZplane,<-.YZplane};
            selectedItem<NEportLevels={0,3}> = 0;
            alignment = "left";
         };
         UIoption XYplane {
            label => "XY";
            set = 1;
         };
         UIoption XZplane {
            label => "XZ";
         };
         UIoption YZplane {
            label => "YZ";
         };
         UIoptionMenu StrokeOrient {
            x = 4;
            y => <-.StrokePlane.y + <-.StrokePlane.height + 5;
            width => <-.StrokeFrame.clientWidth - 8;
            parent => <-.StrokeFrame;
            label => "Orientation";
            cmdList => {
               <-.LRorient,<-.UPorient,<-.RLorient,<-.DOWNorient,
               <-.ARBorient
            };
            selectedItem<NEportLevels={0,3}> = 0;
            alignment = "left";
         };
         UIoption LRorient {
            label => "Left-to-Right";
            set = 1;
         };
         UIoption UPorient {
            label => "Up";
         };
         UIoption RLorient {
            label => "Right-to-Left";
         };
         UIoption DOWNorient {
            label => "Down";
         };
         UIoption ARBorient {
            label => "Arbitrary";
         };
         UIslider StrokeAngle {
            x = 4;
            y => <-.StrokeOrient.y + <-.StrokeOrient.height + 5;
            width => <-.UImod_panel.clientWidth - 50;
            active => switch(((<-.StrokeOrient.selectedItem == 4) + 1),0,1);
            parent => <-.StrokeFrame;
            min = -180.;
            max = 180.;
            value = 0.;
            title => "Angle";
         };
         UIoptionMenu StrokePath {
            x = 4;
            y => <-.StrokeAngle.y + <-.StrokeAngle.height + 5;
            width => <-.StrokeFrame.clientWidth - 8;
            parent => <-.StrokeFrame;
            label => "Path";
            cmdList => {<-.LRpath,
               <-.UPpath,<-.RLpath,<-.DOWNpath};
            selectedItem<NEportLevels={0,3}> = 0;
            alignment = "left";
         };
         UIoption LRpath {
            label => "Left-to-Right";
            set = 1;
         };
         UIoption UPpath {
            label => "Up";
         };
         UIoption RLpath {
            label => "Right-to-Left";
         };
         UIoption DOWNpath {
            label => "Down";
         };
         UIoptionMenu StrokeSpaceMode {
            x = 4;
            y => <-.StrokePath.y + <-.StrokePath.height + 5;
            width => <-.StrokeFrame.clientWidth - 8;
            parent => <-.StrokeFrame;
            label => "Spacing Mode";
            cmdList => {<-.FixedSpace, <-.PropSpace};
            selectedItem<NEportLevels={0,3}> = 1;
            alignment = "left";
         };
         UIoption FixedSpace {
            label => "Fixed";
         };
         UIoption PropSpace {
            label => "Proportional";
            set = 1;
         };
         UIslider StrokeSpacing {
            x = 4;
            y => <-.StrokeSpaceMode.y + <-.StrokeSpaceMode.height + 5;
            width => <-.UImod_panel.clientWidth - 50;
            parent => <-.StrokeFrame;
            min = 0.;
            max = 3.;
            value = 0.;
            title => "Spacing";
         };
         UIslider StrokeHeight {
            x = 4;
            y => <-.StrokeSpacing.y + <-.StrokeSpacing.height + 5;
            width => <-.UImod_panel.clientWidth - 50;
            parent => <-.StrokeFrame;
            min = 0.01;
            max = 10.;
            value = 1.;
            title => "Height";
         };
         UIslider StrokeExpansion {
            x = 4;
            y => <-.StrokeHeight.y + <-.StrokeHeight.height + 5;
            width => <-.UImod_panel.clientWidth - 50;
            parent => <-.StrokeFrame;
            min = 0.25;
            max = 3.;
            value = 1.;
            title => "Expansion";
         };
      };
      group TextValues<export_all=3> {
         int align_horiz<NEportLevels={2,0}> => <-.TextUI.AlignHorizMenu.selectedItem;
         int align_vert<NEportLevels={2,0}> => <-.TextUI.AlignVertMenu.selectedItem;
         int drop_shadow<NEportLevels={2,0}> => <-.TextUI.DropShadow.set;
         int background<NEportLevels={2,0}> => <-.TextUI.Background.set;
         int bounds<NEportLevels={2,0}> => <-.TextUI.Bounds.set;
         int underline<NEportLevels={2,0}> => <-.TextUI.Underline.set;
         int lead_line<NEportLevels={2,0}> => <-.TextUI.Leadline.set;
         int radial<NEportLevels={2,0}> => <-.TextUI.Radial.set;
         int do_offset<NEportLevels={2,0}> => <-.TextUI.Offset.set;
         float offset<NEportLevels={2,0}>[3] => {
            <-.TextUI.OffsetXValue.field.value,<-.TextUI.OffsetYValue.field.value,
            <-.TextUI.OffsetZValue.field.value};
         int xform_mode;
         int color;
         string text_values[] => <-.in_text;
         int stroke = 0;
         group StrokeTextAttribs {
            int font_type => <-.<-.TextUI.StrokeFontType.selectedItem;
            int style;
            int plane => <-.<-.TextUI.StrokePlane.selectedItem;
            int orient => <-.<-.TextUI.StrokeOrient.selectedItem;
            int path => <-.<-.TextUI.StrokePath.selectedItem;
            int space_mode => <-.<-.TextUI.StrokeSpaceMode.selectedItem;
            float spacing => <-.<-.TextUI.StrokeSpacing.value;
            float angle => <-.<-.TextUI.StrokeAngle.value;
            float height => <-.<-.TextUI.StrokeHeight.value;
            float expansion => <-.<-.TextUI.StrokeExpansion.value;
            float width;
         };
      };
      Grid+Xform &TextField => merge(.TextValues,.in_mesh,,,,,,,,);
      DataObjectNoTexture obj {
         in => <-.TextField;
         Props {
            jitter = 1;
            font => <-.<-.TextUI.Font.text;
            inherit = 0;
         };
      };
      olink out_obj<NEportLevels={1,3}> => .obj.obj;
      UIpanel UIframe {
         parent<NEportLevels={3,0}> => <-.<-.UImod_panel;
         y => <-.<-.extract_data_array.UIradioBoxLabel_mode2.y + <-.<-.extract_data_array.UIradioBoxLabel_mode2.height + 15;
         width = 250;
         height = 1200;
      };
   };
   link in_field<NEportLevels={2,1}>;
   DVcell_centres DVcell_centres {
      in => <-.in_field;
   };
   int switch<NEportLevels=1> => (TextGlyphUI.UIradioBoxLabel.selectedItem + 1);
   UImod_panel UImod_panel {
      option {
         set = 1;
      };
      parent<NEportLevels={3,0}>;
      title => name_of(<-.<-);
   };
   macro TextGlyphUI {
      string string<NEportLevels={1,1}>[] = {"Node","Cell"};
      UIradioBoxLabel UIradioBoxLabel {
         parent<NEportLevels={3,1}> => <-.<-.UImod_panel;
         labels => <-.string;
         selectedItem => <-.<-.Display_Data;
         title => "Display Data";
         label_cmd {
            cmd[2] = {
               {
                  set=1,,,,,,,,,,,,,,,,,,,,
               },};
         };
         width = 100;
         UIlabel.alignment = "left";
      };
      GMOD.instancer instancer {
         Value => <-.<-.UImod_panel.visible;
         Group => <-.UIradioBoxLabel;
         active = 2;
      };
   };
};


macro Vector {
   macro glyph {
      ilink in_field<export_all=1,NEportLevels={2,1}> => <-.in_field;
      ilink in_glyph<export_all=1> => switch((.GlyphUI.UIradioBoxLabel_type.selectedItem + 1),<-.geometries.Arrow1_fld.out_fld,<-.geometries.Arrow2_fld.out_fld,<-.geometries.Arrow3_fld.out_fld,<-.geometries.Arrow4_fld.out_fld,<-.geometries.Jet_fld.out_fld);
      DV_Param_glyph GlyphParam<export_all=3> {
         glyph_comp = 0;
         map_comp = 0;
         scale_comp = 0;
         vector = 1;
         scale = 0.1;
         scale_x = 1;
         scale_y = 1;
         scale_z = 1;
         normalize = 0;
         int color<NEportLevels={2,0}> = 1;
      };
      DVglyph DVglyph {
         in => <-.in_field;
         glyph => <-.in_glyph;
         vector => param.vector;
         glyph_comp => param.glyph_comp;
         map_comp => param.map_comp;
         scale_comp => param.scale_comp;
         scale => param.scale;
         scale_x => param.scale_x;
         scale_y => param.scale_y;
         scale_z => param.scale_z;
         normalize => param.normalize;
         DV_Param_glyph &param<NEportLevels={2,0}> => <-.GlyphParam;
      };
      GMOD.instancer instancer {
         Group => <-.GlyphUI;
         Value => <-.panel.visible;
      };
      macro GlyphUI {
         ilink in_fld => <-.in_field;
         DV_Param_glyph &param<NEportLevels={2,0}> => <-.GlyphParam;
         DVnode_data_labels DVnode_data_labels {
            in => <-.in_fld;
            int+nres ncomp => in.nnode_data;
         };
         ilink UIpanel<NEportLevels={2,1}> => panel;
         UIradioBoxLabel UIradioBoxLabel_glyph {
            parent => <-.UIpanel;
            labels<NEportLevels={2,0}> => <-.DVnode_data_labels.labels;
            &selectedItem => param.glyph_comp;
            title => "Glyph Component";
            visible => <-.UIpanel.visible;
            y => <-.<-.<-.geometries.Arrow4_fld.cone_ui.SubDiv.y + <-.<-.<-.geometries.Arrow4_fld.cone_ui.SubDiv.height;
            width => <-.UIpanel.width;
         };
         UIradioBoxLabel UIradioBoxLabel_map {
            parent => <-.UIpanel;
            labels<NEportLevels={2,0}> => <-.DVnode_data_labels.labels;
            &selectedItem => param.map_comp;
            title => "Color Component";
            visible => <-.UIpanel.visible;
            y => <-.UIradioBoxLabel_glyph.y + <-.UIradioBoxLabel_glyph.height;
            width => <-.UIpanel.width;
         };
         UIradioBoxLabel UIradioBoxLabel_scale {
            parent => <-.UIpanel;
            labels<NEportLevels={2,0}> => <-.DVnode_data_labels.labels;
            &selectedItem => param.scale_comp;
            title => "Scale Component";
            visible => <-.UIpanel.visible;
            y => <-.UIradioBoxLabel_map.y + <-.UIradioBoxLabel_map.height + 4;
            width => <-.UIpanel.width;
         };
         UItoggle norm_toggle {
            y => <-.UIradioBoxLabel_scale.y + <-.UIradioBoxLabel_scale.height + 4;
            width => <-.UIpanel.width;
            parent => <-.UIpanel;
            label => "Normalize";
            set<NEportLevels={2,0}> => param.normalize;
         };
         UIslider scale_slider {
            y => <-.norm_toggle.y + <-.norm_toggle.height + 4;
            parent => <-.UIpanel;
            min = -10.;
            max = 10.;
            value<NEportLevels={2,0}> => param.scale;
            title => "scale";
            width => <-.UIpanel.width * 11 / 12;
         };
         VUIslider_typein scale_slider_typein {
            slider => scale_slider;
         };
         UIradioBoxLabel UIradioBoxLabel_type {
            parent => <-.UIpanel;
            labels => <-.glyph_type;
            selectedItem = 0;
            title => "Glyph Type";
            y => <-.outline_on_off.y + <-.outline_on_off.height + 10;
            width = 100;
            label_cmd {
               cmd[5] = {
                  {
                     set=1,,,,,,,,,,,,,,,,,,,,
                  },
                  ,,,
               };
            };
         };
         string glyph_type<NEportLevels={1,1}>[] = {
            "Arrow1","Arrow2","Arrow3","Arrow4","Jet"
         };
         UItoggle outline_on_off {
            y = 0;
            parent => <-.UIpanel;
            label => "outline";
            set = 0;
         };
         UItoggle color_toggle {
            parent => <-.UIpanel;
            label => "Color";
            y => <-.scale_slider.y + <-.scale_slider.height + 5;
            set => <-.param.color;
         };
      };
      DataObjectNoTexture obj {
         in => <-.DVswitch.out;
         Modes {
            mode => {
               0,GD_LINES,0,0,0
            };
            outline => (<-.<-.GlyphUI.outline_on_off.set == 0);
         };
         Obj {
            xform_mode = "Parent";
         };
      };
      olink out_fld<export_all=2,NEportLevels={1,2}> => .DVswitch.out;
      olink out_obj<NEportLevels={1,2}> => .obj.obj;
      link panel<NEportLevels={2,1}> => <-.panel;
      int Glyph_Type<NEportLevels=1,export=3> => GlyphUI.UIradioBoxLabel_glyph.selectedItem;
      int outline<NEportLevels=1,export=3> => GlyphUI.outline_on_off.set;
      DVM.DVswitch DVswitch {
         in => {
            <-.DVextract_mesh.out,<-.DVglyph.out};
         index => <-.GlyphParam.color;
      };
      DVextract_mesh DVextract_mesh {
         in => <-.DVglyph.out;
      };
   };
   macro geometries {
      macro Arrow1_fld {
         Mesh glyph1<NEportLevels={0,1}> {
            int nnodes = 4;
            int nspace = 3;
            coordinates {
               float values[.nvals][.veclen] = {
                  0.,0.,0.,1.,0.,0.,0.7,0.15,0.,0.7,-0.15,0.
               };
            };
            int ncell_sets = 1;
            cell_set => {<-.set1};
         };
         Line set1 {
            ncells = 3;
            node_connect_list = {0,1,1,2,1,3};
         };
         link out_fld<NEportLevels={1,2}> => .glyph1;
      };
      macro Arrow2_fld {
         Quad set1 {
            ncells = 1;
            node_connect_list = {0,1,2,3};
         };
         Tri set2 {
            ncells = 1;
            node_connect_list = {4,5,6};
         };
         Mesh glyph2<NEportLevels={0,1}> {
            int nnodes = 7;
            int nspace = 3;
            coordinates {
               float values[.nvals][.veclen] = {
                  0.,-0.1,0.,0.7,-0.1,0.,0.7,0.1,0.,0.,0.1,0.,0.7,-0.17,0.,
1.,0.,0.,0.7,0.17,0.
               };
            };
            int ncell_sets = 2;
            cell_set => {<-.set1,<-.set2};
         };
         link out_fld<NEportLevels={1,2}> => .glyph2;
      };
      macro Jet_fld {
         Tri set1 {
            ncells = 4;
            node_connect_list = {
               0,1,3,0,2,1,0,2,3,1,2,3
            };
         };
         Mesh jet<NEportLevels={0,1}> {
            int nnodes = 4;
            int nspace = 3;
            coordinates {
               float values[.nvals][.veclen] = {
                  1.,0.,0.,0.,0.3,0.,0.,0.,-0.2,0.,0.,0.2
               };
            };
            int ncell_sets = 1;
            cell_set => {<-.set1};
         };
         link out_fld<NEportLevels={1,2}> => .jet;
      };
      macro Arrow3_fld {
         Line set1 {
            ncells = 4;
            node_connect_list = {0,1,1,2,1,
3,1,4};
         };
         Mesh arrow3 {
            int nnodes = 5;
            int nspace = 3;
            coordinates {
               float values[.nvals][.veclen] = {
                  0.,0.,0.,1.,0.,0.,0.7,0.15,0.,0.7,-0.15,-0.15,0.7,-0.15,
0.15
               };
            };
            int ncell_sets = 1;
            cell_set => {<-.set1};
         };
         olink out_fld<NEportLevels={1,2}> => .arrow3;
      };
      macro Arrow4_fld{
         float radius<export=2> = 0.15;
         int subdiv<export=2> = 4;
         float cone_height<export=2> = 0.3;
         float height<export=2> = 1.;
         macro cone_ui {
            ilink isubdiv => subdiv;
            UIslider SubDiv {
               y => <-.<-.<-.<-.glyph.GlyphUI.UIradioBoxLabel_type.y + <-.<-.<-.<-.glyph.GlyphUI.UIradioBoxLabel_type.height;
               parent => panel;
               min = 3.;
               max = 64.;
               value => isubdiv;
               mode = "integer";
               title => "Base subdivision";
               active => (<-.<-.<-.<-.glyph.GlyphUI.UIradioBoxLabel_type.selectedItem == 3);
            };
         };
         macro cone {
            float ang[(subdiv + 1)] => init_array((subdiv + 1),0,(2 * 3.141592653));
            float x[(subdiv + 1)][1] => init_array((subdiv + 1),(height - cone_height),(height - cone_height));
            float y[(subdiv + 1)][1] => (radius * cos(ang));
            float z[(subdiv + 1)][1] => (radius * sin(ang));
            float xyz_circle[(subdiv + 1)][3] => combine_array(x,y,z);
            float xyz_tip[3] => {height,0,0};
            int conn0[(subdiv + 1)][1] => init_array((subdiv + 1),0,0);
            int conn1[(subdiv + 1)][1] => init_array((subdiv + 1),1,(subdiv + 1));
            int c21[subdiv][1] => conn1[1:subdiv][];
            int c22[1][1] = {1};
            int conn2[(subdiv + 1)][1] => concat_array(c21,c22);
            int nxyz<NEportLevels={0,2}> => (subdiv + 2);
            int ntri<NEportLevels={0,2}> => (subdiv + 1);
            float xyz<NEportLevels={0,2}>[nxyz][3] => concat_array(xyz_tip,xyz_circle);
            int connect<NEportLevels={0,2}>[(3 * (subdiv + 1))] => combine_array(conn0,conn1,conn2);
         };
         macro line {
            int nlines<NEportLevels={0,2}> = 2;
            int nxyz<NEportLevels={0,2}> = 2;
            float xyz[2][3] => {{0,0,0},
               {height,0,0}};
            int connect<NEportLevels={0,2}>[2] => {<-.cone.nxyz,
               (<-.cone.nxyz + 1)};
         };
         Line line_set {
            ncells = 1;
            node_connect_list => <-.line.connect;
         };
         Tri tri_set {
            ncells => <-.cone.ntri;
            node_connect_list => <-.cone.connect;
         };
         Mesh arrow4 {
            int nnodes => (<-.line.nxyz + <-.cone.nxyz);
            int nspace = 3;
            coordinates {
               values => concat_array(cone.xyz,line.xyz);
            };
            int ncell_sets = 2;
            cell_set => {line_set,tri_set};
         };
         olink out_fld => arrow4;
         link panel<NEportLevels={2,1}> => geometries.panel;
      };
      link panel<NEportLevels={2,1}> => <-.panel;
   };
   link in_field<NEportLevels={2,1}>;
   UImod_panel panel {
      parent<NEportLevels={3,0}>;
      title => name_of(<-.<-);
      option {
         set = 1;
      };
   };
   link out_obj<NEportLevels={1,2}> => glyph.out_obj;
   link out_fld<NEportLevels={1,1}> => glyph.out_fld;
};


MODS.offset Offset {
   float Factor<NEportLevels={1,0},export=2> = 1.;
   int Scale_Data_toggle<NEportLevels=1,export=2> = 0;

   GMOD.instancer instancer {
      Value => <-.UIpanel.visible;
      Group => <-.OffsetUI;
      active = 2;
   };
   UImod_panel UIpanel {
      parent<NEportLevels={3,0}>;
      message = "Select offset control panel.";
      title => name_of(<-.<-);
   };

   macro OffsetUI {
      ilink in_fld => <-.in_field;
      DV_Param_offset &param<NEportLevels={2,0}> => <-.OffsetParam;
      DVnode_data_labels DVnode_data_labels {
         in => <-.in_fld;
         int+nres ncomp => in.nnode_data;
      };
      UIradioBoxLabel UIradioBoxLabel {
         parent => <-.panel;
         labels<NEportLevels={2,0}> => <-.DVnode_data_labels.labels;
         &selectedItem => param.component;
         title => "data component";
         visible => <-.panel.visible;
         width => <-.panel.width;
      };
      UIslider Factor_slider {
         parent => panel;
         value => <-.<-.Factor;
         title => "Factor";
         y => <-.UIradioBoxLabel.y + <-.UIradioBoxLabel.height + 4;
         min = 0.;
         max = 1.;
         width => <-.panel.width * 11 / 12;
      };
      VUIslider_typein Factor_slider_typein {
         slider => Factor_slider;
      };
      UIfield Offset_Scale {
         parent => <-.panel;
         value = 1.;
         y => <-.Offset_label.y + <-.Offset_label.height + 4;
      };
      UIlabel Offset_label {
         parent => <-.panel;
         label => "Offset Scale";
         y => <-.Factor_slider.y + <-.Factor_slider.height + 5;
      };
      GMOD.copy_on_change scale {
         input => <-.Factor_slider.value * <-.Offset_Scale.value;
         output => <-.param.scale;
      };
      UItoggle Scale_Data {
         parent => <-.panel;
         y => <-.Offset_Scale.y + <-.Offset_Scale.height + 5;
         set => <-.<-.Scale_Data_toggle;
      };
      link panel<NEportLevels={2,1}> => UIpanel;
   };

   FLD.Node_Data Scale_Node_Data {
      nnodes     =>  <-.DVoffset.out.nnodes;
      nnode_data =>  switch(<-.OffsetUI.Scale_Data.set+1,0,<-.DVoffset.out.nnode_data);
      node_data {
         veclen      => <-.<-.DVoffset.out.node_data[index_of(node_data)].veclen;
         id          => <-.<-.DVoffset.out.node_data[index_of(node_data)].id;
         values      => cache(<-.<-.DVoffset.out.node_data[index_of(node_data)].values * <-.<-.Factor);
         null_flag   => <-.<-.DVoffset.out.node_data[index_of(node_data)].null_flag;
         null_value  => <-.<-.DVoffset.out.node_data[index_of(node_data)].null_value;
         labels      => <-.<-.DVoffset.out.node_data[index_of(node_data)].labels;
         units       => <-.<-.DVoffset.out.node_data[index_of(node_data)].units;
      };
   };

   Mesh+Node_Data &Scale_Field => merge(.Scale_Node_Data, .DVoffset.out);

   DVM.DVswitch DVswitch {
      in => {<-.DVoffset.out, <-.Scale_Field};
      index => <-.OffsetUI.Scale_Data.set;
   };

   out_fld => .DVswitch.out;
   obj {
      in => <-.DVswitch.out;
   };
};


macro Basic_Axis3D {
   string Axis_title_X<NEportLevels={1,1},export=2> = "X";
   string Axis_title_Y<NEportLevels={1,1},export=2> = "Y";
   string Axis_title_Z<NEportLevels={1,1},export=2> = "Z";
   float Axis_scale_X<NEportLevels={1,1},export=2> = 1.;
   float Axis_scale_Y<NEportLevels={1,1},export=2> = 1.;
   float Axis_scale_Z<NEportLevels={1,1},export=2> = 1.;
   Line set1 {
      ncells = 9;
      node_connect_list = {
         0,1,1,2,1,3,0,4,4,5,4,6,0,7,7,8,7,9
      };
   };
   Mesh axis {
      int nnodes = 10;
      int nspace = 3;
      coordinates {
         float values[.nvals][.veclen] => {
            0.,0.,0.,(1 * <-.<-.Axis_UI.xaxis_max.value),0.,0.,
            ((1 * <-.<-.Axis_UI.xaxis_max.value) - 0.3),0.15,0.,
            ((1 * <-.<-.Axis_UI.xaxis_max.value) - 0.3),-0.15,0.,0.,
            (1 * <-.<-.Axis_UI.yaxis_max.value),0.,-0.15,
            ((1 * <-.<-.Axis_UI.yaxis_max.value) - 0.3),0.,0.15,
            ((1 * <-.<-.Axis_UI.yaxis_max.value) - 0.3),0.,0.,0.,
            (1 * <-.<-.Axis_UI.zaxis_max.value),0.,-0.15,
            ((1 * <-.<-.Axis_UI.zaxis_max.value) - 0.3),0.,0.15,
            ((1 * <-.<-.Axis_UI.zaxis_max.value) - 0.3)
         };
      };
      int ncell_sets = 1;
      cell_set => {<-.set1};
   };
   UImod_panel panel {
      parent<NEportLevels={3,0}>;
      title => name_of(<-.<-);
      message = "Select axis control panel.";
      option {
         set = 1;
      };
   };
   DataObjectLite obj {
      in => <-.axis;
   };
   olink out_fld<export=3,NEportLevels={1,0}> => .axis;
   olink out_obj => .GroupObject.obj;
   GDM.GroupObject GroupObject {
      child_objs => {<-.obj.obj,
         <-.text_glyph.out_obj};
   };
   macro text_glyph {
      Mesh &in_mesh<NEportLevels={2,0},export_all=1> => <-.axis_title_position;
      string in_text<NEportLevels={2,0},export_all=1>[] => <-.Axis_UI.Axis_title;
      GMOD.instancer instancer {
         Value => <-.<-.panel.visible;
         Group => <-.TextUI;
         active = 2;
      };
      macro TextUI {
         int active_array[2] = {1,0};
         ilink UImod_panel<NEportLevels={3,1}> => <-.<-.panel;
         UIlabel UIlabel {
            y => <-.<-.<-.Axis_UI.zaxis_max.y + <-.<-.<-.Axis_UI.zaxis_max.height + 5;
            width = 45;
            parent => <-.UImod_panel;
            label => "Font";
            alignment = "left";
         };
         UItext Font {
            x => <-.UIlabel.width;
            y => <-.UIlabel.y;
            width = 200;
            active => <-.active_array[<-.StrokeText.set];
            parent => <-.UImod_panel;
            text = "-adobe-times-bold-r-*-*-20-*-*-*-*-*-*-*";
         };
         UIframe UIframe {
            y => <-.Font.y + <-.Font.height + 4;
            width  => <-.UImod_panel.width;
            height => <-.OffsetZValue.y + <-.OffsetZValue.height + 2;
            parent => <-.UImod_panel;
         };
         UIoption UIoption {
            label => "Left";
            set = 1;
         };
         UIoption UIoption#1 {
            label => "Center";
         };
         UIoption UIoption#2 {
            label => "Right";
         };
         UIoptionMenu AlignHorizMenu {
            parent => <-.UIframe;
            label => "Align Horizontal";
            cmdList => {<-.UIoption,<-.UIoption#1,<-.UIoption#2};
            selectedItem<NEportLevels={0,3}> = 0;
            alignment = "left";
            x = 2;
            y = 2;
         };
         UIoption UIoption#3 {
            label => "Base";
            set = 1;
         };
         UIoption UIoption#4 {
            label => "Bottom";
         };
         UIoption UIoption#5 {
            label => "Center";
         };
         UIoption UIoption#6 {
            label => "Top";
         };
         UIoptionMenu AlignVertMenu {
            y = 30;
            parent => <-.UIframe;
            label => "Align Vertical";
            cmdList => {<-.UIoption#3,
               <-.UIoption#4,<-.UIoption#5,<-.UIoption#6};
            selectedItem<NEportLevels={0,3}> = 0;
            alignment = "left";
            x = 2;
         };
         UItoggle DropShadow {
            x = 2;
            y = 60;
            width = 150;
            active => <-.active_array[<-.StrokeText.set];
            parent => <-.UIframe;
            label => "Drop Shadow";
            alignment = "left";
            set<NEportLevels={0,3}>;
         };
         UItoggle Bounds {
            x = 2;
            y = 90;
            active => <-.active_array[<-.StrokeText.set];
            parent => <-.UIframe;
            label => "Bounds";
            set<NEportLevels={0,3}>;
         };
         UItoggle Underline {
            x = 2;
            y = 120;
            active => <-.active_array[<-.StrokeText.set];
            parent => <-.UIframe;
            label => "Underline";
            set<NEportLevels={0,3}>;
         };
         UItoggle Background {
            x = 2;
            y = 150;
            active => <-.active_array[<-.StrokeText.set];
            parent => <-.UIframe;
            label => "Background";
            set<NEportLevels={0,3}>;
         };
         UItoggle Leadline {
            x = 2;
            y = 180;
            active => <-.active_array[<-.StrokeText.set];
            parent => <-.UIframe;
            label => "Leadline";
            set<NEportLevels={0,3}>;
         };
         UItoggle Radial {
            x = 2;
            y => <-.Leadline.y + <-.Leadline.height + 5;
            width => <-.UIframe.clientWidth - 8;
            active => <-.active_array[<-.StrokeText.set];
            parent => <-.UIframe;
            label => "Radial";
            set<NEportLevels={0,3}>;
         };
         UItoggle Offset {
            x = 2;
            y => <-.Radial.y + <-.Radial.height + 5;
            width => <-.UIframe.clientWidth - 8;
            active => <-.active_array[<-.StrokeText.set];
            parent => <-.UIframe;
            label => "Offset";
            set<NEportLevels={0,3}>;
         };
         UIfieldTypein OffsetXValue {
            UIparent => <-.UIframe;
            flabel => "X Offset";
            label {
               alignment = "center";
            };
            field {
               active => <-.<-.active_array[<-.<-.StrokeText.set];
               value => 0.05;
            };
            x = 4;
            y => <-.Offset.y + <-.Offset.height + 4;
            width  => <-.UIframe.clientWidth - 8;
            height => field.height + 6;
         };
         UIfieldTypein OffsetYValue {
            UIparent => <-.UIframe;
            flabel => "Y Offset";
            label {
               alignment = "center";
            };
            field {
               active => <-.<-.active_array[<-.<-.StrokeText.set];
               value => 0.05;
            };
            x = 4;
            y => <-.OffsetXValue.y + <-.OffsetXValue.height + 5;
            width  => <-.UIframe.clientWidth - 8;
            height => field.height + 6;
         };
         UIfieldTypein OffsetZValue {
            UIparent => <-.UIframe;
            flabel => "Z Offset";
            label {
               alignment = "center";
            };
            field {
               active => <-.<-.active_array[<-.<-.StrokeText.set];
               value => 0.;
            };
            x = 4;
            y => <-.OffsetYValue.y + <-.OffsetYValue.height + 5;
            width  => <-.UIframe.clientWidth - 8;
            height => field.height + 6;
         };
         UItoggle StrokeText {
            y => <-.UIframe.y + <-.UIframe.height + 5;
            width =>  <-.UImod_panel.clientWidth - 50;
            parent => <-.UImod_panel;
            label => "StrokeText";
            set => <-.<-.TextValues.stroke;
         };
         UIframe StrokeFrame {
            y => <-.StrokeText.y + <-.StrokeText.height + 10;
            width => <-.UImod_panel.clientWidth;
            height => <-.StrokeExpansion.y + <-.StrokeExpansion.height + 6;
            visible => <-.StrokeText.set;
            parent => <-.UImod_panel;
         };
         UIoptionMenu StrokeFontType {
            x = 4;
            y = 0;
            width => <-.StrokeFrame.clientWidth - 8;
            parent => <-.StrokeFrame;
            label => "Font Type";
            cmdList => {
               <-.Font1,<-.Font2,<-.Font3,<-.Font4,<-.Font5,<-.Font6,
               <-.Font7,<-.Font8,<-.Font9,<-.Font10
            };
            selectedItem<NEportLevels={0,3}> = 0;
            alignment = "left";
         };
         UIoption Font1 {
            label => "Roman Simplex";
            set = 1;
         };
         UIoption Font2 {
            label => "Roman Duplex";
         };
         UIoption Font3 {
            label => "Roman Triplex";
         };
         UIoption Font4 {
            label => "Roman Complex";
         };
         UIoption Font5 {
            label => "Script Simplex";
         };
         UIoption Font6 {
            label => "Script Complex";
         };
         UIoption Font7 {
            label => "Italics Triplex";
         };
         UIoption Font8 {
            label => "Italics Duplex";
         };
         UIoption Font9 {
            label => "Greek Simplex";
         };
         UIoption Font10 {
            label => "Greek Complex";
         };
         UIoptionMenu StrokePlane {
            x = 4;
            y => <-.StrokeFontType.y + <-.StrokeFontType.height + 5;
            width => (<-.StrokeFrame.clientWidth - 8);
            parent => <-.StrokeFrame;
            label => "Plane";
            cmdList => {<-.XYplane,
               <-.XZplane,<-.YZplane};
            selectedItem<NEportLevels={0,3}> = 0;
            alignment = "left";
         };
         UIoption XYplane {
            label => "XY";
            set = 1;
         };
         UIoption XZplane {
            label => "XZ";
         };
         UIoption YZplane {
            label => "YZ";
         };
         UIoptionMenu StrokeOrient {
            x = 4;
            y => <-.StrokePlane.y + <-.StrokePlane.height + 5;
            width => <-.StrokeFrame.clientWidth - 8;
            parent => <-.StrokeFrame;
            label => "Orientation";
            cmdList => {
               <-.LRorient,<-.UPorient,<-.RLorient,<-.DOWNorient,
               <-.ARBorient
            };
            selectedItem<NEportLevels={0,3}> = 0;
            alignment = "left";
         };
         UIoption LRorient {
            label => "Left-to-Right";
            set = 1;
         };
         UIoption UPorient {
            label => "Up";
         };
         UIoption RLorient {
            label => "Right-to-Left";
         };
         UIoption DOWNorient {
            label => "Down";
         };
         UIoption ARBorient {
            label => "Arbitrary";
         };
         UIslider StrokeAngle {
            x = 4;
            y => <-.StrokeOrient.y + <-.StrokeOrient.height + 5;
            width => <-.UImod_panel.clientWidth - 50;
            active => switch(((<-.StrokeOrient.selectedItem == 4) + 1),0,1);
            parent => <-.StrokeFrame;
            min = -180.;
            max = 180.;
            value = 0.;
            title => "Angle";
         };
         UIoptionMenu StrokePath {
            x = 4;
            y => <-.StrokeAngle.y + <-.StrokeAngle.height + 5;
            width =>  <-.StrokeFrame.clientWidth - 8;
            parent => <-.StrokeFrame;
            label => "Path";
            cmdList => {<-.LRpath,
               <-.UPpath,<-.RLpath,<-.DOWNpath};
            selectedItem<NEportLevels={0,3}> = 0;
            alignment = "left";
         };
         UIoption LRpath {
            label => "Left-to-Right";
            set = 1;
         };
         UIoption UPpath {
            label => "Up";
         };
         UIoption RLpath {
            label => "Right-to-Left";
         };
         UIoption DOWNpath {
            label => "Down";
         };
         UIoptionMenu StrokeSpaceMode {
            x = 4;
            y => <-.StrokePath.y + <-.StrokePath.height + 5;
            width =>  <-.StrokeFrame.clientWidth - 8;
            parent => <-.StrokeFrame;
            label => "Spacing Mode";
            cmdList => {<-.FixedSpace,<-.PropSpace};
            selectedItem<NEportLevels={0,3}> = 1;
            alignment = "left";
         };
         UIoption FixedSpace {
            label => "Fixed";
         };
         UIoption PropSpace {
            label => "Proportional";
            set = 1;
         };
         UIslider StrokeSpacing {
            x = 4;
            y => <-.StrokeSpaceMode.y + <-.StrokeSpaceMode.height + 5;
            width  => <-.UImod_panel.clientWidth - 50;
            parent => <-.StrokeFrame;
            min = 0.;
            max = 3.;
            value = 0.;
            title => "Spacing";
         };
         UIslider StrokeHeight {
            x = 4;
            y => <-.StrokeSpacing.y + <-.StrokeSpacing.height + 5;
            width  => <-.UImod_panel.clientWidth - 50;
            parent => <-.StrokeFrame;
            min = 0.01;
            max = 10.;
            value = 1.;
            title => "Height";
         };
         UIslider StrokeExpansion {
            x = 4;
            y => <-.StrokeHeight.y + <-.StrokeHeight.height + 5;
            width  => <-.UImod_panel.clientWidth - 50;
            parent => <-.StrokeFrame;
            min = 0.25;
            max = 3.;
            value = 1.;
            title => "Expansion";
         };
      };
      group TextValues<export_all=3> {
         int align_horiz<NEportLevels={2,0}> => <-.TextUI.AlignHorizMenu.selectedItem;
         int align_vert<NEportLevels={2,0}> => <-.TextUI.AlignVertMenu.selectedItem;
         int drop_shadow<NEportLevels={2,0}> => <-.TextUI.DropShadow.set;
         int background<NEportLevels={2,0}> => <-.TextUI.Background.set;
         int bounds<NEportLevels={2,0}> => <-.TextUI.Bounds.set;
         int underline<NEportLevels={2,0}> => <-.TextUI.Underline.set;
         int lead_line<NEportLevels={2,0}> => <-.TextUI.Leadline.set;
         int radial<NEportLevels={2,0}> => <-.TextUI.Radial.set;
         int do_offset<NEportLevels={2,0}> => <-.TextUI.Offset.set;
         float offset<NEportLevels={2,0}>[3] => {
            <-.TextUI.OffsetXValue.field.value,
            <-.TextUI.OffsetYValue.field.value,
            <-.TextUI.OffsetZValue.field.value};
         int xform_mode;
         int color;
         string text_values[] => <-.in_text;
         int stroke = 0;
         group StrokeTextAttribs {
            int font_type => <-.<-.TextUI.StrokeFontType.selectedItem;
            int style;
            int plane => <-.<-.TextUI.StrokePlane.selectedItem;
            int orient => <-.<-.TextUI.StrokeOrient.selectedItem;
            int path => <-.<-.TextUI.StrokePath.selectedItem;
            int space_mode => <-.<-.TextUI.StrokeSpaceMode.selectedItem;
            float spacing => <-.<-.TextUI.StrokeSpacing.value;
            float angle => <-.<-.TextUI.StrokeAngle.value;
            float height => <-.<-.TextUI.StrokeHeight.value;
            float expansion => <-.<-.TextUI.StrokeExpansion.value;
            float width;
         };
      };
      Grid+Xform &TextField => merge(.TextValues,.in_mesh,,,,,,,,,,);
      DataObjectNoTexture obj {
         in => <-.TextField;
         Props {
            font => <-.<-.TextUI.Font.text;
            inherit = 0;
         };
      };
      olink out_obj => .obj.obj;
   };
   Mesh axis_title_position<NEportLevels={0,1}> {
      int nnodes = 3;
      int nspace = 3;
      coordinates {
         float values[.nvals][.veclen] => {
            <-.<-.Axis_UI.xaxis_max.value,0,0,0,
            <-.<-.Axis_UI.yaxis_max.value,0,0,0,
            <-.<-.Axis_UI.zaxis_max.value
         };
      };
      &xform => <-.axis.xform;
      int ncell_sets = 1;
   };
   macro Axis_UI {
      link panel<NEportLevels={2,1}> => <-.panel;
      UItoggle xform_toggle {
         parent => <-.panel;
         label => "Transformation Editor";
         y = 0;
         width => <-.<-.panel.width;
      };
      XformEditor probe_edit {
         obj_in => <-.<-.axis;
         vis => <-.xform_toggle.set;
      };
      UIlabel UIlabel_text {
         parent => <-.panel;
         label => "Axis title";
         y => <-.xform_toggle.y + <-.xform_toggle.height + 5;
      };
      UIlabel UIlabel_scale {
         parent => <-.panel;
         label => "Axis scale";
         x => <-.UIlabel_text.width + 5;
         y => <-.UIlabel_text.y;
      };
      string Axis_title<NEportLevels={1,1},export_all=1>[] => {.xaxis_text.text,
         .yaxis_text.text,.zaxis_text.text};
      UItext xaxis_text {
         parent => <-.panel;
         text => <-.<-.Axis_title_X;
         y => <-.xaxis_max.y;
         height => UIdata.UIfonts[0].lineHeight + 8;
      };
      UItext yaxis_text {
         parent => <-.panel;
         text => <-.<-.Axis_title_Y;
         y => <-.yaxis_max.y;
         height => UIdata.UIfonts[0].lineHeight + 8;
      };
      UItext zaxis_text {
         parent => <-.panel;
         text => <-.<-.Axis_title_Z;
         y => <-.zaxis_max.y;
         height => UIdata.UIfonts[0].lineHeight + 8;
      };
      UIfield xaxis_max {
         value<NEportLevels={2,2}> => <-.<-.Axis_scale_X;
         parent => <-.panel;
         y => <-.UIlabel_text.y + <-.UIlabel_text.height + 5;
         x => <-.xaxis_text.width + 5;
         height => UIdata.UIfonts[0].lineHeight + 8;
      };
      UIfield yaxis_max {
         value<NEportLevels={2,2}> => <-.<-.Axis_scale_Y;
         parent => <-.panel;
         y => <-.xaxis_max.y + <-.xaxis_max.height + 5;
         x => <-.yaxis_text.width + 5;
         height => UIdata.UIfonts[0].lineHeight + 8;
      };
      UIfield zaxis_max {
         value<NEportLevels={2,2}> => <-.<-.Axis_scale_Z;
         parent => <-.panel;
         y => <-.yaxis_max.y + <-.yaxis_max.height + 5;
         x => <-.zaxis_text.width + 5;
         height => UIdata.UIfonts[0].lineHeight + 8;
      };
   };
   GMOD.instancer instancer {
      Value => <-.panel.visible;
      Group => <-.Axis_UI;
   };
};


macro Basic_Axis2D {
   string Axis_title_X<NEportLevels=1,export=2> = "X";
   string Axis_title_Y<NEportLevels=1,export=2> = "Y";
   float Axis_scale_X<NEportLevels=1,export=2> = 1.;
   float Axis_scale_Y<NEportLevels=1,export=2> = 1.;
   Line set1 {
      ncells = 6;
      node_connect_list = {
         0,1,1,2,1,3,0,4,4,5,4,6
      };
   };
   Mesh axis {
      int nnodes = 7;
      int nspace = 3;
      coordinates {
         float values[.nvals][.veclen] => {
            0.,0.,0.,(1 * <-.<-.Axis_UI.xaxis_max.value),0.,0.,
            ((1 * <-.<-.Axis_UI.xaxis_max.value) - 0.3),0.15,0.,
            ((1 * <-.<-.Axis_UI.xaxis_max.value) - 0.3),-0.15,0.,0.,
            (1 * <-.<-.Axis_UI.yaxis_max.value),0.,-0.15,
            ((1 * <-.<-.Axis_UI.yaxis_max.value) - 0.3),0.,0.15,
            ((1 * <-.<-.Axis_UI.yaxis_max.value) - 0.3),0.
         };
      };
      int ncell_sets = 1;
      cell_set => {<-.set1};
   };
   UImod_panel panel {
      parent<NEportLevels={3,0}>;
      title => name_of(<-.<-);
      message = "Select axis control panel.";
      option {
         set = 1;
      };
   };
   XformEditor probe_edit {
      obj_in => <-.axis;
      vis => <-.Axis_UI.xform_toggle.set;
   };
   DataObjectLite obj {
      in => <-.axis;
   };
   olink out_fld<export=3,NEportLevels={1,0}> => .axis;
   olink out_obj => .GroupObject.obj;
   GDM.GroupObject GroupObject {
      child_objs => {<-.obj.obj,
         <-.text_glyph.out_obj};
   };
   macro text_glyph {
      Mesh &in_mesh<NEportLevels={2,0},export_all=1> => <-.axis_title_position;
      string in_text<NEportLevels={2,0},export_all=1>[] => <-.Axis_UI.Axis_title;
      GMOD.instancer instancer {
         Value => <-.<-.panel.visible;
         Group => <-.TextUI;
         active = 2;
      };
      macro TextUI {
         int active_array[2] = {1,0};
         ilink UImod_panel<NEportLevels={3,1}> => <-.<-.panel;
         UIlabel UIlabel {
            y => <-.<-.<-.Axis_UI.yaxis_max.y + <-.<-.<-.Axis_UI.yaxis_max.height + 5;
            width = 45;
            parent => <-.UImod_panel;
            label => "Font";
            alignment = "left";
         };
         UItext Font {
            x => <-.UIlabel.width;
            y => <-.UIlabel.y;
            width = 200;
            active => <-.active_array[<-.StrokeText.set];
            parent => <-.UImod_panel;
            text<NEportLevels={0,3}> = "-adobe-times-bold-r-*-*-20-*-*-*-*-*-*-*";
         };
         UIframe UIframe {
            y => <-.Font.y + <-.Font.height + 4;
            width  => <-.UImod_panel.width;
            height => <-.OffsetZValue.y + <-.OffsetZValue.height + 2;
            parent => <-.UImod_panel;
         };
         UIoption UIoption {
            label => "Left";
            set = 1;
         };
         UIoption UIoption#1 {
            label => "Center";
         };
         UIoption UIoption#2 {
            label => "Right";
         };
         UIoptionMenu AlignHorizMenu {
            parent => <-.UIframe;
            label => "Align Horizontal";
            cmdList => {<-.UIoption,<-.UIoption#1,<-.UIoption#2};
            selectedItem<NEportLevels={0,3}> = 0;
            alignment = "left";
            x = 2;
            y = 2;
         };
         UIoption UIoption#3 {
            label => "Base";
            set = 1;
         };
         UIoption UIoption#4 {
            label => "Bottom";
         };
         UIoption UIoption#5 {
            label => "Center";
         };
         UIoption UIoption#6 {
            label => "Top";
         };
         UIoptionMenu AlignVertMenu {
            y = 30;
            parent => <-.UIframe;
            label => "Align Vertical";
            cmdList => {<-.UIoption#3,
               <-.UIoption#4,<-.UIoption#5,<-.UIoption#6};
            selectedItem<NEportLevels={0,3}> = 0;
            alignment = "left";
            x = 2;
         };
         UItoggle DropShadow {
            x = 2;
            y = 60;
            width = 150;
            active => <-.active_array[<-.StrokeText.set];
            parent => <-.UIframe;
            label => "Drop Shadow";
            alignment = "left";
            set<NEportLevels={0,3}>;
         };
         UItoggle Bounds {
            x = 2;
            y = 90;
            active => <-.active_array[<-.StrokeText.set];
            parent => <-.UIframe;
            label => "Bounds";
            set<NEportLevels={0,3}>;
         };
         UItoggle Underline {
            x = 2;
            y = 120;
            active => <-.active_array[<-.StrokeText.set];
            parent => <-.UIframe;
            label => "Underline";
            set<NEportLevels={0,3}>;
         };
         UItoggle Background {
            x = 2;
            y = 150;
            active => <-.active_array[<-.StrokeText.set];
            parent => <-.UIframe;
            label => "Background";
            set<NEportLevels={0,3}>;
         };
         UItoggle Leadline {
            x = 2;
            y = 180;
            active => <-.active_array[<-.StrokeText.set];
            parent => <-.UIframe;
            label => "Leadline";
            set<NEportLevels={0,3}>;
         };
         UItoggle Radial {
            x = 2;
            y => <-.Leadline.y + <-.Leadline.height + 5;
            width  => <-.UIframe.clientWidth - 8;
            active => <-.active_array[<-.StrokeText.set];
            parent => <-.UIframe;
            label => "Radial";
            set<NEportLevels={0,3}>;
         };
         UItoggle Offset {
            y => <-.Radial.y + <-.Radial.height + 5;
            width => <-.UIframe.clientWidth - 8;
            active => <-.active_array[<-.StrokeText.set];
            parent => <-.UIframe;
            label => "Offset";
            set<NEportLevels={0,3}>;
         };
         UIfieldTypein OffsetXValue {
            UIparent => <-.UIframe;
            flabel => "X Offset";
            label {
               alignment = "center";
            };
            field {
               active => <-.<-.active_array[<-.<-.StrokeText.set];
               value => 0.05;
            };
            x = 4;
            y => <-.Offset.y + <-.Offset.height + 4;
            width  => <-.UIframe.clientWidth - 8;
            height => field.height + 6;
         };
         UIfieldTypein OffsetYValue {
            UIparent => <-.UIframe;
            flabel => "Y Offset";
            label {
               alignment = "center";
            };
            field {
               active => <-.<-.active_array[<-.<-.StrokeText.set];
               value => 0.05;
            };
            x = 4;
            y => <-.OffsetXValue.y + <-.OffsetXValue.height + 5;
            width  => <-.UIframe.clientWidth - 8;
            height => field.height + 6;
         };
         UIfieldTypein OffsetZValue {
            UIparent => <-.UIframe;
            flabel => "Z Offset";
            label {
               alignment = "center";
            };
            field {
               active => <-.<-.active_array[<-.<-.StrokeText.set];
               value => 0.;
            };
            x = 4;
            y => <-.OffsetYValue.y + <-.OffsetYValue.height + 5;
            width  => <-.UIframe.clientWidth - 8;
            height => field.height + 6;
         };
         UItoggle StrokeText {
            y => <-.UIframe.y + <-.UIframe.height + 5;
            width  => <-.UImod_panel.clientWidth - 50;
            parent => <-.UImod_panel;
            label  => "StrokeText";
            set => <-.<-.TextValues.stroke;
         };
         UIframe StrokeFrame {
            y => <-.StrokeText.y + <-.StrokeText.height + 10;
            width  => <-.UImod_panel.clientWidth;
            height => <-.StrokeExpansion.y + <-.StrokeExpansion.height + 6;
            visible => <-.StrokeText.set;
            parent => <-.UImod_panel;
         };
         UIoptionMenu StrokeFontType {
            x = 4;
            y = 0;
            width  => <-.StrokeFrame.clientWidth - 8;
            parent => <-.StrokeFrame;
            label  => "Font Type";
            cmdList => {
               <-.Font1,<-.Font2,<-.Font3,<-.Font4,<-.Font5,<-.Font6,
               <-.Font7,<-.Font8,<-.Font9,<-.Font10
            };
            selectedItem<NEportLevels={0,3}> = 0;
            alignment = "left";
         };
         UIoption Font1 {
            label => "Roman Simplex";
            set = 1;
         };
         UIoption Font2 {
            label => "Roman Duplex";
         };
         UIoption Font3 {
            label => "Roman Triplex";
         };
         UIoption Font4 {
            label => "Roman Complex";
         };
         UIoption Font5 {
            label => "Script Simplex";
         };
         UIoption Font6 {
            label => "Script Complex";
         };
         UIoption Font7 {
            label => "Italics Triplex";
         };
         UIoption Font8 {
            label => "Italics Duplex";
         };
         UIoption Font9 {
            label => "Greek Simplex";
         };
         UIoption Font10 {
            label => "Greek Complex";
         };
         UIoptionMenu StrokePlane {
            x = 4;
            y => <-.StrokeFontType.y + <-.StrokeFontType.height + 5;
            width  => <-.StrokeFrame.clientWidth - 8;
            parent => <-.StrokeFrame;
            label  => "Plane";
            cmdList => {<-.XYplane,<-.XZplane,<-.YZplane};
            selectedItem<NEportLevels={0,3}> = 0;
            alignment = "left";
         };
         UIoption XYplane {
            label => "XY";
            set = 1;
         };
         UIoption XZplane {
            label => "XZ";
         };
         UIoption YZplane {
            label => "YZ";
         };
         UIoptionMenu StrokeOrient {
            x = 4;
            y => <-.StrokePlane.y + <-.StrokePlane.height + 5;
            width  => <-.StrokeFrame.clientWidth - 8;
            parent => <-.StrokeFrame;
            label  => "Orientation";
            cmdList => {
               <-.LRorient,<-.UPorient,<-.RLorient,<-.DOWNorient,
               <-.ARBorient
            };
            selectedItem<NEportLevels={0,3}> = 0;
            alignment = "left";
         };
         UIoption LRorient {
            label => "Left-to-Right";
            set = 1;
         };
         UIoption UPorient {
            label => "Up";
         };
         UIoption RLorient {
            label => "Right-to-Left";
         };
         UIoption DOWNorient {
            label => "Down";
         };
         UIoption ARBorient {
            label => "Arbitrary";
         };
         UIslider StrokeAngle {
            x = 4;
            y => <-.StrokeOrient.y + <-.StrokeOrient.height + 5;
            width  => <-.UImod_panel.clientWidth - 50;
            active => switch(((<-.StrokeOrient.selectedItem == 4) + 1),0,1);
            parent => <-.StrokeFrame;
            min = -180.;
            max = 180.;
            value = 0.;
            title => "Angle";
         };
         UIoptionMenu StrokePath {
            x = 4;
            y => <-.StrokeAngle.y + <-.StrokeAngle.height + 5;
            width  => <-.StrokeFrame.clientWidth - 8;
            parent => <-.StrokeFrame;
            label  => "Path";
            cmdList => {<-.LRpath,
               <-.UPpath,<-.RLpath,<-.DOWNpath};
            selectedItem<NEportLevels={0,3}> = 0;
            alignment = "left";
         };
         UIoption LRpath {
            label => "Left-to-Right";
            set = 1;
         };
         UIoption UPpath {
            label => "Up";
         };
         UIoption RLpath {
            label => "Right-to-Left";
         };
         UIoption DOWNpath {
            label => "Down";
         };
         UIoptionMenu StrokeSpaceMode {
            x = 4;
            y => <-.StrokePath.y + <-.StrokePath.height + 5;
            width  => <-.StrokeFrame.clientWidth - 8;
            parent => <-.StrokeFrame;
            label => "Spacing Mode";
            cmdList => {<-.FixedSpace,<-.PropSpace};
            selectedItem<NEportLevels={0,3}> = 1;
            alignment = "left";
         };
         UIoption FixedSpace {
            label => "Fixed";
         };
         UIoption PropSpace {
            label => "Proportional";
            set = 1;
         };
         UIslider StrokeSpacing {
            x = 4;
            y => <-.StrokeSpaceMode.y + <-.StrokeSpaceMode.height + 5;
            width  => <-.UImod_panel.clientWidth - 50;
            parent => <-.StrokeFrame;
            min = 0.;
            max = 3.;
            value = 0.;
            title => "Spacing";
         };
         UIslider StrokeHeight {
            x = 4;
            y => <-.StrokeSpacing.y + <-.StrokeSpacing.height + 5;
            width  => <-.UImod_panel.clientWidth - 50;
            parent => <-.StrokeFrame;
            min = 0.01;
            max = 10.;
            value = 1.;
            title => "Height";
         };
         UIslider StrokeExpansion {
            x = 4;
            y => <-.StrokeHeight.y + <-.StrokeHeight.height + 5;
            width  => <-.UImod_panel.clientWidth - 50;
            parent => <-.StrokeFrame;
            min = 0.25;
            max = 3.;
            value = 1.;
            title => "Expansion";
         };
      };
      group TextValues<export_all=3> {
         int align_horiz<NEportLevels={2,0}> => <-.TextUI.AlignHorizMenu.selectedItem;
         int align_vert<NEportLevels={2,0}> => <-.TextUI.AlignVertMenu.selectedItem;
         int drop_shadow<NEportLevels={2,0}> => <-.TextUI.DropShadow.set;
         int background<NEportLevels={2,0}> => <-.TextUI.Background.set;
         int bounds<NEportLevels={2,0}> => <-.TextUI.Bounds.set;
         int underline<NEportLevels={2,0}> => <-.TextUI.Underline.set;
         int lead_line<NEportLevels={2,0}> => <-.TextUI.Leadline.set;
         int radial<NEportLevels={2,0}> => <-.TextUI.Radial.set;
         int do_offset<NEportLevels={2,0}> => <-.TextUI.Offset.set;
         float offset<NEportLevels={2,0}>[3] => {
            <-.TextUI.OffsetXValue.field.value,
            <-.TextUI.OffsetYValue.field.value,
            <-.TextUI.OffsetZValue.field.value};
         int xform_mode;
         int color;
         string text_values[] => <-.in_text;
         int stroke = 0;
         group StrokeTextAttribs {
            int font_type => <-.<-.TextUI.StrokeFontType.selectedItem;
            int style;
            int plane => <-.<-.TextUI.StrokePlane.selectedItem;
            int orient => <-.<-.TextUI.StrokeOrient.selectedItem;
            int path => <-.<-.TextUI.StrokePath.selectedItem;
            int space_mode => <-.<-.TextUI.StrokeSpaceMode.selectedItem;
            float spacing => <-.<-.TextUI.StrokeSpacing.value;
            float angle => <-.<-.TextUI.StrokeAngle.value;
            float height => <-.<-.TextUI.StrokeHeight.value;
            float expansion => <-.<-.TextUI.StrokeExpansion.value;
            float width;
         };
      };
      Grid+Xform &TextField => merge(.TextValues,.in_mesh,,,,,,,,,,);
      DataObjectNoTexture obj {
         in => <-.TextField;
         Props {
            font => <-.<-.TextUI.Font.text;
            inherit = 0;
         };
      };
      olink out_obj => .obj.obj;
   };
   Mesh axis_title_position<NEportLevels={0,1}> {
      int nnodes = 2;
      int nspace = 3;
      coordinates {
         float values[.nvals][.veclen] => {
            <-.<-.Axis_UI.xaxis_max.value,0,0,0,
            <-.<-.Axis_UI.yaxis_max.value,0
         };
      };
      &xform => <-.axis.xform;
      int ncell_sets = 1;
   };
   GMOD.instancer instancer {
      Value => <-.panel.visible;
      Group => <-.Axis_UI;
   };
   macro Axis_UI {
      link panel<NEportLevels={2,1}> => <-.panel;
      UItoggle xform_toggle {
         parent => <-.panel;
         label => "Transformation Editor";
         y = 0;
         width => <-.<-.panel.width;
      };
      UIlabel UIlabel_text {
         parent => <-.panel;
         label => "Axis title";
         y => <-.xform_toggle.y + <-.xform_toggle.height + 5;
      };
      UIlabel UIlabel_scale {
         parent => <-.panel;
         label => "Axis scale";
         x => <-.UIlabel_text.width + 5;
         y => <-.UIlabel_text.y;
      };
      string Axis_title<NEportLevels={1,1},export_all=1>[] => {.xaxis_text.text,
         .yaxis_text.text};
      UItext xaxis_text {
         parent => <-.panel;
         text => <-.<-.Axis_title_X;
         y => <-.xaxis_max.y;
         height => UIdata.UIfonts[0].lineHeight + 8;
      };
      UItext yaxis_text {
         parent => <-.panel;
         text => <-.<-.Axis_title_Y;
         y => <-.yaxis_max.y;
         height => UIdata.UIfonts[0].lineHeight + 8;
      };
      UIfield xaxis_max {
         value<NEportLevels={2,2}> => <-.<-.Axis_scale_X;
         parent => <-.panel;
         y => <-.UIlabel_text.y + <-.UIlabel_text.height + 5;
         x => <-.xaxis_text.width + 5;
         height => UIdata.UIfonts[0].lineHeight + 8;
      };
      UIfield yaxis_max {
         value<NEportLevels={2,2}> => <-.<-.Axis_scale_Y;
         parent => <-.panel;
         y => <-.xaxis_max.y + <-.xaxis_max.height + 5;
         x => <-.yaxis_text.width + 5;
         height => UIdata.UIfonts[0].lineHeight + 8;
      };
   };
};


macro Probe {
   int Data<NEportLevels=1,export=2> = 0;
   int Probe_Type<NEportLevels=1,export=2> = 0;
   int sphere_subdiv<NEportLevels=1,export=2> = 6;
   ilink in_field<export_all=1>;
   GDobject_templ &in_pick<NEportLevels={2,0},export_all=1>;
   DV_Param_probe ProbeParam<NEportLevels=1,export_all=2> {
      component = 0;
      scale = 1.;
      normalize = 1;
   };
   Probe Probe {
      in_fld => in_field;
      pick => in_pick;
      in_probe => <-.Probe_Glyphs.DVswitch.out;
      DV_Param_probe &param<NEportLevels={2,0}> => ProbeParam;
      oparam {
         value<NEportLevels={2,2}> => switch((<-.DVswitch_out.index + 1),DVinterp_data.out.node_data[0].values[0],DVinterp_cell_data.out.node_data[0].values[0]);
      };
      DVextract_comp {
         in => switch((<-.in_datatype + 1),<-.in_fld);
      };
      DVglyph {
         in => <-.DVswitch_out.out;
      };
      out_probe => .DVswitch_out.out;
      DVextr_cell_comp DVextr_cell_comp {
         in => switch(<-.in_datatype,<-.in_fld);
         comp => <-.param.component;
      };
      DVinterp_cell_data DVinterp_cell_data {
         in => DVextr_cell_comp.out;
         probe => fprobe;
         component = 0;
      };
      DVM.DVswitch DVswitch_out {
         in => {
            <-.DVinterp_data.out,<-.DVinterp_cell_data.out};
         index => in_datatype;
      };
      link in_datatype<NEportLevels={2,1}> => ProbeUI.UIradioBoxLabel#1.selectedItem;
      link+nres out_data<NEportLevels={1,2}> => .oparam.value;
   };
   DV_Param_probe_o &ProbeOParam<NEportLevels=1,export_all=2> => Probe.oparam;
   GMOD.instancer instancer {
      Value => UIpanel.visible;
      Group => ProbeUI;
      active = 2;
   };
   UImod_panel UIpanel {
      parent<NEportLevels={3,0}>;
      message = "Select Probe control panel.";
      title => name_of(<-.<-);
      option {
         set = 1;
      };
   };
   macro ProbeUI {
      ilink in_fld => in_field;
      DV_Param_probe &param<NEportLevels={2,0}> => ProbeParam;
      DV_Param_probe_o &oparam<NEportLevels={2,0}> => ProbeOParam;
      DVnode_data_labels DVnode_data_labels {
         in => in_fld;
         int+nres ncomp => in.nnode_data;
      };
      ilink UIpanel => <-.UIpanel;

      string string<NEportLevels=1>[] = {"Node","Cell"};

      UIradioBoxLabel UIradioBoxLabel#1 {
         parent => <-.UIpanel;
         labels => <-.string;
         title => "Data";
         selectedItem<NEportLevels={2,3}> => <-.<-.Data;
         UIlabel.alignment = "left";
         UIradioBox.x = 8;
      };
      UIradioBoxLabel UIradioBoxLabel<NEportLevels={0,0}> {
         parent => <-.UIpanel;
         labels<NEportLevels={2,0}> => <-.DVswitch.out;
         &selectedItem => param.component;
         title => "Data Component";
         visible => <-.UIpanel.visible;
         y => <-.UIradioBoxLabel#1.y + <-.UIradioBoxLabel#1.height + 8;
         width => <-.UIpanel.width;
         UIlabel.alignment = "left";
         UIlabel.visible => array_size(<-.labels) > 0;
         UIradioBox.x = 8;
      };
      UItoggle norm_toggle {
         y => <-.<-.Probe_Glyphs.Sphere.sphere_ui.SubDiv.y + <-.<-.Probe_Glyphs.Sphere.sphere_ui.SubDiv.height + 8;
         width => <-.UIpanel.width;
         parent => <-.UIpanel;
         label => "Probe Normalize";
         set<NEportLevels={2,0}> => param.normalize;
      };
      UIslider scale_slider {
         y => <-.norm_toggle.y + <-.norm_toggle.height + 4;
         parent => <-.UIpanel;
         min = -10.;
         max = 10.;
         value<NEportLevels={2,0}> => param.scale;
         title => "probe scale";
         width => <-.UIpanel.width * 11 / 12;
      };
      VUIslider_typein scale_slider_typein {
         slider => scale_slider;
      };

      UIfieldTypein probe_value {
         UIparent => <-.UIpanel;
         flabel => "value";
         fval<NEportLevels={3,0}> => oparam.value[0];
         fmin+nres<NEportLevels={2,0}> => cache((in_fld.node_data[param.component].min_vec[0] - 10000));
         fmax+nres<NEportLevels={2,0}> => cache((in_fld.node_data[param.component].max_vec[0] + 10000));
         panel {
            y => <-.<-.scale_slider.y + <-.<-.scale_slider.height + 4;
            width => <-.<-.UIpanel.width;
         };
         x = 0;
      };
      UItoggle xform_toggle {
         y => <-.probe_value.panel.y + <-.probe_value.panel.height + 4;
         width => <-.UIpanel.width;
         parent => <-.UIpanel;
         label => "Probe Transform Editor";
      };
      XformEditor probe_edit {
         obj_in => Probe.fprobe;
         vis => xform_toggle.set;
      };
      DVcell_data_labels DVcell_data_labels {
         in => <-.in_fld;
      };
      DVM.DVswitch DVswitch {
         in => {
            <-.DVnode_data_labels.labels,<-.DVcell_data_labels.labels};
         index => <-.UIradioBoxLabel#1.selectedItem;
      };
   };
   macro obj<locked=0> {
      group &in<NEportLevels={2,1},NEnumColors=4,NEcolor0=255> {
         GDxform_templ &xform;
      } => Probe.out_fld;
      imlink child_objs;
      DefaultProps Props<export_all=1>;
      DefaultModes Modes<export_all=1>;
      DefaultPickInfo PickInfo<export_all=1>;
      AltObject AltObject<instanced=0,export_all=1> {
         alt_in => in;
      };
      DefaultObject Obj<NEportLevels={0,1},export_all=2> {
         input => <-.DVextract_mesh.out;
         xform => in.xform;
         props => Props;
         modes => Modes;
         objects => child_objs;
         altobj => AltObject.obj;
         type = "Dynamic";
         name = "probe";
         pick_info => PickInfo;
      };
      GMOD.instancer instancer {
         Value => Obj.use_altobj;
         Group => AltObject;
      };
      olink obj => Obj;
      DVextract_mesh DVextract_mesh {
         in => <-.in;
      };
   };
   DataObjectNoTexture obj_anno {
      in => <-.TextTitle.probe_anno;
      Obj {
         xform_mode = "Parent";
         name => "probe anno";
      };
   };
   olink out_fld<export_all=2> => Probe.out_probe;
   olink out_obj => obj.obj;
   olink out_anno => obj_anno.obj;
   macro TextTitle {
      DefaultProps DefaultProps {
         font<NEportLevels={2,0}> => <-.TextUI.Font.text;
         inherit = 0;
      };
      GDpick_info DefaultPickInfo;
      GMOD.instancer instancer {
         Value => <-.UIpanel.visible;
         Group => <-.TextUI;
         active = 2;
      };
      macro TextUI {
         int active_array[];
         link UIpanel<NEportLevels={2,1}> => <-.UIpanel;
         UIlabel UIlabel#1 {
            y => <-.Font.y;
            width = 45;
            parent => <-.UIpanel;
            label => "Font";
            alignment = "left";
         };
         UItext Font {
            x = <-.UIlabel#1.width;
            y => <-.<-.<-.ProbeUI.xform_toggle.y + <-.<-.<-.ProbeUI.xform_toggle.height + 20;
            width => <-.UIpanel.width - .x;
            active => <-.active_array[<-.StrokeText.set];
            parent => <-.UIpanel;
            text<NEportLevels={0,3}> = "-adobe-times-bold-r-*-*-20-*-*-*-*-*-*-*";
         };
         UIframe UIframe {
            y => <-.Font.y + <-.Font.height + 4;
            width  => <-.UIpanel.width;
            height => <-.OffsetZValue.y + <-.OffsetZValue.height + 2;
            parent => <-.UIpanel;
         };
         UIoption UIoption {
            label => "Left";
         };
         UIoption UIoption#1 {
            label => "Center";
            set = 1;
         };
         UIoption UIoption#2 {
            label => "Right";
         };
         UIoptionMenu AlignHorizMenu {
            x = 4;
            y = 2;
            width => <-.UIframe.clientWidth - 8;
            parent => <-.UIframe;
            label => "Align Horizontal";
            cmdList => {<-.UIoption,<-.UIoption#1,<-.UIoption#2};
            selectedItem<NEportLevels={0,3}> = 1;
            alignment = "left";
         };
         UIoption UIoption#3 {
            label => "Base";
            set = 1;
         };
         UIoption UIoption#4 {
            label => "Bottom";
         };
         UIoption UIoption#5 {
            label => "Center";
         };
         UIoption UIoption#6 {
            label => "Top";
         };
         UIoptionMenu AlignVertMenu {
            x = 4;
            y => <-.AlignHorizMenu.y + <-.AlignHorizMenu.height + 4;
            width  => <-.UIframe.clientWidth - 8;
            parent => <-.UIframe;
            label  => "Align Vertical";
            cmdList => {<-.UIoption#3,
               <-.UIoption#4,<-.UIoption#5,<-.UIoption#6};
            selectedItem<NEportLevels={0,3}> = 0;
            alignment = "left";
         };
         UItoggle DropShadow {
            x = 4;
            y => <-.AlignVertMenu.y + <-.AlignVertMenu.height + 5;
            width  => <-.UIframe.clientWidth - 8;
            active => <-.active_array[<-.StrokeText.set];
            parent => <-.UIframe;
            label  => "Drop Shadow";
            alignment = "left";
            set<NEportLevels={0,3}>;
         };
         UItoggle Bounds {
            x = 4;
            y => <-.DropShadow.y + <-.DropShadow.height + 5;
            width  => <-.UIframe.clientWidth - 8;
            active => <-.active_array[<-.StrokeText.set];
            parent => <-.UIframe;
            label  => "Bounds";
            set<NEportLevels={0,3}>;
         };
         UItoggle Underline {
            x = 4;
            y => <-.Bounds.y + <-.Bounds.height + 5;
            width  => <-.UIframe.clientWidth - 8;
            active => <-.active_array[<-.StrokeText.set];
            parent => <-.UIframe;
            label  => "Underline";
            set<NEportLevels={0,3}>;
         };
         UItoggle Background {
            x = 4;
            y => <-.Underline.y + <-.Underline.height + 5;
            width  => <-.UIframe.clientWidth - 8;
            active => <-.active_array[<-.StrokeText.set];
            parent => <-.UIframe;
            label  => "Background";
            set<NEportLevels={0,3}>;
         };
         UItoggle Leadline {
            x = 4;
            y => <-.Background.y + <-.Background.height + 5;
            width  => <-.UIframe.clientWidth - 8;
            active => <-.active_array[<-.StrokeText.set];
            parent => <-.UIframe;
            label  => "Leadline";
            set<NEportLevels={0,3}>;
         };
         UItoggle Radial {
            x = 4;
            y => <-.Leadline.y + <-.Leadline.height + 5;
            width  => <-.UIframe.clientWidth - 8;
            active => <-.active_array[<-.StrokeText.set];
            parent => <-.UIframe;
            label  => "Radial";
            set<NEportLevels={0,3}>;
         };
         UItoggle Offset {
            x = 4;
            y => <-.Radial.y + <-.Radial.height + 5;
            width  => <-.UIframe.clientWidth - 8;
            active => <-.active_array[<-.StrokeText.set];
            parent => <-.UIframe;
            label  => "Offset";
            set<NEportLevels={0,3}>;
         };
         UIfieldTypein OffsetXValue {
            UIparent => <-.UIframe;
            flabel => "X Offset";
            fval => 0.05;
            fmin => -5;
            fmax => 5;
            label {
               active => <-.<-.active_array[<-.<-.StrokeText.set];
               alignment = "center";
            };
            field {
               active => <-.<-.active_array[<-.<-.StrokeText.set];
            };
            x = 0;
            y => <-.Offset.y + <-.Offset.height + 4;
            width = 180;
            height => field.height + 6;
         };
         UIfieldTypein OffsetYValue {
            UIparent => <-.UIframe;
            flabel => "Y Offset";
            fval => 0.05;
            fmin => -5;
            fmax => 5;
            label {
               active => <-.<-.active_array[<-.<-.StrokeText.set];
               alignment = "center";
            };
            field {
               active => <-.<-.active_array[<-.<-.StrokeText.set];
            };
            x = 0;
            y => <-.OffsetXValue.y + <-.OffsetXValue.height + 1;
            width = 180;
            height => field.height + 6;
         };
         UIfieldTypein OffsetZValue {
            UIparent => <-.UIframe;
            flabel => "Z Offset";
            fval => 0.;
            fmin => -5;
            fmax => 5;
            label {
               active => <-.<-.active_array[<-.<-.StrokeText.set];
               alignment = "center";
            };
            field {
               active => <-.<-.active_array[<-.<-.StrokeText.set];
            };
            x = 0;
            y => <-.OffsetYValue.y + <-.OffsetYValue.height + 1;
            width = 180;
            height => field.height + 6;
         };
         UItoggle StrokeText {
            y => <-.UIframe.y + <-.UIframe.height + 5;
            width => UImod_panel.clientWidth - 50;
            label => "StrokeText";
            set => ;
            parent => <-.UIpanel;
         };
         UIframe StrokeFrame {
            y => <-.StrokeText.y + <-.StrokeText.height + 10;
            width  => <-.UIpanel.width;
            height => <-.StrokeExpansion.y + <-.StrokeExpansion.height + 6;
            visible => <-.StrokeText.set;
            parent<NEdisplayMode="open"> => <-.UIpanel;
         };
         UIoptionMenu StrokeFontType {
            x = 4;
            y = 0;
            width => <-.StrokeFrame.clientWidth - 8;
            parent => <-.StrokeFrame;
            label => "Font Type";
            cmdList => {
               <-.Font1,<-.Font2,<-.Font3,<-.Font4,<-.Font5,<-.Font6,
               <-.Font7,<-.Font8,<-.Font9,<-.Font10
            };
            selectedItem<NEportLevels={0,3}> = 0;
            alignment = "left";
         };
         UIoption Font1 {
            label => "Roman Simplex";
            set = 1;
         };
         UIoption Font2 {
            label => "Roman Duplex";
         };
         UIoption Font3 {
            label => "Roman Triplex";
         };
         UIoption Font4 {
            label => "Roman Complex";
         };
         UIoption Font5 {
            label => "Script Simplex";
         };
         UIoption Font6 {
            label => "Script Complex";
         };
         UIoption Font7 {
            label => "Italics Triplex";
         };
         UIoption Font8 {
            label => "Italics Duplex";
         };
         UIoption Font9 {
            label => "Greek Simplex";
         };
         UIoption Font10 {
            label => "Greek Complex";
         };
         UIoptionMenu StrokePlane {
            x = 4;
            y => <-.StrokeFontType.y + <-.StrokeFontType.height + 5;
            width  => <-.StrokeFrame.clientWidth - 8;
            parent => <-.StrokeFrame;
            label  => "Plane";
            cmdList => {<-.XYplane, <-.XZplane, <-.YZplane};
            selectedItem<NEportLevels={0,3}> = 0;
            alignment = "left";
         };
         UIoption XYplane {
            label => "XY";
            set = 1;
         };
         UIoption XZplane {
            label => "XZ";
         };
         UIoption YZplane {
            label => "YZ";
         };
         UIoptionMenu StrokeOrient {
            x = 4;
            y => <-.StrokePlane.y + <-.StrokePlane.height + 5;
            width  => <-.StrokeFrame.clientWidth - 8;
            parent => <-.StrokeFrame;
            label  => "Orientation";
            cmdList => {
               <-.LRorient,<-.UPorient,<-.RLorient,<-.DOWNorient,
               <-.ARBorient
            };
            selectedItem = 0;
            alignment = "left";
         };
         UIoption LRorient {
            label => "Left-to-Right";
            set = 1;
         };
         UIoption UPorient {
            label => "Up";
         };
         UIoption RLorient {
            label => "Right-to-Left";
         };
         UIoption DOWNorient {
            label => "Down";
         };
         UIoption ARBorient {
            label => "Arbitrary";
         };
         UIslider StrokeAngle {
            x = 4;
            y => <-.StrokeOrient.y + <-.StrokeOrient.height + 5;
            active => switch(((<-.StrokeOrient.selectedItem == 4) + 1),0,1);
            parent => <-.StrokeFrame;
            min = -180.;
            max = 180.;
            value = 0.;
            title => "Angle";
         };
         UIoptionMenu StrokePath {
            x = 4;
            y => <-.StrokeAngle.y + <-.StrokeAngle.height + 5;
            width  => <-.StrokeFrame.clientWidth - 8;
            parent => <-.StrokeFrame;
            label  => "Path";
            cmdList => {<-.LRpath,<-.UPpath,<-.RLpath,<-.DOWNpath};
            selectedItem<NEportLevels={0,3}> = 0;
            alignment = "left";
         };
         UIoption LRpath {
            label => "Left-to-Right";
            set = 1;
         };
         UIoption UPpath {
            label => "Up";
         };
         UIoption RLpath {
            label => "Right-to-Left";
         };
         UIoption DOWNpath {
            label => "Down";
         };
         UIoptionMenu StrokeSpaceMode {
            x = 4;
            y => <-.StrokePath.y + <-.StrokePath.height + 5;
            width  => <-.StrokeFrame.clientWidth - 8;
            parent => <-.StrokeFrame;
            label  => "Spacing Mode";
            cmdList => {<-.FixedSpace, <-.PropSpace};
            selectedItem<NEportLevels={0,3}> = 1;
            alignment = "left";
         };
         UIoption FixedSpace {
            label => "Fixed";
         };
         UIoption PropSpace {
            label => "Proportional";
            set = 1;
         };
         UIslider StrokeSpacing {
            x = 4;
            y => <-.StrokeSpaceMode.y + <-.StrokeSpaceMode.height + 5;
            parent => <-.StrokeFrame;
            min = 0.;
            max = 3.;
            value = 0.;
            title => "Spacing";
         };
         UIslider StrokeHeight {
            x = 4;
            y => <-.StrokeSpacing.y + <-.StrokeSpacing.height + 5;
            parent => <-.StrokeFrame;
            min = 0.01;
            max = 10.;
            value = 1.;
            title => "Height";
         };
         UIslider StrokeExpansion {
            x = 4;
            y => <-.StrokeHeight.y + <-.StrokeHeight.height + 5;
            parent => <-.StrokeFrame;
            min = 0.25;
            max = 3.;
            value = 1.;
            title => "Expansion";
         };
      };
      DefaultObject obj_title<NEportLevels={0,2}> {
         input => <-.text;
         props => <-.DefaultProps;
         xform_mode = "Locked";
         name = "probe_title";
         pick_info => <-.DefaultPickInfo;
      };
      link UIpanel<NEportLevels={2,1}> => <-.UIpanel;
      link data_value<NEportLevels={2,1}> => <-.Probe.out_data;
      Grid+Xform probe_anno {
         nnodes = 1;
         nspace = 3;
         coordinates {
            &values+nres => <-.<-.<-.Probe.out_probe.coordinates.values;
         };
         &xform => <-.<-.Probe.out_probe.xform;
         int align_horiz<NEportLevels={2,0}> => <-.TextUI.AlignHorizMenu.selectedItem;
         int align_vert<NEportLevels={2,0}> => <-.TextUI.AlignVertMenu.selectedItem;
         int drop_shadow<NEportLevels={2,0}> => <-.TextUI.DropShadow.set;
         int background<NEportLevels={2,0}> => <-.TextUI.Background.set;
         int bounds<NEportLevels={2,0}> => <-.TextUI.Bounds.set;
         int underline<NEportLevels={2,0}> => <-.TextUI.Underline.set;
         int lead_line<NEportLevels={2,0}> => <-.TextUI.Leadline.set;
         int radial<NEportLevels={2,0}> => <-.TextUI.Radial.set;
         int do_offset<NEportLevels={2,0}> => <-.TextUI.Offset.set;
         float offset[] => {
            <-.TextUI.OffsetXValue.fval,<-.TextUI.OffsetYValue.fval,
            <-.TextUI.OffsetZValue.fval};
         int xform_mode;
         int color;
         string text_values[] => ((((((" (" + <-.<-.Probe.out_probe.coordinates.values[0]) + ", ") + <-.<-.Probe.out_probe.coordinates.values[1]) + ", ") + <-.<-.Probe.out_probe.coordinates.values[2]) + ")");
         int stroke = 0;
         group StrokeTextAttribs {
            int font_type;
            int style;
            int plane;
            int orient;
            int path;
            int space_mode;
            float spacing;
            float angle;
            float height;
            float expansion;
            float width;
         };
      };
      Grid+Xform text<NEportLevels={0,1},NEwidth=319.,NEheight=275.> {
         nnodes = 1;
         nspace = 3;
         coordinates {
            &values+nres => {0,0.7,0};
         };
         &xform;
         int align_horiz<NEportLevels={2,0}> => <-.TextUI.AlignHorizMenu.selectedItem;
         int align_vert<NEportLevels={2,0}> => <-.TextUI.AlignVertMenu.selectedItem;
         int drop_shadow<NEportLevels={2,0}> => <-.TextUI.DropShadow.set;
         int background<NEportLevels={2,0}> => <-.TextUI.Background.set;
         int bounds<NEportLevels={2,0}> => <-.TextUI.Bounds.set;
         int underline<NEportLevels={2,0}> => <-.TextUI.Underline.set;
         int lead_line<NEportLevels={2,0}> => <-.TextUI.Leadline.set;
         int radial<NEportLevels={2,0}> => <-.TextUI.Radial.set;
         int do_offset<NEportLevels={2,0}> => <-.TextUI.Offset.set;
         float offset[] => {
            <-.TextUI.OffsetXValue.fval,<-.TextUI.OffsetYValue.fval,
            <-.TextUI.OffsetZValue.fval};
         int xform_mode;
         int color;
         string text_values[] => ((" " + <-.data_value[0]) + " ");
         int stroke = 0;
         group StrokeTextAttribs {
            int font_type;
            int style;
            int plane;
            int orient;
            int path;
            int space_mode;
            float spacing;
            float angle;
            float height;
            float expansion;
            float width;
         };
      };
   };
   link out_title<NEportLevels={1,2}> => .TextTitle.obj_title;
   macro Probe_Glyphs {
      macro Cross {
         Line set1 {
            ncells = 3;
            node_connect_list = {0,1,2,3,4,5};
         };
         Mesh cross {
            int nnodes = 6;
            int nspace = 3;
            coordinates {
               float values[.nvals][.veclen] = {
                  -0.5,0.,0.,0.5,0.,0.,0.,-0.5,0.,0.,0.5,0.,0.,0.,-0.5,0.,
0.,0.5
               };
            };
            int ncell_sets = 1;
            cell_set => {<-.set1};
         };
         olink out_fld<NEportLevels={1,2}> => .cross;
      };
      macro Sphere {
         int subdiv<export=2> => <-.<-.sphere_subdiv;
         macro sphere_ui {
            ilink isubdiv => subdiv;
            UIslider SubDiv {
               y => <-.<-.<-.UIradioBoxLabel.y + <-.<-.<-.UIradioBoxLabel.height + 8;
               parent<NEportLevels={4,0}> => <-.<-.<-.panel;
               min = 5.;
               max = 50.;
               value => isubdiv;
               mode = "integer";
               title => "Sphere Subdivision";
            };
         };
         Field_Spher_Unif sphere {
            nspace = 3;
            ndim = 3;
            dims => {2,subdiv,subdiv};
            points = {0.,0.,0.,0.5,
3.14159,6.28318};
         };
         DVbounds bounds {
            in => <-.sphere;
            hull = 0;
            edges = 0;
            faces = 1;
            imin = 0;
            imax = 1;
            jmin = 0;
            jmax = 0;
            kmin = 0;
            kmax = 0;
            data = 0;
            component = 0;
            out<NEportLevels={0,3}>;
            method+notify_val+notify_inst upd_bounds = "DVbounds_update";
         };
      };
      DVM.DVswitch DVswitch {
         in => {<-.Cross.out_fld, <-.Sphere.bounds.out};
         index => <-.UIradioBoxLabel.selectedItem;
         out<NEportLevels={1,3}>;
      };
      UIradioBoxLabel UIradioBoxLabel {
         parent => <-.panel;
         labels => <-.string;
         selectedItem => <-.<-.Probe_Type;
         title => "Probe Type";
         y => <-.<-.ProbeUI.UIradioBoxLabel.y + <-.<-.ProbeUI.UIradioBoxLabel.height + 6;
         UIlabel.alignment = "left";
         UIradioBox.x = 8;
      }; // Probe_Glyphs
      string string<NEportLevels=1>[] = {"Cross","Sphere"};
      link panel<NEportLevels={2,1}> => <-.UIpanel;
   };
};

};
