//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/v/vizxp/resource.v#1 $
//
///////////////////////////////////////////////////////////////////////////////
//
// DataViewer 
//
//   Viewer Resources - Provides portability across Windows and Motif
//     and a certian level of user customization
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////

group ViewerResourcesTemplate<NEvisible=0> {
   int Renderer;

   group Events {
      string Start[4];
      string Run[4];
      string Stop[4];
      string PickRun;
   };

   int+nres ModuleStackWidth
     => UIdata.UIdisplays[0].width / 4;

   int+nres ModuleStackHeight
     => UIdata.UIdisplays[0].height / 2;

   int+nres FontHeight
     => (UIdata.UIfonts[0].lineHeight + 0);

   group Selected {
      int Height;
      int ButtonHeight;
      string LabelColor;
      string NameColor;
      string ModeColor;
   };

   group Status {
      string StopColor;
      string GoColor;
   };

   group Icon {
      int Width 			= 28;
      int RawWidth	     		= 22;
      int Height 			= 27;
      int RawHeight     		= 21;
   };

   group View {
      int Border;
      int Width;    // inclusive of border
      int Height;   // inclusive of border
   };

   group Editor {
      int LabelFrameHeight;
      group Toolbar {
	 int Height 			= 27;
      };
      int Height;
      int Width				=> ModuleStackWidth;
      group Selector {
         int+nres Width 		=> <-.Width;
         int+nres Height		=> (<-.Height / 4);
      };
      group Tab {
         int+nres Width 		=> <-.Width;
         int+nres Height		=> <-.Height - <-.Selector.Height;
      };
      group Shell {
         int WidthPad;
         int HeightPad;
      };
   };

   group VUI {
      string BackgroundColor;
      group VUIText {
         int LabelY;
         int TextY;
         int TextHeight;
         int HeightAdjust;
         string TextColor;
      };
      group VUIField {
         int FieldHeight;
         string TextColor;
         string FieldColor;
      };
      group VUISlider {
         int SliderHeight;
         string FieldColor;
      };
      group VUILabel {
         string TextColor;
      };
      group VUIToggle {
         string TextColor;
      };
      group VUIHelpBox {
         string TextColor;
         string BackgroundColor;
      };
      group VUIDial {
         int DefaultHeight;
         int FieldHeight;
      };
      group VUIColorEditor {
         int Height;
      };
   };
};

///////////////////////////////////////////////////////////////////////////////

#ifdef MSDOS
ViewerResourcesTemplate ViewerResources {

   Renderer = 1;

   Events {
      Start = {
           "<BtnLDown>",           // rotate
           "Shift<BtnLDown>",      // scale
           "<BtnRDown>",           // translate xy
           "Shift<BtnRDown>"       // translate z
      };
      Run = {
           "<BtnLMotion>",
           "Shift<BtnLMotion>",
           "<BtnRMotion>",
           "Shift<BtnRMotion>"
      };
      Stop = {
           "<BtnLUp>",
           "Shift<BtnLUp>",
           "<BtnRUp>",
           "Shift<BtnRUp>"
      };
      PickRun = "Control<BtnLDown>";
   };

   Selected {
      ButtonHeight      = 18;
      Height 		= 22;
//      LabelColor 	= "light red";
//      NameColor		= "light blue";
//      ModeColor		= "light yellow";
   };

   Status {
//      StopColor         = "light red";
//      GoColor           = "light green";
   };

   View {
      int Border        = 0;
      int Width         = 500;
      int Height        = 500;
   };

   Editor {
      LabelFrameHeight  = 21;
      Height 		= 285;
      Shell {
         WidthPad       = 10;
         HeightPad      = 67;
      };
   };

   VUI {
      VUIText {
         TextY 		= 4;
         LabelY 	= 8;
         TextHeight 	= 38;
         HeightAdjust   = 12;
//         TextColor 	= "black";
      };
      VUIField {
         FieldHeight 	= 38;
//         TextColor 	= "black";
//         FieldColor 	= "light blue";
      };
      VUISlider {
         SliderHeight 	= 34;
//         FieldColor 	= "light blue";
      };
      VUILabel {
//         TextColor 	= "light red";
      };
      VUIToggle {
//         TextColor 	= "black";
      };
      VUIHelpBox {
//         TextColor      = "blue";
//         BackgroundColor= "white";
      };
      VUIDial {
         DefaultHeight 	= 110;
         FieldHeight 	= 26;
      };
      VUIColorEditor {
         Height 	= 200;
      };
   };
};
#else	// End MSDOS, Start Unix
ViewerResourcesTemplate ViewerResources {

   Renderer = 0;

   Events {
      Start = {
           "<Btn2Down>",           // rotate
           "Shift<Btn2Down>",      // scale
           "<Btn3Down>",           // translate xy
           "Shift<Btn3Down>"       // translate z
      };
      Run = {
           "<Btn2Motion>",
           "Shift<Btn2Motion>",
           "<Btn3Motion>",
           "Shift<Btn3Motion>"
      };
      Stop = {
           "<Btn2Up>",
           "Shift<Btn2Up>",
           "<Btn3Up>",
           "Shift<Btn3Up>"
      };
      PickRun = "<Btn1Down>";
   };

   View {
      int Border        = 4;
      int Width         = 500;
      int Height        = 500;
   };

   Editor {
      LabelFrameHeight  = 27;
      Height 		= 350;
      Shell {
         WidthPad       = 0;
         HeightPad      = 50;
      };
   };

   Selected {
      ButtonHeight      = 24;
      Height 		= 34;
//      LabelColor 	= "red3";
//      NameColor		= "blue3";
//      ModeColor		= "yellow";
   };

   Status {
//      StopColor         = "red3";
//      GoColor           = "green3";
   };

   VUI {
      VUIText {
         TextY 		= 2;
         LabelY 	= 4;
         HeightAdjust   = 16;
         TextHeight 	= 46;
//         TextColor 	= "black";
      };
      VUIField {
         FieldHeight 	= 34;
//         TextColor 	= "black";
//         FieldColor 	= "blue3";
      };
      VUISlider {
         SliderHeight 	= 59;
//         FieldColor 	= "blue3";
      };
      VUILabel {
//         TextColor 	= "red3";
      };
      VUIToggle {
//         TextColor 	= "black";
      };
      VUIHelpBox {
//         TextColor      = "blue";
//         BackgroundColor= "white";
      };
      VUIDial {
         DefaultHeight 	= 160;
         FieldHeight 	= 32;
      };
      VUIColorEditor {
         Height 	= 170;
      };
   };
};
#endif
