//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/v/vizxp/vui.v#1 $
//
///////////////////////////////////////////////////////////////////////////////
//
// DataViewer 
//
//   VUI - Viewer User Interface Objects:
//      auto_gui_objects:
//		VUIShell	- the main VUI shell object
//		VUIPanel	- autoparents to VUIShell
//		VUIFrame	- autoparents to VUIShell
//		VUIPulldown	- autoparents to VUIFrame
//		VUIOption 	- autoparents to VUIPulldown
//
// Editor layout:
//
//	VUITabBox
//	VUITabPage
//
// V buffer widgets:
// 
//      VUIToolButton
//      VUIToolToggle
//
// Framed widgets:
//
//	VUIText         => Frame + Label + Text
//	VUIList         => Frame + Label + List 
//	VUIToggle       => Frame + Toggle 
//
// Framed Composite widgets:
//
//	VUIField        => Label + Field 
//	VUIDial         => Dial + Field + IncButton + DecButton
//	VUISlider       => Slider + Field
//	VUISlider2      => Label + Slider-Field + Slider-Field
//	VUIRadioBox     => Label + RadioBox
//	VUIRadioBoxPix  => Label + RadioBox + Pixmaps
//	VUIColorEditor  => ColorEcho + Morphing ( VUIDials, Sliders )
//
// Viewer panels:
//
//      VUIColorPanel
//      VUIDmapPanel
//      VUIThumbnail
//
///////////////////////////////////////////////////////////////////////////////

flibrary+global VUI <compile_subs=0,needs_edit_lic="GD"> {

$include vizxp/resource.v

/* These objects are not used by the current data viewer */
#ifdef NOTDEF
UImod_register VUIShell<NEdisplayMode="maximized",locked=0> {
   macro parent_ui<ui_global_class=1> {
      UIshell parent {
         menu => MainMenu;
      };
      UIcmdList MainMenu<list_class="MenubarEntree"> {
         cmdList<NEportLevels={3,0}>;
      };
      UIpanel panel<NEportLevels={0,2},widget_class="MainMenu"> {
        x = 0;
        y = 0;
	width => <-.parent.width;
	height => <-.parent.height;
        parent => <-.parent;
      };
   };
};

UIdefault_shell_init+UIpanel VUIPanel {
   x = 0;
   y = 0;
   parent_class = "MainMenu";
};

UIdefault_shell_init+UIframe VUIFrame {
   x = 0;
   y = 0;
   parent_class = "MainMenu";
};

macro VUIPulldown {
   UIlist_init+UIcmdList Pulldown<NEportLevels={0,2},list_class="PulldownEntree"> {
      cmd_list_class = "MenubarEntree";
   };
};

macro VUICascade {
   UIlist_init+UIcmdList Pulldown<NEportLevels={0,2},list_class="MenubarEntree"> {
      cmd_list_class = "MenubarEntree";
   };
};

UIlist_init+UIoption VUIOption {
   cmd_list_class = "PulldownEntree";
   label = "foo";
   message = "foo";
};

///////////////////////////////////////////////////////////////////////////////

macro VUITabBox {
   link+nres  parent  <NEportLevels={2,1}>;
   mlink+nres cmdList <NEportLevels={2,1}>;
   string     pixmap;
   string     title;
   int        selectedItem = 0;   // default to first page
   int        selector     = 1;   // show selector ?
   int        style        = 1;   // 0 - option menu / combo box (default)
                                  // 1 - radio box 

   UIpanel TabBoxPanel {
      parent => <-.parent;
      y      =  0;
      width  => Editors.UIpanel.clientWidth;
      height => Editors.UIpanel.clientHeight;
   };

   // Title
   UIframe LabelFrame {
      parent => <-.TabBoxPanel;
      y      =  0;
      width  => <-.TabBoxPanel.clientWidth;
      height = ViewerResources.Editor.LabelFrameHeight + 6;
   };
   UIbutton MorphL {
      parent => <-.LabelFrame;
      x      =  0;
      y      =  0;
      width  = ViewerResources.Icon.Width;
      height = ViewerResources.Icon.Height;
      label  =  "";
      labelPixmap.filename => <-.<-.pixmap;
      labelPixmap.fileType = "avs_image";
      message = "Morph panel selector interface style.";
   };
   UIlabel Label {
      parent => <-.LabelFrame;
      x      = ViewerResources.Icon.Width;
      y      = 0;
      width  => <-.MorphR.x - <-.MorphL.x - <-.MorphL.width;
      height = ViewerResources.Icon.Height;
      label  => <-.title;
      alignment = 1;
   };
   UIbutton MorphR {
      parent => <-.LabelFrame;
      x      => <-.TabBoxPanel.clientWidth - ViewerResources.Icon.Width - 6;
      y      = 0;
      width  = ViewerResources.Icon.Width;
      height = ViewerResources.Icon.Height;
      label  = "";
      labelPixmap.filename => <-.<-.pixmap;
      labelPixmap.fileType = "avs_image";
      message = "Morph panel selector interface style.";
   };
   GMOD.parse_v_relative_no_inst ParseMorph {
      v_commands = "style = 1 - style;";
      trigger    => <-.MorphR.do + <-.MorphL.do;
      relative   => ParseMorph;
   };

   // Selector

   GMOD.instancer OptionSelectorInst {
      Value => and( <-.selector, (1 - <-.style) );
      Group => <-.OptionSelector;
   };
   group OptionSelector<instanced=0> {
      UIframe OptionFrame {
         parent       => <-.<-.TabBoxPanel;
         x            =  0;
         y            => <-.<-.LabelFrame.y + <-.<-.LabelFrame.height;
         width        => <-.<-.TabBoxPanel.clientWidth;
         height+nres  => 1.5 * UIdata.UIfonts[0].lineHeight;
      };
      // need combo box for MSDOS
      UIoptionMenu Selector {
         parent       => <-.OptionFrame;
         x            => 1.25 * ViewerResources.Icon.Width; // guess
         y            =  0;
         cmdList      => <-.<-.cmdList;
         selectedItem => <-.<-.selectedItem;
         label        = "";
         optionLabel  = 0;
      };
   };

   GMOD.instancer RadioSelectorInst {
      Value => and( <-.selector, <-.style );
      Group => <-.RadioSelector;
   };

   group RadioSelector<instanced=0> {
     UIframe RadioFrame {
        y      => (<-.<-.LabelFrame.y + <-.<-.LabelFrame.height);
        width  => <-.<-.TabBoxPanel.clientWidth;
        height => (TabBoxPanel.clientHeight / 4);
        parent => <-.<-.TabBoxPanel;
     };
     UIscrolledWindow RadioScroller {
        x      = 0;
        y      = 0;
        width  => <-.RadioFrame.clientWidth;
        height => <-.RadioFrame.clientHeight;
        parent => <-.RadioFrame;
        virtualHeight+nres => ((RadioBox.dims + 1) * 
                               (UIdata.UIfonts[0].lineHeight));
        virtualWidth => width;
        scrollBars = 2;
     };
     UIradioBox RadioBox {
        parent       => <-.RadioScroller;
        x            =  4;
        y            =  0;
        width        => <-.RadioScroller.clientWidth - 8;
        height       =  300;
        cmdList      => <-.<-.cmdList;
        selectedItem => <-.<-.selectedItem;
     };
   };

   // use selector visibility and style to choose between these positions
   int+nres Yselector[2] => {
       (1.5*UIdata.UIfonts[0].lineHeight),     // option style
       TabBoxPanel.clientHeight/4              // radio style
   };
   int Ytabframe => (LabelFrame.y+LabelFrame.clientHeight+4) + 
                    (selector*Yselector[style]);

   // Panel
   UIframe TabFrame{
      x      = 0;
      y      => <-.Ytabframe;
      width  => <-.TabBoxPanel.clientWidth;
      height => <-.TabBoxPanel.clientHeight - <-.Ytabframe;
      parent => <-.TabBoxPanel;
   };
   UIscrolledWindow TabScroller {
      x      = 0;
      y      = 0;
      width  => <-.TabFrame.clientWidth;
      height => TabFrame.clientHeight;
      parent => <-.TabFrame;
      virtualHeight = 900;
      virtualWidth  => width;
      scrollBars = 2;
   };
   UIpanel TabPanel<NEportLevels={0,2}> {
      y      = 0;
      width  => <-.TabScroller.clientWidth;
      height => <-.TabScroller.virtualHeight;
      parent => <-.TabScroller;
   };
};

///////////////////////////////////////////////////////////////////////////////

UIpanel VUITabPage {
   parent+nres<NEportLevels={3,0}> => <-.<-.TabBox.TabPanel;
   x      = 0;
   y      = 0;
   width  => <-.<-.TabBox.TabPanel.width;
   height =  900;
};

///////////////////////////////////////////////////////////////////////////////

macro VUIToolButton {
   link   parent<NEportLevels={2,1}>;
   int    x       =  0;
   int    width   = ViewerResources.Icon.Width;
   int    height  = ViewerResources.Icon.Height;
   string label = "";
   string pixmap;
   string message;
   int    active = 1;
   group  *relative;
   string v_commands;

   UIbutton ToolButton {
      parent  => <-.parent;
      x       => <-.x;
      y       =  0;
      width   => <-.width;
      height  => <-.height;
      label   => <-.label;
      message => <-.message;
      active  => <-.active;
      labelPixmap {
         filename => <-.<-.pixmap;
         fileType =  "avs_image";
      };
   };

   GMOD.parse_v_relative_no_inst ParseButton {
      trigger    => <-.ToolButton.do;
      relative   => <-.relative;
      v_commands => <-.v_commands;
   };
};

///////////////////////////////////////////////////////////////////////////////

macro VUIToolToggle {
   link   parent<NEportLevels={2,1}>;
   int    x       =  0;
   int    active  =  1;
   int    set     =  0;
   string label   = "";
   string pixmaps[2];
   string messages[2];
   group  *here;
   string v_commands = "";

   // output
   int    width   = ViewerResources.Icon.Width;
   int    height  = ViewerResources.Icon.Height;

   VUIToolButton Button {
      parent     => <-.parent;
      x          => <-.x;
      label      => <-.label;
      message    => <-.messages[<-.set];
      active     => <-.active;
      pixmap     => <-.pixmaps[<-.set];
      relative   => <-.here;
      v_commands => "$push \n" + <-.v_commands + "$pop \n" + "set = 1 - set;";
   };
};

#endif	// NOTDEF

///////////////////////////////////////////////////////////////////////////////

UIlabel VUILabel {
   x = 0;
   y = 0;
   color {
//      foregroundColor = ViewerResources.VUI.VUILabel.TextColor;
//      backgroundColor = ViewerResources.VUI.BackgroundColor;
   };
   alignment = 0;
};

///////////////////////////////////////////////////////////////////////////////

macro VUIText {
   link   parent<NEportLevels={2,1}>;
   int    x      = 0;
   int    y      = 0;
   int    width  = 200;
   int    height = ViewerResources.VUI.VUIText.TextHeight;
   string label;
   string text;
   int    active = 1;

   UIframe TextFrame {
      parent => <-.parent;
      x      => <-.x;
      y      => <-.y;
      width  => <-.width;
      height => <-.height;
   };

   UIlabel TextLabel {
      parent    => <-.TextFrame;
      x         =  4;
      y         = ViewerResources.VUI.VUIText.LabelY;
      width     => <-.width / 3;
      height    => <-.height - 12;
      label     => <-.label;
      alignment = 0;
      color {
//         foregroundColor = ViewerResources.VUI.VUIText.TextColor;
//         backgroundColor = ViewerResources.VUI.BackgroundColor;
      };
      active => <-.active;
   };

   UItext Text {
      parent => <-.TextFrame;
      x      => <-.TextLabel.x + <-.TextLabel.width;
      y      = ViewerResources.VUI.VUIText.TextY;
      width  => <-.width - <-.TextLabel.width - 12;
      height => <-.height - 12;
      text<NEportLevels={2,2}> => <-.text;
      color {
//         foregroundColor = ViewerResources.VUI.VUIField.FieldColor;
      };
      active => <-.active;
   };

};

///////////////////////////////////////////////////////////////////////////////

macro VUIField {
   link parent<NEportLevels={2,1}>;
   int x<NEportLevels={1,1}> = 0;
   int y<NEportLevels={1,1}> = 0;
   int width<NEportLevels={1,1}> = 200;
   int height<NEportLevels={1,1}> = ViewerResources.VUI.VUIText.TextHeight;
   string label<NEportLevels={1,1}> = "VUIField";
   float value<NEportLevels={1,2}>;
   float min<NEportLevels={1,2}>;
   float max<NEportLevels={1,2}>;
   int active = 1;
   int visible = 1;
   int decimalPoints = 2;
   int mode = 2;

   UIlabel UIlabel {
      x      = 4;
      y      = ViewerResources.VUI.VUIText.LabelY;
      width  => <-.width / 2;
      height => (<-.height - 12);
      color {
//         foregroundColor = ViewerResources.VUI.VUIField.TextColor;
//         backgroundColor = ViewerResources.VUI.BackgroundColor;
      };
      parent    => <-.UIframe;
      label     => <-.label;
      alignment = 0;
      active    => <-.active;
   };

   UIfield UIfield {
      x      => <-.UIlabel.x + <-.UIlabel.width;
      y      = ViewerResources.VUI.VUIText.TextY;
      width  => <-.width - <-.UIlabel.width - 12;
      height => <-.height - 12;
      color {
//         foregroundColor = ViewerResources.VUI.VUIField.FieldColor;
      };
      parent => <-.UIframe;
      value<NEportLevels={2,2}> => <-.value;
      min    => <-.min;
      max    => <-.max;
      active => <-.active;
      decimalPoints => <-.decimalPoints;
      mode => <-.mode;
   };

   UIframe UIframe {
      parent => <-.parent;
      x      => <-.x;
      y      => <-.y;
      width  => <-.width;
      height => <-.height;
      visible => <-.visible;
   };
};

///////////////////////////////////////////////////////////////////////////////

macro VUIDial {
   link   parent<NEportLevels={2,0}>;
   int    x         = 0;
   int    y         = 0;
   int    width     = 80;
   int    height    = ViewerResources.VUI.VUIDial.DefaultHeight; // Not a ref...
   int    visible   = 1;
   int    immediate = 0;
   float  value;
   int    min;
   int    max;
   int    decimalPoints;
   string title;

   UIdial Dial {
      parent => <-.parent;
      x      => <-.x;
      y      => <-.y;
      width  => <-.width;
      height => <-.height - Templates.VUI.ViewerResources.VUI.VUIDial.FieldHeight - 4;
      value  => <-.value;
      min    => <-.min;
      max    => <-.max;
      title  => <-.title;
      decimalPoints => <-.decimalPoints;
      immediateMode => <-.immediate;
      float DialIncrement => (max-min) / 10.0;
   };
   UIfield Field {
      parent => <-.parent;
      x      => <-.Up.x + <-.Up.width;
      y      => <-.Dial.y + <-.Dial.height + 2;
      width  => <-.Dial.width - <-.Up.width;
      height = ViewerResources.VUI.VUIDial.FieldHeight;
      value<NEportLevels={2,2}> => <-.Dial.value;
      min    => <-.min;
      max    => <-.max;
      decimalPoints => <-.decimalPoints;
   };
   UIbutton Up {
      parent => <-.parent;
      x      => <-.x;
      y      => <-.Dial.y + <-.Dial.height + 2;
      width  =  16;
      height => <-.Field.height / 2;
      label  =  "+";
   };
   UIbutton Down {
      parent => <-.parent;
      x      => <-.x;
      y      => <-.Up.y + <-.Up.height;
      width  =  16;
      height => <-.Field.height / 2;
      label  =  "-";
   };
   GMOD.parse_v ParseUp {
      v_commands =  "value = value+Dial.DialIncrement;";
      trigger    => <-.Up.do;
      on_inst    =  0;
      relative   => <-.Dial;
   };
   GMOD.parse_v ParseDown {
      v_commands =  "value = value-Dial.DialIncrement;";
      trigger    => <-.Down.do;
      on_inst    =  0;
      relative   => <-.Dial;
   };
};

///////////////////////////////////////////////////////////////////////////////

macro VUISlider {
   link   parent<NEportLevels={2,1}>;
   int    x = 0;
   int    y = 0;
   int    width = 200;
   int    height => .SliderFrame.clientHeight;    // export this height
   float  value<NEportLevels={2,1}>;
   string title;
   int    immediate = 0;
   int    min = 0.0;
   int    max = 1.0;
   int    mode = 2;
   int    decimalPoints => default_dp[mode];
   int    active = 1;
   int    visible<NEportLevels={2,1}> = 1;

   // DPs for modes         unused integer float
   int    default_dp[3] = {   0,      0,     2   };

   UIframe SliderFrame {
      parent  => <-.parent;
      x       => <-.x;
      y       => <-.y;
      width   => <-.width;
      height  => Slider.height + 6;
      visible => <-.visible;
   };
   UIslider Slider {
      parent => <-.SliderFrame;
      x      = 2;
      y      = 0;
      width  => <-.SliderFrame.clientWidth - SliderField.width - 4;
      min    => <-.min;
      max    => <-.max;
      value  => <-.value;
      mode   => <-.mode;
      decimalPoints => <-.decimalPoints;
      immediateMode => <-.immediate;
      title  => <-.title;
      active => <-.active;
   };
   UIfield SliderField {
      parent => <-.SliderFrame;
      x      => Slider.x + Slider.width;
      y      => (<-.height - .height) / 2;
      width  =  50;
      height => max_array({24, Slider.height/2});
//      color.foregroundColor = ViewerResources.VUI.VUISlider.FieldColor;
      min    => <-.min;
      max    => <-.max;
      value         => <-.Slider.value;
      decimalPoints => <-.decimalPoints;
      active        => <-.active;
   };
};

///////////////////////////////////////////////////////////////////////////////
//
// The AG kit has parameters that mean one thing (size based on percentage)
// when positive, something else (size in millimeters) when negative.
// This macro supports that.

macro VUISliderSigned {
   link   parent<NEportLevels={2,1}>;
   int    x = 0;
   int    y = 0;
   int    width = 200;
   int    height => .SliderFrame.clientHeight;    // export this height
   float  value<NEportLevels={2,1}>;
   string title;
   int    immediate = 0;
   int    min = 0.0;
   int    max = 1.0;
   int    mode = 2;
   int    decimalPoints => default_dp[mode];
   int    active = 1;
   int    visible<NEportLevels={2,1}> = 1;
   string option1_str = "%";
   string option2_str = "mm";

   // DPs for modes         unused integer float
   int    default_dp[3] = {   0,      0,     2   };

   UIframe SliderFrame {
      parent  => <-.parent;
      x       => <-.x;
      y       => <-.y;
      width   => <-.width;
      height  => SliderRadioBox.y + SliderRadioBox.height + 6;
      visible => <-.visible;
   };
   UIslider Slider {
      parent => <-.SliderFrame;
      x      =  2;
      y      = 0;
      width  => <-.SliderFrame.clientWidth - SliderField.width - 4;
      min    => <-.min;
      max    => <-.max;
      mode   => <-.mode;
      decimalPoints => <-.decimalPoints;
      immediateMode => <-.immediate;
      title  => <-.title;
      active => <-.active;
   };
   UIfield SliderField {
      parent => <-.SliderFrame;
      x      => Slider.x + Slider.width;
      y      => Slider.y + Slider.height/2 - .height/2;
      width  =  50;
      height => max_array({24, Slider.height/2});
//      color.foregroundColor = ViewerResources.VUI.VUISlider.FieldColor;
      min    => <-.min;
      max    => <-.max;
      value         => <-.Slider.value;
      decimalPoints => <-.decimalPoints;
      active        => <-.active;
   };
   UIoption Option1 {
      label => <-.option1_str;
   };
   UIoption Option2 {
      label => <-.option2_str;
   };
   UIradioBox SliderRadioBox {
      parent => <-.SliderFrame;
      y => Slider.y + Slider.height;
      width = 200;
      // default height calculation is not valid for horizontal boxes.
      height => 2 + UIdata.UIfonts[0].lineHeight;
      cmdList => {<-.Option1, <-.Option2};
      orientation = "horizontal";
   };
   GMOD.GMODInternal.signed_value signed_value {
      sign_flag => <-.SliderRadioBox.selectedItem;
      abs_value => <-.Slider.value;
      signed_val => <-.value;
   };
};

///////////////////////////////////////////////////////////////////////////////

macro VUIslider_typein {
    link slider<NEportLevels={2,1}>;
    int visible<NEportLevels={2,1}> = 1;
    int active<NEportLevels={2,1}> = 1;

    string title = "";
    title+nres => slider.title;

    int x<NEportLevels={2,1}> = 0;
    int y<NEportLevels={2,1}> = 0;
    int width<NEportLevels={2,1}>  = 30;
    int height<NEportLevels={2,1}> = 30;
#ifdef MSDOS
    x+nres	=> slider.width + 4;
    width+nres	=> slider.parent.width - slider.width - 3;
    y+nres	=> slider.y + slider.height - height;
    height+nres	=> slider.height / 2;
#else
    x+nres	=> slider.width + 2;
    width+nres	=> slider.parent.width - slider.width - 2;
    y+nres	=> slider.y + slider.height / 3;
    height+nres	=> slider.height / 3;
#endif

    float value = 0.0;
    float min = 0;
    float max = 100;
    int decimalPoints = 2;
    value+nres	=> slider.value;
    min+nres	=> slider.min;
    max+nres	=> slider.max;
    decimalPoints+nres => slider.decimalPoints;
    active+nres => slider.active;

    UIbutton button {
	parent+nres => <-.slider.parent;
	visible => <-.visible;
	active => <-.active;
	x => <-.x;
	y => <-.y;
	width => <-.width;
	height => <-.height;
	label = "...";
	alignment = 0;
    };
    macro valEditor {
	string title_in => <-.title;
	boolean+IPort2 vis =><-.button.do;
	float value_in =><-.value;
	float min_in => <-.min;
	float max_in => <-.max;
	int precision_in => <-.decimalPoints;
	int+nres x => <-.slider.parent.x + <-.button.x;

	// avoid placing editor_shell outside window for long param lists...
#ifdef MSDOS
	int+nres y => 350;
#else
	int+nres y => switch(((<-.slider.parent.y + <-.button.y) <
						<-.slider.parent.height)+1,
				350,
				<-.slider.parent.y + <-.button.y);
#endif

	int+nres active_in => <-.active;
	GMOD.instancer Instancer {
	    Value => <-.vis;
	    Group => <-.UI;
	};
	macro UI<instanced=0> {
	    link title => <-.title_in;
	    link vis => <-.vis;
	    link value => <-.value_in;
	    link min => <-.min_in;
	    link max => <-.max_in;
	    link precision => <-.precision_in;
	    link x => <-.x;
	    link y => <-.y;
	    link active => <-.active_in;

	    UIshell editor_shell {
		title => "Edit " + <-.title;
		x => <-.x + width / 2;
		y => <-.y;
		width = 230;
		height = 200;
		visible => <-.vis;
		showStatusBar = 0;
	    };
	    UIbutton close_button {
		parent =><-.editor_shell;
		label = "close";
		x => (<-.editor_shell.clientWidth - width)/2;
		y => <-.editor_shell.clientHeight - height;
	    };
	    GMOD.copy_on_change set_close {
		trigger =><-.close_button.do;
		input = 0;
		output =><-.editor_shell.visible;
		on_inst = 0;
	    };
	    UIlabel value_label {
		parent => <-.editor_shell;
		x = 0;
		y => <-.value_field.y + <-.value_field.height/2 - height/2;
		label => " "+"Value";
		width = 120;
		alignment = "right";
	    };
	    UIfield value_field {
		parent => <-.editor_shell;
		x => (<-.value_label.x + <-.value_label.width)+3;
		y = 10;
		width =><-.editor_shell.clientWidth - x - 10;
		format = 0;
		nullString = "";
		value =><-.value;
		min =><-.min;
		max =><-.max;
		decimalPoints => <-.precision;
		active => <-.active;
	    };
	    value_label min_label {
		y => <-.min_field.y + <-.min_field.height/2 - height/2;
		label => " "+"Min";
	    };
	    value_field min_field {
		y => ((<-.value_field.y + <-.value_field.height) + 5);
		value =><-.min;
		min =;
	    };
	    value_label max_label {
		y => <-.max_field.y + <-.max_field.height/2 - height/2;
		label => " "+"Max";
	    };
	    value_field max_field {
		y => ((<-.min_field.y + <-.min_field.height) + 5);
		value =><-.max;
		max =;
	    };
	    value_label precision_label {
		y => <-.precision_field.y + <-.precision_field.height/2 - height/2;
		label => " "+"Decimal Places";
	    };
	    UIfield precision_field {
		parent => <-.editor_shell;
		x => (<-.value_label.x + <-.value_label.width)+3;
		y => ((<-.max_field.y + <-.max_field.height) + 5);
		width =><-.editor_shell.clientWidth - x - 10;
		nullString = "";
		value =><-.precision;
		mode = 1;
		min = 0;
//		max = 6;
		active => <-.active;
	    };
	};
    };
};

///////////////////////////////////////////////////////////////////////////////

macro VUIRange {
   link   parent<NEportLevels={2,1}>;
   int    x = 0;
   int    y = 0;
   int    width = 200;
   int    height => .SliderFrame.clientHeight + 3;    // export this height
   int    visible<NEportLevels={2,1}> = 1;
   float  value1<NEportLevels={2,1}>;
   float  value2<NEportLevels={2,1}>;
   int    immediate = 0;
   float  min = 0.0;
   float  max = 1.0;
   int    mode = 2;
   int    format = 0;
   int    decimalPoints => default_dp[mode];
   int    active = 1;
   int    active1 = 1;
   int    active2 = 1;
   string title;
   string label1 = "Min";
   string label2 = "Max";
   int    constrain = 0;       // restrict max > min 

   // DPs for modes         unused integer float
   int    default_dp[3] = {   0,      0,     2   };

   UIframe SliderFrame {
      parent  => <-.parent;
      x       => <-.x;
      y       => <-.y;
      width   => <-.width;
      height  => 2 * Templates.VUI.ViewerResources.VUI.VUISlider.SliderHeight +
			UIdata.UIfonts[0].lineHeight + 4;
      visible => <-.visible;
   };
   VUILabel SliderLabel {
      parent    => <-.SliderFrame;
      x         =  2;
      y         =  0;
      width     => <-.SliderFrame.clientWidth - 4;
      label     => <-.title;
      alignment =  1;
      active    => <-.active;
   };
   UIslider Slider1 {
      parent => <-.SliderFrame;
      x      =  2;
      y      => <-.SliderLabel.y + <-.SliderLabel.height;
      width  => <-.SliderFrame.clientWidth - <-.SliderField1.width - 4;
      height = ViewerResources.VUI.VUISlider.SliderHeight;
      min    => <-.min;
      max    => <-.max;
      value  => <-.value1;
      mode   => <-.mode;
      title  => <-.label1;
      active => <-.active && <-.active1;
      decimalPoints => <-.decimalPoints;
//      format => <-.format;
      immediateMode => <-.immediate;
   };
   UIfield SliderField1 {
      parent => <-.SliderFrame;
      x      => <-.Slider1.x + <-.Slider1.width;
      y      => <-.Slider1.y + (<-.Slider1.height - height)/2;
      width  =  50;
      height => 1.33 * UIdata.UIfonts[0].lineHeight;
      min    => <-.min;
      max    => <-.max;
      value  => <-.value1;
      active => <-.active && <-.active1;
      decimalPoints => <-.decimalPoints;
      format => <-.format;
//      color.foregroundColor = ViewerResources.VUI.VUISlider.FieldColor;
   };
   Slider1 Slider2 {
      y      => <-.Slider1.y + <-.Slider1.height;
      value  => <-.value2;
      title  => <-.label2;
      active => <-.active && <-.active2;
   };
   SliderField1 SliderField2 {
      y      => <-.Slider2.y + (<-.Slider2.height - height)/2;
      value  => <-.value2;
      active => <-.active && <-.active2;
   };

   GMOD.instancer ConstrainInst {
      Value => <-.constrain;
      Group => <-.Constrain;
   };
   GMOD.constrain Constrain<instanced=0> {
      min => value1;
      max => value2;
      delta = 0.01;
   };
};

///////////////////////////////////////////////////////////////////////////////

macro VUIRangeTypein {
   link   parent<NEportLevels={2,1}>;
   int    x = 0;
   int    y = 0;
   int    width = 200;
   int    height => .SliderFrame.clientHeight + 3;    // export this height
   int    visible<NEportLevels={2,1}> = 1;
   float  value1<NEportLevels={2,1}>;
   float  value2<NEportLevels={2,1}>;
   int    immediate = 0;
   float  min = 0.0;
   float  max = 1.0;
   int    mode = 2;
   int    format = 0;
   int    decimalPoints => default_dp[mode];
   int    active = 1;
   int    active1 = 1;
   int    active2 = 1;
   string title;
   string label1 = "Min";
   string label2 = "Max";
   int    constrain = 0;       // restrict max > min 

   // DPs for modes         unused integer float
   int    default_dp[3] = {   0,      0,     2   };

   UIframe SliderFrame {
      parent  => <-.parent;
      x       => <-.x;
      y       => <-.y;
      width   => <-.width;
      height  => 2 * Templates.VUI.ViewerResources.VUI.VUISlider.SliderHeight +
			UIdata.UIfonts[0].lineHeight + 2;
      visible => <-.visible;
   };
   VUILabel SliderLabel {
      parent    => <-.SliderFrame;
      x         =  2;
      y         =  0;
      width     => <-.SliderFrame.clientWidth - 4;
      label     => <-.title;
      alignment =  1;
      active    => <-.active;
   };
   UIslider Slider1 {
      parent => <-.SliderFrame;
      x      =  2;
      y      => <-.SliderLabel.y + <-.SliderLabel.height;
      width  => <-.SliderFrame.clientWidth * 11 / 12;
      height = ViewerResources.VUI.VUISlider.SliderHeight;
      min    => <-.min;
      max    => <-.max;
      value  => <-.value1;
      mode   => <-.mode;
      title  => <-.label1;
      active => (<-.active && <-.active1);
      decimalPoints => <-.decimalPoints;
      immediateMode => <-.immediate;
   };
   VUIslider_typein SliderField1 {
      slider => Slider1;
      width = 20;
   };

   Slider1 Slider2 {
      y      => <-.Slider1.y + <-.Slider1.height;
      value  => <-.value2;
      title  => <-.label2;
      active => (<-.active && <-.active2);
   };
   SliderField1 SliderField2 {
      slider => Slider2;
   };

   GMOD.instancer ConstrainInst {
      Value => <-.constrain;
      Group => <-.Constrain;
   };
   GMOD.constrain Constrain<instanced=0> {
      min => value1;
      max => value2;
      delta = 0.01;
   };
};

///////////////////////////////////////////////////////////////////////////////

macro VUIToggleMotif {
   link   parent<NEportLevels={2,1}>;
   int    x = 0;
   int    y = 0;
   int    width = 100;
   int    height = 32;
   int    set;
   string label;
   int    active = 1;
   int    visible = 1;

   UIframe ToggleFrame {
      parent  => <-.parent;
      y       => <-.y;
      x       => <-.x;
      width   => <-.width;
      height  => <-.height;
      visible => <-.visible;
   };
   UItoggle Toggle {
      parent => <-.ToggleFrame;
      x      =  4;
      y      =  2;
      width  => <-.ToggleFrame.clientWidth  - 8;
      height => <-.ToggleFrame.clientHeight - 4;
      label  => <-.label;
      do<NEportLevels={0,1}>;
      set<NEportLevels={0,1}> => <-.set;
      color {
//         foregroundColor = ViewerResources.VUI.VUIToggle.TextColor;
//         backgroundColor = ViewerResources.VUI.BackgroundColor;
      };
      alignment = 0;
      active => <-.active;
   };
};

///////////////////////////////////////////////////////////////////////////////

macro VUIToggleWindows {
   link parent<NEportLevels={2,1}>;
   int x = 0;
   int y = 0;
   int width = 100;
   int height = 28;
   int set;
   string label;
   int active = 1;
   int visible = 1;

   UIframe ToggleFrame {
      parent => <-.parent;
      y => <-.y;
      x => <-.x;
      width => <-.width;
      height => <-.height;
      visible => <-.visible;
   };
   UItoggle Toggle {
      x = 4;
      y = 4;
      width = 16;
      height => width;
      parent => <-.ToggleFrame;
      label = "";
      do<NEportLevels={0,1}>;
      set<NEportLevels={0,1}> => <-.set;
      active => <-.active;
   };
   UIlabel UIlabel {
      x => (<-.Toggle.x + <-.Toggle.width);
      y => <-.Toggle.y;
      width => (<-.ToggleFrame.clientWidth - <-.Toggle.width);
      height => Toggle.height;
      color {
//         foregroundColor = ViewerResources.VUI.VUIToggle.TextColor;
//         backgroundColor = ViewerResources.VUI.BackgroundColor;
      };
      parent => <-.ToggleFrame;
      label => <-.label;
      active => <-.active;
   };
};

#ifdef MSDOS
VUIToggleWindows VUIToggle;
#else
VUIToggleMotif VUIToggle;
#endif

////////////////////////////////////////////////////////////////////////////

macro VUIRadioBox {
   link     parent<NEportLevels={2,1}>;
   string   &options<NEportLevels={2,1}>[];
   int      dims => array_size(options);
   int      x = 0;
   int      y = 0;
   int      width;
   int+nres height => RBradioBox.y + RBradioBox.height + 8;
   int      selectedItem;
   int      visible = 1;
   string   label;
   int	    active = 1;

   UIframe RBframe {
      parent  => <-.parent;
      x       => <-.x;
      y       => <-.y;
      width   => <-.width;
      height  => <-.height;
      visible => <-.visible;
   };

   VUILabel RBtitle {
      parent    => <-.RBframe;
      x         =  4;
      y         =  4;
      width     => <-.width - 8;
      label     => <-.label;
      alignment = 1;
      active    => <-.active;
   };

   UIoption RBcmdList[dims] {
      label => <-.options[index_of(RBcmdList)];
      active => <-.active;
   };
   UIradioBox RBradioBox {
      parent 	   => <-.RBframe;
      cmdList 	   => <-.RBcmdList;
      x            =  4;
      y 	   => <-.RBtitle.y + <-.RBtitle.height;
      width 	   => <-.RBframe.clientWidth - 8;
      //height 	   => <-.height;
      selectedItem => <-.selectedItem;
   };
};

////////////////////////////////////////////////////////////////////////////

#ifdef NOTDEF
macro VUIRadioBoxPix {
   link     parent<NEportLevels={2,1}>;
   string   &options<NEportLevels={2,1}>[];
   UIpixmap &pixmaps<NEportLevels={2,1}>[];
   int      dims => array_size(options);
   int      x = 0;
   int      y = 0;
   int      width;
   int+nres height => (dims+1.5) * UIdata.UIfonts[0].lineHeight;
   int      selectedItem;
   int      visible = 1;
   string   label;
   int      pixmapWidth  = 24;
   int      pixmapHeight = 24;
   int      pixmapPad    = 16;

   UIframe RBframe {
      parent  => <-.parent;
      x       => <-.x;
      y       => <-.y;
      width   => <-.width;
      height  => <-.height;
      visible => <-.visible;
   };
   VUILabel RBtitle {
      parent    => <-.RBframe;
      x         =  4;
      y         =  4;
      width     => <-.RBframe.width - 8;
      label     => <-.label;
      alignment = 1;
   };
   UIoption RBcmdList[dims] {
      label => <-.options[index_of(RBcmdList)];
   };
   UIradioBox RBradioBox {
      parent 	   => <-.RBframe;
      cmdList 	   => <-.RBcmdList;
      x            =  4;
      y 	   => <-.RBtitle.y + <-.RBtitle.height;
      width 	   => <-.RBframe.clientWidth - <-.pixmapWidth - <-.pixmapPad - 8;
      height 	   => <-.RBframe.clientHeight;
      selectedItem => <-.selectedItem;
   };
   UIlabel RBpixmaps[dims] {
      parent       => <-.RBframe;
      x            => <-.RBframe.clientWidth - <-.pixmapWidth - <-.pixmapPad;
      y            => <-.RBtitle.y + <-.RBtitle.height + 
                                   (index_of(RBpixmaps) * <-.pixmapHeight);
      width        => <-.pixmapWidth;
      height       => <-.pixmapHeight;
      label        =  "";
      labelPixmap {
	 filename => <-.<-.pixmaps[index_of(RBpixmaps)].filename;
         fileType => <-.<-.pixmaps[index_of(RBpixmaps)].fileType;
      };
   };
};

/////////////////////////////////////////////////////////////////////////////

macro VUIOptionMenu {
   link   parent  <NEportLevels={2,1}>;
   string &options<NEportLevels={2,1}>[];
   int    x = 0;
   int    y = 0;
   int    width;
   int    height;
   int    selectedItem;
   int    dims => array_size(options);
   int    visible = 1;
   int    active = 1;

   UIoption OPcmdList[dims] {
      label => <-.options[index_of(OPcmdList)];
      active => <-.active;
   };

   // need combo box for MSDOS
   UIoptionMenu OPmenu {
      parent       => <-.parent;
      x            => <-.x;
      y            => <-.y;
      width        => <-.width;
      height       => <-.height;
      cmdList      => <-.OPcmdList;
      selectedItem => <-.selectedItem;
      optionLabel  = 0;
      label        = "";
      visible      => <-.visible;
   };
};
#endif

///////////////////////////////////////////////////////////////////////////////

macro VUIFileSelector {
   link     parent<NEportLevels={2,1}>;
   int      x;
   int      y;
   int      width = 200;
   int+nres height => 3.5 * UIdata.UIfonts[0].lineHeight + 24;
   string   title;
   string   file;
   string   filetype;

   UIframe fileFrame {
      parent => <-.parent;
      x      => <-.x;
      y      => <-.y;
      width  => <-.width;
      height => <-.height;
   };

   UIlabel fileTitle {
      parent      => <-.fileFrame;
      label       => <-.title;
      x           = 4;
      y           = 4;
      width       => <-.fileFrame.width - 12;
      height+nres => UIdata.UIfonts[0].lineHeight;
   };

   UItext fileText {
      parent      => <-.fileFrame;
      x           =  4;
      y+nres      => <-.fileTitle.y + <-.fileTitle.height + 4;
      width       => <-.fileFrame.width - 12;
      height+nres => 1.5 * UIdata.UIfonts[0].lineHeight;
      text        => <-.file;
   };

   UIbutton fileBrowse {
      parent      => <-.fileFrame;
      label       =  "Browse";
      x           =  4;
      y           => <-.fileText.y + <-.fileText.height + 4;
      width       => <-.fileFrame.width - 12;
      height+nres => UIdata.UIfonts[0].lineHeight + 8;
   };

   UIfileSB fileFB {
      parent        => <-.fileFrame;
      title         => <-.title;
      x             =  250;
      y             =  45;
      visible       => <-.fileBrowse.do;
      filename      => <-.file;
      searchPattern =>  "*." + <-.filetype;
   };
};

/////////////////////////////////////////////////////////////////////////////

macro VUIOptionMenuLabel {
   link   parent  <NEportLevels={2,1}>;
   string options<NEportLevels={2,1}>[];
   int    x = 0;
   int    y = 0;
   int    width;
   int    height = 37;
   int    visible = 1;
   int    active = 1;
   int    selectedItem;
   string label;

   UIoption OPcmdList[array_size(options)] {
      label => <-.options[index_of(OPcmdList)];
   };
   UIoptionMenu OPmenu {
      parent => <-.parent;
      x            => <-.x + <-.width / 2;
      y            => <-.y;
      width        => <-.width / 2;
      height       => <-.height;
      cmdList      => <-.OPcmdList;
      selectedItem => <-.selectedItem;
      optionLabel  = 0;
      label        = "";
      visible      => <-.visible;
      active       => <-.active;
   };
   UIlabel OPlabel {
      parent => <-.parent;
      x 	   => <-.x;
      y 	   => <-.y + 5;
      width 	   => <-.width / 2 - 5;
      visible      => <-.visible;
      active	   => <-.active;
      label	   => <-.label;
      alignment    = 2;
   };
};

///////////////////////////////////////////////////////////////////////////////

macro VUIColorPanel {
   link  parent<NEportLevels={2,1}>;
   int   x;
   int   y;
   int   width;
   int   height;
   float &color[3];

   UIframe ColorFrame {
      parent => <-.parent;
      x      => <-.x;
      y      => <-.y;
      width  => <-.width;
      height => <-.height;
   };

   UIrenderView ColorDrawArea {
      parent  => <-.ColorFrame;
      x       =  4;
      y       =  4;
      width   => <-.ColorFrame.clientWidth  - 8;
      height  => <-.ColorFrame.clientHeight - 8;
      message =  "Color echo.";
   };

   DefaultCamera2D ColorCamera;

   BestVirtPal ColorPal {
      cube_size = 0;
   };

   DefaultView ColorView {
      handle   => <-.ColorDrawArea.handle;
      virtpal  => <-.ColorPal;
      cameras  => { <-.ColorCamera };
      back_col => <-.color;
   };
};

///////////////////////////////////////////////////////////////////////////////

macro VUIColorEditor {
   link   parent<NEportLevels={2,1}>;
   float  red<NEportLevels={2,0}>;
   float  green<NEportLevels={2,0}>;
   float  blue<NEportLevels={2,0}>;
   int    x = 0;
   int    y = 0;
   int    width  = 200;
   string label<NEportLevels=1> = "VUI Color Editor";
   int    style = 0;  // 0 - dials and inc/dec buttons (default)
                      // 1 - sliders

   VUILabel Title {
      parent => <-.parent;
      x      =  0;
      y      => <-.y + 4;
      width  => <-.width - Morph.width - 10;
      label  => <-.label;
      alignment = 1;
   };
   UIbutton Morph {
      parent => <-.parent;
      x = 0;
      y      => <-.y + 4;
      width  = ViewerResources.Icon.Width;
      height = ViewerResources.Icon.Height;
      label  = "";
      labelPixmap.filename = "$XP_PATH<0>/v/vizxp/icons/datamap.x";
      labelPixmap.fileType = "avs_image";
      message = "Morph color editor interface style.";
   };
   GMOD.parse_v_relative_no_inst ParseMorph {
      v_commands = "style = 1 - style;";
      trigger    => <-.Morph.do;
      relative   => ParseMorph;
   };
   VUIToggle Imm {
      parent => <-.parent;
      x      =  4;
      y      => <-.Morph.y + <-.Morph.height + 4;
      width  => <-.width - 8;
      label  = "Immediate";
   };
   VUIColorPanel ColorEcho {
      parent => <-.parent;
      x      =  4;
      y      => <-.Imm.y + <-.Imm.height;
      width  => <-.width - 8;
      height => <-.Imm.height;
      color  => { <-.red, <-.green, <-.blue };
   };

   GMOD.instancer DialsInst {
      Value => 1 - <-.style;
      Group => <-.Dials;
   };

   group Dials<instanced=0> {
      UIframe DialFrame {
         parent => <-.<-.parent;
         x      =  4;
         y      => <-.<-.ColorEcho.y + <-.<-.ColorEcho.height;
         width  => <-.<-.width - 8;
         height = ViewerResources.VUI.VUIColorEditor.Height;
      };

      int tw => <-.width - 8;
      int w3 => (tw-16) / 3;

      VUIDial HDial {
         parent  => <-.DialFrame;
         x       =  0;
         y       =  0;
         width   => <-.w3;
         height  => <-.DialFrame.clientHeight;
         title   = "Hue";
         min     = 0.0;
         max     = 1.0;
         value<NEportLevels={2,2}>     => <-.<-.rgb_or_hsv.h;
         immediate<NEportLevels={2,1}> => <-.<-.Imm.set;
      };
      HDial SDial {
         x     => <-.HDial.x + <-.HDial.width + 4;
         title = "Saturation";
         value<NEportLevels={2,2}> => <-.<-.rgb_or_hsv.s;
      };
      HDial VDial {
         x     => <-.SDial.x + <-.SDial.width + 4;
         title = "Value";
         value<NEportLevels={2,2}> => <-.<-.rgb_or_hsv.v;
      };
      group HSVToRGBArray {
         float r<NEportLevels={3,0}> => <-.HSVToRGB.r;
         float g<NEportLevels={3,0}> => <-.HSVToRGB.g;
         float b<NEportLevels={3,0}> => <-.HSVToRGB.b;
         float rgb_arr[] => {.r,.g,.b};
      };
      GMOD.hsv_to_rgb HSVToRGB {
         h => <-.HDial.value;
         s => <-.SDial.value;
         v => <-.VDial.value;
      };
   };

   GMOD.instancer SlidersInst {
      Value => <-.style;
      Group => <-.Sliders;
   };
   group Sliders<instanced=0> {
      VUISlider HSlider {
         parent  => <-.<-.parent;
         x       = 4;
         y       => <-.<-.ColorEcho.y + <-.<-.ColorEcho.height;
         width   => <-.<-.width - 8;
         value<NEportLevels={2,2}>         => <-.<-.rgb_or_hsv.h;
         immediate<NEportLevels={2,1}> => <-.<-.Imm.set;
         title   = "Hue";
         min     = 0.0;
         max     = 1.0;
      };
      HSlider SSlider {
         y => <-.HSlider.y + <-.HSlider.height;
         value<NEportLevels={2,2}> => <-.<-.rgb_or_hsv.s;
         title = "Saturation";
      };
      HSlider VSlider {
         y => <-.SSlider.y + <-.SSlider.height;
         value<NEportLevels={2,2}> => <-.<-.rgb_or_hsv.v;
         title = "Value";
      };
      group HSVToRGBArray {
         float r<NEportLevels={3,0}> => <-.HSVToRGB.r;
         float g<NEportLevels={3,0}> => <-.HSVToRGB.g;
         float b<NEportLevels={3,0}> => <-.HSVToRGB.b;
         float rgb_arr[] => {.r,.g,.b};
      };
      GMOD.hsv_to_rgb HSVToRGB {
         h => <-.HSlider.value;
         s => <-.SSlider.value;
         v => <-.VSlider.value;
      };
   };

   GMOD.rgb_or_hsv rgb_or_hsv {
      mode = 1;
      r<NEportLevels={2,1}> => <-.red;
      g<NEportLevels={2,1}> => <-.green;
      b<NEportLevels={2,1}> => <-.blue;
      h<NEportLevels={2,2}>;
      s<NEportLevels={2,2}>;
      v<NEportLevels={2,2}>;
   };
};

///////////////////////////////////////////////////////////////////////////////

macro VUIDmapPanel {
   link  parent<NEportLevels={2,1}>;
   link  dmap<NEportLevels={2,1}>;
   int   x = 0;
   int   y = 0;
   int   width;
   int   height;
   int   showCursor1 = 0;      // visibility flag for cursor 1
   float cursorPos1  = 0.0;    // cursor position 1
   int   showCursor2 = 0;      // visibility flag for cursor 1
   float cursorPos2  = 0.0;    // cursor position 1

   UIframe DmapFrame {
      parent => <-.parent;
      x      => <-.x;
      y      => <-.y;
      width  => <-.width;
      height => <-.height;
   };

   UIrenderView DmapDrawArea {
      parent  => <-.DmapFrame;
      //x       =  4;
      //y       =  4;
      //width   => <-.DmapFrame.clientWidth  - 8;
      //height  => <-.DmapFrame.clientHeight - 8;
      x = 0;
      y = 0;
      width   => <-.DmapFrame.clientWidth;
      height  => <-.DmapFrame.clientHeight;
      message =  "Datamap echo.";
   };

   // datamap object --------------------------------------------------

   float+nres delta     => (dmap.dataMax - dmap.dataMin) / 255.0;
   float      ramp[512] => { init_array(256,0,255), init_array(256,0,255) };

   Mesh_Unif+Dim2+Space2+Node_Data+Float DmapSpectrum<NEportLevels={0,1}> {
      dims   =  { 256, 2 };
      nnodes => prod(dims);
      points => { -5.0, -5.0, 5.0, 5.0 };
      nnode_data = 1;
      !node_data[0] {
         veclen = 1;
         values+nres => (<-.<-.ramp * <-.<-.delta) + <-.<-.dmap.dataMin;
      };
   };

   DefaultObject DmapObject {
      input => <-.DmapSpectrum;
      dmap  => <-.dmap;
   };

   // cursor objects -------------------------------------------------

   DefaultProps CursorProps {
      inherit = 0;
      col = { 0.0, 0.0, 0.0 };    // black cursor
   };

   DefaultModes CursorModes {
      mode = { 1, 2, 1, 1, 1 };
   };

   float cursor1X => (cursorPos1 * 9.9) - 4.95;
   float cursor2X => (cursorPos2 * 9.9) - 4.95;

   Mesh Cursor<NEportLevels={0,1}> {
      nnodes = 2;
      nspace = 2;
      ncell_sets = 1;
      Line cell_set[ncell_sets];
      !cell_set[0] {
          ncells = 1;
          node_connect_list = { 0, 1 };
      };
   };

   Cursor Cursor1 {
      coordinates.values => { {<-.<-.cursor1X,-5.0}, {<-.<-.cursor1X,5.0} };
   };

   Cursor Cursor2 {
      coordinates.values => { {<-.<-.cursor2X,-5.0}, {<-.<-.cursor2X,5.0} };
   };

   DefaultObject CursorObject1 {
      input   => <-.Cursor1;
      props   => <-.CursorProps;
      modes   => <-.CursorModes;
      visible => <-.showCursor1;
   };

   DefaultObject CursorObject2 {
      input   => <-.Cursor2;
      props   => <-.CursorProps;
      modes   => <-.CursorModes;
      visible => <-.showCursor2;
   };

   // camera & view ---------------------------------------------

   DefaultCamera2D DmapCamera {
      objects => { <-.DmapObject, <-.CursorObject1, <-.CursorObject2 };
   };

   BestVirtPal DmapPal {
      cube_size = 0;
   };

   DefaultView DmapView {
      handle   => <-.DmapDrawArea.handle;
      virtpal  => <-.DmapPal;
      cameras  => { <-.DmapCamera };
      back_col => { 0.5, 0.5, 0.5 };
      aspect = 0; // want the colorbar occupying the full view
   };
};

///////////////////////////////////////////////////////////////////////////////

#ifdef NOTDEF
macro VUIThumbnail {
   link  parent<NEportLevels={2,1}>;
   int   x      = 0;
   int   y      = 0;
   int   width  = 300;
   int   height = 300;
   link  object<NEportLevels={2,1}>;

   UIframe ThumbFrame {
      parent => <-.parent;
      x      => <-.x;
      y      => <-.y;
      width  => <-.width;
      height => <-.height;
   };

   // this assumes height < width
   int square  => ThumbFrame.clientHeight - 8;

   UIrenderView ThumbDrawArea {
      parent  => <-.ThumbFrame;
      x       => (<-.width - <-.square) / 2  ;
      y       =  4;
      width   => <-.square;
      height  => <-.square;
      message = "Thumbnail sketch of current object.";
   };

   DefaultLightOn ThumbLight;

   DefaultLightInfo ThumbLightInfo {
      lights[] => { <-.ThumbLight };
   };

   /*  really we need a new normalized transform mode for the objects,
    *  so we just take the current object data and play with our local copy 
    *  but this doesn't work, because I can't get the references to behave 
    */

   DefaultModes ThumbModes {
      mode => { 1, 1, 4, 1, 1 };
   };

   GD.DefaultObject ThumbObject {
      input+nres => <-.object.input;
      modes      => <-.ThumbModes;
      // xform_mode => 3 ; // GD_XFORM_MODE_LOCKED doesn't exist !!!!
   };

   GD.DefaultCamera3D ThumbCamera {
      objects => { <-.ThumbObject };  // , <-.object 
      auto_norm => 3; // GD_CAMERA_AUTO_NORM_ALL;
   };

   BestVirtPal ThumbPal;

   GD.DefaultView ThumbView {
      handle     => <-.ThumbDrawArea.handle;
      virtpal    => ThumbPal;
      cameras    => { <-.ThumbCamera };
      light_info => <-.ThumbLightInfo;
      update     = GD_VIEW_AUTO_UPDATE;
   };
};
#endif

///////////////////////////////////////////////////////////////////////////////

macro VUIList {
   link   parent<NEportLevels={2,1}>;
   int    x = 0;
   int    y = 0;
   int    width = 200;
   int    height = 100;
   string label;
   string selectedText;
   string strings[];
   int    active = 1;

   UIframe ListFrame {
      parent => <-.parent;
      x      => <-.x;
      y      => <-.y;
      width  => <-.width;
      height => <-.height;
   };
   VUILabel VUILabel {
      parent => ListFrame;
      x      =  4;
      y      =  4;
      width  => <-.ListFrame.clientWidth;
      label  => <-.label;
      active => <-.active;
   };
   UIlist List {
      parent       => ListFrame;
      x            =  4;
      y            => <-.VUILabel.y + <-.VUILabel.height;
      width        => <-.ListFrame.clientWidth - 8;
      height       => <-.ListFrame.clientHeight - VUILabel.height - 8;
      selectedText => <-.selectedText;
      strings      => <-.strings;
      active => <-.active;
   };
};

};
