//
//                      Copyright (c) 1996 by
//                      Advanced Visual Systems Inc.
//                      All Rights Reserved
//
//      This software comprises unpublished confidential information of
//      Advanced Visual Systems Inc. and may not be used, copied or made
//      available to anyone, except in accordance with the license
//      under which it is furnished.
//
//      This file is under Perforce control
//      $Id: //depot/express/fcs70/v/wt_objs.v#1 $
//

// V file containing definitions of window toolkit objects.

//---------------------------------------------------------------------//

flibrary WT_OBJS <
   build_dir  = "wt_objs",
   libdeps    = "WTOOL",
   locked     = 1,
   build_cmd  = "$(MAKE)",
   hdr_code   = "void WT_OBJSinit (void);",
   init_code  = "     WT_OBJSinit();",
   link_files = "-lwtobj $(WINLIBS)",
   NEvisible  = 0
> {
   library Types {
      //
      // WTfontFamily defines a font family.
      //
      // On Unix, the "family" string corresponds to the foundry and family
      // components of an X Logical Font Description (XLFD) string
      // (e.g. "adobe-courier").  A wildcard character (*) may be used for
      // either component.  The "charset" string corresponds to the registry
      // and encoding components of an XLFD string (e.g. "ISO8859-1").
      // These components may not be wildcarded.
      //
      // On Windows, the "family" string corresponds to the lfFaceName string
      // of a LOGFONT structure (e.g. "courier"), and the "charset" string
      // corresponds to the enumerated string value of the lfCharSet member of
      // a LOGFONT structure (e.g. "ANSI_CHARSET").
      //
      group WTfontFamily {

	 string  family;
	 string  charset;
      };
      //
      // WTfontFamilyList contains an array of WTfontFamily objects.  At
      // least one WTfontFamily should be included for each charset that
      // is to be supported for the current locale.  Multiple WTfontFamily
      // objects may be specified for a given charset in order to enable
      // the system to run on different X servers, which may have
      // different fonts available.
      //
      group WTfontFamilyList {

	 WTfontFamily  families[];
	 int           num_families => array_size(families);

      };
   };
   //
   // This lists the fonts defined for the current locale.
   //
   "../runtime/nls/$XP_LANG_DIR/fonts.v" WTfonts;
};
