flibrary MACROS <compile_subs=0>{
   macro WandMacro {
      int start = 0;
      int env_vars = 0;
      int print_setup = 0;
      int print_data = 0;
      int control_style = 0;
      int tracker_key = 4126;
      int controller_key = 4127;
      int tracker_sensor_num = 1;
      int interval = 50;
      int limit_output = 0;
      float trans_incr = 0.2;
      float z_trans_incr = 0.5;
      float rotation_incr = 5;
      float scale_incr = 0.2;
      float trans_sensitivity = 0.02;
      float rotation_sensitivity = 0.5;
      float scale_sensitivity = 0.5;
      int on_inst = 0;
      
      GMOD.timer timer {
         TimeStep => <-.interval;
         Active => <-.start;
      };

    
      macro WandUI {
         UImod_panel UImod_panel {
            title => "Wand";
	    width => 300;
         };
	 /* Control Style Pull-down menu */
	 UIoptionMenu control_option_menu {
	    parent => <-.UImod_panel;
	    cmdList => {
	    <-.algo0,<-.algo1,<-.algo2,<-.algo3,<-.algo4,<-.algo5,<-.algo6,<-.algo7,
	    <-.algo8,<-.algo9,<-.algo10,<-.algo11,<-.algo12,<-.algo13,<-.algo14,
	    <-.algo15,<-.algo16};
	    selectedItem => <-.<-.control_style;
	    label => "Control Style";
	 };
	 UIoption algo0 {
	    label => "Translation (B)";
	 };
	 UIoption algo1 {
	    label => "Rotation (B)";
	 };
	 UIoption algo2 {
	    label => "Trans+Rot (B)";
	 };
	 UIoption algo3 {
	    label => "Translation (V)";
	 };
	 UIoption algo4 {
	    label => "Rotation (V)";
	 };
	 UIoption algo5 {
	    label => "Trans (B) + Rot (V)";
	 };
	 UIoption algo6 {
	    label => "Abs. Translation (B)";
	 };
	 UIoption algo7 {
	    label => "Abs. Rotation (B)";
	 };
	 UIoption algo8 {
	    label => "Abs. Trans+Rot (B) ";
	 };
	 UIoption algo9 {
	    label => "Actual Translation (B)";
	 };
	 UIoption algo10 {
	    label => "Actual Rotation (B)";
	 };
	 UIoption algo11 {
	    label => "Actual Trans+Rot (B) ";
	 };
	 UIoption algo12 {
	    label => "KGT";
	 };
	 UIoption algo13 {
	    label => "Trans (B1) + Rot (B2)";
	 };
	 UIoption algo14 {
	    label => "None";
	 };
	 UIoption algo15 {
	    label => "Trans (B1) + Trans->Rot (B2)";
	 };
	 UIoption algo16 {
	    label => "KGT 2";
	 };

	 /* Entry fields and their labels */
         UIlabel interval_label {
            parent => <-.UImod_panel;
            label = "Interval (ms)";
            alignment = 0;
//             x => <-.control_option_menu.x;
//             y => <-.control_option_menu.y + .control_option_menu.height;
         };
         UIfield interval_field {
            parent => <-.UImod_panel;
            value => <-.<-.interval;
             x => <-.interval_label.x + <-.interval_label.width;
             y => <-.interval_label.y;
         };
         UIlabel trans_incr_label {
            parent => <-.UImod_panel;
            label = "X,Y trans incr";
            alignment = 0;
//             x => <-.interval_label.x;
//             y => <-.interval_label.y + .interval_label.height;
         };
         UIfield trans_incr_field {
            parent => <-.UImod_panel;
            mode => 0;
            value => <-.<-.trans_incr;
             x => <-.trans_incr_label.x + <-.trans_incr_label.width;
             y => <-.trans_incr_label.y;
         };
         UIlabel z_trans_incr_label {
            parent => <-.UImod_panel;
            label = "Z trans incr";
            alignment = 0;
//             x => <-.trans_incr_label.x;
//             y => <-.trans_incr_label.y + .trans_incr_label.height;
         };
         UIfield z_trans_incr_field {
            parent => <-.UImod_panel;
            mode => 0;
            value => <-.<-.z_trans_incr;
             x => <-.z_trans_incr_label.x + <-.z_trans_incr_label.width;
             y => <-.z_trans_incr_label.y;
         };
         UIlabel rotation_incr_label {
            parent => <-.UImod_panel;
            label = "Rotation incr";
            alignment = 0;
//             x => <-.z_trans_incr_label.x;
//             y => <-.z_trans_incr_label.y + .z_trans_incr_label.height;
         };
         UIfield rotation_incr_field {
            parent => <-.UImod_panel;
            mode => 0;
            value => <-.<-.rotation_incr;
             x => <-.rotation_incr_label.x + <-.rotation_incr_label.width;
             y => <-.rotation_incr_label.y;
         };
         UIlabel scale_incr_label {
            parent => <-.UImod_panel;
            label = "Scale incr";
            alignment = 0;
//             x => <-.rotation_incr_label.x;
//             y => <-.rotation_incr_label.y + .rotation_incr_label.height;
         };
         UIfield scale_incr_field {
            parent => <-.UImod_panel;
            mode => 0;
            value => <-.<-.scale_incr;
             x => <-.scale_incr_label.x + <-.scale_incr_label.width;
             y => <-.scale_incr_label.y;
         };
	 UIlabel trans_sensitivity_label {
            parent => <-.UImod_panel;
            label = "Trans sensitivity";
            alignment = 0;
//             x => <-.rotation_incr_label.x;
//             y => <-.rotation_incr_label.y + .rotation_incr_label.height;
         };
         UIfield trans_sensitivity_field {
            parent => <-.UImod_panel;
            mode => 0;
            value => <-.<-.trans_sensitivity;
             x => <-.trans_sensitivity_label.x + <-.trans_sensitivity_label.width;
             y => <-.trans_sensitivity_label.y;
         };
         UIlabel rotation_sensitivity_label {
            parent => <-.UImod_panel;
            label = "Rot sensitivity";
            alignment = 0;
//             x => <-.trans_sensitivity_label.x;
//             y => <-.trans_sensitivity_label.y + .trans_sensitivity_label.height;
         };
         UIfield rotation_sensitivity_field {
            parent => <-.UImod_panel;
            value => <-.<-.rotation_sensitivity;
             x => <-.rotation_sensitivity_label.x + <-.rotation_sensitivity_label.width;
             y => <-.rotation_sensitivity_label.y;
         };
         UIlabel scale_sensitivity_label {
            parent => <-.UImod_panel;
            label = "Scale sensitivity";
            alignment = 0;
//             x => <-.rotation_sensitivity_label.x;
//             y => <-.rotation_sensitivity_label.y + .rotation_sensitivity_label.height;
         };
         UIfield scale_sensitivity_field {
            parent => <-.UImod_panel;
            value => <-.<-.scale_sensitivity;
             x => <-.scale_sensitivity_label.x + <-.scale_sensitivity_label.width;
             y => <-.scale_sensitivity_label.y;
         };
	 UIlabel tracker_key_label {
            parent => <-.UImod_panel;
            label = "Tracker key";
            alignment = 0;
	    active => !<-.Env_toggle.set;
//             x => <-.rotation_sensitivity_label.x;
//             y => <-.rotation_sensitivity_label.y + .rotation_sensitivity_label.height;
         };
         UIfield tracker_key_field {
            parent => <-.UImod_panel;
            mode => 1;
	    active => !<-.Env_toggle.set;
            value => <-.<-.tracker_key;
	    nullString = "";
             x => <-.tracker_key_label.x + <-.tracker_key_label.width;
             y => <-.tracker_key_label.y;
         };
         UIlabel controller_key_label {
            parent => <-.UImod_panel;
            label = "Controller key";
            alignment = 0;
	    active => !<-.Env_toggle.set;
//             x => <-.tracker_key_label.x;
//             y => <-.tracker_key_label.y + .tracker_key_label.height;
         };
         UIfield controller_key_field {
            parent => <-.UImod_panel;
	    decimalPoints = 0;
	    active => !<-.Env_toggle.set;
            value => <-.<-.controller_key;
	    nullString = "";
             x => <-.controller_key_label.x + <-.controller_key_label.width;
             y => <-.controller_key_label.y;
         };
	 UIlabel tracker_sensor_label {
	    parent => <-.UImod_panel;
	    label => "Tracker sensor";
	    alignment = 0;
	    active => !<-.Env_toggle.set;
// 	    x => <-.controller_key_label.x;
// 	    y => <-.controller_key_label.y + .controller_key_label.height;
	 };
	 UIfield tracker_sensor_field {
	    parent => <-.UImod_panel;
	    min = -1.;
	    decimalPoints = 0;
	    active => !<-.Env_toggle.set;
	    nullString = "";
	    value => <-.<-.tracker_sensor_num;
 	    x => <-.tracker_sensor_label.x + <-.tracker_sensor_label.width;
 	    y => <-.tracker_sensor_label.y;
	 };
	 /* Toggle to determine whether to use env vars or fields below. */
	 UItoggle Env_toggle {
	    label = "Use MPE env vars";
	    parent => <-.UImod_panel;
	    set => <-.<-.env_vars;
	    width => parent.clientWidth;
	    x => <-.tracker_sensor_label.x;
	    y => <-.tracker_sensor_label.y + .tracker_sensor_label.height;
	 };
	 UItoggle print_setup_toggle {
	    label = "Print setup";
	    parent => <-.UImod_panel;
	    set => <-.<-.print_setup;
	 };
	 UItoggle print_data_toggle {
	    label = "Print data";
	    parent => <-.UImod_panel;
	    set => <-.<-.print_data;
	 };
	 /* Start button */
	 UItoggle Start_toggle {
	    label = "Start";
	    parent => <-.UImod_panel;
	    set => <-.<-.start;
// 	    x => <-.Env_toggle.x;
// 	    y => <-.Env_toggle.y + .Env_toggle.height;
	 };
	 UItoggle limit_output_toggle {
	    label = "Limit output updates (allow trackball)";
	    width => parent.clientWidth;
	    parent => <-.UImod_panel;
	    set => <-.<-.limit_output;
	 };
	 
      };
        
	    
      MODULES.WandModule WandModule {
	 startrun => <-.start;
	 controlstyle => <-.control_style;
	 useenvvars => <-.env_vars;
	 printsetup => <-.print_setup;
	 printdata => <-.print_data;
	 limitoutput => <-.limit_output;
	 trackerdaemonkey => <-.tracker_key;
	 controllerdaemonkey => <-.controller_key;
	 sensornum => <-.tracker_sensor_num;
	 timerVal => <-.timer.Val;
	 trans_incr => <-.trans_incr;
	 z_trans_incr => <-.z_trans_incr;
	 rotation_incr => <-.rotation_incr;
	 scale_incr => <-.scale_incr;
	 trans_sensitivity => <-.trans_sensitivity;
	 rotation_sensitivity => <-.rotation_sensitivity;
	 scale_sensitivity => <-.scale_sensitivity;
         left_button<NEportLevels={0,4}>;
         middle_button<NEportLevels={0,4}>;
         right_button<NEportLevels={0,4}>;
	 reset_out<NEportLevels={0,4}>;
      };
   };


   macro WandUViewer3D {
      MACROS.WandMacro WandMacro { 
	 WandModule {
           reset_out<NEportLevels={0,2}>;
         };
         GMOD.parse_v Do_RNC {
            v_commands = "GDtrack_edit { reset = 1; normalize = 1; center = 1; }; ";
            trigger => <-.WandModule.reset_out;
            relative => <-.<-.Uviewer3D.Scene_Editor.Track_Editor;
            active => <-.WandModule.reset_out;
         };
      };
      GDM.Uviewer3D Uviewer3D {
         Scene {
            Top {
               child_objs<NEportLevels={5,1}>;
            };
            View {
               View {
                  &picked_obj<NEportLevels={0,6}>;
               };
            };
         };
         Scene_Selector {
            curr_view<NEportLevels={0,4}>;
         };
         Scene_Editor {
            View_Editor {
               GDobj_sel {
                  cur_obj<NEportLevels={0,6}>;
               };
            };
            Track_Editor {
               GDxform_edit {
                  x_trans => <-.<-.<-.<-.WandMacro.WandModule.x_out;
                  y_trans => <-.<-.<-.<-.WandMacro.WandModule.y_out;
                  z_trans => <-.<-.<-.<-.WandMacro.WandModule.z_out;
                  x_rot => <-.<-.<-.<-.WandMacro.WandModule.elev_out;
                  y_rot => <-.<-.<-.<-.WandMacro.WandModule.azim_out;
                  z_rot => <-.<-.<-.<-.WandMacro.WandModule.roll_out;
		  scale => <-.<-.<-.<-.WandMacro.WandModule.scale_out;
	       };
            };
         };
      };
   };
};
