/*******************************************************************

  NURBS blending code
  Version 1.0

 ******************************************************************
  Written/adapted by: M.J. Evers
  (c) Computer Graphics Unit, Manchester Computing, 
  Created:       31/7/1996       
  Last Modified: 07/08/1996, 15/8/96

  RefineSurface has been adapted from: Graphics Gems IV
      
 ******************************************************************/


#ifndef __BLENDING_H__
#define __BLENDING_H__

#ifndef __NURBH_H__
#define __NURBH_H__

#include "nurbh.h"

#endif


typedef unsigned char Boolean;


void RefineSurface( PR_nurb * src, PR_nurb * dest, Boolean dirflag );

void normalise( PR_nurb * list, int direction, int num_sections );

void blender( PR_nurb * curves, int nbCurves,  
	      PR_nurb * result );
/* Blender creates a surface from src and returns it in result.

   The array curves should contain at least 4 curves:
     curves[0]  =  dirCurve1 = outer curve of surface 1
     curves[1]  =  curve1 = inner curve of surface 1
     curves[nbCurves-2]  =  curve2 = inner curve of surface 2
     curves[nbCurves-1]  =  dirCurve2 = outer curve of surface 2

   The other curves are intermediate curves.

   The caller should allocate memory for result (that is, for the
   basic NURBS structure, not for the vertices and knot vectors...)
*/ 

void clampNURBScurve ( PR_nurb * src, PR_nurb * dest );
void clampNURBSsurface ( PR_nurb * src, PR_nurb * dest );

void InsertKnot( Ppoint4 * ptsSrc, Pfloat * knotsSrc, int np, int order, 
		 Ppoint4 * ptsDest, Pfloat * knotsDest,
		 double u, int s, int r, int k );
/*void InsertKnot( PR_nurb * src, PR_nurb * dest, double u, 
		 int s, int r, int k );*/

void RefineCurve(PR_nurb * src, PR_nurb * dest, PR_knots * newKnots );

void nrb_curve_eval (int k, int n, Pfloat *t, Ppoint4 *p, Pfloat tx, int mode, Ppoint3 *res);


#endif
