/* This is file nurbfns.h created by Extract */
/* Date: */
#ifndef _NURBFNS_
#define _NURBFNS_

/*-------------------------------*/
/*  Including from:nurb1.c  */

extern void nrb_initialise ARGS((  void ));

extern void nrb_error ARGS(( char * str));

extern void nrb_seterrorcount ARGS((  Pint  i));

extern Pint nrb_inqerrorcount ARGS((  Pint * i));

extern PR_knots* nrb_deallocate ARGS((  PR_knots * ptr,   PR_knots * listhead,
                                  PR_stats * stats));

extern PR_knots* nrb_allocate ARGS((  Pint  ntx,   PR_knots * ptr,
                                PR_knots ** listhead,
                                PR_stats * stats));

extern void nrb_deallocateknots ARGS((  PR_dir * kk));

extern void nrb_allocateknots ARGS((  PR_dir * kk));

extern void nrb_deallocatepts ARGS((  PR_pts ** ptr));

extern void nrb_allocatepts ARGS((  Pint  nx,   PR_pts ** ptr));

extern void nrb_clear ARGS((  PR_nurb * nrb));

extern void nrb_allocatenurb ARGS((  PR_nurb ** ptr));

extern void nrb_deallocatenurb ARGS((  PR_nurb ** ptr));

extern void nrb_stats ARGS((  FILE * fp));

extern void nrb_init ARGS((  Pint  kx,   Pint  Ntx,   Pint  ky,   Pint  nty,
                       PR_nurb * nrb));

extern void nrb_copyknots ARGS((  PR_dir * k1,   PR_dir * k2));

extern void nrb_copy ARGS((  PR_nurb * nrb1,   PR_nurb * nrb2));

extern void nrb_interchange ARGS((  PR_nurb * nrb));

extern boolean nrb_getpoint4 ARGS((  FILE * fp,   Ppoint4 * pt));

extern void nrb_putpoint4 ARGS((  FILE * fp,   Ppoint4 * pt));

extern void nrb_dumpl ARGS((  FILE * fp,   char * str,   PR_knots * listhead));

extern void nrb_dumplists ARGS((  FILE * fp));

extern void nrb_dumpknots ARGS((  FILE * fp, char * str,   PR_dir * kk));

extern void nrb_dumppts ARGS((  FILE * fp,   Pint  nx,   Pint  ny,   Ppoint4 * pts,
                          char * str));

extern void nrb_dumpsummary ARGS((  FILE * fp,   PR_nurb * nrb));

extern void nrb_dump ARGS((  FILE * fp,   PR_nurb * nrb));

extern boolean nrb_read ARGS((  FILE * fp,   PR_nurb * nrb));

extern void nrb_write ARGS((  FILE * fp,   PR_nurb * nrb));

extern Ppoint4 tp_litv4 ARGS((  Pfloat  x,   Pfloat  y,   Pfloat  z,   Pfloat  w));

extern Ppoint4 tp_scale4 ARGS((  Ppoint4  s1,   Pfloat  v));

extern Ppoint4 tp_add4 ARGS((  Ppoint4  s1,   Ppoint4  s2));

extern Ppoint4 tp_sub4 ARGS((  Ppoint4  s1,   Ppoint4  s2));

extern Ppoint4 tp_linsum4 ARGS((  Pfloat  a,   Ppoint4  s1,
                            Pfloat  b,   Ppoint4  s2));

extern Pfloat tp_dotv4 ARGS((  Ppoint4  v,   Ppoint4  p));

extern Pfloat tp_modv4 ARGS((  Ppoint4  P1));

extern void nrb_transpose ARGS((  PR_nurb * s1));

extern Pint nrb_numsubdivs ARGS((  PR_nurb * nrb,   PE_dir  xory,   Pfloat  tol));

/*-------------------------------*/
/*  Including from:nurb2.c  */

extern void nrb_makeknots ARGS((  Pfloat  tmin,   Pfloat  tmax,   PR_dir * kk));

extern void nrb_scaleknots ARGS((float new_tmin, float new_tmax, PR_dir *kk));

extern void nrb_unionknots ARGS((  PR_dir * t1,   PR_dir * t2,   PR_dir * t3));

extern void nrb_differenceknots ARGS((  PR_dir * t1,   PR_dir * t2,   PR_dir * t3));

extern void interv ARGS((  Pfloat * xt,   Pint  lxt,   Pfloat  x,
                     Pint * left,   Pint * mflag));

extern void neil_interv ARGS((  float * xt,   Pint  lxt,   float  x,   Pint * left,
                          Pint * mflag));

extern void nrb_interv ARGS((  PR_dir * knots,   Pfloat  X,   Pint * left,
                         Pint * mflag));

extern void nrb_subdivc ARGS((  PR_nurb * nrb1,   PR_nurb * nrb2,   Pint  mu,
                          Pint  j));

extern void nrb_osloc ARGS((  PR_nurb * nrb1,   PR_nurb * nrb2));

extern void nrb_boehmc ARGS((  PR_nurb * nrb1,   PR_dir * tnew,   PR_nurb * nrb2));

extern void nrb_bvalue ARGS((  PR_nurb * s1,   Pfloat  x,   Pint  jderiv,
                         PR_nurb * s2));

/*-------------------------------*/
/*  Including from:nurb3.c  */

extern void nrb_evaluate ARGS((  PR_nurb * s1,   Pfloat  x,   PR_nurb * S2));

extern void nrb_du ARGS((  PR_nurb * s1,   Pfloat  x,   PR_pts ** XX));

extern void nrb_partials ARGS((  PR_nurb * s1,   PR_pts ** du,   PR_pts ** dv,
                           PR_pts ** duv));

extern void nrb_split ARGS((  PR_nurb * s1,   Pfloat  x,   PR_nurb * s2,
                        PR_nurb * s3));

extern void nrb_join ARGS((  PR_nurb * nrb1,   PR_nurb * nrb2,   PR_nurb * nrb));

extern void nrb_xform ARGS((  PR_nurb * nrb1,   Pmatrix3  xx));

extern void nrb_extrude ARGS((  PR_nurb * nrb1,   Ppoint3  w,   PR_nurb * nrb,
                          Pint * error));

extern void nrb_elevateknots ARGS((  PR_dir * s1,   PR_dir * s2));

extern void nrb_elevate ARGS((  boolean  transpose,   PR_nurb * s1,   PR_nurb * s2));

extern void nrb_ruled ARGS((  PR_nurb * nrb1,   PR_nurb * nrb2,   PR_nurb * nrb,
                        Pint * error));

extern void nrb_revolve ARGS((  PR_nurb * nrb1,   PR_nurb * nrb));

extern void nrb_circle ARGS((  PR_nurb * nrb));

extern void nrb_arc ARGS((  Pfloat  theta1,   Pfloat  theta2,   PR_nurb * nrb));

extern void nrb_sphere ARGS((  PR_nurb * nrb));

/*-------------------------------*/
/*  Including from:nurb4.c  */

extern void nrb_torus ARGS((  PR_nurb * nrb));

extern void nrb_polyline ARGS((  Pint  npts,   Ppoint3 * pp,   PR_nurb * nrb));

extern void nrb_square ARGS((  PR_nurb * nrb1));

extern void nrb_triangle ARGS((  PR_nurb * nrb1));

extern void nrb_vase ARGS((  PR_nurb * nrb));

extern void nrb_makehjknots ARGS((  PR_nurb * nrbin));

extern void nrb_interpolate ARGS((  PR_nurb * nrbin,   Pfloat  tol,
                              PR_nurb * nrbout));

extern void nrb_spli2d ARGS((  PR_nurb * nrbin,   Pint  mm,   Pfloat * tpts,
                         PR_nurb * nrbout));

extern void nrb_tessalate ARGS((  PR_nurb * nrb1,   Pint  nx,   PR_nurb * nrb2));

extern void nrb_drawcnet ARGS((  PR_nurb * nrb,   Pint  start,   PE_dir  xory));

extern void nrb_drawc ARGS((  PR_nurb * nrb,   Pfloat  t,   PE_dir  xory));

extern void nrb_drawsnet ARGS((  PR_nurb * cont_grid));

extern void nrb_draws ARGS((  PR_nurb * nrb));

/*-------------------------------*/
/*  Including from:nurb5.c  */

extern void bsplvb ARGS((  Pfloat * t,   Pint  jhigh,   Pint  index,   Pfloat  x,
                     Pint  left,   Pfloat * biatx));

extern void bchfac ARGS((  Pfloat * w,   Pint  nbands,   Pint  nrow,
                     Pfloat * diag));

extern void banfac ARGS((  Pfloat * w,   Pint  nroww,   Pint  nrow,   Pint  nbandl,
                     Pint  nbandu,   Pint * iflag));

/*-------------------------------*/
/*  Including from:nurb6.c  */

extern void bchslvlot ARGS((  Pfloat * w,   Pint  nbands,   Pint  nrow,   Pint  m,
                        Pint  md,   Pfloat * b));

extern void banslv ARGS((  Pfloat * w,   Pint  nroww,   Pint  nrow,   Pint  m,
                     Pint  mmax,   Pint  nbandl,   Pint  nbandu,   Pfloat * b));

extern void spli2d ARGS((  Pfloat * tau,   Pfloat * gtau,   Pfloat * t,   Pint  n,
	  Pint  k,   Pint  m,   Pint  mmax,   Pint  md,
          Pfloat * work,   Pfloat * q,   Pfloat * bcoef,   Pint * iflag));

extern void ll2appr ARGS((  Pfloat * tau,   Pfloat * gtau,   Pfloat * weight,
                      Pint  ntau,   Pfloat * t,   Pint  n,   Pint  k,
                      Pint  m,   Pint  md,   Pfloat * q,   Pfloat * diag,
                      Pfloat * bcoef));
#endif
