/*******************************************************************
  Conversion library - 
     Contains functions to convert objects to and from the NURBS 
     procedure library format to SoftImage SAAPHIRE

     Version 1.0

 ******************************************************************
  Written by: M.J. Evers
      Created:       18/7/1996
      Last Modified: 09/08/1996, 15/8/96, 21/8/96

 ******************************************************************/
#ifndef __SI_NRB_CONV_LIB__
#define __SI_NRB_CONV_LIB___

#include <SAA.h>

#ifndef __NURBH_H__
#define __NURBH_H__

#include "nurbh.h"

#endif


void convertNURBSToSI( PR_nurb * PR_src, SAA_Elem * SI_dest,
		       SAA_Scene * scene );
/* This function converts the given NURBS to SAAPHIRE
   and returns the result in SI_dest.
   The caller should allocate memory for the destination.
*/

void convertNURBSFromSI( SAA_Elem * SI_src, PR_nurb * PR_dest, 
			 SAA_Scene * scene );
/* This function converts the given SI NURBS to NURBS
   procedure library format and returns the result in PR_dest.
   The caller should allocate memory for the destination.

   NOTE:
     If the NURBS is a curve, the MODEL verify flag should not
     be TRUE, because of a bug in the SAA_nurbsCurveGetKnots()
     function.
*/

void copyPoints( PR_nurb * src, SAA_Elem * dest, SAA_Scene * scene,
		 SAA_Boolean closeU, SAA_Boolean closeV );
/* Copies the vertices and knots from the PR LIB NURBS src
   to the given SI NURBS surface dest. 
   The parameters closeU and closeV specify if the SI NURBS should be closed in
   the u resp. v direction.

   Note that copyPoints only works for NURBS surfaces.

   Note that the copying only affects the local coordinates of 
   the vertices of an object. The coordinates of its center remain
   unchanged...
*/

void nurbsSurfaceSetClosed( SAA_Scene * scene, SAA_Elem * srf,
			    SAA_Boolean closedU, SAA_Boolean closedV );
/*
   This function closes or opens the given NURBS surface, as
   specified by the parameters closedU and closedV.
*/

void dirtyCopy( SAA_Scene * scene, SAA_Elem * srf, SAA_Elem * dest );
/* 
   This function makes a copy of the NURBS surface srf and returns
   it in dest. Caller should allocate memory for dest.
*/

void globalise( SAA_Elem * src, PR_nurb * dest, SAA_Scene * scene );
/* 
   This function 'globalises' the coordinates of dest (assuming that
   dest has the local coordinates of src)

*/

void scaleKnotVector( PR_dir * knotVector, double newMax );
/* This function scales the given knot vector
   so that it will lie in the range 
   [0.0 ... newMax].
*/


void dumpNURBS( FILE * f, SAA_Scene * scene, SAA_Elem * srf );
/* 
   Dumps info about the given NURBS onto the specified output
   stream.

   At the moment only NURBS curves are supported.
*/

/*
** Some function for reading/writing NURBS from/to files
** in the format of the Manchester NURBS procedure library
*/


void readNURBS( const char * inputFile, SAA_Scene * scene );
/* read a NURBS from the file named inputFile, and 
   convert it to SAAPHIRE. The NURBS will be created in
   the given scene 
*/

void writeNURBS( const char * outputFile, SAA_Scene * scene,
		 SAA_Elem * SI_NURBS );
/* writes the given NURBS SI_NURBS from the given scene to the 
   file named outputFile.
*/

#endif
