/*|
 *|   PNGLOGO4.POV -- scene file for POV-Ray 2.2
 *|   Copyright (c) 1995 by Oliver Fromme -- All Rights Reserved
 *|
 *|   Oliver Fromme, Leibnizstr. 18-61, 38678 Clausthal, Germany
 *|   Internet/Usenet email:  fromme@rz.tu-clausthal.de
 *|   WWW:  http://www.rz.tu-clausthal.de/~inof/Welcome.html
 *|
 *|   May be used freely without charge for any purpose.
 *|   This copyright notice may not be removed or modified.
 *|
 */

/*
 *   Rendering time for original image (POV-Ray 2.2.ibmicb):
 *      Pentium-90   1440x960   2:44:58
 *      with text backgound     3:23:01
 */

/*|
 *|   [Modifications by Greg Roelofs, 4 May 1995:  changed wood texture,
 *|    shuffled balls' colors, made some balls transparent, removed `!',
 *|    rotated/enlarged/clarified/fixed "PNG" word, changed aspect ratio
 *|    to 4:3]
 *|
 *|   Rendering time for modified image (POV-Ray 2.2 for Linux/X):
 *|      486-33       1024x768  12:30:38 (wallclock)
 *|                             12:16:35 (CPU)
 *|
 */

#version 2.2

#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"

camera {
   up <0, 1, 0>
   right <1.333, 0, 0> // aspect ratio 4:3 for typical backgrounds
   location <0.05, -4, -27.5>
   direction <0, 0, 1.5>
   look_at <0, -0.4, 0>
}

light_source {< 0, 15, -30> color White}
light_source {< 0, 15, -30> color White}
light_source {< 0, 15, -30> color White}

#declare MyCopper = color rgb <0.95, 0.33, 0.10>
#declare grrCopper = color rgb <0.95, 0.4, 0.10>
#declare grrRed = color rgb <0.8, 0.1, 0.1>
#declare grrBlue = color rgb <0.2, 0.2, 0.7>
#declare grrGreen = color rgbf <0.1, 0.8, 0.1, 0.6>
#declare grrYellow = color rgbf <0.8, 0.8, 0.1, 0.6>

// Textures for passes 1 - 7:

#declare P1_t = texture {pigment {Gold} finish {Metal}}
#declare P2_t = texture {pigment {grrCopper} finish {Metal}}
#declare P3_t = texture {pigment {grrBlue} finish {Metal}}
#declare P4_t = texture {Glass pigment {grrGreen} finish {Metal}}
#declare P5_t = texture {pigment {grrRed} finish {Metal}}
#declare P6_t = texture {Glass pigment {grrYellow} finish {Metal}}
#declare P7_t = texture {Glass pigment {Silver filter 0.8} finish {Metal}}
/*
#declare P7_t = texture {Mirror pigment {Silver}}
 */

// Radius for passes 1 - 7:

/* for "missing" balls (0.0 causes floating exception):
#declare P1_r = 1.2
#declare P2_r = 1.1
#declare P3_r = 1.0
#declare P4_r = 0.9
#declare P5_r = 0.8
#declare P6_r = 0.7
#declare P7_r = 0.6

 */
#declare P1_r = 0.00001
#declare P2_r = 0.00001
#declare P3_r = 0.00001
#declare P4_r = 0.00001
#declare P5_r = 0.00001
#declare P6_r = 0.00001
#declare P7_r = 0.00001

// Depth of hollows in shelf:

#declare HDepth = 0.4

// Y positions of centers of the beads:

#declare P1_y = P1_r - HDepth
#declare P2_y = P2_r - HDepth
#declare P3_y = P3_r - HDepth
#declare P4_y = P4_r - HDepth
#declare P5_y = P5_r - HDepth
#declare P6_y = P6_r - HDepth
#declare P7_y = P7_r - HDepth

// Texture of the wooden shelf:

/*
#declare PNG_Wood =
   texture {
      pigment {
         wood
         turbulence 0.05
         colour_map {
            [0.00 color rgb <0.58, 0.45, 0.23>]
            [0.34 color rgb <0.65, 0.45, 0.25>]
            [0.34 color rgb <0.65, 0.45, 0.25>]
            [0.40 color rgb <0.33, 0.23, 0.13>]
            [0.40 color rgb <0.33, 0.23, 0.13>]
            [0.47 color rgb <0.60, 0.40, 0.20>]
            [0.47 color rgb <0.60, 0.40, 0.20>]
            [1.00 color rgb <0.25, 0.15, 0.05>]
         }
      }
      finish {
         crand 0.02
         ambient 0.32
         diffuse 0.63
         phong 0.05
         phong_size 10
      }
      normal {bumps 0.05}
      scale 1.5 translate <0, 0, 10> rotate <5, 0, 0>
   }
   texture {
      pigment {
         bozo
         color_map {
            [0.00 color rgb <1.00, 1.00, 1.00> filter 1.00]
            [0.80 color rgb <1.00, 0.90, 0.80> filter 0.80]
            [0.80 color rgb <1.00, 0.90, 0.80> filter 0.80]
            [1.00 color rgb <0.30, 0.20, 0.10> filter 0.40]
         }
         scale 0.25
      }
      scale 1.5 translate <0, 0, 10> rotate <5, 0, 0>
   }
   texture {
      pigment {
         image_map {
            gif "pngback.gif"
            map_type 0
            interpolate 2
            filter 255, 1.0
         }
         rotate 90*x
         scale 10
      }
   }
 */

#declare grrWood =
   texture {DMFDarkOak}
   texture {
      pigment {
         image_map {
            gif "pngback.gif"
            map_type 0
            interpolate 2
            filter 255, 1.0
         }
         rotate 90*x
         scale 6
      }
   }

// Size of the hollows:

#declare sc_r = 1.5
#declare sc_y = sc_r - HDepth

// The wooden shelf.
// The hollows are created by cutting spheres from a solid plane.
// First we declare one row of such spheres.

#declare sphere_row =
   union {
      sphere {<-7, sc_y, 0>, sc_r}      sphere {<-5, sc_y, 0>, sc_r}
      sphere {<-3, sc_y, 0>, sc_r}      sphere {<-1, sc_y, 0>, sc_r}
      sphere {< 1, sc_y, 0>, sc_r}      sphere {< 3, sc_y, 0>, sc_r}
      sphere {< 5, sc_y, 0>, sc_r}      sphere {< 7, sc_y, 0>, sc_r}
   }

// Now we use 8 of those rows to create the final shelf.

#declare Shelf =
   difference {
      plane {y, 0}
      object {sphere_row translate  7*z}      object {sphere_row translate  5*z}
      object {sphere_row translate  3*z}      object {sphere_row translate  1*z}
      object {sphere_row translate -1*z}      object {sphere_row translate -3*z}
      object {sphere_row translate -5*z}      object {sphere_row translate -7*z}
      /* texture {PNG_Wood} */
      /* texture {Dark_Wood} */
      /* texture {Tom_Wood} */
      /* texture {DMFWood3}  yuk!!  */
      texture {DMFDarkOak}
      /* texture {grrWood} */
   }

// The first row of beads (passes 1, 2, 4 and 6):

#declare Beads_row1 =
   union {
      sphere {<-7, P1_y, 0>, P1_r texture {P1_t}} // pass 1
      sphere {< 1, P2_y, 0>, P2_r texture {P2_t}} // pass 2
      union { // pass 4
         sphere {<-3, P4_y, 0>, P4_r}      sphere {< 5, P4_y, 0>, P4_r}
         texture {P4_t}
      }
      union { // pass 6
         sphere {<-5, P6_y, 0>, P6_r}      sphere {<-1, P6_y, 0>, P6_r}
         sphere {< 3, P6_y, 0>, P6_r}      sphere {< 7, P6_y, 0>, P6_r}
         texture {P6_t}
      }
   }

// The second row of beads (pass 7, identical to rows 4, 6 and 8):

#declare Beads_row2 =
   union {
      sphere {<-7, P7_y, 0>, P7_r}      sphere {<-5, P7_y, 0>, P7_r}
      sphere {<-3, P7_y, 0>, P7_r}      sphere {<-1, P7_y, 0>, P7_r}
      sphere {< 1, P7_y, 0>, P7_r}      sphere {< 3, P7_y, 0>, P7_r}
      sphere {< 5, P7_y, 0>, P7_r}      sphere {< 7, P7_y, 0>, P7_r}
      texture {P7_t}
   }

// The third row of beads (passes 5 and 6, identical to row 7):

#declare Beads_row3 =
   union {
      union { // pass 5
         sphere {<-7, P5_y, 0>, P5_r}      sphere {<-3, P5_y, 0>, P5_r}
         sphere {< 1, P5_y, 0>, P5_r}      sphere {< 5, P5_y, 0>, P5_r}
         texture {P5_t}
      }
      union { // pass 6
         sphere {<-5, P6_y, 0>, P6_r}      sphere {<-1, P6_y, 0>, P6_r}
         sphere {< 3, P6_y, 0>, P6_r}      sphere {< 7, P6_y, 0>, P6_r}
         texture {P6_t}
      }
   }

// The fifth row of beads (passes 3, 4 and 6):

#declare Beads_row5 =
   union {
      union { // pass 3
         sphere {<-7, P3_y, 0>, P3_r}      sphere {< 1, P3_y, 0>, P3_r}
         texture {P3_t}
      }
      union { // pass 4
         sphere {<-3, P4_y, 0>, P4_r}      sphere {< 5, P4_y, 0>, P4_r}
         texture {P4_t}
      }
      union { // pass 6
         sphere {<-5, P6_y, 0>, P6_r}      sphere {<-1, P6_y, 0>, P6_r}
         sphere {< 3, P6_y, 0>, P6_r}      sphere {< 7, P6_y, 0>, P6_r}
         texture {P6_t}
      }
   }

// Now merge rows 1 - 8:

#declare Beads =
   union {
      object {Beads_row1 translate  7*z}
      object {Beads_row2 translate  5*z}
      object {Beads_row3 translate  3*z}
      object {Beads_row2 translate  1*z}
      object {Beads_row5 translate -1*z}
      object {Beads_row2 translate -3*z}
      object {Beads_row3 translate -5*z}
      object {Beads_row2 translate -7*z}
   }

// Declare the word "PNG":

/*
#declare PNG_Word =
   height_field {
      gif "pngword5c.gif"
      smooth
      water_level 0.001
      translate <-0.49, -3.0, -0.05>  /* +x: right   +y: out   +z: up (top) */
      /* scale <1408/365, 1, 1> */
      /* scale <914/265, 1, 1> */
      scale <1259/368, 1, 1>
      texture {
         pigment {color rgb <0.9, 0.95, 1.0> filter 0.925}
         finish {
            Shiny
            ambient 0
            /* diffuse 0.2 */
            reflection 0.3
            refraction 1
            ior 1.5
         }
      }
   }
 */

object {
   union {
      object {Shelf}
      object {Beads}
      rotate <-70, 0, 0>
   }
}

/*
object {
   PNG_Word
   scale <5.8, 1.2, 5.8>
   rotate -70*x
   translate <0, -1.5, -7.5>
}
 */

// This is our "sky sphere" for mirror surfaces:

/*
object {
   sphere {<0, 0, 0>, 50 texture {Blue_Sky2}}   these clouds suck
}
 */

// --- END ---
