/*|
 *|   PNGLOGO2.POV -- scene file for POV-Ray 2.2
 *|   Copyright (c) 1995 by Oliver Fromme -- All Rights Reserved
 *|
 *|   Oliver Fromme, Leibnizstr. 18-61, 38678 Clausthal, Germany
 *|   Internet/Usenet email:  fromme@rz.tu-clausthal.de
 *|   WWW:  http://www.rz.tu-clausthal.de/~inof/Welcome.html
 *|
 *|   May be used freely without charge for any purpose.
 *|   This copyright notice may not be removed or modified.
 *|
 */

/*
 *   Rendering time (POV-Ray 2.2.ibmicb):
 *      Pentium-90   1280x960   0:04:41
 */

#version 2.2

#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "chars.inc"

background {color White}

camera {
   location <0, -4, -13>
   look_at  <0, 0, 0>
}

light_source {<-1, 3, -5> color White}
light_source {< 0, 3, -5> color White}
light_source {< 1, 3, -5> color White}

#declare PNG_MeltSteel =
   pigment {
      bozo
      turbulence 0.5
      color_map {
         [0.0 color rgb <0.4,0.700,0.9>]
         [0.5 color rgb <0.3,0.200,0.0>]
         [0.5 color rgb <0.6,0.025,0.0>]
         [0.6 color rgb <0.9,0.700,0.0>]
         [0.6 color rgb <0.6,0.025,0.0>]
         [1.0 color rgb <0.6,0.025,0.0>]
      }
   }

object {
   union {
      object {
         char_P
         translate -6*x
      }
      object {
         char_N
         translate -1*x
      }
      object {
         char_G
         translate +4*x
      }
      object {
         char_ExclPt
         translate +7.5*x
      }
      texture {PNG_MeltSteel}
      translate -2.5*y
   }
}

// --- END ---
