/*|
 *|   PNGLOGO3.POV -- scene file for POV-Ray 2.2
 *|   Copyright (c) 1995 by Oliver Fromme -- All Rights Reserved
 *|
 *|   Oliver Fromme, Leibnizstr. 18-61, 38678 Clausthal, Germany
 *|   Internet/Usenet email:  fromme@rz.tu-clausthal.de
 *|   WWW:  http://www.rz.tu-clausthal.de/~inof/Welcome.html
 *|
 *|   May be used freely without charge for any purpose.
 *|   This copyright notice may not be removed or modified.
 *|
 */

/*
 *   Rendering time (POV-Ray 2.2.ibmicb):
 *      Pentium-90   1280x960   1:32:02
 */

#version 2.2

#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"

background {color White}

camera {
   location <0, -4, -25>
   direction <0, 0, 1.5>
   look_at <0, -0.4, 0>
}

light_source {< 0, 15, -30> color White}
light_source {< 0, 15, -30> color White}
light_source {< 0, 15, -30> color White}

// Textures for passes 1 - 7:

#declare P1_t = texture {pigment {color Gold} finish {Metal}}
#declare P2_t = texture {pigment {color Silver} finish {Metal}}
#declare P3_t = texture {pigment {color Copper} finish {Metal}}
#declare P4_t = texture {pigment {color Red} finish {Metal}}
#declare P5_t = texture {pigment {color Yellow} finish {Metal}}
#declare P6_t = texture {pigment {color Green} finish {Metal}}
#declare P7_t = texture {pigment {color Blue} finish {Metal}}

// Radius for passes 1 - 7:

#declare P1_r = 1.1
#declare P2_r = 1.0
#declare P3_r = 0.9
#declare P4_r = 0.8
#declare P5_r = 0.7
#declare P6_r = 0.6
#declare P7_r = 0.5

// Distance from shelf:

#declare SDist = -0.4

// Y positions of centers:

#declare P1_y = P1_r + SDist
#declare P2_y = P2_r + SDist
#declare P3_y = P3_r + SDist
#declare P4_y = P4_r + SDist
#declare P5_y = P5_r + SDist
#declare P6_y = P6_r + SDist
#declare P7_y = P7_r + SDist

#declare PNG_Wood =
   texture {
      pigment {
         wood
         turbulence 0.05
         colour_map {
            [0.00 color red 0.58 green 0.45 blue 0.23]
            [0.34 color red 0.65 green 0.45 blue 0.25]
            [0.34 color red 0.65 green 0.45 blue 0.25]
            [0.40 color red 0.33 green 0.23 blue 0.13]
            [0.40 color red 0.33 green 0.23 blue 0.13]
            [0.47 color red 0.60 green 0.40 blue 0.20]
            [0.47 color red 0.60 green 0.40 blue 0.20]
            [1.00 color red 0.25 green 0.15 blue 0.05]
         }
      }
      finish {
         crand 0.02
         ambient 0.32
         diffuse 0.63
         phong 0.05
         phong_size 10
      }
      normal {bumps 0.05}
      scale 1.5 translate <0,0,10> rotate <5,0,0>
   }
   texture {
      pigment {
         bozo
         color_map {
            [0.00 color red 1.00 green 1.00 blue 1.00 filter 1.00]
            [0.80 color red 1.00 green 0.90 blue 0.80 filter 0.80]
            [0.80 color red 1.00 green 0.90 blue 0.80 filter 0.80]
            [1.00 color red 0.30 green 0.20 blue 0.10 filter 0.40]
         }
         scale 0.25
      }
      scale 1.5 translate <0,0,10> rotate <5,0,0>
   }

#declare sc_r = 1.5
#declare sc_y = sc_r + SDist

#declare bc_r = sc_r+0.05
#declare bp_r = P1_r+0.05

object {
   union {
      difference {
         plane {y, 0 texture {PNG_Wood}}
         union {
            sphere {<-7,sc_y, 7>,sc_r texture {PNG_Wood}}
            sphere {<-5,sc_y, 7>,sc_r texture {PNG_Wood}}
            sphere {<-3,sc_y, 7>,sc_r texture {PNG_Wood}}
            sphere {<-1,sc_y, 7>,sc_r texture {PNG_Wood}}
            sphere {< 1,sc_y, 7>,sc_r texture {PNG_Wood}}
            sphere {< 3,sc_y, 7>,sc_r texture {PNG_Wood}}
            sphere {< 5,sc_y, 7>,sc_r texture {PNG_Wood}}
            sphere {< 7,sc_y, 7>,sc_r texture {PNG_Wood}}
            bounded_by {box {<-7-bc_r,sc_y-bc_r,7+bc_r>,<7+bc_r,sc_y+bc_r,7-bc_r>}}
         }
         union {
            sphere {<-7,sc_y, 5>,sc_r texture {PNG_Wood}}
            sphere {<-5,sc_y, 5>,sc_r texture {PNG_Wood}}
            sphere {<-3,sc_y, 5>,sc_r texture {PNG_Wood}}
            sphere {<-1,sc_y, 5>,sc_r texture {PNG_Wood}}
            sphere {< 1,sc_y, 5>,sc_r texture {PNG_Wood}}
            sphere {< 3,sc_y, 5>,sc_r texture {PNG_Wood}}
            sphere {< 5,sc_y, 5>,sc_r texture {PNG_Wood}}
            sphere {< 7,sc_y, 5>,sc_r texture {PNG_Wood}}
            bounded_by {box {<-7-bc_r,sc_y-bc_r,5+bc_r>,<7+bc_r,sc_y+bc_r,5-bc_r>}}
         }
         union {
            sphere {<-7,sc_y, 3>,sc_r texture {PNG_Wood}}
            sphere {<-5,sc_y, 3>,sc_r texture {PNG_Wood}}
            sphere {<-3,sc_y, 3>,sc_r texture {PNG_Wood}}
            sphere {<-1,sc_y, 3>,sc_r texture {PNG_Wood}}
            sphere {< 1,sc_y, 3>,sc_r texture {PNG_Wood}}
            sphere {< 3,sc_y, 3>,sc_r texture {PNG_Wood}}
            sphere {< 5,sc_y, 3>,sc_r texture {PNG_Wood}}
            sphere {< 7,sc_y, 3>,sc_r texture {PNG_Wood}}
            bounded_by {box {<-7-bc_r,sc_y-bc_r,3+bc_r>,<7+bc_r,sc_y+bc_r,3-bc_r>}}
         }
         union {
            sphere {<-7,sc_y, 1>,sc_r texture {PNG_Wood}}
            sphere {<-5,sc_y, 1>,sc_r texture {PNG_Wood}}
            sphere {<-3,sc_y, 1>,sc_r texture {PNG_Wood}}
            sphere {<-1,sc_y, 1>,sc_r texture {PNG_Wood}}
            sphere {< 1,sc_y, 1>,sc_r texture {PNG_Wood}}
            sphere {< 3,sc_y, 1>,sc_r texture {PNG_Wood}}
            sphere {< 5,sc_y, 1>,sc_r texture {PNG_Wood}}
            sphere {< 7,sc_y, 1>,sc_r texture {PNG_Wood}}
            bounded_by {box {<-7-bc_r,sc_y-bc_r,1+bc_r>,<7+bc_r,sc_y+bc_r,1-bc_r>}}
         }
         union {
            sphere {<-7,sc_y,-1>,sc_r texture {PNG_Wood}}
            sphere {<-5,sc_y,-1>,sc_r texture {PNG_Wood}}
            sphere {<-3,sc_y,-1>,sc_r texture {PNG_Wood}}
            sphere {<-1,sc_y,-1>,sc_r texture {PNG_Wood}}
            sphere {< 1,sc_y,-1>,sc_r texture {PNG_Wood}}
            sphere {< 3,sc_y,-1>,sc_r texture {PNG_Wood}}
            sphere {< 5,sc_y,-1>,sc_r texture {PNG_Wood}}
            sphere {< 7,sc_y,-1>,sc_r texture {PNG_Wood}}
            bounded_by {box {<-7-bc_r,sc_y-bc_r,-1+bc_r>,<7+bc_r,sc_y+bc_r,-1-bc_r>}}
         }
         union {
            sphere {<-7,sc_y,-3>,sc_r texture {PNG_Wood}}
            sphere {<-5,sc_y,-3>,sc_r texture {PNG_Wood}}
            sphere {<-3,sc_y,-3>,sc_r texture {PNG_Wood}}
            sphere {<-1,sc_y,-3>,sc_r texture {PNG_Wood}}
            sphere {< 1,sc_y,-3>,sc_r texture {PNG_Wood}}
            sphere {< 3,sc_y,-3>,sc_r texture {PNG_Wood}}
            sphere {< 5,sc_y,-3>,sc_r texture {PNG_Wood}}
            sphere {< 7,sc_y,-3>,sc_r texture {PNG_Wood}}
            bounded_by {box {<-7-bc_r,sc_y-bc_r,-3+bc_r>,<7+bc_r,sc_y+bc_r,-3-bc_r>}}
         }
         union {
            sphere {<-7,sc_y,-5>,sc_r texture {PNG_Wood}}
            sphere {<-5,sc_y,-5>,sc_r texture {PNG_Wood}}
            sphere {<-3,sc_y,-5>,sc_r texture {PNG_Wood}}
            sphere {<-1,sc_y,-5>,sc_r texture {PNG_Wood}}
            sphere {< 1,sc_y,-5>,sc_r texture {PNG_Wood}}
            sphere {< 3,sc_y,-5>,sc_r texture {PNG_Wood}}
            sphere {< 5,sc_y,-5>,sc_r texture {PNG_Wood}}
            sphere {< 7,sc_y,-5>,sc_r texture {PNG_Wood}}
            bounded_by {box {<-7-bc_r,sc_y-bc_r,-5+bc_r>,<7+bc_r,sc_y+bc_r,-5-bc_r>}}
         }
         union {
            sphere {<-7,sc_y,-7>,sc_r texture {PNG_Wood}}
            sphere {<-5,sc_y,-7>,sc_r texture {PNG_Wood}}
            sphere {<-3,sc_y,-7>,sc_r texture {PNG_Wood}}
            sphere {<-1,sc_y,-7>,sc_r texture {PNG_Wood}}
            sphere {< 1,sc_y,-7>,sc_r texture {PNG_Wood}}
            sphere {< 3,sc_y,-7>,sc_r texture {PNG_Wood}}
            sphere {< 5,sc_y,-7>,sc_r texture {PNG_Wood}}
            sphere {< 7,sc_y,-7>,sc_r texture {PNG_Wood}}
            bounded_by {box {<-7-bc_r,sc_y-bc_r,-7+bc_r>,<7+bc_r,sc_y+bc_r,-7-bc_r>}}
         }
      }

      union {
         sphere {<-7,P1_y, 7>, P1_r texture {P1_t}}
         sphere {<-5,P6_y, 7>, P6_r texture {P6_t}}
         sphere {<-3,P4_y, 7>, P4_r texture {P4_t}}
         sphere {<-1,P6_y, 7>, P6_r texture {P6_t}}
         sphere {< 1,P2_y, 7>, P2_r texture {P2_t}}
         sphere {< 3,P6_y, 7>, P6_r texture {P6_t}}
         sphere {< 5,P4_y, 7>, P4_r texture {P4_t}}
         sphere {< 7,P6_y, 7>, P6_r texture {P6_t}}
         bounded_by {box {<-7-bp_r,sc_y-bc_r,7+bp_r>,<7+bp_r,P1_y+bp_r,7-bp_r>}}
      }
      union {
         sphere {<-7,P7_y, 5>, P7_r texture {P7_t}}
         sphere {<-5,P7_y, 5>, P7_r texture {P7_t}}
         sphere {<-3,P7_y, 5>, P7_r texture {P7_t}}
         sphere {<-1,P7_y, 5>, P7_r texture {P7_t}}
         sphere {< 1,P7_y, 5>, P7_r texture {P7_t}}
         sphere {< 3,P7_y, 5>, P7_r texture {P7_t}}
         sphere {< 5,P7_y, 5>, P7_r texture {P7_t}}
         sphere {< 7,P7_y, 5>, P7_r texture {P7_t}}
         bounded_by {box {<-7-bp_r,sc_y-bc_r,5+bp_r>,<7+bp_r,P1_y+bp_r,5-bp_r>}}
      }
      union {
         sphere {<-7,P5_y, 3>, P5_r texture {P5_t}}
         sphere {<-5,P6_y, 3>, P6_r texture {P6_t}}
         sphere {<-3,P5_y, 3>, P5_r texture {P5_t}}
         sphere {<-1,P6_y, 3>, P6_r texture {P6_t}}
         sphere {< 1,P5_y, 3>, P5_r texture {P5_t}}
         sphere {< 3,P6_y, 3>, P6_r texture {P6_t}}
         sphere {< 5,P5_y, 3>, P5_r texture {P5_t}}
         sphere {< 7,P6_y, 3>, P6_r texture {P6_t}}
         bounded_by {box {<-7-bp_r,sc_y-bc_r,3+bp_r>,<7+bp_r,P1_y+bp_r,3-bp_r>}}
      }
      union {
         sphere {<-7,P7_y, 1>, P7_r texture {P7_t}}
         sphere {<-5,P7_y, 1>, P7_r texture {P7_t}}
         sphere {<-3,P7_y, 1>, P7_r texture {P7_t}}
         sphere {<-1,P7_y, 1>, P7_r texture {P7_t}}
         sphere {< 1,P7_y, 1>, P7_r texture {P7_t}}
         sphere {< 3,P7_y, 1>, P7_r texture {P7_t}}
         sphere {< 5,P7_y, 1>, P7_r texture {P7_t}}
         sphere {< 7,P7_y, 1>, P7_r texture {P7_t}}
         bounded_by {box {<-7-bp_r,sc_y-bc_r,1+bp_r>,<7+bp_r,P1_y+bp_r,1-bp_r>}}
      }
      union {
         sphere {<-7,P3_y,-1>, P3_r texture {P3_t}}
         sphere {<-5,P6_y,-1>, P6_r texture {P6_t}}
         sphere {<-3,P4_y,-1>, P4_r texture {P4_t}}
         sphere {<-1,P6_y,-1>, P6_r texture {P6_t}}
         sphere {< 1,P3_y,-1>, P3_r texture {P3_t}}
         sphere {< 3,P6_y,-1>, P6_r texture {P6_t}}
         sphere {< 5,P4_y,-1>, P4_r texture {P4_t}}
         sphere {< 7,P6_y,-1>, P6_r texture {P6_t}}
         bounded_by {box {<-7-bp_r,sc_y-bc_r,-1+bp_r>,<7+bp_r,P1_y+bp_r,-1-bp_r>}}
      }
      union {
         sphere {<-7,P7_y,-3>, P7_r texture {P7_t}}
         sphere {<-5,P7_y,-3>, P7_r texture {P7_t}}
         sphere {<-3,P7_y,-3>, P7_r texture {P7_t}}
         sphere {<-1,P7_y,-3>, P7_r texture {P7_t}}
         sphere {< 1,P7_y,-3>, P7_r texture {P7_t}}
         sphere {< 3,P7_y,-3>, P7_r texture {P7_t}}
         sphere {< 5,P7_y,-3>, P7_r texture {P7_t}}
         sphere {< 7,P7_y,-3>, P7_r texture {P7_t}}
         bounded_by {box {<-7-bp_r,sc_y-bc_r,-3+bp_r>,<7+bp_r,P1_y+bp_r,-3-bp_r>}}
      }
      union {
         sphere {<-7,P5_y,-5>, P5_r texture {P5_t}}
         sphere {<-5,P6_y,-5>, P6_r texture {P6_t}}
         sphere {<-3,P5_y,-5>, P5_r texture {P5_t}}
         sphere {<-1,P6_y,-5>, P6_r texture {P6_t}}
         sphere {< 1,P5_y,-5>, P5_r texture {P5_t}}
         sphere {< 3,P6_y,-5>, P6_r texture {P6_t}}
         sphere {< 5,P5_y,-5>, P5_r texture {P5_t}}
         sphere {< 7,P6_y,-5>, P6_r texture {P6_t}}
         bounded_by {box {<-7-bp_r,sc_y-bc_r,-5+bp_r>,<7+bp_r,P1_y+bp_r,-5-bp_r>}}
      }
      union {
         sphere {<-7,P7_y,-7>, P7_r texture {P7_t}}
         sphere {<-5,P7_y,-7>, P7_r texture {P7_t}}
         sphere {<-3,P7_y,-7>, P7_r texture {P7_t}}
         sphere {<-1,P7_y,-7>, P7_r texture {P7_t}}
         sphere {< 1,P7_y,-7>, P7_r texture {P7_t}}
         sphere {< 3,P7_y,-7>, P7_r texture {P7_t}}
         sphere {< 5,P7_y,-7>, P7_r texture {P7_t}}
         sphere {< 7,P7_y,-7>, P7_r texture {P7_t}}
         bounded_by {box {<-7-bp_r,sc_y-bc_r,-7+bp_r>,<7+bp_r,P1_y+bp_r,-7-bp_r>}}
      }
   }
   rotate <-70,0,0>
}

// --- END ---
