/*|
 *|   PNGLOG1.POV -- scene file for POV-Ray 2.2
 *|   Copyright (c) 1995 by Oliver Fromme -- All Rights Reserved
 *|
 *|   Oliver Fromme, Leibnizstr. 18-61, 38678 Clausthal, Germany
 *|   Internet/Usenet email:  fromme@rz.tu-clausthal.de
 *|   WWW:  http://www.rz.tu-clausthal.de/~inof/Welcome.html
 *|
 *|   May be used freely without charge for any purpose.
 *|   This copyright notice may not be removed or modified.
 *|
 */

/*
 *   Rendering time (POV-Ray 2.2.ibmicb):
 *      Pentium-90   1280x960   0:23:18
 */

#version 2.2

#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"

background {color White}

camera {
   location <0, 2, -16>
   look_at  <0, 0, -9.9>
}

light_source {<-15, 15, -15> color rgb <1,0,0>}
light_source {<  0, 15, -15> color rgb <1,1,1>}
light_source {< 15, 15, -15> color rgb <0,1,0>}

#declare PNG_Marble =
   texture {
      pigment {
         agate
         agate_turb 5
         color_map {
            [0.00 color Gray90]
            [0.80 color Gray90]
            [0.90 color Gray70]
            [1.00 color Gray70]
         }
         translate <20, 20, 20>
      }
   }
   texture {
      pigment {
         agate
         agate_turb 5
         color_map {
            [0.00 color Gray90 filter 1]
            [0.75 color Gray90 filter 1]
            [0.85 color Gray70]
            [0.95 color Gray70]
            [1.00 color Gray20]
         }
         translate <10, 10, 10>
      }
   }
   texture {
      pigment {
         agate
         agate_turb 5
         color_map {
            [0.00 color Gray90 filter 1]
            [0.95 color Gray90 filter 1]
            [0.95 color Gray90]
            [1.00 color Gray20]
         }
      }
   }

// These are the deltas of the bar lengths
// (e.g. the bar of pass 1 is 1.75 units longer than the bar of pass 2).

#declare pass1_h = 1.75
#declare pass2_h = 1.50
#declare pass3_h = 1.25
#declare pass4_h = 1.00
#declare pass5_h = 0.75
#declare pass6_h = 0.50
#declare pass7_h = 0.25

#declare bottom  = 0.0

// The y coordinates of the top of the bars.

#declare pass7_y = bottom  + pass7_h
#declare pass6_y = pass7_y + pass6_h
#declare pass5_y = pass6_y + pass5_h
#declare pass4_y = pass5_y + pass4_h
#declare pass3_y = pass4_y + pass3_h
#declare pass2_y = pass3_y + pass2_h
#declare pass1_y = pass2_y + pass1_h

#declare PNG_Logo =
   union {
      // pass 1:
      box {<0,bottom,0>,<1,pass1_y,1>}
      // pass 2:
      box {<0,bottom,4>,<1,pass2_y,5>}
      // pass 3:
      box {<4,bottom,0>,<5,pass3_y,1>}
      box {<4,bottom,4>,<5,pass3_y,5>}
      // pass 4:
      box {<0,bottom,2>,<1,pass4_y,3>}
      box {<0,bottom,6>,<1,pass4_y,7>}
      box {<4,bottom,2>,<5,pass4_y,3>}
      box {<4,bottom,6>,<5,pass4_y,7>}
      // pass 5:
      box {<2,bottom,0>,<3,pass5_y,1>}
      box {<2,bottom,4>,<3,pass5_y,5>}
      box {<6,bottom,0>,<7,pass5_y,1>}
      box {<6,bottom,4>,<7,pass5_y,5>}
      box {<2,bottom,2>,<3,pass5_y,3>}
      box {<2,bottom,6>,<3,pass5_y,7>}
      box {<6,bottom,2>,<7,pass5_y,3>}
      box {<6,bottom,6>,<7,pass5_y,7>}
      // pass 6:
      box {<0,bottom,1>,<1,pass6_y,2>}
      box {<0,bottom,5>,<1,pass6_y,6>}
      box {<4,bottom,1>,<5,pass6_y,2>}
      box {<4,bottom,5>,<5,pass6_y,6>}
      box {<0,bottom,3>,<1,pass6_y,4>}
      box {<0,bottom,7>,<1,pass6_y,8>}
      box {<4,bottom,3>,<5,pass6_y,4>}
      box {<4,bottom,7>,<5,pass6_y,8>}
      box {<2,bottom,1>,<3,pass6_y,2>}
      box {<2,bottom,5>,<3,pass6_y,6>}
      box {<6,bottom,1>,<7,pass6_y,2>}
      box {<6,bottom,5>,<7,pass6_y,6>}
      box {<2,bottom,3>,<3,pass6_y,4>}
      box {<2,bottom,7>,<3,pass6_y,8>}
      box {<6,bottom,3>,<7,pass6_y,4>}
      box {<6,bottom,7>,<7,pass6_y,8>}
      // pass 7:
      box {<7,bottom,0>,<8,pass7_y,8>}
      box {<5,bottom,0>,<6,pass7_y,8>}
      box {<3,bottom,0>,<4,pass7_y,8>}
      box {<1,bottom,0>,<2,pass7_y,8>}
   }

object {
   PNG_Logo
   texture {
      PNG_Marble
      finish {
         specular 0.7
         reflection 0.05
         ambient 0.25
      }
      scale 3
   }
   rotate 119.25*y
   translate -3*y -0.95*x
}

// --- END ---
