/*|
 *|   PNGLOG6.POV -- scene file for POV-Ray 2.2
 *|   Copyright (c) 1995 by Oliver Fromme -- All Rights Reserved
 *|
 *|   Oliver Fromme, Leibnizstr. 18-61, 38678 Clausthal, Germany
 *|   Internet/Usenet email:  fromme@rz.tu-clausthal.de
 *|   WWW:  http://www.rz.tu-clausthal.de/~inof/Welcome.html
 *|
 *|   May be used freely without charge for any purpose.
 *|   This copyright notice may not be removed or modified.
 *|
 */

/*
 *   Rendering time (FT-POV-Ray [FTPOV 2.1] 2.2.ibmgcc):
 *      Pentium-100   4096x2730   5h:14m:29s
 *
 *   WARNING:  This scene is not rendered correctly by the POV version
 *             that I have (POV-Ray 2.2.ibmicb).  Use FTPOV instead.
 */

/*
 *   For printing on an Agfa QCR-Z slide recorder, render it at
 *   width 2048 and height 1365 (2k resolution).  You can also
 *   use the 4k resolution of the Agfa (4096 x 2730), but it isn't
 *   much of a difference when transfered to a T-shirt (but takes
 *   four times longer to print).
 *
 *   However, it might be a good idea to render it at that high
 *   resolution and then scale it down by half, using interpolation.
 *   This has a nice antialiasing effect, and it's actually faster
 *   and better looking than POV's built-in antialiasing.
 */

#version 2.2

#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"

background {color White}

camera {
   up <0, 1, 0>
   right <1.5, 0, 0> // aspect ratio 3:2 for slides!
   location <0, 2, -16>
   look_at  <0, 0, -9.9>
}

light_source {<-15, 15, -15> color rgb <1,0,0>}
light_source {<  0, 15, -15> color rgb <1,1,1>}
light_source {< 15, 15, -15> color rgb <0,1,0>}

#declare PNG_Marble =
   texture {
      pigment {
         agate
         agate_turb 5
         color_map {
            [0.00 color Gray90]
            [0.80 color Gray90]
            [0.90 color Gray70]
            [1.00 color Gray70]
         }
         translate <20, 20, 20>
      }
   }
   texture {
      pigment {
         agate
         agate_turb 5
         color_map {
            [0.00 color Gray90 filter 1]
            [0.75 color Gray90 filter 1]
            [0.85 color Gray70]
            [0.95 color Gray70]
            [1.00 color Gray20]
         }
         translate <10, 10, 10>
      }
   }
   texture {
      pigment {
         agate
         agate_turb 5
         color_map {
            [0.00 color Gray90 filter 1]
            [0.95 color Gray90 filter 1]
            [0.95 color Gray90]
            [1.00 color Gray20]
         }
      }
   }

// These are the deltas of the bar lengths
// (e.g. the bar of pass 1 is 1.75 units longer than the bar of pass 2).

#declare pass1_h = 1.75
#declare pass2_h = 1.50
#declare pass3_h = 1.25
#declare pass4_h = 1.00
#declare pass5_h = 0.75
#declare pass6_h = 0.50
#declare pass7_h = 0.25

#declare bottom  = 0.0

// The y coordinates of the top of the bars.

#declare pass7_y = bottom  + pass7_h
#declare pass6_y = pass7_y + pass6_h
#declare pass5_y = pass6_y + pass5_h
#declare pass4_y = pass5_y + pass4_h
#declare pass3_y = pass4_y + pass3_h
#declare pass2_y = pass3_y + pass2_h
#declare pass1_y = pass2_y + pass1_h

// Half of the space between the bars:

#declare spc = 0.1

// Pass 7 row (occurs 4 times):

#declare Pass7 =
   union {
      box {<0+spc,bottom,0+spc>,<1-spc,pass7_y,1-spc>}
      box {<0+spc,bottom,1+spc>,<1-spc,pass7_y,2-spc>}
      box {<0+spc,bottom,2+spc>,<1-spc,pass7_y,3-spc>}
      box {<0+spc,bottom,3+spc>,<1-spc,pass7_y,4-spc>}
      box {<0+spc,bottom,4+spc>,<1-spc,pass7_y,5-spc>}
      box {<0+spc,bottom,5+spc>,<1-spc,pass7_y,6-spc>}
      box {<0+spc,bottom,6+spc>,<1-spc,pass7_y,7-spc>}
      box {<0+spc,bottom,7+spc>,<1-spc,pass7_y,8-spc>}
   }

#declare PNG_Logo =
   union {
      // pass 1:
      box {<0+spc,bottom,0+spc>,<1-spc,pass1_y,1-spc>}
      // pass 2:
      box {<0+spc,bottom,4+spc>,<1-spc,pass2_y,5-spc>}
      // pass 3:
      box {<4+spc,bottom,0+spc>,<5-spc,pass3_y,1-spc>}
      box {<4+spc,bottom,4+spc>,<5-spc,pass3_y,5-spc>}
      // pass 4:
      box {<0+spc,bottom,2+spc>,<1-spc,pass4_y,3-spc>}
      box {<0+spc,bottom,6+spc>,<1-spc,pass4_y,7-spc>}
      box {<4+spc,bottom,2+spc>,<5-spc,pass4_y,3-spc>}
      box {<4+spc,bottom,6+spc>,<5-spc,pass4_y,7-spc>}
      // pass 5:
      box {<2+spc,bottom,0+spc>,<3-spc,pass5_y,1-spc>}
      box {<2+spc,bottom,4+spc>,<3-spc,pass5_y,5-spc>}
      box {<6+spc,bottom,0+spc>,<7-spc,pass5_y,1-spc>}
      box {<6+spc,bottom,4+spc>,<7-spc,pass5_y,5-spc>}
      box {<2+spc,bottom,2+spc>,<3-spc,pass5_y,3-spc>}
      box {<2+spc,bottom,6+spc>,<3-spc,pass5_y,7-spc>}
      box {<6+spc,bottom,2+spc>,<7-spc,pass5_y,3-spc>}
      box {<6+spc,bottom,6+spc>,<7-spc,pass5_y,7-spc>}
      // pass 6:
      box {<0+spc,bottom,1+spc>,<1-spc,pass6_y,2-spc>}
      box {<0+spc,bottom,5+spc>,<1-spc,pass6_y,6-spc>}
      box {<4+spc,bottom,1+spc>,<5-spc,pass6_y,2-spc>}
      box {<4+spc,bottom,5+spc>,<5-spc,pass6_y,6-spc>}
      box {<0+spc,bottom,3+spc>,<1-spc,pass6_y,4-spc>}
      box {<0+spc,bottom,7+spc>,<1-spc,pass6_y,8-spc>}
      box {<4+spc,bottom,3+spc>,<5-spc,pass6_y,4-spc>}
      box {<4+spc,bottom,7+spc>,<5-spc,pass6_y,8-spc>}
      box {<2+spc,bottom,1+spc>,<3-spc,pass6_y,2-spc>}
      box {<2+spc,bottom,5+spc>,<3-spc,pass6_y,6-spc>}
      box {<6+spc,bottom,1+spc>,<7-spc,pass6_y,2-spc>}
      box {<6+spc,bottom,5+spc>,<7-spc,pass6_y,6-spc>}
      box {<2+spc,bottom,3+spc>,<3-spc,pass6_y,4-spc>}
      box {<2+spc,bottom,7+spc>,<3-spc,pass6_y,8-spc>}
      box {<6+spc,bottom,3+spc>,<7-spc,pass6_y,4-spc>}
      box {<6+spc,bottom,7+spc>,<7-spc,pass6_y,8-spc>}
      // pass 7:
      object {Pass7 translate <7,0,0>}
      object {Pass7 translate <5,0,0>}
      object {Pass7 translate <3,0,0>}
      object {Pass7 translate <1,0,0>}
   }

object {
   PNG_Logo
   texture {
      PNG_Marble
      finish {
         specular 0.7
         reflection 0.05
         ambient 0.25
      }
      scale 3
   }
   rotate 119.25*y
   translate <-0.95, -3, 0>
}

object {
   plane {y, 0}
   texture {
      pigment {
         image_map {
            gif "PNGBACK.GIF"
            map_type 0
            interpolate 2
            filter 255, 1.0
         }
         translate <0.1, -1.00, 0>
         rotate 90*x
         scale 10
      }
   }
   texture {
      pigment {
         gradient z
         color_map {
            [0.0 color White filter 1.0]
            [1.0 color White filter 0.0]
         }
         scale 30
         translate <0, 0, -8>
      }
      finish {
         diffuse 0.0
         ambient 1.0
      }
   }
   rotate -25*x
   translate <0, -1.0, 0>
}

object {
   plane {-z, 0}
   texture {
      pigment {
         image_map {
            gif "PNGHEAD.GIF"
            once
            map_type 0
            interpolate 2
            filter 0, 0.0
            filter 255, 1.0
         }
         translate <-0.5, -0.5, 0>
         scale <17.4, 1, 1>
         scale 1.0
      }
   }
   translate <0, 3, -3>
}

// --- END ---
