/* mod_gen Version 1                                                     */
/* Module Name: "LBF extract" (Input) (Subroutine)                       */
/* Author: Jeff Wang,NCSC,248-9242                                       */
/* Date Created: Thu Jun 24 10:41:36 1993                                */
/*                                                                       */
/* This file is automatically generated by the Module Generator (mod_gen)*/
/* Please do not modify or move the contents of this comment block as    */
/* mod_gen needs it in order to read module sources back in.             */
/*                                                                       */
/* End of Module Description Comments                                    */

#include <stdio.h>
#include <math.h>
#include <avs/field.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/geom.h>
#include "draw_usmap.h"
 
/* ---. START OF USER-SUPPLIED CODE SECTION #1 (INCLUDE FILES, GLOBAL VARIABLES)*/

#define   RECLENGTH            255 
#define   NUMBEROFFIELD        18
#define   MAXFIELD             80

typedef char FIPSstring[6];
typedef char PODstring[6];
typedef char SICstring[5];
typedef char ASCstring[11];

typedef struct  {
int begin_col;
int end_col;
char *type;
} data_format;

typedef struct  {
char FIPS_code[5];         /* FIPS state/county code */
char SIC_code[4];          /* Standard Industrial Classification Code */
char ASC_code[10];         /* Area Source Category */
int begin_date;            /* Beginning period interval date/time;in YYMMDDHH */
int end_date;              /* Ending period interval date/time;in YYMMDDHH */
double xloc;                /* Latitude (decimal degrees) or UTM Easting 
                              coordinate (km) to define location of Begin */
double yloc;                /* Longitude (decimal degrees) or UTM Northing 
                              coordinate (km) to define location of Begin */
float xloc_end;            /* Latitude (decimal degrees) or UTM Easting 
                              coordinate (km) to define location of End */
float yloc_end;            /* Longitude (decimal degrees) or UTM Northing 
                              coordinate (km) to define location of End */
int utmzone;               /* UTM zone associated with UTM coordinates 
                              given for a plant (optional if location is 
                              lat/long)  */
int veh_class;             /* Vehicle Class (not used) */
int road_type;             /* Road Type (not used) */
int emis_type;             /* Emission Type (not used) */
float voc_emission;        /* Link Emissions for VOC (tons) */
float nox_emission;        /* Link Emissions for NO (tons) */
float co_emission;         /* Link Emissions for CO (tons) */
float tsp_emission;        /* Link Emissions for TSP (tons) */
float pm10_emission;       /* Link Emissions for PM-10 (tons) */
} LBFrecord;

data_format df[] = {
      1,   5, "A",
      7,  10, "A",
     12,  21, "A",
     23,  30, "I",
     32,  39, "I",
     41,  50, "R",
     51,  60, "R",
     61,  70, "R",
     71,  80, "R",
     82,  83, "I",
     85,  86, "I",
     88,  89, "I",
     91,  92, "I",
     94, 103, "R",
    104, 113, "R",
    114, 123, "R",
    124, 133, "R",
    134, 143, "R" 
};

static char c, selected_file[132];
static char oldfips[5], oldpod[5], oldsic[4], oldasc[10];
static char selected_fips[5], selected_pod[5], selected_sic[4],
            selected_asc[10];
static int viewsome, runview, viewvoc, viewnox, viewco;

/* <---- END OF USER-SUPPLIED CODE SECTION #1                            */
 
/* *****************************************/
/*  Module Description                     */
/* *****************************************/
int LBF_extract_desc()
{

	int in_port, out_port, param;
	extern int LBF_extract_compute();

	AVSset_module_name("LBF extract", MODULE_DATA);

	/* Input Port Specifications               */
	in_port = AVScreate_input_port("in_data", "string", OPTIONAL);

	/* Output Port Specifications              */
        out_port = AVScreate_output_port("outfield",
                "field 1D 6-space 1-vector irregular float");
        out_port = AVScreate_output_port("outsp",
                "field 1D 3-space 1-vector irregular float");
        out_port = AVScreate_output_port("outep",
                "field 1D 3-space 1-vector irregular float");

	/* Parameter Specifications                */
	param = AVSadd_parameter("Select LBF File", "string", " ", " ", ":");
	AVSconnect_widget(param, "browser");
	param = AVSadd_parameter("Select County By FIPS", "choice", " ", 
                " ", "\n");
	AVSconnect_widget(param, "choice_browser");
        param = AVSadd_parameter("Plot By ASC Code", "choice", " ",
                " ", "\n");
        AVSconnect_widget(param, "choice_browser");
        param = AVSadd_parameter("View VOC Data", "oneshot", 0, 0, 1);
        AVSconnect_widget(param, "oneshot");
        param = AVSadd_parameter("View NOX Data", "oneshot", 0, 0, 1);
        AVSconnect_widget(param, "oneshot");
        param = AVSadd_parameter("View CO Data", "oneshot", 0, 0, 1);
        AVSconnect_widget(param, "oneshot");
        param = AVSadd_parameter("Auto View", "boolean", 0, 0, 1);
        AVSconnect_widget(param, "toggle");
        param = AVSadd_parameter("Print Records", "oneshot", 0, 0, 1);
        AVSconnect_widget(param, "oneshot");
        param = AVSadd_parameter("map utm zone", "integer", 0, 0, 100000);
        AVSconnect_widget(param, "typein_integer");
        param = AVSadd_parameter("Coordinate Type", "choice",
                "UTM Coodinate Type", "UTM Coodinate Type:Lat/Lon Type", ":");
        AVSconnect_widget(param, "radio_buttons");
        AVSadd_parameter_prop(param, "width", "integer", 4);

	AVSset_compute_proc(LBF_extract_compute);
/* ---. START OF USER-SUPPLIED CODE SECTION #2 (ADDITIONAL SPECIFICATION INFO)*/
/* <---- END OF USER-SUPPLIED CODE SECTION #2                            */
	return(1);
}
 
/* *****************************************/
/* Module Compute Routine                  */
/* *****************************************/
int LBF_extract_compute( 
in_data, 
outfield,
outsp,
outep,
Select_LBF_File,
Select_County_By_FIPS,
Plot_By_ASC_Code,
View_VOC_Data,
View_NOX_Data,
View_CO_Data,
Auto_View,
Print_Records,
map_utm_zone,
Coordinate_Type
)
	char *in_data;
        AVSfield_float **outfield;
        AVSfield_float **outsp;
        AVSfield_float **outep;
	char *Select_LBF_File;
        char *Select_County_By_FIPS;
        char *Plot_By_ASC_Code;
        int View_VOC_Data;
        int View_NOX_Data;
        int View_CO_Data;
        int Auto_View;
        int Print_Records;
        int map_utm_zone;
        char *Coordinate_Type;
{
/*  THIS IS A 'HINTS' AREA - YOU MAY CUT AND PASTE AT WILL FROM IT       */
static int index, i, j, jj, count, current_field;
static int ichoice, utmornot=1;
static int view_all, print_all, found, pass, update;
static int fipscount, podcount, siccount, asccount;
char *tmp1, *tmp2, *tmp3, *tmp4;
LBFrecord     *lbf;
FIPSstring *tmpfips, minfips;
PODstring  *tmppod, minpod;
SICstring  *tmpsic;
ASCstring  *tmpasc, minasc;
static float tempx, tempy, tempz, tempx_end, tempy_end, tempz_end; 

if (AVSparameter_changed("Coordinate Type"))
{
   ichoice = AVSchoice_number("Coordinate Type", Coordinate_Type);
   switch (ichoice)
   {
      case 1:
            utmornot = 1;
            break;
      case 2:
            utmornot = 0;
            break;
   }
}

if ((tmp1 = (char *)malloc(RECLENGTH*sizeof(char))) == NULL)
{
   fprintf(stderr, "No enough space for tmp1!!\n");
}

if ((tmp2 = (char *)malloc(RECLENGTH*sizeof(char))) == NULL)
{
   fprintf(stderr, "No enough space for tmp2!!\n");
}

if ((tmp4 = (char *)malloc(RECLENGTH*sizeof(char))) == NULL)
{
   fprintf(stderr, "No enough space for tmp4!!\n");
}

if ((tmpfips = (FIPSstring *)calloc(500, sizeof(FIPSstring)))==NULL)
{
   fprintf(stderr, "No enough space for tmpfips!!\n");
}

if ((tmpasc = (ASCstring *)calloc(5000, sizeof(ASCstring)))==NULL)
{
   fprintf(stderr, "No enough space for tmpasc!!\n");
}

/* THIS IS THE END OF THE 'HINTS' AREA. ADD YOUR OWN CODE BETWEEN THE    */
/* FOLLOWING COMMENTS. THE CODE YOU SUPPLY WILL NOT BE OVERWRITTEN.      */
 
/* ---. START OF USER-SUPPLIED CODE SECTION #3 (COMPUTE ROUTINE BODY)   */
if (AVSparameter_changed("Select LBF File"))
{
   FILE *lbffile, *fipsfile;
   FILE *podfile, *sicfile, *ascfile;
   char *podstr, *liststr, *sicstr, *ascstr;
 
   sprintf(selected_fips, " \0");
   AVSmodify_parameter("Select County By FIPS", AVS_VALUE, "",
                       Select_County_By_FIPS, "\n");
   sprintf(selected_asc, " \0");
   AVSmodify_parameter("Plot By ASC Code", AVS_VALUE, "",
                       Plot_By_ASC_Code, "\n");
   sprintf(selected_file, "%s\0", Select_LBF_File);
   fipsfile = fopen("lbffips.txt","w");
   sprintf(oldfips, " ");
   podfile = fopen("lbfpod.txt","w");
   sprintf(oldpod, " ");
   sicfile = fopen("lbfsic.txt","w");
   sprintf(oldsic, " ");
   ascfile = fopen("lbfasc.txt","w");
   sprintf(oldasc, " ");
   if ((lbffile = fopen(selected_file, "r"))!=NULL)
   {
      index = 0;
      fipscount = 0;
      podcount = 0;
      siccount = 0;
      asccount = 0;
      while (fgets(tmp1, RECLENGTH, lbffile)!= NULL)
      {
         index++;
         sprintf(tmp2, "%s\0", tmp1);
         lbf = (LBFrecord *)malloc(1*sizeof(LBFrecord));
         for (i=0; i<NUMBEROFFIELD; i++)
         {
             current_field = i;
             count = 0;
             tmp3 = (char *)malloc(MAXFIELD*sizeof(char));
             for (j=df[i].begin_col-1; 
                  j<=df[i].end_col-1; j++)
             {
                tmp3[count] = tmp2[j];
                count++;
             }
             tmp3[count] = '\0';
             switch (current_field) {
                case 0:
                      sprintf(lbf->FIPS_code, "%s", tmp3);
                      break;
                case 2:
                      sprintf(lbf->ASC_code, "%s", tmp3);
                      break;
                case 13: 
                      lbf->voc_emission = atof(tmp3);
                      break;
                case 14: 
                      lbf->nox_emission = atof(tmp3);
                      break;
                case 15: 
                      lbf->co_emission = atof(tmp3);
                      break;
             }
             free((char *)tmp3);
         }

         /* For FIPS Code */
         if (fipscount == 0)
         {
            sprintf(tmpfips[fipscount], "%s\0", lbf->FIPS_code);
            fipscount++;
         }

         else if (strcmp(lbf->FIPS_code, oldfips) != NULL)
         {
            found = 0;
            j = 0;
            while (!found && j<fipscount)
            {
               if (strcmp(tmpfips[j], lbf->FIPS_code) == NULL)
               {
                  found = 1;
               }
               j++;
            }
            if (!found)
            {
               strcpy(tmpfips[fipscount], lbf->FIPS_code);
               fipscount++;
            }
         }
         sprintf(oldfips, "%s", lbf->FIPS_code);

         /* For ASC Code */
         if (asccount == 0)
         {
            sprintf(tmpasc[asccount], "%s\0", lbf->ASC_code);
            asccount++;
         }

         else if (strcmp(lbf->ASC_code, oldasc) != NULL)
         {
            found = 0;
            j = 0;
            while (!found && j<asccount)
            {
               if (strcmp(tmpasc[j], lbf->ASC_code) == NULL)
               {
                  found = 1;
               }
               j++;
            }
            if (!found)
            {
               strcpy(tmpasc[asccount], lbf->ASC_code);
               asccount++;
            }
         }
         sprintf(oldasc, "%s", lbf->ASC_code);
         /* free memory for next record */
         free((LBFrecord *)lbf);
      }
   }
   else 
   {
      fprintf(stderr, "Can't open file %s.\n", lbffile);
   }
   fclose(lbffile);

   /* For fips array */
   fipscount = fipscount -1;
   /* Sort the value */
   for (i=0; i<fipscount; i++)
   {
       sprintf(minfips, "%s", tmpfips[i]);
       jj = i;
       found = 0;
       for (j=i+1; j<=fipscount; j++)
       {
           if (strcmp(minfips, tmpfips[j]) > 0)
           {
              sprintf(minfips, "%s", tmpfips[j]);
              jj = j;
              found = 1;
           }
       }
       if (found)
       {
           sprintf(tmpfips[jj], "%s", tmpfips[i]);
           sprintf(tmpfips[i], "%s", minfips);
       }
   }
   /* Write out the data */
   for (j=0; j<=fipscount; j++)
   {
       fprintf(fipsfile, "%s\n", tmpfips[j]);
   }
   fclose(fipsfile);

   fclose(podfile);

   asccount = asccount -1;
   /* Sort the value */
   for (i=0; i<asccount; i++)
   {
       sprintf(minasc, "%s", tmpasc[i]);
       jj = i;
       found = 0;
       for (j=i+1; j<=asccount; j++)
       {
           if (strcmp(minasc, tmpasc[j]) > 0)
           {
              sprintf(minasc, "%s", tmpasc[j]);
              jj = j;
              found = 1;
           }
       }
       if (found)
       {
           sprintf(tmpasc[jj], "%s", tmpasc[i]);
           sprintf(tmpasc[i], "%s", minasc);
       }
   }
   /* Write out the data */
   for (j=0; j<=asccount; j++)
   {
       fprintf(ascfile, "%s\n", tmpasc[j]);
   }
   fclose(ascfile);
   liststr = (char *)list_file_browser("lbffips.txt");
   AVSmodify_parameter("Select County By FIPS", AVS_MINVAL,
                       "", (char *)liststr, "\n");
   ascstr = (char *)list_file_browser("lbfasc.txt");
   AVSmodify_parameter("Plot By ASC Code", AVS_MINVAL,
                       "", (char *)ascstr, "\n");

}

if (AVSparameter_changed("Select County By FIPS"))
{
   FILE *lbffile;
 
   sprintf(selected_fips, "%s\0", Select_County_By_FIPS);
}

if (AVSparameter_changed("Plot By ASC Code"))
{
   sprintf(selected_asc, "%s\0", Plot_By_ASC_Code);
}

if (Print_Records)
{
   FILE *lbffile;

   Print_Records = 0;
   if (strcmp(selected_fips," ") == NULL &&
      strcmp(selected_asc," ") == NULL )
   {
      print_all = 1;
   }
   else
   {
      print_all = 0;
   }
   if ((lbffile = fopen(selected_file, "r"))!=NULL)
   {
      index = 0;
      while (fgets(tmp1, RECLENGTH, lbffile)!= NULL)
      {
         index++;
         sprintf(tmp2, "%s\0", tmp1);
         lbf = (LBFrecord *)malloc(1*sizeof(LBFrecord));
         for (i=0; i<NUMBEROFFIELD; i++)
         {
             current_field = i;
             count = 0;
             tmp3 = (char *)malloc(MAXFIELD*sizeof(char));
             for (j=df[i].begin_col-1; 
                  j<=df[i].end_col-1; j++)
             {
                tmp3[count] = tmp2[j];
                count++;
             }
             tmp3[count] = '\0';
             switch (current_field) {
                case 0:
                      sprintf(lbf->FIPS_code, "%s", tmp3);
                      break;
                case 2:
                      sprintf(lbf->ASC_code, "%s", tmp3);
                      break;
                case 5:
                      lbf->xloc = atof(tmp3);
                      break;
                case 6:
                      lbf->yloc = atof(tmp3);
                      break;
                case 7:
                      lbf->xloc_end = atof(tmp3);
                      break;
                case 8:
                      lbf->yloc_end = atof(tmp3);
                      break;
                case 13: 
                      lbf->voc_emission = atof(tmp3);
                      break;
             }
             free((char *)tmp3);
         }
         if (print_all ||
             /* first logical check */
             (strcmp(selected_fips, lbf->FIPS_code) == NULL  &&
              strcmp(selected_asc," ") == NULL) ||
             (strcmp(selected_fips, " ") == NULL  &&
              strcmp(selected_asc," ") == NULL) ||
             (strcmp(selected_fips, " ") == NULL  &&
              strcmp(selected_asc,lbf->ASC_code) == NULL) ||
             /* second logical check */
             (strcmp(selected_fips, lbf->FIPS_code) == NULL  &&
              strcmp(selected_asc,lbf->ASC_code) == NULL)
            )
         {
            fprintf(stderr, "%s\n", tmp2);
/*
            fprintf(stderr, "Data type: %s\n", lbf->data_type);
            fprintf(stderr, "Projection year: %d\n", lbf->prj_year);
            fprintf(stderr, "Inventory base year: %d\n", lbf->base_year);
            fprintf(stderr, "Emission type: %s\n", lbf->emiss_type);
*/
            fprintf(stderr, "FIPS code: %s\n", lbf->FIPS_code);
            fprintf(stderr, "X location(UTM coord.): %f\n", lbf->xloc);
            fprintf(stderr, "Y location(UTM coord.): %f\n", lbf->yloc);
            fprintf(stderr, "UTM zone: %d\n", lbf->utmzone);
            fprintf(stderr, "Emission: %f(tons)\n", lbf->voc_emission);
            fprintf(stderr, "\nThis is the end of record %d.\n", index);
         }
         free((LBFrecord *)lbf);
      }
   }
   else 
   {
      fprintf(stderr, "Can't open file %s.\n", lbffile);
   }
   fclose(lbffile);
}

runview = 0;
if (View_VOC_Data)
{
   viewvoc = 1;
   viewnox = 0;
   viewco = 0;
   runview = 1;
}

if (View_NOX_Data)
{
   viewvoc = 0;
   viewnox = 1;
   viewco = 0;
   runview = 1;
}

if (View_CO_Data)
{
   viewvoc = 0;
   viewnox = 0;
   viewco = 1;
   runview = 1;
}

viewsome = 0;
if (viewvoc == 1 || viewnox == 1 || viewco == 1)
{
   viewsome =1;
}

if (runview || Auto_View && viewsome)
{
   FILE *lbffile, *objfile;
   int ivert;
   float base, height;
   UTMcoordinate temputm;
   GEScoordinate tempges;
   UTMcoordinate temputm_end;
   GEScoordinate tempges_end;
   static AVSfield_float *tmpfield;
   static AVSfield_float *tmpsp;
   static AVSfield_float *tmpep;
   int dims0[1];

/* Free old field data                                                   */
   if (*outfield) AVSfield_free(*outfield);
   if (*outsp) AVSfield_free(*outsp);
   if (*outep) AVSfield_free(*outep);
 
   if (strcmp(selected_fips," ") == NULL &&
       strcmp(selected_asc," ") == NULL )
   {
      view_all = 1;
      AVSwarning("Please select FIPS or ASC Code!!");
      return(0);
   }
   else
   {
      view_all = 0;
   }

   if ((lbffile = fopen(selected_file, "r"))!=NULL)
   {
      index = 0;
      jj = 0;
      objfile = fopen("tmplink.txt","w");
      while (fgets(tmp1, RECLENGTH, lbffile)!= NULL)
      {
         index++;
         sprintf(tmp2, "%s\0", tmp1);
         lbf = (LBFrecord *)malloc(1*sizeof(LBFrecord));
         for (i=0; i<NUMBEROFFIELD; i++)
         {
             current_field = i;
             count = 0;
             tmp3 = (char *)malloc(MAXFIELD*sizeof(char));
             for (j=df[i].begin_col-1; 
                  j<=df[i].end_col-1; j++)
             {
                tmp3[count] = tmp2[j];
                count++;
             }
             tmp3[count] = '\0';
             switch (current_field) {
                case 0:
                      sprintf(lbf->FIPS_code, "%s", tmp3);
                      break;
                case 2:
                      sprintf(lbf->ASC_code, "%s", tmp3);
                      break;
             }
             free((char *)tmp3);
         }

         if (!view_all && (
             /* first logical check */
             (strcmp(selected_fips, lbf->FIPS_code) == NULL  &&
              strcmp(selected_asc," ") == NULL) ||
             (strcmp(selected_fips, " ") == NULL  &&
              strcmp(selected_asc," ") == NULL) ||
             (strcmp(selected_fips, " ") == NULL  &&
              strcmp(selected_asc,lbf->ASC_code) == NULL) ||
             /* second logical check */
             (strcmp(selected_fips, lbf->FIPS_code) == NULL  &&
              strcmp(selected_asc,lbf->ASC_code) == NULL) 
            ))
         {
            fprintf(objfile,"%s", tmp1);
            jj = jj++;
         }
         free((LBFrecord *)lbf);
      }
    fclose(objfile);

    if (jj < 1) return(0);
    /* Free old temp field data                                */
    if (tmpfield) AVSfield_free(tmpfield);

    /* Allocate space for new field output                        */
    dims0[0] = jj;

    tmpfield = (AVSfield_float *) AVSdata_alloc(
          "field 1D 6-space 1-vector irregular float", dims0);
    if (tmpfield == NULL) {
       AVSerror("Allocation of output field failed.");
       return(0);
    }

    /* Allocate space for new field output                        */
    if (tmpsp) AVSfield_free(tmpsp);
    dims0[0] = jj;

    tmpsp = (AVSfield_float *) AVSdata_alloc(
          "field 1D 3-space 1-vector irregular float", dims0);
    if (tmpsp == NULL) {
       AVSerror("Allocation of output field failed.");
       return(0);
    }

    /* Allocate space for new field output                        */
    if (tmpep) AVSfield_free(tmpep);
    dims0[0] = jj;

    tmpep = (AVSfield_float *) AVSdata_alloc(
          "field 1D 3-space 1-vector irregular float", dims0);
    if (tmpep == NULL) {
       AVSerror("Allocation of output field failed.");
       return(0);
    }
    /* FILL IN THE OUTPUT FIELD  Here!                              */
   if ((objfile = fopen("tmplink.txt", "r"))!=NULL)
   {
      ivert = 0;
      while (fgets(tmp1, RECLENGTH, objfile)!= NULL)
      {
         index++;
         sprintf(tmp2, "%s\0", tmp1);
         lbf = (LBFrecord *)malloc(1*sizeof(LBFrecord));
         for (i=0; i<NUMBEROFFIELD; i++)
         {
             current_field = i;
             count = 0;
             tmp3 = (char *)malloc(MAXFIELD*sizeof(char));
             for (j=df[i].begin_col-1;
                  j<=df[i].end_col-1; j++)
             {
                tmp3[count] = tmp2[j];
                count++;
             }
             tmp3[count] = '\0';
             switch (current_field) {
                case 5:
                      lbf->xloc = atof(tmp3);
                      break;
                case 6:
                      lbf->yloc = atof(tmp3);
                      break;
                case 7:
                      lbf->xloc_end = atof(tmp3);
                      break;
                case 8:
                      lbf->yloc_end = atof(tmp3);
                      break;
                case 9:
                      lbf->utmzone = atoi(tmp3);
                      break;
                case 13:
                      lbf->voc_emission = atof(tmp3);
                      break;
                case 14:
                      lbf->nox_emission = atof(tmp3);
                      break;
                case 15:
                      lbf->co_emission = atof(tmp3);
                      break;
             }
             free((char *)tmp3);
         }

         if (utmornot)
         {
            tempges = map_utm_to_latlon(lbf->xloc/1000.0,
                                  lbf->yloc/1000.0,lbf->utmzone);
         }
         else
         {
            tempges.lat = lbf->xloc;
            tempges.lon = lbf->yloc;
            if (lbf->utmzone <= 30 && tempges.lon >0.0)
                tempges.lon = -tempges.lon;
         }
         temputm = map_latlon_to_utm(tempges.lon, tempges.lat, map_utm_zone);            tempx = temputm.x;
         tempy = temputm.y;
         tempz = 1.0;
         if (utmornot)
         {
            tempges_end = map_utm_to_latlon(lbf->xloc_end/1000.0,
                               lbf->yloc_end/1000.0,lbf->utmzone);
         }
         else
         {
            tempges_end.lat = lbf->xloc_end;
            tempges_end.lon = lbf->yloc_end;
            if (lbf->utmzone <= 30 && tempges_end.lon >0.0)
                tempges_end.lon = -tempges_end.lon;
         }
         temputm_end = map_latlon_to_utm(tempges_end.lon,
                                      tempges_end.lat, map_utm_zone);
         tempx_end = temputm_end.x;
         tempy_end = temputm_end.y;
         tempz_end = 1.0;

         /*set color scheme */
         /*set color scheme */
         if (viewvoc)
         {
            base = lbf->voc_emission;
         }
         else if (viewnox)
         {
            base = lbf->nox_emission;
         }
         else if (viewco)
         {
            base = lbf->co_emission;
         }

         tempz = 1.0;

         /* output the link field */
         tmpfield->points[6*ivert] = tempx;
         tmpfield->points[6*ivert+1] = tempy;
         tmpfield->points[6*ivert+2] = tempz;
         tmpfield->points[6*ivert+3] = tempx_end;
         tmpfield->points[6*ivert+4] = tempy_end;
         tmpfield->points[6*ivert+5] = tempz_end;
         tmpfield->data[ivert] = base;
        
         /* output start point field */
         tmpsp->points[3*ivert] = tempx;
         tmpsp->points[3*ivert+1] = tempy;
         tmpsp->points[3*ivert+2] = tempz;
         tmpsp->data[ivert] = base;
        
         /* output end point field */
         tmpep->points[3*ivert] = tempx_end;
         tmpep->points[3*ivert+1] = tempy_end;
         tmpep->points[3*ivert+2] = tempz_end;
         tmpep->data[ivert] = base;
         ivert++;

         free((LBFrecord *)lbf);
      }
      }
      fclose(objfile);

      /* output field data */
      *outfield = tmpfield;
      *outsp = tmpsp;
      *outep = tmpep;
   }
   else 
   {
      fprintf(stderr, "Can't open file %s.\n", lbffile);
   }
   fclose(lbffile);

   /* Create the GEOM Edit List for outLink                            */
   View_VOC_Data = 0;
   View_NOX_Data = 0;
   View_CO_Data = 0;
}


free((char *)tmp1);
free((char *)tmp2);
free((char *)tmp4);
free((FIPSstring *)tmpfips);
free((ASCstring *)tmpasc);

/* <---- END OF USER-SUPPLIED CODE SECTION #3                            */
	return(1);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*mod_list[])()) = {
	LBF_extract_desc,
};
#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
	AVSinit_from_module_list(mod_list, NMODS);
}
 
/* ---. START OF USER-SUPPLIED CODE SECTION #4 (SUBROUTINES, FUNCTIONS, UTILITY ROUTINES)*/
/* <---- END OF USER-SUPPLIED CODE SECTION #4                            */
