/* mod_gen Version 1                                                     */
/* Module Name: "Geom Reset" (Mapper) (Subroutine)                       */
/* Author: Jeff Wang,NCSC,248-9242                                       */
/*         Adapting Kathy Pearson's method                               */
/* Date Created: Wed Jan  6 11:28:10 1993                                */
/*                                                                       */
/* This file is automatically generated by the Module Generator (mod_gen)*/
/* Please do not modify or move the contents of this comment block as    */
/* mod_gen needs it in order to read module sources back in.             */
/*                                                                       */
/* End of Module Description Comments                                    */

#include <stdio.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/field.h>
 
/* *****************************************/
/*  Module Description                     */
/* *****************************************/
int Geom_Reset_desc()
{

	int in_port, out_port, param, iresult;
	extern int Geom_Reset_compute();

	AVSset_module_name("Reset Geom", MODULE_MAPPER);

        /* Input Port Specifications               */
        in_port = AVScreate_input_port("inimage", "field 2D 4-vector byte",
                OPTIONAL);

	/* Parameter Specifications                */
        param = AVSadd_float_parameter("background red", 0.0, 0.0, 1.0);
        AVSconnect_widget(param,"slider");
 
        param = AVSadd_float_parameter("background green", 0.0, 0.0, 1.0);
        AVSconnect_widget(param,"slider");
 
        param = AVSadd_float_parameter("background blue", 0.0, 0.0, 1.0);
        AVSconnect_widget(param,"slider");
 
        param = AVSadd_float_parameter("shrink factor", .85, 0.5, 1.0);
        AVSconnect_widget(param,"dial");
 
	param = AVSadd_parameter("reset", "oneshot", 1, 0, 1);
	AVSconnect_widget(param, "oneshot");

	AVSset_compute_proc(Geom_Reset_compute);
	return(1);
}
 
/* *****************************************/
/* Module Compute Routine                  */
/* *****************************************/
int Geom_Reset_compute(inimage, red, green, blue, shrink, reset)
AVSfield_char *inimage;
float *red;
float *green;
float *blue;
float *shrink;
int reset;
{

int dims0[2],i,j,k;
char *output;			/* pointer to AVS output buffer */
char *error;			/* pointer to AVS error buffer */
static char cmdstr[1024];	/* string for AVS CLI commands */
static int pass0 = 1;

float camera_size;

#define CMD AVScommand("kernel", cmdstr, &output, &error)  

if (pass0)		 /* don't reset when first instantiated in a network */
	{
	pass0 = 0;
	return(0);
	}
if (
	(AVSparameter_changed("background red")) ||
	(AVSparameter_changed("background green")) ||
	(AVSparameter_changed("background blue")) 
	)
	{
	sprintf(cmdstr, "geom_set_background %g %g %g", 
                *red, *green, *blue); CMD;
	return(1);
	}

/* Cameras operate on a 5 point scale, so a camera size of 5.0 means that
the geometry fills the screen (normalized).  A camera size of 4.0 zooms
in and a camera size of 10.0 zooms out for a 50% reduction. 
Here, allow camera sizes between 5 and 10, or shrink factors between
.5 and 1.0 */

camera_size = 5.0 + (1.0 - *shrink) * 10.0; 

if ((reset) || (AVSparameter_changed("shrink factor")) ||
    (AVSinput_changed("inimage",0)))
	{
	sprintf(cmdstr,
"geom_reset\ngeom_normalize\ngeom_set_camera_params -wsize %g\ngeom_refresh\n",
		camera_size); CMD;
        pass0 = 1;
	return(1);
	}

return(0);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
static int ((*mod_list[])()) = {
	Geom_Reset_desc
};
#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
	AVSinit_from_module_list(mod_list, NMODS);
}

