/****************************************************************************
                          INTERNATIONAL AVS CENTRE
           (This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Centre, University of Manchester, the AVS Consortium and
the individual  submitting the module and files associated with said module
provide absolutely NO WARRANTY OF ANY KIND with respect to this software.  The
entire risk as to the quality and performance of this software is with the
user.  IN NO EVENT WILL The International AVS Centre, University of Manchester,
the AVS Consortium and the individual submitting the module and files
associated with said module BE LIABLE TO ANYONE FOR ANY DAMAGES ARISING FROM
THE USE OF THIS SOFTWARE, INCLUDING, WITHOUT LIMITATION, DAMAGES RESULTING FROM
LOST DATA OR LOST PROFITS, OR ANY SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@iavsc.org.

Please send AVS module bug reports to avs@iavsc.org.

***************************************************************************/
/*------------------------------------------------------------------------------
 *  pic.h:  Bio-Rad PIC file i/o routines.  Based on PIC file information
 *          from Lance Ladic's confocal microscopy web page:
 *          http://www.cs.ubc.ca/spider/ladic/confocal.html
 * 
 *  AUTHOR: Chris Pudney,
 *          Dept. Pharmacology, Univ. of Western Australia, Nedlands, 6907.
 *          cpudney@alphapharm.uwa.edu.au
 *
 *  VERSION: DEC Alpha, OSF/1, cc
 *
 *  STARTED: 27/02/96
 *
 *  UPDATED: 04/03/96
 */


#define PIC_HEADER_LEN	76	/* PIC header size */
#define FILE_ID	12345	/* Correct value for file_id field */


/* PIC header structure.
 */
typedef struct _PICheader
{
	char	name[32];
	void	*notes;
	float	mag;
	unsigned int	nx, ny, nz, ramp1Min, ramp1Max, ramp2Min, ramp2Max,
		byteFormat, n, merged, colour1, colour2, fileID, edited, lens,
		dummy[3];

} PICheader;


/* Globals:
 * Error string
 */
extern char	PICerrStr[128];


/* External prototypes:
 */
int	read_PIC_header(char *, PICheader *);
int	read_PIC_data(char *, PICheader *, unsigned char *);
int	write_PIC_header(char *, PICheader *);
int	write_PIC_data(char *, PICheader *, unsigned char *);
