/****************************************************************************
                          INTERNATIONAL AVS CENTRE
           (This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Centre, University of Manchester, the AVS Consortium and
the individual  submitting the module and files associated with said module
provide absolutely NO WARRANTY OF ANY KIND with respect to this software.  The
entire risk as to the quality and performance of this software is with the
user.  IN NO EVENT WILL The International AVS Centre, University of Manchester,
the AVS Consortium and the individual submitting the module and files
associated with said module BE LIABLE TO ANYONE FOR ANY DAMAGES ARISING FROM
THE USE OF THIS SOFTWARE, INCLUDING, WITHOUT LIMITATION, DAMAGES RESULTING FROM
LOST DATA OR LOST PROFITS, OR ANY SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@iavsc.org.

Please send AVS module bug reports to avs@iavsc.org.

***************************************************************************/
/* mod_gen Version 1                                                     */
/* Module Name: "read BioRad PIC" (Input) (Subroutine)                   */
/* Author: Chris Pudney,1.33a or c,4571,3163027                          */
/* Date Created: Wed Mar 13 12:19:05 1996                                */
/*                                                                       */
/* This file is automatically generated by the Module Generator (mod_gen)*/
/* Please do not modify or move the contents of this comment block as    */
/* mod_gen needs it in order to read module sources back in.             */
/*                                                                       */
/* output 0 "image" field 3D 3-space 1-vector uniform byte               */
/* param 0 "BioRad PIC File" browser "" "" ".PIC.pic"                    */
/* param 1 "XY Pixel Size" dial 1.00000 0.00000 10.0000                  */
/* param 2 "Z Step Size" dial 1.00000 0.00000 10.0000                    */
/* param 3 "Header Information" textblock "" "" ":"                      */
/* End of Module Description Comments                                    */

#include <stdio.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/field.h>
 
/* ----> START OF USER-SUPPLIED CODE SECTION #1 (INCLUDE FILES, GLOBAL VARIABLES)*/
/*------------------------------------------------------------------------------
 *	AUTHOR: Chris Pudney,
 *		Biomedical Confocal Microscopy Research Centre
 *		Dept. Pharmacology, Univ. of Western Australia, Nedlands, 6907.
 *		cpudney@alphapharm.uwa.edu.au
 *
 *	VERSION: DEC Alpha, OSF/1, cc
 *
 *	STARTED: 27/02/96
 *
 *	UPDATED: 12/03/96
 */

#include "pic.h"

/* <---- END OF USER-SUPPLIED CODE SECTION #1                            */
 
/* *****************************************/
/*  Module Description                     */
/* *****************************************/
int read_BioRad_PIC_desc()
{

	int in_port, out_port, param, iresult;
	extern int read_BioRad_PIC_compute();

	AVSset_module_name("read BioRad PIC", MODULE_DATA);

	/* Output Port Specifications              */
	out_port = AVScreate_output_port("image", 
		"field 3D 3-space 1-vector uniform byte");

	/* Parameter Specifications                */
	param = AVSadd_parameter("BioRad PIC File", "string", "", "", 
		".PIC.pic");
	AVSconnect_widget(param, "browser");
	param = AVSadd_float_parameter("XY Pixel Size", 1.00000, 0.00000, 
		10.0000);
	AVSconnect_widget(param, "dial");
	param = AVSadd_float_parameter("Z Step Size", 1.00000, 0.00000, 
		10.0000);
	AVSconnect_widget(param, "dial");
	param = AVSadd_parameter("Header Information", "string_block", "", "", 
		":");
	AVSconnect_widget(param, "textblock");

	AVSset_compute_proc(read_BioRad_PIC_compute);
/* ----> START OF USER-SUPPLIED CODE SECTION #2 (ADDITIONAL SPECIFICATION INFO)*/
	AVSadd_parameter_prop(param, "width", "integer", 4);
	AVSadd_parameter_prop(param, "height", "integer", 8);

/* <---- END OF USER-SUPPLIED CODE SECTION #2                            */
	return(1);
}
 
/* *****************************************/
/* Module Compute Routine                  */
/* *****************************************/
int read_BioRad_PIC_compute( image, BioRad_PIC_File, XY_Pixel_Size, 
Z_Step_Size, Header_Information)
	AVSfield_char **image;
	char *BioRad_PIC_File;
	float *XY_Pixel_Size;
	float *Z_Step_Size;
	char *Header_Information;
{

/* ----> START OF USER-SUPPLIED CODE SECTION #3 (COMPUTE ROUTINE BODY)   */

	float	min[3], max[3], *points;
	static PICheader	hdr;
	static char	text[400];


	if (!BioRad_PIC_File || !BioRad_PIC_File[0])
	{
		return 0;

	} /* end if (!filename ... */


	/* Check if a new file is to be read */
	if (AVSparameter_changed("BioRad PIC File"))
	{
		/* Free previous image */
		if (*image)
		{
			AVSfield_free((AVSfield *)*image);

		} /* end if (*image) */


		/* Read header info */
		if (!read_PIC_header(BioRad_PIC_File, &hdr))
		{
			AVSmodify_parameter("Header Information", AVS_VALUE, PICerrStr,
				NULL, NULL);
			AVSwarning(PICerrStr);
			return 0;

		}  /* end if (!read_PIC_header ... */

		else
		{
			int	dims[3];


			/* Generate header info text block */
			(void)sprintf(text,
				"Header Information\n================\nName: %s\nDimensions: %ux%ux%u\nLens: x%u\nMagnification: %f\nLUT #1 Ramp Min, Max: %u, %u\nLUT #2 Ramp Min, Max: %u, %u\nLUT Colours #1, #2: %u, %u\n\n%s, %s, %s,\n%s.", 
				hdr.name, hdr.nx, hdr.ny, hdr.nz, hdr.lens, hdr.mag,
				hdr.ramp1Min, hdr.ramp1Max, hdr.ramp2Min, hdr.ramp2Max,
				hdr.colour1, hdr.colour2,
				hdr.notes ? "Has notes" : "No notes",
				hdr.byteFormat ? "byte values" : "16-bit values",
				hdr.merged ? "merged" : "not merged",
				hdr.edited ? "editted" : "not editted");
			AVSmodify_parameter("Header Information", AVS_VALUE, text, NULL, 
				NULL);

			/* Allocate field */
			dims[0] = hdr.nx;
			dims[1] = hdr.ny;
			dims[2] = hdr.nz;
			*image = (AVSfield_char *)AVSdata_alloc(
				"field 3D 3-space 1-vector uniform byte", dims);
			if (!*image)
			{
				AVSerror("Allocation of output image failed.");
				return 0;

			} /* end if (*image) */

			/* Read data into field. */
			if (!read_PIC_data(BioRad_PIC_File, &hdr,
				(unsigned char *)((AVSfield_char *)*image)->data))
			{
				AVSfield_free((AVSfield *)*image);
				AVSmodify_parameter("Header Information", AVS_VALUE, PICerrStr,
					NULL, NULL);
				AVSwarning(PICerrStr);
				return 0;

			} /* end if (!read_PIC_data) */

			/* Set min/max */
			AVSfield_reset_minmax((AVSfield *)*image);

		} /* end else */
	} /* end if (AVSparameter_changed ... */

	/* Set min/max extents */
	points = (*image)->points;
	points[0] = points[2] = points[4] = min[0] = min[1] = min[2] = 0.;
	points[1] = max[0] = (hdr.nx - 1) * (*XY_Pixel_Size);
	points[3] = max[1] = (hdr.ny - 1) * (*XY_Pixel_Size);
	points[5] = max[2] = (hdr.nz - 1) * (*Z_Step_Size);
	AVSfield_set_extent((AVSfield *)*image, min, max);

/* <---- END OF USER-SUPPLIED CODE SECTION #3                            */
	return(1);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
static int ((*mod_list[])()) = {
	read_BioRad_PIC_desc
};
#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
	AVSinit_from_module_list(mod_list, NMODS);
}
 
/* ----> START OF USER-SUPPLIED CODE SECTION #4 (SUBROUTINES, FUNCTIONS, UTILITY ROUTINES)*/
/* <---- END OF USER-SUPPLIED CODE SECTION #4                            */
